/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.PaymentIntentAmountDetailsLineItemCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentIntentAmountDetailsLineItemListParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentAmountDetailsLineItem
extends ApiResource
implements HasId {
    @SerializedName(value="discount_amount")
    Long discountAmount;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="product_code")
    String productCode;
    @SerializedName(value="product_name")
    String productName;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="tax")
    Tax tax;
    @SerializedName(value="unit_cost")
    Long unitCost;
    @SerializedName(value="unit_of_measure")
    String unitOfMeasure;

    public static PaymentIntentAmountDetailsLineItemCollection list(String intent, Map<String, Object> params) throws StripeException {
        return PaymentIntentAmountDetailsLineItem.list(intent, params, (RequestOptions)null);
    }

    public static PaymentIntentAmountDetailsLineItemCollection list(String intent, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/amount_details_line_items", ApiResource.urlEncodeId(intent));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentIntentAmountDetailsLineItemCollection)PaymentIntentAmountDetailsLineItem.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntentAmountDetailsLineItemCollection.class));
    }

    public static PaymentIntentAmountDetailsLineItemCollection list(String intent, PaymentIntentAmountDetailsLineItemListParams params) throws StripeException {
        return PaymentIntentAmountDetailsLineItem.list(intent, params, (RequestOptions)null);
    }

    public static PaymentIntentAmountDetailsLineItemCollection list(String intent, PaymentIntentAmountDetailsLineItemListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_intents/%s/amount_details_line_items", ApiResource.urlEncodeId(intent));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentIntentAmountDetailsLineItemCollection)PaymentIntentAmountDetailsLineItem.getGlobalResponseGetter().request(request, (Type)((Object)PaymentIntentAmountDetailsLineItemCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.paymentMethodOptions, responseGetter);
        this.trySetResponseGetter(this.tax, responseGetter);
    }

    @Generated
    public Long getDiscountAmount() {
        return this.discountAmount;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public String getProductCode() {
        return this.productCode;
    }

    @Generated
    public String getProductName() {
        return this.productName;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public Tax getTax() {
        return this.tax;
    }

    @Generated
    public Long getUnitCost() {
        return this.unitCost;
    }

    @Generated
    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    @Generated
    public void setDiscountAmount(Long discountAmount) {
        this.discountAmount = discountAmount;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
        this.paymentMethodOptions = paymentMethodOptions;
    }

    @Generated
    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    @Generated
    public void setProductName(String productName) {
        this.productName = productName;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setTax(Tax tax) {
        this.tax = tax;
    }

    @Generated
    public void setUnitCost(Long unitCost) {
        this.unitCost = unitCost;
    }

    @Generated
    public void setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentIntentAmountDetailsLineItem)) {
            return false;
        }
        PaymentIntentAmountDetailsLineItem other = (PaymentIntentAmountDetailsLineItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$discountAmount = this.getDiscountAmount();
        Long other$discountAmount = other.getDiscountAmount();
        if (this$discountAmount == null ? other$discountAmount != null : !((Object)this$discountAmount).equals(other$discountAmount)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        Long this$unitCost = this.getUnitCost();
        Long other$unitCost = other.getUnitCost();
        if (this$unitCost == null ? other$unitCost != null : !((Object)this$unitCost).equals(other$unitCost)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        String this$productCode = this.getProductCode();
        String other$productCode = other.getProductCode();
        if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
            return false;
        }
        String this$productName = this.getProductName();
        String other$productName = other.getProductName();
        if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
            return false;
        }
        Tax this$tax = this.getTax();
        Tax other$tax = other.getTax();
        if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
            return false;
        }
        String this$unitOfMeasure = this.getUnitOfMeasure();
        String other$unitOfMeasure = other.getUnitOfMeasure();
        return !(this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentIntentAmountDetailsLineItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $discountAmount = this.getDiscountAmount();
        result = result * 59 + ($discountAmount == null ? 43 : ((Object)$discountAmount).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        Long $unitCost = this.getUnitCost();
        result = result * 59 + ($unitCost == null ? 43 : ((Object)$unitCost).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        String $productCode = this.getProductCode();
        result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
        String $productName = this.getProductName();
        result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
        Tax $tax = this.getTax();
        result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
        String $unitOfMeasure = this.getUnitOfMeasure();
        result = result * 59 + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class PaymentMethodOptions
    extends StripeObject {
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="card_present")
        CardPresent cardPresent;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="paypal")
        Paypal paypal;

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public CardPresent getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setCardPresent(CardPresent cardPresent) {
            this.cardPresent = cardPresent;
        }

        @Generated
        public void setKlarna(Klarna klarna) {
            this.klarna = klarna;
        }

        @Generated
        public void setPaypal(Paypal paypal) {
            this.paypal = paypal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            CardPresent this$cardPresent = this.getCardPresent();
            CardPresent other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            return !(this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            CardPresent $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            return result;
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="commodity_code")
            String commodityCode;

            @Generated
            public String getCommodityCode() {
                return this.commodityCode;
            }

            @Generated
            public void setCommodityCode(String commodityCode) {
                this.commodityCode = commodityCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$commodityCode = this.getCommodityCode();
                String other$commodityCode = other.getCommodityCode();
                return !(this$commodityCode == null ? other$commodityCode != null : !this$commodityCode.equals(other$commodityCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $commodityCode = this.getCommodityCode();
                result = result * 59 + ($commodityCode == null ? 43 : $commodityCode.hashCode());
                return result;
            }
        }

        public static class CardPresent
        extends StripeObject {
            @SerializedName(value="commodity_code")
            String commodityCode;

            @Generated
            public String getCommodityCode() {
                return this.commodityCode;
            }

            @Generated
            public void setCommodityCode(String commodityCode) {
                this.commodityCode = commodityCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CardPresent)) {
                    return false;
                }
                CardPresent other = (CardPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$commodityCode = this.getCommodityCode();
                String other$commodityCode = other.getCommodityCode();
                return !(this$commodityCode == null ? other$commodityCode != null : !this$commodityCode.equals(other$commodityCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CardPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $commodityCode = this.getCommodityCode();
                result = result * 59 + ($commodityCode == null ? 43 : $commodityCode.hashCode());
                return result;
            }
        }

        public static class Klarna
        extends StripeObject {
            @SerializedName(value="image_url")
            String imageUrl;
            @SerializedName(value="product_url")
            String productUrl;

            @Generated
            public String getImageUrl() {
                return this.imageUrl;
            }

            @Generated
            public String getProductUrl() {
                return this.productUrl;
            }

            @Generated
            public void setImageUrl(String imageUrl) {
                this.imageUrl = imageUrl;
            }

            @Generated
            public void setProductUrl(String productUrl) {
                this.productUrl = productUrl;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$imageUrl = this.getImageUrl();
                String other$imageUrl = other.getImageUrl();
                if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
                    return false;
                }
                String this$productUrl = this.getProductUrl();
                String other$productUrl = other.getProductUrl();
                return !(this$productUrl == null ? other$productUrl != null : !this$productUrl.equals(other$productUrl));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $imageUrl = this.getImageUrl();
                result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
                String $productUrl = this.getProductUrl();
                result = result * 59 + ($productUrl == null ? 43 : $productUrl.hashCode());
                return result;
            }
        }

        public static class Paypal
        extends StripeObject {
            @SerializedName(value="category")
            String category;
            @SerializedName(value="description")
            String description;
            @SerializedName(value="sold_by")
            String soldBy;

            @Generated
            public String getCategory() {
                return this.category;
            }

            @Generated
            public String getDescription() {
                return this.description;
            }

            @Generated
            public String getSoldBy() {
                return this.soldBy;
            }

            @Generated
            public void setCategory(String category) {
                this.category = category;
            }

            @Generated
            public void setDescription(String description) {
                this.description = description;
            }

            @Generated
            public void setSoldBy(String soldBy) {
                this.soldBy = soldBy;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$category = this.getCategory();
                String other$category = other.getCategory();
                if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$soldBy = this.getSoldBy();
                String other$soldBy = other.getSoldBy();
                return !(this$soldBy == null ? other$soldBy != null : !this$soldBy.equals(other$soldBy));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $category = this.getCategory();
                result = result * 59 + ($category == null ? 43 : $category.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $soldBy = this.getSoldBy();
                result = result * 59 + ($soldBy == null ? 43 : $soldBy.hashCode());
                return result;
            }
        }
    }

    public static class Tax
    extends StripeObject {
        @SerializedName(value="total_tax_amount")
        Long totalTaxAmount;

        @Generated
        public Long getTotalTaxAmount() {
            return this.totalTaxAmount;
        }

        @Generated
        public void setTotalTaxAmount(Long totalTaxAmount) {
            this.totalTaxAmount = totalTaxAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tax)) {
                return false;
            }
            Tax other = (Tax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$totalTaxAmount = this.getTotalTaxAmount();
            Long other$totalTaxAmount = other.getTotalTaxAmount();
            return !(this$totalTaxAmount == null ? other$totalTaxAmount != null : !((Object)this$totalTaxAmount).equals(other$totalTaxAmount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $totalTaxAmount = this.getTotalTaxAmount();
            result = result * 59 + ($totalTaxAmount == null ? 43 : ((Object)$totalTaxAmount).hashCode());
            return result;
        }
    }
}

