/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.issuing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.issuing.FraudLiabilityDebitCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.issuing.FraudLiabilityDebitListParams;
import com.stripe.param.issuing.FraudLiabilityDebitRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class FraudLiabilityDebit
extends ApiResource
implements HasId {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="balance_transaction")
    ExpandableField<BalanceTransaction> balanceTransaction;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="dispute")
    String dispute;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public String getBalanceTransaction() {
        return this.balanceTransaction != null ? this.balanceTransaction.getId() : null;
    }

    public void setBalanceTransaction(String id) {
        this.balanceTransaction = ApiResource.setExpandableFieldId(id, this.balanceTransaction);
    }

    public BalanceTransaction getBalanceTransactionObject() {
        return this.balanceTransaction != null ? this.balanceTransaction.getExpanded() : null;
    }

    public void setBalanceTransactionObject(BalanceTransaction expandableObject) {
        this.balanceTransaction = new ExpandableField<BalanceTransaction>(expandableObject.getId(), expandableObject);
    }

    public static FraudLiabilityDebitCollection list(Map<String, Object> params) throws StripeException {
        return FraudLiabilityDebit.list(params, (RequestOptions)null);
    }

    public static FraudLiabilityDebitCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/fraud_liability_debits";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FraudLiabilityDebitCollection)FraudLiabilityDebit.getGlobalResponseGetter().request(request, (Type)((Object)FraudLiabilityDebitCollection.class));
    }

    public static FraudLiabilityDebitCollection list(FraudLiabilityDebitListParams params) throws StripeException {
        return FraudLiabilityDebit.list(params, (RequestOptions)null);
    }

    public static FraudLiabilityDebitCollection list(FraudLiabilityDebitListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/issuing/fraud_liability_debits";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FraudLiabilityDebitCollection)FraudLiabilityDebit.getGlobalResponseGetter().request(request, (Type)((Object)FraudLiabilityDebitCollection.class));
    }

    public static FraudLiabilityDebit retrieve(String fraudLiabilityDebit) throws StripeException {
        return FraudLiabilityDebit.retrieve(fraudLiabilityDebit, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static FraudLiabilityDebit retrieve(String fraudLiabilityDebit, RequestOptions options) throws StripeException {
        return FraudLiabilityDebit.retrieve(fraudLiabilityDebit, (Map<String, Object>)null, options);
    }

    public static FraudLiabilityDebit retrieve(String fraudLiabilityDebit, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/fraud_liability_debits/%s", ApiResource.urlEncodeId(fraudLiabilityDebit));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (FraudLiabilityDebit)FraudLiabilityDebit.getGlobalResponseGetter().request(request, (Type)((Object)FraudLiabilityDebit.class));
    }

    public static FraudLiabilityDebit retrieve(String fraudLiabilityDebit, FraudLiabilityDebitRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/issuing/fraud_liability_debits/%s", ApiResource.urlEncodeId(fraudLiabilityDebit));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FraudLiabilityDebit)FraudLiabilityDebit.getGlobalResponseGetter().request(request, (Type)((Object)FraudLiabilityDebit.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.balanceTransaction, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDispute() {
        return this.dispute;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDispute(String dispute) {
        this.dispute = dispute;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FraudLiabilityDebit)) {
            return false;
        }
        FraudLiabilityDebit other = (FraudLiabilityDebit)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$balanceTransaction = this.getBalanceTransaction();
        String other$balanceTransaction = other.getBalanceTransaction();
        if (this$balanceTransaction == null ? other$balanceTransaction != null : !this$balanceTransaction.equals(other$balanceTransaction)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$dispute = this.getDispute();
        String other$dispute = other.getDispute();
        if (this$dispute == null ? other$dispute != null : !this$dispute.equals(other$dispute)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FraudLiabilityDebit;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $balanceTransaction = this.getBalanceTransaction();
        result = result * 59 + ($balanceTransaction == null ? 43 : $balanceTransaction.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $dispute = this.getDispute();
        result = result * 59 + ($dispute == null ? 43 : $dispute.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

