/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.privacy;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.privacy.RedactionJob;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.privacy.RedactionJobCancelParams;
import com.stripe.param.privacy.RedactionJobCreateParams;
import com.stripe.param.privacy.RedactionJobListParams;
import com.stripe.param.privacy.RedactionJobRetrieveParams;
import com.stripe.param.privacy.RedactionJobRunParams;
import com.stripe.param.privacy.RedactionJobUpdateParams;
import com.stripe.param.privacy.RedactionJobValidateParams;
import com.stripe.service.privacy.RedactionJobValidationErrorService;
import java.lang.reflect.Type;

public final class RedactionJobService
extends ApiService {
    public RedactionJobService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<RedactionJob> list(RedactionJobListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<RedactionJob> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<RedactionJob> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<RedactionJob> list(RedactionJobListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/privacy/redaction_jobs";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<RedactionJob>>(){}.getType());
    }

    public RedactionJob create(RedactionJobCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public RedactionJob create(RedactionJobCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/privacy/redaction_jobs";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob retrieve(String job, RedactionJobRetrieveParams params) throws StripeException {
        return this.retrieve(job, params, null);
    }

    public RedactionJob retrieve(String job, RequestOptions options) throws StripeException {
        return this.retrieve(job, null, options);
    }

    public RedactionJob retrieve(String job) throws StripeException {
        return this.retrieve(job, null, null);
    }

    public RedactionJob retrieve(String job, RedactionJobRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob update(String job, RedactionJobUpdateParams params) throws StripeException {
        return this.update(job, params, null);
    }

    public RedactionJob update(String job, RequestOptions options) throws StripeException {
        return this.update(job, null, options);
    }

    public RedactionJob update(String job) throws StripeException {
        return this.update(job, null, null);
    }

    public RedactionJob update(String job, RedactionJobUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob cancel(String job, RedactionJobCancelParams params) throws StripeException {
        return this.cancel(job, params, null);
    }

    public RedactionJob cancel(String job, RequestOptions options) throws StripeException {
        return this.cancel(job, null, options);
    }

    public RedactionJob cancel(String job) throws StripeException {
        return this.cancel(job, null, null);
    }

    public RedactionJob cancel(String job, RedactionJobCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/cancel", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob run(String job, RedactionJobRunParams params) throws StripeException {
        return this.run(job, params, null);
    }

    public RedactionJob run(String job, RequestOptions options) throws StripeException {
        return this.run(job, null, options);
    }

    public RedactionJob run(String job) throws StripeException {
        return this.run(job, null, null);
    }

    public RedactionJob run(String job, RedactionJobRunParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/run", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob validate(String job, RedactionJobValidateParams params) throws StripeException {
        return this.validate(job, params, null);
    }

    public RedactionJob validate(String job, RequestOptions options) throws StripeException {
        return this.validate(job, null, options);
    }

    public RedactionJob validate(String job) throws StripeException {
        return this.validate(job, null, null);
    }

    public RedactionJob validate(String job, RedactionJobValidateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/validate", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJobValidationErrorService validationErrors() {
        return new RedactionJobValidationErrorService(this.getResponseGetter());
    }
}

