/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core.accounts;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.core.Person;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.accounts.PersonCreateParams;
import com.stripe.param.v2.core.accounts.PersonListParams;
import com.stripe.param.v2.core.accounts.PersonUpdateParams;
import java.lang.reflect.Type;

public final class PersonService
extends ApiService {
    public PersonService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public Person create(String accountId, PersonCreateParams params) throws StripeException {
        return this.create(accountId, params, null);
    }

    public Person create(String accountId, RequestOptions options) throws StripeException {
        return this.create(accountId, null, options);
    }

    public Person create(String accountId) throws StripeException {
        return this.create(accountId, null, null);
    }

    public Person create(String accountId, PersonCreateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/persons", ApiResource.urlEncodeId(accountId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }

    public Person delete(String accountId, String id) throws StripeException {
        return this.delete(accountId, id, null);
    }

    public Person delete(String accountId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/persons/%s", ApiResource.urlEncodeId(accountId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }

    public StripeCollection<Person> list(String accountId, PersonListParams params) throws StripeException {
        return this.list(accountId, params, null);
    }

    public StripeCollection<Person> list(String accountId, RequestOptions options) throws StripeException {
        return this.list(accountId, null, options);
    }

    public StripeCollection<Person> list(String accountId) throws StripeException {
        return this.list(accountId, null, null);
    }

    public StripeCollection<Person> list(String accountId, PersonListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/persons", ApiResource.urlEncodeId(accountId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Person>>(){}.getType());
    }

    public Person retrieve(String accountId, String id) throws StripeException {
        return this.retrieve(accountId, id, null);
    }

    public Person retrieve(String accountId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/persons/%s", ApiResource.urlEncodeId(accountId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }

    public Person update(String accountId, String id, PersonUpdateParams params) throws StripeException {
        return this.update(accountId, id, params, null);
    }

    public Person update(String accountId, String id, RequestOptions options) throws StripeException {
        return this.update(accountId, id, null, options);
    }

    public Person update(String accountId, String id) throws StripeException {
        return this.update(accountId, id, null, null);
    }

    public Person update(String accountId, String id, PersonUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/accounts/%s/persons/%s", ApiResource.urlEncodeId(accountId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Person)this.request(request, (Type)((Object)Person.class));
    }
}

