/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.core.vault;

import com.stripe.exception.BlockedByStripeException;
import com.stripe.exception.ControlledByDashboardException;
import com.stripe.exception.InvalidPaymentMethodException;
import com.stripe.exception.QuotaExceededException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.core.vault.UsBankAccount;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.core.vault.UsBankAccountCreateParams;
import com.stripe.param.v2.core.vault.UsBankAccountUpdateParams;
import java.lang.reflect.Type;

public final class UsBankAccountService
extends ApiService {
    public UsBankAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public UsBankAccount archive(String id) throws StripeException, ControlledByDashboardException {
        return this.archive(id, null);
    }

    public UsBankAccount archive(String id, RequestOptions options) throws StripeException, ControlledByDashboardException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s/archive", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount create(UsBankAccountCreateParams params) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.create(params, null);
    }

    public UsBankAccount create(UsBankAccountCreateParams params, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        String path = "/v2/core/vault/us_bank_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public UsBankAccount retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }

    public UsBankAccount update(String id, UsBankAccountUpdateParams params) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.update(id, params, null);
    }

    public UsBankAccount update(String id, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.update(id, null, options);
    }

    public UsBankAccount update(String id) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        return this.update(id, null, null);
    }

    public UsBankAccount update(String id, UsBankAccountUpdateParams params, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPaymentMethodException, QuotaExceededException {
        String path = String.format("/v2/core/vault/us_bank_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (UsBankAccount)this.request(request, (Type)((Object)UsBankAccount.class));
    }
}

