/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.BlockedByStripeException;
import com.stripe.exception.InvalidPayoutMethodException;
import com.stripe.exception.QuotaExceededException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.OutboundSetupIntent;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.OutboundSetupIntentCreateParams;
import com.stripe.param.v2.moneymanagement.OutboundSetupIntentListParams;
import com.stripe.param.v2.moneymanagement.OutboundSetupIntentUpdateParams;
import java.lang.reflect.Type;

public final class OutboundSetupIntentService
extends ApiService {
    public OutboundSetupIntentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public OutboundSetupIntent cancel(String id) throws StripeException {
        return this.cancel(id, null);
    }

    public OutboundSetupIntent cancel(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/outbound_setup_intents/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (OutboundSetupIntent)this.request(request, (Type)((Object)OutboundSetupIntent.class));
    }

    public OutboundSetupIntent create(OutboundSetupIntentCreateParams params) throws StripeException, BlockedByStripeException, InvalidPayoutMethodException, QuotaExceededException {
        return this.create(params, null);
    }

    public OutboundSetupIntent create(RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPayoutMethodException, QuotaExceededException {
        return this.create(null, options);
    }

    public OutboundSetupIntent create() throws StripeException, BlockedByStripeException, InvalidPayoutMethodException, QuotaExceededException {
        return this.create(null, null);
    }

    public OutboundSetupIntent create(OutboundSetupIntentCreateParams params, RequestOptions options) throws StripeException, BlockedByStripeException, InvalidPayoutMethodException, QuotaExceededException {
        String path = "/v2/money_management/outbound_setup_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundSetupIntent)this.request(request, (Type)((Object)OutboundSetupIntent.class));
    }

    public StripeCollection<OutboundSetupIntent> list(OutboundSetupIntentListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<OutboundSetupIntent> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<OutboundSetupIntent> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<OutboundSetupIntent> list(OutboundSetupIntentListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/outbound_setup_intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<OutboundSetupIntent>>(){}.getType());
    }

    public OutboundSetupIntent retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public OutboundSetupIntent retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/outbound_setup_intents/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (OutboundSetupIntent)this.request(request, (Type)((Object)OutboundSetupIntent.class));
    }

    public OutboundSetupIntent update(String id, OutboundSetupIntentUpdateParams params) throws StripeException, QuotaExceededException, BlockedByStripeException, InvalidPayoutMethodException {
        return this.update(id, params, null);
    }

    public OutboundSetupIntent update(String id, RequestOptions options) throws StripeException, QuotaExceededException, BlockedByStripeException, InvalidPayoutMethodException {
        return this.update(id, null, options);
    }

    public OutboundSetupIntent update(String id) throws StripeException, QuotaExceededException, BlockedByStripeException, InvalidPayoutMethodException {
        return this.update(id, null, null);
    }

    public OutboundSetupIntent update(String id, OutboundSetupIntentUpdateParams params, RequestOptions options) throws StripeException, QuotaExceededException, BlockedByStripeException, InvalidPayoutMethodException {
        String path = String.format("/v2/money_management/outbound_setup_intents/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundSetupIntent)this.request(request, (Type)((Object)OutboundSetupIntent.class));
    }
}

