/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.AlreadyCanceledException;
import com.stripe.exception.InsufficientFundsException;
import com.stripe.exception.NotCancelableException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.OutboundTransfer;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.OutboundTransferCreateParams;
import com.stripe.param.v2.moneymanagement.OutboundTransferListParams;
import java.lang.reflect.Type;

public final class OutboundTransferService
extends ApiService {
    public OutboundTransferService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public OutboundTransfer cancel(String id) throws StripeException, AlreadyCanceledException, NotCancelableException {
        return this.cancel(id, null);
    }

    public OutboundTransfer cancel(String id, RequestOptions options) throws StripeException, AlreadyCanceledException, NotCancelableException {
        String path = String.format("/v2/money_management/outbound_transfers/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (OutboundTransfer)this.request(request, (Type)((Object)OutboundTransfer.class));
    }

    public OutboundTransfer create(OutboundTransferCreateParams params) throws StripeException, InsufficientFundsException {
        return this.create(params, null);
    }

    public OutboundTransfer create(OutboundTransferCreateParams params, RequestOptions options) throws StripeException, InsufficientFundsException {
        String path = "/v2/money_management/outbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (OutboundTransfer)this.request(request, (Type)((Object)OutboundTransfer.class));
    }

    public StripeCollection<OutboundTransfer> list(OutboundTransferListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<OutboundTransfer> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<OutboundTransfer> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<OutboundTransfer> list(OutboundTransferListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/outbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<OutboundTransfer>>(){}.getType());
    }

    public OutboundTransfer retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public OutboundTransfer retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/outbound_transfers/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (OutboundTransfer)this.request(request, (Type)((Object)OutboundTransfer.class));
    }
}

