/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.ControlledByDashboardException;
import com.stripe.exception.InvalidPayoutMethodException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.PayoutMethod;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.PayoutMethodListParams;
import java.lang.reflect.Type;

public final class PayoutMethodService
extends ApiService {
    public PayoutMethodService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public PayoutMethod archive(String id) throws StripeException, ControlledByDashboardException, InvalidPayoutMethodException {
        return this.archive(id, null);
    }

    public PayoutMethod archive(String id, RequestOptions options) throws StripeException, ControlledByDashboardException, InvalidPayoutMethodException {
        String path = String.format("/v2/money_management/payout_methods/%s/archive", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (PayoutMethod)this.request(request, (Type)((Object)PayoutMethod.class));
    }

    public StripeCollection<PayoutMethod> list(PayoutMethodListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PayoutMethod> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PayoutMethod> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PayoutMethod> list(PayoutMethodListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/payout_methods";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PayoutMethod>>(){}.getType());
    }

    public PayoutMethod retrieve(String id) throws StripeException, InvalidPayoutMethodException {
        return this.retrieve(id, null);
    }

    public PayoutMethod retrieve(String id, RequestOptions options) throws StripeException, InvalidPayoutMethodException {
        String path = String.format("/v2/money_management/payout_methods/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (PayoutMethod)this.request(request, (Type)((Object)PayoutMethod.class));
    }

    public PayoutMethod unarchive(String id) throws StripeException, ControlledByDashboardException, InvalidPayoutMethodException {
        return this.unarchive(id, null);
    }

    public PayoutMethod unarchive(String id, RequestOptions options) throws StripeException, ControlledByDashboardException, InvalidPayoutMethodException {
        String path = String.format("/v2/money_management/payout_methods/%s/unarchive", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (PayoutMethod)this.request(request, (Type)((Object)PayoutMethod.class));
    }
}

