/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.Transaction;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.TransactionListParams;
import java.lang.reflect.Type;

public final class TransactionService
extends ApiService {
    public TransactionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Transaction> list(TransactionListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Transaction> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Transaction> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Transaction> list(TransactionListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/transactions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Transaction>>(){}.getType());
    }

    public Transaction retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public Transaction retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/transactions/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (Transaction)this.request(request, (Type)((Object)Transaction.class));
    }
}

