/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.testhelpers;

import com.stripe.exception.StripeException;
import com.stripe.model.v2.FinancialAddressCreditSimulation;
import com.stripe.model.v2.FinancialAddressGeneratedMicrodeposits;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.testhelpers.FinancialAddressCreditParams;
import java.lang.reflect.Type;

public final class FinancialAddressService
extends ApiService {
    public FinancialAddressService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public FinancialAddressCreditSimulation credit(String id, FinancialAddressCreditParams params) throws StripeException {
        return this.credit(id, params, null);
    }

    public FinancialAddressCreditSimulation credit(String id, FinancialAddressCreditParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/test_helpers/financial_addresses/%s/credit", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAddressCreditSimulation)this.request(request, (Type)((Object)FinancialAddressCreditSimulation.class));
    }

    public FinancialAddressGeneratedMicrodeposits generateMicrodeposits(String id) throws StripeException {
        return this.generateMicrodeposits(id, null);
    }

    public FinancialAddressGeneratedMicrodeposits generateMicrodeposits(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/test_helpers/financial_addresses/%s/generate_microdeposits", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (FinancialAddressGeneratedMicrodeposits)this.request(request, (Type)((Object)FinancialAddressGeneratedMicrodeposits.class));
    }
}

