/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.AccountSessionCreateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class AccountSession
extends ApiResource {
    @SerializedName(value="account")
    String account;
    @SerializedName(value="client_secret")
    String clientSecret;
    @SerializedName(value="components")
    Components components;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;

    public static AccountSession create(Map<String, Object> params) throws StripeException {
        return AccountSession.create(params, (RequestOptions)null);
    }

    public static AccountSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/account_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (AccountSession)AccountSession.getGlobalResponseGetter().request(request, (Type)((Object)AccountSession.class));
    }

    public static AccountSession create(AccountSessionCreateParams params) throws StripeException {
        return AccountSession.create(params, (RequestOptions)null);
    }

    public static AccountSession create(AccountSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/account_sessions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (AccountSession)AccountSession.getGlobalResponseGetter().request(request, (Type)((Object)AccountSession.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.components, responseGetter);
    }

    @Generated
    public String getAccount() {
        return this.account;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Components getComponents() {
        return this.components;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setAccount(String account) {
        this.account = account;
    }

    @Generated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    @Generated
    public void setComponents(Components components) {
        this.components = components;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountSession)) {
            return false;
        }
        AccountSession other = (AccountSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$account = this.getAccount();
        String other$account = other.getAccount();
        if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
            return false;
        }
        String this$clientSecret = this.getClientSecret();
        String other$clientSecret = other.getClientSecret();
        if (this$clientSecret == null ? other$clientSecret != null : !this$clientSecret.equals(other$clientSecret)) {
            return false;
        }
        Components this$components = this.getComponents();
        Components other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AccountSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $account = this.getAccount();
        result = result * 59 + ($account == null ? 43 : $account.hashCode());
        String $clientSecret = this.getClientSecret();
        result = result * 59 + ($clientSecret == null ? 43 : $clientSecret.hashCode());
        Components $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    public static class Components
    extends StripeObject {
        @SerializedName(value="account_management")
        AccountManagement accountManagement;
        @SerializedName(value="account_onboarding")
        AccountOnboarding accountOnboarding;
        @SerializedName(value="balances")
        Balances balances;
        @SerializedName(value="disputes_list")
        DisputesList disputesList;
        @SerializedName(value="documents")
        Documents documents;
        @SerializedName(value="financial_account")
        FinancialAccount financialAccount;
        @SerializedName(value="financial_account_transactions")
        FinancialAccountTransactions financialAccountTransactions;
        @SerializedName(value="issuing_card")
        IssuingCard issuingCard;
        @SerializedName(value="issuing_cards_list")
        IssuingCardsList issuingCardsList;
        @SerializedName(value="notification_banner")
        NotificationBanner notificationBanner;
        @SerializedName(value="payment_details")
        PaymentDetails paymentDetails;
        @SerializedName(value="payment_disputes")
        PaymentDisputes paymentDisputes;
        @SerializedName(value="payments")
        Payments payments;
        @SerializedName(value="payouts")
        Payouts payouts;
        @SerializedName(value="payouts_list")
        PayoutsList payoutsList;
        @SerializedName(value="tax_registrations")
        TaxRegistrations taxRegistrations;
        @SerializedName(value="tax_settings")
        TaxSettings taxSettings;

        @Generated
        public AccountManagement getAccountManagement() {
            return this.accountManagement;
        }

        @Generated
        public AccountOnboarding getAccountOnboarding() {
            return this.accountOnboarding;
        }

        @Generated
        public Balances getBalances() {
            return this.balances;
        }

        @Generated
        public DisputesList getDisputesList() {
            return this.disputesList;
        }

        @Generated
        public Documents getDocuments() {
            return this.documents;
        }

        @Generated
        public FinancialAccount getFinancialAccount() {
            return this.financialAccount;
        }

        @Generated
        public FinancialAccountTransactions getFinancialAccountTransactions() {
            return this.financialAccountTransactions;
        }

        @Generated
        public IssuingCard getIssuingCard() {
            return this.issuingCard;
        }

        @Generated
        public IssuingCardsList getIssuingCardsList() {
            return this.issuingCardsList;
        }

        @Generated
        public NotificationBanner getNotificationBanner() {
            return this.notificationBanner;
        }

        @Generated
        public PaymentDetails getPaymentDetails() {
            return this.paymentDetails;
        }

        @Generated
        public PaymentDisputes getPaymentDisputes() {
            return this.paymentDisputes;
        }

        @Generated
        public Payments getPayments() {
            return this.payments;
        }

        @Generated
        public Payouts getPayouts() {
            return this.payouts;
        }

        @Generated
        public PayoutsList getPayoutsList() {
            return this.payoutsList;
        }

        @Generated
        public TaxRegistrations getTaxRegistrations() {
            return this.taxRegistrations;
        }

        @Generated
        public TaxSettings getTaxSettings() {
            return this.taxSettings;
        }

        @Generated
        public void setAccountManagement(AccountManagement accountManagement) {
            this.accountManagement = accountManagement;
        }

        @Generated
        public void setAccountOnboarding(AccountOnboarding accountOnboarding) {
            this.accountOnboarding = accountOnboarding;
        }

        @Generated
        public void setBalances(Balances balances) {
            this.balances = balances;
        }

        @Generated
        public void setDisputesList(DisputesList disputesList) {
            this.disputesList = disputesList;
        }

        @Generated
        public void setDocuments(Documents documents) {
            this.documents = documents;
        }

        @Generated
        public void setFinancialAccount(FinancialAccount financialAccount) {
            this.financialAccount = financialAccount;
        }

        @Generated
        public void setFinancialAccountTransactions(FinancialAccountTransactions financialAccountTransactions) {
            this.financialAccountTransactions = financialAccountTransactions;
        }

        @Generated
        public void setIssuingCard(IssuingCard issuingCard) {
            this.issuingCard = issuingCard;
        }

        @Generated
        public void setIssuingCardsList(IssuingCardsList issuingCardsList) {
            this.issuingCardsList = issuingCardsList;
        }

        @Generated
        public void setNotificationBanner(NotificationBanner notificationBanner) {
            this.notificationBanner = notificationBanner;
        }

        @Generated
        public void setPaymentDetails(PaymentDetails paymentDetails) {
            this.paymentDetails = paymentDetails;
        }

        @Generated
        public void setPaymentDisputes(PaymentDisputes paymentDisputes) {
            this.paymentDisputes = paymentDisputes;
        }

        @Generated
        public void setPayments(Payments payments) {
            this.payments = payments;
        }

        @Generated
        public void setPayouts(Payouts payouts) {
            this.payouts = payouts;
        }

        @Generated
        public void setPayoutsList(PayoutsList payoutsList) {
            this.payoutsList = payoutsList;
        }

        @Generated
        public void setTaxRegistrations(TaxRegistrations taxRegistrations) {
            this.taxRegistrations = taxRegistrations;
        }

        @Generated
        public void setTaxSettings(TaxSettings taxSettings) {
            this.taxSettings = taxSettings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Components)) {
                return false;
            }
            Components other = (Components)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AccountManagement this$accountManagement = this.getAccountManagement();
            AccountManagement other$accountManagement = other.getAccountManagement();
            if (this$accountManagement == null ? other$accountManagement != null : !((Object)this$accountManagement).equals(other$accountManagement)) {
                return false;
            }
            AccountOnboarding this$accountOnboarding = this.getAccountOnboarding();
            AccountOnboarding other$accountOnboarding = other.getAccountOnboarding();
            if (this$accountOnboarding == null ? other$accountOnboarding != null : !((Object)this$accountOnboarding).equals(other$accountOnboarding)) {
                return false;
            }
            Balances this$balances = this.getBalances();
            Balances other$balances = other.getBalances();
            if (this$balances == null ? other$balances != null : !((Object)this$balances).equals(other$balances)) {
                return false;
            }
            DisputesList this$disputesList = this.getDisputesList();
            DisputesList other$disputesList = other.getDisputesList();
            if (this$disputesList == null ? other$disputesList != null : !((Object)this$disputesList).equals(other$disputesList)) {
                return false;
            }
            Documents this$documents = this.getDocuments();
            Documents other$documents = other.getDocuments();
            if (this$documents == null ? other$documents != null : !((Object)this$documents).equals(other$documents)) {
                return false;
            }
            FinancialAccount this$financialAccount = this.getFinancialAccount();
            FinancialAccount other$financialAccount = other.getFinancialAccount();
            if (this$financialAccount == null ? other$financialAccount != null : !((Object)this$financialAccount).equals(other$financialAccount)) {
                return false;
            }
            FinancialAccountTransactions this$financialAccountTransactions = this.getFinancialAccountTransactions();
            FinancialAccountTransactions other$financialAccountTransactions = other.getFinancialAccountTransactions();
            if (this$financialAccountTransactions == null ? other$financialAccountTransactions != null : !((Object)this$financialAccountTransactions).equals(other$financialAccountTransactions)) {
                return false;
            }
            IssuingCard this$issuingCard = this.getIssuingCard();
            IssuingCard other$issuingCard = other.getIssuingCard();
            if (this$issuingCard == null ? other$issuingCard != null : !((Object)this$issuingCard).equals(other$issuingCard)) {
                return false;
            }
            IssuingCardsList this$issuingCardsList = this.getIssuingCardsList();
            IssuingCardsList other$issuingCardsList = other.getIssuingCardsList();
            if (this$issuingCardsList == null ? other$issuingCardsList != null : !((Object)this$issuingCardsList).equals(other$issuingCardsList)) {
                return false;
            }
            NotificationBanner this$notificationBanner = this.getNotificationBanner();
            NotificationBanner other$notificationBanner = other.getNotificationBanner();
            if (this$notificationBanner == null ? other$notificationBanner != null : !((Object)this$notificationBanner).equals(other$notificationBanner)) {
                return false;
            }
            PaymentDetails this$paymentDetails = this.getPaymentDetails();
            PaymentDetails other$paymentDetails = other.getPaymentDetails();
            if (this$paymentDetails == null ? other$paymentDetails != null : !((Object)this$paymentDetails).equals(other$paymentDetails)) {
                return false;
            }
            PaymentDisputes this$paymentDisputes = this.getPaymentDisputes();
            PaymentDisputes other$paymentDisputes = other.getPaymentDisputes();
            if (this$paymentDisputes == null ? other$paymentDisputes != null : !((Object)this$paymentDisputes).equals(other$paymentDisputes)) {
                return false;
            }
            Payments this$payments = this.getPayments();
            Payments other$payments = other.getPayments();
            if (this$payments == null ? other$payments != null : !((Object)this$payments).equals(other$payments)) {
                return false;
            }
            Payouts this$payouts = this.getPayouts();
            Payouts other$payouts = other.getPayouts();
            if (this$payouts == null ? other$payouts != null : !((Object)this$payouts).equals(other$payouts)) {
                return false;
            }
            PayoutsList this$payoutsList = this.getPayoutsList();
            PayoutsList other$payoutsList = other.getPayoutsList();
            if (this$payoutsList == null ? other$payoutsList != null : !((Object)this$payoutsList).equals(other$payoutsList)) {
                return false;
            }
            TaxRegistrations this$taxRegistrations = this.getTaxRegistrations();
            TaxRegistrations other$taxRegistrations = other.getTaxRegistrations();
            if (this$taxRegistrations == null ? other$taxRegistrations != null : !((Object)this$taxRegistrations).equals(other$taxRegistrations)) {
                return false;
            }
            TaxSettings this$taxSettings = this.getTaxSettings();
            TaxSettings other$taxSettings = other.getTaxSettings();
            return !(this$taxSettings == null ? other$taxSettings != null : !((Object)this$taxSettings).equals(other$taxSettings));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Components;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AccountManagement $accountManagement = this.getAccountManagement();
            result = result * 59 + ($accountManagement == null ? 43 : ((Object)$accountManagement).hashCode());
            AccountOnboarding $accountOnboarding = this.getAccountOnboarding();
            result = result * 59 + ($accountOnboarding == null ? 43 : ((Object)$accountOnboarding).hashCode());
            Balances $balances = this.getBalances();
            result = result * 59 + ($balances == null ? 43 : ((Object)$balances).hashCode());
            DisputesList $disputesList = this.getDisputesList();
            result = result * 59 + ($disputesList == null ? 43 : ((Object)$disputesList).hashCode());
            Documents $documents = this.getDocuments();
            result = result * 59 + ($documents == null ? 43 : ((Object)$documents).hashCode());
            FinancialAccount $financialAccount = this.getFinancialAccount();
            result = result * 59 + ($financialAccount == null ? 43 : ((Object)$financialAccount).hashCode());
            FinancialAccountTransactions $financialAccountTransactions = this.getFinancialAccountTransactions();
            result = result * 59 + ($financialAccountTransactions == null ? 43 : ((Object)$financialAccountTransactions).hashCode());
            IssuingCard $issuingCard = this.getIssuingCard();
            result = result * 59 + ($issuingCard == null ? 43 : ((Object)$issuingCard).hashCode());
            IssuingCardsList $issuingCardsList = this.getIssuingCardsList();
            result = result * 59 + ($issuingCardsList == null ? 43 : ((Object)$issuingCardsList).hashCode());
            NotificationBanner $notificationBanner = this.getNotificationBanner();
            result = result * 59 + ($notificationBanner == null ? 43 : ((Object)$notificationBanner).hashCode());
            PaymentDetails $paymentDetails = this.getPaymentDetails();
            result = result * 59 + ($paymentDetails == null ? 43 : ((Object)$paymentDetails).hashCode());
            PaymentDisputes $paymentDisputes = this.getPaymentDisputes();
            result = result * 59 + ($paymentDisputes == null ? 43 : ((Object)$paymentDisputes).hashCode());
            Payments $payments = this.getPayments();
            result = result * 59 + ($payments == null ? 43 : ((Object)$payments).hashCode());
            Payouts $payouts = this.getPayouts();
            result = result * 59 + ($payouts == null ? 43 : ((Object)$payouts).hashCode());
            PayoutsList $payoutsList = this.getPayoutsList();
            result = result * 59 + ($payoutsList == null ? 43 : ((Object)$payoutsList).hashCode());
            TaxRegistrations $taxRegistrations = this.getTaxRegistrations();
            result = result * 59 + ($taxRegistrations == null ? 43 : ((Object)$taxRegistrations).hashCode());
            TaxSettings $taxSettings = this.getTaxSettings();
            result = result * 59 + ($taxSettings == null ? 43 : ((Object)$taxSettings).hashCode());
            return result;
        }

        public static class AccountManagement
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AccountManagement)) {
                    return false;
                }
                AccountManagement other = (AccountManagement)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AccountManagement;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="external_account_collection")
                Boolean externalAccountCollection;

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getExternalAccountCollection() {
                    return this.externalAccountCollection;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setExternalAccountCollection(Boolean externalAccountCollection) {
                    this.externalAccountCollection = externalAccountCollection;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$externalAccountCollection = this.getExternalAccountCollection();
                    Boolean other$externalAccountCollection = other.getExternalAccountCollection();
                    return !(this$externalAccountCollection == null ? other$externalAccountCollection != null : !((Object)this$externalAccountCollection).equals(other$externalAccountCollection));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $externalAccountCollection = this.getExternalAccountCollection();
                    result = result * 59 + ($externalAccountCollection == null ? 43 : ((Object)$externalAccountCollection).hashCode());
                    return result;
                }
            }
        }

        public static class AccountOnboarding
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AccountOnboarding)) {
                    return false;
                }
                AccountOnboarding other = (AccountOnboarding)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AccountOnboarding;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="external_account_collection")
                Boolean externalAccountCollection;

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getExternalAccountCollection() {
                    return this.externalAccountCollection;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setExternalAccountCollection(Boolean externalAccountCollection) {
                    this.externalAccountCollection = externalAccountCollection;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$externalAccountCollection = this.getExternalAccountCollection();
                    Boolean other$externalAccountCollection = other.getExternalAccountCollection();
                    return !(this$externalAccountCollection == null ? other$externalAccountCollection != null : !((Object)this$externalAccountCollection).equals(other$externalAccountCollection));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $externalAccountCollection = this.getExternalAccountCollection();
                    result = result * 59 + ($externalAccountCollection == null ? 43 : ((Object)$externalAccountCollection).hashCode());
                    return result;
                }
            }
        }

        public static class Balances
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Balances)) {
                    return false;
                }
                Balances other = (Balances)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Balances;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="edit_payout_schedule")
                Boolean editPayoutSchedule;
                @SerializedName(value="external_account_collection")
                Boolean externalAccountCollection;
                @SerializedName(value="instant_payouts")
                Boolean instantPayouts;
                @SerializedName(value="standard_payouts")
                Boolean standardPayouts;

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getEditPayoutSchedule() {
                    return this.editPayoutSchedule;
                }

                @Generated
                public Boolean getExternalAccountCollection() {
                    return this.externalAccountCollection;
                }

                @Generated
                public Boolean getInstantPayouts() {
                    return this.instantPayouts;
                }

                @Generated
                public Boolean getStandardPayouts() {
                    return this.standardPayouts;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setEditPayoutSchedule(Boolean editPayoutSchedule) {
                    this.editPayoutSchedule = editPayoutSchedule;
                }

                @Generated
                public void setExternalAccountCollection(Boolean externalAccountCollection) {
                    this.externalAccountCollection = externalAccountCollection;
                }

                @Generated
                public void setInstantPayouts(Boolean instantPayouts) {
                    this.instantPayouts = instantPayouts;
                }

                @Generated
                public void setStandardPayouts(Boolean standardPayouts) {
                    this.standardPayouts = standardPayouts;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$editPayoutSchedule = this.getEditPayoutSchedule();
                    Boolean other$editPayoutSchedule = other.getEditPayoutSchedule();
                    if (this$editPayoutSchedule == null ? other$editPayoutSchedule != null : !((Object)this$editPayoutSchedule).equals(other$editPayoutSchedule)) {
                        return false;
                    }
                    Boolean this$externalAccountCollection = this.getExternalAccountCollection();
                    Boolean other$externalAccountCollection = other.getExternalAccountCollection();
                    if (this$externalAccountCollection == null ? other$externalAccountCollection != null : !((Object)this$externalAccountCollection).equals(other$externalAccountCollection)) {
                        return false;
                    }
                    Boolean this$instantPayouts = this.getInstantPayouts();
                    Boolean other$instantPayouts = other.getInstantPayouts();
                    if (this$instantPayouts == null ? other$instantPayouts != null : !((Object)this$instantPayouts).equals(other$instantPayouts)) {
                        return false;
                    }
                    Boolean this$standardPayouts = this.getStandardPayouts();
                    Boolean other$standardPayouts = other.getStandardPayouts();
                    return !(this$standardPayouts == null ? other$standardPayouts != null : !((Object)this$standardPayouts).equals(other$standardPayouts));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $editPayoutSchedule = this.getEditPayoutSchedule();
                    result = result * 59 + ($editPayoutSchedule == null ? 43 : ((Object)$editPayoutSchedule).hashCode());
                    Boolean $externalAccountCollection = this.getExternalAccountCollection();
                    result = result * 59 + ($externalAccountCollection == null ? 43 : ((Object)$externalAccountCollection).hashCode());
                    Boolean $instantPayouts = this.getInstantPayouts();
                    result = result * 59 + ($instantPayouts == null ? 43 : ((Object)$instantPayouts).hashCode());
                    Boolean $standardPayouts = this.getStandardPayouts();
                    result = result * 59 + ($standardPayouts == null ? 43 : ((Object)$standardPayouts).hashCode());
                    return result;
                }
            }
        }

        public static class DisputesList
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisputesList)) {
                    return false;
                }
                DisputesList other = (DisputesList)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisputesList;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="capture_payments")
                Boolean capturePayments;
                @SerializedName(value="destination_on_behalf_of_charge_management")
                Boolean destinationOnBehalfOfChargeManagement;
                @SerializedName(value="dispute_management")
                Boolean disputeManagement;
                @SerializedName(value="refund_management")
                Boolean refundManagement;

                @Generated
                public Boolean getCapturePayments() {
                    return this.capturePayments;
                }

                @Generated
                public Boolean getDestinationOnBehalfOfChargeManagement() {
                    return this.destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public Boolean getDisputeManagement() {
                    return this.disputeManagement;
                }

                @Generated
                public Boolean getRefundManagement() {
                    return this.refundManagement;
                }

                @Generated
                public void setCapturePayments(Boolean capturePayments) {
                    this.capturePayments = capturePayments;
                }

                @Generated
                public void setDestinationOnBehalfOfChargeManagement(Boolean destinationOnBehalfOfChargeManagement) {
                    this.destinationOnBehalfOfChargeManagement = destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public void setDisputeManagement(Boolean disputeManagement) {
                    this.disputeManagement = disputeManagement;
                }

                @Generated
                public void setRefundManagement(Boolean refundManagement) {
                    this.refundManagement = refundManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$capturePayments = this.getCapturePayments();
                    Boolean other$capturePayments = other.getCapturePayments();
                    if (this$capturePayments == null ? other$capturePayments != null : !((Object)this$capturePayments).equals(other$capturePayments)) {
                        return false;
                    }
                    Boolean this$destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    Boolean other$destinationOnBehalfOfChargeManagement = other.getDestinationOnBehalfOfChargeManagement();
                    if (this$destinationOnBehalfOfChargeManagement == null ? other$destinationOnBehalfOfChargeManagement != null : !((Object)this$destinationOnBehalfOfChargeManagement).equals(other$destinationOnBehalfOfChargeManagement)) {
                        return false;
                    }
                    Boolean this$disputeManagement = this.getDisputeManagement();
                    Boolean other$disputeManagement = other.getDisputeManagement();
                    if (this$disputeManagement == null ? other$disputeManagement != null : !((Object)this$disputeManagement).equals(other$disputeManagement)) {
                        return false;
                    }
                    Boolean this$refundManagement = this.getRefundManagement();
                    Boolean other$refundManagement = other.getRefundManagement();
                    return !(this$refundManagement == null ? other$refundManagement != null : !((Object)this$refundManagement).equals(other$refundManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $capturePayments = this.getCapturePayments();
                    result = result * 59 + ($capturePayments == null ? 43 : ((Object)$capturePayments).hashCode());
                    Boolean $destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    result = result * 59 + ($destinationOnBehalfOfChargeManagement == null ? 43 : ((Object)$destinationOnBehalfOfChargeManagement).hashCode());
                    Boolean $disputeManagement = this.getDisputeManagement();
                    result = result * 59 + ($disputeManagement == null ? 43 : ((Object)$disputeManagement).hashCode());
                    Boolean $refundManagement = this.getRefundManagement();
                    result = result * 59 + ($refundManagement == null ? 43 : ((Object)$refundManagement).hashCode());
                    return result;
                }
            }
        }

        public static class Documents
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Documents)) {
                    return false;
                }
                Documents other = (Documents)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Documents;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }
        }

        public static class FinancialAccount
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FinancialAccount)) {
                    return false;
                }
                FinancialAccount other = (FinancialAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FinancialAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="external_account_collection")
                Boolean externalAccountCollection;
                @SerializedName(value="send_money")
                Boolean sendMoney;
                @SerializedName(value="transfer_balance")
                Boolean transferBalance;

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getExternalAccountCollection() {
                    return this.externalAccountCollection;
                }

                @Generated
                public Boolean getSendMoney() {
                    return this.sendMoney;
                }

                @Generated
                public Boolean getTransferBalance() {
                    return this.transferBalance;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setExternalAccountCollection(Boolean externalAccountCollection) {
                    this.externalAccountCollection = externalAccountCollection;
                }

                @Generated
                public void setSendMoney(Boolean sendMoney) {
                    this.sendMoney = sendMoney;
                }

                @Generated
                public void setTransferBalance(Boolean transferBalance) {
                    this.transferBalance = transferBalance;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$externalAccountCollection = this.getExternalAccountCollection();
                    Boolean other$externalAccountCollection = other.getExternalAccountCollection();
                    if (this$externalAccountCollection == null ? other$externalAccountCollection != null : !((Object)this$externalAccountCollection).equals(other$externalAccountCollection)) {
                        return false;
                    }
                    Boolean this$sendMoney = this.getSendMoney();
                    Boolean other$sendMoney = other.getSendMoney();
                    if (this$sendMoney == null ? other$sendMoney != null : !((Object)this$sendMoney).equals(other$sendMoney)) {
                        return false;
                    }
                    Boolean this$transferBalance = this.getTransferBalance();
                    Boolean other$transferBalance = other.getTransferBalance();
                    return !(this$transferBalance == null ? other$transferBalance != null : !((Object)this$transferBalance).equals(other$transferBalance));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $externalAccountCollection = this.getExternalAccountCollection();
                    result = result * 59 + ($externalAccountCollection == null ? 43 : ((Object)$externalAccountCollection).hashCode());
                    Boolean $sendMoney = this.getSendMoney();
                    result = result * 59 + ($sendMoney == null ? 43 : ((Object)$sendMoney).hashCode());
                    Boolean $transferBalance = this.getTransferBalance();
                    result = result * 59 + ($transferBalance == null ? 43 : ((Object)$transferBalance).hashCode());
                    return result;
                }
            }
        }

        public static class FinancialAccountTransactions
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FinancialAccountTransactions)) {
                    return false;
                }
                FinancialAccountTransactions other = (FinancialAccountTransactions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FinancialAccountTransactions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="card_spend_dispute_management")
                Boolean cardSpendDisputeManagement;

                @Generated
                public Boolean getCardSpendDisputeManagement() {
                    return this.cardSpendDisputeManagement;
                }

                @Generated
                public void setCardSpendDisputeManagement(Boolean cardSpendDisputeManagement) {
                    this.cardSpendDisputeManagement = cardSpendDisputeManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$cardSpendDisputeManagement = this.getCardSpendDisputeManagement();
                    Boolean other$cardSpendDisputeManagement = other.getCardSpendDisputeManagement();
                    return !(this$cardSpendDisputeManagement == null ? other$cardSpendDisputeManagement != null : !((Object)this$cardSpendDisputeManagement).equals(other$cardSpendDisputeManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $cardSpendDisputeManagement = this.getCardSpendDisputeManagement();
                    result = result * 59 + ($cardSpendDisputeManagement == null ? 43 : ((Object)$cardSpendDisputeManagement).hashCode());
                    return result;
                }
            }
        }

        public static class IssuingCard
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IssuingCard)) {
                    return false;
                }
                IssuingCard other = (IssuingCard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IssuingCard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="card_management")
                Boolean cardManagement;
                @SerializedName(value="card_spend_dispute_management")
                Boolean cardSpendDisputeManagement;
                @SerializedName(value="cardholder_management")
                Boolean cardholderManagement;
                @SerializedName(value="spend_control_management")
                Boolean spendControlManagement;

                @Generated
                public Boolean getCardManagement() {
                    return this.cardManagement;
                }

                @Generated
                public Boolean getCardSpendDisputeManagement() {
                    return this.cardSpendDisputeManagement;
                }

                @Generated
                public Boolean getCardholderManagement() {
                    return this.cardholderManagement;
                }

                @Generated
                public Boolean getSpendControlManagement() {
                    return this.spendControlManagement;
                }

                @Generated
                public void setCardManagement(Boolean cardManagement) {
                    this.cardManagement = cardManagement;
                }

                @Generated
                public void setCardSpendDisputeManagement(Boolean cardSpendDisputeManagement) {
                    this.cardSpendDisputeManagement = cardSpendDisputeManagement;
                }

                @Generated
                public void setCardholderManagement(Boolean cardholderManagement) {
                    this.cardholderManagement = cardholderManagement;
                }

                @Generated
                public void setSpendControlManagement(Boolean spendControlManagement) {
                    this.spendControlManagement = spendControlManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$cardManagement = this.getCardManagement();
                    Boolean other$cardManagement = other.getCardManagement();
                    if (this$cardManagement == null ? other$cardManagement != null : !((Object)this$cardManagement).equals(other$cardManagement)) {
                        return false;
                    }
                    Boolean this$cardSpendDisputeManagement = this.getCardSpendDisputeManagement();
                    Boolean other$cardSpendDisputeManagement = other.getCardSpendDisputeManagement();
                    if (this$cardSpendDisputeManagement == null ? other$cardSpendDisputeManagement != null : !((Object)this$cardSpendDisputeManagement).equals(other$cardSpendDisputeManagement)) {
                        return false;
                    }
                    Boolean this$cardholderManagement = this.getCardholderManagement();
                    Boolean other$cardholderManagement = other.getCardholderManagement();
                    if (this$cardholderManagement == null ? other$cardholderManagement != null : !((Object)this$cardholderManagement).equals(other$cardholderManagement)) {
                        return false;
                    }
                    Boolean this$spendControlManagement = this.getSpendControlManagement();
                    Boolean other$spendControlManagement = other.getSpendControlManagement();
                    return !(this$spendControlManagement == null ? other$spendControlManagement != null : !((Object)this$spendControlManagement).equals(other$spendControlManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $cardManagement = this.getCardManagement();
                    result = result * 59 + ($cardManagement == null ? 43 : ((Object)$cardManagement).hashCode());
                    Boolean $cardSpendDisputeManagement = this.getCardSpendDisputeManagement();
                    result = result * 59 + ($cardSpendDisputeManagement == null ? 43 : ((Object)$cardSpendDisputeManagement).hashCode());
                    Boolean $cardholderManagement = this.getCardholderManagement();
                    result = result * 59 + ($cardholderManagement == null ? 43 : ((Object)$cardholderManagement).hashCode());
                    Boolean $spendControlManagement = this.getSpendControlManagement();
                    result = result * 59 + ($spendControlManagement == null ? 43 : ((Object)$spendControlManagement).hashCode());
                    return result;
                }
            }
        }

        public static class IssuingCardsList
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IssuingCardsList)) {
                    return false;
                }
                IssuingCardsList other = (IssuingCardsList)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IssuingCardsList;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="card_management")
                Boolean cardManagement;
                @SerializedName(value="card_spend_dispute_management")
                Boolean cardSpendDisputeManagement;
                @SerializedName(value="cardholder_management")
                Boolean cardholderManagement;
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="spend_control_management")
                Boolean spendControlManagement;

                @Generated
                public Boolean getCardManagement() {
                    return this.cardManagement;
                }

                @Generated
                public Boolean getCardSpendDisputeManagement() {
                    return this.cardSpendDisputeManagement;
                }

                @Generated
                public Boolean getCardholderManagement() {
                    return this.cardholderManagement;
                }

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getSpendControlManagement() {
                    return this.spendControlManagement;
                }

                @Generated
                public void setCardManagement(Boolean cardManagement) {
                    this.cardManagement = cardManagement;
                }

                @Generated
                public void setCardSpendDisputeManagement(Boolean cardSpendDisputeManagement) {
                    this.cardSpendDisputeManagement = cardSpendDisputeManagement;
                }

                @Generated
                public void setCardholderManagement(Boolean cardholderManagement) {
                    this.cardholderManagement = cardholderManagement;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setSpendControlManagement(Boolean spendControlManagement) {
                    this.spendControlManagement = spendControlManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$cardManagement = this.getCardManagement();
                    Boolean other$cardManagement = other.getCardManagement();
                    if (this$cardManagement == null ? other$cardManagement != null : !((Object)this$cardManagement).equals(other$cardManagement)) {
                        return false;
                    }
                    Boolean this$cardSpendDisputeManagement = this.getCardSpendDisputeManagement();
                    Boolean other$cardSpendDisputeManagement = other.getCardSpendDisputeManagement();
                    if (this$cardSpendDisputeManagement == null ? other$cardSpendDisputeManagement != null : !((Object)this$cardSpendDisputeManagement).equals(other$cardSpendDisputeManagement)) {
                        return false;
                    }
                    Boolean this$cardholderManagement = this.getCardholderManagement();
                    Boolean other$cardholderManagement = other.getCardholderManagement();
                    if (this$cardholderManagement == null ? other$cardholderManagement != null : !((Object)this$cardholderManagement).equals(other$cardholderManagement)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$spendControlManagement = this.getSpendControlManagement();
                    Boolean other$spendControlManagement = other.getSpendControlManagement();
                    return !(this$spendControlManagement == null ? other$spendControlManagement != null : !((Object)this$spendControlManagement).equals(other$spendControlManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $cardManagement = this.getCardManagement();
                    result = result * 59 + ($cardManagement == null ? 43 : ((Object)$cardManagement).hashCode());
                    Boolean $cardSpendDisputeManagement = this.getCardSpendDisputeManagement();
                    result = result * 59 + ($cardSpendDisputeManagement == null ? 43 : ((Object)$cardSpendDisputeManagement).hashCode());
                    Boolean $cardholderManagement = this.getCardholderManagement();
                    result = result * 59 + ($cardholderManagement == null ? 43 : ((Object)$cardholderManagement).hashCode());
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $spendControlManagement = this.getSpendControlManagement();
                    result = result * 59 + ($spendControlManagement == null ? 43 : ((Object)$spendControlManagement).hashCode());
                    return result;
                }
            }
        }

        public static class NotificationBanner
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NotificationBanner)) {
                    return false;
                }
                NotificationBanner other = (NotificationBanner)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NotificationBanner;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="external_account_collection")
                Boolean externalAccountCollection;

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getExternalAccountCollection() {
                    return this.externalAccountCollection;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setExternalAccountCollection(Boolean externalAccountCollection) {
                    this.externalAccountCollection = externalAccountCollection;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$externalAccountCollection = this.getExternalAccountCollection();
                    Boolean other$externalAccountCollection = other.getExternalAccountCollection();
                    return !(this$externalAccountCollection == null ? other$externalAccountCollection != null : !((Object)this$externalAccountCollection).equals(other$externalAccountCollection));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $externalAccountCollection = this.getExternalAccountCollection();
                    result = result * 59 + ($externalAccountCollection == null ? 43 : ((Object)$externalAccountCollection).hashCode());
                    return result;
                }
            }
        }

        public static class PaymentDetails
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentDetails)) {
                    return false;
                }
                PaymentDetails other = (PaymentDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="capture_payments")
                Boolean capturePayments;
                @SerializedName(value="destination_on_behalf_of_charge_management")
                Boolean destinationOnBehalfOfChargeManagement;
                @SerializedName(value="dispute_management")
                Boolean disputeManagement;
                @SerializedName(value="refund_management")
                Boolean refundManagement;

                @Generated
                public Boolean getCapturePayments() {
                    return this.capturePayments;
                }

                @Generated
                public Boolean getDestinationOnBehalfOfChargeManagement() {
                    return this.destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public Boolean getDisputeManagement() {
                    return this.disputeManagement;
                }

                @Generated
                public Boolean getRefundManagement() {
                    return this.refundManagement;
                }

                @Generated
                public void setCapturePayments(Boolean capturePayments) {
                    this.capturePayments = capturePayments;
                }

                @Generated
                public void setDestinationOnBehalfOfChargeManagement(Boolean destinationOnBehalfOfChargeManagement) {
                    this.destinationOnBehalfOfChargeManagement = destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public void setDisputeManagement(Boolean disputeManagement) {
                    this.disputeManagement = disputeManagement;
                }

                @Generated
                public void setRefundManagement(Boolean refundManagement) {
                    this.refundManagement = refundManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$capturePayments = this.getCapturePayments();
                    Boolean other$capturePayments = other.getCapturePayments();
                    if (this$capturePayments == null ? other$capturePayments != null : !((Object)this$capturePayments).equals(other$capturePayments)) {
                        return false;
                    }
                    Boolean this$destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    Boolean other$destinationOnBehalfOfChargeManagement = other.getDestinationOnBehalfOfChargeManagement();
                    if (this$destinationOnBehalfOfChargeManagement == null ? other$destinationOnBehalfOfChargeManagement != null : !((Object)this$destinationOnBehalfOfChargeManagement).equals(other$destinationOnBehalfOfChargeManagement)) {
                        return false;
                    }
                    Boolean this$disputeManagement = this.getDisputeManagement();
                    Boolean other$disputeManagement = other.getDisputeManagement();
                    if (this$disputeManagement == null ? other$disputeManagement != null : !((Object)this$disputeManagement).equals(other$disputeManagement)) {
                        return false;
                    }
                    Boolean this$refundManagement = this.getRefundManagement();
                    Boolean other$refundManagement = other.getRefundManagement();
                    return !(this$refundManagement == null ? other$refundManagement != null : !((Object)this$refundManagement).equals(other$refundManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $capturePayments = this.getCapturePayments();
                    result = result * 59 + ($capturePayments == null ? 43 : ((Object)$capturePayments).hashCode());
                    Boolean $destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    result = result * 59 + ($destinationOnBehalfOfChargeManagement == null ? 43 : ((Object)$destinationOnBehalfOfChargeManagement).hashCode());
                    Boolean $disputeManagement = this.getDisputeManagement();
                    result = result * 59 + ($disputeManagement == null ? 43 : ((Object)$disputeManagement).hashCode());
                    Boolean $refundManagement = this.getRefundManagement();
                    result = result * 59 + ($refundManagement == null ? 43 : ((Object)$refundManagement).hashCode());
                    return result;
                }
            }
        }

        public static class PaymentDisputes
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PaymentDisputes)) {
                    return false;
                }
                PaymentDisputes other = (PaymentDisputes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PaymentDisputes;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="destination_on_behalf_of_charge_management")
                Boolean destinationOnBehalfOfChargeManagement;
                @SerializedName(value="dispute_management")
                Boolean disputeManagement;
                @SerializedName(value="refund_management")
                Boolean refundManagement;

                @Generated
                public Boolean getDestinationOnBehalfOfChargeManagement() {
                    return this.destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public Boolean getDisputeManagement() {
                    return this.disputeManagement;
                }

                @Generated
                public Boolean getRefundManagement() {
                    return this.refundManagement;
                }

                @Generated
                public void setDestinationOnBehalfOfChargeManagement(Boolean destinationOnBehalfOfChargeManagement) {
                    this.destinationOnBehalfOfChargeManagement = destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public void setDisputeManagement(Boolean disputeManagement) {
                    this.disputeManagement = disputeManagement;
                }

                @Generated
                public void setRefundManagement(Boolean refundManagement) {
                    this.refundManagement = refundManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    Boolean other$destinationOnBehalfOfChargeManagement = other.getDestinationOnBehalfOfChargeManagement();
                    if (this$destinationOnBehalfOfChargeManagement == null ? other$destinationOnBehalfOfChargeManagement != null : !((Object)this$destinationOnBehalfOfChargeManagement).equals(other$destinationOnBehalfOfChargeManagement)) {
                        return false;
                    }
                    Boolean this$disputeManagement = this.getDisputeManagement();
                    Boolean other$disputeManagement = other.getDisputeManagement();
                    if (this$disputeManagement == null ? other$disputeManagement != null : !((Object)this$disputeManagement).equals(other$disputeManagement)) {
                        return false;
                    }
                    Boolean this$refundManagement = this.getRefundManagement();
                    Boolean other$refundManagement = other.getRefundManagement();
                    return !(this$refundManagement == null ? other$refundManagement != null : !((Object)this$refundManagement).equals(other$refundManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    result = result * 59 + ($destinationOnBehalfOfChargeManagement == null ? 43 : ((Object)$destinationOnBehalfOfChargeManagement).hashCode());
                    Boolean $disputeManagement = this.getDisputeManagement();
                    result = result * 59 + ($disputeManagement == null ? 43 : ((Object)$disputeManagement).hashCode());
                    Boolean $refundManagement = this.getRefundManagement();
                    result = result * 59 + ($refundManagement == null ? 43 : ((Object)$refundManagement).hashCode());
                    return result;
                }
            }
        }

        public static class Payments
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payments)) {
                    return false;
                }
                Payments other = (Payments)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payments;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="capture_payments")
                Boolean capturePayments;
                @SerializedName(value="destination_on_behalf_of_charge_management")
                Boolean destinationOnBehalfOfChargeManagement;
                @SerializedName(value="dispute_management")
                Boolean disputeManagement;
                @SerializedName(value="refund_management")
                Boolean refundManagement;

                @Generated
                public Boolean getCapturePayments() {
                    return this.capturePayments;
                }

                @Generated
                public Boolean getDestinationOnBehalfOfChargeManagement() {
                    return this.destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public Boolean getDisputeManagement() {
                    return this.disputeManagement;
                }

                @Generated
                public Boolean getRefundManagement() {
                    return this.refundManagement;
                }

                @Generated
                public void setCapturePayments(Boolean capturePayments) {
                    this.capturePayments = capturePayments;
                }

                @Generated
                public void setDestinationOnBehalfOfChargeManagement(Boolean destinationOnBehalfOfChargeManagement) {
                    this.destinationOnBehalfOfChargeManagement = destinationOnBehalfOfChargeManagement;
                }

                @Generated
                public void setDisputeManagement(Boolean disputeManagement) {
                    this.disputeManagement = disputeManagement;
                }

                @Generated
                public void setRefundManagement(Boolean refundManagement) {
                    this.refundManagement = refundManagement;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$capturePayments = this.getCapturePayments();
                    Boolean other$capturePayments = other.getCapturePayments();
                    if (this$capturePayments == null ? other$capturePayments != null : !((Object)this$capturePayments).equals(other$capturePayments)) {
                        return false;
                    }
                    Boolean this$destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    Boolean other$destinationOnBehalfOfChargeManagement = other.getDestinationOnBehalfOfChargeManagement();
                    if (this$destinationOnBehalfOfChargeManagement == null ? other$destinationOnBehalfOfChargeManagement != null : !((Object)this$destinationOnBehalfOfChargeManagement).equals(other$destinationOnBehalfOfChargeManagement)) {
                        return false;
                    }
                    Boolean this$disputeManagement = this.getDisputeManagement();
                    Boolean other$disputeManagement = other.getDisputeManagement();
                    if (this$disputeManagement == null ? other$disputeManagement != null : !((Object)this$disputeManagement).equals(other$disputeManagement)) {
                        return false;
                    }
                    Boolean this$refundManagement = this.getRefundManagement();
                    Boolean other$refundManagement = other.getRefundManagement();
                    return !(this$refundManagement == null ? other$refundManagement != null : !((Object)this$refundManagement).equals(other$refundManagement));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $capturePayments = this.getCapturePayments();
                    result = result * 59 + ($capturePayments == null ? 43 : ((Object)$capturePayments).hashCode());
                    Boolean $destinationOnBehalfOfChargeManagement = this.getDestinationOnBehalfOfChargeManagement();
                    result = result * 59 + ($destinationOnBehalfOfChargeManagement == null ? 43 : ((Object)$destinationOnBehalfOfChargeManagement).hashCode());
                    Boolean $disputeManagement = this.getDisputeManagement();
                    result = result * 59 + ($disputeManagement == null ? 43 : ((Object)$disputeManagement).hashCode());
                    Boolean $refundManagement = this.getRefundManagement();
                    result = result * 59 + ($refundManagement == null ? 43 : ((Object)$refundManagement).hashCode());
                    return result;
                }
            }
        }

        public static class Payouts
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payouts)) {
                    return false;
                }
                Payouts other = (Payouts)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payouts;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @SerializedName(value="disable_stripe_user_authentication")
                Boolean disableStripeUserAuthentication;
                @SerializedName(value="edit_payout_schedule")
                Boolean editPayoutSchedule;
                @SerializedName(value="external_account_collection")
                Boolean externalAccountCollection;
                @SerializedName(value="instant_payouts")
                Boolean instantPayouts;
                @SerializedName(value="standard_payouts")
                Boolean standardPayouts;

                @Generated
                public Boolean getDisableStripeUserAuthentication() {
                    return this.disableStripeUserAuthentication;
                }

                @Generated
                public Boolean getEditPayoutSchedule() {
                    return this.editPayoutSchedule;
                }

                @Generated
                public Boolean getExternalAccountCollection() {
                    return this.externalAccountCollection;
                }

                @Generated
                public Boolean getInstantPayouts() {
                    return this.instantPayouts;
                }

                @Generated
                public Boolean getStandardPayouts() {
                    return this.standardPayouts;
                }

                @Generated
                public void setDisableStripeUserAuthentication(Boolean disableStripeUserAuthentication) {
                    this.disableStripeUserAuthentication = disableStripeUserAuthentication;
                }

                @Generated
                public void setEditPayoutSchedule(Boolean editPayoutSchedule) {
                    this.editPayoutSchedule = editPayoutSchedule;
                }

                @Generated
                public void setExternalAccountCollection(Boolean externalAccountCollection) {
                    this.externalAccountCollection = externalAccountCollection;
                }

                @Generated
                public void setInstantPayouts(Boolean instantPayouts) {
                    this.instantPayouts = instantPayouts;
                }

                @Generated
                public void setStandardPayouts(Boolean standardPayouts) {
                    this.standardPayouts = standardPayouts;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Boolean this$disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    Boolean other$disableStripeUserAuthentication = other.getDisableStripeUserAuthentication();
                    if (this$disableStripeUserAuthentication == null ? other$disableStripeUserAuthentication != null : !((Object)this$disableStripeUserAuthentication).equals(other$disableStripeUserAuthentication)) {
                        return false;
                    }
                    Boolean this$editPayoutSchedule = this.getEditPayoutSchedule();
                    Boolean other$editPayoutSchedule = other.getEditPayoutSchedule();
                    if (this$editPayoutSchedule == null ? other$editPayoutSchedule != null : !((Object)this$editPayoutSchedule).equals(other$editPayoutSchedule)) {
                        return false;
                    }
                    Boolean this$externalAccountCollection = this.getExternalAccountCollection();
                    Boolean other$externalAccountCollection = other.getExternalAccountCollection();
                    if (this$externalAccountCollection == null ? other$externalAccountCollection != null : !((Object)this$externalAccountCollection).equals(other$externalAccountCollection)) {
                        return false;
                    }
                    Boolean this$instantPayouts = this.getInstantPayouts();
                    Boolean other$instantPayouts = other.getInstantPayouts();
                    if (this$instantPayouts == null ? other$instantPayouts != null : !((Object)this$instantPayouts).equals(other$instantPayouts)) {
                        return false;
                    }
                    Boolean this$standardPayouts = this.getStandardPayouts();
                    Boolean other$standardPayouts = other.getStandardPayouts();
                    return !(this$standardPayouts == null ? other$standardPayouts != null : !((Object)this$standardPayouts).equals(other$standardPayouts));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Boolean $disableStripeUserAuthentication = this.getDisableStripeUserAuthentication();
                    result = result * 59 + ($disableStripeUserAuthentication == null ? 43 : ((Object)$disableStripeUserAuthentication).hashCode());
                    Boolean $editPayoutSchedule = this.getEditPayoutSchedule();
                    result = result * 59 + ($editPayoutSchedule == null ? 43 : ((Object)$editPayoutSchedule).hashCode());
                    Boolean $externalAccountCollection = this.getExternalAccountCollection();
                    result = result * 59 + ($externalAccountCollection == null ? 43 : ((Object)$externalAccountCollection).hashCode());
                    Boolean $instantPayouts = this.getInstantPayouts();
                    result = result * 59 + ($instantPayouts == null ? 43 : ((Object)$instantPayouts).hashCode());
                    Boolean $standardPayouts = this.getStandardPayouts();
                    result = result * 59 + ($standardPayouts == null ? 43 : ((Object)$standardPayouts).hashCode());
                    return result;
                }
            }
        }

        public static class PayoutsList
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PayoutsList)) {
                    return false;
                }
                PayoutsList other = (PayoutsList)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PayoutsList;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }
        }

        public static class TaxRegistrations
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxRegistrations)) {
                    return false;
                }
                TaxRegistrations other = (TaxRegistrations)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxRegistrations;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }
        }

        public static class TaxSettings
        extends StripeObject {
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="features")
            Features features;

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Features getFeatures() {
                return this.features;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setFeatures(Features features) {
                this.features = features;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxSettings)) {
                    return false;
                }
                TaxSettings other = (TaxSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                Features this$features = this.getFeatures();
                Features other$features = other.getFeatures();
                return !(this$features == null ? other$features != null : !((Object)this$features).equals(other$features));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                Features $features = this.getFeatures();
                result = result * 59 + ($features == null ? 43 : ((Object)$features).hashCode());
                return result;
            }

            public static class Features
            extends StripeObject {
                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Features)) {
                        return false;
                    }
                    Features other = (Features)o;
                    return other.canEqual(this);
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Features;
                }

                @Generated
                public int hashCode() {
                    boolean result = true;
                    return 1;
                }
            }
        }
    }
}

