/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.tax;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.tax.RegistrationCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.tax.RegistrationCreateParams;
import com.stripe.param.tax.RegistrationListParams;
import com.stripe.param.tax.RegistrationRetrieveParams;
import com.stripe.param.tax.RegistrationUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Registration
extends ApiResource
implements HasId {
    @SerializedName(value="active_from")
    Long activeFrom;
    @SerializedName(value="country")
    String country;
    @SerializedName(value="country_options")
    CountryOptions countryOptions;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;

    public static Registration create(Map<String, Object> params) throws StripeException {
        return Registration.create(params, (RequestOptions)null);
    }

    public static Registration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public static Registration create(RegistrationCreateParams params) throws StripeException {
        return Registration.create(params, (RequestOptions)null);
    }

    public static Registration create(RegistrationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public static RegistrationCollection list(Map<String, Object> params) throws StripeException {
        return Registration.list(params, (RequestOptions)null);
    }

    public static RegistrationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RegistrationCollection)Registration.getGlobalResponseGetter().request(request, (Type)((Object)RegistrationCollection.class));
    }

    public static RegistrationCollection list(RegistrationListParams params) throws StripeException {
        return Registration.list(params, (RequestOptions)null);
    }

    public static RegistrationCollection list(RegistrationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/tax/registrations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RegistrationCollection)Registration.getGlobalResponseGetter().request(request, (Type)((Object)RegistrationCollection.class));
    }

    public static Registration retrieve(String id) throws StripeException {
        return Registration.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Registration retrieve(String id, RequestOptions options) throws StripeException {
        return Registration.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Registration retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public static Registration retrieve(String id, RegistrationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)Registration.getGlobalResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public Registration update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Registration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Registration)this.getResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    public Registration update(RegistrationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Registration update(RegistrationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/tax/registrations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Registration)this.getResponseGetter().request(request, (Type)((Object)Registration.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.countryOptions, responseGetter);
    }

    @Generated
    public Long getActiveFrom() {
        return this.activeFrom;
    }

    @Generated
    public String getCountry() {
        return this.country;
    }

    @Generated
    public CountryOptions getCountryOptions() {
        return this.countryOptions;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setActiveFrom(Long activeFrom) {
        this.activeFrom = activeFrom;
    }

    @Generated
    public void setCountry(String country) {
        this.country = country;
    }

    @Generated
    public void setCountryOptions(CountryOptions countryOptions) {
        this.countryOptions = countryOptions;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Registration)) {
            return false;
        }
        Registration other = (Registration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$activeFrom = this.getActiveFrom();
        Long other$activeFrom = other.getActiveFrom();
        if (this$activeFrom == null ? other$activeFrom != null : !((Object)this$activeFrom).equals(other$activeFrom)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$country = this.getCountry();
        String other$country = other.getCountry();
        if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
            return false;
        }
        CountryOptions this$countryOptions = this.getCountryOptions();
        CountryOptions other$countryOptions = other.getCountryOptions();
        if (this$countryOptions == null ? other$countryOptions != null : !((Object)this$countryOptions).equals(other$countryOptions)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Registration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $activeFrom = this.getActiveFrom();
        result = result * 59 + ($activeFrom == null ? 43 : ((Object)$activeFrom).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $country = this.getCountry();
        result = result * 59 + ($country == null ? 43 : $country.hashCode());
        CountryOptions $countryOptions = this.getCountryOptions();
        result = result * 59 + ($countryOptions == null ? 43 : ((Object)$countryOptions).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CountryOptions
    extends StripeObject {
        @SerializedName(value="ae")
        Ae ae;
        @SerializedName(value="al")
        Al al;
        @SerializedName(value="am")
        Am am;
        @SerializedName(value="ao")
        Ao ao;
        @SerializedName(value="at")
        At at;
        @SerializedName(value="au")
        Au au;
        @SerializedName(value="aw")
        Aw aw;
        @SerializedName(value="az")
        Az az;
        @SerializedName(value="ba")
        Ba ba;
        @SerializedName(value="bb")
        Bb bb;
        @SerializedName(value="bd")
        Bd bd;
        @SerializedName(value="be")
        Be be;
        @SerializedName(value="bf")
        Bf bf;
        @SerializedName(value="bg")
        Bg bg;
        @SerializedName(value="bh")
        Bh bh;
        @SerializedName(value="bj")
        Bj bj;
        @SerializedName(value="bs")
        Bs bs;
        @SerializedName(value="by")
        By by;
        @SerializedName(value="ca")
        Ca ca;
        @SerializedName(value="cd")
        Cd cd;
        @SerializedName(value="ch")
        Ch ch;
        @SerializedName(value="cl")
        Cl cl;
        @SerializedName(value="cm")
        Cm cm;
        @SerializedName(value="co")
        Co co;
        @SerializedName(value="cr")
        Cr cr;
        @SerializedName(value="cv")
        Cv cv;
        @SerializedName(value="cy")
        Cy cy;
        @SerializedName(value="cz")
        Cz cz;
        @SerializedName(value="de")
        De de;
        @SerializedName(value="dk")
        Dk dk;
        @SerializedName(value="ec")
        Ec ec;
        @SerializedName(value="ee")
        Ee ee;
        @SerializedName(value="eg")
        Eg eg;
        @SerializedName(value="es")
        Es es;
        @SerializedName(value="et")
        Et et;
        @SerializedName(value="fi")
        Fi fi;
        @SerializedName(value="fr")
        Fr fr;
        @SerializedName(value="gb")
        Gb gb;
        @SerializedName(value="ge")
        Ge ge;
        @SerializedName(value="gn")
        Gn gn;
        @SerializedName(value="gr")
        Gr gr;
        @SerializedName(value="hr")
        Hr hr;
        @SerializedName(value="hu")
        Hu hu;
        @SerializedName(value="id")
        Id id;
        @SerializedName(value="ie")
        Ie ie;
        @SerializedName(value="in")
        In in;
        @SerializedName(value="is")
        Is is;
        @SerializedName(value="it")
        It it;
        @SerializedName(value="jp")
        Jp jp;
        @SerializedName(value="ke")
        Ke ke;
        @SerializedName(value="kg")
        Kg kg;
        @SerializedName(value="kh")
        Kh kh;
        @SerializedName(value="kr")
        Kr kr;
        @SerializedName(value="kz")
        Kz kz;
        @SerializedName(value="la")
        La la;
        @SerializedName(value="lt")
        Lt lt;
        @SerializedName(value="lu")
        Lu lu;
        @SerializedName(value="lv")
        Lv lv;
        @SerializedName(value="ma")
        Ma ma;
        @SerializedName(value="md")
        Md md;
        @SerializedName(value="me")
        Me me;
        @SerializedName(value="mk")
        Mk mk;
        @SerializedName(value="mr")
        Mr mr;
        @SerializedName(value="mt")
        Mt mt;
        @SerializedName(value="mx")
        Mx mx;
        @SerializedName(value="my")
        My my;
        @SerializedName(value="ng")
        Ng ng;
        @SerializedName(value="nl")
        Nl nl;
        @SerializedName(value="no")
        No no;
        @SerializedName(value="np")
        Np np;
        @SerializedName(value="nz")
        Nz nz;
        @SerializedName(value="om")
        Om om;
        @SerializedName(value="pe")
        Pe pe;
        @SerializedName(value="ph")
        Ph ph;
        @SerializedName(value="pl")
        Pl pl;
        @SerializedName(value="pt")
        Pt pt;
        @SerializedName(value="ro")
        Ro ro;
        @SerializedName(value="rs")
        Rs rs;
        @SerializedName(value="ru")
        Ru ru;
        @SerializedName(value="sa")
        Sa sa;
        @SerializedName(value="se")
        Se se;
        @SerializedName(value="sg")
        Sg sg;
        @SerializedName(value="si")
        Si si;
        @SerializedName(value="sk")
        Sk sk;
        @SerializedName(value="sn")
        Sn sn;
        @SerializedName(value="sr")
        Sr sr;
        @SerializedName(value="th")
        Th th;
        @SerializedName(value="tj")
        Tj tj;
        @SerializedName(value="tr")
        Tr tr;
        @SerializedName(value="tz")
        Tz tz;
        @SerializedName(value="ua")
        Ua ua;
        @SerializedName(value="ug")
        Ug ug;
        @SerializedName(value="us")
        Us us;
        @SerializedName(value="uy")
        Uy uy;
        @SerializedName(value="uz")
        Uz uz;
        @SerializedName(value="vn")
        Vn vn;
        @SerializedName(value="za")
        Za za;
        @SerializedName(value="zm")
        Zm zm;
        @SerializedName(value="zw")
        Zw zw;

        @Generated
        public Ae getAe() {
            return this.ae;
        }

        @Generated
        public Al getAl() {
            return this.al;
        }

        @Generated
        public Am getAm() {
            return this.am;
        }

        @Generated
        public Ao getAo() {
            return this.ao;
        }

        @Generated
        public At getAt() {
            return this.at;
        }

        @Generated
        public Au getAu() {
            return this.au;
        }

        @Generated
        public Aw getAw() {
            return this.aw;
        }

        @Generated
        public Az getAz() {
            return this.az;
        }

        @Generated
        public Ba getBa() {
            return this.ba;
        }

        @Generated
        public Bb getBb() {
            return this.bb;
        }

        @Generated
        public Bd getBd() {
            return this.bd;
        }

        @Generated
        public Be getBe() {
            return this.be;
        }

        @Generated
        public Bf getBf() {
            return this.bf;
        }

        @Generated
        public Bg getBg() {
            return this.bg;
        }

        @Generated
        public Bh getBh() {
            return this.bh;
        }

        @Generated
        public Bj getBj() {
            return this.bj;
        }

        @Generated
        public Bs getBs() {
            return this.bs;
        }

        @Generated
        public By getBy() {
            return this.by;
        }

        @Generated
        public Ca getCa() {
            return this.ca;
        }

        @Generated
        public Cd getCd() {
            return this.cd;
        }

        @Generated
        public Ch getCh() {
            return this.ch;
        }

        @Generated
        public Cl getCl() {
            return this.cl;
        }

        @Generated
        public Cm getCm() {
            return this.cm;
        }

        @Generated
        public Co getCo() {
            return this.co;
        }

        @Generated
        public Cr getCr() {
            return this.cr;
        }

        @Generated
        public Cv getCv() {
            return this.cv;
        }

        @Generated
        public Cy getCy() {
            return this.cy;
        }

        @Generated
        public Cz getCz() {
            return this.cz;
        }

        @Generated
        public De getDe() {
            return this.de;
        }

        @Generated
        public Dk getDk() {
            return this.dk;
        }

        @Generated
        public Ec getEc() {
            return this.ec;
        }

        @Generated
        public Ee getEe() {
            return this.ee;
        }

        @Generated
        public Eg getEg() {
            return this.eg;
        }

        @Generated
        public Es getEs() {
            return this.es;
        }

        @Generated
        public Et getEt() {
            return this.et;
        }

        @Generated
        public Fi getFi() {
            return this.fi;
        }

        @Generated
        public Fr getFr() {
            return this.fr;
        }

        @Generated
        public Gb getGb() {
            return this.gb;
        }

        @Generated
        public Ge getGe() {
            return this.ge;
        }

        @Generated
        public Gn getGn() {
            return this.gn;
        }

        @Generated
        public Gr getGr() {
            return this.gr;
        }

        @Generated
        public Hr getHr() {
            return this.hr;
        }

        @Generated
        public Hu getHu() {
            return this.hu;
        }

        @Generated
        public Id getId() {
            return this.id;
        }

        @Generated
        public Ie getIe() {
            return this.ie;
        }

        @Generated
        public In getIn() {
            return this.in;
        }

        @Generated
        public Is getIs() {
            return this.is;
        }

        @Generated
        public It getIt() {
            return this.it;
        }

        @Generated
        public Jp getJp() {
            return this.jp;
        }

        @Generated
        public Ke getKe() {
            return this.ke;
        }

        @Generated
        public Kg getKg() {
            return this.kg;
        }

        @Generated
        public Kh getKh() {
            return this.kh;
        }

        @Generated
        public Kr getKr() {
            return this.kr;
        }

        @Generated
        public Kz getKz() {
            return this.kz;
        }

        @Generated
        public La getLa() {
            return this.la;
        }

        @Generated
        public Lt getLt() {
            return this.lt;
        }

        @Generated
        public Lu getLu() {
            return this.lu;
        }

        @Generated
        public Lv getLv() {
            return this.lv;
        }

        @Generated
        public Ma getMa() {
            return this.ma;
        }

        @Generated
        public Md getMd() {
            return this.md;
        }

        @Generated
        public Me getMe() {
            return this.me;
        }

        @Generated
        public Mk getMk() {
            return this.mk;
        }

        @Generated
        public Mr getMr() {
            return this.mr;
        }

        @Generated
        public Mt getMt() {
            return this.mt;
        }

        @Generated
        public Mx getMx() {
            return this.mx;
        }

        @Generated
        public My getMy() {
            return this.my;
        }

        @Generated
        public Ng getNg() {
            return this.ng;
        }

        @Generated
        public Nl getNl() {
            return this.nl;
        }

        @Generated
        public No getNo() {
            return this.no;
        }

        @Generated
        public Np getNp() {
            return this.np;
        }

        @Generated
        public Nz getNz() {
            return this.nz;
        }

        @Generated
        public Om getOm() {
            return this.om;
        }

        @Generated
        public Pe getPe() {
            return this.pe;
        }

        @Generated
        public Ph getPh() {
            return this.ph;
        }

        @Generated
        public Pl getPl() {
            return this.pl;
        }

        @Generated
        public Pt getPt() {
            return this.pt;
        }

        @Generated
        public Ro getRo() {
            return this.ro;
        }

        @Generated
        public Rs getRs() {
            return this.rs;
        }

        @Generated
        public Ru getRu() {
            return this.ru;
        }

        @Generated
        public Sa getSa() {
            return this.sa;
        }

        @Generated
        public Se getSe() {
            return this.se;
        }

        @Generated
        public Sg getSg() {
            return this.sg;
        }

        @Generated
        public Si getSi() {
            return this.si;
        }

        @Generated
        public Sk getSk() {
            return this.sk;
        }

        @Generated
        public Sn getSn() {
            return this.sn;
        }

        @Generated
        public Sr getSr() {
            return this.sr;
        }

        @Generated
        public Th getTh() {
            return this.th;
        }

        @Generated
        public Tj getTj() {
            return this.tj;
        }

        @Generated
        public Tr getTr() {
            return this.tr;
        }

        @Generated
        public Tz getTz() {
            return this.tz;
        }

        @Generated
        public Ua getUa() {
            return this.ua;
        }

        @Generated
        public Ug getUg() {
            return this.ug;
        }

        @Generated
        public Us getUs() {
            return this.us;
        }

        @Generated
        public Uy getUy() {
            return this.uy;
        }

        @Generated
        public Uz getUz() {
            return this.uz;
        }

        @Generated
        public Vn getVn() {
            return this.vn;
        }

        @Generated
        public Za getZa() {
            return this.za;
        }

        @Generated
        public Zm getZm() {
            return this.zm;
        }

        @Generated
        public Zw getZw() {
            return this.zw;
        }

        @Generated
        public void setAe(Ae ae) {
            this.ae = ae;
        }

        @Generated
        public void setAl(Al al) {
            this.al = al;
        }

        @Generated
        public void setAm(Am am) {
            this.am = am;
        }

        @Generated
        public void setAo(Ao ao) {
            this.ao = ao;
        }

        @Generated
        public void setAt(At at) {
            this.at = at;
        }

        @Generated
        public void setAu(Au au) {
            this.au = au;
        }

        @Generated
        public void setAw(Aw aw) {
            this.aw = aw;
        }

        @Generated
        public void setAz(Az az) {
            this.az = az;
        }

        @Generated
        public void setBa(Ba ba) {
            this.ba = ba;
        }

        @Generated
        public void setBb(Bb bb) {
            this.bb = bb;
        }

        @Generated
        public void setBd(Bd bd) {
            this.bd = bd;
        }

        @Generated
        public void setBe(Be be) {
            this.be = be;
        }

        @Generated
        public void setBf(Bf bf) {
            this.bf = bf;
        }

        @Generated
        public void setBg(Bg bg) {
            this.bg = bg;
        }

        @Generated
        public void setBh(Bh bh) {
            this.bh = bh;
        }

        @Generated
        public void setBj(Bj bj) {
            this.bj = bj;
        }

        @Generated
        public void setBs(Bs bs) {
            this.bs = bs;
        }

        @Generated
        public void setBy(By by) {
            this.by = by;
        }

        @Generated
        public void setCa(Ca ca) {
            this.ca = ca;
        }

        @Generated
        public void setCd(Cd cd) {
            this.cd = cd;
        }

        @Generated
        public void setCh(Ch ch) {
            this.ch = ch;
        }

        @Generated
        public void setCl(Cl cl) {
            this.cl = cl;
        }

        @Generated
        public void setCm(Cm cm) {
            this.cm = cm;
        }

        @Generated
        public void setCo(Co co) {
            this.co = co;
        }

        @Generated
        public void setCr(Cr cr) {
            this.cr = cr;
        }

        @Generated
        public void setCv(Cv cv) {
            this.cv = cv;
        }

        @Generated
        public void setCy(Cy cy) {
            this.cy = cy;
        }

        @Generated
        public void setCz(Cz cz) {
            this.cz = cz;
        }

        @Generated
        public void setDe(De de) {
            this.de = de;
        }

        @Generated
        public void setDk(Dk dk) {
            this.dk = dk;
        }

        @Generated
        public void setEc(Ec ec) {
            this.ec = ec;
        }

        @Generated
        public void setEe(Ee ee) {
            this.ee = ee;
        }

        @Generated
        public void setEg(Eg eg) {
            this.eg = eg;
        }

        @Generated
        public void setEs(Es es) {
            this.es = es;
        }

        @Generated
        public void setEt(Et et) {
            this.et = et;
        }

        @Generated
        public void setFi(Fi fi) {
            this.fi = fi;
        }

        @Generated
        public void setFr(Fr fr) {
            this.fr = fr;
        }

        @Generated
        public void setGb(Gb gb) {
            this.gb = gb;
        }

        @Generated
        public void setGe(Ge ge) {
            this.ge = ge;
        }

        @Generated
        public void setGn(Gn gn) {
            this.gn = gn;
        }

        @Generated
        public void setGr(Gr gr) {
            this.gr = gr;
        }

        @Generated
        public void setHr(Hr hr) {
            this.hr = hr;
        }

        @Generated
        public void setHu(Hu hu) {
            this.hu = hu;
        }

        @Generated
        public void setId(Id id) {
            this.id = id;
        }

        @Generated
        public void setIe(Ie ie) {
            this.ie = ie;
        }

        @Generated
        public void setIn(In in) {
            this.in = in;
        }

        @Generated
        public void setIs(Is is) {
            this.is = is;
        }

        @Generated
        public void setIt(It it) {
            this.it = it;
        }

        @Generated
        public void setJp(Jp jp) {
            this.jp = jp;
        }

        @Generated
        public void setKe(Ke ke) {
            this.ke = ke;
        }

        @Generated
        public void setKg(Kg kg) {
            this.kg = kg;
        }

        @Generated
        public void setKh(Kh kh) {
            this.kh = kh;
        }

        @Generated
        public void setKr(Kr kr) {
            this.kr = kr;
        }

        @Generated
        public void setKz(Kz kz) {
            this.kz = kz;
        }

        @Generated
        public void setLa(La la) {
            this.la = la;
        }

        @Generated
        public void setLt(Lt lt) {
            this.lt = lt;
        }

        @Generated
        public void setLu(Lu lu) {
            this.lu = lu;
        }

        @Generated
        public void setLv(Lv lv) {
            this.lv = lv;
        }

        @Generated
        public void setMa(Ma ma) {
            this.ma = ma;
        }

        @Generated
        public void setMd(Md md) {
            this.md = md;
        }

        @Generated
        public void setMe(Me me) {
            this.me = me;
        }

        @Generated
        public void setMk(Mk mk) {
            this.mk = mk;
        }

        @Generated
        public void setMr(Mr mr) {
            this.mr = mr;
        }

        @Generated
        public void setMt(Mt mt) {
            this.mt = mt;
        }

        @Generated
        public void setMx(Mx mx) {
            this.mx = mx;
        }

        @Generated
        public void setMy(My my) {
            this.my = my;
        }

        @Generated
        public void setNg(Ng ng) {
            this.ng = ng;
        }

        @Generated
        public void setNl(Nl nl) {
            this.nl = nl;
        }

        @Generated
        public void setNo(No no) {
            this.no = no;
        }

        @Generated
        public void setNp(Np np) {
            this.np = np;
        }

        @Generated
        public void setNz(Nz nz) {
            this.nz = nz;
        }

        @Generated
        public void setOm(Om om) {
            this.om = om;
        }

        @Generated
        public void setPe(Pe pe) {
            this.pe = pe;
        }

        @Generated
        public void setPh(Ph ph) {
            this.ph = ph;
        }

        @Generated
        public void setPl(Pl pl) {
            this.pl = pl;
        }

        @Generated
        public void setPt(Pt pt) {
            this.pt = pt;
        }

        @Generated
        public void setRo(Ro ro) {
            this.ro = ro;
        }

        @Generated
        public void setRs(Rs rs) {
            this.rs = rs;
        }

        @Generated
        public void setRu(Ru ru) {
            this.ru = ru;
        }

        @Generated
        public void setSa(Sa sa) {
            this.sa = sa;
        }

        @Generated
        public void setSe(Se se) {
            this.se = se;
        }

        @Generated
        public void setSg(Sg sg) {
            this.sg = sg;
        }

        @Generated
        public void setSi(Si si) {
            this.si = si;
        }

        @Generated
        public void setSk(Sk sk) {
            this.sk = sk;
        }

        @Generated
        public void setSn(Sn sn) {
            this.sn = sn;
        }

        @Generated
        public void setSr(Sr sr) {
            this.sr = sr;
        }

        @Generated
        public void setTh(Th th) {
            this.th = th;
        }

        @Generated
        public void setTj(Tj tj) {
            this.tj = tj;
        }

        @Generated
        public void setTr(Tr tr) {
            this.tr = tr;
        }

        @Generated
        public void setTz(Tz tz) {
            this.tz = tz;
        }

        @Generated
        public void setUa(Ua ua) {
            this.ua = ua;
        }

        @Generated
        public void setUg(Ug ug) {
            this.ug = ug;
        }

        @Generated
        public void setUs(Us us) {
            this.us = us;
        }

        @Generated
        public void setUy(Uy uy) {
            this.uy = uy;
        }

        @Generated
        public void setUz(Uz uz) {
            this.uz = uz;
        }

        @Generated
        public void setVn(Vn vn) {
            this.vn = vn;
        }

        @Generated
        public void setZa(Za za) {
            this.za = za;
        }

        @Generated
        public void setZm(Zm zm) {
            this.zm = zm;
        }

        @Generated
        public void setZw(Zw zw) {
            this.zw = zw;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CountryOptions)) {
                return false;
            }
            CountryOptions other = (CountryOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Ae this$ae = this.getAe();
            Ae other$ae = other.getAe();
            if (this$ae == null ? other$ae != null : !((Object)this$ae).equals(other$ae)) {
                return false;
            }
            Al this$al = this.getAl();
            Al other$al = other.getAl();
            if (this$al == null ? other$al != null : !((Object)this$al).equals(other$al)) {
                return false;
            }
            Am this$am = this.getAm();
            Am other$am = other.getAm();
            if (this$am == null ? other$am != null : !((Object)this$am).equals(other$am)) {
                return false;
            }
            Ao this$ao = this.getAo();
            Ao other$ao = other.getAo();
            if (this$ao == null ? other$ao != null : !((Object)this$ao).equals(other$ao)) {
                return false;
            }
            At this$at = this.getAt();
            At other$at = other.getAt();
            if (this$at == null ? other$at != null : !((Object)this$at).equals(other$at)) {
                return false;
            }
            Au this$au = this.getAu();
            Au other$au = other.getAu();
            if (this$au == null ? other$au != null : !((Object)this$au).equals(other$au)) {
                return false;
            }
            Aw this$aw = this.getAw();
            Aw other$aw = other.getAw();
            if (this$aw == null ? other$aw != null : !((Object)this$aw).equals(other$aw)) {
                return false;
            }
            Az this$az = this.getAz();
            Az other$az = other.getAz();
            if (this$az == null ? other$az != null : !((Object)this$az).equals(other$az)) {
                return false;
            }
            Ba this$ba = this.getBa();
            Ba other$ba = other.getBa();
            if (this$ba == null ? other$ba != null : !((Object)this$ba).equals(other$ba)) {
                return false;
            }
            Bb this$bb = this.getBb();
            Bb other$bb = other.getBb();
            if (this$bb == null ? other$bb != null : !((Object)this$bb).equals(other$bb)) {
                return false;
            }
            Bd this$bd = this.getBd();
            Bd other$bd = other.getBd();
            if (this$bd == null ? other$bd != null : !((Object)this$bd).equals(other$bd)) {
                return false;
            }
            Be this$be = this.getBe();
            Be other$be = other.getBe();
            if (this$be == null ? other$be != null : !((Object)this$be).equals(other$be)) {
                return false;
            }
            Bf this$bf = this.getBf();
            Bf other$bf = other.getBf();
            if (this$bf == null ? other$bf != null : !((Object)this$bf).equals(other$bf)) {
                return false;
            }
            Bg this$bg = this.getBg();
            Bg other$bg = other.getBg();
            if (this$bg == null ? other$bg != null : !((Object)this$bg).equals(other$bg)) {
                return false;
            }
            Bh this$bh = this.getBh();
            Bh other$bh = other.getBh();
            if (this$bh == null ? other$bh != null : !((Object)this$bh).equals(other$bh)) {
                return false;
            }
            Bj this$bj = this.getBj();
            Bj other$bj = other.getBj();
            if (this$bj == null ? other$bj != null : !((Object)this$bj).equals(other$bj)) {
                return false;
            }
            Bs this$bs = this.getBs();
            Bs other$bs = other.getBs();
            if (this$bs == null ? other$bs != null : !((Object)this$bs).equals(other$bs)) {
                return false;
            }
            By this$by = this.getBy();
            By other$by = other.getBy();
            if (this$by == null ? other$by != null : !((Object)this$by).equals(other$by)) {
                return false;
            }
            Ca this$ca = this.getCa();
            Ca other$ca = other.getCa();
            if (this$ca == null ? other$ca != null : !((Object)this$ca).equals(other$ca)) {
                return false;
            }
            Cd this$cd = this.getCd();
            Cd other$cd = other.getCd();
            if (this$cd == null ? other$cd != null : !((Object)this$cd).equals(other$cd)) {
                return false;
            }
            Ch this$ch = this.getCh();
            Ch other$ch = other.getCh();
            if (this$ch == null ? other$ch != null : !((Object)this$ch).equals(other$ch)) {
                return false;
            }
            Cl this$cl = this.getCl();
            Cl other$cl = other.getCl();
            if (this$cl == null ? other$cl != null : !((Object)this$cl).equals(other$cl)) {
                return false;
            }
            Cm this$cm = this.getCm();
            Cm other$cm = other.getCm();
            if (this$cm == null ? other$cm != null : !((Object)this$cm).equals(other$cm)) {
                return false;
            }
            Co this$co = this.getCo();
            Co other$co = other.getCo();
            if (this$co == null ? other$co != null : !((Object)this$co).equals(other$co)) {
                return false;
            }
            Cr this$cr = this.getCr();
            Cr other$cr = other.getCr();
            if (this$cr == null ? other$cr != null : !((Object)this$cr).equals(other$cr)) {
                return false;
            }
            Cv this$cv = this.getCv();
            Cv other$cv = other.getCv();
            if (this$cv == null ? other$cv != null : !((Object)this$cv).equals(other$cv)) {
                return false;
            }
            Cy this$cy = this.getCy();
            Cy other$cy = other.getCy();
            if (this$cy == null ? other$cy != null : !((Object)this$cy).equals(other$cy)) {
                return false;
            }
            Cz this$cz = this.getCz();
            Cz other$cz = other.getCz();
            if (this$cz == null ? other$cz != null : !((Object)this$cz).equals(other$cz)) {
                return false;
            }
            De this$de = this.getDe();
            De other$de = other.getDe();
            if (this$de == null ? other$de != null : !((Object)this$de).equals(other$de)) {
                return false;
            }
            Dk this$dk = this.getDk();
            Dk other$dk = other.getDk();
            if (this$dk == null ? other$dk != null : !((Object)this$dk).equals(other$dk)) {
                return false;
            }
            Ec this$ec = this.getEc();
            Ec other$ec = other.getEc();
            if (this$ec == null ? other$ec != null : !((Object)this$ec).equals(other$ec)) {
                return false;
            }
            Ee this$ee = this.getEe();
            Ee other$ee = other.getEe();
            if (this$ee == null ? other$ee != null : !((Object)this$ee).equals(other$ee)) {
                return false;
            }
            Eg this$eg = this.getEg();
            Eg other$eg = other.getEg();
            if (this$eg == null ? other$eg != null : !((Object)this$eg).equals(other$eg)) {
                return false;
            }
            Es this$es = this.getEs();
            Es other$es = other.getEs();
            if (this$es == null ? other$es != null : !((Object)this$es).equals(other$es)) {
                return false;
            }
            Et this$et = this.getEt();
            Et other$et = other.getEt();
            if (this$et == null ? other$et != null : !((Object)this$et).equals(other$et)) {
                return false;
            }
            Fi this$fi = this.getFi();
            Fi other$fi = other.getFi();
            if (this$fi == null ? other$fi != null : !((Object)this$fi).equals(other$fi)) {
                return false;
            }
            Fr this$fr = this.getFr();
            Fr other$fr = other.getFr();
            if (this$fr == null ? other$fr != null : !((Object)this$fr).equals(other$fr)) {
                return false;
            }
            Gb this$gb = this.getGb();
            Gb other$gb = other.getGb();
            if (this$gb == null ? other$gb != null : !((Object)this$gb).equals(other$gb)) {
                return false;
            }
            Ge this$ge = this.getGe();
            Ge other$ge = other.getGe();
            if (this$ge == null ? other$ge != null : !((Object)this$ge).equals(other$ge)) {
                return false;
            }
            Gn this$gn = this.getGn();
            Gn other$gn = other.getGn();
            if (this$gn == null ? other$gn != null : !((Object)this$gn).equals(other$gn)) {
                return false;
            }
            Gr this$gr = this.getGr();
            Gr other$gr = other.getGr();
            if (this$gr == null ? other$gr != null : !((Object)this$gr).equals(other$gr)) {
                return false;
            }
            Hr this$hr = this.getHr();
            Hr other$hr = other.getHr();
            if (this$hr == null ? other$hr != null : !((Object)this$hr).equals(other$hr)) {
                return false;
            }
            Hu this$hu = this.getHu();
            Hu other$hu = other.getHu();
            if (this$hu == null ? other$hu != null : !((Object)this$hu).equals(other$hu)) {
                return false;
            }
            Id this$id = this.getId();
            Id other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Ie this$ie = this.getIe();
            Ie other$ie = other.getIe();
            if (this$ie == null ? other$ie != null : !((Object)this$ie).equals(other$ie)) {
                return false;
            }
            In this$in = this.getIn();
            In other$in = other.getIn();
            if (this$in == null ? other$in != null : !((Object)this$in).equals(other$in)) {
                return false;
            }
            Is this$is = this.getIs();
            Is other$is = other.getIs();
            if (this$is == null ? other$is != null : !((Object)this$is).equals(other$is)) {
                return false;
            }
            It this$it = this.getIt();
            It other$it = other.getIt();
            if (this$it == null ? other$it != null : !((Object)this$it).equals(other$it)) {
                return false;
            }
            Jp this$jp = this.getJp();
            Jp other$jp = other.getJp();
            if (this$jp == null ? other$jp != null : !((Object)this$jp).equals(other$jp)) {
                return false;
            }
            Ke this$ke = this.getKe();
            Ke other$ke = other.getKe();
            if (this$ke == null ? other$ke != null : !((Object)this$ke).equals(other$ke)) {
                return false;
            }
            Kg this$kg = this.getKg();
            Kg other$kg = other.getKg();
            if (this$kg == null ? other$kg != null : !((Object)this$kg).equals(other$kg)) {
                return false;
            }
            Kh this$kh = this.getKh();
            Kh other$kh = other.getKh();
            if (this$kh == null ? other$kh != null : !((Object)this$kh).equals(other$kh)) {
                return false;
            }
            Kr this$kr = this.getKr();
            Kr other$kr = other.getKr();
            if (this$kr == null ? other$kr != null : !((Object)this$kr).equals(other$kr)) {
                return false;
            }
            Kz this$kz = this.getKz();
            Kz other$kz = other.getKz();
            if (this$kz == null ? other$kz != null : !((Object)this$kz).equals(other$kz)) {
                return false;
            }
            La this$la = this.getLa();
            La other$la = other.getLa();
            if (this$la == null ? other$la != null : !((Object)this$la).equals(other$la)) {
                return false;
            }
            Lt this$lt = this.getLt();
            Lt other$lt = other.getLt();
            if (this$lt == null ? other$lt != null : !((Object)this$lt).equals(other$lt)) {
                return false;
            }
            Lu this$lu = this.getLu();
            Lu other$lu = other.getLu();
            if (this$lu == null ? other$lu != null : !((Object)this$lu).equals(other$lu)) {
                return false;
            }
            Lv this$lv = this.getLv();
            Lv other$lv = other.getLv();
            if (this$lv == null ? other$lv != null : !((Object)this$lv).equals(other$lv)) {
                return false;
            }
            Ma this$ma = this.getMa();
            Ma other$ma = other.getMa();
            if (this$ma == null ? other$ma != null : !((Object)this$ma).equals(other$ma)) {
                return false;
            }
            Md this$md = this.getMd();
            Md other$md = other.getMd();
            if (this$md == null ? other$md != null : !((Object)this$md).equals(other$md)) {
                return false;
            }
            Me this$me = this.getMe();
            Me other$me = other.getMe();
            if (this$me == null ? other$me != null : !((Object)this$me).equals(other$me)) {
                return false;
            }
            Mk this$mk = this.getMk();
            Mk other$mk = other.getMk();
            if (this$mk == null ? other$mk != null : !((Object)this$mk).equals(other$mk)) {
                return false;
            }
            Mr this$mr = this.getMr();
            Mr other$mr = other.getMr();
            if (this$mr == null ? other$mr != null : !((Object)this$mr).equals(other$mr)) {
                return false;
            }
            Mt this$mt = this.getMt();
            Mt other$mt = other.getMt();
            if (this$mt == null ? other$mt != null : !((Object)this$mt).equals(other$mt)) {
                return false;
            }
            Mx this$mx = this.getMx();
            Mx other$mx = other.getMx();
            if (this$mx == null ? other$mx != null : !((Object)this$mx).equals(other$mx)) {
                return false;
            }
            My this$my = this.getMy();
            My other$my = other.getMy();
            if (this$my == null ? other$my != null : !((Object)this$my).equals(other$my)) {
                return false;
            }
            Ng this$ng = this.getNg();
            Ng other$ng = other.getNg();
            if (this$ng == null ? other$ng != null : !((Object)this$ng).equals(other$ng)) {
                return false;
            }
            Nl this$nl = this.getNl();
            Nl other$nl = other.getNl();
            if (this$nl == null ? other$nl != null : !((Object)this$nl).equals(other$nl)) {
                return false;
            }
            No this$no = this.getNo();
            No other$no = other.getNo();
            if (this$no == null ? other$no != null : !((Object)this$no).equals(other$no)) {
                return false;
            }
            Np this$np = this.getNp();
            Np other$np = other.getNp();
            if (this$np == null ? other$np != null : !((Object)this$np).equals(other$np)) {
                return false;
            }
            Nz this$nz = this.getNz();
            Nz other$nz = other.getNz();
            if (this$nz == null ? other$nz != null : !((Object)this$nz).equals(other$nz)) {
                return false;
            }
            Om this$om = this.getOm();
            Om other$om = other.getOm();
            if (this$om == null ? other$om != null : !((Object)this$om).equals(other$om)) {
                return false;
            }
            Pe this$pe = this.getPe();
            Pe other$pe = other.getPe();
            if (this$pe == null ? other$pe != null : !((Object)this$pe).equals(other$pe)) {
                return false;
            }
            Ph this$ph = this.getPh();
            Ph other$ph = other.getPh();
            if (this$ph == null ? other$ph != null : !((Object)this$ph).equals(other$ph)) {
                return false;
            }
            Pl this$pl = this.getPl();
            Pl other$pl = other.getPl();
            if (this$pl == null ? other$pl != null : !((Object)this$pl).equals(other$pl)) {
                return false;
            }
            Pt this$pt = this.getPt();
            Pt other$pt = other.getPt();
            if (this$pt == null ? other$pt != null : !((Object)this$pt).equals(other$pt)) {
                return false;
            }
            Ro this$ro = this.getRo();
            Ro other$ro = other.getRo();
            if (this$ro == null ? other$ro != null : !((Object)this$ro).equals(other$ro)) {
                return false;
            }
            Rs this$rs = this.getRs();
            Rs other$rs = other.getRs();
            if (this$rs == null ? other$rs != null : !((Object)this$rs).equals(other$rs)) {
                return false;
            }
            Ru this$ru = this.getRu();
            Ru other$ru = other.getRu();
            if (this$ru == null ? other$ru != null : !((Object)this$ru).equals(other$ru)) {
                return false;
            }
            Sa this$sa = this.getSa();
            Sa other$sa = other.getSa();
            if (this$sa == null ? other$sa != null : !((Object)this$sa).equals(other$sa)) {
                return false;
            }
            Se this$se = this.getSe();
            Se other$se = other.getSe();
            if (this$se == null ? other$se != null : !((Object)this$se).equals(other$se)) {
                return false;
            }
            Sg this$sg = this.getSg();
            Sg other$sg = other.getSg();
            if (this$sg == null ? other$sg != null : !((Object)this$sg).equals(other$sg)) {
                return false;
            }
            Si this$si = this.getSi();
            Si other$si = other.getSi();
            if (this$si == null ? other$si != null : !((Object)this$si).equals(other$si)) {
                return false;
            }
            Sk this$sk = this.getSk();
            Sk other$sk = other.getSk();
            if (this$sk == null ? other$sk != null : !((Object)this$sk).equals(other$sk)) {
                return false;
            }
            Sn this$sn = this.getSn();
            Sn other$sn = other.getSn();
            if (this$sn == null ? other$sn != null : !((Object)this$sn).equals(other$sn)) {
                return false;
            }
            Sr this$sr = this.getSr();
            Sr other$sr = other.getSr();
            if (this$sr == null ? other$sr != null : !((Object)this$sr).equals(other$sr)) {
                return false;
            }
            Th this$th = this.getTh();
            Th other$th = other.getTh();
            if (this$th == null ? other$th != null : !((Object)this$th).equals(other$th)) {
                return false;
            }
            Tj this$tj = this.getTj();
            Tj other$tj = other.getTj();
            if (this$tj == null ? other$tj != null : !((Object)this$tj).equals(other$tj)) {
                return false;
            }
            Tr this$tr = this.getTr();
            Tr other$tr = other.getTr();
            if (this$tr == null ? other$tr != null : !((Object)this$tr).equals(other$tr)) {
                return false;
            }
            Tz this$tz = this.getTz();
            Tz other$tz = other.getTz();
            if (this$tz == null ? other$tz != null : !((Object)this$tz).equals(other$tz)) {
                return false;
            }
            Ua this$ua = this.getUa();
            Ua other$ua = other.getUa();
            if (this$ua == null ? other$ua != null : !((Object)this$ua).equals(other$ua)) {
                return false;
            }
            Ug this$ug = this.getUg();
            Ug other$ug = other.getUg();
            if (this$ug == null ? other$ug != null : !((Object)this$ug).equals(other$ug)) {
                return false;
            }
            Us this$us = this.getUs();
            Us other$us = other.getUs();
            if (this$us == null ? other$us != null : !((Object)this$us).equals(other$us)) {
                return false;
            }
            Uy this$uy = this.getUy();
            Uy other$uy = other.getUy();
            if (this$uy == null ? other$uy != null : !((Object)this$uy).equals(other$uy)) {
                return false;
            }
            Uz this$uz = this.getUz();
            Uz other$uz = other.getUz();
            if (this$uz == null ? other$uz != null : !((Object)this$uz).equals(other$uz)) {
                return false;
            }
            Vn this$vn = this.getVn();
            Vn other$vn = other.getVn();
            if (this$vn == null ? other$vn != null : !((Object)this$vn).equals(other$vn)) {
                return false;
            }
            Za this$za = this.getZa();
            Za other$za = other.getZa();
            if (this$za == null ? other$za != null : !((Object)this$za).equals(other$za)) {
                return false;
            }
            Zm this$zm = this.getZm();
            Zm other$zm = other.getZm();
            if (this$zm == null ? other$zm != null : !((Object)this$zm).equals(other$zm)) {
                return false;
            }
            Zw this$zw = this.getZw();
            Zw other$zw = other.getZw();
            return !(this$zw == null ? other$zw != null : !((Object)this$zw).equals(other$zw));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CountryOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Ae $ae = this.getAe();
            result = result * 59 + ($ae == null ? 43 : ((Object)$ae).hashCode());
            Al $al = this.getAl();
            result = result * 59 + ($al == null ? 43 : ((Object)$al).hashCode());
            Am $am = this.getAm();
            result = result * 59 + ($am == null ? 43 : ((Object)$am).hashCode());
            Ao $ao = this.getAo();
            result = result * 59 + ($ao == null ? 43 : ((Object)$ao).hashCode());
            At $at = this.getAt();
            result = result * 59 + ($at == null ? 43 : ((Object)$at).hashCode());
            Au $au = this.getAu();
            result = result * 59 + ($au == null ? 43 : ((Object)$au).hashCode());
            Aw $aw = this.getAw();
            result = result * 59 + ($aw == null ? 43 : ((Object)$aw).hashCode());
            Az $az = this.getAz();
            result = result * 59 + ($az == null ? 43 : ((Object)$az).hashCode());
            Ba $ba = this.getBa();
            result = result * 59 + ($ba == null ? 43 : ((Object)$ba).hashCode());
            Bb $bb = this.getBb();
            result = result * 59 + ($bb == null ? 43 : ((Object)$bb).hashCode());
            Bd $bd = this.getBd();
            result = result * 59 + ($bd == null ? 43 : ((Object)$bd).hashCode());
            Be $be = this.getBe();
            result = result * 59 + ($be == null ? 43 : ((Object)$be).hashCode());
            Bf $bf = this.getBf();
            result = result * 59 + ($bf == null ? 43 : ((Object)$bf).hashCode());
            Bg $bg = this.getBg();
            result = result * 59 + ($bg == null ? 43 : ((Object)$bg).hashCode());
            Bh $bh = this.getBh();
            result = result * 59 + ($bh == null ? 43 : ((Object)$bh).hashCode());
            Bj $bj = this.getBj();
            result = result * 59 + ($bj == null ? 43 : ((Object)$bj).hashCode());
            Bs $bs = this.getBs();
            result = result * 59 + ($bs == null ? 43 : ((Object)$bs).hashCode());
            By $by = this.getBy();
            result = result * 59 + ($by == null ? 43 : ((Object)$by).hashCode());
            Ca $ca = this.getCa();
            result = result * 59 + ($ca == null ? 43 : ((Object)$ca).hashCode());
            Cd $cd = this.getCd();
            result = result * 59 + ($cd == null ? 43 : ((Object)$cd).hashCode());
            Ch $ch = this.getCh();
            result = result * 59 + ($ch == null ? 43 : ((Object)$ch).hashCode());
            Cl $cl = this.getCl();
            result = result * 59 + ($cl == null ? 43 : ((Object)$cl).hashCode());
            Cm $cm = this.getCm();
            result = result * 59 + ($cm == null ? 43 : ((Object)$cm).hashCode());
            Co $co = this.getCo();
            result = result * 59 + ($co == null ? 43 : ((Object)$co).hashCode());
            Cr $cr = this.getCr();
            result = result * 59 + ($cr == null ? 43 : ((Object)$cr).hashCode());
            Cv $cv = this.getCv();
            result = result * 59 + ($cv == null ? 43 : ((Object)$cv).hashCode());
            Cy $cy = this.getCy();
            result = result * 59 + ($cy == null ? 43 : ((Object)$cy).hashCode());
            Cz $cz = this.getCz();
            result = result * 59 + ($cz == null ? 43 : ((Object)$cz).hashCode());
            De $de = this.getDe();
            result = result * 59 + ($de == null ? 43 : ((Object)$de).hashCode());
            Dk $dk = this.getDk();
            result = result * 59 + ($dk == null ? 43 : ((Object)$dk).hashCode());
            Ec $ec = this.getEc();
            result = result * 59 + ($ec == null ? 43 : ((Object)$ec).hashCode());
            Ee $ee = this.getEe();
            result = result * 59 + ($ee == null ? 43 : ((Object)$ee).hashCode());
            Eg $eg = this.getEg();
            result = result * 59 + ($eg == null ? 43 : ((Object)$eg).hashCode());
            Es $es = this.getEs();
            result = result * 59 + ($es == null ? 43 : ((Object)$es).hashCode());
            Et $et = this.getEt();
            result = result * 59 + ($et == null ? 43 : ((Object)$et).hashCode());
            Fi $fi = this.getFi();
            result = result * 59 + ($fi == null ? 43 : ((Object)$fi).hashCode());
            Fr $fr = this.getFr();
            result = result * 59 + ($fr == null ? 43 : ((Object)$fr).hashCode());
            Gb $gb = this.getGb();
            result = result * 59 + ($gb == null ? 43 : ((Object)$gb).hashCode());
            Ge $ge = this.getGe();
            result = result * 59 + ($ge == null ? 43 : ((Object)$ge).hashCode());
            Gn $gn = this.getGn();
            result = result * 59 + ($gn == null ? 43 : ((Object)$gn).hashCode());
            Gr $gr = this.getGr();
            result = result * 59 + ($gr == null ? 43 : ((Object)$gr).hashCode());
            Hr $hr = this.getHr();
            result = result * 59 + ($hr == null ? 43 : ((Object)$hr).hashCode());
            Hu $hu = this.getHu();
            result = result * 59 + ($hu == null ? 43 : ((Object)$hu).hashCode());
            Id $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Ie $ie = this.getIe();
            result = result * 59 + ($ie == null ? 43 : ((Object)$ie).hashCode());
            In $in = this.getIn();
            result = result * 59 + ($in == null ? 43 : ((Object)$in).hashCode());
            Is $is = this.getIs();
            result = result * 59 + ($is == null ? 43 : ((Object)$is).hashCode());
            It $it = this.getIt();
            result = result * 59 + ($it == null ? 43 : ((Object)$it).hashCode());
            Jp $jp = this.getJp();
            result = result * 59 + ($jp == null ? 43 : ((Object)$jp).hashCode());
            Ke $ke = this.getKe();
            result = result * 59 + ($ke == null ? 43 : ((Object)$ke).hashCode());
            Kg $kg = this.getKg();
            result = result * 59 + ($kg == null ? 43 : ((Object)$kg).hashCode());
            Kh $kh = this.getKh();
            result = result * 59 + ($kh == null ? 43 : ((Object)$kh).hashCode());
            Kr $kr = this.getKr();
            result = result * 59 + ($kr == null ? 43 : ((Object)$kr).hashCode());
            Kz $kz = this.getKz();
            result = result * 59 + ($kz == null ? 43 : ((Object)$kz).hashCode());
            La $la = this.getLa();
            result = result * 59 + ($la == null ? 43 : ((Object)$la).hashCode());
            Lt $lt = this.getLt();
            result = result * 59 + ($lt == null ? 43 : ((Object)$lt).hashCode());
            Lu $lu = this.getLu();
            result = result * 59 + ($lu == null ? 43 : ((Object)$lu).hashCode());
            Lv $lv = this.getLv();
            result = result * 59 + ($lv == null ? 43 : ((Object)$lv).hashCode());
            Ma $ma = this.getMa();
            result = result * 59 + ($ma == null ? 43 : ((Object)$ma).hashCode());
            Md $md = this.getMd();
            result = result * 59 + ($md == null ? 43 : ((Object)$md).hashCode());
            Me $me = this.getMe();
            result = result * 59 + ($me == null ? 43 : ((Object)$me).hashCode());
            Mk $mk = this.getMk();
            result = result * 59 + ($mk == null ? 43 : ((Object)$mk).hashCode());
            Mr $mr = this.getMr();
            result = result * 59 + ($mr == null ? 43 : ((Object)$mr).hashCode());
            Mt $mt = this.getMt();
            result = result * 59 + ($mt == null ? 43 : ((Object)$mt).hashCode());
            Mx $mx = this.getMx();
            result = result * 59 + ($mx == null ? 43 : ((Object)$mx).hashCode());
            My $my = this.getMy();
            result = result * 59 + ($my == null ? 43 : ((Object)$my).hashCode());
            Ng $ng = this.getNg();
            result = result * 59 + ($ng == null ? 43 : ((Object)$ng).hashCode());
            Nl $nl = this.getNl();
            result = result * 59 + ($nl == null ? 43 : ((Object)$nl).hashCode());
            No $no = this.getNo();
            result = result * 59 + ($no == null ? 43 : ((Object)$no).hashCode());
            Np $np = this.getNp();
            result = result * 59 + ($np == null ? 43 : ((Object)$np).hashCode());
            Nz $nz = this.getNz();
            result = result * 59 + ($nz == null ? 43 : ((Object)$nz).hashCode());
            Om $om = this.getOm();
            result = result * 59 + ($om == null ? 43 : ((Object)$om).hashCode());
            Pe $pe = this.getPe();
            result = result * 59 + ($pe == null ? 43 : ((Object)$pe).hashCode());
            Ph $ph = this.getPh();
            result = result * 59 + ($ph == null ? 43 : ((Object)$ph).hashCode());
            Pl $pl = this.getPl();
            result = result * 59 + ($pl == null ? 43 : ((Object)$pl).hashCode());
            Pt $pt = this.getPt();
            result = result * 59 + ($pt == null ? 43 : ((Object)$pt).hashCode());
            Ro $ro = this.getRo();
            result = result * 59 + ($ro == null ? 43 : ((Object)$ro).hashCode());
            Rs $rs = this.getRs();
            result = result * 59 + ($rs == null ? 43 : ((Object)$rs).hashCode());
            Ru $ru = this.getRu();
            result = result * 59 + ($ru == null ? 43 : ((Object)$ru).hashCode());
            Sa $sa = this.getSa();
            result = result * 59 + ($sa == null ? 43 : ((Object)$sa).hashCode());
            Se $se = this.getSe();
            result = result * 59 + ($se == null ? 43 : ((Object)$se).hashCode());
            Sg $sg = this.getSg();
            result = result * 59 + ($sg == null ? 43 : ((Object)$sg).hashCode());
            Si $si = this.getSi();
            result = result * 59 + ($si == null ? 43 : ((Object)$si).hashCode());
            Sk $sk = this.getSk();
            result = result * 59 + ($sk == null ? 43 : ((Object)$sk).hashCode());
            Sn $sn = this.getSn();
            result = result * 59 + ($sn == null ? 43 : ((Object)$sn).hashCode());
            Sr $sr = this.getSr();
            result = result * 59 + ($sr == null ? 43 : ((Object)$sr).hashCode());
            Th $th = this.getTh();
            result = result * 59 + ($th == null ? 43 : ((Object)$th).hashCode());
            Tj $tj = this.getTj();
            result = result * 59 + ($tj == null ? 43 : ((Object)$tj).hashCode());
            Tr $tr = this.getTr();
            result = result * 59 + ($tr == null ? 43 : ((Object)$tr).hashCode());
            Tz $tz = this.getTz();
            result = result * 59 + ($tz == null ? 43 : ((Object)$tz).hashCode());
            Ua $ua = this.getUa();
            result = result * 59 + ($ua == null ? 43 : ((Object)$ua).hashCode());
            Ug $ug = this.getUg();
            result = result * 59 + ($ug == null ? 43 : ((Object)$ug).hashCode());
            Us $us = this.getUs();
            result = result * 59 + ($us == null ? 43 : ((Object)$us).hashCode());
            Uy $uy = this.getUy();
            result = result * 59 + ($uy == null ? 43 : ((Object)$uy).hashCode());
            Uz $uz = this.getUz();
            result = result * 59 + ($uz == null ? 43 : ((Object)$uz).hashCode());
            Vn $vn = this.getVn();
            result = result * 59 + ($vn == null ? 43 : ((Object)$vn).hashCode());
            Za $za = this.getZa();
            result = result * 59 + ($za == null ? 43 : ((Object)$za).hashCode());
            Zm $zm = this.getZm();
            result = result * 59 + ($zm == null ? 43 : ((Object)$zm).hashCode());
            Zw $zw = this.getZw();
            result = result * 59 + ($zw == null ? 43 : ((Object)$zw).hashCode());
            return result;
        }

        public static class Ae
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ae)) {
                    return false;
                }
                Ae other = (Ae)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ae;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Al
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Al)) {
                    return false;
                }
                Al other = (Al)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Al;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Am
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Am)) {
                    return false;
                }
                Am other = (Am)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Am;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ao
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ao)) {
                    return false;
                }
                Ao other = (Ao)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ao;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class At
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof At)) {
                    return false;
                }
                At other = (At)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof At;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Au
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Au)) {
                    return false;
                }
                Au other = (Au)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Au;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Aw
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Aw)) {
                    return false;
                }
                Aw other = (Aw)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Aw;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Az
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Az)) {
                    return false;
                }
                Az other = (Az)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Az;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ba
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ba)) {
                    return false;
                }
                Ba other = (Ba)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ba;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Bb
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bb)) {
                    return false;
                }
                Bb other = (Bb)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bb;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Bd
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bd)) {
                    return false;
                }
                Bd other = (Bd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Be
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Be)) {
                    return false;
                }
                Be other = (Be)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Be;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Bf
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bf)) {
                    return false;
                }
                Bf other = (Bf)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bf;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Bg
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bg)) {
                    return false;
                }
                Bg other = (Bg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Bh
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bh)) {
                    return false;
                }
                Bh other = (Bh)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bh;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Bj
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bj)) {
                    return false;
                }
                Bj other = (Bj)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bj;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Bs
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bs)) {
                    return false;
                }
                Bs other = (Bs)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bs;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class By
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof By)) {
                    return false;
                }
                By other = (By)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof By;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ca
        extends StripeObject {
            @SerializedName(value="province_standard")
            ProvinceStandard provinceStandard;
            @SerializedName(value="type")
            String type;

            @Generated
            public ProvinceStandard getProvinceStandard() {
                return this.provinceStandard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setProvinceStandard(ProvinceStandard provinceStandard) {
                this.provinceStandard = provinceStandard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ca)) {
                    return false;
                }
                Ca other = (Ca)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ProvinceStandard this$provinceStandard = this.getProvinceStandard();
                ProvinceStandard other$provinceStandard = other.getProvinceStandard();
                if (this$provinceStandard == null ? other$provinceStandard != null : !((Object)this$provinceStandard).equals(other$provinceStandard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ca;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ProvinceStandard $provinceStandard = this.getProvinceStandard();
                result = result * 59 + ($provinceStandard == null ? 43 : ((Object)$provinceStandard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class ProvinceStandard
            extends StripeObject {
                @SerializedName(value="province")
                String province;

                @Generated
                public String getProvince() {
                    return this.province;
                }

                @Generated
                public void setProvince(String province) {
                    this.province = province;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProvinceStandard)) {
                        return false;
                    }
                    ProvinceStandard other = (ProvinceStandard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$province = this.getProvince();
                    String other$province = other.getProvince();
                    return !(this$province == null ? other$province != null : !this$province.equals(other$province));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProvinceStandard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $province = this.getProvince();
                    result = result * 59 + ($province == null ? 43 : $province.hashCode());
                    return result;
                }
            }
        }

        public static class Cd
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cd)) {
                    return false;
                }
                Cd other = (Cd)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cd;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ch
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ch)) {
                    return false;
                }
                Ch other = (Ch)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ch;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cl
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cl)) {
                    return false;
                }
                Cl other = (Cl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cm
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cm)) {
                    return false;
                }
                Cm other = (Cm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Co
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Co)) {
                    return false;
                }
                Co other = (Co)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Co;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cr)) {
                    return false;
                }
                Cr other = (Cr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cv
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cv)) {
                    return false;
                }
                Cv other = (Cv)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cv;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Cy
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cy)) {
                    return false;
                }
                Cy other = (Cy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cy;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Cz
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cz)) {
                    return false;
                }
                Cz other = (Cz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class De
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof De)) {
                    return false;
                }
                De other = (De)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof De;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Dk
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Dk)) {
                    return false;
                }
                Dk other = (Dk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Dk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Ec
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ec)) {
                    return false;
                }
                Ec other = (Ec)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ec;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ee
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ee)) {
                    return false;
                }
                Ee other = (Ee)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ee;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Eg
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eg)) {
                    return false;
                }
                Eg other = (Eg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Es
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Es)) {
                    return false;
                }
                Es other = (Es)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Es;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Et
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Et)) {
                    return false;
                }
                Et other = (Et)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Et;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Fi
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fi)) {
                    return false;
                }
                Fi other = (Fi)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fi;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Fr
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fr)) {
                    return false;
                }
                Fr other = (Fr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Gb
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gb)) {
                    return false;
                }
                Gb other = (Gb)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gb;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ge
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ge)) {
                    return false;
                }
                Ge other = (Ge)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ge;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Gn
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gn)) {
                    return false;
                }
                Gn other = (Gn)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gn;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Gr
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gr)) {
                    return false;
                }
                Gr other = (Gr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Hr
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hr)) {
                    return false;
                }
                Hr other = (Hr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Hu
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Hu)) {
                    return false;
                }
                Hu other = (Hu)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Hu;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Id
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Id)) {
                    return false;
                }
                Id other = (Id)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Id;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ie
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ie)) {
                    return false;
                }
                Ie other = (Ie)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ie;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class In
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof In)) {
                    return false;
                }
                In other = (In)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof In;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Is
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Is)) {
                    return false;
                }
                Is other = (Is)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Is;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class It
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof It)) {
                    return false;
                }
                It other = (It)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof It;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Jp
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jp)) {
                    return false;
                }
                Jp other = (Jp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Jp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ke
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ke)) {
                    return false;
                }
                Ke other = (Ke)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ke;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Kg
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kg)) {
                    return false;
                }
                Kg other = (Kg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Kg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Kh
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kh)) {
                    return false;
                }
                Kh other = (Kh)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Kh;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Kr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kr)) {
                    return false;
                }
                Kr other = (Kr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Kr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Kz
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Kz)) {
                    return false;
                }
                Kz other = (Kz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Kz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class La
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof La)) {
                    return false;
                }
                La other = (La)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof La;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Lt
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lt)) {
                    return false;
                }
                Lt other = (Lt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Lu
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lu)) {
                    return false;
                }
                Lu other = (Lu)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lu;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Lv
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lv)) {
                    return false;
                }
                Lv other = (Lv)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lv;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Ma
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ma)) {
                    return false;
                }
                Ma other = (Ma)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ma;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Md
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Md)) {
                    return false;
                }
                Md other = (Md)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Md;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Me
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Me)) {
                    return false;
                }
                Me other = (Me)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Me;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Mk
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mk)) {
                    return false;
                }
                Mk other = (Mk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Mr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mr)) {
                    return false;
                }
                Mr other = (Mr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Mt
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mt)) {
                    return false;
                }
                Mt other = (Mt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Mx
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mx)) {
                    return false;
                }
                Mx other = (Mx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class My
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof My)) {
                    return false;
                }
                My other = (My)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof My;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ng
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ng)) {
                    return false;
                }
                Ng other = (Ng)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ng;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Nl
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nl)) {
                    return false;
                }
                Nl other = (Nl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class No
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof No)) {
                    return false;
                }
                No other = (No)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof No;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Np
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Np)) {
                    return false;
                }
                Np other = (Np)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Np;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Nz
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Nz)) {
                    return false;
                }
                Nz other = (Nz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Nz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Om
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Om)) {
                    return false;
                }
                Om other = (Om)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Om;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Pe
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pe)) {
                    return false;
                }
                Pe other = (Pe)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pe;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ph
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ph)) {
                    return false;
                }
                Ph other = (Ph)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ph;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Pl
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pl)) {
                    return false;
                }
                Pl other = (Pl)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pl;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Pt
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pt)) {
                    return false;
                }
                Pt other = (Pt)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pt;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Ro
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ro)) {
                    return false;
                }
                Ro other = (Ro)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ro;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Rs
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Rs)) {
                    return false;
                }
                Rs other = (Rs)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Rs;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ru
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ru)) {
                    return false;
                }
                Ru other = (Ru)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ru;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Sa
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sa)) {
                    return false;
                }
                Sa other = (Sa)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sa;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Se
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Se)) {
                    return false;
                }
                Se other = (Se)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Se;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Sg
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sg)) {
                    return false;
                }
                Sg other = (Sg)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sg;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Si
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Si)) {
                    return false;
                }
                Si other = (Si)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Si;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Sk
        extends StripeObject {
            @SerializedName(value="standard")
            Standard standard;
            @SerializedName(value="type")
            String type;

            @Generated
            public Standard getStandard() {
                return this.standard;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setStandard(Standard standard) {
                this.standard = standard;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sk)) {
                    return false;
                }
                Sk other = (Sk)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Standard this$standard = this.getStandard();
                Standard other$standard = other.getStandard();
                if (this$standard == null ? other$standard != null : !((Object)this$standard).equals(other$standard)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sk;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Standard $standard = this.getStandard();
                result = result * 59 + ($standard == null ? 43 : ((Object)$standard).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Standard
            extends StripeObject {
                @SerializedName(value="place_of_supply_scheme")
                String placeOfSupplyScheme;

                @Generated
                public String getPlaceOfSupplyScheme() {
                    return this.placeOfSupplyScheme;
                }

                @Generated
                public void setPlaceOfSupplyScheme(String placeOfSupplyScheme) {
                    this.placeOfSupplyScheme = placeOfSupplyScheme;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Standard)) {
                        return false;
                    }
                    Standard other = (Standard)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    String other$placeOfSupplyScheme = other.getPlaceOfSupplyScheme();
                    return !(this$placeOfSupplyScheme == null ? other$placeOfSupplyScheme != null : !this$placeOfSupplyScheme.equals(other$placeOfSupplyScheme));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Standard;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $placeOfSupplyScheme = this.getPlaceOfSupplyScheme();
                    result = result * 59 + ($placeOfSupplyScheme == null ? 43 : $placeOfSupplyScheme.hashCode());
                    return result;
                }
            }
        }

        public static class Sn
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sn)) {
                    return false;
                }
                Sn other = (Sn)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sn;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Sr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sr)) {
                    return false;
                }
                Sr other = (Sr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Th
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Th)) {
                    return false;
                }
                Th other = (Th)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Th;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Tj
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tj)) {
                    return false;
                }
                Tj other = (Tj)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tj;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Tr
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tr)) {
                    return false;
                }
                Tr other = (Tr)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tr;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Tz
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tz)) {
                    return false;
                }
                Tz other = (Tz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ua
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ua)) {
                    return false;
                }
                Ua other = (Ua)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ua;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Ug
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ug)) {
                    return false;
                }
                Ug other = (Ug)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ug;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Us
        extends StripeObject {
            @SerializedName(value="local_amusement_tax")
            LocalAmusementTax localAmusementTax;
            @SerializedName(value="local_lease_tax")
            LocalLeaseTax localLeaseTax;
            @SerializedName(value="state")
            String state;
            @SerializedName(value="state_sales_tax")
            StateSalesTax stateSalesTax;
            @SerializedName(value="type")
            String type;

            @Generated
            public LocalAmusementTax getLocalAmusementTax() {
                return this.localAmusementTax;
            }

            @Generated
            public LocalLeaseTax getLocalLeaseTax() {
                return this.localLeaseTax;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public StateSalesTax getStateSalesTax() {
                return this.stateSalesTax;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setLocalAmusementTax(LocalAmusementTax localAmusementTax) {
                this.localAmusementTax = localAmusementTax;
            }

            @Generated
            public void setLocalLeaseTax(LocalLeaseTax localLeaseTax) {
                this.localLeaseTax = localLeaseTax;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public void setStateSalesTax(StateSalesTax stateSalesTax) {
                this.stateSalesTax = stateSalesTax;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Us)) {
                    return false;
                }
                Us other = (Us)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                LocalAmusementTax this$localAmusementTax = this.getLocalAmusementTax();
                LocalAmusementTax other$localAmusementTax = other.getLocalAmusementTax();
                if (this$localAmusementTax == null ? other$localAmusementTax != null : !((Object)this$localAmusementTax).equals(other$localAmusementTax)) {
                    return false;
                }
                LocalLeaseTax this$localLeaseTax = this.getLocalLeaseTax();
                LocalLeaseTax other$localLeaseTax = other.getLocalLeaseTax();
                if (this$localLeaseTax == null ? other$localLeaseTax != null : !((Object)this$localLeaseTax).equals(other$localLeaseTax)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
                    return false;
                }
                StateSalesTax this$stateSalesTax = this.getStateSalesTax();
                StateSalesTax other$stateSalesTax = other.getStateSalesTax();
                if (this$stateSalesTax == null ? other$stateSalesTax != null : !((Object)this$stateSalesTax).equals(other$stateSalesTax)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Us;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                LocalAmusementTax $localAmusementTax = this.getLocalAmusementTax();
                result = result * 59 + ($localAmusementTax == null ? 43 : ((Object)$localAmusementTax).hashCode());
                LocalLeaseTax $localLeaseTax = this.getLocalLeaseTax();
                result = result * 59 + ($localLeaseTax == null ? 43 : ((Object)$localLeaseTax).hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                StateSalesTax $stateSalesTax = this.getStateSalesTax();
                result = result * 59 + ($stateSalesTax == null ? 43 : ((Object)$stateSalesTax).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class LocalAmusementTax
            extends StripeObject {
                @SerializedName(value="jurisdiction")
                String jurisdiction;

                @Generated
                public String getJurisdiction() {
                    return this.jurisdiction;
                }

                @Generated
                public void setJurisdiction(String jurisdiction) {
                    this.jurisdiction = jurisdiction;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LocalAmusementTax)) {
                        return false;
                    }
                    LocalAmusementTax other = (LocalAmusementTax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$jurisdiction = this.getJurisdiction();
                    String other$jurisdiction = other.getJurisdiction();
                    return !(this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof LocalAmusementTax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $jurisdiction = this.getJurisdiction();
                    result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
                    return result;
                }
            }

            public static class LocalLeaseTax
            extends StripeObject {
                @SerializedName(value="jurisdiction")
                String jurisdiction;

                @Generated
                public String getJurisdiction() {
                    return this.jurisdiction;
                }

                @Generated
                public void setJurisdiction(String jurisdiction) {
                    this.jurisdiction = jurisdiction;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LocalLeaseTax)) {
                        return false;
                    }
                    LocalLeaseTax other = (LocalLeaseTax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$jurisdiction = this.getJurisdiction();
                    String other$jurisdiction = other.getJurisdiction();
                    return !(this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof LocalLeaseTax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $jurisdiction = this.getJurisdiction();
                    result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
                    return result;
                }
            }

            public static class StateSalesTax
            extends StripeObject {
                @SerializedName(value="elections")
                List<Election> elections;

                @Generated
                public List<Election> getElections() {
                    return this.elections;
                }

                @Generated
                public void setElections(List<Election> elections) {
                    this.elections = elections;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof StateSalesTax)) {
                        return false;
                    }
                    StateSalesTax other = (StateSalesTax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<Election> this$elections = this.getElections();
                    List<Election> other$elections = other.getElections();
                    return !(this$elections == null ? other$elections != null : !((Object)this$elections).equals(other$elections));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof StateSalesTax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<Election> $elections = this.getElections();
                    result = result * 59 + ($elections == null ? 43 : ((Object)$elections).hashCode());
                    return result;
                }

                public static class Election
                extends StripeObject {
                    @SerializedName(value="jurisdiction")
                    String jurisdiction;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public String getJurisdiction() {
                        return this.jurisdiction;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setJurisdiction(String jurisdiction) {
                        this.jurisdiction = jurisdiction;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Election)) {
                            return false;
                        }
                        Election other = (Election)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$jurisdiction = this.getJurisdiction();
                        String other$jurisdiction = other.getJurisdiction();
                        if (this$jurisdiction == null ? other$jurisdiction != null : !this$jurisdiction.equals(other$jurisdiction)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Election;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $jurisdiction = this.getJurisdiction();
                        result = result * 59 + ($jurisdiction == null ? 43 : $jurisdiction.hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class Uy
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Uy)) {
                    return false;
                }
                Uy other = (Uy)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Uy;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Uz
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Uz)) {
                    return false;
                }
                Uz other = (Uz)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Uz;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Vn
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Vn)) {
                    return false;
                }
                Vn other = (Vn)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Vn;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Za
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Za)) {
                    return false;
                }
                Za other = (Za)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Za;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Zm
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zm)) {
                    return false;
                }
                Zm other = (Zm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }

        public static class Zw
        extends StripeObject {
            @SerializedName(value="type")
            String type;

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zw)) {
                    return false;
                }
                Zw other = (Zw)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zw;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }
}

