/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.testhelpers;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.testhelpers.TestClockAdvanceParams;
import com.stripe.param.testhelpers.TestClockCreateParams;
import com.stripe.param.testhelpers.TestClockListParams;
import com.stripe.param.testhelpers.TestClockRetrieveParams;
import java.lang.reflect.Type;

public final class TestClockService
extends ApiService {
    public TestClockService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public TestClock delete(String testClock) throws StripeException {
        return this.delete(testClock, null);
    }

    public TestClock delete(String testClock, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/test_clocks/%s", ApiResource.urlEncodeId(testClock));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (TestClock)this.request(request, (Type)((Object)TestClock.class));
    }

    public TestClock retrieve(String testClock, TestClockRetrieveParams params) throws StripeException {
        return this.retrieve(testClock, params, null);
    }

    public TestClock retrieve(String testClock, RequestOptions options) throws StripeException {
        return this.retrieve(testClock, null, options);
    }

    public TestClock retrieve(String testClock) throws StripeException {
        return this.retrieve(testClock, null, null);
    }

    public TestClock retrieve(String testClock, TestClockRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/test_clocks/%s", ApiResource.urlEncodeId(testClock));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (TestClock)this.request(request, (Type)((Object)TestClock.class));
    }

    public StripeCollection<TestClock> list(TestClockListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<TestClock> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<TestClock> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<TestClock> list(TestClockListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/test_helpers/test_clocks";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<TestClock>>(){}.getType());
    }

    public TestClock create(TestClockCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public TestClock create(TestClockCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/test_helpers/test_clocks";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (TestClock)this.request(request, (Type)((Object)TestClock.class));
    }

    public TestClock advance(String testClock, TestClockAdvanceParams params) throws StripeException {
        return this.advance(testClock, params, null);
    }

    public TestClock advance(String testClock, TestClockAdvanceParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/test_helpers/test_clocks/%s/advance", ApiResource.urlEncodeId(testClock));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (TestClock)this.request(request, (Type)((Object)TestClock.class));
    }
}

