/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.Customer;
import com.stripe.model.ExternalAccount;
import com.stripe.model.SourceOwner;
import com.stripe.model.SourceReceiverFlow;
import com.stripe.model.SourceRedirectFlow;
import com.stripe.model.SourceVerificationFlow;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class Source
extends ExternalAccount {
    Long amount;
    String clientSecret;
    Long created;
    String currency;
    String flow;
    Boolean livemode;
    SourceOwner owner;
    String status;
    String usage;
    String type;
    SourceReceiverFlow receiver;
    SourceRedirectFlow redirect;
    SourceVerificationFlow verification;
    Map<String, String> typeData;

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getFlow() {
        return this.flow;
    }

    public void setFlow(String flow) {
        this.flow = flow;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public SourceOwner getOwner() {
        return this.owner;
    }

    public void setOwner(SourceOwner owner) {
        this.owner = owner;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SourceReceiverFlow getReceiver() {
        return this.receiver;
    }

    public void setReceiver(SourceReceiverFlow receiver) {
        this.receiver = receiver;
    }

    public SourceRedirectFlow getRedirect() {
        return this.redirect;
    }

    public void setRedirect(SourceRedirectFlow redirect) {
        this.redirect = redirect;
    }

    public SourceVerificationFlow getVerification() {
        return this.verification;
    }

    public void setVerification(SourceVerificationFlow verification) {
        this.verification = verification;
    }

    public Map<String, String> getTypeData() {
        return this.typeData;
    }

    public void setTypeData(Map<String, String> typeData) {
        this.typeData = typeData;
    }

    public String getSourceInstanceURL() throws InvalidRequestException {
        if (this.getCustomer() != null) {
            return String.format("%s/%s/sources/%s", Source.classURL(Customer.class), this.getCustomer(), this.getId());
        }
        return Source.instanceURL(Source.class, this.getId());
    }

    public static Source create(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.create(params, null);
    }

    public static Source create(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.POST, Source.classURL(Source.class), params, Source.class, options);
    }

    public static Source retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.retrieve(id, null);
    }

    public static Source retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.GET, Source.instanceURL(Source.class, id), null, Source.class, options);
    }

    @Override
    public Source verify(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.verify((Map)params, (RequestOptions)null);
    }

    @Override
    public Source verify(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        if (this.getCustomer() != null) {
            return Source.request(APIResource.RequestMethod.POST, String.format("%s/verify", this.getSourceInstanceURL()), params, Source.class, options);
        }
        throw new InvalidRequestException("Only customer sources can be verified in this manner.", null, null, null, null);
    }

    @Override
    public Source update(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.update((Map)params, (RequestOptions)null);
    }

    @Override
    public Source update(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return Source.request(APIResource.RequestMethod.POST, this.getSourceInstanceURL(), params, Source.class, options);
    }
}

