/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.stripe.exception.APIConnectionException;
import com.stripe.exception.APIException;
import com.stripe.exception.AuthenticationException;
import com.stripe.exception.CardException;
import com.stripe.exception.InvalidRequestException;
import com.stripe.model.ApplicationFeeCollection;
import com.stripe.model.FeeRefundCollection;
import com.stripe.model.HasId;
import com.stripe.net.APIResource;
import com.stripe.net.RequestOptions;
import java.util.Map;

public class ApplicationFee
extends APIResource
implements HasId {
    String id;
    String account;
    Long amount;
    Long amountRefunded;
    String application;
    String balanceTransaction;
    String charge;
    Long created;
    String currency;
    Boolean livemode;
    String originatingTransaction;
    Boolean refunded;
    FeeRefundCollection refunds;
    @Deprecated
    String user;

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public Long getAmountRefunded() {
        return this.amountRefunded;
    }

    public void setAmountRefunded(Long amountRefunded) {
        this.amountRefunded = amountRefunded;
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getBalanceTransaction() {
        return this.balanceTransaction;
    }

    public void setBalanceTransaction(String balanceTransaction) {
        this.balanceTransaction = balanceTransaction;
    }

    public String getCharge() {
        return this.charge;
    }

    public void setCharge(String charge) {
        this.charge = charge;
    }

    public Long getCreated() {
        return this.created;
    }

    public void setCreated(Long created) {
        this.created = created;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public Boolean getLivemode() {
        return this.livemode;
    }

    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    public String getOriginatingTransaction() {
        return this.originatingTransaction;
    }

    public void setOriginatingTransaction(String originatingTransaction) {
        this.originatingTransaction = originatingTransaction;
    }

    public Boolean getRefunded() {
        return this.refunded;
    }

    public void setRefunded(Boolean refunded) {
        this.refunded = refunded;
    }

    public FeeRefundCollection getRefunds() {
        if (this.refunds.getURL() == null) {
            this.refunds.setURL(String.format("/v1/application_fees/%s/refunds", this.getId()));
        }
        return this.refunds;
    }

    @Deprecated
    public String getUser() {
        return this.user;
    }

    @Deprecated
    public void setUser(String user) {
        this.user = user;
    }

    public static ApplicationFee retrieve(String id) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.retrieve(id, (RequestOptions)null);
    }

    @Deprecated
    public static ApplicationFee retrieve(String id, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.retrieve(id, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public static ApplicationFee retrieve(String id, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.request(APIResource.RequestMethod.GET, ApplicationFee.instanceURL(ApplicationFee.class, id), null, ApplicationFee.class, options);
    }

    public static ApplicationFeeCollection list(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, null);
    }

    public static ApplicationFeeCollection list(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.requestCollection(ApplicationFee.classURL(ApplicationFee.class), params, ApplicationFeeCollection.class, options);
    }

    @Deprecated
    public static ApplicationFeeCollection all(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, null);
    }

    @Deprecated
    public static ApplicationFeeCollection all(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    @Deprecated
    public static ApplicationFeeCollection all(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.list(params, options);
    }

    public ApplicationFee refund() throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, (RequestOptions)null);
    }

    public ApplicationFee refund(Map<String, Object> params) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, (RequestOptions)null);
    }

    @Deprecated
    public ApplicationFee refund(String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(RequestOptions.builder().setApiKey(apiKey).build());
    }

    public ApplicationFee refund(RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(null, options);
    }

    @Deprecated
    public ApplicationFee refund(Map<String, Object> params, String apiKey) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return this.refund(params, RequestOptions.builder().setApiKey(apiKey).build());
    }

    public ApplicationFee refund(Map<String, Object> params, RequestOptions options) throws AuthenticationException, InvalidRequestException, APIConnectionException, CardException, APIException {
        return ApplicationFee.request(APIResource.RequestMethod.POST, String.format("%s/refund", ApplicationFee.instanceURL(ApplicationFee.class, this.getId())), params, ApplicationFee.class, options);
    }
}

