/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.stripe.model.Account;
import com.stripe.model.AlipayAccount;
import com.stripe.model.ApplePayDomain;
import com.stripe.model.ApplicationFee;
import com.stripe.model.Balance;
import com.stripe.model.BalanceTransaction;
import com.stripe.model.BankAccount;
import com.stripe.model.BitcoinReceiver;
import com.stripe.model.Card;
import com.stripe.model.Charge;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.Dispute;
import com.stripe.model.Event;
import com.stripe.model.EventData;
import com.stripe.model.Fee;
import com.stripe.model.FeeRefund;
import com.stripe.model.FileUpload;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItem;
import com.stripe.model.InvoiceLineItem;
import com.stripe.model.Order;
import com.stripe.model.OrderItem;
import com.stripe.model.OrderReturn;
import com.stripe.model.Plan;
import com.stripe.model.Product;
import com.stripe.model.Recipient;
import com.stripe.model.Refund;
import com.stripe.model.Reversal;
import com.stripe.model.SKU;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.Subscription;
import com.stripe.model.Summary;
import com.stripe.model.ThreeDSecure;
import com.stripe.model.Token;
import com.stripe.model.Transfer;
import com.stripe.net.APIResource;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EventDataDeserializer
implements JsonDeserializer<EventData> {
    static final Map<String, Class> objectMap = new HashMap<String, Class>();

    private Object deserializeJsonPrimitive(JsonPrimitive element) {
        if (element.isBoolean()) {
            return element.getAsBoolean();
        }
        if (element.isNumber()) {
            return element.getAsNumber();
        }
        return element.getAsString();
    }

    private Object[] deserializeJsonArray(JsonArray arr) {
        Object[] elems = new Object[arr.size()];
        Iterator elemIter = arr.iterator();
        int i = 0;
        while (elemIter.hasNext()) {
            JsonElement elem = (JsonElement)elemIter.next();
            elems[i++] = this.deserializeJsonElement(elem);
        }
        return elems;
    }

    private Object deserializeJsonElement(JsonElement element) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonObject()) {
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            this.populateMapFromJSONObject(valueMap, element.getAsJsonObject());
            return valueMap;
        }
        if (element.isJsonPrimitive()) {
            return this.deserializeJsonPrimitive(element.getAsJsonPrimitive());
        }
        if (element.isJsonArray()) {
            return this.deserializeJsonArray(element.getAsJsonArray());
        }
        System.err.println("Unknown JSON element type for element " + element + ". If you're seeing this messaage, it's probably a bug in the Stripe Java library. Please contact us by email at support@stripe.com.");
        return null;
    }

    private void populateMapFromJSONObject(Map<String, Object> objMap, JsonObject jsonObject) {
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            objMap.put(key, this.deserializeJsonElement(element));
        }
    }

    public EventData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        EventData eventData = new EventData();
        JsonObject jsonObject = json.getAsJsonObject();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if ("previous_attributes".equals(key)) {
                if (element.isJsonNull()) {
                    eventData.setPreviousAttributes(null);
                    continue;
                }
                if (!element.isJsonObject()) continue;
                HashMap<String, Object> previousAttributes = new HashMap<String, Object>();
                this.populateMapFromJSONObject(previousAttributes, element.getAsJsonObject());
                eventData.setPreviousAttributes(previousAttributes);
                continue;
            }
            if (!"object".equals(key)) continue;
            String type = element.getAsJsonObject().get("object").getAsString();
            Class<StripeRawJsonObject> cl = objectMap.get(type);
            StripeObject object = (StripeObject)APIResource.GSON.fromJson((JsonElement)entry.getValue(), cl != null ? cl : StripeRawJsonObject.class);
            eventData.setObject(object);
        }
        return eventData;
    }

    static {
        objectMap.put("balance", Balance.class);
        objectMap.put("balance_transaction", BalanceTransaction.class);
        objectMap.put("charge", Charge.class);
        objectMap.put("customer", Customer.class);
        objectMap.put("dispute", Dispute.class);
        objectMap.put("event", Event.class);
        objectMap.put("file_upload", FileUpload.class);
        objectMap.put("refund", Refund.class);
        objectMap.put("token", Token.class);
        objectMap.put("transfer", Transfer.class);
        objectMap.put("transfer_reversal", Reversal.class);
        objectMap.put("account", Account.class);
        objectMap.put("fee_refund", FeeRefund.class);
        objectMap.put("application_fee", ApplicationFee.class);
        objectMap.put("recipient", Recipient.class);
        objectMap.put("alipay_account", AlipayAccount.class);
        objectMap.put("bank_account", BankAccount.class);
        objectMap.put("bitcoin_receiver", BitcoinReceiver.class);
        objectMap.put("card", Card.class);
        objectMap.put("order", Order.class);
        objectMap.put("order_item", OrderItem.class);
        objectMap.put("order_return", OrderReturn.class);
        objectMap.put("product", Product.class);
        objectMap.put("sku", SKU.class);
        objectMap.put("coupon", Coupon.class);
        objectMap.put("discount", Discount.class);
        objectMap.put("invoice", Invoice.class);
        objectMap.put("invoice_line_item", InvoiceLineItem.class);
        objectMap.put("invoiceitem", InvoiceItem.class);
        objectMap.put("plan", Plan.class);
        objectMap.put("subscription", Subscription.class);
        objectMap.put("summary", Summary.class);
        objectMap.put("fee", Fee.class);
        objectMap.put("three_d_secure", ThreeDSecure.class);
        objectMap.put("apple_pay_domain", ApplePayDomain.class);
    }
}

