/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.exception;

import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.stripe.exception.ApiException;
import com.stripe.model.StripeError;
import com.stripe.model.StripeObject;
import com.stripe.net.StripeResponseGetter;
import lombok.Generated;

public final class InvalidPaymentMethodException
extends ApiException {
    private static final long serialVersionUID = 2L;
    String invalidParam;

    private InvalidPaymentMethodException(String message, String requestId, String code, Integer statusCode, Throwable e, String invalidParam) {
        super(message, requestId, code, statusCode, e);
        this.invalidParam = invalidParam;
    }

    static InvalidPaymentMethodException parse(JsonObject body, int statusCode, String requestId, StripeResponseGetter responseGetter) {
        InvalidPaymentMethodError error = (InvalidPaymentMethodError)StripeObject.deserializeStripeObject(body, InvalidPaymentMethodError.class, responseGetter);
        InvalidPaymentMethodException exception = new InvalidPaymentMethodException(error.getMessage(), requestId, error.getCode(), statusCode, null, error.getInvalidParam());
        exception.setStripeError(error);
        return exception;
    }

    @Generated
    public String getInvalidParam() {
        return this.invalidParam;
    }

    public static class InvalidPaymentMethodError
    extends StripeError {
        @SerializedName(value="invalid_param")
        String invalidParam;

        @Generated
        public String getInvalidParam() {
            return this.invalidParam;
        }
    }
}

