/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.CouponCollection;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.CouponCreateParams;
import com.stripe.param.CouponListParams;
import com.stripe.param.CouponRetrieveParams;
import com.stripe.param.CouponUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Coupon
extends ApiResource
implements HasId,
MetadataStore<Coupon> {
    @SerializedName(value="amount_off")
    Long amountOff;
    @SerializedName(value="applies_to")
    AppliesTo appliesTo;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="currency_options")
    Map<String, CurrencyOption> currencyOptions;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="duration")
    String duration;
    @SerializedName(value="duration_in_months")
    Long durationInMonths;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="max_redemptions")
    Long maxRedemptions;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="percent_off")
    BigDecimal percentOff;
    @SerializedName(value="redeem_by")
    Long redeemBy;
    @SerializedName(value="script")
    Script script;
    @SerializedName(value="times_redeemed")
    Long timesRedeemed;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="valid")
    Boolean valid;

    public static Coupon create(Map<String, Object> params) throws StripeException {
        return Coupon.create(params, (RequestOptions)null);
    }

    public static Coupon create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/coupons";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Coupon)Coupon.getGlobalResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    public static Coupon create(CouponCreateParams params) throws StripeException {
        return Coupon.create(params, (RequestOptions)null);
    }

    public static Coupon create(CouponCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/coupons";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Coupon)Coupon.getGlobalResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    public Coupon delete() throws StripeException {
        return this.delete(null, null);
    }

    public Coupon delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public Coupon delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public Coupon delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options);
        return (Coupon)this.getResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    public static CouponCollection list(Map<String, Object> params) throws StripeException {
        return Coupon.list(params, (RequestOptions)null);
    }

    public static CouponCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/coupons";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (CouponCollection)Coupon.getGlobalResponseGetter().request(request, (Type)((Object)CouponCollection.class));
    }

    public static CouponCollection list(CouponListParams params) throws StripeException {
        return Coupon.list(params, (RequestOptions)null);
    }

    public static CouponCollection list(CouponListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/coupons";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (CouponCollection)Coupon.getGlobalResponseGetter().request(request, (Type)((Object)CouponCollection.class));
    }

    public static Coupon retrieve(String coupon) throws StripeException {
        return Coupon.retrieve(coupon, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Coupon retrieve(String coupon, RequestOptions options) throws StripeException {
        return Coupon.retrieve(coupon, (Map<String, Object>)null, options);
    }

    public static Coupon retrieve(String coupon, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Coupon)Coupon.getGlobalResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    public static Coupon retrieve(String coupon, CouponRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(coupon));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Coupon)Coupon.getGlobalResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    public Coupon update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public Coupon update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Coupon)this.getResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    public Coupon update(CouponUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public Coupon update(CouponUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/coupons/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Coupon)this.getResponseGetter().request(request, (Type)((Object)Coupon.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.appliesTo, responseGetter);
        this.trySetResponseGetter(this.script, responseGetter);
    }

    @Generated
    public Long getAmountOff() {
        return this.amountOff;
    }

    @Generated
    public AppliesTo getAppliesTo() {
        return this.appliesTo;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public Map<String, CurrencyOption> getCurrencyOptions() {
        return this.currencyOptions;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDuration() {
        return this.duration;
    }

    @Generated
    public Long getDurationInMonths() {
        return this.durationInMonths;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getMaxRedemptions() {
        return this.maxRedemptions;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public BigDecimal getPercentOff() {
        return this.percentOff;
    }

    @Generated
    public Long getRedeemBy() {
        return this.redeemBy;
    }

    @Generated
    public Script getScript() {
        return this.script;
    }

    @Generated
    public Long getTimesRedeemed() {
        return this.timesRedeemed;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Boolean getValid() {
        return this.valid;
    }

    @Generated
    public void setAmountOff(Long amountOff) {
        this.amountOff = amountOff;
    }

    @Generated
    public void setAppliesTo(AppliesTo appliesTo) {
        this.appliesTo = appliesTo;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCurrencyOptions(Map<String, CurrencyOption> currencyOptions) {
        this.currencyOptions = currencyOptions;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDuration(String duration) {
        this.duration = duration;
    }

    @Generated
    public void setDurationInMonths(Long durationInMonths) {
        this.durationInMonths = durationInMonths;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMaxRedemptions(Long maxRedemptions) {
        this.maxRedemptions = maxRedemptions;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPercentOff(BigDecimal percentOff) {
        this.percentOff = percentOff;
    }

    @Generated
    public void setRedeemBy(Long redeemBy) {
        this.redeemBy = redeemBy;
    }

    @Generated
    public void setScript(Script script) {
        this.script = script;
    }

    @Generated
    public void setTimesRedeemed(Long timesRedeemed) {
        this.timesRedeemed = timesRedeemed;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Coupon)) {
            return false;
        }
        Coupon other = (Coupon)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountOff = this.getAmountOff();
        Long other$amountOff = other.getAmountOff();
        if (this$amountOff == null ? other$amountOff != null : !((Object)this$amountOff).equals(other$amountOff)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Long this$durationInMonths = this.getDurationInMonths();
        Long other$durationInMonths = other.getDurationInMonths();
        if (this$durationInMonths == null ? other$durationInMonths != null : !((Object)this$durationInMonths).equals(other$durationInMonths)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$maxRedemptions = this.getMaxRedemptions();
        Long other$maxRedemptions = other.getMaxRedemptions();
        if (this$maxRedemptions == null ? other$maxRedemptions != null : !((Object)this$maxRedemptions).equals(other$maxRedemptions)) {
            return false;
        }
        Long this$redeemBy = this.getRedeemBy();
        Long other$redeemBy = other.getRedeemBy();
        if (this$redeemBy == null ? other$redeemBy != null : !((Object)this$redeemBy).equals(other$redeemBy)) {
            return false;
        }
        Long this$timesRedeemed = this.getTimesRedeemed();
        Long other$timesRedeemed = other.getTimesRedeemed();
        if (this$timesRedeemed == null ? other$timesRedeemed != null : !((Object)this$timesRedeemed).equals(other$timesRedeemed)) {
            return false;
        }
        Boolean this$valid = this.getValid();
        Boolean other$valid = other.getValid();
        if (this$valid == null ? other$valid != null : !((Object)this$valid).equals(other$valid)) {
            return false;
        }
        AppliesTo this$appliesTo = this.getAppliesTo();
        AppliesTo other$appliesTo = other.getAppliesTo();
        if (this$appliesTo == null ? other$appliesTo != null : !((Object)this$appliesTo).equals(other$appliesTo)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        Map<String, CurrencyOption> this$currencyOptions = this.getCurrencyOptions();
        Map<String, CurrencyOption> other$currencyOptions = other.getCurrencyOptions();
        if (this$currencyOptions == null ? other$currencyOptions != null : !((Object)this$currencyOptions).equals(other$currencyOptions)) {
            return false;
        }
        String this$duration = this.getDuration();
        String other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !this$duration.equals(other$duration)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        BigDecimal this$percentOff = this.getPercentOff();
        BigDecimal other$percentOff = other.getPercentOff();
        if (this$percentOff == null ? other$percentOff != null : !((Object)this$percentOff).equals(other$percentOff)) {
            return false;
        }
        Script this$script = this.getScript();
        Script other$script = other.getScript();
        if (this$script == null ? other$script != null : !((Object)this$script).equals(other$script)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Coupon;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountOff = this.getAmountOff();
        result = result * 59 + ($amountOff == null ? 43 : ((Object)$amountOff).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Long $durationInMonths = this.getDurationInMonths();
        result = result * 59 + ($durationInMonths == null ? 43 : ((Object)$durationInMonths).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $maxRedemptions = this.getMaxRedemptions();
        result = result * 59 + ($maxRedemptions == null ? 43 : ((Object)$maxRedemptions).hashCode());
        Long $redeemBy = this.getRedeemBy();
        result = result * 59 + ($redeemBy == null ? 43 : ((Object)$redeemBy).hashCode());
        Long $timesRedeemed = this.getTimesRedeemed();
        result = result * 59 + ($timesRedeemed == null ? 43 : ((Object)$timesRedeemed).hashCode());
        Boolean $valid = this.getValid();
        result = result * 59 + ($valid == null ? 43 : ((Object)$valid).hashCode());
        AppliesTo $appliesTo = this.getAppliesTo();
        result = result * 59 + ($appliesTo == null ? 43 : ((Object)$appliesTo).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        Map<String, CurrencyOption> $currencyOptions = this.getCurrencyOptions();
        result = result * 59 + ($currencyOptions == null ? 43 : ((Object)$currencyOptions).hashCode());
        String $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : $duration.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        BigDecimal $percentOff = this.getPercentOff();
        result = result * 59 + ($percentOff == null ? 43 : ((Object)$percentOff).hashCode());
        Script $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : ((Object)$script).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class AppliesTo
    extends StripeObject {
        @SerializedName(value="products")
        List<String> products;

        @Generated
        public List<String> getProducts() {
            return this.products;
        }

        @Generated
        public void setProducts(List<String> products) {
            this.products = products;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppliesTo)) {
                return false;
            }
            AppliesTo other = (AppliesTo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$products = this.getProducts();
            List<String> other$products = other.getProducts();
            return !(this$products == null ? other$products != null : !((Object)this$products).equals(other$products));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppliesTo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $products = this.getProducts();
            result = result * 59 + ($products == null ? 43 : ((Object)$products).hashCode());
            return result;
        }
    }

    public static class Script
    extends StripeObject
    implements HasId {
        @SerializedName(value="configuration")
        Map<String, Object> configuration;
        @SerializedName(value="display_name")
        String displayName;
        @SerializedName(value="id")
        String id;

        @Generated
        public Map<String, Object> getConfiguration() {
            return this.configuration;
        }

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public void setConfiguration(Map<String, Object> configuration) {
            this.configuration = configuration;
        }

        @Generated
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Script)) {
                return false;
            }
            Script other = (Script)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$configuration = this.getConfiguration();
            Map<String, Object> other$configuration = other.getConfiguration();
            if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
                return false;
            }
            String this$displayName = this.getDisplayName();
            String other$displayName = other.getDisplayName();
            if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Script;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $configuration = this.getConfiguration();
            result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
            String $displayName = this.getDisplayName();
            result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }

    public static class CurrencyOption
    extends StripeObject {
        @SerializedName(value="amount_off")
        Long amountOff;

        @Generated
        public Long getAmountOff() {
            return this.amountOff;
        }

        @Generated
        public void setAmountOff(Long amountOff) {
            this.amountOff = amountOff;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrencyOption)) {
                return false;
            }
            CurrencyOption other = (CurrencyOption)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountOff = this.getAmountOff();
            Long other$amountOff = other.getAmountOff();
            return !(this$amountOff == null ? other$amountOff != null : !((Object)this$amountOff).equals(other$amountOff));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrencyOption;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountOff = this.getAmountOff();
            result = result * 59 + ($amountOff == null ? 43 : ((Object)$amountOff).hashCode());
            return result;
        }
    }
}

