/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.InvoiceItemCollection;
import com.stripe.model.Margin;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoiceItemCreateParams;
import com.stripe.param.InvoiceItemListParams;
import com.stripe.param.InvoiceItemRetrieveParams;
import com.stripe.param.InvoiceItemUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class InvoiceItem
extends ApiResource
implements HasId,
MetadataStore<InvoiceItem> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_account")
    String customerAccount;
    @SerializedName(value="date")
    Long date;
    @SerializedName(value="deleted")
    Boolean deleted;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discountable")
    Boolean discountable;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    ExpandableField<Invoice> invoice;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="margins")
    List<ExpandableField<Margin>> margins;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="net_amount")
    Long netAmount;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="parent")
    Parent parent;
    @SerializedName(value="period")
    Period period;
    @SerializedName(value="pricing")
    Pricing pricing;
    @SerializedName(value="proration")
    Boolean proration;
    @SerializedName(value="proration_details")
    ProrationDetails prorationDetails;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="tax_rates")
    List<TaxRate> taxRates;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getInvoice() {
        return this.invoice != null ? this.invoice.getId() : null;
    }

    public void setInvoice(String id) {
        this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
    }

    public Invoice getInvoiceObject() {
        return this.invoice != null ? this.invoice.getExpanded() : null;
    }

    public void setInvoiceObject(Invoice expandableObject) {
        this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public List<String> getMargins() {
        return this.margins != null ? this.margins.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setMargins(List<String> ids) {
        if (ids == null) {
            this.margins = null;
            return;
        }
        if (this.margins != null && this.margins.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.margins = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Margin> getMarginObjects() {
        return this.margins != null ? this.margins.stream().map(x -> (Margin)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setMarginObjects(List<Margin> objs) {
        this.margins = objs != null ? objs.stream().map(x -> new ExpandableField<Margin>(x.getId(), (Margin)x)).collect(Collectors.toList()) : null;
    }

    public static InvoiceItem create(Map<String, Object> params) throws StripeException {
        return InvoiceItem.create(params, (RequestOptions)null);
    }

    public static InvoiceItem create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/invoiceitems";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (InvoiceItem)InvoiceItem.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    public static InvoiceItem create(InvoiceItemCreateParams params) throws StripeException {
        return InvoiceItem.create(params, (RequestOptions)null);
    }

    public static InvoiceItem create(InvoiceItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoiceitems";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItem)InvoiceItem.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    public InvoiceItem delete() throws StripeException {
        return this.delete(null, null);
    }

    public InvoiceItem delete(RequestOptions options) throws StripeException {
        return this.delete(null, options);
    }

    public InvoiceItem delete(Map<String, Object> params) throws StripeException {
        return this.delete(params, null);
    }

    public InvoiceItem delete(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, params, options);
        return (InvoiceItem)this.getResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    public static InvoiceItemCollection list(Map<String, Object> params) throws StripeException {
        return InvoiceItem.list(params, (RequestOptions)null);
    }

    public static InvoiceItemCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/invoiceitems";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (InvoiceItemCollection)InvoiceItem.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceItemCollection.class));
    }

    public static InvoiceItemCollection list(InvoiceItemListParams params) throws StripeException {
        return InvoiceItem.list(params, (RequestOptions)null);
    }

    public static InvoiceItemCollection list(InvoiceItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/invoiceitems";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItemCollection)InvoiceItem.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceItemCollection.class));
    }

    public static InvoiceItem retrieve(String invoiceitem) throws StripeException {
        return InvoiceItem.retrieve(invoiceitem, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static InvoiceItem retrieve(String invoiceitem, RequestOptions options) throws StripeException {
        return InvoiceItem.retrieve(invoiceitem, (Map<String, Object>)null, options);
    }

    public static InvoiceItem retrieve(String invoiceitem, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (InvoiceItem)InvoiceItem.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    public static InvoiceItem retrieve(String invoiceitem, InvoiceItemRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(invoiceitem));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItem)InvoiceItem.getGlobalResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    public InvoiceItem update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public InvoiceItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (InvoiceItem)this.getResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    public InvoiceItem update(InvoiceItemUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public InvoiceItem update(InvoiceItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoiceitems/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceItem)this.getResponseGetter().request(request, (Type)((Object)InvoiceItem.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.invoice, responseGetter);
        this.trySetResponseGetter(this.parent, responseGetter);
        this.trySetResponseGetter(this.period, responseGetter);
        this.trySetResponseGetter(this.pricing, responseGetter);
        this.trySetResponseGetter(this.prorationDetails, responseGetter);
        this.trySetResponseGetter(this.testClock, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomerAccount() {
        return this.customerAccount;
    }

    @Generated
    public Long getDate() {
        return this.date;
    }

    @Generated
    public Boolean getDeleted() {
        return this.deleted;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getDiscountable() {
        return this.discountable;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public Long getNetAmount() {
        return this.netAmount;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Parent getParent() {
        return this.parent;
    }

    @Generated
    public Period getPeriod() {
        return this.period;
    }

    @Generated
    public Pricing getPricing() {
        return this.pricing;
    }

    @Generated
    public Boolean getProration() {
        return this.proration;
    }

    @Generated
    public ProrationDetails getProrationDetails() {
        return this.prorationDetails;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public List<TaxRate> getTaxRates() {
        return this.taxRates;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomerAccount(String customerAccount) {
        this.customerAccount = customerAccount;
    }

    @Generated
    public void setDate(Long date) {
        this.date = date;
    }

    @Generated
    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setNetAmount(Long netAmount) {
        this.netAmount = netAmount;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setParent(Parent parent) {
        this.parent = parent;
    }

    @Generated
    public void setPeriod(Period period) {
        this.period = period;
    }

    @Generated
    public void setPricing(Pricing pricing) {
        this.pricing = pricing;
    }

    @Generated
    public void setProration(Boolean proration) {
        this.proration = proration;
    }

    @Generated
    public void setProrationDetails(ProrationDetails prorationDetails) {
        this.prorationDetails = prorationDetails;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setTaxRates(List<TaxRate> taxRates) {
        this.taxRates = taxRates;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceItem)) {
            return false;
        }
        InvoiceItem other = (InvoiceItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$date = this.getDate();
        Long other$date = other.getDate();
        if (this$date == null ? other$date != null : !((Object)this$date).equals(other$date)) {
            return false;
        }
        Boolean this$deleted = this.getDeleted();
        Boolean other$deleted = other.getDeleted();
        if (this$deleted == null ? other$deleted != null : !((Object)this$deleted).equals(other$deleted)) {
            return false;
        }
        Boolean this$discountable = this.getDiscountable();
        Boolean other$discountable = other.getDiscountable();
        if (this$discountable == null ? other$discountable != null : !((Object)this$discountable).equals(other$discountable)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$netAmount = this.getNetAmount();
        Long other$netAmount = other.getNetAmount();
        if (this$netAmount == null ? other$netAmount != null : !((Object)this$netAmount).equals(other$netAmount)) {
            return false;
        }
        Boolean this$proration = this.getProration();
        Boolean other$proration = other.getProration();
        if (this$proration == null ? other$proration != null : !((Object)this$proration).equals(other$proration)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerAccount = this.getCustomerAccount();
        String other$customerAccount = other.getCustomerAccount();
        if (this$customerAccount == null ? other$customerAccount != null : !this$customerAccount.equals(other$customerAccount)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        List<String> this$margins = this.getMargins();
        List<String> other$margins = other.getMargins();
        if (this$margins == null ? other$margins != null : !((Object)this$margins).equals(other$margins)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Parent this$parent = this.getParent();
        Parent other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Period this$period = this.getPeriod();
        Period other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Pricing this$pricing = this.getPricing();
        Pricing other$pricing = other.getPricing();
        if (this$pricing == null ? other$pricing != null : !((Object)this$pricing).equals(other$pricing)) {
            return false;
        }
        ProrationDetails this$prorationDetails = this.getProrationDetails();
        ProrationDetails other$prorationDetails = other.getProrationDetails();
        if (this$prorationDetails == null ? other$prorationDetails != null : !((Object)this$prorationDetails).equals(other$prorationDetails)) {
            return false;
        }
        List<TaxRate> this$taxRates = this.getTaxRates();
        List<TaxRate> other$taxRates = other.getTaxRates();
        if (this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        return !(this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvoiceItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $date = this.getDate();
        result = result * 59 + ($date == null ? 43 : ((Object)$date).hashCode());
        Boolean $deleted = this.getDeleted();
        result = result * 59 + ($deleted == null ? 43 : ((Object)$deleted).hashCode());
        Boolean $discountable = this.getDiscountable();
        result = result * 59 + ($discountable == null ? 43 : ((Object)$discountable).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $netAmount = this.getNetAmount();
        result = result * 59 + ($netAmount == null ? 43 : ((Object)$netAmount).hashCode());
        Boolean $proration = this.getProration();
        result = result * 59 + ($proration == null ? 43 : ((Object)$proration).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerAccount = this.getCustomerAccount();
        result = result * 59 + ($customerAccount == null ? 43 : $customerAccount.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        List<String> $margins = this.getMargins();
        result = result * 59 + ($margins == null ? 43 : ((Object)$margins).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Parent $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Period $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Pricing $pricing = this.getPricing();
        result = result * 59 + ($pricing == null ? 43 : ((Object)$pricing).hashCode());
        ProrationDetails $prorationDetails = this.getProrationDetails();
        result = result * 59 + ($prorationDetails == null ? 43 : ((Object)$prorationDetails).hashCode());
        List<TaxRate> $taxRates = this.getTaxRates();
        result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Parent
    extends StripeObject {
        @SerializedName(value="subscription_details")
        SubscriptionDetails subscriptionDetails;
        @SerializedName(value="type")
        String type;

        @Generated
        public SubscriptionDetails getSubscriptionDetails() {
            return this.subscriptionDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setSubscriptionDetails(SubscriptionDetails subscriptionDetails) {
            this.subscriptionDetails = subscriptionDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SubscriptionDetails this$subscriptionDetails = this.getSubscriptionDetails();
            SubscriptionDetails other$subscriptionDetails = other.getSubscriptionDetails();
            if (this$subscriptionDetails == null ? other$subscriptionDetails != null : !((Object)this$subscriptionDetails).equals(other$subscriptionDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Parent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SubscriptionDetails $subscriptionDetails = this.getSubscriptionDetails();
            result = result * 59 + ($subscriptionDetails == null ? 43 : ((Object)$subscriptionDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class SubscriptionDetails
        extends StripeObject {
            @SerializedName(value="subscription")
            String subscription;
            @SerializedName(value="subscription_item")
            String subscriptionItem;

            @Generated
            public String getSubscription() {
                return this.subscription;
            }

            @Generated
            public String getSubscriptionItem() {
                return this.subscriptionItem;
            }

            @Generated
            public void setSubscription(String subscription) {
                this.subscription = subscription;
            }

            @Generated
            public void setSubscriptionItem(String subscriptionItem) {
                this.subscriptionItem = subscriptionItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SubscriptionDetails)) {
                    return false;
                }
                SubscriptionDetails other = (SubscriptionDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$subscription = this.getSubscription();
                String other$subscription = other.getSubscription();
                if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
                    return false;
                }
                String this$subscriptionItem = this.getSubscriptionItem();
                String other$subscriptionItem = other.getSubscriptionItem();
                return !(this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SubscriptionDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $subscription = this.getSubscription();
                result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
                String $subscriptionItem = this.getSubscriptionItem();
                result = result * 59 + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
                return result;
            }
        }
    }

    public static class Period
    extends StripeObject {
        @SerializedName(value="end")
        Long end;
        @SerializedName(value="start")
        Long start;

        @Generated
        public Long getEnd() {
            return this.end;
        }

        @Generated
        public Long getStart() {
            return this.start;
        }

        @Generated
        public void setEnd(Long end) {
            this.end = end;
        }

        @Generated
        public void setStart(Long start) {
            this.start = start;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Period)) {
                return false;
            }
            Period other = (Period)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$end = this.getEnd();
            Long other$end = other.getEnd();
            if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
                return false;
            }
            Long this$start = this.getStart();
            Long other$start = other.getStart();
            return !(this$start == null ? other$start != null : !((Object)this$start).equals(other$start));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Period;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
            Long $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            return result;
        }
    }

    public static class Pricing
    extends StripeObject {
        @SerializedName(value="price_details")
        PriceDetails priceDetails;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="unit_amount_decimal")
        BigDecimal unitAmountDecimal;

        @Generated
        public PriceDetails getPriceDetails() {
            return this.priceDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public BigDecimal getUnitAmountDecimal() {
            return this.unitAmountDecimal;
        }

        @Generated
        public void setPriceDetails(PriceDetails priceDetails) {
            this.priceDetails = priceDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
            this.unitAmountDecimal = unitAmountDecimal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pricing)) {
                return false;
            }
            Pricing other = (Pricing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            PriceDetails this$priceDetails = this.getPriceDetails();
            PriceDetails other$priceDetails = other.getPriceDetails();
            if (this$priceDetails == null ? other$priceDetails != null : !((Object)this$priceDetails).equals(other$priceDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
            BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
            return !(this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pricing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PriceDetails $priceDetails = this.getPriceDetails();
            result = result * 59 + ($priceDetails == null ? 43 : ((Object)$priceDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
            result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
            return result;
        }

        public static class PriceDetails
        extends StripeObject {
            @SerializedName(value="price")
            String price;
            @SerializedName(value="product")
            String product;

            @Generated
            public String getPrice() {
                return this.price;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public void setPrice(String price) {
                this.price = price;
            }

            @Generated
            public void setProduct(String product) {
                this.product = product;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PriceDetails)) {
                    return false;
                }
                PriceDetails other = (PriceDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$price = this.getPrice();
                String other$price = other.getPrice();
                if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                    return false;
                }
                String this$product = this.getProduct();
                String other$product = other.getProduct();
                return !(this$product == null ? other$product != null : !this$product.equals(other$product));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PriceDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : $price.hashCode());
                String $product = this.getProduct();
                result = result * 59 + ($product == null ? 43 : $product.hashCode());
                return result;
            }
        }
    }

    public static class ProrationDetails
    extends StripeObject {
        @SerializedName(value="discount_amounts")
        List<DiscountAmount> discountAmounts;

        @Generated
        public List<DiscountAmount> getDiscountAmounts() {
            return this.discountAmounts;
        }

        @Generated
        public void setDiscountAmounts(List<DiscountAmount> discountAmounts) {
            this.discountAmounts = discountAmounts;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ProrationDetails)) {
                return false;
            }
            ProrationDetails other = (ProrationDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<DiscountAmount> this$discountAmounts = this.getDiscountAmounts();
            List<DiscountAmount> other$discountAmounts = other.getDiscountAmounts();
            return !(this$discountAmounts == null ? other$discountAmounts != null : !((Object)this$discountAmounts).equals(other$discountAmounts));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ProrationDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<DiscountAmount> $discountAmounts = this.getDiscountAmounts();
            result = result * 59 + ($discountAmounts == null ? 43 : ((Object)$discountAmounts).hashCode());
            return result;
        }

        public static class DiscountAmount
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="discount")
            ExpandableField<Discount> discount;

            public String getDiscount() {
                return this.discount != null ? this.discount.getId() : null;
            }

            public void setDiscount(String id) {
                this.discount = ApiResource.setExpandableFieldId(id, this.discount);
            }

            public Discount getDiscountObject() {
                return this.discount != null ? this.discount.getExpanded() : null;
            }

            public void setDiscountObject(Discount expandableObject) {
                this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DiscountAmount)) {
                    return false;
                }
                DiscountAmount other = (DiscountAmount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$discount = this.getDiscount();
                String other$discount = other.getDiscount();
                return !(this$discount == null ? other$discount != null : !this$discount.equals(other$discount));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DiscountAmount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $discount = this.getDiscount();
                result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                return result;
            }
        }
    }
}

