/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Account;
import com.stripe.model.Application;
import com.stripe.model.Coupon;
import com.stripe.model.Customer;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Invoice;
import com.stripe.model.MetadataStore;
import com.stripe.model.PaymentMethod;
import com.stripe.model.Plan;
import com.stripe.model.Price;
import com.stripe.model.PromotionCode;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.SubscriptionScheduleCollection;
import com.stripe.model.TaxId;
import com.stripe.model.TaxRate;
import com.stripe.model.testhelpers.TestClock;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.SubscriptionScheduleAmendParams;
import com.stripe.param.SubscriptionScheduleCancelParams;
import com.stripe.param.SubscriptionScheduleCreateParams;
import com.stripe.param.SubscriptionScheduleListParams;
import com.stripe.param.SubscriptionScheduleReleaseParams;
import com.stripe.param.SubscriptionScheduleRetrieveParams;
import com.stripe.param.SubscriptionScheduleUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class SubscriptionSchedule
extends ApiResource
implements HasId,
MetadataStore<SubscriptionSchedule> {
    @SerializedName(value="application")
    ExpandableField<Application> application;
    @SerializedName(value="billing_behavior")
    String billingBehavior;
    @SerializedName(value="billing_mode")
    BillingMode billingMode;
    @SerializedName(value="canceled_at")
    Long canceledAt;
    @SerializedName(value="completed_at")
    Long completedAt;
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="current_phase")
    CurrentPhase currentPhase;
    @SerializedName(value="customer")
    ExpandableField<Customer> customer;
    @SerializedName(value="customer_account")
    String customerAccount;
    @SerializedName(value="default_settings")
    DefaultSettings defaultSettings;
    @SerializedName(value="end_behavior")
    String endBehavior;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="last_price_migration_error")
    LastPriceMigrationError lastPriceMigrationError;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="phases")
    List<Phase> phases;
    @SerializedName(value="prebilling")
    Prebilling prebilling;
    @SerializedName(value="released_at")
    Long releasedAt;
    @SerializedName(value="released_subscription")
    String releasedSubscription;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="test_clock")
    ExpandableField<TestClock> testClock;

    public String getApplication() {
        return this.application != null ? this.application.getId() : null;
    }

    public void setApplication(String id) {
        this.application = ApiResource.setExpandableFieldId(id, this.application);
    }

    public Application getApplicationObject() {
        return this.application != null ? this.application.getExpanded() : null;
    }

    public void setApplicationObject(Application expandableObject) {
        this.application = new ExpandableField<Application>(expandableObject.getId(), expandableObject);
    }

    public String getCustomer() {
        return this.customer != null ? this.customer.getId() : null;
    }

    public void setCustomer(String id) {
        this.customer = ApiResource.setExpandableFieldId(id, this.customer);
    }

    public Customer getCustomerObject() {
        return this.customer != null ? this.customer.getExpanded() : null;
    }

    public void setCustomerObject(Customer expandableObject) {
        this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
    }

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public String getTestClock() {
        return this.testClock != null ? this.testClock.getId() : null;
    }

    public void setTestClock(String id) {
        this.testClock = ApiResource.setExpandableFieldId(id, this.testClock);
    }

    public TestClock getTestClockObject() {
        return this.testClock != null ? this.testClock.getExpanded() : null;
    }

    public void setTestClockObject(TestClock expandableObject) {
        this.testClock = new ExpandableField<TestClock>(expandableObject.getId(), expandableObject);
    }

    public SubscriptionSchedule amend() throws StripeException {
        return this.amend((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule amend(RequestOptions options) throws StripeException {
        return this.amend((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule amend(Map<String, Object> params) throws StripeException {
        return this.amend(params, (RequestOptions)null);
    }

    public SubscriptionSchedule amend(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/amend", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule amend(SubscriptionScheduleAmendParams params) throws StripeException {
        return this.amend(params, (RequestOptions)null);
    }

    public SubscriptionSchedule amend(SubscriptionScheduleAmendParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/amend", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public SubscriptionSchedule cancel(SubscriptionScheduleCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public static SubscriptionSchedule create(Map<String, Object> params) throws StripeException {
        return SubscriptionSchedule.create(params, (RequestOptions)null);
    }

    public static SubscriptionSchedule create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_schedules";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionSchedule)SubscriptionSchedule.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params) throws StripeException {
        return SubscriptionSchedule.create(params, (RequestOptions)null);
    }

    public static SubscriptionSchedule create(SubscriptionScheduleCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_schedules";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionSchedule)SubscriptionSchedule.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public static SubscriptionScheduleCollection list(Map<String, Object> params) throws StripeException {
        return SubscriptionSchedule.list(params, (RequestOptions)null);
    }

    public static SubscriptionScheduleCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_schedules";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (SubscriptionScheduleCollection)SubscriptionSchedule.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionScheduleCollection.class));
    }

    public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params) throws StripeException {
        return SubscriptionSchedule.list(params, (RequestOptions)null);
    }

    public static SubscriptionScheduleCollection list(SubscriptionScheduleListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/subscription_schedules";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionScheduleCollection)SubscriptionSchedule.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionScheduleCollection.class));
    }

    public SubscriptionSchedule release() throws StripeException {
        return this.release((Map<String, Object>)null, (RequestOptions)null);
    }

    public SubscriptionSchedule release(RequestOptions options) throws StripeException {
        return this.release((Map<String, Object>)null, options);
    }

    public SubscriptionSchedule release(Map<String, Object> params) throws StripeException {
        return this.release(params, (RequestOptions)null);
    }

    public SubscriptionSchedule release(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params) throws StripeException {
        return this.release(params, (RequestOptions)null);
    }

    public SubscriptionSchedule release(SubscriptionScheduleReleaseParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s/release", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public static SubscriptionSchedule retrieve(String schedule) throws StripeException {
        return SubscriptionSchedule.retrieve(schedule, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static SubscriptionSchedule retrieve(String schedule, RequestOptions options) throws StripeException {
        return SubscriptionSchedule.retrieve(schedule, (Map<String, Object>)null, options);
    }

    public static SubscriptionSchedule retrieve(String schedule, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (SubscriptionSchedule)SubscriptionSchedule.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public static SubscriptionSchedule retrieve(String schedule, SubscriptionScheduleRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(schedule));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionSchedule)SubscriptionSchedule.getGlobalResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public SubscriptionSchedule update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public SubscriptionSchedule update(SubscriptionScheduleUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/subscription_schedules/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (SubscriptionSchedule)this.getResponseGetter().request(request, (Type)((Object)SubscriptionSchedule.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.application, responseGetter);
        this.trySetResponseGetter(this.billingMode, responseGetter);
        this.trySetResponseGetter(this.currentPhase, responseGetter);
        this.trySetResponseGetter(this.customer, responseGetter);
        this.trySetResponseGetter(this.defaultSettings, responseGetter);
        this.trySetResponseGetter(this.lastPriceMigrationError, responseGetter);
        this.trySetResponseGetter(this.prebilling, responseGetter);
        this.trySetResponseGetter(this.subscription, responseGetter);
        this.trySetResponseGetter(this.testClock, responseGetter);
    }

    @Generated
    public String getBillingBehavior() {
        return this.billingBehavior;
    }

    @Generated
    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    @Generated
    public Long getCanceledAt() {
        return this.canceledAt;
    }

    @Generated
    public Long getCompletedAt() {
        return this.completedAt;
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public CurrentPhase getCurrentPhase() {
        return this.currentPhase;
    }

    @Generated
    public String getCustomerAccount() {
        return this.customerAccount;
    }

    @Generated
    public DefaultSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    @Generated
    public String getEndBehavior() {
        return this.endBehavior;
    }

    @Generated
    public LastPriceMigrationError getLastPriceMigrationError() {
        return this.lastPriceMigrationError;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Phase> getPhases() {
        return this.phases;
    }

    @Generated
    public Prebilling getPrebilling() {
        return this.prebilling;
    }

    @Generated
    public Long getReleasedAt() {
        return this.releasedAt;
    }

    @Generated
    public String getReleasedSubscription() {
        return this.releasedSubscription;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public void setBillingBehavior(String billingBehavior) {
        this.billingBehavior = billingBehavior;
    }

    @Generated
    public void setBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
    }

    @Generated
    public void setCanceledAt(Long canceledAt) {
        this.canceledAt = canceledAt;
    }

    @Generated
    public void setCompletedAt(Long completedAt) {
        this.completedAt = completedAt;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setCurrentPhase(CurrentPhase currentPhase) {
        this.currentPhase = currentPhase;
    }

    @Generated
    public void setCustomerAccount(String customerAccount) {
        this.customerAccount = customerAccount;
    }

    @Generated
    public void setDefaultSettings(DefaultSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    @Generated
    public void setEndBehavior(String endBehavior) {
        this.endBehavior = endBehavior;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLastPriceMigrationError(LastPriceMigrationError lastPriceMigrationError) {
        this.lastPriceMigrationError = lastPriceMigrationError;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    @Generated
    public void setPrebilling(Prebilling prebilling) {
        this.prebilling = prebilling;
    }

    @Generated
    public void setReleasedAt(Long releasedAt) {
        this.releasedAt = releasedAt;
    }

    @Generated
    public void setReleasedSubscription(String releasedSubscription) {
        this.releasedSubscription = releasedSubscription;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionSchedule)) {
            return false;
        }
        SubscriptionSchedule other = (SubscriptionSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$canceledAt = this.getCanceledAt();
        Long other$canceledAt = other.getCanceledAt();
        if (this$canceledAt == null ? other$canceledAt != null : !((Object)this$canceledAt).equals(other$canceledAt)) {
            return false;
        }
        Long this$completedAt = this.getCompletedAt();
        Long other$completedAt = other.getCompletedAt();
        if (this$completedAt == null ? other$completedAt != null : !((Object)this$completedAt).equals(other$completedAt)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$releasedAt = this.getReleasedAt();
        Long other$releasedAt = other.getReleasedAt();
        if (this$releasedAt == null ? other$releasedAt != null : !((Object)this$releasedAt).equals(other$releasedAt)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        String this$billingBehavior = this.getBillingBehavior();
        String other$billingBehavior = other.getBillingBehavior();
        if (this$billingBehavior == null ? other$billingBehavior != null : !this$billingBehavior.equals(other$billingBehavior)) {
            return false;
        }
        BillingMode this$billingMode = this.getBillingMode();
        BillingMode other$billingMode = other.getBillingMode();
        if (this$billingMode == null ? other$billingMode != null : !((Object)this$billingMode).equals(other$billingMode)) {
            return false;
        }
        CurrentPhase this$currentPhase = this.getCurrentPhase();
        CurrentPhase other$currentPhase = other.getCurrentPhase();
        if (this$currentPhase == null ? other$currentPhase != null : !((Object)this$currentPhase).equals(other$currentPhase)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerAccount = this.getCustomerAccount();
        String other$customerAccount = other.getCustomerAccount();
        if (this$customerAccount == null ? other$customerAccount != null : !this$customerAccount.equals(other$customerAccount)) {
            return false;
        }
        DefaultSettings this$defaultSettings = this.getDefaultSettings();
        DefaultSettings other$defaultSettings = other.getDefaultSettings();
        if (this$defaultSettings == null ? other$defaultSettings != null : !((Object)this$defaultSettings).equals(other$defaultSettings)) {
            return false;
        }
        String this$endBehavior = this.getEndBehavior();
        String other$endBehavior = other.getEndBehavior();
        if (this$endBehavior == null ? other$endBehavior != null : !this$endBehavior.equals(other$endBehavior)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        LastPriceMigrationError this$lastPriceMigrationError = this.getLastPriceMigrationError();
        LastPriceMigrationError other$lastPriceMigrationError = other.getLastPriceMigrationError();
        if (this$lastPriceMigrationError == null ? other$lastPriceMigrationError != null : !((Object)this$lastPriceMigrationError).equals(other$lastPriceMigrationError)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Phase> this$phases = this.getPhases();
        List<Phase> other$phases = other.getPhases();
        if (this$phases == null ? other$phases != null : !((Object)this$phases).equals(other$phases)) {
            return false;
        }
        Prebilling this$prebilling = this.getPrebilling();
        Prebilling other$prebilling = other.getPrebilling();
        if (this$prebilling == null ? other$prebilling != null : !((Object)this$prebilling).equals(other$prebilling)) {
            return false;
        }
        String this$releasedSubscription = this.getReleasedSubscription();
        String other$releasedSubscription = other.getReleasedSubscription();
        if (this$releasedSubscription == null ? other$releasedSubscription != null : !this$releasedSubscription.equals(other$releasedSubscription)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        String this$testClock = this.getTestClock();
        String other$testClock = other.getTestClock();
        return !(this$testClock == null ? other$testClock != null : !this$testClock.equals(other$testClock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionSchedule;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $canceledAt = this.getCanceledAt();
        result = result * 59 + ($canceledAt == null ? 43 : ((Object)$canceledAt).hashCode());
        Long $completedAt = this.getCompletedAt();
        result = result * 59 + ($completedAt == null ? 43 : ((Object)$completedAt).hashCode());
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $releasedAt = this.getReleasedAt();
        result = result * 59 + ($releasedAt == null ? 43 : ((Object)$releasedAt).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        String $billingBehavior = this.getBillingBehavior();
        result = result * 59 + ($billingBehavior == null ? 43 : $billingBehavior.hashCode());
        BillingMode $billingMode = this.getBillingMode();
        result = result * 59 + ($billingMode == null ? 43 : ((Object)$billingMode).hashCode());
        CurrentPhase $currentPhase = this.getCurrentPhase();
        result = result * 59 + ($currentPhase == null ? 43 : ((Object)$currentPhase).hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerAccount = this.getCustomerAccount();
        result = result * 59 + ($customerAccount == null ? 43 : $customerAccount.hashCode());
        DefaultSettings $defaultSettings = this.getDefaultSettings();
        result = result * 59 + ($defaultSettings == null ? 43 : ((Object)$defaultSettings).hashCode());
        String $endBehavior = this.getEndBehavior();
        result = result * 59 + ($endBehavior == null ? 43 : $endBehavior.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        LastPriceMigrationError $lastPriceMigrationError = this.getLastPriceMigrationError();
        result = result * 59 + ($lastPriceMigrationError == null ? 43 : ((Object)$lastPriceMigrationError).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Phase> $phases = this.getPhases();
        result = result * 59 + ($phases == null ? 43 : ((Object)$phases).hashCode());
        Prebilling $prebilling = this.getPrebilling();
        result = result * 59 + ($prebilling == null ? 43 : ((Object)$prebilling).hashCode());
        String $releasedSubscription = this.getReleasedSubscription();
        result = result * 59 + ($releasedSubscription == null ? 43 : $releasedSubscription.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        String $testClock = this.getTestClock();
        result = result * 59 + ($testClock == null ? 43 : $testClock.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class BillingMode
    extends StripeObject {
        @SerializedName(value="flexible")
        Flexible flexible;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="updated_at")
        Long updatedAt;

        @Generated
        public Flexible getFlexible() {
            return this.flexible;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public Long getUpdatedAt() {
            return this.updatedAt;
        }

        @Generated
        public void setFlexible(Flexible flexible) {
            this.flexible = flexible;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUpdatedAt(Long updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BillingMode)) {
                return false;
            }
            BillingMode other = (BillingMode)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$updatedAt = this.getUpdatedAt();
            Long other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
                return false;
            }
            Flexible this$flexible = this.getFlexible();
            Flexible other$flexible = other.getFlexible();
            if (this$flexible == null ? other$flexible != null : !((Object)this$flexible).equals(other$flexible)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BillingMode;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $updatedAt = this.getUpdatedAt();
            result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
            Flexible $flexible = this.getFlexible();
            result = result * 59 + ($flexible == null ? 43 : ((Object)$flexible).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Flexible
        extends StripeObject {
            @SerializedName(value="proration_discounts")
            String prorationDiscounts;

            @Generated
            public String getProrationDiscounts() {
                return this.prorationDiscounts;
            }

            @Generated
            public void setProrationDiscounts(String prorationDiscounts) {
                this.prorationDiscounts = prorationDiscounts;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Flexible)) {
                    return false;
                }
                Flexible other = (Flexible)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$prorationDiscounts = this.getProrationDiscounts();
                String other$prorationDiscounts = other.getProrationDiscounts();
                return !(this$prorationDiscounts == null ? other$prorationDiscounts != null : !this$prorationDiscounts.equals(other$prorationDiscounts));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Flexible;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $prorationDiscounts = this.getProrationDiscounts();
                result = result * 59 + ($prorationDiscounts == null ? 43 : $prorationDiscounts.hashCode());
                return result;
            }
        }
    }

    public static class CurrentPhase
    extends StripeObject {
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="start_date")
        Long startDate;

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public Long getStartDate() {
            return this.startDate;
        }

        @Generated
        public void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        @Generated
        public void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CurrentPhase)) {
                return false;
            }
            CurrentPhase other = (CurrentPhase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$endDate = this.getEndDate();
            Long other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            Long this$startDate = this.getStartDate();
            Long other$startDate = other.getStartDate();
            return !(this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CurrentPhase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            Long $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            return result;
        }
    }

    public static class DefaultSettings
    extends StripeObject {
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="automatic_tax")
        AutomaticTax automaticTax;
        @SerializedName(value="billing_cycle_anchor")
        String billingCycleAnchor;
        @SerializedName(value="billing_thresholds")
        BillingThresholds billingThresholds;
        @SerializedName(value="collection_method")
        String collectionMethod;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="on_behalf_of")
        ExpandableField<Account> onBehalfOf;
        @SerializedName(value="transfer_data")
        TransferData transferData;

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        public String getOnBehalfOf() {
            return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
        }

        public void setOnBehalfOf(String id) {
            this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
        }

        public Account getOnBehalfOfObject() {
            return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
        }

        public void setOnBehalfOfObject(Account expandableObject) {
            this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public AutomaticTax getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public String getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public String getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
        }

        @Generated
        public void setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
        }

        @Generated
        public void setBillingCycleAnchor(String billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setBillingThresholds(BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setCollectionMethod(String collectionMethod) {
            this.collectionMethod = collectionMethod;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
        }

        @Generated
        public void setTransferData(TransferData transferData) {
            this.transferData = transferData;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DefaultSettings)) {
                return false;
            }
            DefaultSettings other = (DefaultSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
            BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
            if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
                return false;
            }
            AutomaticTax this$automaticTax = this.getAutomaticTax();
            AutomaticTax other$automaticTax = other.getAutomaticTax();
            if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
                return false;
            }
            String this$billingCycleAnchor = this.getBillingCycleAnchor();
            String other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) {
                return false;
            }
            BillingThresholds this$billingThresholds = this.getBillingThresholds();
            BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            String this$collectionMethod = this.getCollectionMethod();
            String other$collectionMethod = other.getCollectionMethod();
            if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
            InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
            if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
                return false;
            }
            String this$onBehalfOf = this.getOnBehalfOf();
            String other$onBehalfOf = other.getOnBehalfOf();
            if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
                return false;
            }
            TransferData this$transferData = this.getTransferData();
            TransferData other$transferData = other.getTransferData();
            return !(this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DefaultSettings;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
            result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
            AutomaticTax $automaticTax = this.getAutomaticTax();
            result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
            String $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
            BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            String $collectionMethod = this.getCollectionMethod();
            result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
            result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
            String $onBehalfOf = this.getOnBehalfOf();
            result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
            TransferData $transferData = this.getTransferData();
            result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
            return result;
        }

        public static class AutomaticTax
        extends StripeObject {
            @SerializedName(value="disabled_reason")
            String disabledReason;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="liability")
            Liability liability;

            @Generated
            public String getDisabledReason() {
                return this.disabledReason;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Liability getLiability() {
                return this.liability;
            }

            @Generated
            public void setDisabledReason(String disabledReason) {
                this.disabledReason = disabledReason;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setLiability(Liability liability) {
                this.liability = liability;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AutomaticTax)) {
                    return false;
                }
                AutomaticTax other = (AutomaticTax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                String this$disabledReason = this.getDisabledReason();
                String other$disabledReason = other.getDisabledReason();
                if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                    return false;
                }
                Liability this$liability = this.getLiability();
                Liability other$liability = other.getLiability();
                return !(this$liability == null ? other$liability != null : !((Object)this$liability).equals(other$liability));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AutomaticTax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                String $disabledReason = this.getDisabledReason();
                result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
                Liability $liability = this.getLiability();
                result = result * 59 + ($liability == null ? 43 : ((Object)$liability).hashCode());
                return result;
            }

            public static class Liability
            extends StripeObject {
                @SerializedName(value="account")
                ExpandableField<Account> account;
                @SerializedName(value="type")
                String type;

                public String getAccount() {
                    return this.account != null ? this.account.getId() : null;
                }

                public void setAccount(String id) {
                    this.account = ApiResource.setExpandableFieldId(id, this.account);
                }

                public Account getAccountObject() {
                    return this.account != null ? this.account.getExpanded() : null;
                }

                public void setAccountObject(Account expandableObject) {
                    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Liability)) {
                        return false;
                    }
                    Liability other = (Liability)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$account = this.getAccount();
                    String other$account = other.getAccount();
                    if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Liability;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $account = this.getAccount();
                    result = result * 59 + ($account == null ? 43 : $account.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class BillingThresholds
        extends StripeObject {
            @SerializedName(value="amount_gte")
            Long amountGte;
            @SerializedName(value="reset_billing_cycle_anchor")
            Boolean resetBillingCycleAnchor;

            @Generated
            public Long getAmountGte() {
                return this.amountGte;
            }

            @Generated
            public Boolean getResetBillingCycleAnchor() {
                return this.resetBillingCycleAnchor;
            }

            @Generated
            public void setAmountGte(Long amountGte) {
                this.amountGte = amountGte;
            }

            @Generated
            public void setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingThresholds)) {
                    return false;
                }
                BillingThresholds other = (BillingThresholds)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountGte = this.getAmountGte();
                Long other$amountGte = other.getAmountGte();
                if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                    return false;
                }
                Boolean this$resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
                Boolean other$resetBillingCycleAnchor = other.getResetBillingCycleAnchor();
                return !(this$resetBillingCycleAnchor == null ? other$resetBillingCycleAnchor != null : !((Object)this$resetBillingCycleAnchor).equals(other$resetBillingCycleAnchor));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingThresholds;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountGte = this.getAmountGte();
                result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
                Boolean $resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
                result = result * 59 + ($resetBillingCycleAnchor == null ? 43 : ((Object)$resetBillingCycleAnchor).hashCode());
                return result;
            }
        }

        public static class InvoiceSettings
        extends StripeObject {
            @SerializedName(value="account_tax_ids")
            List<ExpandableField<TaxId>> accountTaxIds;
            @SerializedName(value="days_until_due")
            Long daysUntilDue;
            @SerializedName(value="issuer")
            Issuer issuer;

            public List<String> getAccountTaxIds() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIds(List<String> ids) {
                if (ids == null) {
                    this.accountTaxIds = null;
                    return;
                }
                if (this.accountTaxIds != null && this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
                    return;
                }
                this.accountTaxIds = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
            }

            public List<TaxId> getAccountTaxIdObjects() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> (TaxId)x.getExpanded()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIdObjects(List<TaxId> objs) {
                this.accountTaxIds = objs != null ? objs.stream().map(x -> new ExpandableField<TaxId>(x.getId(), (TaxId)x)).collect(Collectors.toList()) : null;
            }

            @Generated
            public Long getDaysUntilDue() {
                return this.daysUntilDue;
            }

            @Generated
            public Issuer getIssuer() {
                return this.issuer;
            }

            @Generated
            public void setDaysUntilDue(Long daysUntilDue) {
                this.daysUntilDue = daysUntilDue;
            }

            @Generated
            public void setIssuer(Issuer issuer) {
                this.issuer = issuer;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceSettings)) {
                    return false;
                }
                InvoiceSettings other = (InvoiceSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$daysUntilDue = this.getDaysUntilDue();
                Long other$daysUntilDue = other.getDaysUntilDue();
                if (this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue)) {
                    return false;
                }
                List<String> this$accountTaxIds = this.getAccountTaxIds();
                List<String> other$accountTaxIds = other.getAccountTaxIds();
                if (this$accountTaxIds == null ? other$accountTaxIds != null : !((Object)this$accountTaxIds).equals(other$accountTaxIds)) {
                    return false;
                }
                Issuer this$issuer = this.getIssuer();
                Issuer other$issuer = other.getIssuer();
                return !(this$issuer == null ? other$issuer != null : !((Object)this$issuer).equals(other$issuer));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $daysUntilDue = this.getDaysUntilDue();
                result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
                List<String> $accountTaxIds = this.getAccountTaxIds();
                result = result * 59 + ($accountTaxIds == null ? 43 : ((Object)$accountTaxIds).hashCode());
                Issuer $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : ((Object)$issuer).hashCode());
                return result;
            }

            public static class Issuer
            extends StripeObject {
                @SerializedName(value="account")
                ExpandableField<Account> account;
                @SerializedName(value="type")
                String type;

                public String getAccount() {
                    return this.account != null ? this.account.getId() : null;
                }

                public void setAccount(String id) {
                    this.account = ApiResource.setExpandableFieldId(id, this.account);
                }

                public Account getAccountObject() {
                    return this.account != null ? this.account.getExpanded() : null;
                }

                public void setAccountObject(Account expandableObject) {
                    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Issuer)) {
                        return false;
                    }
                    Issuer other = (Issuer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$account = this.getAccount();
                    String other$account = other.getAccount();
                    if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Issuer;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $account = this.getAccount();
                    result = result * 59 + ($account == null ? 43 : $account.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class TransferData
        extends StripeObject {
            @SerializedName(value="amount_percent")
            BigDecimal amountPercent;
            @SerializedName(value="destination")
            ExpandableField<Account> destination;

            public String getDestination() {
                return this.destination != null ? this.destination.getId() : null;
            }

            public void setDestination(String id) {
                this.destination = ApiResource.setExpandableFieldId(id, this.destination);
            }

            public Account getDestinationObject() {
                return this.destination != null ? this.destination.getExpanded() : null;
            }

            public void setDestinationObject(Account expandableObject) {
                this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public BigDecimal getAmountPercent() {
                return this.amountPercent;
            }

            @Generated
            public void setAmountPercent(BigDecimal amountPercent) {
                this.amountPercent = amountPercent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TransferData)) {
                    return false;
                }
                TransferData other = (TransferData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BigDecimal this$amountPercent = this.getAmountPercent();
                BigDecimal other$amountPercent = other.getAmountPercent();
                if (this$amountPercent == null ? other$amountPercent != null : !((Object)this$amountPercent).equals(other$amountPercent)) {
                    return false;
                }
                String this$destination = this.getDestination();
                String other$destination = other.getDestination();
                return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TransferData;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigDecimal $amountPercent = this.getAmountPercent();
                result = result * 59 + ($amountPercent == null ? 43 : ((Object)$amountPercent).hashCode());
                String $destination = this.getDestination();
                result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
                return result;
            }
        }
    }

    public static class LastPriceMigrationError
    extends StripeObject {
        @SerializedName(value="errored_at")
        Long erroredAt;
        @SerializedName(value="failed_transitions")
        List<FailedTransition> failedTransitions;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getErroredAt() {
            return this.erroredAt;
        }

        @Generated
        public List<FailedTransition> getFailedTransitions() {
            return this.failedTransitions;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setErroredAt(Long erroredAt) {
            this.erroredAt = erroredAt;
        }

        @Generated
        public void setFailedTransitions(List<FailedTransition> failedTransitions) {
            this.failedTransitions = failedTransitions;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LastPriceMigrationError)) {
                return false;
            }
            LastPriceMigrationError other = (LastPriceMigrationError)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$erroredAt = this.getErroredAt();
            Long other$erroredAt = other.getErroredAt();
            if (this$erroredAt == null ? other$erroredAt != null : !((Object)this$erroredAt).equals(other$erroredAt)) {
                return false;
            }
            List<FailedTransition> this$failedTransitions = this.getFailedTransitions();
            List<FailedTransition> other$failedTransitions = other.getFailedTransitions();
            if (this$failedTransitions == null ? other$failedTransitions != null : !((Object)this$failedTransitions).equals(other$failedTransitions)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LastPriceMigrationError;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $erroredAt = this.getErroredAt();
            result = result * 59 + ($erroredAt == null ? 43 : ((Object)$erroredAt).hashCode());
            List<FailedTransition> $failedTransitions = this.getFailedTransitions();
            result = result * 59 + ($failedTransitions == null ? 43 : ((Object)$failedTransitions).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class FailedTransition
        extends StripeObject {
            @SerializedName(value="source_price")
            String sourcePrice;
            @SerializedName(value="target_price")
            String targetPrice;

            @Generated
            public String getSourcePrice() {
                return this.sourcePrice;
            }

            @Generated
            public String getTargetPrice() {
                return this.targetPrice;
            }

            @Generated
            public void setSourcePrice(String sourcePrice) {
                this.sourcePrice = sourcePrice;
            }

            @Generated
            public void setTargetPrice(String targetPrice) {
                this.targetPrice = targetPrice;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FailedTransition)) {
                    return false;
                }
                FailedTransition other = (FailedTransition)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$sourcePrice = this.getSourcePrice();
                String other$sourcePrice = other.getSourcePrice();
                if (this$sourcePrice == null ? other$sourcePrice != null : !this$sourcePrice.equals(other$sourcePrice)) {
                    return false;
                }
                String this$targetPrice = this.getTargetPrice();
                String other$targetPrice = other.getTargetPrice();
                return !(this$targetPrice == null ? other$targetPrice != null : !this$targetPrice.equals(other$targetPrice));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FailedTransition;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $sourcePrice = this.getSourcePrice();
                result = result * 59 + ($sourcePrice == null ? 43 : $sourcePrice.hashCode());
                String $targetPrice = this.getTargetPrice();
                result = result * 59 + ($targetPrice == null ? 43 : $targetPrice.hashCode());
                return result;
            }
        }
    }

    public static class Prebilling
    extends StripeObject {
        @SerializedName(value="invoice")
        ExpandableField<Invoice> invoice;
        @SerializedName(value="period_end")
        Long periodEnd;
        @SerializedName(value="period_start")
        Long periodStart;
        @SerializedName(value="update_behavior")
        String updateBehavior;

        public String getInvoice() {
            return this.invoice != null ? this.invoice.getId() : null;
        }

        public void setInvoice(String id) {
            this.invoice = ApiResource.setExpandableFieldId(id, this.invoice);
        }

        public Invoice getInvoiceObject() {
            return this.invoice != null ? this.invoice.getExpanded() : null;
        }

        public void setInvoiceObject(Invoice expandableObject) {
            this.invoice = new ExpandableField<Invoice>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getPeriodEnd() {
            return this.periodEnd;
        }

        @Generated
        public Long getPeriodStart() {
            return this.periodStart;
        }

        @Generated
        public String getUpdateBehavior() {
            return this.updateBehavior;
        }

        @Generated
        public void setPeriodEnd(Long periodEnd) {
            this.periodEnd = periodEnd;
        }

        @Generated
        public void setPeriodStart(Long periodStart) {
            this.periodStart = periodStart;
        }

        @Generated
        public void setUpdateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Prebilling)) {
                return false;
            }
            Prebilling other = (Prebilling)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$periodEnd = this.getPeriodEnd();
            Long other$periodEnd = other.getPeriodEnd();
            if (this$periodEnd == null ? other$periodEnd != null : !((Object)this$periodEnd).equals(other$periodEnd)) {
                return false;
            }
            Long this$periodStart = this.getPeriodStart();
            Long other$periodStart = other.getPeriodStart();
            if (this$periodStart == null ? other$periodStart != null : !((Object)this$periodStart).equals(other$periodStart)) {
                return false;
            }
            String this$invoice = this.getInvoice();
            String other$invoice = other.getInvoice();
            if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
                return false;
            }
            String this$updateBehavior = this.getUpdateBehavior();
            String other$updateBehavior = other.getUpdateBehavior();
            return !(this$updateBehavior == null ? other$updateBehavior != null : !this$updateBehavior.equals(other$updateBehavior));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Prebilling;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $periodEnd = this.getPeriodEnd();
            result = result * 59 + ($periodEnd == null ? 43 : ((Object)$periodEnd).hashCode());
            Long $periodStart = this.getPeriodStart();
            result = result * 59 + ($periodStart == null ? 43 : ((Object)$periodStart).hashCode());
            String $invoice = this.getInvoice();
            result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
            String $updateBehavior = this.getUpdateBehavior();
            result = result * 59 + ($updateBehavior == null ? 43 : $updateBehavior.hashCode());
            return result;
        }
    }

    public static class Phase
    extends StripeObject {
        @SerializedName(value="add_invoice_items")
        List<AddInvoiceItem> addInvoiceItems;
        @SerializedName(value="application_fee_percent")
        BigDecimal applicationFeePercent;
        @SerializedName(value="automatic_tax")
        AutomaticTax automaticTax;
        @SerializedName(value="billing_cycle_anchor")
        String billingCycleAnchor;
        @SerializedName(value="billing_thresholds")
        BillingThresholds billingThresholds;
        @SerializedName(value="collection_method")
        String collectionMethod;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="default_payment_method")
        ExpandableField<PaymentMethod> defaultPaymentMethod;
        @SerializedName(value="default_tax_rates")
        List<TaxRate> defaultTaxRates;
        @SerializedName(value="description")
        String description;
        @SerializedName(value="discounts")
        List<Discount> discounts;
        @SerializedName(value="end_date")
        Long endDate;
        @SerializedName(value="invoice_settings")
        InvoiceSettings invoiceSettings;
        @SerializedName(value="items")
        List<Item> items;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="on_behalf_of")
        ExpandableField<Account> onBehalfOf;
        @SerializedName(value="pause_collection")
        PauseCollection pauseCollection;
        @SerializedName(value="proration_behavior")
        String prorationBehavior;
        @SerializedName(value="start_date")
        Long startDate;
        @SerializedName(value="transfer_data")
        TransferData transferData;
        @SerializedName(value="trial_continuation")
        String trialContinuation;
        @SerializedName(value="trial_end")
        Long trialEnd;
        @SerializedName(value="trial_settings")
        TrialSettings trialSettings;

        public String getDefaultPaymentMethod() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getId() : null;
        }

        public void setDefaultPaymentMethod(String id) {
            this.defaultPaymentMethod = ApiResource.setExpandableFieldId(id, this.defaultPaymentMethod);
        }

        public PaymentMethod getDefaultPaymentMethodObject() {
            return this.defaultPaymentMethod != null ? this.defaultPaymentMethod.getExpanded() : null;
        }

        public void setDefaultPaymentMethodObject(PaymentMethod expandableObject) {
            this.defaultPaymentMethod = new ExpandableField<PaymentMethod>(expandableObject.getId(), expandableObject);
        }

        public String getOnBehalfOf() {
            return this.onBehalfOf != null ? this.onBehalfOf.getId() : null;
        }

        public void setOnBehalfOf(String id) {
            this.onBehalfOf = ApiResource.setExpandableFieldId(id, this.onBehalfOf);
        }

        public Account getOnBehalfOfObject() {
            return this.onBehalfOf != null ? this.onBehalfOf.getExpanded() : null;
        }

        public void setOnBehalfOfObject(Account expandableObject) {
            this.onBehalfOf = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public List<AddInvoiceItem> getAddInvoiceItems() {
            return this.addInvoiceItems;
        }

        @Generated
        public BigDecimal getApplicationFeePercent() {
            return this.applicationFeePercent;
        }

        @Generated
        public AutomaticTax getAutomaticTax() {
            return this.automaticTax;
        }

        @Generated
        public String getBillingCycleAnchor() {
            return this.billingCycleAnchor;
        }

        @Generated
        public BillingThresholds getBillingThresholds() {
            return this.billingThresholds;
        }

        @Generated
        public String getCollectionMethod() {
            return this.collectionMethod;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public List<TaxRate> getDefaultTaxRates() {
            return this.defaultTaxRates;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<Discount> getDiscounts() {
            return this.discounts;
        }

        @Generated
        public Long getEndDate() {
            return this.endDate;
        }

        @Generated
        public InvoiceSettings getInvoiceSettings() {
            return this.invoiceSettings;
        }

        @Generated
        public List<Item> getItems() {
            return this.items;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public PauseCollection getPauseCollection() {
            return this.pauseCollection;
        }

        @Generated
        public String getProrationBehavior() {
            return this.prorationBehavior;
        }

        @Generated
        public Long getStartDate() {
            return this.startDate;
        }

        @Generated
        public TransferData getTransferData() {
            return this.transferData;
        }

        @Generated
        public String getTrialContinuation() {
            return this.trialContinuation;
        }

        @Generated
        public Long getTrialEnd() {
            return this.trialEnd;
        }

        @Generated
        public TrialSettings getTrialSettings() {
            return this.trialSettings;
        }

        @Generated
        public void setAddInvoiceItems(List<AddInvoiceItem> addInvoiceItems) {
            this.addInvoiceItems = addInvoiceItems;
        }

        @Generated
        public void setApplicationFeePercent(BigDecimal applicationFeePercent) {
            this.applicationFeePercent = applicationFeePercent;
        }

        @Generated
        public void setAutomaticTax(AutomaticTax automaticTax) {
            this.automaticTax = automaticTax;
        }

        @Generated
        public void setBillingCycleAnchor(String billingCycleAnchor) {
            this.billingCycleAnchor = billingCycleAnchor;
        }

        @Generated
        public void setBillingThresholds(BillingThresholds billingThresholds) {
            this.billingThresholds = billingThresholds;
        }

        @Generated
        public void setCollectionMethod(String collectionMethod) {
            this.collectionMethod = collectionMethod;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setDefaultTaxRates(List<TaxRate> defaultTaxRates) {
            this.defaultTaxRates = defaultTaxRates;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setDiscounts(List<Discount> discounts) {
            this.discounts = discounts;
        }

        @Generated
        public void setEndDate(Long endDate) {
            this.endDate = endDate;
        }

        @Generated
        public void setInvoiceSettings(InvoiceSettings invoiceSettings) {
            this.invoiceSettings = invoiceSettings;
        }

        @Generated
        public void setItems(List<Item> items) {
            this.items = items;
        }

        @Generated
        public void setMetadata(Map<String, String> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public void setPauseCollection(PauseCollection pauseCollection) {
            this.pauseCollection = pauseCollection;
        }

        @Generated
        public void setProrationBehavior(String prorationBehavior) {
            this.prorationBehavior = prorationBehavior;
        }

        @Generated
        public void setStartDate(Long startDate) {
            this.startDate = startDate;
        }

        @Generated
        public void setTransferData(TransferData transferData) {
            this.transferData = transferData;
        }

        @Generated
        public void setTrialContinuation(String trialContinuation) {
            this.trialContinuation = trialContinuation;
        }

        @Generated
        public void setTrialEnd(Long trialEnd) {
            this.trialEnd = trialEnd;
        }

        @Generated
        public void setTrialSettings(TrialSettings trialSettings) {
            this.trialSettings = trialSettings;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Phase)) {
                return false;
            }
            Phase other = (Phase)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$endDate = this.getEndDate();
            Long other$endDate = other.getEndDate();
            if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
                return false;
            }
            Long this$startDate = this.getStartDate();
            Long other$startDate = other.getStartDate();
            if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
                return false;
            }
            Long this$trialEnd = this.getTrialEnd();
            Long other$trialEnd = other.getTrialEnd();
            if (this$trialEnd == null ? other$trialEnd != null : !((Object)this$trialEnd).equals(other$trialEnd)) {
                return false;
            }
            List<AddInvoiceItem> this$addInvoiceItems = this.getAddInvoiceItems();
            List<AddInvoiceItem> other$addInvoiceItems = other.getAddInvoiceItems();
            if (this$addInvoiceItems == null ? other$addInvoiceItems != null : !((Object)this$addInvoiceItems).equals(other$addInvoiceItems)) {
                return false;
            }
            BigDecimal this$applicationFeePercent = this.getApplicationFeePercent();
            BigDecimal other$applicationFeePercent = other.getApplicationFeePercent();
            if (this$applicationFeePercent == null ? other$applicationFeePercent != null : !((Object)this$applicationFeePercent).equals(other$applicationFeePercent)) {
                return false;
            }
            AutomaticTax this$automaticTax = this.getAutomaticTax();
            AutomaticTax other$automaticTax = other.getAutomaticTax();
            if (this$automaticTax == null ? other$automaticTax != null : !((Object)this$automaticTax).equals(other$automaticTax)) {
                return false;
            }
            String this$billingCycleAnchor = this.getBillingCycleAnchor();
            String other$billingCycleAnchor = other.getBillingCycleAnchor();
            if (this$billingCycleAnchor == null ? other$billingCycleAnchor != null : !this$billingCycleAnchor.equals(other$billingCycleAnchor)) {
                return false;
            }
            BillingThresholds this$billingThresholds = this.getBillingThresholds();
            BillingThresholds other$billingThresholds = other.getBillingThresholds();
            if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                return false;
            }
            String this$collectionMethod = this.getCollectionMethod();
            String other$collectionMethod = other.getCollectionMethod();
            if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            String this$defaultPaymentMethod = this.getDefaultPaymentMethod();
            String other$defaultPaymentMethod = other.getDefaultPaymentMethod();
            if (this$defaultPaymentMethod == null ? other$defaultPaymentMethod != null : !this$defaultPaymentMethod.equals(other$defaultPaymentMethod)) {
                return false;
            }
            List<TaxRate> this$defaultTaxRates = this.getDefaultTaxRates();
            List<TaxRate> other$defaultTaxRates = other.getDefaultTaxRates();
            if (this$defaultTaxRates == null ? other$defaultTaxRates != null : !((Object)this$defaultTaxRates).equals(other$defaultTaxRates)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<Discount> this$discounts = this.getDiscounts();
            List<Discount> other$discounts = other.getDiscounts();
            if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                return false;
            }
            InvoiceSettings this$invoiceSettings = this.getInvoiceSettings();
            InvoiceSettings other$invoiceSettings = other.getInvoiceSettings();
            if (this$invoiceSettings == null ? other$invoiceSettings != null : !((Object)this$invoiceSettings).equals(other$invoiceSettings)) {
                return false;
            }
            List<Item> this$items = this.getItems();
            List<Item> other$items = other.getItems();
            if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            String this$onBehalfOf = this.getOnBehalfOf();
            String other$onBehalfOf = other.getOnBehalfOf();
            if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
                return false;
            }
            PauseCollection this$pauseCollection = this.getPauseCollection();
            PauseCollection other$pauseCollection = other.getPauseCollection();
            if (this$pauseCollection == null ? other$pauseCollection != null : !((Object)this$pauseCollection).equals(other$pauseCollection)) {
                return false;
            }
            String this$prorationBehavior = this.getProrationBehavior();
            String other$prorationBehavior = other.getProrationBehavior();
            if (this$prorationBehavior == null ? other$prorationBehavior != null : !this$prorationBehavior.equals(other$prorationBehavior)) {
                return false;
            }
            TransferData this$transferData = this.getTransferData();
            TransferData other$transferData = other.getTransferData();
            if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
                return false;
            }
            String this$trialContinuation = this.getTrialContinuation();
            String other$trialContinuation = other.getTrialContinuation();
            if (this$trialContinuation == null ? other$trialContinuation != null : !this$trialContinuation.equals(other$trialContinuation)) {
                return false;
            }
            TrialSettings this$trialSettings = this.getTrialSettings();
            TrialSettings other$trialSettings = other.getTrialSettings();
            return !(this$trialSettings == null ? other$trialSettings != null : !((Object)this$trialSettings).equals(other$trialSettings));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Phase;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $endDate = this.getEndDate();
            result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
            Long $startDate = this.getStartDate();
            result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
            Long $trialEnd = this.getTrialEnd();
            result = result * 59 + ($trialEnd == null ? 43 : ((Object)$trialEnd).hashCode());
            List<AddInvoiceItem> $addInvoiceItems = this.getAddInvoiceItems();
            result = result * 59 + ($addInvoiceItems == null ? 43 : ((Object)$addInvoiceItems).hashCode());
            BigDecimal $applicationFeePercent = this.getApplicationFeePercent();
            result = result * 59 + ($applicationFeePercent == null ? 43 : ((Object)$applicationFeePercent).hashCode());
            AutomaticTax $automaticTax = this.getAutomaticTax();
            result = result * 59 + ($automaticTax == null ? 43 : ((Object)$automaticTax).hashCode());
            String $billingCycleAnchor = this.getBillingCycleAnchor();
            result = result * 59 + ($billingCycleAnchor == null ? 43 : $billingCycleAnchor.hashCode());
            BillingThresholds $billingThresholds = this.getBillingThresholds();
            result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
            String $collectionMethod = this.getCollectionMethod();
            result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            String $defaultPaymentMethod = this.getDefaultPaymentMethod();
            result = result * 59 + ($defaultPaymentMethod == null ? 43 : $defaultPaymentMethod.hashCode());
            List<TaxRate> $defaultTaxRates = this.getDefaultTaxRates();
            result = result * 59 + ($defaultTaxRates == null ? 43 : ((Object)$defaultTaxRates).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<Discount> $discounts = this.getDiscounts();
            result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
            InvoiceSettings $invoiceSettings = this.getInvoiceSettings();
            result = result * 59 + ($invoiceSettings == null ? 43 : ((Object)$invoiceSettings).hashCode());
            List<Item> $items = this.getItems();
            result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            String $onBehalfOf = this.getOnBehalfOf();
            result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
            PauseCollection $pauseCollection = this.getPauseCollection();
            result = result * 59 + ($pauseCollection == null ? 43 : ((Object)$pauseCollection).hashCode());
            String $prorationBehavior = this.getProrationBehavior();
            result = result * 59 + ($prorationBehavior == null ? 43 : $prorationBehavior.hashCode());
            TransferData $transferData = this.getTransferData();
            result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
            String $trialContinuation = this.getTrialContinuation();
            result = result * 59 + ($trialContinuation == null ? 43 : $trialContinuation.hashCode());
            TrialSettings $trialSettings = this.getTrialSettings();
            result = result * 59 + ($trialSettings == null ? 43 : ((Object)$trialSettings).hashCode());
            return result;
        }

        public static class AutomaticTax
        extends StripeObject {
            @SerializedName(value="disabled_reason")
            String disabledReason;
            @SerializedName(value="enabled")
            Boolean enabled;
            @SerializedName(value="liability")
            Liability liability;

            @Generated
            public String getDisabledReason() {
                return this.disabledReason;
            }

            @Generated
            public Boolean getEnabled() {
                return this.enabled;
            }

            @Generated
            public Liability getLiability() {
                return this.liability;
            }

            @Generated
            public void setDisabledReason(String disabledReason) {
                this.disabledReason = disabledReason;
            }

            @Generated
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }

            @Generated
            public void setLiability(Liability liability) {
                this.liability = liability;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AutomaticTax)) {
                    return false;
                }
                AutomaticTax other = (AutomaticTax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$enabled = this.getEnabled();
                Boolean other$enabled = other.getEnabled();
                if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                    return false;
                }
                String this$disabledReason = this.getDisabledReason();
                String other$disabledReason = other.getDisabledReason();
                if (this$disabledReason == null ? other$disabledReason != null : !this$disabledReason.equals(other$disabledReason)) {
                    return false;
                }
                Liability this$liability = this.getLiability();
                Liability other$liability = other.getLiability();
                return !(this$liability == null ? other$liability != null : !((Object)this$liability).equals(other$liability));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AutomaticTax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $enabled = this.getEnabled();
                result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
                String $disabledReason = this.getDisabledReason();
                result = result * 59 + ($disabledReason == null ? 43 : $disabledReason.hashCode());
                Liability $liability = this.getLiability();
                result = result * 59 + ($liability == null ? 43 : ((Object)$liability).hashCode());
                return result;
            }

            public static class Liability
            extends StripeObject {
                @SerializedName(value="account")
                ExpandableField<Account> account;
                @SerializedName(value="type")
                String type;

                public String getAccount() {
                    return this.account != null ? this.account.getId() : null;
                }

                public void setAccount(String id) {
                    this.account = ApiResource.setExpandableFieldId(id, this.account);
                }

                public Account getAccountObject() {
                    return this.account != null ? this.account.getExpanded() : null;
                }

                public void setAccountObject(Account expandableObject) {
                    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Liability)) {
                        return false;
                    }
                    Liability other = (Liability)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$account = this.getAccount();
                    String other$account = other.getAccount();
                    if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Liability;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $account = this.getAccount();
                    result = result * 59 + ($account == null ? 43 : $account.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class BillingThresholds
        extends StripeObject {
            @SerializedName(value="amount_gte")
            Long amountGte;
            @SerializedName(value="reset_billing_cycle_anchor")
            Boolean resetBillingCycleAnchor;

            @Generated
            public Long getAmountGte() {
                return this.amountGte;
            }

            @Generated
            public Boolean getResetBillingCycleAnchor() {
                return this.resetBillingCycleAnchor;
            }

            @Generated
            public void setAmountGte(Long amountGte) {
                this.amountGte = amountGte;
            }

            @Generated
            public void setResetBillingCycleAnchor(Boolean resetBillingCycleAnchor) {
                this.resetBillingCycleAnchor = resetBillingCycleAnchor;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingThresholds)) {
                    return false;
                }
                BillingThresholds other = (BillingThresholds)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amountGte = this.getAmountGte();
                Long other$amountGte = other.getAmountGte();
                if (this$amountGte == null ? other$amountGte != null : !((Object)this$amountGte).equals(other$amountGte)) {
                    return false;
                }
                Boolean this$resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
                Boolean other$resetBillingCycleAnchor = other.getResetBillingCycleAnchor();
                return !(this$resetBillingCycleAnchor == null ? other$resetBillingCycleAnchor != null : !((Object)this$resetBillingCycleAnchor).equals(other$resetBillingCycleAnchor));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingThresholds;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amountGte = this.getAmountGte();
                result = result * 59 + ($amountGte == null ? 43 : ((Object)$amountGte).hashCode());
                Boolean $resetBillingCycleAnchor = this.getResetBillingCycleAnchor();
                result = result * 59 + ($resetBillingCycleAnchor == null ? 43 : ((Object)$resetBillingCycleAnchor).hashCode());
                return result;
            }
        }

        public static class InvoiceSettings
        extends StripeObject {
            @SerializedName(value="account_tax_ids")
            List<ExpandableField<TaxId>> accountTaxIds;
            @SerializedName(value="days_until_due")
            Long daysUntilDue;
            @SerializedName(value="issuer")
            Issuer issuer;

            public List<String> getAccountTaxIds() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIds(List<String> ids) {
                if (ids == null) {
                    this.accountTaxIds = null;
                    return;
                }
                if (this.accountTaxIds != null && this.accountTaxIds.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
                    return;
                }
                this.accountTaxIds = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
            }

            public List<TaxId> getAccountTaxIdObjects() {
                return this.accountTaxIds != null ? this.accountTaxIds.stream().map(x -> (TaxId)x.getExpanded()).collect(Collectors.toList()) : null;
            }

            public void setAccountTaxIdObjects(List<TaxId> objs) {
                this.accountTaxIds = objs != null ? objs.stream().map(x -> new ExpandableField<TaxId>(x.getId(), (TaxId)x)).collect(Collectors.toList()) : null;
            }

            @Generated
            public Long getDaysUntilDue() {
                return this.daysUntilDue;
            }

            @Generated
            public Issuer getIssuer() {
                return this.issuer;
            }

            @Generated
            public void setDaysUntilDue(Long daysUntilDue) {
                this.daysUntilDue = daysUntilDue;
            }

            @Generated
            public void setIssuer(Issuer issuer) {
                this.issuer = issuer;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceSettings)) {
                    return false;
                }
                InvoiceSettings other = (InvoiceSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$daysUntilDue = this.getDaysUntilDue();
                Long other$daysUntilDue = other.getDaysUntilDue();
                if (this$daysUntilDue == null ? other$daysUntilDue != null : !((Object)this$daysUntilDue).equals(other$daysUntilDue)) {
                    return false;
                }
                List<String> this$accountTaxIds = this.getAccountTaxIds();
                List<String> other$accountTaxIds = other.getAccountTaxIds();
                if (this$accountTaxIds == null ? other$accountTaxIds != null : !((Object)this$accountTaxIds).equals(other$accountTaxIds)) {
                    return false;
                }
                Issuer this$issuer = this.getIssuer();
                Issuer other$issuer = other.getIssuer();
                return !(this$issuer == null ? other$issuer != null : !((Object)this$issuer).equals(other$issuer));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $daysUntilDue = this.getDaysUntilDue();
                result = result * 59 + ($daysUntilDue == null ? 43 : ((Object)$daysUntilDue).hashCode());
                List<String> $accountTaxIds = this.getAccountTaxIds();
                result = result * 59 + ($accountTaxIds == null ? 43 : ((Object)$accountTaxIds).hashCode());
                Issuer $issuer = this.getIssuer();
                result = result * 59 + ($issuer == null ? 43 : ((Object)$issuer).hashCode());
                return result;
            }

            public static class Issuer
            extends StripeObject {
                @SerializedName(value="account")
                ExpandableField<Account> account;
                @SerializedName(value="type")
                String type;

                public String getAccount() {
                    return this.account != null ? this.account.getId() : null;
                }

                public void setAccount(String id) {
                    this.account = ApiResource.setExpandableFieldId(id, this.account);
                }

                public Account getAccountObject() {
                    return this.account != null ? this.account.getExpanded() : null;
                }

                public void setAccountObject(Account expandableObject) {
                    this.account = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Issuer)) {
                        return false;
                    }
                    Issuer other = (Issuer)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$account = this.getAccount();
                    String other$account = other.getAccount();
                    if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Issuer;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $account = this.getAccount();
                    result = result * 59 + ($account == null ? 43 : $account.hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class PauseCollection
        extends StripeObject {
            @SerializedName(value="behavior")
            String behavior;

            @Generated
            public String getBehavior() {
                return this.behavior;
            }

            @Generated
            public void setBehavior(String behavior) {
                this.behavior = behavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PauseCollection)) {
                    return false;
                }
                PauseCollection other = (PauseCollection)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$behavior = this.getBehavior();
                String other$behavior = other.getBehavior();
                return !(this$behavior == null ? other$behavior != null : !this$behavior.equals(other$behavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PauseCollection;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $behavior = this.getBehavior();
                result = result * 59 + ($behavior == null ? 43 : $behavior.hashCode());
                return result;
            }
        }

        public static class TransferData
        extends StripeObject {
            @SerializedName(value="amount_percent")
            BigDecimal amountPercent;
            @SerializedName(value="destination")
            ExpandableField<Account> destination;

            public String getDestination() {
                return this.destination != null ? this.destination.getId() : null;
            }

            public void setDestination(String id) {
                this.destination = ApiResource.setExpandableFieldId(id, this.destination);
            }

            public Account getDestinationObject() {
                return this.destination != null ? this.destination.getExpanded() : null;
            }

            public void setDestinationObject(Account expandableObject) {
                this.destination = new ExpandableField<Account>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public BigDecimal getAmountPercent() {
                return this.amountPercent;
            }

            @Generated
            public void setAmountPercent(BigDecimal amountPercent) {
                this.amountPercent = amountPercent;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TransferData)) {
                    return false;
                }
                TransferData other = (TransferData)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BigDecimal this$amountPercent = this.getAmountPercent();
                BigDecimal other$amountPercent = other.getAmountPercent();
                if (this$amountPercent == null ? other$amountPercent != null : !((Object)this$amountPercent).equals(other$amountPercent)) {
                    return false;
                }
                String this$destination = this.getDestination();
                String other$destination = other.getDestination();
                return !(this$destination == null ? other$destination != null : !this$destination.equals(other$destination));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TransferData;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BigDecimal $amountPercent = this.getAmountPercent();
                result = result * 59 + ($amountPercent == null ? 43 : ((Object)$amountPercent).hashCode());
                String $destination = this.getDestination();
                result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
                return result;
            }
        }

        public static class TrialSettings
        extends StripeObject {
            @SerializedName(value="end_behavior")
            EndBehavior endBehavior;

            @Generated
            public EndBehavior getEndBehavior() {
                return this.endBehavior;
            }

            @Generated
            public void setEndBehavior(EndBehavior endBehavior) {
                this.endBehavior = endBehavior;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TrialSettings)) {
                    return false;
                }
                TrialSettings other = (TrialSettings)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                EndBehavior this$endBehavior = this.getEndBehavior();
                EndBehavior other$endBehavior = other.getEndBehavior();
                return !(this$endBehavior == null ? other$endBehavior != null : !((Object)this$endBehavior).equals(other$endBehavior));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TrialSettings;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                EndBehavior $endBehavior = this.getEndBehavior();
                result = result * 59 + ($endBehavior == null ? 43 : ((Object)$endBehavior).hashCode());
                return result;
            }

            public static class EndBehavior
            extends StripeObject {
                @SerializedName(value="prorate_up_front")
                String prorateUpFront;

                @Generated
                public String getProrateUpFront() {
                    return this.prorateUpFront;
                }

                @Generated
                public void setProrateUpFront(String prorateUpFront) {
                    this.prorateUpFront = prorateUpFront;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof EndBehavior)) {
                        return false;
                    }
                    EndBehavior other = (EndBehavior)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$prorateUpFront = this.getProrateUpFront();
                    String other$prorateUpFront = other.getProrateUpFront();
                    return !(this$prorateUpFront == null ? other$prorateUpFront != null : !this$prorateUpFront.equals(other$prorateUpFront));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof EndBehavior;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $prorateUpFront = this.getProrateUpFront();
                    result = result * 59 + ($prorateUpFront == null ? 43 : $prorateUpFront.hashCode());
                    return result;
                }
            }
        }

        public static class Item
        extends StripeObject {
            @SerializedName(value="billing_thresholds")
            BillingThresholds billingThresholds;
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="plan")
            ExpandableField<Plan> plan;
            @SerializedName(value="price")
            ExpandableField<Price> price;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            List<TaxRate> taxRates;
            @SerializedName(value="trial")
            Trial trial;

            public String getPlan() {
                return this.plan != null ? this.plan.getId() : null;
            }

            public void setPlan(String id) {
                this.plan = ApiResource.setExpandableFieldId(id, this.plan);
            }

            public Plan getPlanObject() {
                return this.plan != null ? this.plan.getExpanded() : null;
            }

            public void setPlanObject(Plan expandableObject) {
                this.plan = new ExpandableField<Plan>(expandableObject.getId(), expandableObject);
            }

            public String getPrice() {
                return this.price != null ? this.price.getId() : null;
            }

            public void setPrice(String id) {
                this.price = ApiResource.setExpandableFieldId(id, this.price);
            }

            public Price getPriceObject() {
                return this.price != null ? this.price.getExpanded() : null;
            }

            public void setPriceObject(Price expandableObject) {
                this.price = new ExpandableField<Price>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public BillingThresholds getBillingThresholds() {
                return this.billingThresholds;
            }

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public List<TaxRate> getTaxRates() {
                return this.taxRates;
            }

            @Generated
            public Trial getTrial() {
                return this.trial;
            }

            @Generated
            public void setBillingThresholds(BillingThresholds billingThresholds) {
                this.billingThresholds = billingThresholds;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
            }

            @Generated
            public void setQuantity(Long quantity) {
                this.quantity = quantity;
            }

            @Generated
            public void setTaxRates(List<TaxRate> taxRates) {
                this.taxRates = taxRates;
            }

            @Generated
            public void setTrial(Trial trial) {
                this.trial = trial;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Item)) {
                    return false;
                }
                Item other = (Item)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$quantity = this.getQuantity();
                Long other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                    return false;
                }
                BillingThresholds this$billingThresholds = this.getBillingThresholds();
                BillingThresholds other$billingThresholds = other.getBillingThresholds();
                if (this$billingThresholds == null ? other$billingThresholds != null : !((Object)this$billingThresholds).equals(other$billingThresholds)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                Map<String, String> this$metadata = this.getMetadata();
                Map<String, String> other$metadata = other.getMetadata();
                if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                    return false;
                }
                String this$plan = this.getPlan();
                String other$plan = other.getPlan();
                if (this$plan == null ? other$plan != null : !this$plan.equals(other$plan)) {
                    return false;
                }
                String this$price = this.getPrice();
                String other$price = other.getPrice();
                if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                    return false;
                }
                List<TaxRate> this$taxRates = this.getTaxRates();
                List<TaxRate> other$taxRates = other.getTaxRates();
                if (this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates)) {
                    return false;
                }
                Trial this$trial = this.getTrial();
                Trial other$trial = other.getTrial();
                return !(this$trial == null ? other$trial != null : !((Object)this$trial).equals(other$trial));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Item;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                BillingThresholds $billingThresholds = this.getBillingThresholds();
                result = result * 59 + ($billingThresholds == null ? 43 : ((Object)$billingThresholds).hashCode());
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                Map<String, String> $metadata = this.getMetadata();
                result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
                String $plan = this.getPlan();
                result = result * 59 + ($plan == null ? 43 : $plan.hashCode());
                String $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : $price.hashCode());
                List<TaxRate> $taxRates = this.getTaxRates();
                result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
                Trial $trial = this.getTrial();
                result = result * 59 + ($trial == null ? 43 : ((Object)$trial).hashCode());
                return result;
            }

            public static class BillingThresholds
            extends StripeObject {
                @SerializedName(value="usage_gte")
                Long usageGte;

                @Generated
                public Long getUsageGte() {
                    return this.usageGte;
                }

                @Generated
                public void setUsageGte(Long usageGte) {
                    this.usageGte = usageGte;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BillingThresholds)) {
                        return false;
                    }
                    BillingThresholds other = (BillingThresholds)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$usageGte = this.getUsageGte();
                    Long other$usageGte = other.getUsageGte();
                    return !(this$usageGte == null ? other$usageGte != null : !((Object)this$usageGte).equals(other$usageGte));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BillingThresholds;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $usageGte = this.getUsageGte();
                    result = result * 59 + ($usageGte == null ? 43 : ((Object)$usageGte).hashCode());
                    return result;
                }
            }

            public static class Trial
            extends StripeObject {
                @SerializedName(value="converts_to")
                List<String> convertsTo;
                @SerializedName(value="type")
                String type;

                @Generated
                public List<String> getConvertsTo() {
                    return this.convertsTo;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setConvertsTo(List<String> convertsTo) {
                    this.convertsTo = convertsTo;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Trial)) {
                        return false;
                    }
                    Trial other = (Trial)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<String> this$convertsTo = this.getConvertsTo();
                    List<String> other$convertsTo = other.getConvertsTo();
                    if (this$convertsTo == null ? other$convertsTo != null : !((Object)this$convertsTo).equals(other$convertsTo)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Trial;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<String> $convertsTo = this.getConvertsTo();
                    result = result * 59 + ($convertsTo == null ? 43 : ((Object)$convertsTo).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="coupon")
                ExpandableField<Coupon> coupon;
                @SerializedName(value="discount")
                ExpandableField<com.stripe.model.Discount> discount;
                @SerializedName(value="discount_end")
                DiscountEnd discountEnd;
                @SerializedName(value="promotion_code")
                ExpandableField<PromotionCode> promotionCode;

                public String getCoupon() {
                    return this.coupon != null ? this.coupon.getId() : null;
                }

                public void setCoupon(String id) {
                    this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
                }

                public Coupon getCouponObject() {
                    return this.coupon != null ? this.coupon.getExpanded() : null;
                }

                public void setCouponObject(Coupon expandableObject) {
                    this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
                }

                public String getDiscount() {
                    return this.discount != null ? this.discount.getId() : null;
                }

                public void setDiscount(String id) {
                    this.discount = ApiResource.setExpandableFieldId(id, this.discount);
                }

                public com.stripe.model.Discount getDiscountObject() {
                    return this.discount != null ? this.discount.getExpanded() : null;
                }

                public void setDiscountObject(com.stripe.model.Discount expandableObject) {
                    this.discount = new ExpandableField<com.stripe.model.Discount>(expandableObject.getId(), expandableObject);
                }

                public String getPromotionCode() {
                    return this.promotionCode != null ? this.promotionCode.getId() : null;
                }

                public void setPromotionCode(String id) {
                    this.promotionCode = ApiResource.setExpandableFieldId(id, this.promotionCode);
                }

                public PromotionCode getPromotionCodeObject() {
                    return this.promotionCode != null ? this.promotionCode.getExpanded() : null;
                }

                public void setPromotionCodeObject(PromotionCode expandableObject) {
                    this.promotionCode = new ExpandableField<PromotionCode>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public DiscountEnd getDiscountEnd() {
                    return this.discountEnd;
                }

                @Generated
                public void setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$coupon = this.getCoupon();
                    String other$coupon = other.getCoupon();
                    if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                        return false;
                    }
                    String this$discount = this.getDiscount();
                    String other$discount = other.getDiscount();
                    if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) {
                        return false;
                    }
                    DiscountEnd this$discountEnd = this.getDiscountEnd();
                    DiscountEnd other$discountEnd = other.getDiscountEnd();
                    if (this$discountEnd == null ? other$discountEnd != null : !((Object)this$discountEnd).equals(other$discountEnd)) {
                        return false;
                    }
                    String this$promotionCode = this.getPromotionCode();
                    String other$promotionCode = other.getPromotionCode();
                    return !(this$promotionCode == null ? other$promotionCode != null : !this$promotionCode.equals(other$promotionCode));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $coupon = this.getCoupon();
                    result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
                    String $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                    DiscountEnd $discountEnd = this.getDiscountEnd();
                    result = result * 59 + ($discountEnd == null ? 43 : ((Object)$discountEnd).hashCode());
                    String $promotionCode = this.getPromotionCode();
                    result = result * 59 + ($promotionCode == null ? 43 : $promotionCode.hashCode());
                    return result;
                }

                public static class DiscountEnd
                extends StripeObject {
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof DiscountEnd)) {
                            return false;
                        }
                        DiscountEnd other = (DiscountEnd)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$timestamp = this.getTimestamp();
                        Long other$timestamp = other.getTimestamp();
                        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof DiscountEnd;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $timestamp = this.getTimestamp();
                        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }
        }

        public static class Discount
        extends StripeObject {
            @SerializedName(value="coupon")
            ExpandableField<Coupon> coupon;
            @SerializedName(value="discount")
            ExpandableField<com.stripe.model.Discount> discount;
            @SerializedName(value="discount_end")
            DiscountEnd discountEnd;
            @SerializedName(value="promotion_code")
            ExpandableField<PromotionCode> promotionCode;

            public String getCoupon() {
                return this.coupon != null ? this.coupon.getId() : null;
            }

            public void setCoupon(String id) {
                this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
            }

            public Coupon getCouponObject() {
                return this.coupon != null ? this.coupon.getExpanded() : null;
            }

            public void setCouponObject(Coupon expandableObject) {
                this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
            }

            public String getDiscount() {
                return this.discount != null ? this.discount.getId() : null;
            }

            public void setDiscount(String id) {
                this.discount = ApiResource.setExpandableFieldId(id, this.discount);
            }

            public com.stripe.model.Discount getDiscountObject() {
                return this.discount != null ? this.discount.getExpanded() : null;
            }

            public void setDiscountObject(com.stripe.model.Discount expandableObject) {
                this.discount = new ExpandableField<com.stripe.model.Discount>(expandableObject.getId(), expandableObject);
            }

            public String getPromotionCode() {
                return this.promotionCode != null ? this.promotionCode.getId() : null;
            }

            public void setPromotionCode(String id) {
                this.promotionCode = ApiResource.setExpandableFieldId(id, this.promotionCode);
            }

            public PromotionCode getPromotionCodeObject() {
                return this.promotionCode != null ? this.promotionCode.getExpanded() : null;
            }

            public void setPromotionCodeObject(PromotionCode expandableObject) {
                this.promotionCode = new ExpandableField<PromotionCode>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public DiscountEnd getDiscountEnd() {
                return this.discountEnd;
            }

            @Generated
            public void setDiscountEnd(DiscountEnd discountEnd) {
                this.discountEnd = discountEnd;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Discount)) {
                    return false;
                }
                Discount other = (Discount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$coupon = this.getCoupon();
                String other$coupon = other.getCoupon();
                if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                    return false;
                }
                String this$discount = this.getDiscount();
                String other$discount = other.getDiscount();
                if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) {
                    return false;
                }
                DiscountEnd this$discountEnd = this.getDiscountEnd();
                DiscountEnd other$discountEnd = other.getDiscountEnd();
                if (this$discountEnd == null ? other$discountEnd != null : !((Object)this$discountEnd).equals(other$discountEnd)) {
                    return false;
                }
                String this$promotionCode = this.getPromotionCode();
                String other$promotionCode = other.getPromotionCode();
                return !(this$promotionCode == null ? other$promotionCode != null : !this$promotionCode.equals(other$promotionCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Discount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $coupon = this.getCoupon();
                result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
                String $discount = this.getDiscount();
                result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                DiscountEnd $discountEnd = this.getDiscountEnd();
                result = result * 59 + ($discountEnd == null ? 43 : ((Object)$discountEnd).hashCode());
                String $promotionCode = this.getPromotionCode();
                result = result * 59 + ($promotionCode == null ? 43 : $promotionCode.hashCode());
                return result;
            }

            public static class DiscountEnd
            extends StripeObject {
                @SerializedName(value="timestamp")
                Long timestamp;
                @SerializedName(value="type")
                String type;

                @Generated
                public Long getTimestamp() {
                    return this.timestamp;
                }

                @Generated
                public String getType() {
                    return this.type;
                }

                @Generated
                public void setTimestamp(Long timestamp) {
                    this.timestamp = timestamp;
                }

                @Generated
                public void setType(String type) {
                    this.type = type;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof DiscountEnd)) {
                        return false;
                    }
                    DiscountEnd other = (DiscountEnd)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$timestamp = this.getTimestamp();
                    Long other$timestamp = other.getTimestamp();
                    if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                        return false;
                    }
                    String this$type = this.getType();
                    String other$type = other.getType();
                    return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof DiscountEnd;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $timestamp = this.getTimestamp();
                    result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                    String $type = this.getType();
                    result = result * 59 + ($type == null ? 43 : $type.hashCode());
                    return result;
                }
            }
        }

        public static class AddInvoiceItem
        extends StripeObject {
            @SerializedName(value="discounts")
            List<Discount> discounts;
            @SerializedName(value="metadata")
            Map<String, String> metadata;
            @SerializedName(value="period")
            Period period;
            @SerializedName(value="price")
            ExpandableField<Price> price;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax_rates")
            List<TaxRate> taxRates;

            public String getPrice() {
                return this.price != null ? this.price.getId() : null;
            }

            public void setPrice(String id) {
                this.price = ApiResource.setExpandableFieldId(id, this.price);
            }

            public Price getPriceObject() {
                return this.price != null ? this.price.getExpanded() : null;
            }

            public void setPriceObject(Price expandableObject) {
                this.price = new ExpandableField<Price>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public List<Discount> getDiscounts() {
                return this.discounts;
            }

            @Generated
            public Map<String, String> getMetadata() {
                return this.metadata;
            }

            @Generated
            public Period getPeriod() {
                return this.period;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public List<TaxRate> getTaxRates() {
                return this.taxRates;
            }

            @Generated
            public void setDiscounts(List<Discount> discounts) {
                this.discounts = discounts;
            }

            @Generated
            public void setMetadata(Map<String, String> metadata) {
                this.metadata = metadata;
            }

            @Generated
            public void setPeriod(Period period) {
                this.period = period;
            }

            @Generated
            public void setQuantity(Long quantity) {
                this.quantity = quantity;
            }

            @Generated
            public void setTaxRates(List<TaxRate> taxRates) {
                this.taxRates = taxRates;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AddInvoiceItem)) {
                    return false;
                }
                AddInvoiceItem other = (AddInvoiceItem)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$quantity = this.getQuantity();
                Long other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                    return false;
                }
                List<Discount> this$discounts = this.getDiscounts();
                List<Discount> other$discounts = other.getDiscounts();
                if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
                    return false;
                }
                Map<String, String> this$metadata = this.getMetadata();
                Map<String, String> other$metadata = other.getMetadata();
                if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                    return false;
                }
                Period this$period = this.getPeriod();
                Period other$period = other.getPeriod();
                if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
                    return false;
                }
                String this$price = this.getPrice();
                String other$price = other.getPrice();
                if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                    return false;
                }
                List<TaxRate> this$taxRates = this.getTaxRates();
                List<TaxRate> other$taxRates = other.getTaxRates();
                return !(this$taxRates == null ? other$taxRates != null : !((Object)this$taxRates).equals(other$taxRates));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AddInvoiceItem;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                List<Discount> $discounts = this.getDiscounts();
                result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
                Map<String, String> $metadata = this.getMetadata();
                result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
                Period $period = this.getPeriod();
                result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
                String $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : $price.hashCode());
                List<TaxRate> $taxRates = this.getTaxRates();
                result = result * 59 + ($taxRates == null ? 43 : ((Object)$taxRates).hashCode());
                return result;
            }

            public static class Period
            extends StripeObject {
                @SerializedName(value="end")
                End end;
                @SerializedName(value="start")
                Start start;

                @Generated
                public End getEnd() {
                    return this.end;
                }

                @Generated
                public Start getStart() {
                    return this.start;
                }

                @Generated
                public void setEnd(End end) {
                    this.end = end;
                }

                @Generated
                public void setStart(Start start) {
                    this.start = start;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Period)) {
                        return false;
                    }
                    Period other = (Period)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    End this$end = this.getEnd();
                    End other$end = other.getEnd();
                    if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
                        return false;
                    }
                    Start this$start = this.getStart();
                    Start other$start = other.getStart();
                    return !(this$start == null ? other$start != null : !((Object)this$start).equals(other$start));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Period;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    End $end = this.getEnd();
                    result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
                    Start $start = this.getStart();
                    result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
                    return result;
                }

                public static class End
                extends StripeObject {
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof End)) {
                            return false;
                        }
                        End other = (End)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$timestamp = this.getTimestamp();
                        Long other$timestamp = other.getTimestamp();
                        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof End;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $timestamp = this.getTimestamp();
                        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }

                public static class Start
                extends StripeObject {
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Start)) {
                            return false;
                        }
                        Start other = (Start)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$timestamp = this.getTimestamp();
                        Long other$timestamp = other.getTimestamp();
                        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Start;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $timestamp = this.getTimestamp();
                        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }

            public static class Discount
            extends StripeObject {
                @SerializedName(value="coupon")
                ExpandableField<Coupon> coupon;
                @SerializedName(value="discount")
                ExpandableField<com.stripe.model.Discount> discount;
                @SerializedName(value="discount_end")
                DiscountEnd discountEnd;
                @SerializedName(value="promotion_code")
                ExpandableField<PromotionCode> promotionCode;

                public String getCoupon() {
                    return this.coupon != null ? this.coupon.getId() : null;
                }

                public void setCoupon(String id) {
                    this.coupon = ApiResource.setExpandableFieldId(id, this.coupon);
                }

                public Coupon getCouponObject() {
                    return this.coupon != null ? this.coupon.getExpanded() : null;
                }

                public void setCouponObject(Coupon expandableObject) {
                    this.coupon = new ExpandableField<Coupon>(expandableObject.getId(), expandableObject);
                }

                public String getDiscount() {
                    return this.discount != null ? this.discount.getId() : null;
                }

                public void setDiscount(String id) {
                    this.discount = ApiResource.setExpandableFieldId(id, this.discount);
                }

                public com.stripe.model.Discount getDiscountObject() {
                    return this.discount != null ? this.discount.getExpanded() : null;
                }

                public void setDiscountObject(com.stripe.model.Discount expandableObject) {
                    this.discount = new ExpandableField<com.stripe.model.Discount>(expandableObject.getId(), expandableObject);
                }

                public String getPromotionCode() {
                    return this.promotionCode != null ? this.promotionCode.getId() : null;
                }

                public void setPromotionCode(String id) {
                    this.promotionCode = ApiResource.setExpandableFieldId(id, this.promotionCode);
                }

                public PromotionCode getPromotionCodeObject() {
                    return this.promotionCode != null ? this.promotionCode.getExpanded() : null;
                }

                public void setPromotionCodeObject(PromotionCode expandableObject) {
                    this.promotionCode = new ExpandableField<PromotionCode>(expandableObject.getId(), expandableObject);
                }

                @Generated
                public DiscountEnd getDiscountEnd() {
                    return this.discountEnd;
                }

                @Generated
                public void setDiscountEnd(DiscountEnd discountEnd) {
                    this.discountEnd = discountEnd;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Discount)) {
                        return false;
                    }
                    Discount other = (Discount)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$coupon = this.getCoupon();
                    String other$coupon = other.getCoupon();
                    if (this$coupon == null ? other$coupon != null : !this$coupon.equals(other$coupon)) {
                        return false;
                    }
                    String this$discount = this.getDiscount();
                    String other$discount = other.getDiscount();
                    if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) {
                        return false;
                    }
                    DiscountEnd this$discountEnd = this.getDiscountEnd();
                    DiscountEnd other$discountEnd = other.getDiscountEnd();
                    if (this$discountEnd == null ? other$discountEnd != null : !((Object)this$discountEnd).equals(other$discountEnd)) {
                        return false;
                    }
                    String this$promotionCode = this.getPromotionCode();
                    String other$promotionCode = other.getPromotionCode();
                    return !(this$promotionCode == null ? other$promotionCode != null : !this$promotionCode.equals(other$promotionCode));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Discount;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $coupon = this.getCoupon();
                    result = result * 59 + ($coupon == null ? 43 : $coupon.hashCode());
                    String $discount = this.getDiscount();
                    result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
                    DiscountEnd $discountEnd = this.getDiscountEnd();
                    result = result * 59 + ($discountEnd == null ? 43 : ((Object)$discountEnd).hashCode());
                    String $promotionCode = this.getPromotionCode();
                    result = result * 59 + ($promotionCode == null ? 43 : $promotionCode.hashCode());
                    return result;
                }

                public static class DiscountEnd
                extends StripeObject {
                    @SerializedName(value="timestamp")
                    Long timestamp;
                    @SerializedName(value="type")
                    String type;

                    @Generated
                    public Long getTimestamp() {
                        return this.timestamp;
                    }

                    @Generated
                    public String getType() {
                        return this.type;
                    }

                    @Generated
                    public void setTimestamp(Long timestamp) {
                        this.timestamp = timestamp;
                    }

                    @Generated
                    public void setType(String type) {
                        this.type = type;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof DiscountEnd)) {
                            return false;
                        }
                        DiscountEnd other = (DiscountEnd)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$timestamp = this.getTimestamp();
                        Long other$timestamp = other.getTimestamp();
                        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                            return false;
                        }
                        String this$type = this.getType();
                        String other$type = other.getType();
                        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof DiscountEnd;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $timestamp = this.getTimestamp();
                        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
                        String $type = this.getType();
                        result = result * 59 + ($type == null ? 43 : $type.hashCode());
                        return result;
                    }
                }
            }
        }
    }
}

