/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.privacy;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.privacy.RedactionJobCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.privacy.RedactionJobCancelParams;
import com.stripe.param.privacy.RedactionJobCreateParams;
import com.stripe.param.privacy.RedactionJobListParams;
import com.stripe.param.privacy.RedactionJobRetrieveParams;
import com.stripe.param.privacy.RedactionJobRunParams;
import com.stripe.param.privacy.RedactionJobUpdateParams;
import com.stripe.param.privacy.RedactionJobValidateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RedactionJob
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="objects")
    Objects objects;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="validation_behavior")
    String validationBehavior;

    public RedactionJob cancel() throws StripeException {
        return this.cancel((Map<String, Object>)null, (RequestOptions)null);
    }

    public RedactionJob cancel(RequestOptions options) throws StripeException {
        return this.cancel((Map<String, Object>)null, options);
    }

    public RedactionJob cancel(Map<String, Object> params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public RedactionJob cancel(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob cancel(RedactionJobCancelParams params) throws StripeException {
        return this.cancel(params, (RequestOptions)null);
    }

    public RedactionJob cancel(RedactionJobCancelParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/cancel", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public static RedactionJob create(Map<String, Object> params) throws StripeException {
        return RedactionJob.create(params, (RequestOptions)null);
    }

    public static RedactionJob create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/privacy/redaction_jobs";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RedactionJob)RedactionJob.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public static RedactionJob create(RedactionJobCreateParams params) throws StripeException {
        return RedactionJob.create(params, (RequestOptions)null);
    }

    public static RedactionJob create(RedactionJobCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/privacy/redaction_jobs";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)RedactionJob.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public static RedactionJobCollection list(Map<String, Object> params) throws StripeException {
        return RedactionJob.list(params, (RequestOptions)null);
    }

    public static RedactionJobCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/privacy/redaction_jobs";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RedactionJobCollection)RedactionJob.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJobCollection.class));
    }

    public static RedactionJobCollection list(RedactionJobListParams params) throws StripeException {
        return RedactionJob.list(params, (RequestOptions)null);
    }

    public static RedactionJobCollection list(RedactionJobListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/privacy/redaction_jobs";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJobCollection)RedactionJob.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJobCollection.class));
    }

    public static RedactionJob retrieve(String job) throws StripeException {
        return RedactionJob.retrieve(job, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static RedactionJob retrieve(String job, RequestOptions options) throws StripeException {
        return RedactionJob.retrieve(job, (Map<String, Object>)null, options);
    }

    public static RedactionJob retrieve(String job, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RedactionJob)RedactionJob.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public static RedactionJob retrieve(String job, RedactionJobRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s", ApiResource.urlEncodeId(job));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)RedactionJob.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob run() throws StripeException {
        return this.run((Map<String, Object>)null, (RequestOptions)null);
    }

    public RedactionJob run(RequestOptions options) throws StripeException {
        return this.run((Map<String, Object>)null, options);
    }

    public RedactionJob run(Map<String, Object> params) throws StripeException {
        return this.run(params, (RequestOptions)null);
    }

    public RedactionJob run(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/run", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob run(RedactionJobRunParams params) throws StripeException {
        return this.run(params, (RequestOptions)null);
    }

    public RedactionJob run(RedactionJobRunParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/run", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public RedactionJob update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob update(RedactionJobUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public RedactionJob update(RedactionJobUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob validate() throws StripeException {
        return this.validate((Map<String, Object>)null, (RequestOptions)null);
    }

    public RedactionJob validate(RequestOptions options) throws StripeException {
        return this.validate((Map<String, Object>)null, options);
    }

    public RedactionJob validate(Map<String, Object> params) throws StripeException {
        return this.validate(params, (RequestOptions)null);
    }

    public RedactionJob validate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/validate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    public RedactionJob validate(RedactionJobValidateParams params) throws StripeException {
        return this.validate(params, (RequestOptions)null);
    }

    public RedactionJob validate(RedactionJobValidateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/validate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJob)this.getResponseGetter().request(request, (Type)((Object)RedactionJob.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.objects, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Objects getObjects() {
        return this.objects;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getValidationBehavior() {
        return this.validationBehavior;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setObjects(Objects objects) {
        this.objects = objects;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setValidationBehavior(String validationBehavior) {
        this.validationBehavior = validationBehavior;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedactionJob)) {
            return false;
        }
        RedactionJob other = (RedactionJob)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Objects this$objects = this.getObjects();
        Objects other$objects = other.getObjects();
        if (this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$validationBehavior = this.getValidationBehavior();
        String other$validationBehavior = other.getValidationBehavior();
        return !(this$validationBehavior == null ? other$validationBehavior != null : !this$validationBehavior.equals(other$validationBehavior));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedactionJob;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Objects $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $validationBehavior = this.getValidationBehavior();
        result = result * 59 + ($validationBehavior == null ? 43 : $validationBehavior.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class Objects
    extends StripeObject {
        @SerializedName(value="charges")
        List<String> charges;
        @SerializedName(value="checkout_sessions")
        List<String> checkoutSessions;
        @SerializedName(value="customers")
        List<String> customers;
        @SerializedName(value="identity_verification_sessions")
        List<String> identityVerificationSessions;
        @SerializedName(value="invoices")
        List<String> invoices;
        @SerializedName(value="issuing_cardholders")
        List<String> issuingCardholders;
        @SerializedName(value="payment_intents")
        List<String> paymentIntents;
        @SerializedName(value="radar_value_list_items")
        List<String> radarValueListItems;
        @SerializedName(value="setup_intents")
        List<String> setupIntents;

        @Generated
        public List<String> getCharges() {
            return this.charges;
        }

        @Generated
        public List<String> getCheckoutSessions() {
            return this.checkoutSessions;
        }

        @Generated
        public List<String> getCustomers() {
            return this.customers;
        }

        @Generated
        public List<String> getIdentityVerificationSessions() {
            return this.identityVerificationSessions;
        }

        @Generated
        public List<String> getInvoices() {
            return this.invoices;
        }

        @Generated
        public List<String> getIssuingCardholders() {
            return this.issuingCardholders;
        }

        @Generated
        public List<String> getPaymentIntents() {
            return this.paymentIntents;
        }

        @Generated
        public List<String> getRadarValueListItems() {
            return this.radarValueListItems;
        }

        @Generated
        public List<String> getSetupIntents() {
            return this.setupIntents;
        }

        @Generated
        public void setCharges(List<String> charges) {
            this.charges = charges;
        }

        @Generated
        public void setCheckoutSessions(List<String> checkoutSessions) {
            this.checkoutSessions = checkoutSessions;
        }

        @Generated
        public void setCustomers(List<String> customers) {
            this.customers = customers;
        }

        @Generated
        public void setIdentityVerificationSessions(List<String> identityVerificationSessions) {
            this.identityVerificationSessions = identityVerificationSessions;
        }

        @Generated
        public void setInvoices(List<String> invoices) {
            this.invoices = invoices;
        }

        @Generated
        public void setIssuingCardholders(List<String> issuingCardholders) {
            this.issuingCardholders = issuingCardholders;
        }

        @Generated
        public void setPaymentIntents(List<String> paymentIntents) {
            this.paymentIntents = paymentIntents;
        }

        @Generated
        public void setRadarValueListItems(List<String> radarValueListItems) {
            this.radarValueListItems = radarValueListItems;
        }

        @Generated
        public void setSetupIntents(List<String> setupIntents) {
            this.setupIntents = setupIntents;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Objects)) {
                return false;
            }
            Objects other = (Objects)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$charges = this.getCharges();
            List<String> other$charges = other.getCharges();
            if (this$charges == null ? other$charges != null : !((Object)this$charges).equals(other$charges)) {
                return false;
            }
            List<String> this$checkoutSessions = this.getCheckoutSessions();
            List<String> other$checkoutSessions = other.getCheckoutSessions();
            if (this$checkoutSessions == null ? other$checkoutSessions != null : !((Object)this$checkoutSessions).equals(other$checkoutSessions)) {
                return false;
            }
            List<String> this$customers = this.getCustomers();
            List<String> other$customers = other.getCustomers();
            if (this$customers == null ? other$customers != null : !((Object)this$customers).equals(other$customers)) {
                return false;
            }
            List<String> this$identityVerificationSessions = this.getIdentityVerificationSessions();
            List<String> other$identityVerificationSessions = other.getIdentityVerificationSessions();
            if (this$identityVerificationSessions == null ? other$identityVerificationSessions != null : !((Object)this$identityVerificationSessions).equals(other$identityVerificationSessions)) {
                return false;
            }
            List<String> this$invoices = this.getInvoices();
            List<String> other$invoices = other.getInvoices();
            if (this$invoices == null ? other$invoices != null : !((Object)this$invoices).equals(other$invoices)) {
                return false;
            }
            List<String> this$issuingCardholders = this.getIssuingCardholders();
            List<String> other$issuingCardholders = other.getIssuingCardholders();
            if (this$issuingCardholders == null ? other$issuingCardholders != null : !((Object)this$issuingCardholders).equals(other$issuingCardholders)) {
                return false;
            }
            List<String> this$paymentIntents = this.getPaymentIntents();
            List<String> other$paymentIntents = other.getPaymentIntents();
            if (this$paymentIntents == null ? other$paymentIntents != null : !((Object)this$paymentIntents).equals(other$paymentIntents)) {
                return false;
            }
            List<String> this$radarValueListItems = this.getRadarValueListItems();
            List<String> other$radarValueListItems = other.getRadarValueListItems();
            if (this$radarValueListItems == null ? other$radarValueListItems != null : !((Object)this$radarValueListItems).equals(other$radarValueListItems)) {
                return false;
            }
            List<String> this$setupIntents = this.getSetupIntents();
            List<String> other$setupIntents = other.getSetupIntents();
            return !(this$setupIntents == null ? other$setupIntents != null : !((Object)this$setupIntents).equals(other$setupIntents));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Objects;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $charges = this.getCharges();
            result = result * 59 + ($charges == null ? 43 : ((Object)$charges).hashCode());
            List<String> $checkoutSessions = this.getCheckoutSessions();
            result = result * 59 + ($checkoutSessions == null ? 43 : ((Object)$checkoutSessions).hashCode());
            List<String> $customers = this.getCustomers();
            result = result * 59 + ($customers == null ? 43 : ((Object)$customers).hashCode());
            List<String> $identityVerificationSessions = this.getIdentityVerificationSessions();
            result = result * 59 + ($identityVerificationSessions == null ? 43 : ((Object)$identityVerificationSessions).hashCode());
            List<String> $invoices = this.getInvoices();
            result = result * 59 + ($invoices == null ? 43 : ((Object)$invoices).hashCode());
            List<String> $issuingCardholders = this.getIssuingCardholders();
            result = result * 59 + ($issuingCardholders == null ? 43 : ((Object)$issuingCardholders).hashCode());
            List<String> $paymentIntents = this.getPaymentIntents();
            result = result * 59 + ($paymentIntents == null ? 43 : ((Object)$paymentIntents).hashCode());
            List<String> $radarValueListItems = this.getRadarValueListItems();
            result = result * 59 + ($radarValueListItems == null ? 43 : ((Object)$radarValueListItems).hashCode());
            List<String> $setupIntents = this.getSetupIntents();
            result = result * 59 + ($setupIntents == null ? 43 : ((Object)$setupIntents).hashCode());
            return result;
        }
    }
}

