/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.privacy;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.privacy.RedactionJobValidationErrorCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.privacy.RedactionJobValidationErrorListParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class RedactionJobValidationError
extends ApiResource
implements HasId {
    @SerializedName(value="code")
    String code;
    @SerializedName(value="erroring_object")
    ErroringObject erroringObject;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="message")
    String message;
    @SerializedName(value="object")
    String object;

    public static RedactionJobValidationErrorCollection list(String job, Map<String, Object> params) throws StripeException {
        return RedactionJobValidationError.list(job, params, (RequestOptions)null);
    }

    public static RedactionJobValidationErrorCollection list(String job, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/validation_errors", ApiResource.urlEncodeId(job));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RedactionJobValidationErrorCollection)RedactionJobValidationError.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJobValidationErrorCollection.class));
    }

    public static RedactionJobValidationErrorCollection list(String job, RedactionJobValidationErrorListParams params) throws StripeException {
        return RedactionJobValidationError.list(job, params, (RequestOptions)null);
    }

    public static RedactionJobValidationErrorCollection list(String job, RedactionJobValidationErrorListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/privacy/redaction_jobs/%s/validation_errors", ApiResource.urlEncodeId(job));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RedactionJobValidationErrorCollection)RedactionJobValidationError.getGlobalResponseGetter().request(request, (Type)((Object)RedactionJobValidationErrorCollection.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.erroringObject, responseGetter);
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public ErroringObject getErroringObject() {
        return this.erroringObject;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public void setCode(String code) {
        this.code = code;
    }

    @Generated
    public void setErroringObject(ErroringObject erroringObject) {
        this.erroringObject = erroringObject;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedactionJobValidationError)) {
            return false;
        }
        RedactionJobValidationError other = (RedactionJobValidationError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        ErroringObject this$erroringObject = this.getErroringObject();
        ErroringObject other$erroringObject = other.getErroringObject();
        if (this$erroringObject == null ? other$erroringObject != null : !((Object)this$erroringObject).equals(other$erroringObject)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RedactionJobValidationError;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        ErroringObject $erroringObject = this.getErroringObject();
        result = result * 59 + ($erroringObject == null ? 43 : ((Object)$erroringObject).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class ErroringObject
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="object_type")
        String objectType;

        @Generated
        public String getObjectType() {
            return this.objectType;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setObjectType(String objectType) {
            this.objectType = objectType;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErroringObject)) {
                return false;
            }
            ErroringObject other = (ErroringObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$objectType = this.getObjectType();
            String other$objectType = other.getObjectType();
            return !(this$objectType == null ? other$objectType != null : !this$objectType.equals(other$objectType));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ErroringObject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $objectType = this.getObjectType();
            result = result * 59 + ($objectType == null ? 43 : $objectType.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }
}

