/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import com.stripe.param.common.EmptyParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class PaymentIntentCreateParams
extends ApiRequestParams {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="amount_details")
    AmountDetails amountDetails;
    @SerializedName(value="application_fee_amount")
    Long applicationFeeAmount;
    @SerializedName(value="automatic_payment_methods")
    AutomaticPaymentMethods automaticPaymentMethods;
    @SerializedName(value="capture_method")
    CaptureMethod captureMethod;
    @SerializedName(value="confirm")
    Boolean confirm;
    @SerializedName(value="confirmation_method")
    ConfirmationMethod confirmationMethod;
    @SerializedName(value="confirmation_token")
    String confirmationToken;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="customer_account")
    String customerAccount;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="error_on_requires_action")
    Boolean errorOnRequiresAction;
    @SerializedName(value="excluded_payment_method_types")
    List<ExcludedPaymentMethodType> excludedPaymentMethodTypes;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="fx_quote")
    String fxQuote;
    @SerializedName(value="hooks")
    Hooks hooks;
    @SerializedName(value="mandate")
    String mandate;
    @SerializedName(value="mandate_data")
    Object mandateData;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="off_session")
    Object offSession;
    @SerializedName(value="on_behalf_of")
    String onBehalfOf;
    @SerializedName(value="payment_details")
    PaymentDetails paymentDetails;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_configuration")
    String paymentMethodConfiguration;
    @SerializedName(value="payment_method_data")
    PaymentMethodData paymentMethodData;
    @SerializedName(value="payment_method_options")
    PaymentMethodOptions paymentMethodOptions;
    @SerializedName(value="payment_method_types")
    List<String> paymentMethodTypes;
    @SerializedName(value="radar_options")
    RadarOptions radarOptions;
    @SerializedName(value="receipt_email")
    String receiptEmail;
    @SerializedName(value="return_url")
    String returnUrl;
    @SerializedName(value="secret_key_confirmation")
    SecretKeyConfirmation secretKeyConfirmation;
    @SerializedName(value="setup_future_usage")
    SetupFutureUsage setupFutureUsage;
    @SerializedName(value="shipping")
    Shipping shipping;
    @SerializedName(value="statement_descriptor")
    String statementDescriptor;
    @SerializedName(value="statement_descriptor_suffix")
    String statementDescriptorSuffix;
    @SerializedName(value="transfer_data")
    TransferData transferData;
    @SerializedName(value="transfer_group")
    String transferGroup;
    @SerializedName(value="use_stripe_sdk")
    Boolean useStripeSdk;

    private PaymentIntentCreateParams(Long amount, AmountDetails amountDetails, Long applicationFeeAmount, AutomaticPaymentMethods automaticPaymentMethods, CaptureMethod captureMethod, Boolean confirm, ConfirmationMethod confirmationMethod, String confirmationToken, String currency, String customer, String customerAccount, String description, Boolean errorOnRequiresAction, List<ExcludedPaymentMethodType> excludedPaymentMethodTypes, List<String> expand, Map<String, Object> extraParams, String fxQuote, Hooks hooks, String mandate, Object mandateData, Map<String, String> metadata, Object offSession, String onBehalfOf, PaymentDetails paymentDetails, String paymentMethod, String paymentMethodConfiguration, PaymentMethodData paymentMethodData, PaymentMethodOptions paymentMethodOptions, List<String> paymentMethodTypes, RadarOptions radarOptions, String receiptEmail, String returnUrl, SecretKeyConfirmation secretKeyConfirmation, SetupFutureUsage setupFutureUsage, Shipping shipping, String statementDescriptor, String statementDescriptorSuffix, TransferData transferData, String transferGroup, Boolean useStripeSdk) {
        this.amount = amount;
        this.amountDetails = amountDetails;
        this.applicationFeeAmount = applicationFeeAmount;
        this.automaticPaymentMethods = automaticPaymentMethods;
        this.captureMethod = captureMethod;
        this.confirm = confirm;
        this.confirmationMethod = confirmationMethod;
        this.confirmationToken = confirmationToken;
        this.currency = currency;
        this.customer = customer;
        this.customerAccount = customerAccount;
        this.description = description;
        this.errorOnRequiresAction = errorOnRequiresAction;
        this.excludedPaymentMethodTypes = excludedPaymentMethodTypes;
        this.expand = expand;
        this.extraParams = extraParams;
        this.fxQuote = fxQuote;
        this.hooks = hooks;
        this.mandate = mandate;
        this.mandateData = mandateData;
        this.metadata = metadata;
        this.offSession = offSession;
        this.onBehalfOf = onBehalfOf;
        this.paymentDetails = paymentDetails;
        this.paymentMethod = paymentMethod;
        this.paymentMethodConfiguration = paymentMethodConfiguration;
        this.paymentMethodData = paymentMethodData;
        this.paymentMethodOptions = paymentMethodOptions;
        this.paymentMethodTypes = paymentMethodTypes;
        this.radarOptions = radarOptions;
        this.receiptEmail = receiptEmail;
        this.returnUrl = returnUrl;
        this.secretKeyConfirmation = secretKeyConfirmation;
        this.setupFutureUsage = setupFutureUsage;
        this.shipping = shipping;
        this.statementDescriptor = statementDescriptor;
        this.statementDescriptorSuffix = statementDescriptorSuffix;
        this.transferData = transferData;
        this.transferGroup = transferGroup;
        this.useStripeSdk = useStripeSdk;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public AmountDetails getAmountDetails() {
        return this.amountDetails;
    }

    @Generated
    public Long getApplicationFeeAmount() {
        return this.applicationFeeAmount;
    }

    @Generated
    public AutomaticPaymentMethods getAutomaticPaymentMethods() {
        return this.automaticPaymentMethods;
    }

    @Generated
    public CaptureMethod getCaptureMethod() {
        return this.captureMethod;
    }

    @Generated
    public Boolean getConfirm() {
        return this.confirm;
    }

    @Generated
    public ConfirmationMethod getConfirmationMethod() {
        return this.confirmationMethod;
    }

    @Generated
    public String getConfirmationToken() {
        return this.confirmationToken;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public String getCustomerAccount() {
        return this.customerAccount;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Boolean getErrorOnRequiresAction() {
        return this.errorOnRequiresAction;
    }

    @Generated
    public List<ExcludedPaymentMethodType> getExcludedPaymentMethodTypes() {
        return this.excludedPaymentMethodTypes;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public String getFxQuote() {
        return this.fxQuote;
    }

    @Generated
    public Hooks getHooks() {
        return this.hooks;
    }

    @Generated
    public String getMandate() {
        return this.mandate;
    }

    @Generated
    public Object getMandateData() {
        return this.mandateData;
    }

    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    @Generated
    public Object getOffSession() {
        return this.offSession;
    }

    @Generated
    public String getOnBehalfOf() {
        return this.onBehalfOf;
    }

    @Generated
    public PaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public String getPaymentMethodConfiguration() {
        return this.paymentMethodConfiguration;
    }

    @Generated
    public PaymentMethodData getPaymentMethodData() {
        return this.paymentMethodData;
    }

    @Generated
    public PaymentMethodOptions getPaymentMethodOptions() {
        return this.paymentMethodOptions;
    }

    @Generated
    public List<String> getPaymentMethodTypes() {
        return this.paymentMethodTypes;
    }

    @Generated
    public RadarOptions getRadarOptions() {
        return this.radarOptions;
    }

    @Generated
    public String getReceiptEmail() {
        return this.receiptEmail;
    }

    @Generated
    public String getReturnUrl() {
        return this.returnUrl;
    }

    @Generated
    public SecretKeyConfirmation getSecretKeyConfirmation() {
        return this.secretKeyConfirmation;
    }

    @Generated
    public SetupFutureUsage getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public Shipping getShipping() {
        return this.shipping;
    }

    @Generated
    public String getStatementDescriptor() {
        return this.statementDescriptor;
    }

    @Generated
    public String getStatementDescriptorSuffix() {
        return this.statementDescriptorSuffix;
    }

    @Generated
    public TransferData getTransferData() {
        return this.transferData;
    }

    @Generated
    public String getTransferGroup() {
        return this.transferGroup;
    }

    @Generated
    public Boolean getUseStripeSdk() {
        return this.useStripeSdk;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentIntentCreateParams)) {
            return false;
        }
        PaymentIntentCreateParams other = (PaymentIntentCreateParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Long this$applicationFeeAmount = this.getApplicationFeeAmount();
        Long other$applicationFeeAmount = other.getApplicationFeeAmount();
        if (this$applicationFeeAmount == null ? other$applicationFeeAmount != null : !((Object)this$applicationFeeAmount).equals(other$applicationFeeAmount)) {
            return false;
        }
        Boolean this$confirm = this.getConfirm();
        Boolean other$confirm = other.getConfirm();
        if (this$confirm == null ? other$confirm != null : !((Object)this$confirm).equals(other$confirm)) {
            return false;
        }
        Boolean this$errorOnRequiresAction = this.getErrorOnRequiresAction();
        Boolean other$errorOnRequiresAction = other.getErrorOnRequiresAction();
        if (this$errorOnRequiresAction == null ? other$errorOnRequiresAction != null : !((Object)this$errorOnRequiresAction).equals(other$errorOnRequiresAction)) {
            return false;
        }
        Boolean this$useStripeSdk = this.getUseStripeSdk();
        Boolean other$useStripeSdk = other.getUseStripeSdk();
        if (this$useStripeSdk == null ? other$useStripeSdk != null : !((Object)this$useStripeSdk).equals(other$useStripeSdk)) {
            return false;
        }
        AmountDetails this$amountDetails = this.getAmountDetails();
        AmountDetails other$amountDetails = other.getAmountDetails();
        if (this$amountDetails == null ? other$amountDetails != null : !((Object)this$amountDetails).equals(other$amountDetails)) {
            return false;
        }
        AutomaticPaymentMethods this$automaticPaymentMethods = this.getAutomaticPaymentMethods();
        AutomaticPaymentMethods other$automaticPaymentMethods = other.getAutomaticPaymentMethods();
        if (this$automaticPaymentMethods == null ? other$automaticPaymentMethods != null : !((Object)this$automaticPaymentMethods).equals(other$automaticPaymentMethods)) {
            return false;
        }
        CaptureMethod this$captureMethod = this.getCaptureMethod();
        CaptureMethod other$captureMethod = other.getCaptureMethod();
        if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
            return false;
        }
        ConfirmationMethod this$confirmationMethod = this.getConfirmationMethod();
        ConfirmationMethod other$confirmationMethod = other.getConfirmationMethod();
        if (this$confirmationMethod == null ? other$confirmationMethod != null : !this$confirmationMethod.equals(other$confirmationMethod)) {
            return false;
        }
        String this$confirmationToken = this.getConfirmationToken();
        String other$confirmationToken = other.getConfirmationToken();
        if (this$confirmationToken == null ? other$confirmationToken != null : !this$confirmationToken.equals(other$confirmationToken)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        String this$customerAccount = this.getCustomerAccount();
        String other$customerAccount = other.getCustomerAccount();
        if (this$customerAccount == null ? other$customerAccount != null : !this$customerAccount.equals(other$customerAccount)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<ExcludedPaymentMethodType> this$excludedPaymentMethodTypes = this.getExcludedPaymentMethodTypes();
        List<ExcludedPaymentMethodType> other$excludedPaymentMethodTypes = other.getExcludedPaymentMethodTypes();
        if (this$excludedPaymentMethodTypes == null ? other$excludedPaymentMethodTypes != null : !((Object)this$excludedPaymentMethodTypes).equals(other$excludedPaymentMethodTypes)) {
            return false;
        }
        List<String> this$expand = this.getExpand();
        List<String> other$expand = other.getExpand();
        if (this$expand == null ? other$expand != null : !((Object)this$expand).equals(other$expand)) {
            return false;
        }
        Map<String, Object> this$extraParams = this.getExtraParams();
        Map<String, Object> other$extraParams = other.getExtraParams();
        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
            return false;
        }
        String this$fxQuote = this.getFxQuote();
        String other$fxQuote = other.getFxQuote();
        if (this$fxQuote == null ? other$fxQuote != null : !this$fxQuote.equals(other$fxQuote)) {
            return false;
        }
        Hooks this$hooks = this.getHooks();
        Hooks other$hooks = other.getHooks();
        if (this$hooks == null ? other$hooks != null : !((Object)this$hooks).equals(other$hooks)) {
            return false;
        }
        String this$mandate = this.getMandate();
        String other$mandate = other.getMandate();
        if (this$mandate == null ? other$mandate != null : !this$mandate.equals(other$mandate)) {
            return false;
        }
        Object this$mandateData = this.getMandateData();
        Object other$mandateData = other.getMandateData();
        if (this$mandateData == null ? other$mandateData != null : !this$mandateData.equals(other$mandateData)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        Object this$offSession = this.getOffSession();
        Object other$offSession = other.getOffSession();
        if (this$offSession == null ? other$offSession != null : !this$offSession.equals(other$offSession)) {
            return false;
        }
        String this$onBehalfOf = this.getOnBehalfOf();
        String other$onBehalfOf = other.getOnBehalfOf();
        if (this$onBehalfOf == null ? other$onBehalfOf != null : !this$onBehalfOf.equals(other$onBehalfOf)) {
            return false;
        }
        PaymentDetails this$paymentDetails = this.getPaymentDetails();
        PaymentDetails other$paymentDetails = other.getPaymentDetails();
        if (this$paymentDetails == null ? other$paymentDetails != null : !((Object)this$paymentDetails).equals(other$paymentDetails)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        String this$paymentMethodConfiguration = this.getPaymentMethodConfiguration();
        String other$paymentMethodConfiguration = other.getPaymentMethodConfiguration();
        if (this$paymentMethodConfiguration == null ? other$paymentMethodConfiguration != null : !this$paymentMethodConfiguration.equals(other$paymentMethodConfiguration)) {
            return false;
        }
        PaymentMethodData this$paymentMethodData = this.getPaymentMethodData();
        PaymentMethodData other$paymentMethodData = other.getPaymentMethodData();
        if (this$paymentMethodData == null ? other$paymentMethodData != null : !((Object)this$paymentMethodData).equals(other$paymentMethodData)) {
            return false;
        }
        PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
        PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
        if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
            return false;
        }
        List<String> this$paymentMethodTypes = this.getPaymentMethodTypes();
        List<String> other$paymentMethodTypes = other.getPaymentMethodTypes();
        if (this$paymentMethodTypes == null ? other$paymentMethodTypes != null : !((Object)this$paymentMethodTypes).equals(other$paymentMethodTypes)) {
            return false;
        }
        RadarOptions this$radarOptions = this.getRadarOptions();
        RadarOptions other$radarOptions = other.getRadarOptions();
        if (this$radarOptions == null ? other$radarOptions != null : !((Object)this$radarOptions).equals(other$radarOptions)) {
            return false;
        }
        String this$receiptEmail = this.getReceiptEmail();
        String other$receiptEmail = other.getReceiptEmail();
        if (this$receiptEmail == null ? other$receiptEmail != null : !this$receiptEmail.equals(other$receiptEmail)) {
            return false;
        }
        String this$returnUrl = this.getReturnUrl();
        String other$returnUrl = other.getReturnUrl();
        if (this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl)) {
            return false;
        }
        SecretKeyConfirmation this$secretKeyConfirmation = this.getSecretKeyConfirmation();
        SecretKeyConfirmation other$secretKeyConfirmation = other.getSecretKeyConfirmation();
        if (this$secretKeyConfirmation == null ? other$secretKeyConfirmation != null : !this$secretKeyConfirmation.equals(other$secretKeyConfirmation)) {
            return false;
        }
        SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
        SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
            return false;
        }
        Shipping this$shipping = this.getShipping();
        Shipping other$shipping = other.getShipping();
        if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
            return false;
        }
        String this$statementDescriptor = this.getStatementDescriptor();
        String other$statementDescriptor = other.getStatementDescriptor();
        if (this$statementDescriptor == null ? other$statementDescriptor != null : !this$statementDescriptor.equals(other$statementDescriptor)) {
            return false;
        }
        String this$statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        String other$statementDescriptorSuffix = other.getStatementDescriptorSuffix();
        if (this$statementDescriptorSuffix == null ? other$statementDescriptorSuffix != null : !this$statementDescriptorSuffix.equals(other$statementDescriptorSuffix)) {
            return false;
        }
        TransferData this$transferData = this.getTransferData();
        TransferData other$transferData = other.getTransferData();
        if (this$transferData == null ? other$transferData != null : !((Object)this$transferData).equals(other$transferData)) {
            return false;
        }
        String this$transferGroup = this.getTransferGroup();
        String other$transferGroup = other.getTransferGroup();
        return !(this$transferGroup == null ? other$transferGroup != null : !this$transferGroup.equals(other$transferGroup));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentIntentCreateParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Long $applicationFeeAmount = this.getApplicationFeeAmount();
        result = result * 59 + ($applicationFeeAmount == null ? 43 : ((Object)$applicationFeeAmount).hashCode());
        Boolean $confirm = this.getConfirm();
        result = result * 59 + ($confirm == null ? 43 : ((Object)$confirm).hashCode());
        Boolean $errorOnRequiresAction = this.getErrorOnRequiresAction();
        result = result * 59 + ($errorOnRequiresAction == null ? 43 : ((Object)$errorOnRequiresAction).hashCode());
        Boolean $useStripeSdk = this.getUseStripeSdk();
        result = result * 59 + ($useStripeSdk == null ? 43 : ((Object)$useStripeSdk).hashCode());
        AmountDetails $amountDetails = this.getAmountDetails();
        result = result * 59 + ($amountDetails == null ? 43 : ((Object)$amountDetails).hashCode());
        AutomaticPaymentMethods $automaticPaymentMethods = this.getAutomaticPaymentMethods();
        result = result * 59 + ($automaticPaymentMethods == null ? 43 : ((Object)$automaticPaymentMethods).hashCode());
        CaptureMethod $captureMethod = this.getCaptureMethod();
        result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
        ConfirmationMethod $confirmationMethod = this.getConfirmationMethod();
        result = result * 59 + ($confirmationMethod == null ? 43 : $confirmationMethod.hashCode());
        String $confirmationToken = this.getConfirmationToken();
        result = result * 59 + ($confirmationToken == null ? 43 : $confirmationToken.hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        String $customerAccount = this.getCustomerAccount();
        result = result * 59 + ($customerAccount == null ? 43 : $customerAccount.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<ExcludedPaymentMethodType> $excludedPaymentMethodTypes = this.getExcludedPaymentMethodTypes();
        result = result * 59 + ($excludedPaymentMethodTypes == null ? 43 : ((Object)$excludedPaymentMethodTypes).hashCode());
        List<String> $expand = this.getExpand();
        result = result * 59 + ($expand == null ? 43 : ((Object)$expand).hashCode());
        Map<String, Object> $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
        String $fxQuote = this.getFxQuote();
        result = result * 59 + ($fxQuote == null ? 43 : $fxQuote.hashCode());
        Hooks $hooks = this.getHooks();
        result = result * 59 + ($hooks == null ? 43 : ((Object)$hooks).hashCode());
        String $mandate = this.getMandate();
        result = result * 59 + ($mandate == null ? 43 : $mandate.hashCode());
        Object $mandateData = this.getMandateData();
        result = result * 59 + ($mandateData == null ? 43 : $mandateData.hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        Object $offSession = this.getOffSession();
        result = result * 59 + ($offSession == null ? 43 : $offSession.hashCode());
        String $onBehalfOf = this.getOnBehalfOf();
        result = result * 59 + ($onBehalfOf == null ? 43 : $onBehalfOf.hashCode());
        PaymentDetails $paymentDetails = this.getPaymentDetails();
        result = result * 59 + ($paymentDetails == null ? 43 : ((Object)$paymentDetails).hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        String $paymentMethodConfiguration = this.getPaymentMethodConfiguration();
        result = result * 59 + ($paymentMethodConfiguration == null ? 43 : $paymentMethodConfiguration.hashCode());
        PaymentMethodData $paymentMethodData = this.getPaymentMethodData();
        result = result * 59 + ($paymentMethodData == null ? 43 : ((Object)$paymentMethodData).hashCode());
        PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
        result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
        List<String> $paymentMethodTypes = this.getPaymentMethodTypes();
        result = result * 59 + ($paymentMethodTypes == null ? 43 : ((Object)$paymentMethodTypes).hashCode());
        RadarOptions $radarOptions = this.getRadarOptions();
        result = result * 59 + ($radarOptions == null ? 43 : ((Object)$radarOptions).hashCode());
        String $receiptEmail = this.getReceiptEmail();
        result = result * 59 + ($receiptEmail == null ? 43 : $receiptEmail.hashCode());
        String $returnUrl = this.getReturnUrl();
        result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
        SecretKeyConfirmation $secretKeyConfirmation = this.getSecretKeyConfirmation();
        result = result * 59 + ($secretKeyConfirmation == null ? 43 : $secretKeyConfirmation.hashCode());
        SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        Shipping $shipping = this.getShipping();
        result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
        String $statementDescriptor = this.getStatementDescriptor();
        result = result * 59 + ($statementDescriptor == null ? 43 : $statementDescriptor.hashCode());
        String $statementDescriptorSuffix = this.getStatementDescriptorSuffix();
        result = result * 59 + ($statementDescriptorSuffix == null ? 43 : $statementDescriptorSuffix.hashCode());
        TransferData $transferData = this.getTransferData();
        result = result * 59 + ($transferData == null ? 43 : ((Object)$transferData).hashCode());
        String $transferGroup = this.getTransferGroup();
        result = result * 59 + ($transferGroup == null ? 43 : $transferGroup.hashCode());
        return result;
    }

    public static class AmountDetails {
        @SerializedName(value="discount_amount")
        Object discountAmount;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="line_items")
        Object lineItems;
        @SerializedName(value="shipping")
        Object shipping;
        @SerializedName(value="tax")
        Object tax;

        private AmountDetails(Object discountAmount, Map<String, Object> extraParams, Object lineItems, Object shipping, Object tax) {
            this.discountAmount = discountAmount;
            this.extraParams = extraParams;
            this.lineItems = lineItems;
            this.shipping = shipping;
            this.tax = tax;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getDiscountAmount() {
            return this.discountAmount;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getLineItems() {
            return this.lineItems;
        }

        @Generated
        public Object getShipping() {
            return this.shipping;
        }

        @Generated
        public Object getTax() {
            return this.tax;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmountDetails)) {
                return false;
            }
            AmountDetails other = (AmountDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$discountAmount = this.getDiscountAmount();
            Object other$discountAmount = other.getDiscountAmount();
            if (this$discountAmount == null ? other$discountAmount != null : !this$discountAmount.equals(other$discountAmount)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            Object this$lineItems = this.getLineItems();
            Object other$lineItems = other.getLineItems();
            if (this$lineItems == null ? other$lineItems != null : !this$lineItems.equals(other$lineItems)) {
                return false;
            }
            Object this$shipping = this.getShipping();
            Object other$shipping = other.getShipping();
            if (this$shipping == null ? other$shipping != null : !this$shipping.equals(other$shipping)) {
                return false;
            }
            Object this$tax = this.getTax();
            Object other$tax = other.getTax();
            return !(this$tax == null ? other$tax != null : !this$tax.equals(other$tax));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmountDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $discountAmount = this.getDiscountAmount();
            result = result * 59 + ($discountAmount == null ? 43 : $discountAmount.hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            Object $lineItems = this.getLineItems();
            result = result * 59 + ($lineItems == null ? 43 : $lineItems.hashCode());
            Object $shipping = this.getShipping();
            result = result * 59 + ($shipping == null ? 43 : $shipping.hashCode());
            Object $tax = this.getTax();
            result = result * 59 + ($tax == null ? 43 : $tax.hashCode());
            return result;
        }

        public static class Builder {
            private Object discountAmount;
            private Map<String, Object> extraParams;
            private Object lineItems;
            private Object shipping;
            private Object tax;

            public AmountDetails build() {
                return new AmountDetails(this.discountAmount, this.extraParams, this.lineItems, this.shipping, this.tax);
            }

            public Builder setDiscountAmount(Long discountAmount) {
                this.discountAmount = discountAmount;
                return this;
            }

            public Builder setDiscountAmount(EmptyParam discountAmount) {
                this.discountAmount = discountAmount;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addLineItem(LineItem element) {
                if (this.lineItems == null || this.lineItems instanceof EmptyParam) {
                    this.lineItems = new ArrayList();
                }
                ((List)this.lineItems).add(element);
                return this;
            }

            public Builder addAllLineItem(List<LineItem> elements) {
                if (this.lineItems == null || this.lineItems instanceof EmptyParam) {
                    this.lineItems = new ArrayList();
                }
                ((List)this.lineItems).addAll(elements);
                return this;
            }

            public Builder setLineItems(EmptyParam lineItems) {
                this.lineItems = lineItems;
                return this;
            }

            public Builder setLineItems(List<LineItem> lineItems) {
                this.lineItems = lineItems;
                return this;
            }

            public Builder setShipping(Shipping shipping) {
                this.shipping = shipping;
                return this;
            }

            public Builder setShipping(EmptyParam shipping) {
                this.shipping = shipping;
                return this;
            }

            public Builder setTax(Tax tax) {
                this.tax = tax;
                return this;
            }

            public Builder setTax(EmptyParam tax) {
                this.tax = tax;
                return this;
            }
        }

        public static class Tax {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="total_tax_amount")
            Long totalTaxAmount;

            private Tax(Map<String, Object> extraParams, Long totalTaxAmount) {
                this.extraParams = extraParams;
                this.totalTaxAmount = totalTaxAmount;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Long getTotalTaxAmount() {
                return this.totalTaxAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Tax)) {
                    return false;
                }
                Tax other = (Tax)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$totalTaxAmount = this.getTotalTaxAmount();
                Long other$totalTaxAmount = other.getTotalTaxAmount();
                if (this$totalTaxAmount == null ? other$totalTaxAmount != null : !((Object)this$totalTaxAmount).equals(other$totalTaxAmount)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Tax;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $totalTaxAmount = this.getTotalTaxAmount();
                result = result * 59 + ($totalTaxAmount == null ? 43 : ((Object)$totalTaxAmount).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Long totalTaxAmount;

                public Tax build() {
                    return new Tax(this.extraParams, this.totalTaxAmount);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTotalTaxAmount(Long totalTaxAmount) {
                    this.totalTaxAmount = totalTaxAmount;
                    return this;
                }
            }
        }

        public static class Shipping {
            @SerializedName(value="amount")
            Object amount;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="from_postal_code")
            Object fromPostalCode;
            @SerializedName(value="to_postal_code")
            Object toPostalCode;

            private Shipping(Object amount, Map<String, Object> extraParams, Object fromPostalCode, Object toPostalCode) {
                this.amount = amount;
                this.extraParams = extraParams;
                this.fromPostalCode = fromPostalCode;
                this.toPostalCode = toPostalCode;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAmount() {
                return this.amount;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getFromPostalCode() {
                return this.fromPostalCode;
            }

            @Generated
            public Object getToPostalCode() {
                return this.toPostalCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Shipping)) {
                    return false;
                }
                Shipping other = (Shipping)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$amount = this.getAmount();
                Object other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Object this$fromPostalCode = this.getFromPostalCode();
                Object other$fromPostalCode = other.getFromPostalCode();
                if (this$fromPostalCode == null ? other$fromPostalCode != null : !this$fromPostalCode.equals(other$fromPostalCode)) {
                    return false;
                }
                Object this$toPostalCode = this.getToPostalCode();
                Object other$toPostalCode = other.getToPostalCode();
                return !(this$toPostalCode == null ? other$toPostalCode != null : !this$toPostalCode.equals(other$toPostalCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Shipping;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Object $fromPostalCode = this.getFromPostalCode();
                result = result * 59 + ($fromPostalCode == null ? 43 : $fromPostalCode.hashCode());
                Object $toPostalCode = this.getToPostalCode();
                result = result * 59 + ($toPostalCode == null ? 43 : $toPostalCode.hashCode());
                return result;
            }

            public static class Builder {
                private Object amount;
                private Map<String, Object> extraParams;
                private Object fromPostalCode;
                private Object toPostalCode;

                public Shipping build() {
                    return new Shipping(this.amount, this.extraParams, this.fromPostalCode, this.toPostalCode);
                }

                public Builder setAmount(Long amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder setAmount(EmptyParam amount) {
                    this.amount = amount;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFromPostalCode(String fromPostalCode) {
                    this.fromPostalCode = fromPostalCode;
                    return this;
                }

                public Builder setFromPostalCode(EmptyParam fromPostalCode) {
                    this.fromPostalCode = fromPostalCode;
                    return this;
                }

                public Builder setToPostalCode(String toPostalCode) {
                    this.toPostalCode = toPostalCode;
                    return this;
                }

                public Builder setToPostalCode(EmptyParam toPostalCode) {
                    this.toPostalCode = toPostalCode;
                    return this;
                }
            }
        }

        public static class LineItem {
            @SerializedName(value="discount_amount")
            Long discountAmount;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="payment_method_options")
            PaymentMethodOptions paymentMethodOptions;
            @SerializedName(value="product_code")
            String productCode;
            @SerializedName(value="product_name")
            String productName;
            @SerializedName(value="quantity")
            Long quantity;
            @SerializedName(value="tax")
            Tax tax;
            @SerializedName(value="unit_cost")
            Long unitCost;
            @SerializedName(value="unit_of_measure")
            String unitOfMeasure;

            private LineItem(Long discountAmount, Map<String, Object> extraParams, PaymentMethodOptions paymentMethodOptions, String productCode, String productName, Long quantity, Tax tax, Long unitCost, String unitOfMeasure) {
                this.discountAmount = discountAmount;
                this.extraParams = extraParams;
                this.paymentMethodOptions = paymentMethodOptions;
                this.productCode = productCode;
                this.productName = productName;
                this.quantity = quantity;
                this.tax = tax;
                this.unitCost = unitCost;
                this.unitOfMeasure = unitOfMeasure;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getDiscountAmount() {
                return this.discountAmount;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public PaymentMethodOptions getPaymentMethodOptions() {
                return this.paymentMethodOptions;
            }

            @Generated
            public String getProductCode() {
                return this.productCode;
            }

            @Generated
            public String getProductName() {
                return this.productName;
            }

            @Generated
            public Long getQuantity() {
                return this.quantity;
            }

            @Generated
            public Tax getTax() {
                return this.tax;
            }

            @Generated
            public Long getUnitCost() {
                return this.unitCost;
            }

            @Generated
            public String getUnitOfMeasure() {
                return this.unitOfMeasure;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LineItem)) {
                    return false;
                }
                LineItem other = (LineItem)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$discountAmount = this.getDiscountAmount();
                Long other$discountAmount = other.getDiscountAmount();
                if (this$discountAmount == null ? other$discountAmount != null : !((Object)this$discountAmount).equals(other$discountAmount)) {
                    return false;
                }
                Long this$quantity = this.getQuantity();
                Long other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                    return false;
                }
                Long this$unitCost = this.getUnitCost();
                Long other$unitCost = other.getUnitCost();
                if (this$unitCost == null ? other$unitCost != null : !((Object)this$unitCost).equals(other$unitCost)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                PaymentMethodOptions this$paymentMethodOptions = this.getPaymentMethodOptions();
                PaymentMethodOptions other$paymentMethodOptions = other.getPaymentMethodOptions();
                if (this$paymentMethodOptions == null ? other$paymentMethodOptions != null : !((Object)this$paymentMethodOptions).equals(other$paymentMethodOptions)) {
                    return false;
                }
                String this$productCode = this.getProductCode();
                String other$productCode = other.getProductCode();
                if (this$productCode == null ? other$productCode != null : !this$productCode.equals(other$productCode)) {
                    return false;
                }
                String this$productName = this.getProductName();
                String other$productName = other.getProductName();
                if (this$productName == null ? other$productName != null : !this$productName.equals(other$productName)) {
                    return false;
                }
                Tax this$tax = this.getTax();
                Tax other$tax = other.getTax();
                if (this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax)) {
                    return false;
                }
                String this$unitOfMeasure = this.getUnitOfMeasure();
                String other$unitOfMeasure = other.getUnitOfMeasure();
                return !(this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LineItem;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $discountAmount = this.getDiscountAmount();
                result = result * 59 + ($discountAmount == null ? 43 : ((Object)$discountAmount).hashCode());
                Long $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                Long $unitCost = this.getUnitCost();
                result = result * 59 + ($unitCost == null ? 43 : ((Object)$unitCost).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                PaymentMethodOptions $paymentMethodOptions = this.getPaymentMethodOptions();
                result = result * 59 + ($paymentMethodOptions == null ? 43 : ((Object)$paymentMethodOptions).hashCode());
                String $productCode = this.getProductCode();
                result = result * 59 + ($productCode == null ? 43 : $productCode.hashCode());
                String $productName = this.getProductName();
                result = result * 59 + ($productName == null ? 43 : $productName.hashCode());
                Tax $tax = this.getTax();
                result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
                String $unitOfMeasure = this.getUnitOfMeasure();
                result = result * 59 + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
                return result;
            }

            public static class PaymentMethodOptions {
                @SerializedName(value="card")
                Card card;
                @SerializedName(value="card_present")
                CardPresent cardPresent;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="klarna")
                Klarna klarna;
                @SerializedName(value="paypal")
                Paypal paypal;

                private PaymentMethodOptions(Card card, CardPresent cardPresent, Map<String, Object> extraParams, Klarna klarna, Paypal paypal) {
                    this.card = card;
                    this.cardPresent = cardPresent;
                    this.extraParams = extraParams;
                    this.klarna = klarna;
                    this.paypal = paypal;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Card getCard() {
                    return this.card;
                }

                @Generated
                public CardPresent getCardPresent() {
                    return this.cardPresent;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Klarna getKlarna() {
                    return this.klarna;
                }

                @Generated
                public Paypal getPaypal() {
                    return this.paypal;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PaymentMethodOptions)) {
                        return false;
                    }
                    PaymentMethodOptions other = (PaymentMethodOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Card this$card = this.getCard();
                    Card other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    CardPresent this$cardPresent = this.getCardPresent();
                    CardPresent other$cardPresent = other.getCardPresent();
                    if (this$cardPresent == null ? other$cardPresent != null : !((Object)this$cardPresent).equals(other$cardPresent)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Klarna this$klarna = this.getKlarna();
                    Klarna other$klarna = other.getKlarna();
                    if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                        return false;
                    }
                    Paypal this$paypal = this.getPaypal();
                    Paypal other$paypal = other.getPaypal();
                    return !(this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof PaymentMethodOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Card $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    CardPresent $cardPresent = this.getCardPresent();
                    result = result * 59 + ($cardPresent == null ? 43 : ((Object)$cardPresent).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Klarna $klarna = this.getKlarna();
                    result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
                    Paypal $paypal = this.getPaypal();
                    result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
                    return result;
                }

                public static class Card {
                    @SerializedName(value="commodity_code")
                    String commodityCode;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private Card(String commodityCode, Map<String, Object> extraParams) {
                        this.commodityCode = commodityCode;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCommodityCode() {
                        return this.commodityCode;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Card)) {
                            return false;
                        }
                        Card other = (Card)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$commodityCode = this.getCommodityCode();
                        String other$commodityCode = other.getCommodityCode();
                        if (this$commodityCode == null ? other$commodityCode != null : !this$commodityCode.equals(other$commodityCode)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Card;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $commodityCode = this.getCommodityCode();
                        result = result * 59 + ($commodityCode == null ? 43 : $commodityCode.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        return result;
                    }

                    public static class Builder {
                        private String commodityCode;
                        private Map<String, Object> extraParams;

                        public Card build() {
                            return new Card(this.commodityCode, this.extraParams);
                        }

                        public Builder setCommodityCode(String commodityCode) {
                            this.commodityCode = commodityCode;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static class CardPresent {
                    @SerializedName(value="commodity_code")
                    String commodityCode;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private CardPresent(String commodityCode, Map<String, Object> extraParams) {
                        this.commodityCode = commodityCode;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getCommodityCode() {
                        return this.commodityCode;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof CardPresent)) {
                            return false;
                        }
                        CardPresent other = (CardPresent)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$commodityCode = this.getCommodityCode();
                        String other$commodityCode = other.getCommodityCode();
                        if (this$commodityCode == null ? other$commodityCode != null : !this$commodityCode.equals(other$commodityCode)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof CardPresent;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $commodityCode = this.getCommodityCode();
                        result = result * 59 + ($commodityCode == null ? 43 : $commodityCode.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        return result;
                    }

                    public static class Builder {
                        private String commodityCode;
                        private Map<String, Object> extraParams;

                        public CardPresent build() {
                            return new CardPresent(this.commodityCode, this.extraParams);
                        }

                        public Builder setCommodityCode(String commodityCode) {
                            this.commodityCode = commodityCode;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static class Klarna {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="image_url")
                    String imageUrl;
                    @SerializedName(value="product_url")
                    String productUrl;
                    @SerializedName(value="subscription_reference")
                    String subscriptionReference;

                    private Klarna(Map<String, Object> extraParams, String imageUrl, String productUrl, String subscriptionReference) {
                        this.extraParams = extraParams;
                        this.imageUrl = imageUrl;
                        this.productUrl = productUrl;
                        this.subscriptionReference = subscriptionReference;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getImageUrl() {
                        return this.imageUrl;
                    }

                    @Generated
                    public String getProductUrl() {
                        return this.productUrl;
                    }

                    @Generated
                    public String getSubscriptionReference() {
                        return this.subscriptionReference;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Klarna)) {
                            return false;
                        }
                        Klarna other = (Klarna)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$imageUrl = this.getImageUrl();
                        String other$imageUrl = other.getImageUrl();
                        if (this$imageUrl == null ? other$imageUrl != null : !this$imageUrl.equals(other$imageUrl)) {
                            return false;
                        }
                        String this$productUrl = this.getProductUrl();
                        String other$productUrl = other.getProductUrl();
                        if (this$productUrl == null ? other$productUrl != null : !this$productUrl.equals(other$productUrl)) {
                            return false;
                        }
                        String this$subscriptionReference = this.getSubscriptionReference();
                        String other$subscriptionReference = other.getSubscriptionReference();
                        return !(this$subscriptionReference == null ? other$subscriptionReference != null : !this$subscriptionReference.equals(other$subscriptionReference));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Klarna;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $imageUrl = this.getImageUrl();
                        result = result * 59 + ($imageUrl == null ? 43 : $imageUrl.hashCode());
                        String $productUrl = this.getProductUrl();
                        result = result * 59 + ($productUrl == null ? 43 : $productUrl.hashCode());
                        String $subscriptionReference = this.getSubscriptionReference();
                        result = result * 59 + ($subscriptionReference == null ? 43 : $subscriptionReference.hashCode());
                        return result;
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private String imageUrl;
                        private String productUrl;
                        private String subscriptionReference;

                        public Klarna build() {
                            return new Klarna(this.extraParams, this.imageUrl, this.productUrl, this.subscriptionReference);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setImageUrl(String imageUrl) {
                            this.imageUrl = imageUrl;
                            return this;
                        }

                        public Builder setProductUrl(String productUrl) {
                            this.productUrl = productUrl;
                            return this;
                        }

                        public Builder setSubscriptionReference(String subscriptionReference) {
                            this.subscriptionReference = subscriptionReference;
                            return this;
                        }
                    }
                }

                public static class Paypal {
                    @SerializedName(value="category")
                    Category category;
                    @SerializedName(value="description")
                    String description;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="sold_by")
                    String soldBy;

                    private Paypal(Category category, String description, Map<String, Object> extraParams, String soldBy) {
                        this.category = category;
                        this.description = description;
                        this.extraParams = extraParams;
                        this.soldBy = soldBy;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Category getCategory() {
                        return this.category;
                    }

                    @Generated
                    public String getDescription() {
                        return this.description;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getSoldBy() {
                        return this.soldBy;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Paypal)) {
                            return false;
                        }
                        Paypal other = (Paypal)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Category this$category = this.getCategory();
                        Category other$category = other.getCategory();
                        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                            return false;
                        }
                        String this$description = this.getDescription();
                        String other$description = other.getDescription();
                        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$soldBy = this.getSoldBy();
                        String other$soldBy = other.getSoldBy();
                        return !(this$soldBy == null ? other$soldBy != null : !this$soldBy.equals(other$soldBy));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Paypal;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Category $category = this.getCategory();
                        result = result * 59 + ($category == null ? 43 : $category.hashCode());
                        String $description = this.getDescription();
                        result = result * 59 + ($description == null ? 43 : $description.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $soldBy = this.getSoldBy();
                        result = result * 59 + ($soldBy == null ? 43 : $soldBy.hashCode());
                        return result;
                    }

                    public static enum Category implements ApiRequestParams.EnumParam
                    {
                        DIGITAL_GOODS("digital_goods"),
                        DONATION("donation"),
                        PHYSICAL_GOODS("physical_goods");

                        private final String value;

                        private Category(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Category category;
                        private String description;
                        private Map<String, Object> extraParams;
                        private String soldBy;

                        public Paypal build() {
                            return new Paypal(this.category, this.description, this.extraParams, this.soldBy);
                        }

                        public Builder setCategory(Category category) {
                            this.category = category;
                            return this;
                        }

                        public Builder setDescription(String description) {
                            this.description = description;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setSoldBy(String soldBy) {
                            this.soldBy = soldBy;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Card card;
                    private CardPresent cardPresent;
                    private Map<String, Object> extraParams;
                    private Klarna klarna;
                    private Paypal paypal;

                    public PaymentMethodOptions build() {
                        return new PaymentMethodOptions(this.card, this.cardPresent, this.extraParams, this.klarna, this.paypal);
                    }

                    public Builder setCard(Card card) {
                        this.card = card;
                        return this;
                    }

                    public Builder setCardPresent(CardPresent cardPresent) {
                        this.cardPresent = cardPresent;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setKlarna(Klarna klarna) {
                        this.klarna = klarna;
                        return this;
                    }

                    public Builder setPaypal(Paypal paypal) {
                        this.paypal = paypal;
                        return this;
                    }
                }
            }

            public static class Tax {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="total_tax_amount")
                Long totalTaxAmount;

                private Tax(Map<String, Object> extraParams, Long totalTaxAmount) {
                    this.extraParams = extraParams;
                    this.totalTaxAmount = totalTaxAmount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getTotalTaxAmount() {
                    return this.totalTaxAmount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$totalTaxAmount = this.getTotalTaxAmount();
                    Long other$totalTaxAmount = other.getTotalTaxAmount();
                    if (this$totalTaxAmount == null ? other$totalTaxAmount != null : !((Object)this$totalTaxAmount).equals(other$totalTaxAmount)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $totalTaxAmount = this.getTotalTaxAmount();
                    result = result * 59 + ($totalTaxAmount == null ? 43 : ((Object)$totalTaxAmount).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Long totalTaxAmount;

                    public Tax build() {
                        return new Tax(this.extraParams, this.totalTaxAmount);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setTotalTaxAmount(Long totalTaxAmount) {
                        this.totalTaxAmount = totalTaxAmount;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Long discountAmount;
                private Map<String, Object> extraParams;
                private PaymentMethodOptions paymentMethodOptions;
                private String productCode;
                private String productName;
                private Long quantity;
                private Tax tax;
                private Long unitCost;
                private String unitOfMeasure;

                public LineItem build() {
                    return new LineItem(this.discountAmount, this.extraParams, this.paymentMethodOptions, this.productCode, this.productName, this.quantity, this.tax, this.unitCost, this.unitOfMeasure);
                }

                public Builder setDiscountAmount(Long discountAmount) {
                    this.discountAmount = discountAmount;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPaymentMethodOptions(PaymentMethodOptions paymentMethodOptions) {
                    this.paymentMethodOptions = paymentMethodOptions;
                    return this;
                }

                public Builder setProductCode(String productCode) {
                    this.productCode = productCode;
                    return this;
                }

                public Builder setProductName(String productName) {
                    this.productName = productName;
                    return this;
                }

                public Builder setQuantity(Long quantity) {
                    this.quantity = quantity;
                    return this;
                }

                public Builder setTax(Tax tax) {
                    this.tax = tax;
                    return this;
                }

                public Builder setUnitCost(Long unitCost) {
                    this.unitCost = unitCost;
                    return this;
                }

                public Builder setUnitOfMeasure(String unitOfMeasure) {
                    this.unitOfMeasure = unitOfMeasure;
                    return this;
                }
            }
        }
    }

    public static class AutomaticPaymentMethods {
        @SerializedName(value="allow_redirects")
        AllowRedirects allowRedirects;
        @SerializedName(value="enabled")
        Boolean enabled;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;

        private AutomaticPaymentMethods(AllowRedirects allowRedirects, Boolean enabled, Map<String, Object> extraParams) {
            this.allowRedirects = allowRedirects;
            this.enabled = enabled;
            this.extraParams = extraParams;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AllowRedirects getAllowRedirects() {
            return this.allowRedirects;
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AutomaticPaymentMethods)) {
                return false;
            }
            AutomaticPaymentMethods other = (AutomaticPaymentMethods)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            AllowRedirects this$allowRedirects = this.getAllowRedirects();
            AllowRedirects other$allowRedirects = other.getAllowRedirects();
            if (this$allowRedirects == null ? other$allowRedirects != null : !this$allowRedirects.equals(other$allowRedirects)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AutomaticPaymentMethods;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            AllowRedirects $allowRedirects = this.getAllowRedirects();
            result = result * 59 + ($allowRedirects == null ? 43 : $allowRedirects.hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            return result;
        }

        public static enum AllowRedirects implements ApiRequestParams.EnumParam
        {
            ALWAYS("always"),
            NEVER("never");

            private final String value;

            private AllowRedirects(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private AllowRedirects allowRedirects;
            private Boolean enabled;
            private Map<String, Object> extraParams;

            public AutomaticPaymentMethods build() {
                return new AutomaticPaymentMethods(this.allowRedirects, this.enabled, this.extraParams);
            }

            public Builder setAllowRedirects(AllowRedirects allowRedirects) {
                this.allowRedirects = allowRedirects;
                return this;
            }

            public Builder setEnabled(Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }
        }
    }

    public static enum CaptureMethod implements ApiRequestParams.EnumParam
    {
        AUTOMATIC("automatic"),
        AUTOMATIC_ASYNC("automatic_async"),
        MANUAL("manual");

        private final String value;

        private CaptureMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static enum ConfirmationMethod implements ApiRequestParams.EnumParam
    {
        AUTOMATIC("automatic"),
        MANUAL("manual");

        private final String value;

        private ConfirmationMethod(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class Hooks {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="inputs")
        Inputs inputs;

        private Hooks(Map<String, Object> extraParams, Inputs inputs) {
            this.extraParams = extraParams;
            this.inputs = inputs;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Inputs getInputs() {
            return this.inputs;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Hooks)) {
                return false;
            }
            Hooks other = (Hooks)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            Inputs this$inputs = this.getInputs();
            Inputs other$inputs = other.getInputs();
            return !(this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Hooks;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            Inputs $inputs = this.getInputs();
            result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
            return result;
        }

        public static class Inputs {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="tax")
            Tax tax;

            private Inputs(Map<String, Object> extraParams, Tax tax) {
                this.extraParams = extraParams;
                this.tax = tax;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Tax getTax() {
                return this.tax;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Inputs)) {
                    return false;
                }
                Inputs other = (Inputs)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Tax this$tax = this.getTax();
                Tax other$tax = other.getTax();
                return !(this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Inputs;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Tax $tax = this.getTax();
                result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
                return result;
            }

            public static class Tax {
                @SerializedName(value="calculation")
                Object calculation;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private Tax(Object calculation, Map<String, Object> extraParams) {
                    this.calculation = calculation;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Object getCalculation() {
                    return this.calculation;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Tax)) {
                        return false;
                    }
                    Tax other = (Tax)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Object this$calculation = this.getCalculation();
                    Object other$calculation = other.getCalculation();
                    if (this$calculation == null ? other$calculation != null : !this$calculation.equals(other$calculation)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Tax;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Object $calculation = this.getCalculation();
                    result = result * 59 + ($calculation == null ? 43 : $calculation.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class Builder {
                    private Object calculation;
                    private Map<String, Object> extraParams;

                    public Tax build() {
                        return new Tax(this.calculation, this.extraParams);
                    }

                    public Builder setCalculation(String calculation) {
                        this.calculation = calculation;
                        return this;
                    }

                    public Builder setCalculation(EmptyParam calculation) {
                        this.calculation = calculation;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Tax tax;

                public Inputs build() {
                    return new Inputs(this.extraParams, this.tax);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTax(Tax tax) {
                    this.tax = tax;
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private Inputs inputs;

            public Hooks build() {
                return new Hooks(this.extraParams, this.inputs);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setInputs(Inputs inputs) {
                this.inputs = inputs;
                return this;
            }
        }
    }

    public static class PaymentDetails {
        @SerializedName(value="car_rental")
        CarRental carRental;
        @SerializedName(value="customer_reference")
        Object customerReference;
        @SerializedName(value="event_details")
        EventDetails eventDetails;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="flight")
        Flight flight;
        @SerializedName(value="lodging")
        Lodging lodging;
        @SerializedName(value="order_reference")
        Object orderReference;
        @SerializedName(value="subscription")
        Subscription subscription;

        private PaymentDetails(CarRental carRental, Object customerReference, EventDetails eventDetails, Map<String, Object> extraParams, Flight flight, Lodging lodging, Object orderReference, Subscription subscription) {
            this.carRental = carRental;
            this.customerReference = customerReference;
            this.eventDetails = eventDetails;
            this.extraParams = extraParams;
            this.flight = flight;
            this.lodging = lodging;
            this.orderReference = orderReference;
            this.subscription = subscription;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public CarRental getCarRental() {
            return this.carRental;
        }

        @Generated
        public Object getCustomerReference() {
            return this.customerReference;
        }

        @Generated
        public EventDetails getEventDetails() {
            return this.eventDetails;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Flight getFlight() {
            return this.flight;
        }

        @Generated
        public Lodging getLodging() {
            return this.lodging;
        }

        @Generated
        public Object getOrderReference() {
            return this.orderReference;
        }

        @Generated
        public Subscription getSubscription() {
            return this.subscription;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentDetails)) {
                return false;
            }
            PaymentDetails other = (PaymentDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            CarRental this$carRental = this.getCarRental();
            CarRental other$carRental = other.getCarRental();
            if (this$carRental == null ? other$carRental != null : !((Object)this$carRental).equals(other$carRental)) {
                return false;
            }
            Object this$customerReference = this.getCustomerReference();
            Object other$customerReference = other.getCustomerReference();
            if (this$customerReference == null ? other$customerReference != null : !this$customerReference.equals(other$customerReference)) {
                return false;
            }
            EventDetails this$eventDetails = this.getEventDetails();
            EventDetails other$eventDetails = other.getEventDetails();
            if (this$eventDetails == null ? other$eventDetails != null : !((Object)this$eventDetails).equals(other$eventDetails)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            Flight this$flight = this.getFlight();
            Flight other$flight = other.getFlight();
            if (this$flight == null ? other$flight != null : !((Object)this$flight).equals(other$flight)) {
                return false;
            }
            Lodging this$lodging = this.getLodging();
            Lodging other$lodging = other.getLodging();
            if (this$lodging == null ? other$lodging != null : !((Object)this$lodging).equals(other$lodging)) {
                return false;
            }
            Object this$orderReference = this.getOrderReference();
            Object other$orderReference = other.getOrderReference();
            if (this$orderReference == null ? other$orderReference != null : !this$orderReference.equals(other$orderReference)) {
                return false;
            }
            Subscription this$subscription = this.getSubscription();
            Subscription other$subscription = other.getSubscription();
            return !(this$subscription == null ? other$subscription != null : !((Object)this$subscription).equals(other$subscription));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CarRental $carRental = this.getCarRental();
            result = result * 59 + ($carRental == null ? 43 : ((Object)$carRental).hashCode());
            Object $customerReference = this.getCustomerReference();
            result = result * 59 + ($customerReference == null ? 43 : $customerReference.hashCode());
            EventDetails $eventDetails = this.getEventDetails();
            result = result * 59 + ($eventDetails == null ? 43 : ((Object)$eventDetails).hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            Flight $flight = this.getFlight();
            result = result * 59 + ($flight == null ? 43 : ((Object)$flight).hashCode());
            Lodging $lodging = this.getLodging();
            result = result * 59 + ($lodging == null ? 43 : ((Object)$lodging).hashCode());
            Object $orderReference = this.getOrderReference();
            result = result * 59 + ($orderReference == null ? 43 : $orderReference.hashCode());
            Subscription $subscription = this.getSubscription();
            result = result * 59 + ($subscription == null ? 43 : ((Object)$subscription).hashCode());
            return result;
        }

        public static class CarRental {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="booking_number")
            String bookingNumber;
            @SerializedName(value="car_class_code")
            String carClassCode;
            @SerializedName(value="car_make")
            String carMake;
            @SerializedName(value="car_model")
            String carModel;
            @SerializedName(value="company")
            String company;
            @SerializedName(value="customer_service_phone_number")
            String customerServicePhoneNumber;
            @SerializedName(value="days_rented")
            Long daysRented;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="distance")
            Distance distance;
            @SerializedName(value="drivers")
            List<Driver> drivers;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="pickup_address")
            PickupAddress pickupAddress;
            @SerializedName(value="pickup_at")
            Long pickupAt;
            @SerializedName(value="pickup_location_name")
            String pickupLocationName;
            @SerializedName(value="rate_amount")
            Long rateAmount;
            @SerializedName(value="rate_interval")
            RateInterval rateInterval;
            @SerializedName(value="renter_name")
            String renterName;
            @SerializedName(value="return_address")
            ReturnAddress returnAddress;
            @SerializedName(value="return_at")
            Long returnAt;
            @SerializedName(value="return_location_name")
            String returnLocationName;
            @SerializedName(value="tax_exempt")
            Boolean taxExempt;
            @SerializedName(value="vehicle_identification_number")
            String vehicleIdentificationNumber;

            private CarRental(Affiliate affiliate, String bookingNumber, String carClassCode, String carMake, String carModel, String company, String customerServicePhoneNumber, Long daysRented, Delivery delivery, Distance distance, List<Driver> drivers, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean noShow, PickupAddress pickupAddress, Long pickupAt, String pickupLocationName, Long rateAmount, RateInterval rateInterval, String renterName, ReturnAddress returnAddress, Long returnAt, String returnLocationName, Boolean taxExempt, String vehicleIdentificationNumber) {
                this.affiliate = affiliate;
                this.bookingNumber = bookingNumber;
                this.carClassCode = carClassCode;
                this.carMake = carMake;
                this.carModel = carModel;
                this.company = company;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.daysRented = daysRented;
                this.delivery = delivery;
                this.distance = distance;
                this.drivers = drivers;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.noShow = noShow;
                this.pickupAddress = pickupAddress;
                this.pickupAt = pickupAt;
                this.pickupLocationName = pickupLocationName;
                this.rateAmount = rateAmount;
                this.rateInterval = rateInterval;
                this.renterName = renterName;
                this.returnAddress = returnAddress;
                this.returnAt = returnAt;
                this.returnLocationName = returnLocationName;
                this.taxExempt = taxExempt;
                this.vehicleIdentificationNumber = vehicleIdentificationNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public String getCarClassCode() {
                return this.carClassCode;
            }

            @Generated
            public String getCarMake() {
                return this.carMake;
            }

            @Generated
            public String getCarModel() {
                return this.carModel;
            }

            @Generated
            public String getCompany() {
                return this.company;
            }

            @Generated
            public String getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDaysRented() {
                return this.daysRented;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Distance getDistance() {
                return this.distance;
            }

            @Generated
            public List<Driver> getDrivers() {
                return this.drivers;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public PickupAddress getPickupAddress() {
                return this.pickupAddress;
            }

            @Generated
            public Long getPickupAt() {
                return this.pickupAt;
            }

            @Generated
            public String getPickupLocationName() {
                return this.pickupLocationName;
            }

            @Generated
            public Long getRateAmount() {
                return this.rateAmount;
            }

            @Generated
            public RateInterval getRateInterval() {
                return this.rateInterval;
            }

            @Generated
            public String getRenterName() {
                return this.renterName;
            }

            @Generated
            public ReturnAddress getReturnAddress() {
                return this.returnAddress;
            }

            @Generated
            public Long getReturnAt() {
                return this.returnAt;
            }

            @Generated
            public String getReturnLocationName() {
                return this.returnLocationName;
            }

            @Generated
            public Boolean getTaxExempt() {
                return this.taxExempt;
            }

            @Generated
            public String getVehicleIdentificationNumber() {
                return this.vehicleIdentificationNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CarRental)) {
                    return false;
                }
                CarRental other = (CarRental)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$daysRented = this.getDaysRented();
                Long other$daysRented = other.getDaysRented();
                if (this$daysRented == null ? other$daysRented != null : !((Object)this$daysRented).equals(other$daysRented)) {
                    return false;
                }
                Boolean this$noShow = this.getNoShow();
                Boolean other$noShow = other.getNoShow();
                if (this$noShow == null ? other$noShow != null : !((Object)this$noShow).equals(other$noShow)) {
                    return false;
                }
                Long this$pickupAt = this.getPickupAt();
                Long other$pickupAt = other.getPickupAt();
                if (this$pickupAt == null ? other$pickupAt != null : !((Object)this$pickupAt).equals(other$pickupAt)) {
                    return false;
                }
                Long this$rateAmount = this.getRateAmount();
                Long other$rateAmount = other.getRateAmount();
                if (this$rateAmount == null ? other$rateAmount != null : !((Object)this$rateAmount).equals(other$rateAmount)) {
                    return false;
                }
                Long this$returnAt = this.getReturnAt();
                Long other$returnAt = other.getReturnAt();
                if (this$returnAt == null ? other$returnAt != null : !((Object)this$returnAt).equals(other$returnAt)) {
                    return false;
                }
                Boolean this$taxExempt = this.getTaxExempt();
                Boolean other$taxExempt = other.getTaxExempt();
                if (this$taxExempt == null ? other$taxExempt != null : !((Object)this$taxExempt).equals(other$taxExempt)) {
                    return false;
                }
                Affiliate this$affiliate = this.getAffiliate();
                Affiliate other$affiliate = other.getAffiliate();
                if (this$affiliate == null ? other$affiliate != null : !((Object)this$affiliate).equals(other$affiliate)) {
                    return false;
                }
                String this$bookingNumber = this.getBookingNumber();
                String other$bookingNumber = other.getBookingNumber();
                if (this$bookingNumber == null ? other$bookingNumber != null : !this$bookingNumber.equals(other$bookingNumber)) {
                    return false;
                }
                String this$carClassCode = this.getCarClassCode();
                String other$carClassCode = other.getCarClassCode();
                if (this$carClassCode == null ? other$carClassCode != null : !this$carClassCode.equals(other$carClassCode)) {
                    return false;
                }
                String this$carMake = this.getCarMake();
                String other$carMake = other.getCarMake();
                if (this$carMake == null ? other$carMake != null : !this$carMake.equals(other$carMake)) {
                    return false;
                }
                String this$carModel = this.getCarModel();
                String other$carModel = other.getCarModel();
                if (this$carModel == null ? other$carModel != null : !this$carModel.equals(other$carModel)) {
                    return false;
                }
                String this$company = this.getCompany();
                String other$company = other.getCompany();
                if (this$company == null ? other$company != null : !this$company.equals(other$company)) {
                    return false;
                }
                String this$customerServicePhoneNumber = this.getCustomerServicePhoneNumber();
                String other$customerServicePhoneNumber = other.getCustomerServicePhoneNumber();
                if (this$customerServicePhoneNumber == null ? other$customerServicePhoneNumber != null : !this$customerServicePhoneNumber.equals(other$customerServicePhoneNumber)) {
                    return false;
                }
                Delivery this$delivery = this.getDelivery();
                Delivery other$delivery = other.getDelivery();
                if (this$delivery == null ? other$delivery != null : !((Object)this$delivery).equals(other$delivery)) {
                    return false;
                }
                Distance this$distance = this.getDistance();
                Distance other$distance = other.getDistance();
                if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
                    return false;
                }
                List<Driver> this$drivers = this.getDrivers();
                List<Driver> other$drivers = other.getDrivers();
                if (this$drivers == null ? other$drivers != null : !((Object)this$drivers).equals(other$drivers)) {
                    return false;
                }
                List<ExtraCharge> this$extraCharges = this.getExtraCharges();
                List<ExtraCharge> other$extraCharges = other.getExtraCharges();
                if (this$extraCharges == null ? other$extraCharges != null : !((Object)this$extraCharges).equals(other$extraCharges)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                PickupAddress this$pickupAddress = this.getPickupAddress();
                PickupAddress other$pickupAddress = other.getPickupAddress();
                if (this$pickupAddress == null ? other$pickupAddress != null : !((Object)this$pickupAddress).equals(other$pickupAddress)) {
                    return false;
                }
                String this$pickupLocationName = this.getPickupLocationName();
                String other$pickupLocationName = other.getPickupLocationName();
                if (this$pickupLocationName == null ? other$pickupLocationName != null : !this$pickupLocationName.equals(other$pickupLocationName)) {
                    return false;
                }
                RateInterval this$rateInterval = this.getRateInterval();
                RateInterval other$rateInterval = other.getRateInterval();
                if (this$rateInterval == null ? other$rateInterval != null : !this$rateInterval.equals(other$rateInterval)) {
                    return false;
                }
                String this$renterName = this.getRenterName();
                String other$renterName = other.getRenterName();
                if (this$renterName == null ? other$renterName != null : !this$renterName.equals(other$renterName)) {
                    return false;
                }
                ReturnAddress this$returnAddress = this.getReturnAddress();
                ReturnAddress other$returnAddress = other.getReturnAddress();
                if (this$returnAddress == null ? other$returnAddress != null : !((Object)this$returnAddress).equals(other$returnAddress)) {
                    return false;
                }
                String this$returnLocationName = this.getReturnLocationName();
                String other$returnLocationName = other.getReturnLocationName();
                if (this$returnLocationName == null ? other$returnLocationName != null : !this$returnLocationName.equals(other$returnLocationName)) {
                    return false;
                }
                String this$vehicleIdentificationNumber = this.getVehicleIdentificationNumber();
                String other$vehicleIdentificationNumber = other.getVehicleIdentificationNumber();
                return !(this$vehicleIdentificationNumber == null ? other$vehicleIdentificationNumber != null : !this$vehicleIdentificationNumber.equals(other$vehicleIdentificationNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CarRental;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $daysRented = this.getDaysRented();
                result = result * 59 + ($daysRented == null ? 43 : ((Object)$daysRented).hashCode());
                Boolean $noShow = this.getNoShow();
                result = result * 59 + ($noShow == null ? 43 : ((Object)$noShow).hashCode());
                Long $pickupAt = this.getPickupAt();
                result = result * 59 + ($pickupAt == null ? 43 : ((Object)$pickupAt).hashCode());
                Long $rateAmount = this.getRateAmount();
                result = result * 59 + ($rateAmount == null ? 43 : ((Object)$rateAmount).hashCode());
                Long $returnAt = this.getReturnAt();
                result = result * 59 + ($returnAt == null ? 43 : ((Object)$returnAt).hashCode());
                Boolean $taxExempt = this.getTaxExempt();
                result = result * 59 + ($taxExempt == null ? 43 : ((Object)$taxExempt).hashCode());
                Affiliate $affiliate = this.getAffiliate();
                result = result * 59 + ($affiliate == null ? 43 : ((Object)$affiliate).hashCode());
                String $bookingNumber = this.getBookingNumber();
                result = result * 59 + ($bookingNumber == null ? 43 : $bookingNumber.hashCode());
                String $carClassCode = this.getCarClassCode();
                result = result * 59 + ($carClassCode == null ? 43 : $carClassCode.hashCode());
                String $carMake = this.getCarMake();
                result = result * 59 + ($carMake == null ? 43 : $carMake.hashCode());
                String $carModel = this.getCarModel();
                result = result * 59 + ($carModel == null ? 43 : $carModel.hashCode());
                String $company = this.getCompany();
                result = result * 59 + ($company == null ? 43 : $company.hashCode());
                String $customerServicePhoneNumber = this.getCustomerServicePhoneNumber();
                result = result * 59 + ($customerServicePhoneNumber == null ? 43 : $customerServicePhoneNumber.hashCode());
                Delivery $delivery = this.getDelivery();
                result = result * 59 + ($delivery == null ? 43 : ((Object)$delivery).hashCode());
                Distance $distance = this.getDistance();
                result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
                List<Driver> $drivers = this.getDrivers();
                result = result * 59 + ($drivers == null ? 43 : ((Object)$drivers).hashCode());
                List<ExtraCharge> $extraCharges = this.getExtraCharges();
                result = result * 59 + ($extraCharges == null ? 43 : ((Object)$extraCharges).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                PickupAddress $pickupAddress = this.getPickupAddress();
                result = result * 59 + ($pickupAddress == null ? 43 : ((Object)$pickupAddress).hashCode());
                String $pickupLocationName = this.getPickupLocationName();
                result = result * 59 + ($pickupLocationName == null ? 43 : $pickupLocationName.hashCode());
                RateInterval $rateInterval = this.getRateInterval();
                result = result * 59 + ($rateInterval == null ? 43 : $rateInterval.hashCode());
                String $renterName = this.getRenterName();
                result = result * 59 + ($renterName == null ? 43 : $renterName.hashCode());
                ReturnAddress $returnAddress = this.getReturnAddress();
                result = result * 59 + ($returnAddress == null ? 43 : ((Object)$returnAddress).hashCode());
                String $returnLocationName = this.getReturnLocationName();
                result = result * 59 + ($returnLocationName == null ? 43 : $returnLocationName.hashCode());
                String $vehicleIdentificationNumber = this.getVehicleIdentificationNumber();
                result = result * 59 + ($vehicleIdentificationNumber == null ? 43 : $vehicleIdentificationNumber.hashCode());
                return result;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Affiliate)) {
                        return false;
                    }
                    Affiliate other = (Affiliate)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Affiliate;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Delivery)) {
                        return false;
                    }
                    Delivery other = (Delivery)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Mode this$mode = this.getMode();
                    Mode other$mode = other.getMode();
                    if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                        return false;
                    }
                    Recipient this$recipient = this.getRecipient();
                    Recipient other$recipient = other.getRecipient();
                    return !(this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Delivery;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Mode $mode = this.getMode();
                    result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                    Recipient $recipient = this.getRecipient();
                    result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
                    return result;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Recipient)) {
                            return false;
                        }
                        Recipient other = (Recipient)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        String this$phone = this.getPhone();
                        String other$phone = other.getPhone();
                        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Recipient;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        String $phone = this.getPhone();
                        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                        return result;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Distance {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="unit")
                Unit unit;

                private Distance(Long amount, Map<String, Object> extraParams, Unit unit) {
                    this.amount = amount;
                    this.extraParams = extraParams;
                    this.unit = unit;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Unit getUnit() {
                    return this.unit;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Distance)) {
                        return false;
                    }
                    Distance other = (Distance)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Unit this$unit = this.getUnit();
                    Unit other$unit = other.getUnit();
                    return !(this$unit == null ? other$unit != null : !this$unit.equals(other$unit));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Distance;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Unit $unit = this.getUnit();
                    result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                    return result;
                }

                public static enum Unit implements ApiRequestParams.EnumParam
                {
                    KILOMETERS("kilometers"),
                    MILES("miles");

                    private final String value;

                    private Unit(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long amount;
                    private Map<String, Object> extraParams;
                    private Unit unit;

                    public Distance build() {
                        return new Distance(this.amount, this.extraParams, this.unit);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setUnit(Unit unit) {
                        this.unit = unit;
                        return this;
                    }
                }
            }

            public static class PickupAddress {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private PickupAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof PickupAddress)) {
                        return false;
                    }
                    PickupAddress other = (PickupAddress)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof PickupAddress;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public PickupAddress build() {
                        return new PickupAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static enum RateInterval implements ApiRequestParams.EnumParam
            {
                DAY("day"),
                MONTH("month"),
                WEEK("week");

                private final String value;

                private RateInterval(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class ReturnAddress {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private ReturnAddress(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ReturnAddress)) {
                        return false;
                    }
                    ReturnAddress other = (ReturnAddress)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ReturnAddress;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public ReturnAddress build() {
                        return new ReturnAddress(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private String bookingNumber;
                private String carClassCode;
                private String carMake;
                private String carModel;
                private String company;
                private String customerServicePhoneNumber;
                private Long daysRented;
                private Delivery delivery;
                private Distance distance;
                private List<Driver> drivers;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean noShow;
                private PickupAddress pickupAddress;
                private Long pickupAt;
                private String pickupLocationName;
                private Long rateAmount;
                private RateInterval rateInterval;
                private String renterName;
                private ReturnAddress returnAddress;
                private Long returnAt;
                private String returnLocationName;
                private Boolean taxExempt;
                private String vehicleIdentificationNumber;

                public CarRental build() {
                    return new CarRental(this.affiliate, this.bookingNumber, this.carClassCode, this.carMake, this.carModel, this.company, this.customerServicePhoneNumber, this.daysRented, this.delivery, this.distance, this.drivers, this.extraCharges, this.extraParams, this.noShow, this.pickupAddress, this.pickupAt, this.pickupLocationName, this.rateAmount, this.rateInterval, this.renterName, this.returnAddress, this.returnAt, this.returnLocationName, this.taxExempt, this.vehicleIdentificationNumber);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCarClassCode(String carClassCode) {
                    this.carClassCode = carClassCode;
                    return this;
                }

                public Builder setCarMake(String carMake) {
                    this.carMake = carMake;
                    return this;
                }

                public Builder setCarModel(String carModel) {
                    this.carModel = carModel;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDaysRented(Long daysRented) {
                    this.daysRented = daysRented;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder setDistance(Distance distance) {
                    this.distance = distance;
                    return this;
                }

                public Builder addDriver(Driver element) {
                    if (this.drivers == null) {
                        this.drivers = new ArrayList<Driver>();
                    }
                    this.drivers.add(element);
                    return this;
                }

                public Builder addAllDriver(List<Driver> elements) {
                    if (this.drivers == null) {
                        this.drivers = new ArrayList<Driver>();
                    }
                    this.drivers.addAll(elements);
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setPickupAddress(PickupAddress pickupAddress) {
                    this.pickupAddress = pickupAddress;
                    return this;
                }

                public Builder setPickupAt(Long pickupAt) {
                    this.pickupAt = pickupAt;
                    return this;
                }

                public Builder setPickupLocationName(String pickupLocationName) {
                    this.pickupLocationName = pickupLocationName;
                    return this;
                }

                public Builder setRateAmount(Long rateAmount) {
                    this.rateAmount = rateAmount;
                    return this;
                }

                public Builder setRateInterval(RateInterval rateInterval) {
                    this.rateInterval = rateInterval;
                    return this;
                }

                public Builder setRenterName(String renterName) {
                    this.renterName = renterName;
                    return this;
                }

                public Builder setReturnAddress(ReturnAddress returnAddress) {
                    this.returnAddress = returnAddress;
                    return this;
                }

                public Builder setReturnAt(Long returnAt) {
                    this.returnAt = returnAt;
                    return this;
                }

                public Builder setReturnLocationName(String returnLocationName) {
                    this.returnLocationName = returnLocationName;
                    return this;
                }

                public Builder setTaxExempt(Boolean taxExempt) {
                    this.taxExempt = taxExempt;
                    return this;
                }

                public Builder setVehicleIdentificationNumber(String vehicleIdentificationNumber) {
                    this.vehicleIdentificationNumber = vehicleIdentificationNumber;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                EXTRA_MILEAGE("extra_mileage"),
                GAS("gas"),
                LATE_RETURN("late_return"),
                ONE_WAY_SERVICE("one_way_service"),
                PARKING_VIOLATION("parking_violation");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Driver {
                @SerializedName(value="driver_identification_number")
                String driverIdentificationNumber;
                @SerializedName(value="driver_tax_number")
                String driverTaxNumber;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Driver(String driverIdentificationNumber, String driverTaxNumber, Map<String, Object> extraParams, String name) {
                    this.driverIdentificationNumber = driverIdentificationNumber;
                    this.driverTaxNumber = driverTaxNumber;
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getDriverIdentificationNumber() {
                    return this.driverIdentificationNumber;
                }

                @Generated
                public String getDriverTaxNumber() {
                    return this.driverTaxNumber;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Driver)) {
                        return false;
                    }
                    Driver other = (Driver)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$driverIdentificationNumber = this.getDriverIdentificationNumber();
                    String other$driverIdentificationNumber = other.getDriverIdentificationNumber();
                    if (this$driverIdentificationNumber == null ? other$driverIdentificationNumber != null : !this$driverIdentificationNumber.equals(other$driverIdentificationNumber)) {
                        return false;
                    }
                    String this$driverTaxNumber = this.getDriverTaxNumber();
                    String other$driverTaxNumber = other.getDriverTaxNumber();
                    if (this$driverTaxNumber == null ? other$driverTaxNumber != null : !this$driverTaxNumber.equals(other$driverTaxNumber)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Driver;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $driverIdentificationNumber = this.getDriverIdentificationNumber();
                    result = result * 59 + ($driverIdentificationNumber == null ? 43 : $driverIdentificationNumber.hashCode());
                    String $driverTaxNumber = this.getDriverTaxNumber();
                    result = result * 59 + ($driverTaxNumber == null ? 43 : $driverTaxNumber.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private String driverIdentificationNumber;
                    private String driverTaxNumber;
                    private Map<String, Object> extraParams;
                    private String name;

                    public Driver build() {
                        return new Driver(this.driverIdentificationNumber, this.driverTaxNumber, this.extraParams, this.name);
                    }

                    public Builder setDriverIdentificationNumber(String driverIdentificationNumber) {
                        this.driverIdentificationNumber = driverIdentificationNumber;
                        return this;
                    }

                    public Builder setDriverTaxNumber(String driverTaxNumber) {
                        this.driverTaxNumber = driverTaxNumber;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class EventDetails {
            @SerializedName(value="access_controlled_venue")
            Boolean accessControlledVenue;
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="company")
            String company;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="ends_at")
            Long endsAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="genre")
            String genre;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="starts_at")
            Long startsAt;

            private EventDetails(Boolean accessControlledVenue, Address address, Affiliate affiliate, String company, Delivery delivery, Long endsAt, Map<String, Object> extraParams, String genre, String name, Long startsAt) {
                this.accessControlledVenue = accessControlledVenue;
                this.address = address;
                this.affiliate = affiliate;
                this.company = company;
                this.delivery = delivery;
                this.endsAt = endsAt;
                this.extraParams = extraParams;
                this.genre = genre;
                this.name = name;
                this.startsAt = startsAt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Boolean getAccessControlledVenue() {
                return this.accessControlledVenue;
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getCompany() {
                return this.company;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Long getEndsAt() {
                return this.endsAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getGenre() {
                return this.genre;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Long getStartsAt() {
                return this.startsAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EventDetails)) {
                    return false;
                }
                EventDetails other = (EventDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$accessControlledVenue = this.getAccessControlledVenue();
                Boolean other$accessControlledVenue = other.getAccessControlledVenue();
                if (this$accessControlledVenue == null ? other$accessControlledVenue != null : !((Object)this$accessControlledVenue).equals(other$accessControlledVenue)) {
                    return false;
                }
                Long this$endsAt = this.getEndsAt();
                Long other$endsAt = other.getEndsAt();
                if (this$endsAt == null ? other$endsAt != null : !((Object)this$endsAt).equals(other$endsAt)) {
                    return false;
                }
                Long this$startsAt = this.getStartsAt();
                Long other$startsAt = other.getStartsAt();
                if (this$startsAt == null ? other$startsAt != null : !((Object)this$startsAt).equals(other$startsAt)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                Affiliate this$affiliate = this.getAffiliate();
                Affiliate other$affiliate = other.getAffiliate();
                if (this$affiliate == null ? other$affiliate != null : !((Object)this$affiliate).equals(other$affiliate)) {
                    return false;
                }
                String this$company = this.getCompany();
                String other$company = other.getCompany();
                if (this$company == null ? other$company != null : !this$company.equals(other$company)) {
                    return false;
                }
                Delivery this$delivery = this.getDelivery();
                Delivery other$delivery = other.getDelivery();
                if (this$delivery == null ? other$delivery != null : !((Object)this$delivery).equals(other$delivery)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$genre = this.getGenre();
                String other$genre = other.getGenre();
                if (this$genre == null ? other$genre != null : !this$genre.equals(other$genre)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof EventDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $accessControlledVenue = this.getAccessControlledVenue();
                result = result * 59 + ($accessControlledVenue == null ? 43 : ((Object)$accessControlledVenue).hashCode());
                Long $endsAt = this.getEndsAt();
                result = result * 59 + ($endsAt == null ? 43 : ((Object)$endsAt).hashCode());
                Long $startsAt = this.getStartsAt();
                result = result * 59 + ($startsAt == null ? 43 : ((Object)$startsAt).hashCode());
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                Affiliate $affiliate = this.getAffiliate();
                result = result * 59 + ($affiliate == null ? 43 : ((Object)$affiliate).hashCode());
                String $company = this.getCompany();
                result = result * 59 + ($company == null ? 43 : $company.hashCode());
                Delivery $delivery = this.getDelivery();
                result = result * 59 + ($delivery == null ? 43 : ((Object)$delivery).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $genre = this.getGenre();
                result = result * 59 + ($genre == null ? 43 : $genre.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Address)) {
                        return false;
                    }
                    Address other = (Address)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Address;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Affiliate)) {
                        return false;
                    }
                    Affiliate other = (Affiliate)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Affiliate;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Delivery)) {
                        return false;
                    }
                    Delivery other = (Delivery)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Mode this$mode = this.getMode();
                    Mode other$mode = other.getMode();
                    if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                        return false;
                    }
                    Recipient this$recipient = this.getRecipient();
                    Recipient other$recipient = other.getRecipient();
                    return !(this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Delivery;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Mode $mode = this.getMode();
                    result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                    Recipient $recipient = this.getRecipient();
                    result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
                    return result;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Recipient)) {
                            return false;
                        }
                        Recipient other = (Recipient)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        String this$phone = this.getPhone();
                        String other$phone = other.getPhone();
                        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Recipient;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        String $phone = this.getPhone();
                        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                        return result;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Boolean accessControlledVenue;
                private Address address;
                private Affiliate affiliate;
                private String company;
                private Delivery delivery;
                private Long endsAt;
                private Map<String, Object> extraParams;
                private String genre;
                private String name;
                private Long startsAt;

                public EventDetails build() {
                    return new EventDetails(this.accessControlledVenue, this.address, this.affiliate, this.company, this.delivery, this.endsAt, this.extraParams, this.genre, this.name, this.startsAt);
                }

                public Builder setAccessControlledVenue(Boolean accessControlledVenue) {
                    this.accessControlledVenue = accessControlledVenue;
                    return this;
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setCompany(String company) {
                    this.company = company;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder setEndsAt(Long endsAt) {
                    this.endsAt = endsAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setGenre(String genre) {
                    this.genre = genre;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setStartsAt(Long startsAt) {
                    this.startsAt = startsAt;
                    return this;
                }
            }
        }

        public static class Flight {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="agency_number")
            String agencyNumber;
            @SerializedName(value="carrier")
            String carrier;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="passenger_name")
            String passengerName;
            @SerializedName(value="passengers")
            List<Passenger> passengers;
            @SerializedName(value="segments")
            List<Segment> segments;
            @SerializedName(value="ticket_number")
            String ticketNumber;

            private Flight(Affiliate affiliate, String agencyNumber, String carrier, Delivery delivery, Map<String, Object> extraParams, String passengerName, List<Passenger> passengers, List<Segment> segments, String ticketNumber) {
                this.affiliate = affiliate;
                this.agencyNumber = agencyNumber;
                this.carrier = carrier;
                this.delivery = delivery;
                this.extraParams = extraParams;
                this.passengerName = passengerName;
                this.passengers = passengers;
                this.segments = segments;
                this.ticketNumber = ticketNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getAgencyNumber() {
                return this.agencyNumber;
            }

            @Generated
            public String getCarrier() {
                return this.carrier;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPassengerName() {
                return this.passengerName;
            }

            @Generated
            public List<Passenger> getPassengers() {
                return this.passengers;
            }

            @Generated
            public List<Segment> getSegments() {
                return this.segments;
            }

            @Generated
            public String getTicketNumber() {
                return this.ticketNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Flight)) {
                    return false;
                }
                Flight other = (Flight)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Affiliate this$affiliate = this.getAffiliate();
                Affiliate other$affiliate = other.getAffiliate();
                if (this$affiliate == null ? other$affiliate != null : !((Object)this$affiliate).equals(other$affiliate)) {
                    return false;
                }
                String this$agencyNumber = this.getAgencyNumber();
                String other$agencyNumber = other.getAgencyNumber();
                if (this$agencyNumber == null ? other$agencyNumber != null : !this$agencyNumber.equals(other$agencyNumber)) {
                    return false;
                }
                String this$carrier = this.getCarrier();
                String other$carrier = other.getCarrier();
                if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) {
                    return false;
                }
                Delivery this$delivery = this.getDelivery();
                Delivery other$delivery = other.getDelivery();
                if (this$delivery == null ? other$delivery != null : !((Object)this$delivery).equals(other$delivery)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$passengerName = this.getPassengerName();
                String other$passengerName = other.getPassengerName();
                if (this$passengerName == null ? other$passengerName != null : !this$passengerName.equals(other$passengerName)) {
                    return false;
                }
                List<Passenger> this$passengers = this.getPassengers();
                List<Passenger> other$passengers = other.getPassengers();
                if (this$passengers == null ? other$passengers != null : !((Object)this$passengers).equals(other$passengers)) {
                    return false;
                }
                List<Segment> this$segments = this.getSegments();
                List<Segment> other$segments = other.getSegments();
                if (this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments)) {
                    return false;
                }
                String this$ticketNumber = this.getTicketNumber();
                String other$ticketNumber = other.getTicketNumber();
                return !(this$ticketNumber == null ? other$ticketNumber != null : !this$ticketNumber.equals(other$ticketNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Flight;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Affiliate $affiliate = this.getAffiliate();
                result = result * 59 + ($affiliate == null ? 43 : ((Object)$affiliate).hashCode());
                String $agencyNumber = this.getAgencyNumber();
                result = result * 59 + ($agencyNumber == null ? 43 : $agencyNumber.hashCode());
                String $carrier = this.getCarrier();
                result = result * 59 + ($carrier == null ? 43 : $carrier.hashCode());
                Delivery $delivery = this.getDelivery();
                result = result * 59 + ($delivery == null ? 43 : ((Object)$delivery).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $passengerName = this.getPassengerName();
                result = result * 59 + ($passengerName == null ? 43 : $passengerName.hashCode());
                List<Passenger> $passengers = this.getPassengers();
                result = result * 59 + ($passengers == null ? 43 : ((Object)$passengers).hashCode());
                List<Segment> $segments = this.getSegments();
                result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
                String $ticketNumber = this.getTicketNumber();
                result = result * 59 + ($ticketNumber == null ? 43 : $ticketNumber.hashCode());
                return result;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Affiliate)) {
                        return false;
                    }
                    Affiliate other = (Affiliate)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Affiliate;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Delivery)) {
                        return false;
                    }
                    Delivery other = (Delivery)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Mode this$mode = this.getMode();
                    Mode other$mode = other.getMode();
                    if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                        return false;
                    }
                    Recipient this$recipient = this.getRecipient();
                    Recipient other$recipient = other.getRecipient();
                    return !(this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Delivery;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Mode $mode = this.getMode();
                    result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                    Recipient $recipient = this.getRecipient();
                    result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
                    return result;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Recipient)) {
                            return false;
                        }
                        Recipient other = (Recipient)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        String this$phone = this.getPhone();
                        String other$phone = other.getPhone();
                        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Recipient;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        String $phone = this.getPhone();
                        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                        return result;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private String agencyNumber;
                private String carrier;
                private Delivery delivery;
                private Map<String, Object> extraParams;
                private String passengerName;
                private List<Passenger> passengers;
                private List<Segment> segments;
                private String ticketNumber;

                public Flight build() {
                    return new Flight(this.affiliate, this.agencyNumber, this.carrier, this.delivery, this.extraParams, this.passengerName, this.passengers, this.segments, this.ticketNumber);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setAgencyNumber(String agencyNumber) {
                    this.agencyNumber = agencyNumber;
                    return this;
                }

                public Builder setCarrier(String carrier) {
                    this.carrier = carrier;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPassengerName(String passengerName) {
                    this.passengerName = passengerName;
                    return this;
                }

                public Builder addPassenger(Passenger element) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.add(element);
                    return this;
                }

                public Builder addAllPassenger(List<Passenger> elements) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.addAll(elements);
                    return this;
                }

                public Builder addSegment(Segment element) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.add(element);
                    return this;
                }

                public Builder addAllSegment(List<Segment> elements) {
                    if (this.segments == null) {
                        this.segments = new ArrayList<Segment>();
                    }
                    this.segments.addAll(elements);
                    return this;
                }

                public Builder setTicketNumber(String ticketNumber) {
                    this.ticketNumber = ticketNumber;
                    return this;
                }
            }

            public static class Segment {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="arrival_airport")
                String arrivalAirport;
                @SerializedName(value="arrives_at")
                Long arrivesAt;
                @SerializedName(value="carrier")
                String carrier;
                @SerializedName(value="departs_at")
                Long departsAt;
                @SerializedName(value="departure_airport")
                String departureAirport;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="flight_number")
                String flightNumber;
                @SerializedName(value="service_class")
                ServiceClass serviceClass;

                private Segment(Long amount, String arrivalAirport, Long arrivesAt, String carrier, Long departsAt, String departureAirport, Map<String, Object> extraParams, String flightNumber, ServiceClass serviceClass) {
                    this.amount = amount;
                    this.arrivalAirport = arrivalAirport;
                    this.arrivesAt = arrivesAt;
                    this.carrier = carrier;
                    this.departsAt = departsAt;
                    this.departureAirport = departureAirport;
                    this.extraParams = extraParams;
                    this.flightNumber = flightNumber;
                    this.serviceClass = serviceClass;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public String getArrivalAirport() {
                    return this.arrivalAirport;
                }

                @Generated
                public Long getArrivesAt() {
                    return this.arrivesAt;
                }

                @Generated
                public String getCarrier() {
                    return this.carrier;
                }

                @Generated
                public Long getDepartsAt() {
                    return this.departsAt;
                }

                @Generated
                public String getDepartureAirport() {
                    return this.departureAirport;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getFlightNumber() {
                    return this.flightNumber;
                }

                @Generated
                public ServiceClass getServiceClass() {
                    return this.serviceClass;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Segment)) {
                        return false;
                    }
                    Segment other = (Segment)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$arrivesAt = this.getArrivesAt();
                    Long other$arrivesAt = other.getArrivesAt();
                    if (this$arrivesAt == null ? other$arrivesAt != null : !((Object)this$arrivesAt).equals(other$arrivesAt)) {
                        return false;
                    }
                    Long this$departsAt = this.getDepartsAt();
                    Long other$departsAt = other.getDepartsAt();
                    if (this$departsAt == null ? other$departsAt != null : !((Object)this$departsAt).equals(other$departsAt)) {
                        return false;
                    }
                    String this$arrivalAirport = this.getArrivalAirport();
                    String other$arrivalAirport = other.getArrivalAirport();
                    if (this$arrivalAirport == null ? other$arrivalAirport != null : !this$arrivalAirport.equals(other$arrivalAirport)) {
                        return false;
                    }
                    String this$carrier = this.getCarrier();
                    String other$carrier = other.getCarrier();
                    if (this$carrier == null ? other$carrier != null : !this$carrier.equals(other$carrier)) {
                        return false;
                    }
                    String this$departureAirport = this.getDepartureAirport();
                    String other$departureAirport = other.getDepartureAirport();
                    if (this$departureAirport == null ? other$departureAirport != null : !this$departureAirport.equals(other$departureAirport)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$flightNumber = this.getFlightNumber();
                    String other$flightNumber = other.getFlightNumber();
                    if (this$flightNumber == null ? other$flightNumber != null : !this$flightNumber.equals(other$flightNumber)) {
                        return false;
                    }
                    ServiceClass this$serviceClass = this.getServiceClass();
                    ServiceClass other$serviceClass = other.getServiceClass();
                    return !(this$serviceClass == null ? other$serviceClass != null : !this$serviceClass.equals(other$serviceClass));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Segment;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $arrivesAt = this.getArrivesAt();
                    result = result * 59 + ($arrivesAt == null ? 43 : ((Object)$arrivesAt).hashCode());
                    Long $departsAt = this.getDepartsAt();
                    result = result * 59 + ($departsAt == null ? 43 : ((Object)$departsAt).hashCode());
                    String $arrivalAirport = this.getArrivalAirport();
                    result = result * 59 + ($arrivalAirport == null ? 43 : $arrivalAirport.hashCode());
                    String $carrier = this.getCarrier();
                    result = result * 59 + ($carrier == null ? 43 : $carrier.hashCode());
                    String $departureAirport = this.getDepartureAirport();
                    result = result * 59 + ($departureAirport == null ? 43 : $departureAirport.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $flightNumber = this.getFlightNumber();
                    result = result * 59 + ($flightNumber == null ? 43 : $flightNumber.hashCode());
                    ServiceClass $serviceClass = this.getServiceClass();
                    result = result * 59 + ($serviceClass == null ? 43 : $serviceClass.hashCode());
                    return result;
                }

                public static enum ServiceClass implements ApiRequestParams.EnumParam
                {
                    BUSINESS("business"),
                    ECONOMY("economy"),
                    FIRST("first"),
                    PREMIUM_ECONOMY("premium_economy");

                    private final String value;

                    private ServiceClass(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long amount;
                    private String arrivalAirport;
                    private Long arrivesAt;
                    private String carrier;
                    private Long departsAt;
                    private String departureAirport;
                    private Map<String, Object> extraParams;
                    private String flightNumber;
                    private ServiceClass serviceClass;

                    public Segment build() {
                        return new Segment(this.amount, this.arrivalAirport, this.arrivesAt, this.carrier, this.departsAt, this.departureAirport, this.extraParams, this.flightNumber, this.serviceClass);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder setArrivalAirport(String arrivalAirport) {
                        this.arrivalAirport = arrivalAirport;
                        return this;
                    }

                    public Builder setArrivesAt(Long arrivesAt) {
                        this.arrivesAt = arrivesAt;
                        return this;
                    }

                    public Builder setCarrier(String carrier) {
                        this.carrier = carrier;
                        return this;
                    }

                    public Builder setDepartsAt(Long departsAt) {
                        this.departsAt = departsAt;
                        return this;
                    }

                    public Builder setDepartureAirport(String departureAirport) {
                        this.departureAirport = departureAirport;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFlightNumber(String flightNumber) {
                        this.flightNumber = flightNumber;
                        return this;
                    }

                    public Builder setServiceClass(ServiceClass serviceClass) {
                        this.serviceClass = serviceClass;
                        return this;
                    }
                }
            }

            public static class Passenger {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Passenger(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Passenger)) {
                        return false;
                    }
                    Passenger other = (Passenger)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Passenger;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Passenger build() {
                        return new Passenger(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class Lodging {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="adults")
            Long adults;
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="booking_number")
            String bookingNumber;
            @SerializedName(value="category")
            Category category;
            @SerializedName(value="checkin_at")
            Long checkinAt;
            @SerializedName(value="checkout_at")
            Long checkoutAt;
            @SerializedName(value="customer_service_phone_number")
            String customerServicePhoneNumber;
            @SerializedName(value="daily_room_rate_amount")
            Long dailyRoomRateAmount;
            @SerializedName(value="delivery")
            Delivery delivery;
            @SerializedName(value="extra_charges")
            List<ExtraCharge> extraCharges;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="fire_safety_act_compliance")
            Boolean fireSafetyActCompliance;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="no_show")
            Boolean noShow;
            @SerializedName(value="number_of_rooms")
            Long numberOfRooms;
            @SerializedName(value="passengers")
            List<Passenger> passengers;
            @SerializedName(value="property_phone_number")
            String propertyPhoneNumber;
            @SerializedName(value="room_class")
            String roomClass;
            @SerializedName(value="room_nights")
            Long roomNights;
            @SerializedName(value="total_room_tax_amount")
            Long totalRoomTaxAmount;
            @SerializedName(value="total_tax_amount")
            Long totalTaxAmount;

            private Lodging(Address address, Long adults, Affiliate affiliate, String bookingNumber, Category category, Long checkinAt, Long checkoutAt, String customerServicePhoneNumber, Long dailyRoomRateAmount, Delivery delivery, List<ExtraCharge> extraCharges, Map<String, Object> extraParams, Boolean fireSafetyActCompliance, String name, Boolean noShow, Long numberOfRooms, List<Passenger> passengers, String propertyPhoneNumber, String roomClass, Long roomNights, Long totalRoomTaxAmount, Long totalTaxAmount) {
                this.address = address;
                this.adults = adults;
                this.affiliate = affiliate;
                this.bookingNumber = bookingNumber;
                this.category = category;
                this.checkinAt = checkinAt;
                this.checkoutAt = checkoutAt;
                this.customerServicePhoneNumber = customerServicePhoneNumber;
                this.dailyRoomRateAmount = dailyRoomRateAmount;
                this.delivery = delivery;
                this.extraCharges = extraCharges;
                this.extraParams = extraParams;
                this.fireSafetyActCompliance = fireSafetyActCompliance;
                this.name = name;
                this.noShow = noShow;
                this.numberOfRooms = numberOfRooms;
                this.passengers = passengers;
                this.propertyPhoneNumber = propertyPhoneNumber;
                this.roomClass = roomClass;
                this.roomNights = roomNights;
                this.totalRoomTaxAmount = totalRoomTaxAmount;
                this.totalTaxAmount = totalTaxAmount;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public Long getAdults() {
                return this.adults;
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public String getBookingNumber() {
                return this.bookingNumber;
            }

            @Generated
            public Category getCategory() {
                return this.category;
            }

            @Generated
            public Long getCheckinAt() {
                return this.checkinAt;
            }

            @Generated
            public Long getCheckoutAt() {
                return this.checkoutAt;
            }

            @Generated
            public String getCustomerServicePhoneNumber() {
                return this.customerServicePhoneNumber;
            }

            @Generated
            public Long getDailyRoomRateAmount() {
                return this.dailyRoomRateAmount;
            }

            @Generated
            public Delivery getDelivery() {
                return this.delivery;
            }

            @Generated
            public List<ExtraCharge> getExtraCharges() {
                return this.extraCharges;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Boolean getFireSafetyActCompliance() {
                return this.fireSafetyActCompliance;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Boolean getNoShow() {
                return this.noShow;
            }

            @Generated
            public Long getNumberOfRooms() {
                return this.numberOfRooms;
            }

            @Generated
            public List<Passenger> getPassengers() {
                return this.passengers;
            }

            @Generated
            public String getPropertyPhoneNumber() {
                return this.propertyPhoneNumber;
            }

            @Generated
            public String getRoomClass() {
                return this.roomClass;
            }

            @Generated
            public Long getRoomNights() {
                return this.roomNights;
            }

            @Generated
            public Long getTotalRoomTaxAmount() {
                return this.totalRoomTaxAmount;
            }

            @Generated
            public Long getTotalTaxAmount() {
                return this.totalTaxAmount;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lodging)) {
                    return false;
                }
                Lodging other = (Lodging)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$adults = this.getAdults();
                Long other$adults = other.getAdults();
                if (this$adults == null ? other$adults != null : !((Object)this$adults).equals(other$adults)) {
                    return false;
                }
                Long this$checkinAt = this.getCheckinAt();
                Long other$checkinAt = other.getCheckinAt();
                if (this$checkinAt == null ? other$checkinAt != null : !((Object)this$checkinAt).equals(other$checkinAt)) {
                    return false;
                }
                Long this$checkoutAt = this.getCheckoutAt();
                Long other$checkoutAt = other.getCheckoutAt();
                if (this$checkoutAt == null ? other$checkoutAt != null : !((Object)this$checkoutAt).equals(other$checkoutAt)) {
                    return false;
                }
                Long this$dailyRoomRateAmount = this.getDailyRoomRateAmount();
                Long other$dailyRoomRateAmount = other.getDailyRoomRateAmount();
                if (this$dailyRoomRateAmount == null ? other$dailyRoomRateAmount != null : !((Object)this$dailyRoomRateAmount).equals(other$dailyRoomRateAmount)) {
                    return false;
                }
                Boolean this$fireSafetyActCompliance = this.getFireSafetyActCompliance();
                Boolean other$fireSafetyActCompliance = other.getFireSafetyActCompliance();
                if (this$fireSafetyActCompliance == null ? other$fireSafetyActCompliance != null : !((Object)this$fireSafetyActCompliance).equals(other$fireSafetyActCompliance)) {
                    return false;
                }
                Boolean this$noShow = this.getNoShow();
                Boolean other$noShow = other.getNoShow();
                if (this$noShow == null ? other$noShow != null : !((Object)this$noShow).equals(other$noShow)) {
                    return false;
                }
                Long this$numberOfRooms = this.getNumberOfRooms();
                Long other$numberOfRooms = other.getNumberOfRooms();
                if (this$numberOfRooms == null ? other$numberOfRooms != null : !((Object)this$numberOfRooms).equals(other$numberOfRooms)) {
                    return false;
                }
                Long this$roomNights = this.getRoomNights();
                Long other$roomNights = other.getRoomNights();
                if (this$roomNights == null ? other$roomNights != null : !((Object)this$roomNights).equals(other$roomNights)) {
                    return false;
                }
                Long this$totalRoomTaxAmount = this.getTotalRoomTaxAmount();
                Long other$totalRoomTaxAmount = other.getTotalRoomTaxAmount();
                if (this$totalRoomTaxAmount == null ? other$totalRoomTaxAmount != null : !((Object)this$totalRoomTaxAmount).equals(other$totalRoomTaxAmount)) {
                    return false;
                }
                Long this$totalTaxAmount = this.getTotalTaxAmount();
                Long other$totalTaxAmount = other.getTotalTaxAmount();
                if (this$totalTaxAmount == null ? other$totalTaxAmount != null : !((Object)this$totalTaxAmount).equals(other$totalTaxAmount)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                Affiliate this$affiliate = this.getAffiliate();
                Affiliate other$affiliate = other.getAffiliate();
                if (this$affiliate == null ? other$affiliate != null : !((Object)this$affiliate).equals(other$affiliate)) {
                    return false;
                }
                String this$bookingNumber = this.getBookingNumber();
                String other$bookingNumber = other.getBookingNumber();
                if (this$bookingNumber == null ? other$bookingNumber != null : !this$bookingNumber.equals(other$bookingNumber)) {
                    return false;
                }
                Category this$category = this.getCategory();
                Category other$category = other.getCategory();
                if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                    return false;
                }
                String this$customerServicePhoneNumber = this.getCustomerServicePhoneNumber();
                String other$customerServicePhoneNumber = other.getCustomerServicePhoneNumber();
                if (this$customerServicePhoneNumber == null ? other$customerServicePhoneNumber != null : !this$customerServicePhoneNumber.equals(other$customerServicePhoneNumber)) {
                    return false;
                }
                Delivery this$delivery = this.getDelivery();
                Delivery other$delivery = other.getDelivery();
                if (this$delivery == null ? other$delivery != null : !((Object)this$delivery).equals(other$delivery)) {
                    return false;
                }
                List<ExtraCharge> this$extraCharges = this.getExtraCharges();
                List<ExtraCharge> other$extraCharges = other.getExtraCharges();
                if (this$extraCharges == null ? other$extraCharges != null : !((Object)this$extraCharges).equals(other$extraCharges)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                List<Passenger> this$passengers = this.getPassengers();
                List<Passenger> other$passengers = other.getPassengers();
                if (this$passengers == null ? other$passengers != null : !((Object)this$passengers).equals(other$passengers)) {
                    return false;
                }
                String this$propertyPhoneNumber = this.getPropertyPhoneNumber();
                String other$propertyPhoneNumber = other.getPropertyPhoneNumber();
                if (this$propertyPhoneNumber == null ? other$propertyPhoneNumber != null : !this$propertyPhoneNumber.equals(other$propertyPhoneNumber)) {
                    return false;
                }
                String this$roomClass = this.getRoomClass();
                String other$roomClass = other.getRoomClass();
                return !(this$roomClass == null ? other$roomClass != null : !this$roomClass.equals(other$roomClass));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lodging;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $adults = this.getAdults();
                result = result * 59 + ($adults == null ? 43 : ((Object)$adults).hashCode());
                Long $checkinAt = this.getCheckinAt();
                result = result * 59 + ($checkinAt == null ? 43 : ((Object)$checkinAt).hashCode());
                Long $checkoutAt = this.getCheckoutAt();
                result = result * 59 + ($checkoutAt == null ? 43 : ((Object)$checkoutAt).hashCode());
                Long $dailyRoomRateAmount = this.getDailyRoomRateAmount();
                result = result * 59 + ($dailyRoomRateAmount == null ? 43 : ((Object)$dailyRoomRateAmount).hashCode());
                Boolean $fireSafetyActCompliance = this.getFireSafetyActCompliance();
                result = result * 59 + ($fireSafetyActCompliance == null ? 43 : ((Object)$fireSafetyActCompliance).hashCode());
                Boolean $noShow = this.getNoShow();
                result = result * 59 + ($noShow == null ? 43 : ((Object)$noShow).hashCode());
                Long $numberOfRooms = this.getNumberOfRooms();
                result = result * 59 + ($numberOfRooms == null ? 43 : ((Object)$numberOfRooms).hashCode());
                Long $roomNights = this.getRoomNights();
                result = result * 59 + ($roomNights == null ? 43 : ((Object)$roomNights).hashCode());
                Long $totalRoomTaxAmount = this.getTotalRoomTaxAmount();
                result = result * 59 + ($totalRoomTaxAmount == null ? 43 : ((Object)$totalRoomTaxAmount).hashCode());
                Long $totalTaxAmount = this.getTotalTaxAmount();
                result = result * 59 + ($totalTaxAmount == null ? 43 : ((Object)$totalTaxAmount).hashCode());
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                Affiliate $affiliate = this.getAffiliate();
                result = result * 59 + ($affiliate == null ? 43 : ((Object)$affiliate).hashCode());
                String $bookingNumber = this.getBookingNumber();
                result = result * 59 + ($bookingNumber == null ? 43 : $bookingNumber.hashCode());
                Category $category = this.getCategory();
                result = result * 59 + ($category == null ? 43 : $category.hashCode());
                String $customerServicePhoneNumber = this.getCustomerServicePhoneNumber();
                result = result * 59 + ($customerServicePhoneNumber == null ? 43 : $customerServicePhoneNumber.hashCode());
                Delivery $delivery = this.getDelivery();
                result = result * 59 + ($delivery == null ? 43 : ((Object)$delivery).hashCode());
                List<ExtraCharge> $extraCharges = this.getExtraCharges();
                result = result * 59 + ($extraCharges == null ? 43 : ((Object)$extraCharges).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                List<Passenger> $passengers = this.getPassengers();
                result = result * 59 + ($passengers == null ? 43 : ((Object)$passengers).hashCode());
                String $propertyPhoneNumber = this.getPropertyPhoneNumber();
                result = result * 59 + ($propertyPhoneNumber == null ? 43 : $propertyPhoneNumber.hashCode());
                String $roomClass = this.getRoomClass();
                result = result * 59 + ($roomClass == null ? 43 : $roomClass.hashCode());
                return result;
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Address)) {
                        return false;
                    }
                    Address other = (Address)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Address;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Affiliate)) {
                        return false;
                    }
                    Affiliate other = (Affiliate)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Affiliate;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static enum Category implements ApiRequestParams.EnumParam
            {
                HOTEL("hotel"),
                VACATION_RENTAL("vacation_rental");

                private final String value;

                private Category(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Delivery {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="mode")
                Mode mode;
                @SerializedName(value="recipient")
                Recipient recipient;

                private Delivery(Map<String, Object> extraParams, Mode mode, Recipient recipient) {
                    this.extraParams = extraParams;
                    this.mode = mode;
                    this.recipient = recipient;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Mode getMode() {
                    return this.mode;
                }

                @Generated
                public Recipient getRecipient() {
                    return this.recipient;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Delivery)) {
                        return false;
                    }
                    Delivery other = (Delivery)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Mode this$mode = this.getMode();
                    Mode other$mode = other.getMode();
                    if (this$mode == null ? other$mode != null : !this$mode.equals(other$mode)) {
                        return false;
                    }
                    Recipient this$recipient = this.getRecipient();
                    Recipient other$recipient = other.getRecipient();
                    return !(this$recipient == null ? other$recipient != null : !((Object)this$recipient).equals(other$recipient));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Delivery;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Mode $mode = this.getMode();
                    result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                    Recipient $recipient = this.getRecipient();
                    result = result * 59 + ($recipient == null ? 43 : ((Object)$recipient).hashCode());
                    return result;
                }

                public static enum Mode implements ApiRequestParams.EnumParam
                {
                    EMAIL("email"),
                    PHONE("phone"),
                    PICKUP("pickup"),
                    POST("post");

                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Recipient {
                    @SerializedName(value="email")
                    String email;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="name")
                    String name;
                    @SerializedName(value="phone")
                    String phone;

                    private Recipient(String email, Map<String, Object> extraParams, String name, String phone) {
                        this.email = email;
                        this.extraParams = extraParams;
                        this.name = name;
                        this.phone = phone;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public String getEmail() {
                        return this.email;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getName() {
                        return this.name;
                    }

                    @Generated
                    public String getPhone() {
                        return this.phone;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Recipient)) {
                            return false;
                        }
                        Recipient other = (Recipient)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$email = this.getEmail();
                        String other$email = other.getEmail();
                        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$name = this.getName();
                        String other$name = other.getName();
                        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                            return false;
                        }
                        String this$phone = this.getPhone();
                        String other$phone = other.getPhone();
                        return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Recipient;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $email = this.getEmail();
                        result = result * 59 + ($email == null ? 43 : $email.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $name = this.getName();
                        result = result * 59 + ($name == null ? 43 : $name.hashCode());
                        String $phone = this.getPhone();
                        result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                        return result;
                    }

                    public static class Builder {
                        private String email;
                        private Map<String, Object> extraParams;
                        private String name;
                        private String phone;

                        public Recipient build() {
                            return new Recipient(this.email, this.extraParams, this.name, this.phone);
                        }

                        public Builder setEmail(String email) {
                            this.email = email;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setName(String name) {
                            this.name = name;
                            return this;
                        }

                        public Builder setPhone(String phone) {
                            this.phone = phone;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Mode mode;
                    private Recipient recipient;

                    public Delivery build() {
                        return new Delivery(this.extraParams, this.mode, this.recipient);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMode(Mode mode) {
                        this.mode = mode;
                        return this;
                    }

                    public Builder setRecipient(Recipient recipient) {
                        this.recipient = recipient;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Address address;
                private Long adults;
                private Affiliate affiliate;
                private String bookingNumber;
                private Category category;
                private Long checkinAt;
                private Long checkoutAt;
                private String customerServicePhoneNumber;
                private Long dailyRoomRateAmount;
                private Delivery delivery;
                private List<ExtraCharge> extraCharges;
                private Map<String, Object> extraParams;
                private Boolean fireSafetyActCompliance;
                private String name;
                private Boolean noShow;
                private Long numberOfRooms;
                private List<Passenger> passengers;
                private String propertyPhoneNumber;
                private String roomClass;
                private Long roomNights;
                private Long totalRoomTaxAmount;
                private Long totalTaxAmount;

                public Lodging build() {
                    return new Lodging(this.address, this.adults, this.affiliate, this.bookingNumber, this.category, this.checkinAt, this.checkoutAt, this.customerServicePhoneNumber, this.dailyRoomRateAmount, this.delivery, this.extraCharges, this.extraParams, this.fireSafetyActCompliance, this.name, this.noShow, this.numberOfRooms, this.passengers, this.propertyPhoneNumber, this.roomClass, this.roomNights, this.totalRoomTaxAmount, this.totalTaxAmount);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAdults(Long adults) {
                    this.adults = adults;
                    return this;
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setBookingNumber(String bookingNumber) {
                    this.bookingNumber = bookingNumber;
                    return this;
                }

                public Builder setCategory(Category category) {
                    this.category = category;
                    return this;
                }

                public Builder setCheckinAt(Long checkinAt) {
                    this.checkinAt = checkinAt;
                    return this;
                }

                public Builder setCheckoutAt(Long checkoutAt) {
                    this.checkoutAt = checkoutAt;
                    return this;
                }

                public Builder setCustomerServicePhoneNumber(String customerServicePhoneNumber) {
                    this.customerServicePhoneNumber = customerServicePhoneNumber;
                    return this;
                }

                public Builder setDailyRoomRateAmount(Long dailyRoomRateAmount) {
                    this.dailyRoomRateAmount = dailyRoomRateAmount;
                    return this;
                }

                public Builder setDelivery(Delivery delivery) {
                    this.delivery = delivery;
                    return this;
                }

                public Builder addExtraCharge(ExtraCharge element) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.add(element);
                    return this;
                }

                public Builder addAllExtraCharge(List<ExtraCharge> elements) {
                    if (this.extraCharges == null) {
                        this.extraCharges = new ArrayList<ExtraCharge>();
                    }
                    this.extraCharges.addAll(elements);
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFireSafetyActCompliance(Boolean fireSafetyActCompliance) {
                    this.fireSafetyActCompliance = fireSafetyActCompliance;
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setNoShow(Boolean noShow) {
                    this.noShow = noShow;
                    return this;
                }

                public Builder setNumberOfRooms(Long numberOfRooms) {
                    this.numberOfRooms = numberOfRooms;
                    return this;
                }

                public Builder addPassenger(Passenger element) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.add(element);
                    return this;
                }

                public Builder addAllPassenger(List<Passenger> elements) {
                    if (this.passengers == null) {
                        this.passengers = new ArrayList<Passenger>();
                    }
                    this.passengers.addAll(elements);
                    return this;
                }

                public Builder setPropertyPhoneNumber(String propertyPhoneNumber) {
                    this.propertyPhoneNumber = propertyPhoneNumber;
                    return this;
                }

                public Builder setRoomClass(String roomClass) {
                    this.roomClass = roomClass;
                    return this;
                }

                public Builder setRoomNights(Long roomNights) {
                    this.roomNights = roomNights;
                    return this;
                }

                public Builder setTotalRoomTaxAmount(Long totalRoomTaxAmount) {
                    this.totalRoomTaxAmount = totalRoomTaxAmount;
                    return this;
                }

                public Builder setTotalTaxAmount(Long totalTaxAmount) {
                    this.totalTaxAmount = totalTaxAmount;
                    return this;
                }
            }

            public static enum ExtraCharge implements ApiRequestParams.EnumParam
            {
                GIFT_SHOP("gift_shop"),
                LAUNDRY("laundry"),
                MINI_BAR("mini_bar"),
                OTHER("other"),
                RESTAURANT("restaurant"),
                TELEPHONE("telephone");

                private final String value;

                private ExtraCharge(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Passenger {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Passenger(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Passenger)) {
                        return false;
                    }
                    Passenger other = (Passenger)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Passenger;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Passenger build() {
                        return new Passenger(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }
        }

        public static class Subscription {
            @SerializedName(value="affiliate")
            Affiliate affiliate;
            @SerializedName(value="auto_renewal")
            Boolean autoRenewal;
            @SerializedName(value="billing_interval")
            BillingInterval billingInterval;
            @SerializedName(value="ends_at")
            Long endsAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="starts_at")
            Long startsAt;

            private Subscription(Affiliate affiliate, Boolean autoRenewal, BillingInterval billingInterval, Long endsAt, Map<String, Object> extraParams, String name, Long startsAt) {
                this.affiliate = affiliate;
                this.autoRenewal = autoRenewal;
                this.billingInterval = billingInterval;
                this.endsAt = endsAt;
                this.extraParams = extraParams;
                this.name = name;
                this.startsAt = startsAt;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Affiliate getAffiliate() {
                return this.affiliate;
            }

            @Generated
            public Boolean getAutoRenewal() {
                return this.autoRenewal;
            }

            @Generated
            public BillingInterval getBillingInterval() {
                return this.billingInterval;
            }

            @Generated
            public Long getEndsAt() {
                return this.endsAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public Long getStartsAt() {
                return this.startsAt;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Subscription)) {
                    return false;
                }
                Subscription other = (Subscription)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$autoRenewal = this.getAutoRenewal();
                Boolean other$autoRenewal = other.getAutoRenewal();
                if (this$autoRenewal == null ? other$autoRenewal != null : !((Object)this$autoRenewal).equals(other$autoRenewal)) {
                    return false;
                }
                Long this$endsAt = this.getEndsAt();
                Long other$endsAt = other.getEndsAt();
                if (this$endsAt == null ? other$endsAt != null : !((Object)this$endsAt).equals(other$endsAt)) {
                    return false;
                }
                Long this$startsAt = this.getStartsAt();
                Long other$startsAt = other.getStartsAt();
                if (this$startsAt == null ? other$startsAt != null : !((Object)this$startsAt).equals(other$startsAt)) {
                    return false;
                }
                Affiliate this$affiliate = this.getAffiliate();
                Affiliate other$affiliate = other.getAffiliate();
                if (this$affiliate == null ? other$affiliate != null : !((Object)this$affiliate).equals(other$affiliate)) {
                    return false;
                }
                BillingInterval this$billingInterval = this.getBillingInterval();
                BillingInterval other$billingInterval = other.getBillingInterval();
                if (this$billingInterval == null ? other$billingInterval != null : !((Object)this$billingInterval).equals(other$billingInterval)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                return !(this$name == null ? other$name != null : !this$name.equals(other$name));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Subscription;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $autoRenewal = this.getAutoRenewal();
                result = result * 59 + ($autoRenewal == null ? 43 : ((Object)$autoRenewal).hashCode());
                Long $endsAt = this.getEndsAt();
                result = result * 59 + ($endsAt == null ? 43 : ((Object)$endsAt).hashCode());
                Long $startsAt = this.getStartsAt();
                result = result * 59 + ($startsAt == null ? 43 : ((Object)$startsAt).hashCode());
                Affiliate $affiliate = this.getAffiliate();
                result = result * 59 + ($affiliate == null ? 43 : ((Object)$affiliate).hashCode());
                BillingInterval $billingInterval = this.getBillingInterval();
                result = result * 59 + ($billingInterval == null ? 43 : ((Object)$billingInterval).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                return result;
            }

            public static class Affiliate {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;

                private Affiliate(Map<String, Object> extraParams, String name) {
                    this.extraParams = extraParams;
                    this.name = name;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Affiliate)) {
                        return false;
                    }
                    Affiliate other = (Affiliate)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    return !(this$name == null ? other$name != null : !this$name.equals(other$name));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Affiliate;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String name;

                    public Affiliate build() {
                        return new Affiliate(this.extraParams, this.name);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }
                }
            }

            public static class BillingInterval {
                @SerializedName(value="count")
                Long count;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;

                private BillingInterval(Long count, Map<String, Object> extraParams, Interval interval) {
                    this.count = count;
                    this.extraParams = extraParams;
                    this.interval = interval;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getCount() {
                    return this.count;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof BillingInterval)) {
                        return false;
                    }
                    BillingInterval other = (BillingInterval)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$count = this.getCount();
                    Long other$count = other.getCount();
                    if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Interval this$interval = this.getInterval();
                    Interval other$interval = other.getInterval();
                    return !(this$interval == null ? other$interval != null : !this$interval.equals(other$interval));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof BillingInterval;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $count = this.getCount();
                    result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Interval $interval = this.getInterval();
                    result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                    return result;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long count;
                    private Map<String, Object> extraParams;
                    private Interval interval;

                    public BillingInterval build() {
                        return new BillingInterval(this.count, this.extraParams, this.interval);
                    }

                    public Builder setCount(Long count) {
                        this.count = count;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Affiliate affiliate;
                private Boolean autoRenewal;
                private BillingInterval billingInterval;
                private Long endsAt;
                private Map<String, Object> extraParams;
                private String name;
                private Long startsAt;

                public Subscription build() {
                    return new Subscription(this.affiliate, this.autoRenewal, this.billingInterval, this.endsAt, this.extraParams, this.name, this.startsAt);
                }

                public Builder setAffiliate(Affiliate affiliate) {
                    this.affiliate = affiliate;
                    return this;
                }

                public Builder setAutoRenewal(Boolean autoRenewal) {
                    this.autoRenewal = autoRenewal;
                    return this;
                }

                public Builder setBillingInterval(BillingInterval billingInterval) {
                    this.billingInterval = billingInterval;
                    return this;
                }

                public Builder setEndsAt(Long endsAt) {
                    this.endsAt = endsAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setStartsAt(Long startsAt) {
                    this.startsAt = startsAt;
                    return this;
                }
            }
        }

        public static class Builder {
            private CarRental carRental;
            private Object customerReference;
            private EventDetails eventDetails;
            private Map<String, Object> extraParams;
            private Flight flight;
            private Lodging lodging;
            private Object orderReference;
            private Subscription subscription;

            public PaymentDetails build() {
                return new PaymentDetails(this.carRental, this.customerReference, this.eventDetails, this.extraParams, this.flight, this.lodging, this.orderReference, this.subscription);
            }

            public Builder setCarRental(CarRental carRental) {
                this.carRental = carRental;
                return this;
            }

            public Builder setCustomerReference(String customerReference) {
                this.customerReference = customerReference;
                return this;
            }

            public Builder setCustomerReference(EmptyParam customerReference) {
                this.customerReference = customerReference;
                return this;
            }

            public Builder setEventDetails(EventDetails eventDetails) {
                this.eventDetails = eventDetails;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFlight(Flight flight) {
                this.flight = flight;
                return this;
            }

            public Builder setLodging(Lodging lodging) {
                this.lodging = lodging;
                return this;
            }

            public Builder setOrderReference(String orderReference) {
                this.orderReference = orderReference;
                return this;
            }

            public Builder setOrderReference(EmptyParam orderReference) {
                this.orderReference = orderReference;
                return this;
            }

            public Builder setSubscription(Subscription subscription) {
                this.subscription = subscription;
                return this;
            }
        }
    }

    public static class PaymentMethodData {
        @SerializedName(value="acss_debit")
        AcssDebit acssDebit;
        @SerializedName(value="affirm")
        Affirm affirm;
        @SerializedName(value="afterpay_clearpay")
        AfterpayClearpay afterpayClearpay;
        @SerializedName(value="alipay")
        Alipay alipay;
        @SerializedName(value="allow_redisplay")
        AllowRedisplay allowRedisplay;
        @SerializedName(value="alma")
        Alma alma;
        @SerializedName(value="amazon_pay")
        AmazonPay amazonPay;
        @SerializedName(value="au_becs_debit")
        AuBecsDebit auBecsDebit;
        @SerializedName(value="bacs_debit")
        BacsDebit bacsDebit;
        @SerializedName(value="bancontact")
        Bancontact bancontact;
        @SerializedName(value="billie")
        Billie billie;
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="blik")
        Blik blik;
        @SerializedName(value="boleto")
        Boleto boleto;
        @SerializedName(value="cashapp")
        Cashapp cashapp;
        @SerializedName(value="crypto")
        Crypto crypto;
        @SerializedName(value="customer_balance")
        CustomerBalance customerBalance;
        @SerializedName(value="eps")
        Eps eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Fpx fpx;
        @SerializedName(value="giropay")
        Giropay giropay;
        @SerializedName(value="gopay")
        Gopay gopay;
        @SerializedName(value="grabpay")
        Grabpay grabpay;
        @SerializedName(value="id_bank_transfer")
        IdBankTransfer idBankTransfer;
        @SerializedName(value="ideal")
        Ideal ideal;
        @SerializedName(value="interac_present")
        InteracPresent interacPresent;
        @SerializedName(value="kakao_pay")
        KakaoPay kakaoPay;
        @SerializedName(value="klarna")
        Klarna klarna;
        @SerializedName(value="konbini")
        Konbini konbini;
        @SerializedName(value="kr_card")
        KrCard krCard;
        @SerializedName(value="link")
        Link link;
        @SerializedName(value="mb_way")
        MbWay mbWay;
        @SerializedName(value="metadata")
        Map<String, String> metadata;
        @SerializedName(value="mobilepay")
        Mobilepay mobilepay;
        @SerializedName(value="multibanco")
        Multibanco multibanco;
        @SerializedName(value="naver_pay")
        NaverPay naverPay;
        @SerializedName(value="nz_bank_account")
        NzBankAccount nzBankAccount;
        @SerializedName(value="oxxo")
        Oxxo oxxo;
        @SerializedName(value="p24")
        P24 p24;
        @SerializedName(value="pay_by_bank")
        PayByBank payByBank;
        @SerializedName(value="payco")
        Payco payco;
        @SerializedName(value="paynow")
        Paynow paynow;
        @SerializedName(value="paypal")
        Paypal paypal;
        @SerializedName(value="paypay")
        Paypay paypay;
        @SerializedName(value="payto")
        Payto payto;
        @SerializedName(value="pix")
        Pix pix;
        @SerializedName(value="promptpay")
        Promptpay promptpay;
        @SerializedName(value="qris")
        Qris qris;
        @SerializedName(value="radar_options")
        RadarOptions radarOptions;
        @SerializedName(value="rechnung")
        Rechnung rechnung;
        @SerializedName(value="revolut_pay")
        RevolutPay revolutPay;
        @SerializedName(value="samsung_pay")
        SamsungPay samsungPay;
        @SerializedName(value="satispay")
        Satispay satispay;
        @SerializedName(value="sepa_debit")
        SepaDebit sepaDebit;
        @SerializedName(value="shopeepay")
        Shopeepay shopeepay;
        @SerializedName(value="sofort")
        Sofort sofort;
        @SerializedName(value="stripe_balance")
        StripeBalance stripeBalance;
        @SerializedName(value="swish")
        Swish swish;
        @SerializedName(value="twint")
        Twint twint;
        @SerializedName(value="type")
        Type type;
        @SerializedName(value="us_bank_account")
        UsBankAccount usBankAccount;
        @SerializedName(value="wechat_pay")
        WechatPay wechatPay;
        @SerializedName(value="zip")
        Zip zip;

        private PaymentMethodData(AcssDebit acssDebit, Affirm affirm, AfterpayClearpay afterpayClearpay, Alipay alipay, AllowRedisplay allowRedisplay, Alma alma, AmazonPay amazonPay, AuBecsDebit auBecsDebit, BacsDebit bacsDebit, Bancontact bancontact, Billie billie, BillingDetails billingDetails, Blik blik, Boleto boleto, Cashapp cashapp, Crypto crypto, CustomerBalance customerBalance, Eps eps, Map<String, Object> extraParams, Fpx fpx, Giropay giropay, Gopay gopay, Grabpay grabpay, IdBankTransfer idBankTransfer, Ideal ideal, InteracPresent interacPresent, KakaoPay kakaoPay, Klarna klarna, Konbini konbini, KrCard krCard, Link link, MbWay mbWay, Map<String, String> metadata, Mobilepay mobilepay, Multibanco multibanco, NaverPay naverPay, NzBankAccount nzBankAccount, Oxxo oxxo, P24 p24, PayByBank payByBank, Payco payco, Paynow paynow, Paypal paypal, Paypay paypay, Payto payto, Pix pix, Promptpay promptpay, Qris qris, RadarOptions radarOptions, Rechnung rechnung, RevolutPay revolutPay, SamsungPay samsungPay, Satispay satispay, SepaDebit sepaDebit, Shopeepay shopeepay, Sofort sofort, StripeBalance stripeBalance, Swish swish, Twint twint, Type type, UsBankAccount usBankAccount, WechatPay wechatPay, Zip zip) {
            this.acssDebit = acssDebit;
            this.affirm = affirm;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.allowRedisplay = allowRedisplay;
            this.alma = alma;
            this.amazonPay = amazonPay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.billie = billie;
            this.billingDetails = billingDetails;
            this.blik = blik;
            this.boleto = boleto;
            this.cashapp = cashapp;
            this.crypto = crypto;
            this.customerBalance = customerBalance;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.gopay = gopay;
            this.grabpay = grabpay;
            this.idBankTransfer = idBankTransfer;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.kakaoPay = kakaoPay;
            this.klarna = klarna;
            this.konbini = konbini;
            this.krCard = krCard;
            this.link = link;
            this.mbWay = mbWay;
            this.metadata = metadata;
            this.mobilepay = mobilepay;
            this.multibanco = multibanco;
            this.naverPay = naverPay;
            this.nzBankAccount = nzBankAccount;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.payByBank = payByBank;
            this.payco = payco;
            this.paynow = paynow;
            this.paypal = paypal;
            this.paypay = paypay;
            this.payto = payto;
            this.pix = pix;
            this.promptpay = promptpay;
            this.qris = qris;
            this.radarOptions = radarOptions;
            this.rechnung = rechnung;
            this.revolutPay = revolutPay;
            this.samsungPay = samsungPay;
            this.satispay = satispay;
            this.sepaDebit = sepaDebit;
            this.shopeepay = shopeepay;
            this.sofort = sofort;
            this.stripeBalance = stripeBalance;
            this.swish = swish;
            this.twint = twint;
            this.type = type;
            this.usBankAccount = usBankAccount;
            this.wechatPay = wechatPay;
            this.zip = zip;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public AcssDebit getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Affirm getAffirm() {
            return this.affirm;
        }

        @Generated
        public AfterpayClearpay getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Alipay getAlipay() {
            return this.alipay;
        }

        @Generated
        public AllowRedisplay getAllowRedisplay() {
            return this.allowRedisplay;
        }

        @Generated
        public Alma getAlma() {
            return this.alma;
        }

        @Generated
        public AmazonPay getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public AuBecsDebit getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public BacsDebit getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Bancontact getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Billie getBillie() {
            return this.billie;
        }

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Blik getBlik() {
            return this.blik;
        }

        @Generated
        public Boleto getBoleto() {
            return this.boleto;
        }

        @Generated
        public Cashapp getCashapp() {
            return this.cashapp;
        }

        @Generated
        public Crypto getCrypto() {
            return this.crypto;
        }

        @Generated
        public CustomerBalance getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Eps getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Fpx getFpx() {
            return this.fpx;
        }

        @Generated
        public Giropay getGiropay() {
            return this.giropay;
        }

        @Generated
        public Gopay getGopay() {
            return this.gopay;
        }

        @Generated
        public Grabpay getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public IdBankTransfer getIdBankTransfer() {
            return this.idBankTransfer;
        }

        @Generated
        public Ideal getIdeal() {
            return this.ideal;
        }

        @Generated
        public InteracPresent getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public KakaoPay getKakaoPay() {
            return this.kakaoPay;
        }

        @Generated
        public Klarna getKlarna() {
            return this.klarna;
        }

        @Generated
        public Konbini getKonbini() {
            return this.konbini;
        }

        @Generated
        public KrCard getKrCard() {
            return this.krCard;
        }

        @Generated
        public Link getLink() {
            return this.link;
        }

        @Generated
        public MbWay getMbWay() {
            return this.mbWay;
        }

        @Generated
        public Map<String, String> getMetadata() {
            return this.metadata;
        }

        @Generated
        public Mobilepay getMobilepay() {
            return this.mobilepay;
        }

        @Generated
        public Multibanco getMultibanco() {
            return this.multibanco;
        }

        @Generated
        public NaverPay getNaverPay() {
            return this.naverPay;
        }

        @Generated
        public NzBankAccount getNzBankAccount() {
            return this.nzBankAccount;
        }

        @Generated
        public Oxxo getOxxo() {
            return this.oxxo;
        }

        @Generated
        public P24 getP24() {
            return this.p24;
        }

        @Generated
        public PayByBank getPayByBank() {
            return this.payByBank;
        }

        @Generated
        public Payco getPayco() {
            return this.payco;
        }

        @Generated
        public Paynow getPaynow() {
            return this.paynow;
        }

        @Generated
        public Paypal getPaypal() {
            return this.paypal;
        }

        @Generated
        public Paypay getPaypay() {
            return this.paypay;
        }

        @Generated
        public Payto getPayto() {
            return this.payto;
        }

        @Generated
        public Pix getPix() {
            return this.pix;
        }

        @Generated
        public Promptpay getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public Qris getQris() {
            return this.qris;
        }

        @Generated
        public RadarOptions getRadarOptions() {
            return this.radarOptions;
        }

        @Generated
        public Rechnung getRechnung() {
            return this.rechnung;
        }

        @Generated
        public RevolutPay getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public SamsungPay getSamsungPay() {
            return this.samsungPay;
        }

        @Generated
        public Satispay getSatispay() {
            return this.satispay;
        }

        @Generated
        public SepaDebit getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Shopeepay getShopeepay() {
            return this.shopeepay;
        }

        @Generated
        public Sofort getSofort() {
            return this.sofort;
        }

        @Generated
        public StripeBalance getStripeBalance() {
            return this.stripeBalance;
        }

        @Generated
        public Swish getSwish() {
            return this.swish;
        }

        @Generated
        public Twint getTwint() {
            return this.twint;
        }

        @Generated
        public Type getType() {
            return this.type;
        }

        @Generated
        public UsBankAccount getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public WechatPay getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Zip getZip() {
            return this.zip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodData)) {
                return false;
            }
            PaymentMethodData other = (PaymentMethodData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AcssDebit this$acssDebit = this.getAcssDebit();
            AcssDebit other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
                return false;
            }
            Affirm this$affirm = this.getAffirm();
            Affirm other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
                return false;
            }
            AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
            AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
                return false;
            }
            Alipay this$alipay = this.getAlipay();
            Alipay other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
                return false;
            }
            AllowRedisplay this$allowRedisplay = this.getAllowRedisplay();
            AllowRedisplay other$allowRedisplay = other.getAllowRedisplay();
            if (this$allowRedisplay == null ? other$allowRedisplay != null : !this$allowRedisplay.equals(other$allowRedisplay)) {
                return false;
            }
            Alma this$alma = this.getAlma();
            Alma other$alma = other.getAlma();
            if (this$alma == null ? other$alma != null : !((Object)this$alma).equals(other$alma)) {
                return false;
            }
            AmazonPay this$amazonPay = this.getAmazonPay();
            AmazonPay other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
                return false;
            }
            AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
            AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
                return false;
            }
            BacsDebit this$bacsDebit = this.getBacsDebit();
            BacsDebit other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
                return false;
            }
            Bancontact this$bancontact = this.getBancontact();
            Bancontact other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
                return false;
            }
            Billie this$billie = this.getBillie();
            Billie other$billie = other.getBillie();
            if (this$billie == null ? other$billie != null : !((Object)this$billie).equals(other$billie)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            Blik this$blik = this.getBlik();
            Blik other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
                return false;
            }
            Boleto this$boleto = this.getBoleto();
            Boleto other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
                return false;
            }
            Cashapp this$cashapp = this.getCashapp();
            Cashapp other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
                return false;
            }
            Crypto this$crypto = this.getCrypto();
            Crypto other$crypto = other.getCrypto();
            if (this$crypto == null ? other$crypto != null : !((Object)this$crypto).equals(other$crypto)) {
                return false;
            }
            CustomerBalance this$customerBalance = this.getCustomerBalance();
            CustomerBalance other$customerBalance = other.getCustomerBalance();
            if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
                return false;
            }
            Eps this$eps = this.getEps();
            Eps other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            Fpx this$fpx = this.getFpx();
            Fpx other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
                return false;
            }
            Giropay this$giropay = this.getGiropay();
            Giropay other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
                return false;
            }
            Gopay this$gopay = this.getGopay();
            Gopay other$gopay = other.getGopay();
            if (this$gopay == null ? other$gopay != null : !((Object)this$gopay).equals(other$gopay)) {
                return false;
            }
            Grabpay this$grabpay = this.getGrabpay();
            Grabpay other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
                return false;
            }
            IdBankTransfer this$idBankTransfer = this.getIdBankTransfer();
            IdBankTransfer other$idBankTransfer = other.getIdBankTransfer();
            if (this$idBankTransfer == null ? other$idBankTransfer != null : !((Object)this$idBankTransfer).equals(other$idBankTransfer)) {
                return false;
            }
            Ideal this$ideal = this.getIdeal();
            Ideal other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
                return false;
            }
            InteracPresent this$interacPresent = this.getInteracPresent();
            InteracPresent other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !((Object)this$interacPresent).equals(other$interacPresent)) {
                return false;
            }
            KakaoPay this$kakaoPay = this.getKakaoPay();
            KakaoPay other$kakaoPay = other.getKakaoPay();
            if (this$kakaoPay == null ? other$kakaoPay != null : !((Object)this$kakaoPay).equals(other$kakaoPay)) {
                return false;
            }
            Klarna this$klarna = this.getKlarna();
            Klarna other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
                return false;
            }
            Konbini this$konbini = this.getKonbini();
            Konbini other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
                return false;
            }
            KrCard this$krCard = this.getKrCard();
            KrCard other$krCard = other.getKrCard();
            if (this$krCard == null ? other$krCard != null : !((Object)this$krCard).equals(other$krCard)) {
                return false;
            }
            Link this$link = this.getLink();
            Link other$link = other.getLink();
            if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
                return false;
            }
            MbWay this$mbWay = this.getMbWay();
            MbWay other$mbWay = other.getMbWay();
            if (this$mbWay == null ? other$mbWay != null : !((Object)this$mbWay).equals(other$mbWay)) {
                return false;
            }
            Map<String, String> this$metadata = this.getMetadata();
            Map<String, String> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            Mobilepay this$mobilepay = this.getMobilepay();
            Mobilepay other$mobilepay = other.getMobilepay();
            if (this$mobilepay == null ? other$mobilepay != null : !((Object)this$mobilepay).equals(other$mobilepay)) {
                return false;
            }
            Multibanco this$multibanco = this.getMultibanco();
            Multibanco other$multibanco = other.getMultibanco();
            if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
                return false;
            }
            NaverPay this$naverPay = this.getNaverPay();
            NaverPay other$naverPay = other.getNaverPay();
            if (this$naverPay == null ? other$naverPay != null : !((Object)this$naverPay).equals(other$naverPay)) {
                return false;
            }
            NzBankAccount this$nzBankAccount = this.getNzBankAccount();
            NzBankAccount other$nzBankAccount = other.getNzBankAccount();
            if (this$nzBankAccount == null ? other$nzBankAccount != null : !((Object)this$nzBankAccount).equals(other$nzBankAccount)) {
                return false;
            }
            Oxxo this$oxxo = this.getOxxo();
            Oxxo other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
                return false;
            }
            P24 this$p24 = this.getP24();
            P24 other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
                return false;
            }
            PayByBank this$payByBank = this.getPayByBank();
            PayByBank other$payByBank = other.getPayByBank();
            if (this$payByBank == null ? other$payByBank != null : !((Object)this$payByBank).equals(other$payByBank)) {
                return false;
            }
            Payco this$payco = this.getPayco();
            Payco other$payco = other.getPayco();
            if (this$payco == null ? other$payco != null : !((Object)this$payco).equals(other$payco)) {
                return false;
            }
            Paynow this$paynow = this.getPaynow();
            Paynow other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
                return false;
            }
            Paypal this$paypal = this.getPaypal();
            Paypal other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
                return false;
            }
            Paypay this$paypay = this.getPaypay();
            Paypay other$paypay = other.getPaypay();
            if (this$paypay == null ? other$paypay != null : !((Object)this$paypay).equals(other$paypay)) {
                return false;
            }
            Payto this$payto = this.getPayto();
            Payto other$payto = other.getPayto();
            if (this$payto == null ? other$payto != null : !((Object)this$payto).equals(other$payto)) {
                return false;
            }
            Pix this$pix = this.getPix();
            Pix other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
                return false;
            }
            Promptpay this$promptpay = this.getPromptpay();
            Promptpay other$promptpay = other.getPromptpay();
            if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
                return false;
            }
            Qris this$qris = this.getQris();
            Qris other$qris = other.getQris();
            if (this$qris == null ? other$qris != null : !((Object)this$qris).equals(other$qris)) {
                return false;
            }
            RadarOptions this$radarOptions = this.getRadarOptions();
            RadarOptions other$radarOptions = other.getRadarOptions();
            if (this$radarOptions == null ? other$radarOptions != null : !((Object)this$radarOptions).equals(other$radarOptions)) {
                return false;
            }
            Rechnung this$rechnung = this.getRechnung();
            Rechnung other$rechnung = other.getRechnung();
            if (this$rechnung == null ? other$rechnung != null : !((Object)this$rechnung).equals(other$rechnung)) {
                return false;
            }
            RevolutPay this$revolutPay = this.getRevolutPay();
            RevolutPay other$revolutPay = other.getRevolutPay();
            if (this$revolutPay == null ? other$revolutPay != null : !((Object)this$revolutPay).equals(other$revolutPay)) {
                return false;
            }
            SamsungPay this$samsungPay = this.getSamsungPay();
            SamsungPay other$samsungPay = other.getSamsungPay();
            if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
                return false;
            }
            Satispay this$satispay = this.getSatispay();
            Satispay other$satispay = other.getSatispay();
            if (this$satispay == null ? other$satispay != null : !((Object)this$satispay).equals(other$satispay)) {
                return false;
            }
            SepaDebit this$sepaDebit = this.getSepaDebit();
            SepaDebit other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
                return false;
            }
            Shopeepay this$shopeepay = this.getShopeepay();
            Shopeepay other$shopeepay = other.getShopeepay();
            if (this$shopeepay == null ? other$shopeepay != null : !((Object)this$shopeepay).equals(other$shopeepay)) {
                return false;
            }
            Sofort this$sofort = this.getSofort();
            Sofort other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
                return false;
            }
            StripeBalance this$stripeBalance = this.getStripeBalance();
            StripeBalance other$stripeBalance = other.getStripeBalance();
            if (this$stripeBalance == null ? other$stripeBalance != null : !((Object)this$stripeBalance).equals(other$stripeBalance)) {
                return false;
            }
            Swish this$swish = this.getSwish();
            Swish other$swish = other.getSwish();
            if (this$swish == null ? other$swish != null : !((Object)this$swish).equals(other$swish)) {
                return false;
            }
            Twint this$twint = this.getTwint();
            Twint other$twint = other.getTwint();
            if (this$twint == null ? other$twint != null : !((Object)this$twint).equals(other$twint)) {
                return false;
            }
            Type this$type = this.getType();
            Type other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            UsBankAccount this$usBankAccount = this.getUsBankAccount();
            UsBankAccount other$usBankAccount = other.getUsBankAccount();
            if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
                return false;
            }
            WechatPay this$wechatPay = this.getWechatPay();
            WechatPay other$wechatPay = other.getWechatPay();
            if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
                return false;
            }
            Zip this$zip = this.getZip();
            Zip other$zip = other.getZip();
            return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AcssDebit $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
            Affirm $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
            AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
            Alipay $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
            AllowRedisplay $allowRedisplay = this.getAllowRedisplay();
            result = result * 59 + ($allowRedisplay == null ? 43 : $allowRedisplay.hashCode());
            Alma $alma = this.getAlma();
            result = result * 59 + ($alma == null ? 43 : ((Object)$alma).hashCode());
            AmazonPay $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
            AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
            BacsDebit $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
            Bancontact $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
            Billie $billie = this.getBillie();
            result = result * 59 + ($billie == null ? 43 : ((Object)$billie).hashCode());
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            Blik $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
            Boleto $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
            Cashapp $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
            Crypto $crypto = this.getCrypto();
            result = result * 59 + ($crypto == null ? 43 : ((Object)$crypto).hashCode());
            CustomerBalance $customerBalance = this.getCustomerBalance();
            result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
            Eps $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            Fpx $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
            Giropay $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
            Gopay $gopay = this.getGopay();
            result = result * 59 + ($gopay == null ? 43 : ((Object)$gopay).hashCode());
            Grabpay $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
            IdBankTransfer $idBankTransfer = this.getIdBankTransfer();
            result = result * 59 + ($idBankTransfer == null ? 43 : ((Object)$idBankTransfer).hashCode());
            Ideal $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
            InteracPresent $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : ((Object)$interacPresent).hashCode());
            KakaoPay $kakaoPay = this.getKakaoPay();
            result = result * 59 + ($kakaoPay == null ? 43 : ((Object)$kakaoPay).hashCode());
            Klarna $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
            Konbini $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
            KrCard $krCard = this.getKrCard();
            result = result * 59 + ($krCard == null ? 43 : ((Object)$krCard).hashCode());
            Link $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
            MbWay $mbWay = this.getMbWay();
            result = result * 59 + ($mbWay == null ? 43 : ((Object)$mbWay).hashCode());
            Map<String, String> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            Mobilepay $mobilepay = this.getMobilepay();
            result = result * 59 + ($mobilepay == null ? 43 : ((Object)$mobilepay).hashCode());
            Multibanco $multibanco = this.getMultibanco();
            result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
            NaverPay $naverPay = this.getNaverPay();
            result = result * 59 + ($naverPay == null ? 43 : ((Object)$naverPay).hashCode());
            NzBankAccount $nzBankAccount = this.getNzBankAccount();
            result = result * 59 + ($nzBankAccount == null ? 43 : ((Object)$nzBankAccount).hashCode());
            Oxxo $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
            P24 $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
            PayByBank $payByBank = this.getPayByBank();
            result = result * 59 + ($payByBank == null ? 43 : ((Object)$payByBank).hashCode());
            Payco $payco = this.getPayco();
            result = result * 59 + ($payco == null ? 43 : ((Object)$payco).hashCode());
            Paynow $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
            Paypal $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
            Paypay $paypay = this.getPaypay();
            result = result * 59 + ($paypay == null ? 43 : ((Object)$paypay).hashCode());
            Payto $payto = this.getPayto();
            result = result * 59 + ($payto == null ? 43 : ((Object)$payto).hashCode());
            Pix $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
            Promptpay $promptpay = this.getPromptpay();
            result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
            Qris $qris = this.getQris();
            result = result * 59 + ($qris == null ? 43 : ((Object)$qris).hashCode());
            RadarOptions $radarOptions = this.getRadarOptions();
            result = result * 59 + ($radarOptions == null ? 43 : ((Object)$radarOptions).hashCode());
            Rechnung $rechnung = this.getRechnung();
            result = result * 59 + ($rechnung == null ? 43 : ((Object)$rechnung).hashCode());
            RevolutPay $revolutPay = this.getRevolutPay();
            result = result * 59 + ($revolutPay == null ? 43 : ((Object)$revolutPay).hashCode());
            SamsungPay $samsungPay = this.getSamsungPay();
            result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
            Satispay $satispay = this.getSatispay();
            result = result * 59 + ($satispay == null ? 43 : ((Object)$satispay).hashCode());
            SepaDebit $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
            Shopeepay $shopeepay = this.getShopeepay();
            result = result * 59 + ($shopeepay == null ? 43 : ((Object)$shopeepay).hashCode());
            Sofort $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
            StripeBalance $stripeBalance = this.getStripeBalance();
            result = result * 59 + ($stripeBalance == null ? 43 : ((Object)$stripeBalance).hashCode());
            Swish $swish = this.getSwish();
            result = result * 59 + ($swish == null ? 43 : ((Object)$swish).hashCode());
            Twint $twint = this.getTwint();
            result = result * 59 + ($twint == null ? 43 : ((Object)$twint).hashCode());
            Type $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            UsBankAccount $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
            WechatPay $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
            Zip $zip = this.getZip();
            result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
            return result;
        }

        public static class AcssDebit {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="institution_number")
            String institutionNumber;
            @SerializedName(value="transit_number")
            String transitNumber;

            private AcssDebit(String accountNumber, Map<String, Object> extraParams, String institutionNumber, String transitNumber) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.institutionNumber = institutionNumber;
                this.transitNumber = transitNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getInstitutionNumber() {
                return this.institutionNumber;
            }

            @Generated
            public String getTransitNumber() {
                return this.transitNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AcssDebit)) {
                    return false;
                }
                AcssDebit other = (AcssDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$institutionNumber = this.getInstitutionNumber();
                String other$institutionNumber = other.getInstitutionNumber();
                if (this$institutionNumber == null ? other$institutionNumber != null : !this$institutionNumber.equals(other$institutionNumber)) {
                    return false;
                }
                String this$transitNumber = this.getTransitNumber();
                String other$transitNumber = other.getTransitNumber();
                return !(this$transitNumber == null ? other$transitNumber != null : !this$transitNumber.equals(other$transitNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AcssDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $institutionNumber = this.getInstitutionNumber();
                result = result * 59 + ($institutionNumber == null ? 43 : $institutionNumber.hashCode());
                String $transitNumber = this.getTransitNumber();
                result = result * 59 + ($transitNumber == null ? 43 : $transitNumber.hashCode());
                return result;
            }

            public static class Builder {
                private String accountNumber;
                private Map<String, Object> extraParams;
                private String institutionNumber;
                private String transitNumber;

                public AcssDebit build() {
                    return new AcssDebit(this.accountNumber, this.extraParams, this.institutionNumber, this.transitNumber);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setInstitutionNumber(String institutionNumber) {
                    this.institutionNumber = institutionNumber;
                    return this;
                }

                public Builder setTransitNumber(String transitNumber) {
                    this.transitNumber = transitNumber;
                    return this;
                }
            }
        }

        public static class Affirm {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Affirm(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Affirm)) {
                    return false;
                }
                Affirm other = (Affirm)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Affirm;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Affirm build() {
                    return new Affirm(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AfterpayClearpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AfterpayClearpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AfterpayClearpay)) {
                    return false;
                }
                AfterpayClearpay other = (AfterpayClearpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AfterpayClearpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public AfterpayClearpay build() {
                    return new AfterpayClearpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Alipay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alipay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alipay)) {
                    return false;
                }
                Alipay other = (Alipay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alipay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alipay build() {
                    return new Alipay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum AllowRedisplay implements ApiRequestParams.EnumParam
        {
            ALWAYS("always"),
            LIMITED("limited"),
            UNSPECIFIED("unspecified");

            private final String value;

            private AllowRedisplay(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Alma {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Alma(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Alma)) {
                    return false;
                }
                Alma other = (Alma)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Alma;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Alma build() {
                    return new Alma(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AmazonPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AmazonPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AmazonPay)) {
                    return false;
                }
                AmazonPay other = (AmazonPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AmazonPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public AmazonPay build() {
                    return new AmazonPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class AuBecsDebit {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private AuBecsDebit(String accountNumber, String bsbNumber, Map<String, Object> extraParams) {
                this.accountNumber = accountNumber;
                this.bsbNumber = bsbNumber;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AuBecsDebit)) {
                    return false;
                }
                AuBecsDebit other = (AuBecsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$bsbNumber = this.getBsbNumber();
                String other$bsbNumber = other.getBsbNumber();
                if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof AuBecsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $bsbNumber = this.getBsbNumber();
                result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private String accountNumber;
                private String bsbNumber;
                private Map<String, Object> extraParams;

                public AuBecsDebit build() {
                    return new AuBecsDebit(this.accountNumber, this.bsbNumber, this.extraParams);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setBsbNumber(String bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BacsDebit {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="sort_code")
            String sortCode;

            private BacsDebit(String accountNumber, Map<String, Object> extraParams, String sortCode) {
                this.accountNumber = accountNumber;
                this.extraParams = extraParams;
                this.sortCode = sortCode;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getSortCode() {
                return this.sortCode;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BacsDebit)) {
                    return false;
                }
                BacsDebit other = (BacsDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$sortCode = this.getSortCode();
                String other$sortCode = other.getSortCode();
                return !(this$sortCode == null ? other$sortCode != null : !this$sortCode.equals(other$sortCode));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BacsDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $sortCode = this.getSortCode();
                result = result * 59 + ($sortCode == null ? 43 : $sortCode.hashCode());
                return result;
            }

            public static class Builder {
                private String accountNumber;
                private Map<String, Object> extraParams;
                private String sortCode;

                public BacsDebit build() {
                    return new BacsDebit(this.accountNumber, this.extraParams, this.sortCode);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSortCode(String sortCode) {
                    this.sortCode = sortCode;
                    return this;
                }
            }
        }

        public static class Bancontact {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Bancontact(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Bancontact)) {
                    return false;
                }
                Bancontact other = (Bancontact)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Bancontact;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Bancontact build() {
                    return new Bancontact(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Billie {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Billie(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Billie)) {
                    return false;
                }
                Billie other = (Billie)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Billie;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Billie build() {
                    return new Billie(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class BillingDetails {
            @SerializedName(value="address")
            Object address;
            @SerializedName(value="email")
            Object email;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="name")
            Object name;
            @SerializedName(value="phone")
            Object phone;
            @SerializedName(value="tax_id")
            String taxId;

            private BillingDetails(Object address, Object email, Map<String, Object> extraParams, Object name, Object phone, String taxId) {
                this.address = address;
                this.email = email;
                this.extraParams = extraParams;
                this.name = name;
                this.phone = phone;
                this.taxId = taxId;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getAddress() {
                return this.address;
            }

            @Generated
            public Object getEmail() {
                return this.email;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getName() {
                return this.name;
            }

            @Generated
            public Object getPhone() {
                return this.phone;
            }

            @Generated
            public String getTaxId() {
                return this.taxId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$address = this.getAddress();
                Object other$address = other.getAddress();
                if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                    return false;
                }
                Object this$email = this.getEmail();
                Object other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Object this$name = this.getName();
                Object other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                Object this$phone = this.getPhone();
                Object other$phone = other.getPhone();
                if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                    return false;
                }
                String this$taxId = this.getTaxId();
                String other$taxId = other.getTaxId();
                return !(this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : $address.hashCode());
                Object $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Object $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                Object $phone = this.getPhone();
                result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                String $taxId = this.getTaxId();
                result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
                return result;
            }

            public static class Builder {
                private Object address;
                private Object email;
                private Map<String, Object> extraParams;
                private Object name;
                private Object phone;
                private String taxId;

                public BillingDetails build() {
                    return new BillingDetails(this.address, this.email, this.extraParams, this.name, this.phone, this.taxId);
                }

                public Builder setAddress(Address address) {
                    this.address = address;
                    return this;
                }

                public Builder setAddress(EmptyParam address) {
                    this.address = address;
                    return this;
                }

                public Builder setEmail(String email) {
                    this.email = email;
                    return this;
                }

                public Builder setEmail(EmptyParam email) {
                    this.email = email;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setName(String name) {
                    this.name = name;
                    return this;
                }

                public Builder setName(EmptyParam name) {
                    this.name = name;
                    return this;
                }

                public Builder setPhone(String phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setPhone(EmptyParam phone) {
                    this.phone = phone;
                    return this;
                }

                public Builder setTaxId(String taxId) {
                    this.taxId = taxId;
                    return this;
                }
            }

            public static class Address {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                private Address(String city, String country, Map<String, Object> extraParams, String line1, String line2, String postalCode, String state) {
                    this.city = city;
                    this.country = country;
                    this.extraParams = extraParams;
                    this.line1 = line1;
                    this.line2 = line2;
                    this.postalCode = postalCode;
                    this.state = state;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Address)) {
                        return false;
                    }
                    Address other = (Address)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Address;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }

                public static class Builder {
                    private String city;
                    private String country;
                    private Map<String, Object> extraParams;
                    private String line1;
                    private String line2;
                    private String postalCode;
                    private String state;

                    public Address build() {
                        return new Address(this.city, this.country, this.extraParams, this.line1, this.line2, this.postalCode, this.state);
                    }

                    public Builder setCity(String city) {
                        this.city = city;
                        return this;
                    }

                    public Builder setCountry(String country) {
                        this.country = country;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setLine1(String line1) {
                        this.line1 = line1;
                        return this;
                    }

                    public Builder setLine2(String line2) {
                        this.line2 = line2;
                        return this;
                    }

                    public Builder setPostalCode(String postalCode) {
                        this.postalCode = postalCode;
                        return this;
                    }

                    public Builder setState(String state) {
                        this.state = state;
                        return this;
                    }
                }
            }
        }

        public static class Blik {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Blik(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Blik)) {
                    return false;
                }
                Blik other = (Blik)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Blik;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Blik build() {
                    return new Blik(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Boleto {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="tax_id")
            String taxId;

            private Boleto(Map<String, Object> extraParams, String taxId) {
                this.extraParams = extraParams;
                this.taxId = taxId;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getTaxId() {
                return this.taxId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Boleto)) {
                    return false;
                }
                Boleto other = (Boleto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$taxId = this.getTaxId();
                String other$taxId = other.getTaxId();
                return !(this$taxId == null ? other$taxId != null : !this$taxId.equals(other$taxId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Boleto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $taxId = this.getTaxId();
                result = result * 59 + ($taxId == null ? 43 : $taxId.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String taxId;

                public Boleto build() {
                    return new Boleto(this.extraParams, this.taxId);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setTaxId(String taxId) {
                    this.taxId = taxId;
                    return this;
                }
            }
        }

        public static class Cashapp {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Cashapp(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Cashapp)) {
                    return false;
                }
                Cashapp other = (Cashapp)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Cashapp;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Cashapp build() {
                    return new Cashapp(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Crypto {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Crypto(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Crypto)) {
                    return false;
                }
                Crypto other = (Crypto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Crypto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Crypto build() {
                    return new Crypto(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class CustomerBalance {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private CustomerBalance(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof CustomerBalance)) {
                    return false;
                }
                CustomerBalance other = (CustomerBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof CustomerBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public CustomerBalance build() {
                    return new CustomerBalance(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Eps {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Eps(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Eps)) {
                    return false;
                }
                Eps other = (Eps)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Bank this$bank = this.getBank();
                Bank other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Eps;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Bank $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ARZTE_UND_APOTHEKER_BANK("arzte_und_apotheker_bank"),
                AUSTRIAN_ANADI_BANK_AG("austrian_anadi_bank_ag"),
                BANK_AUSTRIA("bank_austria"),
                BANKHAUS_CARL_SPANGLER("bankhaus_carl_spangler"),
                BANKHAUS_SCHELHAMMER_UND_SCHATTERA_AG("bankhaus_schelhammer_und_schattera_ag"),
                BAWAG_PSK_AG("bawag_psk_ag"),
                BKS_BANK_AG("bks_bank_ag"),
                BRULL_KALLMUS_BANK_AG("brull_kallmus_bank_ag"),
                BTV_VIER_LANDER_BANK("btv_vier_lander_bank"),
                CAPITAL_BANK_GRAWE_GRUPPE_AG("capital_bank_grawe_gruppe_ag"),
                DEUTSCHE_BANK_AG("deutsche_bank_ag"),
                DOLOMITENBANK("dolomitenbank"),
                EASYBANK_AG("easybank_ag"),
                ERSTE_BANK_UND_SPARKASSEN("erste_bank_und_sparkassen"),
                HYPO_ALPEADRIABANK_INTERNATIONAL_AG("hypo_alpeadriabank_international_ag"),
                HYPO_BANK_BURGENLAND_AKTIENGESELLSCHAFT("hypo_bank_burgenland_aktiengesellschaft"),
                HYPO_NOE_LB_FUR_NIEDEROSTERREICH_U_WIEN("hypo_noe_lb_fur_niederosterreich_u_wien"),
                HYPO_OBEROSTERREICH_SALZBURG_STEIERMARK("hypo_oberosterreich_salzburg_steiermark"),
                HYPO_TIROL_BANK_AG("hypo_tirol_bank_ag"),
                HYPO_VORARLBERG_BANK_AG("hypo_vorarlberg_bank_ag"),
                MARCHFELDER_BANK("marchfelder_bank"),
                OBERBANK_AG("oberbank_ag"),
                RAIFFEISEN_BANKENGRUPPE_OSTERREICH("raiffeisen_bankengruppe_osterreich"),
                SCHOELLERBANK_AG("schoellerbank_ag"),
                SPARDA_BANK_WIEN("sparda_bank_wien"),
                VOLKSBANK_GRUPPE("volksbank_gruppe"),
                VOLKSKREDITBANK_AG("volkskreditbank_ag"),
                VR_BANK_BRAUNAU("vr_bank_braunau");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Eps build() {
                    return new Eps(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Fpx {
            @SerializedName(value="account_holder_type")
            AccountHolderType accountHolderType;
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Fpx(AccountHolderType accountHolderType, Bank bank, Map<String, Object> extraParams) {
                this.accountHolderType = accountHolderType;
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AccountHolderType getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Fpx)) {
                    return false;
                }
                Fpx other = (Fpx)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AccountHolderType this$accountHolderType = this.getAccountHolderType();
                AccountHolderType other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                Bank this$bank = this.getBank();
                Bank other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Fpx;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AccountHolderType $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                Bank $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static enum AccountHolderType implements ApiRequestParams.EnumParam
            {
                COMPANY("company"),
                INDIVIDUAL("individual");

                private final String value;

                private AccountHolderType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                AFFIN_BANK("affin_bank"),
                AGROBANK("agrobank"),
                ALLIANCE_BANK("alliance_bank"),
                AMBANK("ambank"),
                BANK_ISLAM("bank_islam"),
                BANK_MUAMALAT("bank_muamalat"),
                BANK_OF_CHINA("bank_of_china"),
                BANK_RAKYAT("bank_rakyat"),
                BSN("bsn"),
                CIMB("cimb"),
                DEUTSCHE_BANK("deutsche_bank"),
                HONG_LEONG_BANK("hong_leong_bank"),
                HSBC("hsbc"),
                KFH("kfh"),
                MAYBANK2E("maybank2e"),
                MAYBANK2U("maybank2u"),
                OCBC("ocbc"),
                PB_ENTERPRISE("pb_enterprise"),
                PUBLIC_BANK("public_bank"),
                RHB("rhb"),
                STANDARD_CHARTERED("standard_chartered"),
                UOB("uob");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AccountHolderType accountHolderType;
                private Bank bank;
                private Map<String, Object> extraParams;

                public Fpx build() {
                    return new Fpx(this.accountHolderType, this.bank, this.extraParams);
                }

                public Builder setAccountHolderType(AccountHolderType accountHolderType) {
                    this.accountHolderType = accountHolderType;
                    return this;
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Giropay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Giropay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Giropay build() {
                    return new Giropay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Gopay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Gopay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gopay)) {
                    return false;
                }
                Gopay other = (Gopay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gopay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Gopay build() {
                    return new Gopay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Grabpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Grabpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Grabpay build() {
                    return new Grabpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class IdBankTransfer {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private IdBankTransfer(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdBankTransfer)) {
                    return false;
                }
                IdBankTransfer other = (IdBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Bank this$bank = this.getBank();
                Bank other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IdBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Bank $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                BCA("bca"),
                BNI("bni"),
                BRI("bri"),
                CIMB("cimb"),
                PERMATA("permata");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public IdBankTransfer build() {
                    return new IdBankTransfer(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Ideal(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Bank this$bank = this.getBank();
                Bank other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Bank $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ABN_AMRO("abn_amro"),
                ASN_BANK("asn_bank"),
                BUNQ("bunq"),
                BUUT("buut"),
                HANDELSBANKEN("handelsbanken"),
                ING("ing"),
                KNAB("knab"),
                MONEYOU("moneyou"),
                N26("n26"),
                NN("nn"),
                RABOBANK("rabobank"),
                REGIOBANK("regiobank"),
                REVOLUT("revolut"),
                SNS_BANK("sns_bank"),
                TRIODOS_BANK("triodos_bank"),
                VAN_LANSCHOT("van_lanschot"),
                YOURSAFE("yoursafe");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public Ideal build() {
                    return new Ideal(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class KakaoPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private KakaoPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KakaoPay)) {
                    return false;
                }
                KakaoPay other = (KakaoPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KakaoPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public KakaoPay build() {
                    return new KakaoPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="dob")
            Dob dob;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Klarna(Dob dob, Map<String, Object> extraParams) {
                this.dob = dob;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Dob getDob() {
                return this.dob;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Dob this$dob = this.getDob();
                Dob other$dob = other.getDob();
                if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Dob $dob = this.getDob();
                result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Dob {
                @SerializedName(value="day")
                Long day;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="month")
                Long month;
                @SerializedName(value="year")
                Long year;

                private Dob(Long day, Map<String, Object> extraParams, Long month, Long year) {
                    this.day = day;
                    this.extraParams = extraParams;
                    this.month = month;
                    this.year = year;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getDay() {
                    return this.day;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getMonth() {
                    return this.month;
                }

                @Generated
                public Long getYear() {
                    return this.year;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Dob)) {
                        return false;
                    }
                    Dob other = (Dob)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$day = this.getDay();
                    Long other$day = other.getDay();
                    if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                        return false;
                    }
                    Long this$month = this.getMonth();
                    Long other$month = other.getMonth();
                    if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                        return false;
                    }
                    Long this$year = this.getYear();
                    Long other$year = other.getYear();
                    if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Dob;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $day = this.getDay();
                    result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                    Long $month = this.getMonth();
                    result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                    Long $year = this.getYear();
                    result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class Builder {
                    private Long day;
                    private Map<String, Object> extraParams;
                    private Long month;
                    private Long year;

                    public Dob build() {
                        return new Dob(this.day, this.extraParams, this.month, this.year);
                    }

                    public Builder setDay(Long day) {
                        this.day = day;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMonth(Long month) {
                        this.month = month;
                        return this;
                    }

                    public Builder setYear(Long year) {
                        this.year = year;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Dob dob;
                private Map<String, Object> extraParams;

                public Klarna build() {
                    return new Klarna(this.dob, this.extraParams);
                }

                public Builder setDob(Dob dob) {
                    this.dob = dob;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Konbini {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Konbini(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Konbini build() {
                    return new Konbini(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class KrCard {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private KrCard(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KrCard)) {
                    return false;
                }
                KrCard other = (KrCard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KrCard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public KrCard build() {
                    return new KrCard(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Link {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Link(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Link build() {
                    return new Link(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class MbWay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private MbWay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MbWay)) {
                    return false;
                }
                MbWay other = (MbWay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof MbWay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public MbWay build() {
                    return new MbWay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Mobilepay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Mobilepay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mobilepay)) {
                    return false;
                }
                Mobilepay other = (Mobilepay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mobilepay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Mobilepay build() {
                    return new Mobilepay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Multibanco {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Multibanco(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Multibanco)) {
                    return false;
                }
                Multibanco other = (Multibanco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Multibanco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Multibanco build() {
                    return new Multibanco(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class NaverPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="funding")
            Funding funding;

            private NaverPay(Map<String, Object> extraParams, Funding funding) {
                this.extraParams = extraParams;
                this.funding = funding;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Funding getFunding() {
                return this.funding;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NaverPay)) {
                    return false;
                }
                NaverPay other = (NaverPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Funding this$funding = this.getFunding();
                Funding other$funding = other.getFunding();
                return !(this$funding == null ? other$funding != null : !this$funding.equals(other$funding));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NaverPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Funding $funding = this.getFunding();
                result = result * 59 + ($funding == null ? 43 : $funding.hashCode());
                return result;
            }

            public static enum Funding implements ApiRequestParams.EnumParam
            {
                CARD("card"),
                POINTS("points");

                private final String value;

                private Funding(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Funding funding;

                public NaverPay build() {
                    return new NaverPay(this.extraParams, this.funding);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFunding(Funding funding) {
                    this.funding = funding;
                    return this;
                }
            }
        }

        public static class NzBankAccount {
            @SerializedName(value="account_holder_name")
            String accountHolderName;
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bank_code")
            String bankCode;
            @SerializedName(value="branch_code")
            String branchCode;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="suffix")
            String suffix;

            private NzBankAccount(String accountHolderName, String accountNumber, String bankCode, String branchCode, Map<String, Object> extraParams, String reference, String suffix) {
                this.accountHolderName = accountHolderName;
                this.accountNumber = accountNumber;
                this.bankCode = bankCode;
                this.branchCode = branchCode;
                this.extraParams = extraParams;
                this.reference = reference;
                this.suffix = suffix;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountHolderName() {
                return this.accountHolderName;
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBankCode() {
                return this.bankCode;
            }

            @Generated
            public String getBranchCode() {
                return this.branchCode;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getSuffix() {
                return this.suffix;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NzBankAccount)) {
                    return false;
                }
                NzBankAccount other = (NzBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountHolderName = this.getAccountHolderName();
                String other$accountHolderName = other.getAccountHolderName();
                if (this$accountHolderName == null ? other$accountHolderName != null : !this$accountHolderName.equals(other$accountHolderName)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$bankCode = this.getBankCode();
                String other$bankCode = other.getBankCode();
                if (this$bankCode == null ? other$bankCode != null : !this$bankCode.equals(other$bankCode)) {
                    return false;
                }
                String this$branchCode = this.getBranchCode();
                String other$branchCode = other.getBranchCode();
                if (this$branchCode == null ? other$branchCode != null : !this$branchCode.equals(other$branchCode)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$suffix = this.getSuffix();
                String other$suffix = other.getSuffix();
                return !(this$suffix == null ? other$suffix != null : !this$suffix.equals(other$suffix));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NzBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountHolderName = this.getAccountHolderName();
                result = result * 59 + ($accountHolderName == null ? 43 : $accountHolderName.hashCode());
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $bankCode = this.getBankCode();
                result = result * 59 + ($bankCode == null ? 43 : $bankCode.hashCode());
                String $branchCode = this.getBranchCode();
                result = result * 59 + ($branchCode == null ? 43 : $branchCode.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $suffix = this.getSuffix();
                result = result * 59 + ($suffix == null ? 43 : $suffix.hashCode());
                return result;
            }

            public static class Builder {
                private String accountHolderName;
                private String accountNumber;
                private String bankCode;
                private String branchCode;
                private Map<String, Object> extraParams;
                private String reference;
                private String suffix;

                public NzBankAccount build() {
                    return new NzBankAccount(this.accountHolderName, this.accountNumber, this.bankCode, this.branchCode, this.extraParams, this.reference, this.suffix);
                }

                public Builder setAccountHolderName(String accountHolderName) {
                    this.accountHolderName = accountHolderName;
                    return this;
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setBankCode(String bankCode) {
                    this.bankCode = bankCode;
                    return this;
                }

                public Builder setBranchCode(String branchCode) {
                    this.branchCode = branchCode;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setSuffix(String suffix) {
                    this.suffix = suffix;
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Oxxo(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Oxxo build() {
                    return new Oxxo(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="bank")
            Bank bank;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private P24(Bank bank, Map<String, Object> extraParams) {
                this.bank = bank;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Bank getBank() {
                return this.bank;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Bank this$bank = this.getBank();
                Bank other$bank = other.getBank();
                if (this$bank == null ? other$bank != null : !this$bank.equals(other$bank)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Bank $bank = this.getBank();
                result = result * 59 + ($bank == null ? 43 : $bank.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static enum Bank implements ApiRequestParams.EnumParam
            {
                ALIOR_BANK("alior_bank"),
                BANK_MILLENNIUM("bank_millennium"),
                BANK_NOWY_BFG_SA("bank_nowy_bfg_sa"),
                BANK_PEKAO_SA("bank_pekao_sa"),
                BANKI_SPBDZIELCZE("banki_spbdzielcze"),
                BLIK("blik"),
                BNP_PARIBAS("bnp_paribas"),
                BOZ("boz"),
                CITI_HANDLOWY("citi_handlowy"),
                CREDIT_AGRICOLE("credit_agricole"),
                ENVELOBANK("envelobank"),
                ETRANSFER_POCZTOWY24("etransfer_pocztowy24"),
                GETIN_BANK("getin_bank"),
                IDEABANK("ideabank"),
                ING("ing"),
                INTELIGO("inteligo"),
                MBANK_MTRANSFER("mbank_mtransfer"),
                NEST_PRZELEW("nest_przelew"),
                NOBLE_PAY("noble_pay"),
                PBAC_Z_IPKO("pbac_z_ipko"),
                PLUS_BANK("plus_bank"),
                SANTANDER_PRZELEW24("santander_przelew24"),
                TMOBILE_USBUGI_BANKOWE("tmobile_usbugi_bankowe"),
                TOYOTA_BANK("toyota_bank"),
                VELOBANK("velobank"),
                VOLKSWAGEN_BANK("volkswagen_bank");

                private final String value;

                private Bank(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Bank bank;
                private Map<String, Object> extraParams;

                public P24 build() {
                    return new P24(this.bank, this.extraParams);
                }

                public Builder setBank(Bank bank) {
                    this.bank = bank;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class PayByBank {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private PayByBank(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PayByBank)) {
                    return false;
                }
                PayByBank other = (PayByBank)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PayByBank;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public PayByBank build() {
                    return new PayByBank(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Payco {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Payco(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payco)) {
                    return false;
                }
                Payco other = (Payco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Payco build() {
                    return new Payco(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Paynow {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Paynow(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Paynow build() {
                    return new Paynow(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Paypal {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Paypal(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Paypal build() {
                    return new Paypal(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Paypay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Paypay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypay)) {
                    return false;
                }
                Paypay other = (Paypay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Paypay build() {
                    return new Paypay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Payto {
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="bsb_number")
            String bsbNumber;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="pay_id")
            String payId;

            private Payto(String accountNumber, String bsbNumber, Map<String, Object> extraParams, String payId) {
                this.accountNumber = accountNumber;
                this.bsbNumber = bsbNumber;
                this.extraParams = extraParams;
                this.payId = payId;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public String getBsbNumber() {
                return this.bsbNumber;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getPayId() {
                return this.payId;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payto)) {
                    return false;
                }
                Payto other = (Payto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                String this$bsbNumber = this.getBsbNumber();
                String other$bsbNumber = other.getBsbNumber();
                if (this$bsbNumber == null ? other$bsbNumber != null : !this$bsbNumber.equals(other$bsbNumber)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$payId = this.getPayId();
                String other$payId = other.getPayId();
                return !(this$payId == null ? other$payId != null : !this$payId.equals(other$payId));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                String $bsbNumber = this.getBsbNumber();
                result = result * 59 + ($bsbNumber == null ? 43 : $bsbNumber.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $payId = this.getPayId();
                result = result * 59 + ($payId == null ? 43 : $payId.hashCode());
                return result;
            }

            public static class Builder {
                private String accountNumber;
                private String bsbNumber;
                private Map<String, Object> extraParams;
                private String payId;

                public Payto build() {
                    return new Payto(this.accountNumber, this.bsbNumber, this.extraParams, this.payId);
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setBsbNumber(String bsbNumber) {
                    this.bsbNumber = bsbNumber;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPayId(String payId) {
                    this.payId = payId;
                    return this;
                }
            }
        }

        public static class Pix {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Pix(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Pix build() {
                    return new Pix(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Promptpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Promptpay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Promptpay)) {
                    return false;
                }
                Promptpay other = (Promptpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Promptpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Promptpay build() {
                    return new Promptpay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Qris {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Qris(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Qris)) {
                    return false;
                }
                Qris other = (Qris)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Qris;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Qris build() {
                    return new Qris(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class RadarOptions {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="session")
            String session;

            private RadarOptions(Map<String, Object> extraParams, String session) {
                this.extraParams = extraParams;
                this.session = session;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getSession() {
                return this.session;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RadarOptions)) {
                    return false;
                }
                RadarOptions other = (RadarOptions)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$session = this.getSession();
                String other$session = other.getSession();
                return !(this$session == null ? other$session != null : !this$session.equals(other$session));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RadarOptions;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $session = this.getSession();
                result = result * 59 + ($session == null ? 43 : $session.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String session;

                public RadarOptions build() {
                    return new RadarOptions(this.extraParams, this.session);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSession(String session) {
                    this.session = session;
                    return this;
                }
            }
        }

        public static class Rechnung {
            @SerializedName(value="dob")
            Dob dob;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Rechnung(Dob dob, Map<String, Object> extraParams) {
                this.dob = dob;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Dob getDob() {
                return this.dob;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Rechnung)) {
                    return false;
                }
                Rechnung other = (Rechnung)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Dob this$dob = this.getDob();
                Dob other$dob = other.getDob();
                if (this$dob == null ? other$dob != null : !((Object)this$dob).equals(other$dob)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Rechnung;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Dob $dob = this.getDob();
                result = result * 59 + ($dob == null ? 43 : ((Object)$dob).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Dob {
                @SerializedName(value="day")
                Long day;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="month")
                Long month;
                @SerializedName(value="year")
                Long year;

                private Dob(Long day, Map<String, Object> extraParams, Long month, Long year) {
                    this.day = day;
                    this.extraParams = extraParams;
                    this.month = month;
                    this.year = year;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getDay() {
                    return this.day;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getMonth() {
                    return this.month;
                }

                @Generated
                public Long getYear() {
                    return this.year;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Dob)) {
                        return false;
                    }
                    Dob other = (Dob)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$day = this.getDay();
                    Long other$day = other.getDay();
                    if (this$day == null ? other$day != null : !((Object)this$day).equals(other$day)) {
                        return false;
                    }
                    Long this$month = this.getMonth();
                    Long other$month = other.getMonth();
                    if (this$month == null ? other$month != null : !((Object)this$month).equals(other$month)) {
                        return false;
                    }
                    Long this$year = this.getYear();
                    Long other$year = other.getYear();
                    if (this$year == null ? other$year != null : !((Object)this$year).equals(other$year)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Dob;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $day = this.getDay();
                    result = result * 59 + ($day == null ? 43 : ((Object)$day).hashCode());
                    Long $month = this.getMonth();
                    result = result * 59 + ($month == null ? 43 : ((Object)$month).hashCode());
                    Long $year = this.getYear();
                    result = result * 59 + ($year == null ? 43 : ((Object)$year).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class Builder {
                    private Long day;
                    private Map<String, Object> extraParams;
                    private Long month;
                    private Long year;

                    public Dob build() {
                        return new Dob(this.day, this.extraParams, this.month, this.year);
                    }

                    public Builder setDay(Long day) {
                        this.day = day;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMonth(Long month) {
                        this.month = month;
                        return this;
                    }

                    public Builder setYear(Long year) {
                        this.year = year;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Dob dob;
                private Map<String, Object> extraParams;

                public Rechnung build() {
                    return new Rechnung(this.dob, this.extraParams);
                }

                public Builder setDob(Dob dob) {
                    this.dob = dob;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class RevolutPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private RevolutPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevolutPay)) {
                    return false;
                }
                RevolutPay other = (RevolutPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RevolutPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public RevolutPay build() {
                    return new RevolutPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class SamsungPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private SamsungPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SamsungPay)) {
                    return false;
                }
                SamsungPay other = (SamsungPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SamsungPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public SamsungPay build() {
                    return new SamsungPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Satispay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Satispay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Satispay)) {
                    return false;
                }
                Satispay other = (Satispay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Satispay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Satispay build() {
                    return new Satispay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="iban")
            String iban;

            private SepaDebit(Map<String, Object> extraParams, String iban) {
                this.extraParams = extraParams;
                this.iban = iban;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getIban() {
                return this.iban;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$iban = this.getIban();
                String other$iban = other.getIban();
                return !(this$iban == null ? other$iban != null : !this$iban.equals(other$iban));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $iban = this.getIban();
                result = result * 59 + ($iban == null ? 43 : $iban.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private String iban;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.iban);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setIban(String iban) {
                    this.iban = iban;
                    return this;
                }
            }
        }

        public static class Shopeepay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Shopeepay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Shopeepay)) {
                    return false;
                }
                Shopeepay other = (Shopeepay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Shopeepay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Shopeepay build() {
                    return new Shopeepay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="country")
            Country country;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Sofort(Country country, Map<String, Object> extraParams) {
                this.country = country;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Country getCountry() {
                return this.country;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Country this$country = this.getCountry();
                Country other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Country $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static enum Country implements ApiRequestParams.EnumParam
            {
                AT("AT"),
                BE("BE"),
                DE("DE"),
                ES("ES"),
                IT("IT"),
                NL("NL");

                private final String value;

                private Country(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Country country;
                private Map<String, Object> extraParams;

                public Sofort build() {
                    return new Sofort(this.country, this.extraParams);
                }

                public Builder setCountry(Country country) {
                    this.country = country;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class StripeBalance {
            @SerializedName(value="account")
            String account;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="source_type")
            SourceType sourceType;

            private StripeBalance(String account, Map<String, Object> extraParams, SourceType sourceType) {
                this.account = account;
                this.extraParams = extraParams;
                this.sourceType = sourceType;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAccount() {
                return this.account;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SourceType getSourceType() {
                return this.sourceType;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StripeBalance)) {
                    return false;
                }
                StripeBalance other = (StripeBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$account = this.getAccount();
                String other$account = other.getAccount();
                if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SourceType this$sourceType = this.getSourceType();
                SourceType other$sourceType = other.getSourceType();
                return !(this$sourceType == null ? other$sourceType != null : !this$sourceType.equals(other$sourceType));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StripeBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $account = this.getAccount();
                result = result * 59 + ($account == null ? 43 : $account.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SourceType $sourceType = this.getSourceType();
                result = result * 59 + ($sourceType == null ? 43 : $sourceType.hashCode());
                return result;
            }

            public static enum SourceType implements ApiRequestParams.EnumParam
            {
                BANK_ACCOUNT("bank_account"),
                CARD("card"),
                FPX("fpx");

                private final String value;

                private SourceType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String account;
                private Map<String, Object> extraParams;
                private SourceType sourceType;

                public StripeBalance build() {
                    return new StripeBalance(this.account, this.extraParams, this.sourceType);
                }

                public Builder setAccount(String account) {
                    this.account = account;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSourceType(SourceType sourceType) {
                    this.sourceType = sourceType;
                    return this;
                }
            }
        }

        public static class Swish {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Swish(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Swish)) {
                    return false;
                }
                Swish other = (Swish)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Swish;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Swish build() {
                    return new Swish(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Twint {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Twint(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Twint)) {
                    return false;
                }
                Twint other = (Twint)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Twint;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Twint build() {
                    return new Twint(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static enum Type implements ApiRequestParams.EnumParam
        {
            ACSS_DEBIT("acss_debit"),
            AFFIRM("affirm"),
            AFTERPAY_CLEARPAY("afterpay_clearpay"),
            ALIPAY("alipay"),
            ALMA("alma"),
            AMAZON_PAY("amazon_pay"),
            AU_BECS_DEBIT("au_becs_debit"),
            BACS_DEBIT("bacs_debit"),
            BANCONTACT("bancontact"),
            BILLIE("billie"),
            BLIK("blik"),
            BOLETO("boleto"),
            CASHAPP("cashapp"),
            CRYPTO("crypto"),
            CUSTOMER_BALANCE("customer_balance"),
            EPS("eps"),
            FPX("fpx"),
            GIROPAY("giropay"),
            GOPAY("gopay"),
            GRABPAY("grabpay"),
            ID_BANK_TRANSFER("id_bank_transfer"),
            IDEAL("ideal"),
            KAKAO_PAY("kakao_pay"),
            KLARNA("klarna"),
            KONBINI("konbini"),
            KR_CARD("kr_card"),
            LINK("link"),
            MB_WAY("mb_way"),
            MOBILEPAY("mobilepay"),
            MULTIBANCO("multibanco"),
            NAVER_PAY("naver_pay"),
            NZ_BANK_ACCOUNT("nz_bank_account"),
            OXXO("oxxo"),
            P24("p24"),
            PAY_BY_BANK("pay_by_bank"),
            PAYCO("payco"),
            PAYNOW("paynow"),
            PAYPAL("paypal"),
            PAYPAY("paypay"),
            PAYTO("payto"),
            PIX("pix"),
            PROMPTPAY("promptpay"),
            QRIS("qris"),
            RECHNUNG("rechnung"),
            REVOLUT_PAY("revolut_pay"),
            SAMSUNG_PAY("samsung_pay"),
            SATISPAY("satispay"),
            SEPA_DEBIT("sepa_debit"),
            SHOPEEPAY("shopeepay"),
            SOFORT("sofort"),
            STRIPE_BALANCE("stripe_balance"),
            SWISH("swish"),
            TWINT("twint"),
            US_BANK_ACCOUNT("us_bank_account"),
            WECHAT_PAY("wechat_pay"),
            ZIP("zip");

            private final String value;

            private Type(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class UsBankAccount {
            @SerializedName(value="account_holder_type")
            AccountHolderType accountHolderType;
            @SerializedName(value="account_number")
            String accountNumber;
            @SerializedName(value="account_type")
            AccountType accountType;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="financial_connections_account")
            String financialConnectionsAccount;
            @SerializedName(value="routing_number")
            String routingNumber;

            private UsBankAccount(AccountHolderType accountHolderType, String accountNumber, AccountType accountType, Map<String, Object> extraParams, String financialConnectionsAccount, String routingNumber) {
                this.accountHolderType = accountHolderType;
                this.accountNumber = accountNumber;
                this.accountType = accountType;
                this.extraParams = extraParams;
                this.financialConnectionsAccount = financialConnectionsAccount;
                this.routingNumber = routingNumber;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AccountHolderType getAccountHolderType() {
                return this.accountHolderType;
            }

            @Generated
            public String getAccountNumber() {
                return this.accountNumber;
            }

            @Generated
            public AccountType getAccountType() {
                return this.accountType;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public String getFinancialConnectionsAccount() {
                return this.financialConnectionsAccount;
            }

            @Generated
            public String getRoutingNumber() {
                return this.routingNumber;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                AccountHolderType this$accountHolderType = this.getAccountHolderType();
                AccountHolderType other$accountHolderType = other.getAccountHolderType();
                if (this$accountHolderType == null ? other$accountHolderType != null : !this$accountHolderType.equals(other$accountHolderType)) {
                    return false;
                }
                String this$accountNumber = this.getAccountNumber();
                String other$accountNumber = other.getAccountNumber();
                if (this$accountNumber == null ? other$accountNumber != null : !this$accountNumber.equals(other$accountNumber)) {
                    return false;
                }
                AccountType this$accountType = this.getAccountType();
                AccountType other$accountType = other.getAccountType();
                if (this$accountType == null ? other$accountType != null : !this$accountType.equals(other$accountType)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$financialConnectionsAccount = this.getFinancialConnectionsAccount();
                String other$financialConnectionsAccount = other.getFinancialConnectionsAccount();
                if (this$financialConnectionsAccount == null ? other$financialConnectionsAccount != null : !this$financialConnectionsAccount.equals(other$financialConnectionsAccount)) {
                    return false;
                }
                String this$routingNumber = this.getRoutingNumber();
                String other$routingNumber = other.getRoutingNumber();
                return !(this$routingNumber == null ? other$routingNumber != null : !this$routingNumber.equals(other$routingNumber));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                AccountHolderType $accountHolderType = this.getAccountHolderType();
                result = result * 59 + ($accountHolderType == null ? 43 : $accountHolderType.hashCode());
                String $accountNumber = this.getAccountNumber();
                result = result * 59 + ($accountNumber == null ? 43 : $accountNumber.hashCode());
                AccountType $accountType = this.getAccountType();
                result = result * 59 + ($accountType == null ? 43 : $accountType.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $financialConnectionsAccount = this.getFinancialConnectionsAccount();
                result = result * 59 + ($financialConnectionsAccount == null ? 43 : $financialConnectionsAccount.hashCode());
                String $routingNumber = this.getRoutingNumber();
                result = result * 59 + ($routingNumber == null ? 43 : $routingNumber.hashCode());
                return result;
            }

            public static enum AccountHolderType implements ApiRequestParams.EnumParam
            {
                COMPANY("company"),
                INDIVIDUAL("individual");

                private final String value;

                private AccountHolderType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum AccountType implements ApiRequestParams.EnumParam
            {
                CHECKING("checking"),
                SAVINGS("savings");

                private final String value;

                private AccountType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AccountHolderType accountHolderType;
                private String accountNumber;
                private AccountType accountType;
                private Map<String, Object> extraParams;
                private String financialConnectionsAccount;
                private String routingNumber;

                public UsBankAccount build() {
                    return new UsBankAccount(this.accountHolderType, this.accountNumber, this.accountType, this.extraParams, this.financialConnectionsAccount, this.routingNumber);
                }

                public Builder setAccountHolderType(AccountHolderType accountHolderType) {
                    this.accountHolderType = accountHolderType;
                    return this;
                }

                public Builder setAccountNumber(String accountNumber) {
                    this.accountNumber = accountNumber;
                    return this;
                }

                public Builder setAccountType(AccountType accountType) {
                    this.accountType = accountType;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFinancialConnectionsAccount(String financialConnectionsAccount) {
                    this.financialConnectionsAccount = financialConnectionsAccount;
                    return this;
                }

                public Builder setRoutingNumber(String routingNumber) {
                    this.routingNumber = routingNumber;
                    return this;
                }
            }
        }

        public static class WechatPay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private WechatPay(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public WechatPay build() {
                    return new WechatPay(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Zip {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Zip(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zip)) {
                    return false;
                }
                Zip other = (Zip)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zip;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Zip build() {
                    return new Zip(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Builder {
            private AcssDebit acssDebit;
            private Affirm affirm;
            private AfterpayClearpay afterpayClearpay;
            private Alipay alipay;
            private AllowRedisplay allowRedisplay;
            private Alma alma;
            private AmazonPay amazonPay;
            private AuBecsDebit auBecsDebit;
            private BacsDebit bacsDebit;
            private Bancontact bancontact;
            private Billie billie;
            private BillingDetails billingDetails;
            private Blik blik;
            private Boleto boleto;
            private Cashapp cashapp;
            private Crypto crypto;
            private CustomerBalance customerBalance;
            private Eps eps;
            private Map<String, Object> extraParams;
            private Fpx fpx;
            private Giropay giropay;
            private Gopay gopay;
            private Grabpay grabpay;
            private IdBankTransfer idBankTransfer;
            private Ideal ideal;
            private InteracPresent interacPresent;
            private KakaoPay kakaoPay;
            private Klarna klarna;
            private Konbini konbini;
            private KrCard krCard;
            private Link link;
            private MbWay mbWay;
            private Map<String, String> metadata;
            private Mobilepay mobilepay;
            private Multibanco multibanco;
            private NaverPay naverPay;
            private NzBankAccount nzBankAccount;
            private Oxxo oxxo;
            private P24 p24;
            private PayByBank payByBank;
            private Payco payco;
            private Paynow paynow;
            private Paypal paypal;
            private Paypay paypay;
            private Payto payto;
            private Pix pix;
            private Promptpay promptpay;
            private Qris qris;
            private RadarOptions radarOptions;
            private Rechnung rechnung;
            private RevolutPay revolutPay;
            private SamsungPay samsungPay;
            private Satispay satispay;
            private SepaDebit sepaDebit;
            private Shopeepay shopeepay;
            private Sofort sofort;
            private StripeBalance stripeBalance;
            private Swish swish;
            private Twint twint;
            private Type type;
            private UsBankAccount usBankAccount;
            private WechatPay wechatPay;
            private Zip zip;

            public PaymentMethodData build() {
                return new PaymentMethodData(this.acssDebit, this.affirm, this.afterpayClearpay, this.alipay, this.allowRedisplay, this.alma, this.amazonPay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.billie, this.billingDetails, this.blik, this.boleto, this.cashapp, this.crypto, this.customerBalance, this.eps, this.extraParams, this.fpx, this.giropay, this.gopay, this.grabpay, this.idBankTransfer, this.ideal, this.interacPresent, this.kakaoPay, this.klarna, this.konbini, this.krCard, this.link, this.mbWay, this.metadata, this.mobilepay, this.multibanco, this.naverPay, this.nzBankAccount, this.oxxo, this.p24, this.payByBank, this.payco, this.paynow, this.paypal, this.paypay, this.payto, this.pix, this.promptpay, this.qris, this.radarOptions, this.rechnung, this.revolutPay, this.samsungPay, this.satispay, this.sepaDebit, this.shopeepay, this.sofort, this.stripeBalance, this.swish, this.twint, this.type, this.usBankAccount, this.wechatPay, this.zip);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAffirm(Affirm affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAllowRedisplay(AllowRedisplay allowRedisplay) {
                this.allowRedisplay = allowRedisplay;
                return this;
            }

            public Builder setAlma(Alma alma) {
                this.alma = alma;
                return this;
            }

            public Builder setAmazonPay(AmazonPay amazonPay) {
                this.amazonPay = amazonPay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBillie(Billie billie) {
                this.billie = billie;
                return this;
            }

            public Builder setBillingDetails(BillingDetails billingDetails) {
                this.billingDetails = billingDetails;
                return this;
            }

            public Builder setBlik(Blik blik) {
                this.blik = blik;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setCashapp(Cashapp cashapp) {
                this.cashapp = cashapp;
                return this;
            }

            public Builder setCrypto(Crypto crypto) {
                this.crypto = crypto;
                return this;
            }

            public Builder setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGopay(Gopay gopay) {
                this.gopay = gopay;
                return this;
            }

            public Builder setGrabpay(Grabpay grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setIdBankTransfer(IdBankTransfer idBankTransfer) {
                this.idBankTransfer = idBankTransfer;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setKakaoPay(KakaoPay kakaoPay) {
                this.kakaoPay = kakaoPay;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKonbini(Konbini konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setKrCard(KrCard krCard) {
                this.krCard = krCard;
                return this;
            }

            public Builder setLink(Link link) {
                this.link = link;
                return this;
            }

            public Builder setMbWay(MbWay mbWay) {
                this.mbWay = mbWay;
                return this;
            }

            public Builder putMetadata(String key, String value) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.put(key, value);
                return this;
            }

            public Builder putAllMetadata(Map<String, String> map) {
                if (this.metadata == null) {
                    this.metadata = new HashMap<String, String>();
                }
                this.metadata.putAll(map);
                return this;
            }

            public Builder setMobilepay(Mobilepay mobilepay) {
                this.mobilepay = mobilepay;
                return this;
            }

            public Builder setMultibanco(Multibanco multibanco) {
                this.multibanco = multibanco;
                return this;
            }

            public Builder setNaverPay(NaverPay naverPay) {
                this.naverPay = naverPay;
                return this;
            }

            public Builder setNzBankAccount(NzBankAccount nzBankAccount) {
                this.nzBankAccount = nzBankAccount;
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setPayByBank(PayByBank payByBank) {
                this.payByBank = payByBank;
                return this;
            }

            public Builder setPayco(Payco payco) {
                this.payco = payco;
                return this;
            }

            public Builder setPaynow(Paynow paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setPaypal(Paypal paypal) {
                this.paypal = paypal;
                return this;
            }

            public Builder setPaypay(Paypay paypay) {
                this.paypay = paypay;
                return this;
            }

            public Builder setPayto(Payto payto) {
                this.payto = payto;
                return this;
            }

            public Builder setPix(Pix pix) {
                this.pix = pix;
                return this;
            }

            public Builder setPromptpay(Promptpay promptpay) {
                this.promptpay = promptpay;
                return this;
            }

            public Builder setQris(Qris qris) {
                this.qris = qris;
                return this;
            }

            public Builder setRadarOptions(RadarOptions radarOptions) {
                this.radarOptions = radarOptions;
                return this;
            }

            public Builder setRechnung(Rechnung rechnung) {
                this.rechnung = rechnung;
                return this;
            }

            public Builder setRevolutPay(RevolutPay revolutPay) {
                this.revolutPay = revolutPay;
                return this;
            }

            public Builder setSamsungPay(SamsungPay samsungPay) {
                this.samsungPay = samsungPay;
                return this;
            }

            public Builder setSatispay(Satispay satispay) {
                this.satispay = satispay;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setShopeepay(Shopeepay shopeepay) {
                this.shopeepay = shopeepay;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setStripeBalance(StripeBalance stripeBalance) {
                this.stripeBalance = stripeBalance;
                return this;
            }

            public Builder setSwish(Swish swish) {
                this.swish = swish;
                return this;
            }

            public Builder setTwint(Twint twint) {
                this.twint = twint;
                return this;
            }

            public Builder setType(Type type) {
                this.type = type;
                return this;
            }

            public Builder setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setZip(Zip zip) {
                this.zip = zip;
                return this;
            }
        }
    }

    public static class PaymentMethodOptions {
        @SerializedName(value="acss_debit")
        Object acssDebit;
        @SerializedName(value="affirm")
        Object affirm;
        @SerializedName(value="afterpay_clearpay")
        Object afterpayClearpay;
        @SerializedName(value="alipay")
        Object alipay;
        @SerializedName(value="alma")
        Object alma;
        @SerializedName(value="amazon_pay")
        Object amazonPay;
        @SerializedName(value="au_becs_debit")
        Object auBecsDebit;
        @SerializedName(value="bacs_debit")
        Object bacsDebit;
        @SerializedName(value="bancontact")
        Object bancontact;
        @SerializedName(value="billie")
        Object billie;
        @SerializedName(value="blik")
        Object blik;
        @SerializedName(value="boleto")
        Object boleto;
        @SerializedName(value="card")
        Object card;
        @SerializedName(value="card_present")
        Object cardPresent;
        @SerializedName(value="cashapp")
        Object cashapp;
        @SerializedName(value="crypto")
        Object crypto;
        @SerializedName(value="customer_balance")
        Object customerBalance;
        @SerializedName(value="eps")
        Object eps;
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="fpx")
        Object fpx;
        @SerializedName(value="giropay")
        Object giropay;
        @SerializedName(value="gopay")
        Object gopay;
        @SerializedName(value="grabpay")
        Object grabpay;
        @SerializedName(value="id_bank_transfer")
        Object idBankTransfer;
        @SerializedName(value="ideal")
        Object ideal;
        @SerializedName(value="interac_present")
        Object interacPresent;
        @SerializedName(value="kakao_pay")
        Object kakaoPay;
        @SerializedName(value="klarna")
        Object klarna;
        @SerializedName(value="konbini")
        Object konbini;
        @SerializedName(value="kr_card")
        Object krCard;
        @SerializedName(value="link")
        Object link;
        @SerializedName(value="mb_way")
        Object mbWay;
        @SerializedName(value="mobilepay")
        Object mobilepay;
        @SerializedName(value="multibanco")
        Object multibanco;
        @SerializedName(value="naver_pay")
        Object naverPay;
        @SerializedName(value="nz_bank_account")
        Object nzBankAccount;
        @SerializedName(value="oxxo")
        Object oxxo;
        @SerializedName(value="p24")
        Object p24;
        @SerializedName(value="pay_by_bank")
        Object payByBank;
        @SerializedName(value="payco")
        Object payco;
        @SerializedName(value="paynow")
        Object paynow;
        @SerializedName(value="paypal")
        Object paypal;
        @SerializedName(value="paypay")
        Object paypay;
        @SerializedName(value="payto")
        Object payto;
        @SerializedName(value="pix")
        Object pix;
        @SerializedName(value="promptpay")
        Object promptpay;
        @SerializedName(value="qris")
        Object qris;
        @SerializedName(value="rechnung")
        Object rechnung;
        @SerializedName(value="revolut_pay")
        Object revolutPay;
        @SerializedName(value="samsung_pay")
        Object samsungPay;
        @SerializedName(value="satispay")
        Object satispay;
        @SerializedName(value="sepa_debit")
        Object sepaDebit;
        @SerializedName(value="shopeepay")
        Object shopeepay;
        @SerializedName(value="sofort")
        Object sofort;
        @SerializedName(value="stripe_balance")
        Object stripeBalance;
        @SerializedName(value="swish")
        Object swish;
        @SerializedName(value="twint")
        Object twint;
        @SerializedName(value="us_bank_account")
        Object usBankAccount;
        @SerializedName(value="wechat_pay")
        Object wechatPay;
        @SerializedName(value="zip")
        Object zip;

        private PaymentMethodOptions(Object acssDebit, Object affirm, Object afterpayClearpay, Object alipay, Object alma, Object amazonPay, Object auBecsDebit, Object bacsDebit, Object bancontact, Object billie, Object blik, Object boleto, Object card, Object cardPresent, Object cashapp, Object crypto, Object customerBalance, Object eps, Map<String, Object> extraParams, Object fpx, Object giropay, Object gopay, Object grabpay, Object idBankTransfer, Object ideal, Object interacPresent, Object kakaoPay, Object klarna, Object konbini, Object krCard, Object link, Object mbWay, Object mobilepay, Object multibanco, Object naverPay, Object nzBankAccount, Object oxxo, Object p24, Object payByBank, Object payco, Object paynow, Object paypal, Object paypay, Object payto, Object pix, Object promptpay, Object qris, Object rechnung, Object revolutPay, Object samsungPay, Object satispay, Object sepaDebit, Object shopeepay, Object sofort, Object stripeBalance, Object swish, Object twint, Object usBankAccount, Object wechatPay, Object zip) {
            this.acssDebit = acssDebit;
            this.affirm = affirm;
            this.afterpayClearpay = afterpayClearpay;
            this.alipay = alipay;
            this.alma = alma;
            this.amazonPay = amazonPay;
            this.auBecsDebit = auBecsDebit;
            this.bacsDebit = bacsDebit;
            this.bancontact = bancontact;
            this.billie = billie;
            this.blik = blik;
            this.boleto = boleto;
            this.card = card;
            this.cardPresent = cardPresent;
            this.cashapp = cashapp;
            this.crypto = crypto;
            this.customerBalance = customerBalance;
            this.eps = eps;
            this.extraParams = extraParams;
            this.fpx = fpx;
            this.giropay = giropay;
            this.gopay = gopay;
            this.grabpay = grabpay;
            this.idBankTransfer = idBankTransfer;
            this.ideal = ideal;
            this.interacPresent = interacPresent;
            this.kakaoPay = kakaoPay;
            this.klarna = klarna;
            this.konbini = konbini;
            this.krCard = krCard;
            this.link = link;
            this.mbWay = mbWay;
            this.mobilepay = mobilepay;
            this.multibanco = multibanco;
            this.naverPay = naverPay;
            this.nzBankAccount = nzBankAccount;
            this.oxxo = oxxo;
            this.p24 = p24;
            this.payByBank = payByBank;
            this.payco = payco;
            this.paynow = paynow;
            this.paypal = paypal;
            this.paypay = paypay;
            this.payto = payto;
            this.pix = pix;
            this.promptpay = promptpay;
            this.qris = qris;
            this.rechnung = rechnung;
            this.revolutPay = revolutPay;
            this.samsungPay = samsungPay;
            this.satispay = satispay;
            this.sepaDebit = sepaDebit;
            this.shopeepay = shopeepay;
            this.sofort = sofort;
            this.stripeBalance = stripeBalance;
            this.swish = swish;
            this.twint = twint;
            this.usBankAccount = usBankAccount;
            this.wechatPay = wechatPay;
            this.zip = zip;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Object getAcssDebit() {
            return this.acssDebit;
        }

        @Generated
        public Object getAffirm() {
            return this.affirm;
        }

        @Generated
        public Object getAfterpayClearpay() {
            return this.afterpayClearpay;
        }

        @Generated
        public Object getAlipay() {
            return this.alipay;
        }

        @Generated
        public Object getAlma() {
            return this.alma;
        }

        @Generated
        public Object getAmazonPay() {
            return this.amazonPay;
        }

        @Generated
        public Object getAuBecsDebit() {
            return this.auBecsDebit;
        }

        @Generated
        public Object getBacsDebit() {
            return this.bacsDebit;
        }

        @Generated
        public Object getBancontact() {
            return this.bancontact;
        }

        @Generated
        public Object getBillie() {
            return this.billie;
        }

        @Generated
        public Object getBlik() {
            return this.blik;
        }

        @Generated
        public Object getBoleto() {
            return this.boleto;
        }

        @Generated
        public Object getCard() {
            return this.card;
        }

        @Generated
        public Object getCardPresent() {
            return this.cardPresent;
        }

        @Generated
        public Object getCashapp() {
            return this.cashapp;
        }

        @Generated
        public Object getCrypto() {
            return this.crypto;
        }

        @Generated
        public Object getCustomerBalance() {
            return this.customerBalance;
        }

        @Generated
        public Object getEps() {
            return this.eps;
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public Object getFpx() {
            return this.fpx;
        }

        @Generated
        public Object getGiropay() {
            return this.giropay;
        }

        @Generated
        public Object getGopay() {
            return this.gopay;
        }

        @Generated
        public Object getGrabpay() {
            return this.grabpay;
        }

        @Generated
        public Object getIdBankTransfer() {
            return this.idBankTransfer;
        }

        @Generated
        public Object getIdeal() {
            return this.ideal;
        }

        @Generated
        public Object getInteracPresent() {
            return this.interacPresent;
        }

        @Generated
        public Object getKakaoPay() {
            return this.kakaoPay;
        }

        @Generated
        public Object getKlarna() {
            return this.klarna;
        }

        @Generated
        public Object getKonbini() {
            return this.konbini;
        }

        @Generated
        public Object getKrCard() {
            return this.krCard;
        }

        @Generated
        public Object getLink() {
            return this.link;
        }

        @Generated
        public Object getMbWay() {
            return this.mbWay;
        }

        @Generated
        public Object getMobilepay() {
            return this.mobilepay;
        }

        @Generated
        public Object getMultibanco() {
            return this.multibanco;
        }

        @Generated
        public Object getNaverPay() {
            return this.naverPay;
        }

        @Generated
        public Object getNzBankAccount() {
            return this.nzBankAccount;
        }

        @Generated
        public Object getOxxo() {
            return this.oxxo;
        }

        @Generated
        public Object getP24() {
            return this.p24;
        }

        @Generated
        public Object getPayByBank() {
            return this.payByBank;
        }

        @Generated
        public Object getPayco() {
            return this.payco;
        }

        @Generated
        public Object getPaynow() {
            return this.paynow;
        }

        @Generated
        public Object getPaypal() {
            return this.paypal;
        }

        @Generated
        public Object getPaypay() {
            return this.paypay;
        }

        @Generated
        public Object getPayto() {
            return this.payto;
        }

        @Generated
        public Object getPix() {
            return this.pix;
        }

        @Generated
        public Object getPromptpay() {
            return this.promptpay;
        }

        @Generated
        public Object getQris() {
            return this.qris;
        }

        @Generated
        public Object getRechnung() {
            return this.rechnung;
        }

        @Generated
        public Object getRevolutPay() {
            return this.revolutPay;
        }

        @Generated
        public Object getSamsungPay() {
            return this.samsungPay;
        }

        @Generated
        public Object getSatispay() {
            return this.satispay;
        }

        @Generated
        public Object getSepaDebit() {
            return this.sepaDebit;
        }

        @Generated
        public Object getShopeepay() {
            return this.shopeepay;
        }

        @Generated
        public Object getSofort() {
            return this.sofort;
        }

        @Generated
        public Object getStripeBalance() {
            return this.stripeBalance;
        }

        @Generated
        public Object getSwish() {
            return this.swish;
        }

        @Generated
        public Object getTwint() {
            return this.twint;
        }

        @Generated
        public Object getUsBankAccount() {
            return this.usBankAccount;
        }

        @Generated
        public Object getWechatPay() {
            return this.wechatPay;
        }

        @Generated
        public Object getZip() {
            return this.zip;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodOptions)) {
                return false;
            }
            PaymentMethodOptions other = (PaymentMethodOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$acssDebit = this.getAcssDebit();
            Object other$acssDebit = other.getAcssDebit();
            if (this$acssDebit == null ? other$acssDebit != null : !this$acssDebit.equals(other$acssDebit)) {
                return false;
            }
            Object this$affirm = this.getAffirm();
            Object other$affirm = other.getAffirm();
            if (this$affirm == null ? other$affirm != null : !this$affirm.equals(other$affirm)) {
                return false;
            }
            Object this$afterpayClearpay = this.getAfterpayClearpay();
            Object other$afterpayClearpay = other.getAfterpayClearpay();
            if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !this$afterpayClearpay.equals(other$afterpayClearpay)) {
                return false;
            }
            Object this$alipay = this.getAlipay();
            Object other$alipay = other.getAlipay();
            if (this$alipay == null ? other$alipay != null : !this$alipay.equals(other$alipay)) {
                return false;
            }
            Object this$alma = this.getAlma();
            Object other$alma = other.getAlma();
            if (this$alma == null ? other$alma != null : !this$alma.equals(other$alma)) {
                return false;
            }
            Object this$amazonPay = this.getAmazonPay();
            Object other$amazonPay = other.getAmazonPay();
            if (this$amazonPay == null ? other$amazonPay != null : !this$amazonPay.equals(other$amazonPay)) {
                return false;
            }
            Object this$auBecsDebit = this.getAuBecsDebit();
            Object other$auBecsDebit = other.getAuBecsDebit();
            if (this$auBecsDebit == null ? other$auBecsDebit != null : !this$auBecsDebit.equals(other$auBecsDebit)) {
                return false;
            }
            Object this$bacsDebit = this.getBacsDebit();
            Object other$bacsDebit = other.getBacsDebit();
            if (this$bacsDebit == null ? other$bacsDebit != null : !this$bacsDebit.equals(other$bacsDebit)) {
                return false;
            }
            Object this$bancontact = this.getBancontact();
            Object other$bancontact = other.getBancontact();
            if (this$bancontact == null ? other$bancontact != null : !this$bancontact.equals(other$bancontact)) {
                return false;
            }
            Object this$billie = this.getBillie();
            Object other$billie = other.getBillie();
            if (this$billie == null ? other$billie != null : !this$billie.equals(other$billie)) {
                return false;
            }
            Object this$blik = this.getBlik();
            Object other$blik = other.getBlik();
            if (this$blik == null ? other$blik != null : !this$blik.equals(other$blik)) {
                return false;
            }
            Object this$boleto = this.getBoleto();
            Object other$boleto = other.getBoleto();
            if (this$boleto == null ? other$boleto != null : !this$boleto.equals(other$boleto)) {
                return false;
            }
            Object this$card = this.getCard();
            Object other$card = other.getCard();
            if (this$card == null ? other$card != null : !this$card.equals(other$card)) {
                return false;
            }
            Object this$cardPresent = this.getCardPresent();
            Object other$cardPresent = other.getCardPresent();
            if (this$cardPresent == null ? other$cardPresent != null : !this$cardPresent.equals(other$cardPresent)) {
                return false;
            }
            Object this$cashapp = this.getCashapp();
            Object other$cashapp = other.getCashapp();
            if (this$cashapp == null ? other$cashapp != null : !this$cashapp.equals(other$cashapp)) {
                return false;
            }
            Object this$crypto = this.getCrypto();
            Object other$crypto = other.getCrypto();
            if (this$crypto == null ? other$crypto != null : !this$crypto.equals(other$crypto)) {
                return false;
            }
            Object this$customerBalance = this.getCustomerBalance();
            Object other$customerBalance = other.getCustomerBalance();
            if (this$customerBalance == null ? other$customerBalance != null : !this$customerBalance.equals(other$customerBalance)) {
                return false;
            }
            Object this$eps = this.getEps();
            Object other$eps = other.getEps();
            if (this$eps == null ? other$eps != null : !this$eps.equals(other$eps)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            Object this$fpx = this.getFpx();
            Object other$fpx = other.getFpx();
            if (this$fpx == null ? other$fpx != null : !this$fpx.equals(other$fpx)) {
                return false;
            }
            Object this$giropay = this.getGiropay();
            Object other$giropay = other.getGiropay();
            if (this$giropay == null ? other$giropay != null : !this$giropay.equals(other$giropay)) {
                return false;
            }
            Object this$gopay = this.getGopay();
            Object other$gopay = other.getGopay();
            if (this$gopay == null ? other$gopay != null : !this$gopay.equals(other$gopay)) {
                return false;
            }
            Object this$grabpay = this.getGrabpay();
            Object other$grabpay = other.getGrabpay();
            if (this$grabpay == null ? other$grabpay != null : !this$grabpay.equals(other$grabpay)) {
                return false;
            }
            Object this$idBankTransfer = this.getIdBankTransfer();
            Object other$idBankTransfer = other.getIdBankTransfer();
            if (this$idBankTransfer == null ? other$idBankTransfer != null : !this$idBankTransfer.equals(other$idBankTransfer)) {
                return false;
            }
            Object this$ideal = this.getIdeal();
            Object other$ideal = other.getIdeal();
            if (this$ideal == null ? other$ideal != null : !this$ideal.equals(other$ideal)) {
                return false;
            }
            Object this$interacPresent = this.getInteracPresent();
            Object other$interacPresent = other.getInteracPresent();
            if (this$interacPresent == null ? other$interacPresent != null : !this$interacPresent.equals(other$interacPresent)) {
                return false;
            }
            Object this$kakaoPay = this.getKakaoPay();
            Object other$kakaoPay = other.getKakaoPay();
            if (this$kakaoPay == null ? other$kakaoPay != null : !this$kakaoPay.equals(other$kakaoPay)) {
                return false;
            }
            Object this$klarna = this.getKlarna();
            Object other$klarna = other.getKlarna();
            if (this$klarna == null ? other$klarna != null : !this$klarna.equals(other$klarna)) {
                return false;
            }
            Object this$konbini = this.getKonbini();
            Object other$konbini = other.getKonbini();
            if (this$konbini == null ? other$konbini != null : !this$konbini.equals(other$konbini)) {
                return false;
            }
            Object this$krCard = this.getKrCard();
            Object other$krCard = other.getKrCard();
            if (this$krCard == null ? other$krCard != null : !this$krCard.equals(other$krCard)) {
                return false;
            }
            Object this$link = this.getLink();
            Object other$link = other.getLink();
            if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
                return false;
            }
            Object this$mbWay = this.getMbWay();
            Object other$mbWay = other.getMbWay();
            if (this$mbWay == null ? other$mbWay != null : !this$mbWay.equals(other$mbWay)) {
                return false;
            }
            Object this$mobilepay = this.getMobilepay();
            Object other$mobilepay = other.getMobilepay();
            if (this$mobilepay == null ? other$mobilepay != null : !this$mobilepay.equals(other$mobilepay)) {
                return false;
            }
            Object this$multibanco = this.getMultibanco();
            Object other$multibanco = other.getMultibanco();
            if (this$multibanco == null ? other$multibanco != null : !this$multibanco.equals(other$multibanco)) {
                return false;
            }
            Object this$naverPay = this.getNaverPay();
            Object other$naverPay = other.getNaverPay();
            if (this$naverPay == null ? other$naverPay != null : !this$naverPay.equals(other$naverPay)) {
                return false;
            }
            Object this$nzBankAccount = this.getNzBankAccount();
            Object other$nzBankAccount = other.getNzBankAccount();
            if (this$nzBankAccount == null ? other$nzBankAccount != null : !this$nzBankAccount.equals(other$nzBankAccount)) {
                return false;
            }
            Object this$oxxo = this.getOxxo();
            Object other$oxxo = other.getOxxo();
            if (this$oxxo == null ? other$oxxo != null : !this$oxxo.equals(other$oxxo)) {
                return false;
            }
            Object this$p24 = this.getP24();
            Object other$p24 = other.getP24();
            if (this$p24 == null ? other$p24 != null : !this$p24.equals(other$p24)) {
                return false;
            }
            Object this$payByBank = this.getPayByBank();
            Object other$payByBank = other.getPayByBank();
            if (this$payByBank == null ? other$payByBank != null : !this$payByBank.equals(other$payByBank)) {
                return false;
            }
            Object this$payco = this.getPayco();
            Object other$payco = other.getPayco();
            if (this$payco == null ? other$payco != null : !this$payco.equals(other$payco)) {
                return false;
            }
            Object this$paynow = this.getPaynow();
            Object other$paynow = other.getPaynow();
            if (this$paynow == null ? other$paynow != null : !this$paynow.equals(other$paynow)) {
                return false;
            }
            Object this$paypal = this.getPaypal();
            Object other$paypal = other.getPaypal();
            if (this$paypal == null ? other$paypal != null : !this$paypal.equals(other$paypal)) {
                return false;
            }
            Object this$paypay = this.getPaypay();
            Object other$paypay = other.getPaypay();
            if (this$paypay == null ? other$paypay != null : !this$paypay.equals(other$paypay)) {
                return false;
            }
            Object this$payto = this.getPayto();
            Object other$payto = other.getPayto();
            if (this$payto == null ? other$payto != null : !this$payto.equals(other$payto)) {
                return false;
            }
            Object this$pix = this.getPix();
            Object other$pix = other.getPix();
            if (this$pix == null ? other$pix != null : !this$pix.equals(other$pix)) {
                return false;
            }
            Object this$promptpay = this.getPromptpay();
            Object other$promptpay = other.getPromptpay();
            if (this$promptpay == null ? other$promptpay != null : !this$promptpay.equals(other$promptpay)) {
                return false;
            }
            Object this$qris = this.getQris();
            Object other$qris = other.getQris();
            if (this$qris == null ? other$qris != null : !this$qris.equals(other$qris)) {
                return false;
            }
            Object this$rechnung = this.getRechnung();
            Object other$rechnung = other.getRechnung();
            if (this$rechnung == null ? other$rechnung != null : !this$rechnung.equals(other$rechnung)) {
                return false;
            }
            Object this$revolutPay = this.getRevolutPay();
            Object other$revolutPay = other.getRevolutPay();
            if (this$revolutPay == null ? other$revolutPay != null : !this$revolutPay.equals(other$revolutPay)) {
                return false;
            }
            Object this$samsungPay = this.getSamsungPay();
            Object other$samsungPay = other.getSamsungPay();
            if (this$samsungPay == null ? other$samsungPay != null : !this$samsungPay.equals(other$samsungPay)) {
                return false;
            }
            Object this$satispay = this.getSatispay();
            Object other$satispay = other.getSatispay();
            if (this$satispay == null ? other$satispay != null : !this$satispay.equals(other$satispay)) {
                return false;
            }
            Object this$sepaDebit = this.getSepaDebit();
            Object other$sepaDebit = other.getSepaDebit();
            if (this$sepaDebit == null ? other$sepaDebit != null : !this$sepaDebit.equals(other$sepaDebit)) {
                return false;
            }
            Object this$shopeepay = this.getShopeepay();
            Object other$shopeepay = other.getShopeepay();
            if (this$shopeepay == null ? other$shopeepay != null : !this$shopeepay.equals(other$shopeepay)) {
                return false;
            }
            Object this$sofort = this.getSofort();
            Object other$sofort = other.getSofort();
            if (this$sofort == null ? other$sofort != null : !this$sofort.equals(other$sofort)) {
                return false;
            }
            Object this$stripeBalance = this.getStripeBalance();
            Object other$stripeBalance = other.getStripeBalance();
            if (this$stripeBalance == null ? other$stripeBalance != null : !this$stripeBalance.equals(other$stripeBalance)) {
                return false;
            }
            Object this$swish = this.getSwish();
            Object other$swish = other.getSwish();
            if (this$swish == null ? other$swish != null : !this$swish.equals(other$swish)) {
                return false;
            }
            Object this$twint = this.getTwint();
            Object other$twint = other.getTwint();
            if (this$twint == null ? other$twint != null : !this$twint.equals(other$twint)) {
                return false;
            }
            Object this$usBankAccount = this.getUsBankAccount();
            Object other$usBankAccount = other.getUsBankAccount();
            if (this$usBankAccount == null ? other$usBankAccount != null : !this$usBankAccount.equals(other$usBankAccount)) {
                return false;
            }
            Object this$wechatPay = this.getWechatPay();
            Object other$wechatPay = other.getWechatPay();
            if (this$wechatPay == null ? other$wechatPay != null : !this$wechatPay.equals(other$wechatPay)) {
                return false;
            }
            Object this$zip = this.getZip();
            Object other$zip = other.getZip();
            return !(this$zip == null ? other$zip != null : !this$zip.equals(other$zip));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $acssDebit = this.getAcssDebit();
            result = result * 59 + ($acssDebit == null ? 43 : $acssDebit.hashCode());
            Object $affirm = this.getAffirm();
            result = result * 59 + ($affirm == null ? 43 : $affirm.hashCode());
            Object $afterpayClearpay = this.getAfterpayClearpay();
            result = result * 59 + ($afterpayClearpay == null ? 43 : $afterpayClearpay.hashCode());
            Object $alipay = this.getAlipay();
            result = result * 59 + ($alipay == null ? 43 : $alipay.hashCode());
            Object $alma = this.getAlma();
            result = result * 59 + ($alma == null ? 43 : $alma.hashCode());
            Object $amazonPay = this.getAmazonPay();
            result = result * 59 + ($amazonPay == null ? 43 : $amazonPay.hashCode());
            Object $auBecsDebit = this.getAuBecsDebit();
            result = result * 59 + ($auBecsDebit == null ? 43 : $auBecsDebit.hashCode());
            Object $bacsDebit = this.getBacsDebit();
            result = result * 59 + ($bacsDebit == null ? 43 : $bacsDebit.hashCode());
            Object $bancontact = this.getBancontact();
            result = result * 59 + ($bancontact == null ? 43 : $bancontact.hashCode());
            Object $billie = this.getBillie();
            result = result * 59 + ($billie == null ? 43 : $billie.hashCode());
            Object $blik = this.getBlik();
            result = result * 59 + ($blik == null ? 43 : $blik.hashCode());
            Object $boleto = this.getBoleto();
            result = result * 59 + ($boleto == null ? 43 : $boleto.hashCode());
            Object $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : $card.hashCode());
            Object $cardPresent = this.getCardPresent();
            result = result * 59 + ($cardPresent == null ? 43 : $cardPresent.hashCode());
            Object $cashapp = this.getCashapp();
            result = result * 59 + ($cashapp == null ? 43 : $cashapp.hashCode());
            Object $crypto = this.getCrypto();
            result = result * 59 + ($crypto == null ? 43 : $crypto.hashCode());
            Object $customerBalance = this.getCustomerBalance();
            result = result * 59 + ($customerBalance == null ? 43 : $customerBalance.hashCode());
            Object $eps = this.getEps();
            result = result * 59 + ($eps == null ? 43 : $eps.hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            Object $fpx = this.getFpx();
            result = result * 59 + ($fpx == null ? 43 : $fpx.hashCode());
            Object $giropay = this.getGiropay();
            result = result * 59 + ($giropay == null ? 43 : $giropay.hashCode());
            Object $gopay = this.getGopay();
            result = result * 59 + ($gopay == null ? 43 : $gopay.hashCode());
            Object $grabpay = this.getGrabpay();
            result = result * 59 + ($grabpay == null ? 43 : $grabpay.hashCode());
            Object $idBankTransfer = this.getIdBankTransfer();
            result = result * 59 + ($idBankTransfer == null ? 43 : $idBankTransfer.hashCode());
            Object $ideal = this.getIdeal();
            result = result * 59 + ($ideal == null ? 43 : $ideal.hashCode());
            Object $interacPresent = this.getInteracPresent();
            result = result * 59 + ($interacPresent == null ? 43 : $interacPresent.hashCode());
            Object $kakaoPay = this.getKakaoPay();
            result = result * 59 + ($kakaoPay == null ? 43 : $kakaoPay.hashCode());
            Object $klarna = this.getKlarna();
            result = result * 59 + ($klarna == null ? 43 : $klarna.hashCode());
            Object $konbini = this.getKonbini();
            result = result * 59 + ($konbini == null ? 43 : $konbini.hashCode());
            Object $krCard = this.getKrCard();
            result = result * 59 + ($krCard == null ? 43 : $krCard.hashCode());
            Object $link = this.getLink();
            result = result * 59 + ($link == null ? 43 : $link.hashCode());
            Object $mbWay = this.getMbWay();
            result = result * 59 + ($mbWay == null ? 43 : $mbWay.hashCode());
            Object $mobilepay = this.getMobilepay();
            result = result * 59 + ($mobilepay == null ? 43 : $mobilepay.hashCode());
            Object $multibanco = this.getMultibanco();
            result = result * 59 + ($multibanco == null ? 43 : $multibanco.hashCode());
            Object $naverPay = this.getNaverPay();
            result = result * 59 + ($naverPay == null ? 43 : $naverPay.hashCode());
            Object $nzBankAccount = this.getNzBankAccount();
            result = result * 59 + ($nzBankAccount == null ? 43 : $nzBankAccount.hashCode());
            Object $oxxo = this.getOxxo();
            result = result * 59 + ($oxxo == null ? 43 : $oxxo.hashCode());
            Object $p24 = this.getP24();
            result = result * 59 + ($p24 == null ? 43 : $p24.hashCode());
            Object $payByBank = this.getPayByBank();
            result = result * 59 + ($payByBank == null ? 43 : $payByBank.hashCode());
            Object $payco = this.getPayco();
            result = result * 59 + ($payco == null ? 43 : $payco.hashCode());
            Object $paynow = this.getPaynow();
            result = result * 59 + ($paynow == null ? 43 : $paynow.hashCode());
            Object $paypal = this.getPaypal();
            result = result * 59 + ($paypal == null ? 43 : $paypal.hashCode());
            Object $paypay = this.getPaypay();
            result = result * 59 + ($paypay == null ? 43 : $paypay.hashCode());
            Object $payto = this.getPayto();
            result = result * 59 + ($payto == null ? 43 : $payto.hashCode());
            Object $pix = this.getPix();
            result = result * 59 + ($pix == null ? 43 : $pix.hashCode());
            Object $promptpay = this.getPromptpay();
            result = result * 59 + ($promptpay == null ? 43 : $promptpay.hashCode());
            Object $qris = this.getQris();
            result = result * 59 + ($qris == null ? 43 : $qris.hashCode());
            Object $rechnung = this.getRechnung();
            result = result * 59 + ($rechnung == null ? 43 : $rechnung.hashCode());
            Object $revolutPay = this.getRevolutPay();
            result = result * 59 + ($revolutPay == null ? 43 : $revolutPay.hashCode());
            Object $samsungPay = this.getSamsungPay();
            result = result * 59 + ($samsungPay == null ? 43 : $samsungPay.hashCode());
            Object $satispay = this.getSatispay();
            result = result * 59 + ($satispay == null ? 43 : $satispay.hashCode());
            Object $sepaDebit = this.getSepaDebit();
            result = result * 59 + ($sepaDebit == null ? 43 : $sepaDebit.hashCode());
            Object $shopeepay = this.getShopeepay();
            result = result * 59 + ($shopeepay == null ? 43 : $shopeepay.hashCode());
            Object $sofort = this.getSofort();
            result = result * 59 + ($sofort == null ? 43 : $sofort.hashCode());
            Object $stripeBalance = this.getStripeBalance();
            result = result * 59 + ($stripeBalance == null ? 43 : $stripeBalance.hashCode());
            Object $swish = this.getSwish();
            result = result * 59 + ($swish == null ? 43 : $swish.hashCode());
            Object $twint = this.getTwint();
            result = result * 59 + ($twint == null ? 43 : $twint.hashCode());
            Object $usBankAccount = this.getUsBankAccount();
            result = result * 59 + ($usBankAccount == null ? 43 : $usBankAccount.hashCode());
            Object $wechatPay = this.getWechatPay();
            result = result * 59 + ($wechatPay == null ? 43 : $wechatPay.hashCode());
            Object $zip = this.getZip();
            result = result * 59 + ($zip == null ? 43 : $zip.hashCode());
            return result;
        }

        public static class Builder {
            private Object acssDebit;
            private Object affirm;
            private Object afterpayClearpay;
            private Object alipay;
            private Object alma;
            private Object amazonPay;
            private Object auBecsDebit;
            private Object bacsDebit;
            private Object bancontact;
            private Object billie;
            private Object blik;
            private Object boleto;
            private Object card;
            private Object cardPresent;
            private Object cashapp;
            private Object crypto;
            private Object customerBalance;
            private Object eps;
            private Map<String, Object> extraParams;
            private Object fpx;
            private Object giropay;
            private Object gopay;
            private Object grabpay;
            private Object idBankTransfer;
            private Object ideal;
            private Object interacPresent;
            private Object kakaoPay;
            private Object klarna;
            private Object konbini;
            private Object krCard;
            private Object link;
            private Object mbWay;
            private Object mobilepay;
            private Object multibanco;
            private Object naverPay;
            private Object nzBankAccount;
            private Object oxxo;
            private Object p24;
            private Object payByBank;
            private Object payco;
            private Object paynow;
            private Object paypal;
            private Object paypay;
            private Object payto;
            private Object pix;
            private Object promptpay;
            private Object qris;
            private Object rechnung;
            private Object revolutPay;
            private Object samsungPay;
            private Object satispay;
            private Object sepaDebit;
            private Object shopeepay;
            private Object sofort;
            private Object stripeBalance;
            private Object swish;
            private Object twint;
            private Object usBankAccount;
            private Object wechatPay;
            private Object zip;

            public PaymentMethodOptions build() {
                return new PaymentMethodOptions(this.acssDebit, this.affirm, this.afterpayClearpay, this.alipay, this.alma, this.amazonPay, this.auBecsDebit, this.bacsDebit, this.bancontact, this.billie, this.blik, this.boleto, this.card, this.cardPresent, this.cashapp, this.crypto, this.customerBalance, this.eps, this.extraParams, this.fpx, this.giropay, this.gopay, this.grabpay, this.idBankTransfer, this.ideal, this.interacPresent, this.kakaoPay, this.klarna, this.konbini, this.krCard, this.link, this.mbWay, this.mobilepay, this.multibanco, this.naverPay, this.nzBankAccount, this.oxxo, this.p24, this.payByBank, this.payco, this.paynow, this.paypal, this.paypay, this.payto, this.pix, this.promptpay, this.qris, this.rechnung, this.revolutPay, this.samsungPay, this.satispay, this.sepaDebit, this.shopeepay, this.sofort, this.stripeBalance, this.swish, this.twint, this.usBankAccount, this.wechatPay, this.zip);
            }

            public Builder setAcssDebit(AcssDebit acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAcssDebit(EmptyParam acssDebit) {
                this.acssDebit = acssDebit;
                return this;
            }

            public Builder setAffirm(Affirm affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAffirm(EmptyParam affirm) {
                this.affirm = affirm;
                return this;
            }

            public Builder setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAfterpayClearpay(EmptyParam afterpayClearpay) {
                this.afterpayClearpay = afterpayClearpay;
                return this;
            }

            public Builder setAlipay(Alipay alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAlipay(EmptyParam alipay) {
                this.alipay = alipay;
                return this;
            }

            public Builder setAlma(Alma alma) {
                this.alma = alma;
                return this;
            }

            public Builder setAlma(EmptyParam alma) {
                this.alma = alma;
                return this;
            }

            public Builder setAmazonPay(AmazonPay amazonPay) {
                this.amazonPay = amazonPay;
                return this;
            }

            public Builder setAmazonPay(EmptyParam amazonPay) {
                this.amazonPay = amazonPay;
                return this;
            }

            public Builder setAuBecsDebit(AuBecsDebit auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setAuBecsDebit(EmptyParam auBecsDebit) {
                this.auBecsDebit = auBecsDebit;
                return this;
            }

            public Builder setBacsDebit(BacsDebit bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBacsDebit(EmptyParam bacsDebit) {
                this.bacsDebit = bacsDebit;
                return this;
            }

            public Builder setBancontact(Bancontact bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBancontact(EmptyParam bancontact) {
                this.bancontact = bancontact;
                return this;
            }

            public Builder setBillie(Billie billie) {
                this.billie = billie;
                return this;
            }

            public Builder setBillie(EmptyParam billie) {
                this.billie = billie;
                return this;
            }

            public Builder setBlik(Blik blik) {
                this.blik = blik;
                return this;
            }

            public Builder setBlik(EmptyParam blik) {
                this.blik = blik;
                return this;
            }

            public Builder setBoleto(Boleto boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setBoleto(EmptyParam boleto) {
                this.boleto = boleto;
                return this;
            }

            public Builder setCard(Card card) {
                this.card = card;
                return this;
            }

            public Builder setCard(EmptyParam card) {
                this.card = card;
                return this;
            }

            public Builder setCardPresent(CardPresent cardPresent) {
                this.cardPresent = cardPresent;
                return this;
            }

            public Builder setCardPresent(EmptyParam cardPresent) {
                this.cardPresent = cardPresent;
                return this;
            }

            public Builder setCashapp(Cashapp cashapp) {
                this.cashapp = cashapp;
                return this;
            }

            public Builder setCashapp(EmptyParam cashapp) {
                this.cashapp = cashapp;
                return this;
            }

            public Builder setCrypto(Crypto crypto) {
                this.crypto = crypto;
                return this;
            }

            public Builder setCrypto(EmptyParam crypto) {
                this.crypto = crypto;
                return this;
            }

            public Builder setCustomerBalance(CustomerBalance customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setCustomerBalance(EmptyParam customerBalance) {
                this.customerBalance = customerBalance;
                return this;
            }

            public Builder setEps(Eps eps) {
                this.eps = eps;
                return this;
            }

            public Builder setEps(EmptyParam eps) {
                this.eps = eps;
                return this;
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder setFpx(Fpx fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setFpx(EmptyParam fpx) {
                this.fpx = fpx;
                return this;
            }

            public Builder setGiropay(Giropay giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGiropay(EmptyParam giropay) {
                this.giropay = giropay;
                return this;
            }

            public Builder setGopay(Gopay gopay) {
                this.gopay = gopay;
                return this;
            }

            public Builder setGopay(EmptyParam gopay) {
                this.gopay = gopay;
                return this;
            }

            public Builder setGrabpay(Grabpay grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setGrabpay(EmptyParam grabpay) {
                this.grabpay = grabpay;
                return this;
            }

            public Builder setIdBankTransfer(IdBankTransfer idBankTransfer) {
                this.idBankTransfer = idBankTransfer;
                return this;
            }

            public Builder setIdBankTransfer(EmptyParam idBankTransfer) {
                this.idBankTransfer = idBankTransfer;
                return this;
            }

            public Builder setIdeal(Ideal ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setIdeal(EmptyParam ideal) {
                this.ideal = ideal;
                return this;
            }

            public Builder setInteracPresent(InteracPresent interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setInteracPresent(EmptyParam interacPresent) {
                this.interacPresent = interacPresent;
                return this;
            }

            public Builder setKakaoPay(KakaoPay kakaoPay) {
                this.kakaoPay = kakaoPay;
                return this;
            }

            public Builder setKakaoPay(EmptyParam kakaoPay) {
                this.kakaoPay = kakaoPay;
                return this;
            }

            public Builder setKlarna(Klarna klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKlarna(EmptyParam klarna) {
                this.klarna = klarna;
                return this;
            }

            public Builder setKonbini(Konbini konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setKonbini(EmptyParam konbini) {
                this.konbini = konbini;
                return this;
            }

            public Builder setKrCard(KrCard krCard) {
                this.krCard = krCard;
                return this;
            }

            public Builder setKrCard(EmptyParam krCard) {
                this.krCard = krCard;
                return this;
            }

            public Builder setLink(Link link) {
                this.link = link;
                return this;
            }

            public Builder setLink(EmptyParam link) {
                this.link = link;
                return this;
            }

            public Builder setMbWay(MbWay mbWay) {
                this.mbWay = mbWay;
                return this;
            }

            public Builder setMbWay(EmptyParam mbWay) {
                this.mbWay = mbWay;
                return this;
            }

            public Builder setMobilepay(Mobilepay mobilepay) {
                this.mobilepay = mobilepay;
                return this;
            }

            public Builder setMobilepay(EmptyParam mobilepay) {
                this.mobilepay = mobilepay;
                return this;
            }

            public Builder setMultibanco(Multibanco multibanco) {
                this.multibanco = multibanco;
                return this;
            }

            public Builder setMultibanco(EmptyParam multibanco) {
                this.multibanco = multibanco;
                return this;
            }

            public Builder setNaverPay(NaverPay naverPay) {
                this.naverPay = naverPay;
                return this;
            }

            public Builder setNaverPay(EmptyParam naverPay) {
                this.naverPay = naverPay;
                return this;
            }

            public Builder setNzBankAccount(NzBankAccount nzBankAccount) {
                this.nzBankAccount = nzBankAccount;
                return this;
            }

            public Builder setNzBankAccount(EmptyParam nzBankAccount) {
                this.nzBankAccount = nzBankAccount;
                return this;
            }

            public Builder setOxxo(Oxxo oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setOxxo(EmptyParam oxxo) {
                this.oxxo = oxxo;
                return this;
            }

            public Builder setP24(P24 p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setP24(EmptyParam p24) {
                this.p24 = p24;
                return this;
            }

            public Builder setPayByBank(PayByBank payByBank) {
                this.payByBank = payByBank;
                return this;
            }

            public Builder setPayByBank(EmptyParam payByBank) {
                this.payByBank = payByBank;
                return this;
            }

            public Builder setPayco(Payco payco) {
                this.payco = payco;
                return this;
            }

            public Builder setPayco(EmptyParam payco) {
                this.payco = payco;
                return this;
            }

            public Builder setPaynow(Paynow paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setPaynow(EmptyParam paynow) {
                this.paynow = paynow;
                return this;
            }

            public Builder setPaypal(Paypal paypal) {
                this.paypal = paypal;
                return this;
            }

            public Builder setPaypal(EmptyParam paypal) {
                this.paypal = paypal;
                return this;
            }

            public Builder setPaypay(Paypay paypay) {
                this.paypay = paypay;
                return this;
            }

            public Builder setPaypay(EmptyParam paypay) {
                this.paypay = paypay;
                return this;
            }

            public Builder setPayto(Payto payto) {
                this.payto = payto;
                return this;
            }

            public Builder setPayto(EmptyParam payto) {
                this.payto = payto;
                return this;
            }

            public Builder setPix(Pix pix) {
                this.pix = pix;
                return this;
            }

            public Builder setPix(EmptyParam pix) {
                this.pix = pix;
                return this;
            }

            public Builder setPromptpay(Promptpay promptpay) {
                this.promptpay = promptpay;
                return this;
            }

            public Builder setPromptpay(EmptyParam promptpay) {
                this.promptpay = promptpay;
                return this;
            }

            public Builder setQris(Qris qris) {
                this.qris = qris;
                return this;
            }

            public Builder setQris(EmptyParam qris) {
                this.qris = qris;
                return this;
            }

            public Builder setRechnung(Rechnung rechnung) {
                this.rechnung = rechnung;
                return this;
            }

            public Builder setRechnung(EmptyParam rechnung) {
                this.rechnung = rechnung;
                return this;
            }

            public Builder setRevolutPay(RevolutPay revolutPay) {
                this.revolutPay = revolutPay;
                return this;
            }

            public Builder setRevolutPay(EmptyParam revolutPay) {
                this.revolutPay = revolutPay;
                return this;
            }

            public Builder setSamsungPay(SamsungPay samsungPay) {
                this.samsungPay = samsungPay;
                return this;
            }

            public Builder setSamsungPay(EmptyParam samsungPay) {
                this.samsungPay = samsungPay;
                return this;
            }

            public Builder setSatispay(Satispay satispay) {
                this.satispay = satispay;
                return this;
            }

            public Builder setSatispay(EmptyParam satispay) {
                this.satispay = satispay;
                return this;
            }

            public Builder setSepaDebit(SepaDebit sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setSepaDebit(EmptyParam sepaDebit) {
                this.sepaDebit = sepaDebit;
                return this;
            }

            public Builder setShopeepay(Shopeepay shopeepay) {
                this.shopeepay = shopeepay;
                return this;
            }

            public Builder setShopeepay(EmptyParam shopeepay) {
                this.shopeepay = shopeepay;
                return this;
            }

            public Builder setSofort(Sofort sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setSofort(EmptyParam sofort) {
                this.sofort = sofort;
                return this;
            }

            public Builder setStripeBalance(StripeBalance stripeBalance) {
                this.stripeBalance = stripeBalance;
                return this;
            }

            public Builder setStripeBalance(EmptyParam stripeBalance) {
                this.stripeBalance = stripeBalance;
                return this;
            }

            public Builder setSwish(Swish swish) {
                this.swish = swish;
                return this;
            }

            public Builder setSwish(EmptyParam swish) {
                this.swish = swish;
                return this;
            }

            public Builder setTwint(Twint twint) {
                this.twint = twint;
                return this;
            }

            public Builder setTwint(EmptyParam twint) {
                this.twint = twint;
                return this;
            }

            public Builder setUsBankAccount(UsBankAccount usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setUsBankAccount(EmptyParam usBankAccount) {
                this.usBankAccount = usBankAccount;
                return this;
            }

            public Builder setWechatPay(WechatPay wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setWechatPay(EmptyParam wechatPay) {
                this.wechatPay = wechatPay;
                return this;
            }

            public Builder setZip(Zip zip) {
                this.zip = zip;
                return this;
            }

            public Builder setZip(EmptyParam zip) {
                this.zip = zip;
                return this;
            }
        }

        public static class Zip {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Zip(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Zip)) {
                    return false;
                }
                Zip other = (Zip)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Zip;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Zip build() {
                    return new Zip(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class WechatPay {
            @SerializedName(value="app_id")
            String appId;
            @SerializedName(value="client")
            Client client;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private WechatPay(String appId, Client client, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.appId = appId;
                this.client = client;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getAppId() {
                return this.appId;
            }

            @Generated
            public Client getClient() {
                return this.client;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof WechatPay)) {
                    return false;
                }
                WechatPay other = (WechatPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$appId = this.getAppId();
                String other$appId = other.getAppId();
                if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
                    return false;
                }
                Client this$client = this.getClient();
                Client other$client = other.getClient();
                if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof WechatPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $appId = this.getAppId();
                result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
                Client $client = this.getClient();
                result = result * 59 + ($client == null ? 43 : $client.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum Client implements ApiRequestParams.EnumParam
            {
                ANDROID("android"),
                IOS("ios"),
                WEB("web");

                private final String value;

                private Client(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String appId;
                private Client client;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public WechatPay build() {
                    return new WechatPay(this.appId, this.client, this.extraParams, this.setupFutureUsage);
                }

                public Builder setAppId(String appId) {
                    this.appId = appId;
                    return this;
                }

                public Builder setClient(Client client) {
                    this.client = client;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class UsBankAccount {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="financial_connections")
            FinancialConnections financialConnections;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="networks")
            Networks networks;
            @SerializedName(value="preferred_settlement_speed")
            ApiRequestParams.EnumParam preferredSettlementSpeed;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="target_date")
            String targetDate;
            @SerializedName(value="verification_method")
            VerificationMethod verificationMethod;

            private UsBankAccount(Map<String, Object> extraParams, FinancialConnections financialConnections, MandateOptions mandateOptions, Networks networks, ApiRequestParams.EnumParam preferredSettlementSpeed, ApiRequestParams.EnumParam setupFutureUsage, String targetDate, VerificationMethod verificationMethod) {
                this.extraParams = extraParams;
                this.financialConnections = financialConnections;
                this.mandateOptions = mandateOptions;
                this.networks = networks;
                this.preferredSettlementSpeed = preferredSettlementSpeed;
                this.setupFutureUsage = setupFutureUsage;
                this.targetDate = targetDate;
                this.verificationMethod = verificationMethod;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public FinancialConnections getFinancialConnections() {
                return this.financialConnections;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public Networks getNetworks() {
                return this.networks;
            }

            @Generated
            public ApiRequestParams.EnumParam getPreferredSettlementSpeed() {
                return this.preferredSettlementSpeed;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getTargetDate() {
                return this.targetDate;
            }

            @Generated
            public VerificationMethod getVerificationMethod() {
                return this.verificationMethod;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof UsBankAccount)) {
                    return false;
                }
                UsBankAccount other = (UsBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                FinancialConnections this$financialConnections = this.getFinancialConnections();
                FinancialConnections other$financialConnections = other.getFinancialConnections();
                if (this$financialConnections == null ? other$financialConnections != null : !((Object)this$financialConnections).equals(other$financialConnections)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                Networks this$networks = this.getNetworks();
                Networks other$networks = other.getNetworks();
                if (this$networks == null ? other$networks != null : !((Object)this$networks).equals(other$networks)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$preferredSettlementSpeed = this.getPreferredSettlementSpeed();
                ApiRequestParams.EnumParam other$preferredSettlementSpeed = other.getPreferredSettlementSpeed();
                if (this$preferredSettlementSpeed == null ? other$preferredSettlementSpeed != null : !this$preferredSettlementSpeed.equals(other$preferredSettlementSpeed)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$targetDate = this.getTargetDate();
                String other$targetDate = other.getTargetDate();
                if (this$targetDate == null ? other$targetDate != null : !this$targetDate.equals(other$targetDate)) {
                    return false;
                }
                VerificationMethod this$verificationMethod = this.getVerificationMethod();
                VerificationMethod other$verificationMethod = other.getVerificationMethod();
                return !(this$verificationMethod == null ? other$verificationMethod != null : !this$verificationMethod.equals(other$verificationMethod));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof UsBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                FinancialConnections $financialConnections = this.getFinancialConnections();
                result = result * 59 + ($financialConnections == null ? 43 : ((Object)$financialConnections).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                Networks $networks = this.getNetworks();
                result = result * 59 + ($networks == null ? 43 : ((Object)$networks).hashCode());
                ApiRequestParams.EnumParam $preferredSettlementSpeed = this.getPreferredSettlementSpeed();
                result = result * 59 + ($preferredSettlementSpeed == null ? 43 : $preferredSettlementSpeed.hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $targetDate = this.getTargetDate();
                result = result * 59 + ($targetDate == null ? 43 : $targetDate.hashCode());
                VerificationMethod $verificationMethod = this.getVerificationMethod();
                result = result * 59 + ($verificationMethod == null ? 43 : $verificationMethod.hashCode());
                return result;
            }

            public static class FinancialConnections {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="filters")
                Filters filters;
                @SerializedName(value="manual_entry")
                ManualEntry manualEntry;
                @SerializedName(value="permissions")
                List<Permission> permissions;
                @SerializedName(value="prefetch")
                List<Prefetch> prefetch;
                @SerializedName(value="return_url")
                String returnUrl;

                private FinancialConnections(Map<String, Object> extraParams, Filters filters, ManualEntry manualEntry, List<Permission> permissions, List<Prefetch> prefetch, String returnUrl) {
                    this.extraParams = extraParams;
                    this.filters = filters;
                    this.manualEntry = manualEntry;
                    this.permissions = permissions;
                    this.prefetch = prefetch;
                    this.returnUrl = returnUrl;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Filters getFilters() {
                    return this.filters;
                }

                @Generated
                public ManualEntry getManualEntry() {
                    return this.manualEntry;
                }

                @Generated
                public List<Permission> getPermissions() {
                    return this.permissions;
                }

                @Generated
                public List<Prefetch> getPrefetch() {
                    return this.prefetch;
                }

                @Generated
                public String getReturnUrl() {
                    return this.returnUrl;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof FinancialConnections)) {
                        return false;
                    }
                    FinancialConnections other = (FinancialConnections)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Filters this$filters = this.getFilters();
                    Filters other$filters = other.getFilters();
                    if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                        return false;
                    }
                    ManualEntry this$manualEntry = this.getManualEntry();
                    ManualEntry other$manualEntry = other.getManualEntry();
                    if (this$manualEntry == null ? other$manualEntry != null : !((Object)this$manualEntry).equals(other$manualEntry)) {
                        return false;
                    }
                    List<Permission> this$permissions = this.getPermissions();
                    List<Permission> other$permissions = other.getPermissions();
                    if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
                        return false;
                    }
                    List<Prefetch> this$prefetch = this.getPrefetch();
                    List<Prefetch> other$prefetch = other.getPrefetch();
                    if (this$prefetch == null ? other$prefetch != null : !((Object)this$prefetch).equals(other$prefetch)) {
                        return false;
                    }
                    String this$returnUrl = this.getReturnUrl();
                    String other$returnUrl = other.getReturnUrl();
                    return !(this$returnUrl == null ? other$returnUrl != null : !this$returnUrl.equals(other$returnUrl));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof FinancialConnections;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Filters $filters = this.getFilters();
                    result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
                    ManualEntry $manualEntry = this.getManualEntry();
                    result = result * 59 + ($manualEntry == null ? 43 : ((Object)$manualEntry).hashCode());
                    List<Permission> $permissions = this.getPermissions();
                    result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
                    List<Prefetch> $prefetch = this.getPrefetch();
                    result = result * 59 + ($prefetch == null ? 43 : ((Object)$prefetch).hashCode());
                    String $returnUrl = this.getReturnUrl();
                    result = result * 59 + ($returnUrl == null ? 43 : $returnUrl.hashCode());
                    return result;
                }

                public static class Filters {
                    @SerializedName(value="account_subcategories")
                    List<AccountSubcategory> accountSubcategories;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="institution")
                    String institution;

                    private Filters(List<AccountSubcategory> accountSubcategories, Map<String, Object> extraParams, String institution) {
                        this.accountSubcategories = accountSubcategories;
                        this.extraParams = extraParams;
                        this.institution = institution;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public List<AccountSubcategory> getAccountSubcategories() {
                        return this.accountSubcategories;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public String getInstitution() {
                        return this.institution;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Filters)) {
                            return false;
                        }
                        Filters other = (Filters)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        List<AccountSubcategory> this$accountSubcategories = this.getAccountSubcategories();
                        List<AccountSubcategory> other$accountSubcategories = other.getAccountSubcategories();
                        if (this$accountSubcategories == null ? other$accountSubcategories != null : !((Object)this$accountSubcategories).equals(other$accountSubcategories)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        String this$institution = this.getInstitution();
                        String other$institution = other.getInstitution();
                        return !(this$institution == null ? other$institution != null : !this$institution.equals(other$institution));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Filters;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        List<AccountSubcategory> $accountSubcategories = this.getAccountSubcategories();
                        result = result * 59 + ($accountSubcategories == null ? 43 : ((Object)$accountSubcategories).hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        String $institution = this.getInstitution();
                        result = result * 59 + ($institution == null ? 43 : $institution.hashCode());
                        return result;
                    }

                    public static class Builder {
                        private List<AccountSubcategory> accountSubcategories;
                        private Map<String, Object> extraParams;
                        private String institution;

                        public Filters build() {
                            return new Filters(this.accountSubcategories, this.extraParams, this.institution);
                        }

                        public Builder addAccountSubcategory(AccountSubcategory element) {
                            if (this.accountSubcategories == null) {
                                this.accountSubcategories = new ArrayList<AccountSubcategory>();
                            }
                            this.accountSubcategories.add(element);
                            return this;
                        }

                        public Builder addAllAccountSubcategory(List<AccountSubcategory> elements) {
                            if (this.accountSubcategories == null) {
                                this.accountSubcategories = new ArrayList<AccountSubcategory>();
                            }
                            this.accountSubcategories.addAll(elements);
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setInstitution(String institution) {
                            this.institution = institution;
                            return this;
                        }
                    }

                    public static enum AccountSubcategory implements ApiRequestParams.EnumParam
                    {
                        CHECKING("checking"),
                        SAVINGS("savings");

                        private final String value;

                        private AccountSubcategory(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }
                }

                public static class ManualEntry {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="mode")
                    Mode mode;

                    private ManualEntry(Map<String, Object> extraParams, Mode mode) {
                        this.extraParams = extraParams;
                        this.mode = mode;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Mode getMode() {
                        return this.mode;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ManualEntry)) {
                            return false;
                        }
                        ManualEntry other = (ManualEntry)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        Mode this$mode = this.getMode();
                        Mode other$mode = other.getMode();
                        return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ManualEntry;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        Mode $mode = this.getMode();
                        result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
                        return result;
                    }

                    public static enum Mode implements ApiRequestParams.EnumParam
                    {
                        AUTOMATIC("automatic"),
                        CUSTOM("custom");

                        private final String value;

                        private Mode(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Mode mode;

                        public ManualEntry build() {
                            return new ManualEntry(this.extraParams, this.mode);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setMode(Mode mode) {
                            this.mode = mode;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Filters filters;
                    private ManualEntry manualEntry;
                    private List<Permission> permissions;
                    private List<Prefetch> prefetch;
                    private String returnUrl;

                    public FinancialConnections build() {
                        return new FinancialConnections(this.extraParams, this.filters, this.manualEntry, this.permissions, this.prefetch, this.returnUrl);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setFilters(Filters filters) {
                        this.filters = filters;
                        return this;
                    }

                    public Builder setManualEntry(ManualEntry manualEntry) {
                        this.manualEntry = manualEntry;
                        return this;
                    }

                    public Builder addPermission(Permission element) {
                        if (this.permissions == null) {
                            this.permissions = new ArrayList<Permission>();
                        }
                        this.permissions.add(element);
                        return this;
                    }

                    public Builder addAllPermission(List<Permission> elements) {
                        if (this.permissions == null) {
                            this.permissions = new ArrayList<Permission>();
                        }
                        this.permissions.addAll(elements);
                        return this;
                    }

                    public Builder addPrefetch(Prefetch element) {
                        if (this.prefetch == null) {
                            this.prefetch = new ArrayList<Prefetch>();
                        }
                        this.prefetch.add(element);
                        return this;
                    }

                    public Builder addAllPrefetch(List<Prefetch> elements) {
                        if (this.prefetch == null) {
                            this.prefetch = new ArrayList<Prefetch>();
                        }
                        this.prefetch.addAll(elements);
                        return this;
                    }

                    public Builder setReturnUrl(String returnUrl) {
                        this.returnUrl = returnUrl;
                        return this;
                    }
                }

                public static enum Prefetch implements ApiRequestParams.EnumParam
                {
                    BALANCES("balances"),
                    INFERRED_BALANCES("inferred_balances"),
                    OWNERSHIP("ownership"),
                    TRANSACTIONS("transactions");

                    private final String value;

                    private Prefetch(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum Permission implements ApiRequestParams.EnumParam
                {
                    BALANCES("balances"),
                    OWNERSHIP("ownership"),
                    PAYMENT_METHOD("payment_method"),
                    TRANSACTIONS("transactions");

                    private final String value;

                    private Permission(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static class MandateOptions {
                @SerializedName(value="collection_method")
                ApiRequestParams.EnumParam collectionMethod;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private MandateOptions(ApiRequestParams.EnumParam collectionMethod, Map<String, Object> extraParams) {
                    this.collectionMethod = collectionMethod;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public ApiRequestParams.EnumParam getCollectionMethod() {
                    return this.collectionMethod;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ApiRequestParams.EnumParam this$collectionMethod = this.getCollectionMethod();
                    ApiRequestParams.EnumParam other$collectionMethod = other.getCollectionMethod();
                    if (this$collectionMethod == null ? other$collectionMethod != null : !this$collectionMethod.equals(other$collectionMethod)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ApiRequestParams.EnumParam $collectionMethod = this.getCollectionMethod();
                    result = result * 59 + ($collectionMethod == null ? 43 : $collectionMethod.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class Builder {
                    private ApiRequestParams.EnumParam collectionMethod;
                    private Map<String, Object> extraParams;

                    public MandateOptions build() {
                        return new MandateOptions(this.collectionMethod, this.extraParams);
                    }

                    public Builder setCollectionMethod(CollectionMethod collectionMethod) {
                        this.collectionMethod = collectionMethod;
                        return this;
                    }

                    public Builder setCollectionMethod(EmptyParam collectionMethod) {
                        this.collectionMethod = collectionMethod;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }

                public static enum CollectionMethod implements ApiRequestParams.EnumParam
                {
                    PAPER("paper");

                    private final String value;

                    private CollectionMethod(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static class Networks {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="requested")
                List<Requested> requested;

                private Networks(Map<String, Object> extraParams, List<Requested> requested) {
                    this.extraParams = extraParams;
                    this.requested = requested;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public List<Requested> getRequested() {
                    return this.requested;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Networks)) {
                        return false;
                    }
                    Networks other = (Networks)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    List<Requested> this$requested = this.getRequested();
                    List<Requested> other$requested = other.getRequested();
                    return !(this$requested == null ? other$requested != null : !((Object)this$requested).equals(other$requested));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Networks;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    List<Requested> $requested = this.getRequested();
                    result = result * 59 + ($requested == null ? 43 : ((Object)$requested).hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private List<Requested> requested;

                    public Networks build() {
                        return new Networks(this.extraParams, this.requested);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder addRequested(Requested element) {
                        if (this.requested == null) {
                            this.requested = new ArrayList<Requested>();
                        }
                        this.requested.add(element);
                        return this;
                    }

                    public Builder addAllRequested(List<Requested> elements) {
                        if (this.requested == null) {
                            this.requested = new ArrayList<Requested>();
                        }
                        this.requested.addAll(elements);
                        return this;
                    }
                }

                public static enum Requested implements ApiRequestParams.EnumParam
                {
                    ACH("ach"),
                    US_DOMESTIC_WIRE("us_domestic_wire");

                    private final String value;

                    private Requested(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }
            }

            public static enum VerificationMethod implements ApiRequestParams.EnumParam
            {
                AUTOMATIC("automatic"),
                INSTANT("instant"),
                MICRODEPOSITS("microdeposits");

                private final String value;

                private VerificationMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private FinancialConnections financialConnections;
                private MandateOptions mandateOptions;
                private Networks networks;
                private ApiRequestParams.EnumParam preferredSettlementSpeed;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private String targetDate;
                private VerificationMethod verificationMethod;

                public UsBankAccount build() {
                    return new UsBankAccount(this.extraParams, this.financialConnections, this.mandateOptions, this.networks, this.preferredSettlementSpeed, this.setupFutureUsage, this.targetDate, this.verificationMethod);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setFinancialConnections(FinancialConnections financialConnections) {
                    this.financialConnections = financialConnections;
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setNetworks(Networks networks) {
                    this.networks = networks;
                    return this;
                }

                public Builder setPreferredSettlementSpeed(PreferredSettlementSpeed preferredSettlementSpeed) {
                    this.preferredSettlementSpeed = preferredSettlementSpeed;
                    return this;
                }

                public Builder setPreferredSettlementSpeed(EmptyParam preferredSettlementSpeed) {
                    this.preferredSettlementSpeed = preferredSettlementSpeed;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTargetDate(String targetDate) {
                    this.targetDate = targetDate;
                    return this;
                }

                public Builder setVerificationMethod(VerificationMethod verificationMethod) {
                    this.verificationMethod = verificationMethod;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum PreferredSettlementSpeed implements ApiRequestParams.EnumParam
            {
                FASTEST("fastest"),
                STANDARD("standard");

                private final String value;

                private PreferredSettlementSpeed(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Twint {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Twint(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Twint)) {
                    return false;
                }
                Twint other = (Twint)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Twint;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Twint build() {
                    return new Twint(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Swish {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="reference")
            Object reference;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Swish(Map<String, Object> extraParams, Object reference, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.reference = reference;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getReference() {
                return this.reference;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Swish)) {
                    return false;
                }
                Swish other = (Swish)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Object this$reference = this.getReference();
                Object other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Swish;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Object $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private Object reference;
                private SetupFutureUsage setupFutureUsage;

                public Swish build() {
                    return new Swish(this.extraParams, this.reference, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setReference(EmptyParam reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class StripeBalance {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private StripeBalance(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof StripeBalance)) {
                    return false;
                }
                StripeBalance other = (StripeBalance)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof StripeBalance;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public StripeBalance build() {
                    return new StripeBalance(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Sofort {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="preferred_language")
            ApiRequestParams.EnumParam preferredLanguage;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Sofort(Map<String, Object> extraParams, ApiRequestParams.EnumParam preferredLanguage, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.preferredLanguage = preferredLanguage;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getPreferredLanguage() {
                return this.preferredLanguage;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Sofort)) {
                    return false;
                }
                Sofort other = (Sofort)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$preferredLanguage = this.getPreferredLanguage();
                ApiRequestParams.EnumParam other$preferredLanguage = other.getPreferredLanguage();
                if (this$preferredLanguage == null ? other$preferredLanguage != null : !this$preferredLanguage.equals(other$preferredLanguage)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Sofort;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $preferredLanguage = this.getPreferredLanguage();
                result = result * 59 + ($preferredLanguage == null ? 43 : $preferredLanguage.hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam preferredLanguage;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Sofort build() {
                    return new Sofort(this.extraParams, this.preferredLanguage, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setPreferredLanguage(PreferredLanguage preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }

                public Builder setPreferredLanguage(EmptyParam preferredLanguage) {
                    this.preferredLanguage = preferredLanguage;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum PreferredLanguage implements ApiRequestParams.EnumParam
            {
                DE("de"),
                EN("en"),
                ES("es"),
                FR("fr"),
                IT("it"),
                NL("nl"),
                PL("pl");

                private final String value;

                private PreferredLanguage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Shopeepay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Shopeepay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Shopeepay)) {
                    return false;
                }
                Shopeepay other = (Shopeepay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Shopeepay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Shopeepay build() {
                    return new Shopeepay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class SepaDebit {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="target_date")
            String targetDate;

            private SepaDebit(Map<String, Object> extraParams, MandateOptions mandateOptions, ApiRequestParams.EnumParam setupFutureUsage, String targetDate) {
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.setupFutureUsage = setupFutureUsage;
                this.targetDate = targetDate;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getTargetDate() {
                return this.targetDate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SepaDebit)) {
                    return false;
                }
                SepaDebit other = (SepaDebit)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$targetDate = this.getTargetDate();
                String other$targetDate = other.getTargetDate();
                return !(this$targetDate == null ? other$targetDate != null : !this$targetDate.equals(other$targetDate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SepaDebit;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $targetDate = this.getTargetDate();
                result = result * 59 + ($targetDate == null ? 43 : $targetDate.hashCode());
                return result;
            }

            public static class MandateOptions {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="reference_prefix")
                Object referencePrefix;

                private MandateOptions(Map<String, Object> extraParams, Object referencePrefix) {
                    this.extraParams = extraParams;
                    this.referencePrefix = referencePrefix;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Object getReferencePrefix() {
                    return this.referencePrefix;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Object this$referencePrefix = this.getReferencePrefix();
                    Object other$referencePrefix = other.getReferencePrefix();
                    return !(this$referencePrefix == null ? other$referencePrefix != null : !this$referencePrefix.equals(other$referencePrefix));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Object $referencePrefix = this.getReferencePrefix();
                    result = result * 59 + ($referencePrefix == null ? 43 : $referencePrefix.hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Object referencePrefix;

                    public MandateOptions build() {
                        return new MandateOptions(this.extraParams, this.referencePrefix);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setReferencePrefix(String referencePrefix) {
                        this.referencePrefix = referencePrefix;
                        return this;
                    }

                    public Builder setReferencePrefix(EmptyParam referencePrefix) {
                        this.referencePrefix = referencePrefix;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private String targetDate;

                public SepaDebit build() {
                    return new SepaDebit(this.extraParams, this.mandateOptions, this.setupFutureUsage, this.targetDate);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTargetDate(String targetDate) {
                    this.targetDate = targetDate;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Satispay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Satispay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Satispay)) {
                    return false;
                }
                Satispay other = (Satispay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Satispay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;

                public Satispay build() {
                    return new Satispay(this.captureMethod, this.extraParams);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class SamsungPay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private SamsungPay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SamsungPay)) {
                    return false;
                }
                SamsungPay other = (SamsungPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SamsungPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;

                public SamsungPay build() {
                    return new SamsungPay(this.captureMethod, this.extraParams);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class RevolutPay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private RevolutPay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RevolutPay)) {
                    return false;
                }
                RevolutPay other = (RevolutPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RevolutPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public RevolutPay build() {
                    return new RevolutPay(this.captureMethod, this.extraParams, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Rechnung {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Rechnung(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Rechnung)) {
                    return false;
                }
                Rechnung other = (Rechnung)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Rechnung;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public Rechnung build() {
                    return new Rechnung(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Qris {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Qris(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Qris)) {
                    return false;
                }
                Qris other = (Qris)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Qris;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Qris build() {
                    return new Qris(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Promptpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Promptpay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Promptpay)) {
                    return false;
                }
                Promptpay other = (Promptpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Promptpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Promptpay build() {
                    return new Promptpay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Pix {
            @SerializedName(value="amount_includes_iof")
            AmountIncludesIof amountIncludesIof;
            @SerializedName(value="expires_after_seconds")
            Long expiresAfterSeconds;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Pix(AmountIncludesIof amountIncludesIof, Long expiresAfterSeconds, Long expiresAt, Map<String, Object> extraParams, MandateOptions mandateOptions, SetupFutureUsage setupFutureUsage) {
                this.amountIncludesIof = amountIncludesIof;
                this.expiresAfterSeconds = expiresAfterSeconds;
                this.expiresAt = expiresAt;
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public AmountIncludesIof getAmountIncludesIof() {
                return this.amountIncludesIof;
            }

            @Generated
            public Long getExpiresAfterSeconds() {
                return this.expiresAfterSeconds;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pix)) {
                    return false;
                }
                Pix other = (Pix)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterSeconds = this.getExpiresAfterSeconds();
                Long other$expiresAfterSeconds = other.getExpiresAfterSeconds();
                if (this$expiresAfterSeconds == null ? other$expiresAfterSeconds != null : !((Object)this$expiresAfterSeconds).equals(other$expiresAfterSeconds)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                AmountIncludesIof this$amountIncludesIof = this.getAmountIncludesIof();
                AmountIncludesIof other$amountIncludesIof = other.getAmountIncludesIof();
                if (this$amountIncludesIof == null ? other$amountIncludesIof != null : !this$amountIncludesIof.equals(other$amountIncludesIof)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pix;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterSeconds = this.getExpiresAfterSeconds();
                result = result * 59 + ($expiresAfterSeconds == null ? 43 : ((Object)$expiresAfterSeconds).hashCode());
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                AmountIncludesIof $amountIncludesIof = this.getAmountIncludesIof();
                result = result * 59 + ($amountIncludesIof == null ? 43 : $amountIncludesIof.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum AmountIncludesIof implements ApiRequestParams.EnumParam
            {
                ALWAYS("always"),
                NEVER("never");

                private final String value;

                private AmountIncludesIof(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class MandateOptions {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="amount_includes_iof")
                AmountIncludesIof amountIncludesIof;
                @SerializedName(value="amount_type")
                AmountType amountType;
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="end_date")
                String endDate;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="payment_schedule")
                PaymentSchedule paymentSchedule;
                @SerializedName(value="reference")
                String reference;
                @SerializedName(value="start_date")
                String startDate;

                private MandateOptions(Long amount, AmountIncludesIof amountIncludesIof, AmountType amountType, String currency, String endDate, Map<String, Object> extraParams, PaymentSchedule paymentSchedule, String reference, String startDate) {
                    this.amount = amount;
                    this.amountIncludesIof = amountIncludesIof;
                    this.amountType = amountType;
                    this.currency = currency;
                    this.endDate = endDate;
                    this.extraParams = extraParams;
                    this.paymentSchedule = paymentSchedule;
                    this.reference = reference;
                    this.startDate = startDate;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public AmountIncludesIof getAmountIncludesIof() {
                    return this.amountIncludesIof;
                }

                @Generated
                public AmountType getAmountType() {
                    return this.amountType;
                }

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public String getEndDate() {
                    return this.endDate;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public PaymentSchedule getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public String getReference() {
                    return this.reference;
                }

                @Generated
                public String getStartDate() {
                    return this.startDate;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    AmountIncludesIof this$amountIncludesIof = this.getAmountIncludesIof();
                    AmountIncludesIof other$amountIncludesIof = other.getAmountIncludesIof();
                    if (this$amountIncludesIof == null ? other$amountIncludesIof != null : !this$amountIncludesIof.equals(other$amountIncludesIof)) {
                        return false;
                    }
                    AmountType this$amountType = this.getAmountType();
                    AmountType other$amountType = other.getAmountType();
                    if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                        return false;
                    }
                    String this$endDate = this.getEndDate();
                    String other$endDate = other.getEndDate();
                    if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    PaymentSchedule this$paymentSchedule = this.getPaymentSchedule();
                    PaymentSchedule other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    String this$reference = this.getReference();
                    String other$reference = other.getReference();
                    if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                        return false;
                    }
                    String this$startDate = this.getStartDate();
                    String other$startDate = other.getStartDate();
                    return !(this$startDate == null ? other$startDate != null : !this$startDate.equals(other$startDate));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    AmountIncludesIof $amountIncludesIof = this.getAmountIncludesIof();
                    result = result * 59 + ($amountIncludesIof == null ? 43 : $amountIncludesIof.hashCode());
                    AmountType $amountType = this.getAmountType();
                    result = result * 59 + ($amountType == null ? 43 : $amountType.hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    String $endDate = this.getEndDate();
                    result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    PaymentSchedule $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    String $reference = this.getReference();
                    result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                    String $startDate = this.getStartDate();
                    result = result * 59 + ($startDate == null ? 43 : $startDate.hashCode());
                    return result;
                }

                public static enum AmountIncludesIof implements ApiRequestParams.EnumParam
                {
                    ALWAYS("always"),
                    NEVER("never");

                    private final String value;

                    private AmountIncludesIof(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum AmountType implements ApiRequestParams.EnumParam
                {
                    FIXED("fixed"),
                    MAXIMUM("maximum");

                    private final String value;

                    private AmountType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum PaymentSchedule implements ApiRequestParams.EnumParam
                {
                    HALFYEARLY("halfyearly"),
                    MONTHLY("monthly"),
                    QUARTERLY("quarterly"),
                    WEEKLY("weekly"),
                    YEARLY("yearly");

                    private final String value;

                    private PaymentSchedule(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long amount;
                    private AmountIncludesIof amountIncludesIof;
                    private AmountType amountType;
                    private String currency;
                    private String endDate;
                    private Map<String, Object> extraParams;
                    private PaymentSchedule paymentSchedule;
                    private String reference;
                    private String startDate;

                    public MandateOptions build() {
                        return new MandateOptions(this.amount, this.amountIncludesIof, this.amountType, this.currency, this.endDate, this.extraParams, this.paymentSchedule, this.reference, this.startDate);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder setAmountIncludesIof(AmountIncludesIof amountIncludesIof) {
                        this.amountIncludesIof = amountIncludesIof;
                        return this;
                    }

                    public Builder setAmountType(AmountType amountType) {
                        this.amountType = amountType;
                        return this;
                    }

                    public Builder setCurrency(String currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder setEndDate(String endDate) {
                        this.endDate = endDate;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPaymentSchedule(PaymentSchedule paymentSchedule) {
                        this.paymentSchedule = paymentSchedule;
                        return this;
                    }

                    public Builder setReference(String reference) {
                        this.reference = reference;
                        return this;
                    }

                    public Builder setStartDate(String startDate) {
                        this.startDate = startDate;
                        return this;
                    }
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private AmountIncludesIof amountIncludesIof;
                private Long expiresAfterSeconds;
                private Long expiresAt;
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private SetupFutureUsage setupFutureUsage;

                public Pix build() {
                    return new Pix(this.amountIncludesIof, this.expiresAfterSeconds, this.expiresAt, this.extraParams, this.mandateOptions, this.setupFutureUsage);
                }

                public Builder setAmountIncludesIof(AmountIncludesIof amountIncludesIof) {
                    this.amountIncludesIof = amountIncludesIof;
                    return this;
                }

                public Builder setExpiresAfterSeconds(Long expiresAfterSeconds) {
                    this.expiresAfterSeconds = expiresAfterSeconds;
                    return this;
                }

                public Builder setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Payto {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="mandate_options")
            MandateOptions mandateOptions;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Payto(Map<String, Object> extraParams, MandateOptions mandateOptions, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.mandateOptions = mandateOptions;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public MandateOptions getMandateOptions() {
                return this.mandateOptions;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payto)) {
                    return false;
                }
                Payto other = (Payto)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                MandateOptions this$mandateOptions = this.getMandateOptions();
                MandateOptions other$mandateOptions = other.getMandateOptions();
                if (this$mandateOptions == null ? other$mandateOptions != null : !((Object)this$mandateOptions).equals(other$mandateOptions)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payto;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                MandateOptions $mandateOptions = this.getMandateOptions();
                result = result * 59 + ($mandateOptions == null ? 43 : ((Object)$mandateOptions).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class MandateOptions {
                @SerializedName(value="amount")
                Long amount;
                @SerializedName(value="amount_type")
                AmountType amountType;
                @SerializedName(value="end_date")
                String endDate;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="payment_schedule")
                PaymentSchedule paymentSchedule;
                @SerializedName(value="payments_per_period")
                Long paymentsPerPeriod;
                @SerializedName(value="purpose")
                Purpose purpose;

                private MandateOptions(Long amount, AmountType amountType, String endDate, Map<String, Object> extraParams, PaymentSchedule paymentSchedule, Long paymentsPerPeriod, Purpose purpose) {
                    this.amount = amount;
                    this.amountType = amountType;
                    this.endDate = endDate;
                    this.extraParams = extraParams;
                    this.paymentSchedule = paymentSchedule;
                    this.paymentsPerPeriod = paymentsPerPeriod;
                    this.purpose = purpose;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAmount() {
                    return this.amount;
                }

                @Generated
                public AmountType getAmountType() {
                    return this.amountType;
                }

                @Generated
                public String getEndDate() {
                    return this.endDate;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public PaymentSchedule getPaymentSchedule() {
                    return this.paymentSchedule;
                }

                @Generated
                public Long getPaymentsPerPeriod() {
                    return this.paymentsPerPeriod;
                }

                @Generated
                public Purpose getPurpose() {
                    return this.purpose;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof MandateOptions)) {
                        return false;
                    }
                    MandateOptions other = (MandateOptions)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$amount = this.getAmount();
                    Long other$amount = other.getAmount();
                    if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                        return false;
                    }
                    Long this$paymentsPerPeriod = this.getPaymentsPerPeriod();
                    Long other$paymentsPerPeriod = other.getPaymentsPerPeriod();
                    if (this$paymentsPerPeriod == null ? other$paymentsPerPeriod != null : !((Object)this$paymentsPerPeriod).equals(other$paymentsPerPeriod)) {
                        return false;
                    }
                    AmountType this$amountType = this.getAmountType();
                    AmountType other$amountType = other.getAmountType();
                    if (this$amountType == null ? other$amountType != null : !this$amountType.equals(other$amountType)) {
                        return false;
                    }
                    String this$endDate = this.getEndDate();
                    String other$endDate = other.getEndDate();
                    if (this$endDate == null ? other$endDate != null : !this$endDate.equals(other$endDate)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    PaymentSchedule this$paymentSchedule = this.getPaymentSchedule();
                    PaymentSchedule other$paymentSchedule = other.getPaymentSchedule();
                    if (this$paymentSchedule == null ? other$paymentSchedule != null : !this$paymentSchedule.equals(other$paymentSchedule)) {
                        return false;
                    }
                    Purpose this$purpose = this.getPurpose();
                    Purpose other$purpose = other.getPurpose();
                    return !(this$purpose == null ? other$purpose != null : !this$purpose.equals(other$purpose));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof MandateOptions;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $amount = this.getAmount();
                    result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                    Long $paymentsPerPeriod = this.getPaymentsPerPeriod();
                    result = result * 59 + ($paymentsPerPeriod == null ? 43 : ((Object)$paymentsPerPeriod).hashCode());
                    AmountType $amountType = this.getAmountType();
                    result = result * 59 + ($amountType == null ? 43 : $amountType.hashCode());
                    String $endDate = this.getEndDate();
                    result = result * 59 + ($endDate == null ? 43 : $endDate.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    PaymentSchedule $paymentSchedule = this.getPaymentSchedule();
                    result = result * 59 + ($paymentSchedule == null ? 43 : $paymentSchedule.hashCode());
                    Purpose $purpose = this.getPurpose();
                    result = result * 59 + ($purpose == null ? 43 : $purpose.hashCode());
                    return result;
                }

                public static enum AmountType implements ApiRequestParams.EnumParam
                {
                    FIXED("fixed"),
                    MAXIMUM("maximum");

                    private final String value;

                    private AmountType(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum PaymentSchedule implements ApiRequestParams.EnumParam
                {
                    ADHOC("adhoc"),
                    ANNUAL("annual"),
                    DAILY("daily"),
                    FORTNIGHTLY("fortnightly"),
                    MONTHLY("monthly"),
                    QUARTERLY("quarterly"),
                    SEMI_ANNUAL("semi_annual"),
                    WEEKLY("weekly");

                    private final String value;

                    private PaymentSchedule(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static enum Purpose implements ApiRequestParams.EnumParam
                {
                    DEPENDANT_SUPPORT("dependant_support"),
                    GOVERNMENT("government"),
                    LOAN("loan"),
                    MORTGAGE("mortgage"),
                    OTHER("other"),
                    PENSION("pension"),
                    PERSONAL("personal"),
                    RETAIL("retail"),
                    SALARY("salary"),
                    TAX("tax"),
                    UTILITY("utility");

                    private final String value;

                    private Purpose(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long amount;
                    private AmountType amountType;
                    private String endDate;
                    private Map<String, Object> extraParams;
                    private PaymentSchedule paymentSchedule;
                    private Long paymentsPerPeriod;
                    private Purpose purpose;

                    public MandateOptions build() {
                        return new MandateOptions(this.amount, this.amountType, this.endDate, this.extraParams, this.paymentSchedule, this.paymentsPerPeriod, this.purpose);
                    }

                    public Builder setAmount(Long amount) {
                        this.amount = amount;
                        return this;
                    }

                    public Builder setAmountType(AmountType amountType) {
                        this.amountType = amountType;
                        return this;
                    }

                    public Builder setEndDate(String endDate) {
                        this.endDate = endDate;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setPaymentSchedule(PaymentSchedule paymentSchedule) {
                        this.paymentSchedule = paymentSchedule;
                        return this;
                    }

                    public Builder setPaymentsPerPeriod(Long paymentsPerPeriod) {
                        this.paymentsPerPeriod = paymentsPerPeriod;
                        return this;
                    }

                    public Builder setPurpose(Purpose purpose) {
                        this.purpose = purpose;
                        return this;
                    }
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private MandateOptions mandateOptions;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Payto build() {
                    return new Payto(this.extraParams, this.mandateOptions, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMandateOptions(MandateOptions mandateOptions) {
                    this.mandateOptions = mandateOptions;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Paypay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Paypay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypay)) {
                    return false;
                }
                Paypay other = (Paypay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;

                public Paypay build() {
                    return new Paypay(this.captureMethod, this.extraParams);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Paypal {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="line_items")
            List<LineItem> lineItems;
            @SerializedName(value="preferred_locale")
            PreferredLocale preferredLocale;
            @SerializedName(value="reference")
            String reference;
            @SerializedName(value="reference_id")
            String referenceId;
            @SerializedName(value="risk_correlation_id")
            String riskCorrelationId;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="subsellers")
            List<String> subsellers;

            private Paypal(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, List<LineItem> lineItems, PreferredLocale preferredLocale, String reference, String referenceId, String riskCorrelationId, ApiRequestParams.EnumParam setupFutureUsage, List<String> subsellers) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.lineItems = lineItems;
                this.preferredLocale = preferredLocale;
                this.reference = reference;
                this.referenceId = referenceId;
                this.riskCorrelationId = riskCorrelationId;
                this.setupFutureUsage = setupFutureUsage;
                this.subsellers = subsellers;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public List<LineItem> getLineItems() {
                return this.lineItems;
            }

            @Generated
            public PreferredLocale getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public String getReference() {
                return this.reference;
            }

            @Generated
            public String getReferenceId() {
                return this.referenceId;
            }

            @Generated
            public String getRiskCorrelationId() {
                return this.riskCorrelationId;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public List<String> getSubsellers() {
                return this.subsellers;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paypal)) {
                    return false;
                }
                Paypal other = (Paypal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                List<LineItem> this$lineItems = this.getLineItems();
                List<LineItem> other$lineItems = other.getLineItems();
                if (this$lineItems == null ? other$lineItems != null : !((Object)this$lineItems).equals(other$lineItems)) {
                    return false;
                }
                PreferredLocale this$preferredLocale = this.getPreferredLocale();
                PreferredLocale other$preferredLocale = other.getPreferredLocale();
                if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                    return false;
                }
                String this$reference = this.getReference();
                String other$reference = other.getReference();
                if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
                    return false;
                }
                String this$referenceId = this.getReferenceId();
                String other$referenceId = other.getReferenceId();
                if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) {
                    return false;
                }
                String this$riskCorrelationId = this.getRiskCorrelationId();
                String other$riskCorrelationId = other.getRiskCorrelationId();
                if (this$riskCorrelationId == null ? other$riskCorrelationId != null : !this$riskCorrelationId.equals(other$riskCorrelationId)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                List<String> this$subsellers = this.getSubsellers();
                List<String> other$subsellers = other.getSubsellers();
                return !(this$subsellers == null ? other$subsellers != null : !((Object)this$subsellers).equals(other$subsellers));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paypal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                List<LineItem> $lineItems = this.getLineItems();
                result = result * 59 + ($lineItems == null ? 43 : ((Object)$lineItems).hashCode());
                PreferredLocale $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                String $reference = this.getReference();
                result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                String $referenceId = this.getReferenceId();
                result = result * 59 + ($referenceId == null ? 43 : $referenceId.hashCode());
                String $riskCorrelationId = this.getRiskCorrelationId();
                result = result * 59 + ($riskCorrelationId == null ? 43 : $riskCorrelationId.hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                List<String> $subsellers = this.getSubsellers();
                result = result * 59 + ($subsellers == null ? 43 : ((Object)$subsellers).hashCode());
                return result;
            }

            public static enum PreferredLocale implements ApiRequestParams.EnumParam
            {
                CS_CZ("cs-CZ"),
                DA_DK("da-DK"),
                DE_AT("de-AT"),
                DE_DE("de-DE"),
                DE_LU("de-LU"),
                EL_GR("el-GR"),
                EN_GB("en-GB"),
                EN_US("en-US"),
                ES_ES("es-ES"),
                FI_FI("fi-FI"),
                FR_BE("fr-BE"),
                FR_FR("fr-FR"),
                FR_LU("fr-LU"),
                HU_HU("hu-HU"),
                IT_IT("it-IT"),
                NL_BE("nl-BE"),
                NL_NL("nl-NL"),
                PL_PL("pl-PL"),
                PT_PT("pt-PT"),
                SK_SK("sk-SK"),
                SV_SE("sv-SE");

                private final String value;

                private PreferredLocale(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private List<LineItem> lineItems;
                private PreferredLocale preferredLocale;
                private String reference;
                private String referenceId;
                private String riskCorrelationId;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private List<String> subsellers;

                public Paypal build() {
                    return new Paypal(this.captureMethod, this.extraParams, this.lineItems, this.preferredLocale, this.reference, this.referenceId, this.riskCorrelationId, this.setupFutureUsage, this.subsellers);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder addLineItem(LineItem element) {
                    if (this.lineItems == null) {
                        this.lineItems = new ArrayList<LineItem>();
                    }
                    this.lineItems.add(element);
                    return this;
                }

                public Builder addAllLineItem(List<LineItem> elements) {
                    if (this.lineItems == null) {
                        this.lineItems = new ArrayList<LineItem>();
                    }
                    this.lineItems.addAll(elements);
                    return this;
                }

                public Builder setPreferredLocale(PreferredLocale preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }

                public Builder setReference(String reference) {
                    this.reference = reference;
                    return this;
                }

                public Builder setReferenceId(String referenceId) {
                    this.referenceId = referenceId;
                    return this;
                }

                public Builder setRiskCorrelationId(String riskCorrelationId) {
                    this.riskCorrelationId = riskCorrelationId;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder addSubseller(String element) {
                    if (this.subsellers == null) {
                        this.subsellers = new ArrayList<String>();
                    }
                    this.subsellers.add(element);
                    return this;
                }

                public Builder addAllSubseller(List<String> elements) {
                    if (this.subsellers == null) {
                        this.subsellers = new ArrayList<String>();
                    }
                    this.subsellers.addAll(elements);
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class LineItem {
                @SerializedName(value="category")
                Category category;
                @SerializedName(value="description")
                String description;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="quantity")
                Long quantity;
                @SerializedName(value="sku")
                String sku;
                @SerializedName(value="sold_by")
                String soldBy;
                @SerializedName(value="tax")
                Tax tax;
                @SerializedName(value="unit_amount")
                Long unitAmount;

                private LineItem(Category category, String description, Map<String, Object> extraParams, String name, Long quantity, String sku, String soldBy, Tax tax, Long unitAmount) {
                    this.category = category;
                    this.description = description;
                    this.extraParams = extraParams;
                    this.name = name;
                    this.quantity = quantity;
                    this.sku = sku;
                    this.soldBy = soldBy;
                    this.tax = tax;
                    this.unitAmount = unitAmount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Category getCategory() {
                    return this.category;
                }

                @Generated
                public String getDescription() {
                    return this.description;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public Long getQuantity() {
                    return this.quantity;
                }

                @Generated
                public String getSku() {
                    return this.sku;
                }

                @Generated
                public String getSoldBy() {
                    return this.soldBy;
                }

                @Generated
                public Tax getTax() {
                    return this.tax;
                }

                @Generated
                public Long getUnitAmount() {
                    return this.unitAmount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof LineItem)) {
                        return false;
                    }
                    LineItem other = (LineItem)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$quantity = this.getQuantity();
                    Long other$quantity = other.getQuantity();
                    if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                        return false;
                    }
                    Long this$unitAmount = this.getUnitAmount();
                    Long other$unitAmount = other.getUnitAmount();
                    if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                        return false;
                    }
                    Category this$category = this.getCategory();
                    Category other$category = other.getCategory();
                    if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
                        return false;
                    }
                    String this$description = this.getDescription();
                    String other$description = other.getDescription();
                    if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    String this$sku = this.getSku();
                    String other$sku = other.getSku();
                    if (this$sku == null ? other$sku != null : !this$sku.equals(other$sku)) {
                        return false;
                    }
                    String this$soldBy = this.getSoldBy();
                    String other$soldBy = other.getSoldBy();
                    if (this$soldBy == null ? other$soldBy != null : !this$soldBy.equals(other$soldBy)) {
                        return false;
                    }
                    Tax this$tax = this.getTax();
                    Tax other$tax = other.getTax();
                    return !(this$tax == null ? other$tax != null : !((Object)this$tax).equals(other$tax));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof LineItem;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $quantity = this.getQuantity();
                    result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
                    Long $unitAmount = this.getUnitAmount();
                    result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
                    Category $category = this.getCategory();
                    result = result * 59 + ($category == null ? 43 : $category.hashCode());
                    String $description = this.getDescription();
                    result = result * 59 + ($description == null ? 43 : $description.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    String $sku = this.getSku();
                    result = result * 59 + ($sku == null ? 43 : $sku.hashCode());
                    String $soldBy = this.getSoldBy();
                    result = result * 59 + ($soldBy == null ? 43 : $soldBy.hashCode());
                    Tax $tax = this.getTax();
                    result = result * 59 + ($tax == null ? 43 : ((Object)$tax).hashCode());
                    return result;
                }

                public static enum Category implements ApiRequestParams.EnumParam
                {
                    DIGITAL_GOODS("digital_goods"),
                    DONATION("donation"),
                    PHYSICAL_GOODS("physical_goods");

                    private final String value;

                    private Category(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Tax {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="behavior")
                    Behavior behavior;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private Tax(Long amount, Behavior behavior, Map<String, Object> extraParams) {
                        this.amount = amount;
                        this.behavior = behavior;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public Behavior getBehavior() {
                        return this.behavior;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof Tax)) {
                            return false;
                        }
                        Tax other = (Tax)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$amount = this.getAmount();
                        Long other$amount = other.getAmount();
                        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                            return false;
                        }
                        Behavior this$behavior = this.getBehavior();
                        Behavior other$behavior = other.getBehavior();
                        if (this$behavior == null ? other$behavior != null : !this$behavior.equals(other$behavior)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof Tax;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $amount = this.getAmount();
                        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                        Behavior $behavior = this.getBehavior();
                        result = result * 59 + ($behavior == null ? 43 : $behavior.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        return result;
                    }

                    public static enum Behavior implements ApiRequestParams.EnumParam
                    {
                        EXCLUSIVE("exclusive"),
                        INCLUSIVE("inclusive");

                        private final String value;

                        private Behavior(String value) {
                            this.value = value;
                        }

                        @Override
                        @Generated
                        public String getValue() {
                            return this.value;
                        }
                    }

                    public static class Builder {
                        private Long amount;
                        private Behavior behavior;
                        private Map<String, Object> extraParams;

                        public Tax build() {
                            return new Tax(this.amount, this.behavior, this.extraParams);
                        }

                        public Builder setAmount(Long amount) {
                            this.amount = amount;
                            return this;
                        }

                        public Builder setBehavior(Behavior behavior) {
                            this.behavior = behavior;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Category category;
                    private String description;
                    private Map<String, Object> extraParams;
                    private String name;
                    private Long quantity;
                    private String sku;
                    private String soldBy;
                    private Tax tax;
                    private Long unitAmount;

                    public LineItem build() {
                        return new LineItem(this.category, this.description, this.extraParams, this.name, this.quantity, this.sku, this.soldBy, this.tax, this.unitAmount);
                    }

                    public Builder setCategory(Category category) {
                        this.category = category;
                        return this;
                    }

                    public Builder setDescription(String description) {
                        this.description = description;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setQuantity(Long quantity) {
                        this.quantity = quantity;
                        return this;
                    }

                    public Builder setSku(String sku) {
                        this.sku = sku;
                        return this;
                    }

                    public Builder setSoldBy(String soldBy) {
                        this.soldBy = soldBy;
                        return this;
                    }

                    public Builder setTax(Tax tax) {
                        this.tax = tax;
                        return this;
                    }

                    public Builder setUnitAmount(Long unitAmount) {
                        this.unitAmount = unitAmount;
                        return this;
                    }
                }
            }
        }

        public static class Paynow {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Paynow(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Paynow)) {
                    return false;
                }
                Paynow other = (Paynow)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Paynow;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Paynow build() {
                    return new Paynow(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Payco {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private Payco(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Payco)) {
                    return false;
                }
                Payco other = (Payco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Payco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;

                public Payco build() {
                    return new Payco(this.captureMethod, this.extraParams);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class PayByBank {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private PayByBank(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PayByBank)) {
                    return false;
                }
                PayByBank other = (PayByBank)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PayByBank;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public PayByBank build() {
                    return new PayByBank(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class P24 {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="tos_shown_and_accepted")
            Boolean tosShownAndAccepted;

            private P24(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage, Boolean tosShownAndAccepted) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
                this.tosShownAndAccepted = tosShownAndAccepted;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public Boolean getTosShownAndAccepted() {
                return this.tosShownAndAccepted;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof P24)) {
                    return false;
                }
                P24 other = (P24)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$tosShownAndAccepted = this.getTosShownAndAccepted();
                Boolean other$tosShownAndAccepted = other.getTosShownAndAccepted();
                if (this$tosShownAndAccepted == null ? other$tosShownAndAccepted != null : !((Object)this$tosShownAndAccepted).equals(other$tosShownAndAccepted)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof P24;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $tosShownAndAccepted = this.getTosShownAndAccepted();
                result = result * 59 + ($tosShownAndAccepted == null ? 43 : ((Object)$tosShownAndAccepted).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;
                private Boolean tosShownAndAccepted;

                public P24 build() {
                    return new P24(this.extraParams, this.setupFutureUsage, this.tosShownAndAccepted);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTosShownAndAccepted(Boolean tosShownAndAccepted) {
                    this.tosShownAndAccepted = tosShownAndAccepted;
                    return this;
                }
            }
        }

        public static class Oxxo {
            @SerializedName(value="expires_after_days")
            Long expiresAfterDays;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Oxxo(Long expiresAfterDays, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfterDays = expiresAfterDays;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Oxxo)) {
                    return false;
                }
                Oxxo other = (Oxxo)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfterDays = this.getExpiresAfterDays();
                Long other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !((Object)this$expiresAfterDays).equals(other$expiresAfterDays)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Oxxo;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : ((Object)$expiresAfterDays).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Long expiresAfterDays;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Oxxo build() {
                    return new Oxxo(this.expiresAfterDays, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class NzBankAccount {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;
            @SerializedName(value="target_date")
            String targetDate;

            private NzBankAccount(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage, String targetDate) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
                this.targetDate = targetDate;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public String getTargetDate() {
                return this.targetDate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NzBankAccount)) {
                    return false;
                }
                NzBankAccount other = (NzBankAccount)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                String this$targetDate = this.getTargetDate();
                String other$targetDate = other.getTargetDate();
                return !(this$targetDate == null ? other$targetDate != null : !this$targetDate.equals(other$targetDate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NzBankAccount;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                String $targetDate = this.getTargetDate();
                result = result * 59 + ($targetDate == null ? 43 : $targetDate.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;
                private String targetDate;

                public NzBankAccount build() {
                    return new NzBankAccount(this.extraParams, this.setupFutureUsage, this.targetDate);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setTargetDate(String targetDate) {
                    this.targetDate = targetDate;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class NaverPay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private NaverPay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NaverPay)) {
                    return false;
                }
                NaverPay other = (NaverPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NaverPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public NaverPay build() {
                    return new NaverPay(this.captureMethod, this.extraParams, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Multibanco {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Multibanco(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Multibanco)) {
                    return false;
                }
                Multibanco other = (Multibanco)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Multibanco;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Multibanco build() {
                    return new Multibanco(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Mobilepay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Mobilepay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Mobilepay)) {
                    return false;
                }
                Mobilepay other = (Mobilepay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Mobilepay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Mobilepay build() {
                    return new Mobilepay(this.captureMethod, this.extraParams, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class MbWay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private MbWay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MbWay)) {
                    return false;
                }
                MbWay other = (MbWay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof MbWay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public MbWay build() {
                    return new MbWay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Link {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="persistent_token")
            @Deprecated
            String persistentToken;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Link(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, String persistentToken, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.persistentToken = persistentToken;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Deprecated
            @Generated
            public String getPersistentToken() {
                return this.persistentToken;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Link)) {
                    return false;
                }
                Link other = (Link)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                String this$persistentToken = this.getPersistentToken();
                String other$persistentToken = other.getPersistentToken();
                if (this$persistentToken == null ? other$persistentToken != null : !this$persistentToken.equals(other$persistentToken)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Link;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                String $persistentToken = this.getPersistentToken();
                result = result * 59 + ($persistentToken == null ? 43 : $persistentToken.hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private String persistentToken;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Link build() {
                    return new Link(this.captureMethod, this.extraParams, this.persistentToken, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                @Deprecated
                public Builder setPersistentToken(String persistentToken) {
                    this.persistentToken = persistentToken;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class KrCard {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private KrCard(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KrCard)) {
                    return false;
                }
                KrCard other = (KrCard)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KrCard;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public KrCard build() {
                    return new KrCard(this.captureMethod, this.extraParams, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class Konbini {
            @SerializedName(value="confirmation_number")
            Object confirmationNumber;
            @SerializedName(value="expires_after_days")
            Object expiresAfterDays;
            @SerializedName(value="expires_at")
            Object expiresAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="product_description")
            Object productDescription;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Konbini(Object confirmationNumber, Object expiresAfterDays, Object expiresAt, Map<String, Object> extraParams, Object productDescription, SetupFutureUsage setupFutureUsage) {
                this.confirmationNumber = confirmationNumber;
                this.expiresAfterDays = expiresAfterDays;
                this.expiresAt = expiresAt;
                this.extraParams = extraParams;
                this.productDescription = productDescription;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Object getConfirmationNumber() {
                return this.confirmationNumber;
            }

            @Generated
            public Object getExpiresAfterDays() {
                return this.expiresAfterDays;
            }

            @Generated
            public Object getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Object getProductDescription() {
                return this.productDescription;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Konbini)) {
                    return false;
                }
                Konbini other = (Konbini)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$confirmationNumber = this.getConfirmationNumber();
                Object other$confirmationNumber = other.getConfirmationNumber();
                if (this$confirmationNumber == null ? other$confirmationNumber != null : !this$confirmationNumber.equals(other$confirmationNumber)) {
                    return false;
                }
                Object this$expiresAfterDays = this.getExpiresAfterDays();
                Object other$expiresAfterDays = other.getExpiresAfterDays();
                if (this$expiresAfterDays == null ? other$expiresAfterDays != null : !this$expiresAfterDays.equals(other$expiresAfterDays)) {
                    return false;
                }
                Object this$expiresAt = this.getExpiresAt();
                Object other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !this$expiresAt.equals(other$expiresAt)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Object this$productDescription = this.getProductDescription();
                Object other$productDescription = other.getProductDescription();
                if (this$productDescription == null ? other$productDescription != null : !this$productDescription.equals(other$productDescription)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Konbini;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $confirmationNumber = this.getConfirmationNumber();
                result = result * 59 + ($confirmationNumber == null ? 43 : $confirmationNumber.hashCode());
                Object $expiresAfterDays = this.getExpiresAfterDays();
                result = result * 59 + ($expiresAfterDays == null ? 43 : $expiresAfterDays.hashCode());
                Object $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : $expiresAt.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Object $productDescription = this.getProductDescription();
                result = result * 59 + ($productDescription == null ? 43 : $productDescription.hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Object confirmationNumber;
                private Object expiresAfterDays;
                private Object expiresAt;
                private Map<String, Object> extraParams;
                private Object productDescription;
                private SetupFutureUsage setupFutureUsage;

                public Konbini build() {
                    return new Konbini(this.confirmationNumber, this.expiresAfterDays, this.expiresAt, this.extraParams, this.productDescription, this.setupFutureUsage);
                }

                public Builder setConfirmationNumber(String confirmationNumber) {
                    this.confirmationNumber = confirmationNumber;
                    return this;
                }

                public Builder setConfirmationNumber(EmptyParam confirmationNumber) {
                    this.confirmationNumber = confirmationNumber;
                    return this;
                }

                public Builder setExpiresAfterDays(Long expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder setExpiresAfterDays(EmptyParam expiresAfterDays) {
                    this.expiresAfterDays = expiresAfterDays;
                    return this;
                }

                public Builder setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder setExpiresAt(EmptyParam expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setProductDescription(String productDescription) {
                    this.productDescription = productDescription;
                    return this;
                }

                public Builder setProductDescription(EmptyParam productDescription) {
                    this.productDescription = productDescription;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Klarna {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="on_demand")
            OnDemand onDemand;
            @SerializedName(value="preferred_locale")
            PreferredLocale preferredLocale;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;
            @SerializedName(value="subscriptions")
            Object subscriptions;

            private Klarna(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, OnDemand onDemand, PreferredLocale preferredLocale, SetupFutureUsage setupFutureUsage, Object subscriptions) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.onDemand = onDemand;
                this.preferredLocale = preferredLocale;
                this.setupFutureUsage = setupFutureUsage;
                this.subscriptions = subscriptions;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public OnDemand getOnDemand() {
                return this.onDemand;
            }

            @Generated
            public PreferredLocale getPreferredLocale() {
                return this.preferredLocale;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public Object getSubscriptions() {
                return this.subscriptions;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Klarna)) {
                    return false;
                }
                Klarna other = (Klarna)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                OnDemand this$onDemand = this.getOnDemand();
                OnDemand other$onDemand = other.getOnDemand();
                if (this$onDemand == null ? other$onDemand != null : !((Object)this$onDemand).equals(other$onDemand)) {
                    return false;
                }
                PreferredLocale this$preferredLocale = this.getPreferredLocale();
                PreferredLocale other$preferredLocale = other.getPreferredLocale();
                if (this$preferredLocale == null ? other$preferredLocale != null : !this$preferredLocale.equals(other$preferredLocale)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
                    return false;
                }
                Object this$subscriptions = this.getSubscriptions();
                Object other$subscriptions = other.getSubscriptions();
                return !(this$subscriptions == null ? other$subscriptions != null : !this$subscriptions.equals(other$subscriptions));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Klarna;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                OnDemand $onDemand = this.getOnDemand();
                result = result * 59 + ($onDemand == null ? 43 : ((Object)$onDemand).hashCode());
                PreferredLocale $preferredLocale = this.getPreferredLocale();
                result = result * 59 + ($preferredLocale == null ? 43 : $preferredLocale.hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                Object $subscriptions = this.getSubscriptions();
                result = result * 59 + ($subscriptions == null ? 43 : $subscriptions.hashCode());
                return result;
            }

            public static class OnDemand {
                @SerializedName(value="average_amount")
                Long averageAmount;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="maximum_amount")
                Long maximumAmount;
                @SerializedName(value="minimum_amount")
                Long minimumAmount;
                @SerializedName(value="purchase_interval")
                PurchaseInterval purchaseInterval;
                @SerializedName(value="purchase_interval_count")
                Long purchaseIntervalCount;

                private OnDemand(Long averageAmount, Map<String, Object> extraParams, Long maximumAmount, Long minimumAmount, PurchaseInterval purchaseInterval, Long purchaseIntervalCount) {
                    this.averageAmount = averageAmount;
                    this.extraParams = extraParams;
                    this.maximumAmount = maximumAmount;
                    this.minimumAmount = minimumAmount;
                    this.purchaseInterval = purchaseInterval;
                    this.purchaseIntervalCount = purchaseIntervalCount;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Long getAverageAmount() {
                    return this.averageAmount;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getMaximumAmount() {
                    return this.maximumAmount;
                }

                @Generated
                public Long getMinimumAmount() {
                    return this.minimumAmount;
                }

                @Generated
                public PurchaseInterval getPurchaseInterval() {
                    return this.purchaseInterval;
                }

                @Generated
                public Long getPurchaseIntervalCount() {
                    return this.purchaseIntervalCount;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof OnDemand)) {
                        return false;
                    }
                    OnDemand other = (OnDemand)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$averageAmount = this.getAverageAmount();
                    Long other$averageAmount = other.getAverageAmount();
                    if (this$averageAmount == null ? other$averageAmount != null : !((Object)this$averageAmount).equals(other$averageAmount)) {
                        return false;
                    }
                    Long this$maximumAmount = this.getMaximumAmount();
                    Long other$maximumAmount = other.getMaximumAmount();
                    if (this$maximumAmount == null ? other$maximumAmount != null : !((Object)this$maximumAmount).equals(other$maximumAmount)) {
                        return false;
                    }
                    Long this$minimumAmount = this.getMinimumAmount();
                    Long other$minimumAmount = other.getMinimumAmount();
                    if (this$minimumAmount == null ? other$minimumAmount != null : !((Object)this$minimumAmount).equals(other$minimumAmount)) {
                        return false;
                    }
                    Long this$purchaseIntervalCount = this.getPurchaseIntervalCount();
                    Long other$purchaseIntervalCount = other.getPurchaseIntervalCount();
                    if (this$purchaseIntervalCount == null ? other$purchaseIntervalCount != null : !((Object)this$purchaseIntervalCount).equals(other$purchaseIntervalCount)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    PurchaseInterval this$purchaseInterval = this.getPurchaseInterval();
                    PurchaseInterval other$purchaseInterval = other.getPurchaseInterval();
                    return !(this$purchaseInterval == null ? other$purchaseInterval != null : !this$purchaseInterval.equals(other$purchaseInterval));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof OnDemand;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $averageAmount = this.getAverageAmount();
                    result = result * 59 + ($averageAmount == null ? 43 : ((Object)$averageAmount).hashCode());
                    Long $maximumAmount = this.getMaximumAmount();
                    result = result * 59 + ($maximumAmount == null ? 43 : ((Object)$maximumAmount).hashCode());
                    Long $minimumAmount = this.getMinimumAmount();
                    result = result * 59 + ($minimumAmount == null ? 43 : ((Object)$minimumAmount).hashCode());
                    Long $purchaseIntervalCount = this.getPurchaseIntervalCount();
                    result = result * 59 + ($purchaseIntervalCount == null ? 43 : ((Object)$purchaseIntervalCount).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    PurchaseInterval $purchaseInterval = this.getPurchaseInterval();
                    result = result * 59 + ($purchaseInterval == null ? 43 : $purchaseInterval.hashCode());
                    return result;
                }

                public static enum PurchaseInterval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private PurchaseInterval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class Builder {
                    private Long averageAmount;
                    private Map<String, Object> extraParams;
                    private Long maximumAmount;
                    private Long minimumAmount;
                    private PurchaseInterval purchaseInterval;
                    private Long purchaseIntervalCount;

                    public OnDemand build() {
                        return new OnDemand(this.averageAmount, this.extraParams, this.maximumAmount, this.minimumAmount, this.purchaseInterval, this.purchaseIntervalCount);
                    }

                    public Builder setAverageAmount(Long averageAmount) {
                        this.averageAmount = averageAmount;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setMaximumAmount(Long maximumAmount) {
                        this.maximumAmount = maximumAmount;
                        return this;
                    }

                    public Builder setMinimumAmount(Long minimumAmount) {
                        this.minimumAmount = minimumAmount;
                        return this;
                    }

                    public Builder setPurchaseInterval(PurchaseInterval purchaseInterval) {
                        this.purchaseInterval = purchaseInterval;
                        return this;
                    }

                    public Builder setPurchaseIntervalCount(Long purchaseIntervalCount) {
                        this.purchaseIntervalCount = purchaseIntervalCount;
                        return this;
                    }
                }
            }

            public static enum PreferredLocale implements ApiRequestParams.EnumParam
            {
                CS_CZ("cs-CZ"),
                DA_DK("da-DK"),
                DE_AT("de-AT"),
                DE_CH("de-CH"),
                DE_DE("de-DE"),
                EL_GR("el-GR"),
                EN_AT("en-AT"),
                EN_AU("en-AU"),
                EN_BE("en-BE"),
                EN_CA("en-CA"),
                EN_CH("en-CH"),
                EN_CZ("en-CZ"),
                EN_DE("en-DE"),
                EN_DK("en-DK"),
                EN_ES("en-ES"),
                EN_FI("en-FI"),
                EN_FR("en-FR"),
                EN_GB("en-GB"),
                EN_GR("en-GR"),
                EN_IE("en-IE"),
                EN_IT("en-IT"),
                EN_NL("en-NL"),
                EN_NO("en-NO"),
                EN_NZ("en-NZ"),
                EN_PL("en-PL"),
                EN_PT("en-PT"),
                EN_RO("en-RO"),
                EN_SE("en-SE"),
                EN_US("en-US"),
                ES_ES("es-ES"),
                ES_US("es-US"),
                FI_FI("fi-FI"),
                FR_BE("fr-BE"),
                FR_CA("fr-CA"),
                FR_CH("fr-CH"),
                FR_FR("fr-FR"),
                IT_CH("it-CH"),
                IT_IT("it-IT"),
                NB_NO("nb-NO"),
                NL_BE("nl-BE"),
                NL_NL("nl-NL"),
                PL_PL("pl-PL"),
                PT_PT("pt-PT"),
                RO_RO("ro-RO"),
                SV_FI("sv-FI"),
                SV_SE("sv-SE");

                private final String value;

                private PreferredLocale(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session"),
                ON_SESSION("on_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private OnDemand onDemand;
                private PreferredLocale preferredLocale;
                private SetupFutureUsage setupFutureUsage;
                private Object subscriptions;

                public Klarna build() {
                    return new Klarna(this.captureMethod, this.extraParams, this.onDemand, this.preferredLocale, this.setupFutureUsage, this.subscriptions);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setOnDemand(OnDemand onDemand) {
                    this.onDemand = onDemand;
                    return this;
                }

                public Builder setPreferredLocale(PreferredLocale preferredLocale) {
                    this.preferredLocale = preferredLocale;
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder addSubscription(Subscription element) {
                    if (this.subscriptions == null || this.subscriptions instanceof EmptyParam) {
                        this.subscriptions = new ArrayList();
                    }
                    ((List)this.subscriptions).add(element);
                    return this;
                }

                public Builder addAllSubscription(List<Subscription> elements) {
                    if (this.subscriptions == null || this.subscriptions instanceof EmptyParam) {
                        this.subscriptions = new ArrayList();
                    }
                    ((List)this.subscriptions).addAll(elements);
                    return this;
                }

                public Builder setSubscriptions(EmptyParam subscriptions) {
                    this.subscriptions = subscriptions;
                    return this;
                }

                public Builder setSubscriptions(List<Subscription> subscriptions) {
                    this.subscriptions = subscriptions;
                    return this;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Subscription {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="interval")
                Interval interval;
                @SerializedName(value="interval_count")
                Long intervalCount;
                @SerializedName(value="name")
                String name;
                @SerializedName(value="next_billing")
                NextBilling nextBilling;
                @SerializedName(value="reference")
                String reference;

                private Subscription(Map<String, Object> extraParams, Interval interval, Long intervalCount, String name, NextBilling nextBilling, String reference) {
                    this.extraParams = extraParams;
                    this.interval = interval;
                    this.intervalCount = intervalCount;
                    this.name = name;
                    this.nextBilling = nextBilling;
                    this.reference = reference;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Interval getInterval() {
                    return this.interval;
                }

                @Generated
                public Long getIntervalCount() {
                    return this.intervalCount;
                }

                @Generated
                public String getName() {
                    return this.name;
                }

                @Generated
                public NextBilling getNextBilling() {
                    return this.nextBilling;
                }

                @Generated
                public String getReference() {
                    return this.reference;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Subscription)) {
                        return false;
                    }
                    Subscription other = (Subscription)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$intervalCount = this.getIntervalCount();
                    Long other$intervalCount = other.getIntervalCount();
                    if (this$intervalCount == null ? other$intervalCount != null : !((Object)this$intervalCount).equals(other$intervalCount)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    Interval this$interval = this.getInterval();
                    Interval other$interval = other.getInterval();
                    if (this$interval == null ? other$interval != null : !this$interval.equals(other$interval)) {
                        return false;
                    }
                    String this$name = this.getName();
                    String other$name = other.getName();
                    if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                        return false;
                    }
                    NextBilling this$nextBilling = this.getNextBilling();
                    NextBilling other$nextBilling = other.getNextBilling();
                    if (this$nextBilling == null ? other$nextBilling != null : !((Object)this$nextBilling).equals(other$nextBilling)) {
                        return false;
                    }
                    String this$reference = this.getReference();
                    String other$reference = other.getReference();
                    return !(this$reference == null ? other$reference != null : !this$reference.equals(other$reference));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Subscription;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $intervalCount = this.getIntervalCount();
                    result = result * 59 + ($intervalCount == null ? 43 : ((Object)$intervalCount).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    Interval $interval = this.getInterval();
                    result = result * 59 + ($interval == null ? 43 : $interval.hashCode());
                    String $name = this.getName();
                    result = result * 59 + ($name == null ? 43 : $name.hashCode());
                    NextBilling $nextBilling = this.getNextBilling();
                    result = result * 59 + ($nextBilling == null ? 43 : ((Object)$nextBilling).hashCode());
                    String $reference = this.getReference();
                    result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
                    return result;
                }

                public static enum Interval implements ApiRequestParams.EnumParam
                {
                    DAY("day"),
                    MONTH("month"),
                    WEEK("week"),
                    YEAR("year");

                    private final String value;

                    private Interval(String value) {
                        this.value = value;
                    }

                    @Override
                    @Generated
                    public String getValue() {
                        return this.value;
                    }
                }

                public static class NextBilling {
                    @SerializedName(value="amount")
                    Long amount;
                    @SerializedName(value="date")
                    String date;
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;

                    private NextBilling(Long amount, String date, Map<String, Object> extraParams) {
                        this.amount = amount;
                        this.date = date;
                        this.extraParams = extraParams;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Long getAmount() {
                        return this.amount;
                    }

                    @Generated
                    public String getDate() {
                        return this.date;
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof NextBilling)) {
                            return false;
                        }
                        NextBilling other = (NextBilling)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$amount = this.getAmount();
                        Long other$amount = other.getAmount();
                        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                            return false;
                        }
                        String this$date = this.getDate();
                        String other$date = other.getDate();
                        if (this$date == null ? other$date != null : !this$date.equals(other$date)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof NextBilling;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $amount = this.getAmount();
                        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                        String $date = this.getDate();
                        result = result * 59 + ($date == null ? 43 : $date.hashCode());
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        return result;
                    }

                    public static class Builder {
                        private Long amount;
                        private String date;
                        private Map<String, Object> extraParams;

                        public NextBilling build() {
                            return new NextBilling(this.amount, this.date, this.extraParams);
                        }

                        public Builder setAmount(Long amount) {
                            this.amount = amount;
                            return this;
                        }

                        public Builder setDate(String date) {
                            this.date = date;
                            return this;
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private Interval interval;
                    private Long intervalCount;
                    private String name;
                    private NextBilling nextBilling;
                    private String reference;

                    public Subscription build() {
                        return new Subscription(this.extraParams, this.interval, this.intervalCount, this.name, this.nextBilling, this.reference);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setInterval(Interval interval) {
                        this.interval = interval;
                        return this;
                    }

                    public Builder setIntervalCount(Long intervalCount) {
                        this.intervalCount = intervalCount;
                        return this;
                    }

                    public Builder setName(String name) {
                        this.name = name;
                        return this;
                    }

                    public Builder setNextBilling(NextBilling nextBilling) {
                        this.nextBilling = nextBilling;
                        return this;
                    }

                    public Builder setReference(String reference) {
                        this.reference = reference;
                        return this;
                    }
                }
            }
        }

        public static class KakaoPay {
            @SerializedName(value="capture_method")
            ApiRequestParams.EnumParam captureMethod;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private KakaoPay(ApiRequestParams.EnumParam captureMethod, Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.captureMethod = captureMethod;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public ApiRequestParams.EnumParam getCaptureMethod() {
                return this.captureMethod;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KakaoPay)) {
                    return false;
                }
                KakaoPay other = (KakaoPay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$captureMethod = this.getCaptureMethod();
                ApiRequestParams.EnumParam other$captureMethod = other.getCaptureMethod();
                if (this$captureMethod == null ? other$captureMethod != null : !this$captureMethod.equals(other$captureMethod)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KakaoPay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ApiRequestParams.EnumParam $captureMethod = this.getCaptureMethod();
                result = result * 59 + ($captureMethod == null ? 43 : $captureMethod.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private ApiRequestParams.EnumParam captureMethod;
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public KakaoPay build() {
                    return new KakaoPay(this.captureMethod, this.extraParams, this.setupFutureUsage);
                }

                public Builder setCaptureMethod(CaptureMethod captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder setCaptureMethod(EmptyParam captureMethod) {
                    this.captureMethod = captureMethod;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static enum CaptureMethod implements ApiRequestParams.EnumParam
            {
                MANUAL("manual");

                private final String value;

                private CaptureMethod(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class InteracPresent {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;

            private InteracPresent(Map<String, Object> extraParams) {
                this.extraParams = extraParams;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InteracPresent)) {
                    return false;
                }
                InteracPresent other = (InteracPresent)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InteracPresent;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;

                public InteracPresent build() {
                    return new InteracPresent(this.extraParams);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }
            }
        }

        public static class Ideal {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            ApiRequestParams.EnumParam setupFutureUsage;

            private Ideal(Map<String, Object> extraParams, ApiRequestParams.EnumParam setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public ApiRequestParams.EnumParam getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Ideal)) {
                    return false;
                }
                Ideal other = (Ideal)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                ApiRequestParams.EnumParam this$setupFutureUsage = this.getSetupFutureUsage();
                ApiRequestParams.EnumParam other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Ideal;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                ApiRequestParams.EnumParam $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private ApiRequestParams.EnumParam setupFutureUsage;

                public Ideal build() {
                    return new Ideal(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }

                public Builder setSetupFutureUsage(EmptyParam setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }
        }

        public static class IdBankTransfer {
            @SerializedName(value="expires_after")
            Long expiresAfter;
            @SerializedName(value="expires_at")
            Long expiresAt;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private IdBankTransfer(Long expiresAfter, Long expiresAt, Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.expiresAfter = expiresAfter;
                this.expiresAt = expiresAt;
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Long getExpiresAfter() {
                return this.expiresAfter;
            }

            @Generated
            public Long getExpiresAt() {
                return this.expiresAt;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof IdBankTransfer)) {
                    return false;
                }
                IdBankTransfer other = (IdBankTransfer)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expiresAfter = this.getExpiresAfter();
                Long other$expiresAfter = other.getExpiresAfter();
                if (this$expiresAfter == null ? other$expiresAfter != null : !((Object)this$expiresAfter).equals(other$expiresAfter)) {
                    return false;
                }
                Long this$expiresAt = this.getExpiresAt();
                Long other$expiresAt = other.getExpiresAt();
                if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof IdBankTransfer;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expiresAfter = this.getExpiresAfter();
                result = result * 59 + ($expiresAfter == null ? 43 : ((Object)$expiresAfter).hashCode());
                Long $expiresAt = this.getExpiresAt();
                result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Long expiresAfter;
                private Long expiresAt;
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public IdBankTransfer build() {
                    return new IdBankTransfer(this.expiresAfter, this.expiresAt, this.extraParams, this.setupFutureUsage);
                }

                public Builder setExpiresAfter(Long expiresAfter) {
                    this.expiresAfter = expiresAfter;
                    return this;
                }

                public Builder setExpiresAt(Long expiresAt) {
                    this.expiresAt = expiresAt;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Grabpay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Grabpay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Grabpay)) {
                    return false;
                }
                Grabpay other = (Grabpay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Grabpay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Grabpay build() {
                    return new Grabpay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Gopay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Gopay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Gopay)) {
                    return false;
                }
                Gopay other = (Gopay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                SetupFutureUsage this$setupFutureUsage = this.getSetupFutureUsage();
                SetupFutureUsage other$setupFutureUsage = other.getSetupFutureUsage();
                return !(this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Gopay;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                SetupFutureUsage $setupFutureUsage = this.getSetupFutureUsage();
                result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
                return result;
            }

            public static enum SetupFutureUsage implements ApiRequestParams.EnumParam
            {
                NONE("none"),
                OFF_SESSION("off_session");

                private final String value;

                private SetupFutureUsage(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private Map<String, Object> extraParams;
                private SetupFutureUsage setupFutureUsage;

                public Gopay build() {
                    return new Gopay(this.extraParams, this.setupFutureUsage);
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setSetupFutureUsage(SetupFutureUsage setupFutureUsage) {
                    this.setupFutureUsage = setupFutureUsage;
                    return this;
                }
            }
        }

        public static class Giropay {
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="setup_future_usage")
            SetupFutureUsage setupFutureUsage;

            private Giropay(Map<String, Object> extraParams, SetupFutureUsage setupFutureUsage) {
                this.extraParams = extraParams;
                this.setupFutureUsage = setupFutureUsage;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public SetupFutureUsage getSetupFutureUsage() {
                return this.setupFutureUsage;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Giropay)) {
                    return false;
                }
                Giropay other = (Giropay)o;
                if (!other.canEqual(this)) {
                    return false;
        