/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.Cadence;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.CadenceCreateParams;
import com.stripe.param.v2.billing.CadenceListParams;
import com.stripe.param.v2.billing.CadenceRetrieveParams;
import com.stripe.param.v2.billing.CadenceUpdateParams;
import java.lang.reflect.Type;

public final class CadenceService
extends ApiService {
    public CadenceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Cadence> list(CadenceListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Cadence> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Cadence> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Cadence> list(CadenceListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/cadences";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Cadence>>(){}.getType());
    }

    public Cadence create(CadenceCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Cadence create(CadenceCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/cadences";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Cadence)this.request(request, (Type)((Object)Cadence.class));
    }

    public Cadence retrieve(String id, CadenceRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public Cadence retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public Cadence retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public Cadence retrieve(String id, CadenceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/cadences/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Cadence)this.request(request, (Type)((Object)Cadence.class));
    }

    public Cadence update(String id, CadenceUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Cadence update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Cadence update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Cadence update(String id, CadenceUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/cadences/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Cadence)this.request(request, (Type)((Object)Cadence.class));
    }

    public Cadence cancel(String id) throws StripeException {
        return this.cancel(id, null);
    }

    public Cadence cancel(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/cadences/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (Cadence)this.request(request, (Type)((Object)Cadence.class));
    }
}

