/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.Profile;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.ProfileCreateParams;
import com.stripe.param.v2.billing.ProfileListParams;
import com.stripe.param.v2.billing.ProfileUpdateParams;
import java.lang.reflect.Type;

public final class ProfileService
extends ApiService {
    public ProfileService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Profile> list(ProfileListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Profile> list(ProfileListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/profiles";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Profile>>(){}.getType());
    }

    public Profile create(ProfileCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Profile create(ProfileCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/profiles";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Profile)this.request(request, (Type)((Object)Profile.class));
    }

    public Profile retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public Profile retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/profiles/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (Profile)this.request(request, (Type)((Object)Profile.class));
    }

    public Profile update(String id, ProfileUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public Profile update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public Profile update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public Profile update(String id, ProfileUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/profiles/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Profile)this.request(request, (Type)((Object)Profile.class));
    }
}

