/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing.billsettings;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.BillSettingVersion;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.billsettings.VersionListParams;
import java.lang.reflect.Type;

public final class VersionService
extends ApiService {
    public VersionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<BillSettingVersion> list(String billSettingId, VersionListParams params) throws StripeException {
        return this.list(billSettingId, params, null);
    }

    public StripeCollection<BillSettingVersion> list(String billSettingId, RequestOptions options) throws StripeException {
        return this.list(billSettingId, null, options);
    }

    public StripeCollection<BillSettingVersion> list(String billSettingId) throws StripeException {
        return this.list(billSettingId, null, null);
    }

    public StripeCollection<BillSettingVersion> list(String billSettingId, VersionListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/bill_settings/%s/versions", ApiResource.urlEncodeId(billSettingId));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<BillSettingVersion>>(){}.getType());
    }

    public BillSettingVersion retrieve(String billSettingId, String id) throws StripeException {
        return this.retrieve(billSettingId, id, null);
    }

    public BillSettingVersion retrieve(String billSettingId, String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/bill_settings/%s/versions/%s", ApiResource.urlEncodeId(billSettingId), ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (BillSettingVersion)this.request(request, (Type)((Object)BillSettingVersion.class));
    }
}

