/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.AlreadyExistsException;
import com.stripe.exception.FeatureNotEnabledException;
import com.stripe.exception.NonZeroBalanceException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.FinancialAccount;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.FinancialAccountCloseParams;
import com.stripe.param.v2.moneymanagement.FinancialAccountCreateParams;
import com.stripe.param.v2.moneymanagement.FinancialAccountListParams;
import java.lang.reflect.Type;

public final class FinancialAccountService
extends ApiService {
    public FinancialAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<FinancialAccount> list(FinancialAccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<FinancialAccount> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<FinancialAccount> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<FinancialAccount> list(FinancialAccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/financial_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<FinancialAccount>>(){}.getType());
    }

    public FinancialAccount create(FinancialAccountCreateParams params) throws StripeException, AlreadyExistsException, FeatureNotEnabledException {
        return this.create(params, null);
    }

    public FinancialAccount create(FinancialAccountCreateParams params, RequestOptions options) throws StripeException, AlreadyExistsException, FeatureNotEnabledException {
        String path = "/v2/money_management/financial_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccount)this.request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public FinancialAccount retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/financial_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (FinancialAccount)this.request(request, (Type)((Object)FinancialAccount.class));
    }

    public FinancialAccount close(String id, FinancialAccountCloseParams params) throws StripeException, NonZeroBalanceException {
        return this.close(id, params, null);
    }

    public FinancialAccount close(String id, RequestOptions options) throws StripeException, NonZeroBalanceException {
        return this.close(id, null, options);
    }

    public FinancialAccount close(String id) throws StripeException, NonZeroBalanceException {
        return this.close(id, null, null);
    }

    public FinancialAccount close(String id, FinancialAccountCloseParams params, RequestOptions options) throws StripeException, NonZeroBalanceException {
        String path = String.format("/v2/money_management/financial_accounts/%s/close", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAccount)this.request(request, (Type)((Object)FinancialAccount.class));
    }
}

