/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.FeatureNotEnabledException;
import com.stripe.exception.FinancialAccountNotOpenException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.FinancialAddress;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.FinancialAddressCreateParams;
import com.stripe.param.v2.moneymanagement.FinancialAddressListParams;
import com.stripe.param.v2.moneymanagement.FinancialAddressRetrieveParams;
import java.lang.reflect.Type;

public final class FinancialAddressService
extends ApiService {
    public FinancialAddressService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<FinancialAddress> list(FinancialAddressListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<FinancialAddress> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<FinancialAddress> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<FinancialAddress> list(FinancialAddressListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/financial_addresses";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<FinancialAddress>>(){}.getType());
    }

    public FinancialAddress create(FinancialAddressCreateParams params) throws StripeException, FinancialAccountNotOpenException, FeatureNotEnabledException {
        return this.create(params, null);
    }

    public FinancialAddress create(FinancialAddressCreateParams params, RequestOptions options) throws StripeException, FinancialAccountNotOpenException, FeatureNotEnabledException {
        String path = "/v2/money_management/financial_addresses";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAddress)this.request(request, (Type)((Object)FinancialAddress.class));
    }

    public FinancialAddress retrieve(String id, FinancialAddressRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public FinancialAddress retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public FinancialAddress retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public FinancialAddress retrieve(String id, FinancialAddressRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/financial_addresses/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (FinancialAddress)this.request(request, (Type)((Object)FinancialAddress.class));
    }
}

