/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.BlockedByStripeException;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.InboundTransfer;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.InboundTransferCreateParams;
import com.stripe.param.v2.moneymanagement.InboundTransferListParams;
import java.lang.reflect.Type;

public final class InboundTransferService
extends ApiService {
    public InboundTransferService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<InboundTransfer> list(InboundTransferListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<InboundTransfer> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<InboundTransfer> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<InboundTransfer> list(InboundTransferListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/inbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<InboundTransfer>>(){}.getType());
    }

    public InboundTransfer create(InboundTransferCreateParams params) throws StripeException, BlockedByStripeException {
        return this.create(params, null);
    }

    public InboundTransfer create(InboundTransferCreateParams params, RequestOptions options) throws StripeException, BlockedByStripeException {
        String path = "/v2/money_management/inbound_transfers";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InboundTransfer)this.request(request, (Type)((Object)InboundTransfer.class));
    }

    public InboundTransfer retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public InboundTransfer retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/inbound_transfers/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (InboundTransfer)this.request(request, (Type)((Object)InboundTransfer.class));
    }
}

