/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.moneymanagement;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.moneymanagement.TransactionEntry;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.moneymanagement.TransactionEntryListParams;
import java.lang.reflect.Type;

public final class TransactionEntryService
extends ApiService {
    public TransactionEntryService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<TransactionEntry> list(TransactionEntryListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<TransactionEntry> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<TransactionEntry> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<TransactionEntry> list(TransactionEntryListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/money_management/transaction_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<TransactionEntry>>(){}.getType());
    }

    public TransactionEntry retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public TransactionEntry retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/money_management/transaction_entries/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (TransactionEntry)this.request(request, (Type)((Object)TransactionEntry.class));
    }
}

