/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.PaymentMethodConfigurationCollection;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.PaymentMethodConfigurationCreateParams;
import com.stripe.param.PaymentMethodConfigurationListParams;
import com.stripe.param.PaymentMethodConfigurationRetrieveParams;
import com.stripe.param.PaymentMethodConfigurationUpdateParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class PaymentMethodConfiguration
extends ApiResource
implements HasId {
    @SerializedName(value="acss_debit")
    AcssDebit acssDebit;
    @SerializedName(value="active")
    Boolean active;
    @SerializedName(value="affirm")
    Affirm affirm;
    @SerializedName(value="afterpay_clearpay")
    AfterpayClearpay afterpayClearpay;
    @SerializedName(value="alipay")
    Alipay alipay;
    @SerializedName(value="alma")
    Alma alma;
    @SerializedName(value="amazon_pay")
    AmazonPay amazonPay;
    @SerializedName(value="apple_pay")
    ApplePay applePay;
    @SerializedName(value="application")
    String application;
    @SerializedName(value="au_becs_debit")
    AuBecsDebit auBecsDebit;
    @SerializedName(value="bacs_debit")
    BacsDebit bacsDebit;
    @SerializedName(value="bancontact")
    Bancontact bancontact;
    @SerializedName(value="billie")
    Billie billie;
    @SerializedName(value="blik")
    Blik blik;
    @SerializedName(value="boleto")
    Boleto boleto;
    @SerializedName(value="card")
    Card card;
    @SerializedName(value="cartes_bancaires")
    CartesBancaires cartesBancaires;
    @SerializedName(value="cashapp")
    Cashapp cashapp;
    @SerializedName(value="crypto")
    Crypto crypto;
    @SerializedName(value="customer_balance")
    CustomerBalance customerBalance;
    @SerializedName(value="eps")
    Eps eps;
    @SerializedName(value="fpx")
    Fpx fpx;
    @SerializedName(value="giropay")
    Giropay giropay;
    @SerializedName(value="google_pay")
    GooglePay googlePay;
    @SerializedName(value="grabpay")
    Grabpay grabpay;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="ideal")
    Ideal ideal;
    @SerializedName(value="is_default")
    Boolean isDefault;
    @SerializedName(value="jcb")
    Jcb jcb;
    @SerializedName(value="kakao_pay")
    KakaoPay kakaoPay;
    @SerializedName(value="klarna")
    Klarna klarna;
    @SerializedName(value="konbini")
    Konbini konbini;
    @SerializedName(value="kr_card")
    KrCard krCard;
    @SerializedName(value="link")
    Link link;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="mb_way")
    MbWay mbWay;
    @SerializedName(value="mobilepay")
    Mobilepay mobilepay;
    @SerializedName(value="multibanco")
    Multibanco multibanco;
    @SerializedName(value="name")
    String name;
    @SerializedName(value="naver_pay")
    NaverPay naverPay;
    @SerializedName(value="nz_bank_account")
    NzBankAccount nzBankAccount;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="oxxo")
    Oxxo oxxo;
    @SerializedName(value="p24")
    P24 p24;
    @SerializedName(value="parent")
    String parent;
    @SerializedName(value="pay_by_bank")
    PayByBank payByBank;
    @SerializedName(value="payco")
    Payco payco;
    @SerializedName(value="paynow")
    Paynow paynow;
    @SerializedName(value="paypal")
    Paypal paypal;
    @SerializedName(value="pix")
    Pix pix;
    @SerializedName(value="promptpay")
    Promptpay promptpay;
    @SerializedName(value="revolut_pay")
    RevolutPay revolutPay;
    @SerializedName(value="samsung_pay")
    SamsungPay samsungPay;
    @SerializedName(value="satispay")
    Satispay satispay;
    @SerializedName(value="sepa_debit")
    SepaDebit sepaDebit;
    @SerializedName(value="sofort")
    Sofort sofort;
    @SerializedName(value="swish")
    Swish swish;
    @SerializedName(value="twint")
    Twint twint;
    @SerializedName(value="us_bank_account")
    UsBankAccount usBankAccount;
    @SerializedName(value="wechat_pay")
    WechatPay wechatPay;
    @SerializedName(value="zip")
    Zip zip;

    public static PaymentMethodConfiguration create(Map<String, Object> params) throws StripeException {
        return PaymentMethodConfiguration.create(params, (RequestOptions)null);
    }

    public static PaymentMethodConfiguration create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentMethodConfiguration)PaymentMethodConfiguration.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public static PaymentMethodConfiguration create(PaymentMethodConfigurationCreateParams params) throws StripeException {
        return PaymentMethodConfiguration.create(params, (RequestOptions)null);
    }

    public static PaymentMethodConfiguration create(PaymentMethodConfigurationCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_configurations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfiguration)PaymentMethodConfiguration.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public static PaymentMethodConfigurationCollection list(Map<String, Object> params) throws StripeException {
        return PaymentMethodConfiguration.list(params, (RequestOptions)null);
    }

    public static PaymentMethodConfigurationCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_configurations";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentMethodConfigurationCollection)PaymentMethodConfiguration.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodConfigurationCollection.class));
    }

    public static PaymentMethodConfigurationCollection list(PaymentMethodConfigurationListParams params) throws StripeException {
        return PaymentMethodConfiguration.list(params, (RequestOptions)null);
    }

    public static PaymentMethodConfigurationCollection list(PaymentMethodConfigurationListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/payment_method_configurations";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfigurationCollection)PaymentMethodConfiguration.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodConfigurationCollection.class));
    }

    public static PaymentMethodConfiguration retrieve(String configuration) throws StripeException {
        return PaymentMethodConfiguration.retrieve(configuration, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static PaymentMethodConfiguration retrieve(String configuration, RequestOptions options) throws StripeException {
        return PaymentMethodConfiguration.retrieve(configuration, (Map<String, Object>)null, options);
    }

    public static PaymentMethodConfiguration retrieve(String configuration, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (PaymentMethodConfiguration)PaymentMethodConfiguration.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public static PaymentMethodConfiguration retrieve(String configuration, PaymentMethodConfigurationRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(configuration));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfiguration)PaymentMethodConfiguration.getGlobalResponseGetter().request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public PaymentMethodConfiguration update(Map<String, Object> params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethodConfiguration update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (PaymentMethodConfiguration)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    public PaymentMethodConfiguration update(PaymentMethodConfigurationUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public PaymentMethodConfiguration update(PaymentMethodConfigurationUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/payment_method_configurations/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PaymentMethodConfiguration)this.getResponseGetter().request(request, (Type)((Object)PaymentMethodConfiguration.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.acssDebit, responseGetter);
        this.trySetResponseGetter(this.affirm, responseGetter);
        this.trySetResponseGetter(this.afterpayClearpay, responseGetter);
        this.trySetResponseGetter(this.alipay, responseGetter);
        this.trySetResponseGetter(this.alma, responseGetter);
        this.trySetResponseGetter(this.amazonPay, responseGetter);
        this.trySetResponseGetter(this.applePay, responseGetter);
        this.trySetResponseGetter(this.auBecsDebit, responseGetter);
        this.trySetResponseGetter(this.bacsDebit, responseGetter);
        this.trySetResponseGetter(this.bancontact, responseGetter);
        this.trySetResponseGetter(this.billie, responseGetter);
        this.trySetResponseGetter(this.blik, responseGetter);
        this.trySetResponseGetter(this.boleto, responseGetter);
        this.trySetResponseGetter(this.card, responseGetter);
        this.trySetResponseGetter(this.cartesBancaires, responseGetter);
        this.trySetResponseGetter(this.cashapp, responseGetter);
        this.trySetResponseGetter(this.crypto, responseGetter);
        this.trySetResponseGetter(this.customerBalance, responseGetter);
        this.trySetResponseGetter(this.eps, responseGetter);
        this.trySetResponseGetter(this.fpx, responseGetter);
        this.trySetResponseGetter(this.giropay, responseGetter);
        this.trySetResponseGetter(this.googlePay, responseGetter);
        this.trySetResponseGetter(this.grabpay, responseGetter);
        this.trySetResponseGetter(this.ideal, responseGetter);
        this.trySetResponseGetter(this.jcb, responseGetter);
        this.trySetResponseGetter(this.kakaoPay, responseGetter);
        this.trySetResponseGetter(this.klarna, responseGetter);
        this.trySetResponseGetter(this.konbini, responseGetter);
        this.trySetResponseGetter(this.krCard, responseGetter);
        this.trySetResponseGetter(this.link, responseGetter);
        this.trySetResponseGetter(this.mbWay, responseGetter);
        this.trySetResponseGetter(this.mobilepay, responseGetter);
        this.trySetResponseGetter(this.multibanco, responseGetter);
        this.trySetResponseGetter(this.naverPay, responseGetter);
        this.trySetResponseGetter(this.nzBankAccount, responseGetter);
        this.trySetResponseGetter(this.oxxo, responseGetter);
        this.trySetResponseGetter(this.p24, responseGetter);
        this.trySetResponseGetter(this.payByBank, responseGetter);
        this.trySetResponseGetter(this.payco, responseGetter);
        this.trySetResponseGetter(this.paynow, responseGetter);
        this.trySetResponseGetter(this.paypal, responseGetter);
        this.trySetResponseGetter(this.pix, responseGetter);
        this.trySetResponseGetter(this.promptpay, responseGetter);
        this.trySetResponseGetter(this.revolutPay, responseGetter);
        this.trySetResponseGetter(this.samsungPay, responseGetter);
        this.trySetResponseGetter(this.satispay, responseGetter);
        this.trySetResponseGetter(this.sepaDebit, responseGetter);
        this.trySetResponseGetter(this.sofort, responseGetter);
        this.trySetResponseGetter(this.swish, responseGetter);
        this.trySetResponseGetter(this.twint, responseGetter);
        this.trySetResponseGetter(this.usBankAccount, responseGetter);
        this.trySetResponseGetter(this.wechatPay, responseGetter);
        this.trySetResponseGetter(this.zip, responseGetter);
    }

    @Generated
    public AcssDebit getAcssDebit() {
        return this.acssDebit;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public Affirm getAffirm() {
        return this.affirm;
    }

    @Generated
    public AfterpayClearpay getAfterpayClearpay() {
        return this.afterpayClearpay;
    }

    @Generated
    public Alipay getAlipay() {
        return this.alipay;
    }

    @Generated
    public Alma getAlma() {
        return this.alma;
    }

    @Generated
    public AmazonPay getAmazonPay() {
        return this.amazonPay;
    }

    @Generated
    public ApplePay getApplePay() {
        return this.applePay;
    }

    @Generated
    public String getApplication() {
        return this.application;
    }

    @Generated
    public AuBecsDebit getAuBecsDebit() {
        return this.auBecsDebit;
    }

    @Generated
    public BacsDebit getBacsDebit() {
        return this.bacsDebit;
    }

    @Generated
    public Bancontact getBancontact() {
        return this.bancontact;
    }

    @Generated
    public Billie getBillie() {
        return this.billie;
    }

    @Generated
    public Blik getBlik() {
        return this.blik;
    }

    @Generated
    public Boleto getBoleto() {
        return this.boleto;
    }

    @Generated
    public Card getCard() {
        return this.card;
    }

    @Generated
    public CartesBancaires getCartesBancaires() {
        return this.cartesBancaires;
    }

    @Generated
    public Cashapp getCashapp() {
        return this.cashapp;
    }

    @Generated
    public Crypto getCrypto() {
        return this.crypto;
    }

    @Generated
    public CustomerBalance getCustomerBalance() {
        return this.customerBalance;
    }

    @Generated
    public Eps getEps() {
        return this.eps;
    }

    @Generated
    public Fpx getFpx() {
        return this.fpx;
    }

    @Generated
    public Giropay getGiropay() {
        return this.giropay;
    }

    @Generated
    public GooglePay getGooglePay() {
        return this.googlePay;
    }

    @Generated
    public Grabpay getGrabpay() {
        return this.grabpay;
    }

    @Generated
    public Ideal getIdeal() {
        return this.ideal;
    }

    @Generated
    public Boolean getIsDefault() {
        return this.isDefault;
    }

    @Generated
    public Jcb getJcb() {
        return this.jcb;
    }

    @Generated
    public KakaoPay getKakaoPay() {
        return this.kakaoPay;
    }

    @Generated
    public Klarna getKlarna() {
        return this.klarna;
    }

    @Generated
    public Konbini getKonbini() {
        return this.konbini;
    }

    @Generated
    public KrCard getKrCard() {
        return this.krCard;
    }

    @Generated
    public Link getLink() {
        return this.link;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public MbWay getMbWay() {
        return this.mbWay;
    }

    @Generated
    public Mobilepay getMobilepay() {
        return this.mobilepay;
    }

    @Generated
    public Multibanco getMultibanco() {
        return this.multibanco;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public NaverPay getNaverPay() {
        return this.naverPay;
    }

    @Generated
    public NzBankAccount getNzBankAccount() {
        return this.nzBankAccount;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Oxxo getOxxo() {
        return this.oxxo;
    }

    @Generated
    public P24 getP24() {
        return this.p24;
    }

    @Generated
    public String getParent() {
        return this.parent;
    }

    @Generated
    public PayByBank getPayByBank() {
        return this.payByBank;
    }

    @Generated
    public Payco getPayco() {
        return this.payco;
    }

    @Generated
    public Paynow getPaynow() {
        return this.paynow;
    }

    @Generated
    public Paypal getPaypal() {
        return this.paypal;
    }

    @Generated
    public Pix getPix() {
        return this.pix;
    }

    @Generated
    public Promptpay getPromptpay() {
        return this.promptpay;
    }

    @Generated
    public RevolutPay getRevolutPay() {
        return this.revolutPay;
    }

    @Generated
    public SamsungPay getSamsungPay() {
        return this.samsungPay;
    }

    @Generated
    public Satispay getSatispay() {
        return this.satispay;
    }

    @Generated
    public SepaDebit getSepaDebit() {
        return this.sepaDebit;
    }

    @Generated
    public Sofort getSofort() {
        return this.sofort;
    }

    @Generated
    public Swish getSwish() {
        return this.swish;
    }

    @Generated
    public Twint getTwint() {
        return this.twint;
    }

    @Generated
    public UsBankAccount getUsBankAccount() {
        return this.usBankAccount;
    }

    @Generated
    public WechatPay getWechatPay() {
        return this.wechatPay;
    }

    @Generated
    public Zip getZip() {
        return this.zip;
    }

    @Generated
    public void setAcssDebit(AcssDebit acssDebit) {
        this.acssDebit = acssDebit;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setAffirm(Affirm affirm) {
        this.affirm = affirm;
    }

    @Generated
    public void setAfterpayClearpay(AfterpayClearpay afterpayClearpay) {
        this.afterpayClearpay = afterpayClearpay;
    }

    @Generated
    public void setAlipay(Alipay alipay) {
        this.alipay = alipay;
    }

    @Generated
    public void setAlma(Alma alma) {
        this.alma = alma;
    }

    @Generated
    public void setAmazonPay(AmazonPay amazonPay) {
        this.amazonPay = amazonPay;
    }

    @Generated
    public void setApplePay(ApplePay applePay) {
        this.applePay = applePay;
    }

    @Generated
    public void setApplication(String application) {
        this.application = application;
    }

    @Generated
    public void setAuBecsDebit(AuBecsDebit auBecsDebit) {
        this.auBecsDebit = auBecsDebit;
    }

    @Generated
    public void setBacsDebit(BacsDebit bacsDebit) {
        this.bacsDebit = bacsDebit;
    }

    @Generated
    public void setBancontact(Bancontact bancontact) {
        this.bancontact = bancontact;
    }

    @Generated
    public void setBillie(Billie billie) {
        this.billie = billie;
    }

    @Generated
    public void setBlik(Blik blik) {
        this.blik = blik;
    }

    @Generated
    public void setBoleto(Boleto boleto) {
        this.boleto = boleto;
    }

    @Generated
    public void setCard(Card card) {
        this.card = card;
    }

    @Generated
    public void setCartesBancaires(CartesBancaires cartesBancaires) {
        this.cartesBancaires = cartesBancaires;
    }

    @Generated
    public void setCashapp(Cashapp cashapp) {
        this.cashapp = cashapp;
    }

    @Generated
    public void setCrypto(Crypto crypto) {
        this.crypto = crypto;
    }

    @Generated
    public void setCustomerBalance(CustomerBalance customerBalance) {
        this.customerBalance = customerBalance;
    }

    @Generated
    public void setEps(Eps eps) {
        this.eps = eps;
    }

    @Generated
    public void setFpx(Fpx fpx) {
        this.fpx = fpx;
    }

    @Generated
    public void setGiropay(Giropay giropay) {
        this.giropay = giropay;
    }

    @Generated
    public void setGooglePay(GooglePay googlePay) {
        this.googlePay = googlePay;
    }

    @Generated
    public void setGrabpay(Grabpay grabpay) {
        this.grabpay = grabpay;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIdeal(Ideal ideal) {
        this.ideal = ideal;
    }

    @Generated
    public void setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Generated
    public void setJcb(Jcb jcb) {
        this.jcb = jcb;
    }

    @Generated
    public void setKakaoPay(KakaoPay kakaoPay) {
        this.kakaoPay = kakaoPay;
    }

    @Generated
    public void setKlarna(Klarna klarna) {
        this.klarna = klarna;
    }

    @Generated
    public void setKonbini(Konbini konbini) {
        this.konbini = konbini;
    }

    @Generated
    public void setKrCard(KrCard krCard) {
        this.krCard = krCard;
    }

    @Generated
    public void setLink(Link link) {
        this.link = link;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMbWay(MbWay mbWay) {
        this.mbWay = mbWay;
    }

    @Generated
    public void setMobilepay(Mobilepay mobilepay) {
        this.mobilepay = mobilepay;
    }

    @Generated
    public void setMultibanco(Multibanco multibanco) {
        this.multibanco = multibanco;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNaverPay(NaverPay naverPay) {
        this.naverPay = naverPay;
    }

    @Generated
    public void setNzBankAccount(NzBankAccount nzBankAccount) {
        this.nzBankAccount = nzBankAccount;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOxxo(Oxxo oxxo) {
        this.oxxo = oxxo;
    }

    @Generated
    public void setP24(P24 p24) {
        this.p24 = p24;
    }

    @Generated
    public void setParent(String parent) {
        this.parent = parent;
    }

    @Generated
    public void setPayByBank(PayByBank payByBank) {
        this.payByBank = payByBank;
    }

    @Generated
    public void setPayco(Payco payco) {
        this.payco = payco;
    }

    @Generated
    public void setPaynow(Paynow paynow) {
        this.paynow = paynow;
    }

    @Generated
    public void setPaypal(Paypal paypal) {
        this.paypal = paypal;
    }

    @Generated
    public void setPix(Pix pix) {
        this.pix = pix;
    }

    @Generated
    public void setPromptpay(Promptpay promptpay) {
        this.promptpay = promptpay;
    }

    @Generated
    public void setRevolutPay(RevolutPay revolutPay) {
        this.revolutPay = revolutPay;
    }

    @Generated
    public void setSamsungPay(SamsungPay samsungPay) {
        this.samsungPay = samsungPay;
    }

    @Generated
    public void setSatispay(Satispay satispay) {
        this.satispay = satispay;
    }

    @Generated
    public void setSepaDebit(SepaDebit sepaDebit) {
        this.sepaDebit = sepaDebit;
    }

    @Generated
    public void setSofort(Sofort sofort) {
        this.sofort = sofort;
    }

    @Generated
    public void setSwish(Swish swish) {
        this.swish = swish;
    }

    @Generated
    public void setTwint(Twint twint) {
        this.twint = twint;
    }

    @Generated
    public void setUsBankAccount(UsBankAccount usBankAccount) {
        this.usBankAccount = usBankAccount;
    }

    @Generated
    public void setWechatPay(WechatPay wechatPay) {
        this.wechatPay = wechatPay;
    }

    @Generated
    public void setZip(Zip zip) {
        this.zip = zip;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PaymentMethodConfiguration)) {
            return false;
        }
        PaymentMethodConfiguration other = (PaymentMethodConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        AcssDebit this$acssDebit = this.getAcssDebit();
        AcssDebit other$acssDebit = other.getAcssDebit();
        if (this$acssDebit == null ? other$acssDebit != null : !((Object)this$acssDebit).equals(other$acssDebit)) {
            return false;
        }
        Affirm this$affirm = this.getAffirm();
        Affirm other$affirm = other.getAffirm();
        if (this$affirm == null ? other$affirm != null : !((Object)this$affirm).equals(other$affirm)) {
            return false;
        }
        AfterpayClearpay this$afterpayClearpay = this.getAfterpayClearpay();
        AfterpayClearpay other$afterpayClearpay = other.getAfterpayClearpay();
        if (this$afterpayClearpay == null ? other$afterpayClearpay != null : !((Object)this$afterpayClearpay).equals(other$afterpayClearpay)) {
            return false;
        }
        Alipay this$alipay = this.getAlipay();
        Alipay other$alipay = other.getAlipay();
        if (this$alipay == null ? other$alipay != null : !((Object)this$alipay).equals(other$alipay)) {
            return false;
        }
        Alma this$alma = this.getAlma();
        Alma other$alma = other.getAlma();
        if (this$alma == null ? other$alma != null : !((Object)this$alma).equals(other$alma)) {
            return false;
        }
        AmazonPay this$amazonPay = this.getAmazonPay();
        AmazonPay other$amazonPay = other.getAmazonPay();
        if (this$amazonPay == null ? other$amazonPay != null : !((Object)this$amazonPay).equals(other$amazonPay)) {
            return false;
        }
        ApplePay this$applePay = this.getApplePay();
        ApplePay other$applePay = other.getApplePay();
        if (this$applePay == null ? other$applePay != null : !((Object)this$applePay).equals(other$applePay)) {
            return false;
        }
        String this$application = this.getApplication();
        String other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        AuBecsDebit this$auBecsDebit = this.getAuBecsDebit();
        AuBecsDebit other$auBecsDebit = other.getAuBecsDebit();
        if (this$auBecsDebit == null ? other$auBecsDebit != null : !((Object)this$auBecsDebit).equals(other$auBecsDebit)) {
            return false;
        }
        BacsDebit this$bacsDebit = this.getBacsDebit();
        BacsDebit other$bacsDebit = other.getBacsDebit();
        if (this$bacsDebit == null ? other$bacsDebit != null : !((Object)this$bacsDebit).equals(other$bacsDebit)) {
            return false;
        }
        Bancontact this$bancontact = this.getBancontact();
        Bancontact other$bancontact = other.getBancontact();
        if (this$bancontact == null ? other$bancontact != null : !((Object)this$bancontact).equals(other$bancontact)) {
            return false;
        }
        Billie this$billie = this.getBillie();
        Billie other$billie = other.getBillie();
        if (this$billie == null ? other$billie != null : !((Object)this$billie).equals(other$billie)) {
            return false;
        }
        Blik this$blik = this.getBlik();
        Blik other$blik = other.getBlik();
        if (this$blik == null ? other$blik != null : !((Object)this$blik).equals(other$blik)) {
            return false;
        }
        Boleto this$boleto = this.getBoleto();
        Boleto other$boleto = other.getBoleto();
        if (this$boleto == null ? other$boleto != null : !((Object)this$boleto).equals(other$boleto)) {
            return false;
        }
        Card this$card = this.getCard();
        Card other$card = other.getCard();
        if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
            return false;
        }
        CartesBancaires this$cartesBancaires = this.getCartesBancaires();
        CartesBancaires other$cartesBancaires = other.getCartesBancaires();
        if (this$cartesBancaires == null ? other$cartesBancaires != null : !((Object)this$cartesBancaires).equals(other$cartesBancaires)) {
            return false;
        }
        Cashapp this$cashapp = this.getCashapp();
        Cashapp other$cashapp = other.getCashapp();
        if (this$cashapp == null ? other$cashapp != null : !((Object)this$cashapp).equals(other$cashapp)) {
            return false;
        }
        Crypto this$crypto = this.getCrypto();
        Crypto other$crypto = other.getCrypto();
        if (this$crypto == null ? other$crypto != null : !((Object)this$crypto).equals(other$crypto)) {
            return false;
        }
        CustomerBalance this$customerBalance = this.getCustomerBalance();
        CustomerBalance other$customerBalance = other.getCustomerBalance();
        if (this$customerBalance == null ? other$customerBalance != null : !((Object)this$customerBalance).equals(other$customerBalance)) {
            return false;
        }
        Eps this$eps = this.getEps();
        Eps other$eps = other.getEps();
        if (this$eps == null ? other$eps != null : !((Object)this$eps).equals(other$eps)) {
            return false;
        }
        Fpx this$fpx = this.getFpx();
        Fpx other$fpx = other.getFpx();
        if (this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx)) {
            return false;
        }
        Giropay this$giropay = this.getGiropay();
        Giropay other$giropay = other.getGiropay();
        if (this$giropay == null ? other$giropay != null : !((Object)this$giropay).equals(other$giropay)) {
            return false;
        }
        GooglePay this$googlePay = this.getGooglePay();
        GooglePay other$googlePay = other.getGooglePay();
        if (this$googlePay == null ? other$googlePay != null : !((Object)this$googlePay).equals(other$googlePay)) {
            return false;
        }
        Grabpay this$grabpay = this.getGrabpay();
        Grabpay other$grabpay = other.getGrabpay();
        if (this$grabpay == null ? other$grabpay != null : !((Object)this$grabpay).equals(other$grabpay)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Ideal this$ideal = this.getIdeal();
        Ideal other$ideal = other.getIdeal();
        if (this$ideal == null ? other$ideal != null : !((Object)this$ideal).equals(other$ideal)) {
            return false;
        }
        Jcb this$jcb = this.getJcb();
        Jcb other$jcb = other.getJcb();
        if (this$jcb == null ? other$jcb != null : !((Object)this$jcb).equals(other$jcb)) {
            return false;
        }
        KakaoPay this$kakaoPay = this.getKakaoPay();
        KakaoPay other$kakaoPay = other.getKakaoPay();
        if (this$kakaoPay == null ? other$kakaoPay != null : !((Object)this$kakaoPay).equals(other$kakaoPay)) {
            return false;
        }
        Klarna this$klarna = this.getKlarna();
        Klarna other$klarna = other.getKlarna();
        if (this$klarna == null ? other$klarna != null : !((Object)this$klarna).equals(other$klarna)) {
            return false;
        }
        Konbini this$konbini = this.getKonbini();
        Konbini other$konbini = other.getKonbini();
        if (this$konbini == null ? other$konbini != null : !((Object)this$konbini).equals(other$konbini)) {
            return false;
        }
        KrCard this$krCard = this.getKrCard();
        KrCard other$krCard = other.getKrCard();
        if (this$krCard == null ? other$krCard != null : !((Object)this$krCard).equals(other$krCard)) {
            return false;
        }
        Link this$link = this.getLink();
        Link other$link = other.getLink();
        if (this$link == null ? other$link != null : !((Object)this$link).equals(other$link)) {
            return false;
        }
        MbWay this$mbWay = this.getMbWay();
        MbWay other$mbWay = other.getMbWay();
        if (this$mbWay == null ? other$mbWay != null : !((Object)this$mbWay).equals(other$mbWay)) {
            return false;
        }
        Mobilepay this$mobilepay = this.getMobilepay();
        Mobilepay other$mobilepay = other.getMobilepay();
        if (this$mobilepay == null ? other$mobilepay != null : !((Object)this$mobilepay).equals(other$mobilepay)) {
            return false;
        }
        Multibanco this$multibanco = this.getMultibanco();
        Multibanco other$multibanco = other.getMultibanco();
        if (this$multibanco == null ? other$multibanco != null : !((Object)this$multibanco).equals(other$multibanco)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NaverPay this$naverPay = this.getNaverPay();
        NaverPay other$naverPay = other.getNaverPay();
        if (this$naverPay == null ? other$naverPay != null : !((Object)this$naverPay).equals(other$naverPay)) {
            return false;
        }
        NzBankAccount this$nzBankAccount = this.getNzBankAccount();
        NzBankAccount other$nzBankAccount = other.getNzBankAccount();
        if (this$nzBankAccount == null ? other$nzBankAccount != null : !((Object)this$nzBankAccount).equals(other$nzBankAccount)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Oxxo this$oxxo = this.getOxxo();
        Oxxo other$oxxo = other.getOxxo();
        if (this$oxxo == null ? other$oxxo != null : !((Object)this$oxxo).equals(other$oxxo)) {
            return false;
        }
        P24 this$p24 = this.getP24();
        P24 other$p24 = other.getP24();
        if (this$p24 == null ? other$p24 != null : !((Object)this$p24).equals(other$p24)) {
            return false;
        }
        String this$parent = this.getParent();
        String other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !this$parent.equals(other$parent)) {
            return false;
        }
        PayByBank this$payByBank = this.getPayByBank();
        PayByBank other$payByBank = other.getPayByBank();
        if (this$payByBank == null ? other$payByBank != null : !((Object)this$payByBank).equals(other$payByBank)) {
            return false;
        }
        Payco this$payco = this.getPayco();
        Payco other$payco = other.getPayco();
        if (this$payco == null ? other$payco != null : !((Object)this$payco).equals(other$payco)) {
            return false;
        }
        Paynow this$paynow = this.getPaynow();
        Paynow other$paynow = other.getPaynow();
        if (this$paynow == null ? other$paynow != null : !((Object)this$paynow).equals(other$paynow)) {
            return false;
        }
        Paypal this$paypal = this.getPaypal();
        Paypal other$paypal = other.getPaypal();
        if (this$paypal == null ? other$paypal != null : !((Object)this$paypal).equals(other$paypal)) {
            return false;
        }
        Pix this$pix = this.getPix();
        Pix other$pix = other.getPix();
        if (this$pix == null ? other$pix != null : !((Object)this$pix).equals(other$pix)) {
            return false;
        }
        Promptpay this$promptpay = this.getPromptpay();
        Promptpay other$promptpay = other.getPromptpay();
        if (this$promptpay == null ? other$promptpay != null : !((Object)this$promptpay).equals(other$promptpay)) {
            return false;
        }
        RevolutPay this$revolutPay = this.getRevolutPay();
        RevolutPay other$revolutPay = other.getRevolutPay();
        if (this$revolutPay == null ? other$revolutPay != null : !((Object)this$revolutPay).equals(other$revolutPay)) {
            return false;
        }
        SamsungPay this$samsungPay = this.getSamsungPay();
        SamsungPay other$samsungPay = other.getSamsungPay();
        if (this$samsungPay == null ? other$samsungPay != null : !((Object)this$samsungPay).equals(other$samsungPay)) {
            return false;
        }
        Satispay this$satispay = this.getSatispay();
        Satispay other$satispay = other.getSatispay();
        if (this$satispay == null ? other$satispay != null : !((Object)this$satispay).equals(other$satispay)) {
            return false;
        }
        SepaDebit this$sepaDebit = this.getSepaDebit();
        SepaDebit other$sepaDebit = other.getSepaDebit();
        if (this$sepaDebit == null ? other$sepaDebit != null : !((Object)this$sepaDebit).equals(other$sepaDebit)) {
            return false;
        }
        Sofort this$sofort = this.getSofort();
        Sofort other$sofort = other.getSofort();
        if (this$sofort == null ? other$sofort != null : !((Object)this$sofort).equals(other$sofort)) {
            return false;
        }
        Swish this$swish = this.getSwish();
        Swish other$swish = other.getSwish();
        if (this$swish == null ? other$swish != null : !((Object)this$swish).equals(other$swish)) {
            return false;
        }
        Twint this$twint = this.getTwint();
        Twint other$twint = other.getTwint();
        if (this$twint == null ? other$twint != null : !((Object)this$twint).equals(other$twint)) {
            return false;
        }
        UsBankAccount this$usBankAccount = this.getUsBankAccount();
        UsBankAccount other$usBankAccount = other.getUsBankAccount();
        if (this$usBankAccount == null ? other$usBankAccount != null : !((Object)this$usBankAccount).equals(other$usBankAccount)) {
            return false;
        }
        WechatPay this$wechatPay = this.getWechatPay();
        WechatPay other$wechatPay = other.getWechatPay();
        if (this$wechatPay == null ? other$wechatPay != null : !((Object)this$wechatPay).equals(other$wechatPay)) {
            return false;
        }
        Zip this$zip = this.getZip();
        Zip other$zip = other.getZip();
        return !(this$zip == null ? other$zip != null : !((Object)this$zip).equals(other$zip));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PaymentMethodConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        AcssDebit $acssDebit = this.getAcssDebit();
        result = result * 59 + ($acssDebit == null ? 43 : ((Object)$acssDebit).hashCode());
        Affirm $affirm = this.getAffirm();
        result = result * 59 + ($affirm == null ? 43 : ((Object)$affirm).hashCode());
        AfterpayClearpay $afterpayClearpay = this.getAfterpayClearpay();
        result = result * 59 + ($afterpayClearpay == null ? 43 : ((Object)$afterpayClearpay).hashCode());
        Alipay $alipay = this.getAlipay();
        result = result * 59 + ($alipay == null ? 43 : ((Object)$alipay).hashCode());
        Alma $alma = this.getAlma();
        result = result * 59 + ($alma == null ? 43 : ((Object)$alma).hashCode());
        AmazonPay $amazonPay = this.getAmazonPay();
        result = result * 59 + ($amazonPay == null ? 43 : ((Object)$amazonPay).hashCode());
        ApplePay $applePay = this.getApplePay();
        result = result * 59 + ($applePay == null ? 43 : ((Object)$applePay).hashCode());
        String $application = this.getApplication();
        result = result * 59 + ($application == null ? 43 : $application.hashCode());
        AuBecsDebit $auBecsDebit = this.getAuBecsDebit();
        result = result * 59 + ($auBecsDebit == null ? 43 : ((Object)$auBecsDebit).hashCode());
        BacsDebit $bacsDebit = this.getBacsDebit();
        result = result * 59 + ($bacsDebit == null ? 43 : ((Object)$bacsDebit).hashCode());
        Bancontact $bancontact = this.getBancontact();
        result = result * 59 + ($bancontact == null ? 43 : ((Object)$bancontact).hashCode());
        Billie $billie = this.getBillie();
        result = result * 59 + ($billie == null ? 43 : ((Object)$billie).hashCode());
        Blik $blik = this.getBlik();
        result = result * 59 + ($blik == null ? 43 : ((Object)$blik).hashCode());
        Boleto $boleto = this.getBoleto();
        result = result * 59 + ($boleto == null ? 43 : ((Object)$boleto).hashCode());
        Card $card = this.getCard();
        result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
        CartesBancaires $cartesBancaires = this.getCartesBancaires();
        result = result * 59 + ($cartesBancaires == null ? 43 : ((Object)$cartesBancaires).hashCode());
        Cashapp $cashapp = this.getCashapp();
        result = result * 59 + ($cashapp == null ? 43 : ((Object)$cashapp).hashCode());
        Crypto $crypto = this.getCrypto();
        result = result * 59 + ($crypto == null ? 43 : ((Object)$crypto).hashCode());
        CustomerBalance $customerBalance = this.getCustomerBalance();
        result = result * 59 + ($customerBalance == null ? 43 : ((Object)$customerBalance).hashCode());
        Eps $eps = this.getEps();
        result = result * 59 + ($eps == null ? 43 : ((Object)$eps).hashCode());
        Fpx $fpx = this.getFpx();
        result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
        Giropay $giropay = this.getGiropay();
        result = result * 59 + ($giropay == null ? 43 : ((Object)$giropay).hashCode());
        GooglePay $googlePay = this.getGooglePay();
        result = result * 59 + ($googlePay == null ? 43 : ((Object)$googlePay).hashCode());
        Grabpay $grabpay = this.getGrabpay();
        result = result * 59 + ($grabpay == null ? 43 : ((Object)$grabpay).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Ideal $ideal = this.getIdeal();
        result = result * 59 + ($ideal == null ? 43 : ((Object)$ideal).hashCode());
        Jcb $jcb = this.getJcb();
        result = result * 59 + ($jcb == null ? 43 : ((Object)$jcb).hashCode());
        KakaoPay $kakaoPay = this.getKakaoPay();
        result = result * 59 + ($kakaoPay == null ? 43 : ((Object)$kakaoPay).hashCode());
        Klarna $klarna = this.getKlarna();
        result = result * 59 + ($klarna == null ? 43 : ((Object)$klarna).hashCode());
        Konbini $konbini = this.getKonbini();
        result = result * 59 + ($konbini == null ? 43 : ((Object)$konbini).hashCode());
        KrCard $krCard = this.getKrCard();
        result = result * 59 + ($krCard == null ? 43 : ((Object)$krCard).hashCode());
        Link $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : ((Object)$link).hashCode());
        MbWay $mbWay = this.getMbWay();
        result = result * 59 + ($mbWay == null ? 43 : ((Object)$mbWay).hashCode());
        Mobilepay $mobilepay = this.getMobilepay();
        result = result * 59 + ($mobilepay == null ? 43 : ((Object)$mobilepay).hashCode());
        Multibanco $multibanco = this.getMultibanco();
        result = result * 59 + ($multibanco == null ? 43 : ((Object)$multibanco).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NaverPay $naverPay = this.getNaverPay();
        result = result * 59 + ($naverPay == null ? 43 : ((Object)$naverPay).hashCode());
        NzBankAccount $nzBankAccount = this.getNzBankAccount();
        result = result * 59 + ($nzBankAccount == null ? 43 : ((Object)$nzBankAccount).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Oxxo $oxxo = this.getOxxo();
        result = result * 59 + ($oxxo == null ? 43 : ((Object)$oxxo).hashCode());
        P24 $p24 = this.getP24();
        result = result * 59 + ($p24 == null ? 43 : ((Object)$p24).hashCode());
        String $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : $parent.hashCode());
        PayByBank $payByBank = this.getPayByBank();
        result = result * 59 + ($payByBank == null ? 43 : ((Object)$payByBank).hashCode());
        Payco $payco = this.getPayco();
        result = result * 59 + ($payco == null ? 43 : ((Object)$payco).hashCode());
        Paynow $paynow = this.getPaynow();
        result = result * 59 + ($paynow == null ? 43 : ((Object)$paynow).hashCode());
        Paypal $paypal = this.getPaypal();
        result = result * 59 + ($paypal == null ? 43 : ((Object)$paypal).hashCode());
        Pix $pix = this.getPix();
        result = result * 59 + ($pix == null ? 43 : ((Object)$pix).hashCode());
        Promptpay $promptpay = this.getPromptpay();
        result = result * 59 + ($promptpay == null ? 43 : ((Object)$promptpay).hashCode());
        RevolutPay $revolutPay = this.getRevolutPay();
        result = result * 59 + ($revolutPay == null ? 43 : ((Object)$revolutPay).hashCode());
        SamsungPay $samsungPay = this.getSamsungPay();
        result = result * 59 + ($samsungPay == null ? 43 : ((Object)$samsungPay).hashCode());
        Satispay $satispay = this.getSatispay();
        result = result * 59 + ($satispay == null ? 43 : ((Object)$satispay).hashCode());
        SepaDebit $sepaDebit = this.getSepaDebit();
        result = result * 59 + ($sepaDebit == null ? 43 : ((Object)$sepaDebit).hashCode());
        Sofort $sofort = this.getSofort();
        result = result * 59 + ($sofort == null ? 43 : ((Object)$sofort).hashCode());
        Swish $swish = this.getSwish();
        result = result * 59 + ($swish == null ? 43 : ((Object)$swish).hashCode());
        Twint $twint = this.getTwint();
        result = result * 59 + ($twint == null ? 43 : ((Object)$twint).hashCode());
        UsBankAccount $usBankAccount = this.getUsBankAccount();
        result = result * 59 + ($usBankAccount == null ? 43 : ((Object)$usBankAccount).hashCode());
        WechatPay $wechatPay = this.getWechatPay();
        result = result * 59 + ($wechatPay == null ? 43 : ((Object)$wechatPay).hashCode());
        Zip $zip = this.getZip();
        result = result * 59 + ($zip == null ? 43 : ((Object)$zip).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class AcssDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AcssDebit)) {
                return false;
            }
            AcssDebit other = (AcssDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AcssDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Affirm
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Affirm)) {
                return false;
            }
            Affirm other = (Affirm)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Affirm;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class AfterpayClearpay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AfterpayClearpay)) {
                return false;
            }
            AfterpayClearpay other = (AfterpayClearpay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AfterpayClearpay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Alipay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alipay)) {
                return false;
            }
            Alipay other = (Alipay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Alipay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Alma
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Alma)) {
                return false;
            }
            Alma other = (Alma)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Alma;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class AmazonPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AmazonPay)) {
                return false;
            }
            AmazonPay other = (AmazonPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AmazonPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class ApplePay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ApplePay)) {
                return false;
            }
            ApplePay other = (ApplePay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ApplePay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class AuBecsDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuBecsDebit)) {
                return false;
            }
            AuBecsDebit other = (AuBecsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuBecsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class BacsDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BacsDebit)) {
                return false;
            }
            BacsDebit other = (BacsDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BacsDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Bancontact
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Bancontact)) {
                return false;
            }
            Bancontact other = (Bancontact)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Bancontact;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Billie
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Billie)) {
                return false;
            }
            Billie other = (Billie)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Billie;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Blik
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Blik)) {
                return false;
            }
            Blik other = (Blik)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Blik;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Boleto
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Boleto)) {
                return false;
            }
            Boleto other = (Boleto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Boleto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Card
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Card)) {
                return false;
            }
            Card other = (Card)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Card;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class CartesBancaires
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CartesBancaires)) {
                return false;
            }
            CartesBancaires other = (CartesBancaires)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CartesBancaires;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Cashapp
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cashapp)) {
                return false;
            }
            Cashapp other = (Cashapp)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Cashapp;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Crypto
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Crypto)) {
                return false;
            }
            Crypto other = (Crypto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Crypto;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class CustomerBalance
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CustomerBalance)) {
                return false;
            }
            CustomerBalance other = (CustomerBalance)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CustomerBalance;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Eps
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Eps)) {
                return false;
            }
            Eps other = (Eps)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Eps;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Fpx
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Fpx)) {
                return false;
            }
            Fpx other = (Fpx)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Fpx;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Giropay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Giropay)) {
                return false;
            }
            Giropay other = (Giropay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Giropay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class GooglePay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GooglePay)) {
                return false;
            }
            GooglePay other = (GooglePay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof GooglePay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Grabpay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Grabpay)) {
                return false;
            }
            Grabpay other = (Grabpay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Grabpay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Ideal
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ideal)) {
                return false;
            }
            Ideal other = (Ideal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Ideal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Jcb
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Jcb)) {
                return false;
            }
            Jcb other = (Jcb)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Jcb;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class KakaoPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KakaoPay)) {
                return false;
            }
            KakaoPay other = (KakaoPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KakaoPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Klarna
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Klarna)) {
                return false;
            }
            Klarna other = (Klarna)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Klarna;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Konbini
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Konbini)) {
                return false;
            }
            Konbini other = (Konbini)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Konbini;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class KrCard
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KrCard)) {
                return false;
            }
            KrCard other = (KrCard)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof KrCard;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Link
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Link)) {
                return false;
            }
            Link other = (Link)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Link;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class MbWay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MbWay)) {
                return false;
            }
            MbWay other = (MbWay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MbWay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Mobilepay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mobilepay)) {
                return false;
            }
            Mobilepay other = (Mobilepay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Mobilepay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Multibanco
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Multibanco)) {
                return false;
            }
            Multibanco other = (Multibanco)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Multibanco;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class NaverPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NaverPay)) {
                return false;
            }
            NaverPay other = (NaverPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NaverPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class NzBankAccount
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NzBankAccount)) {
                return false;
            }
            NzBankAccount other = (NzBankAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof NzBankAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Oxxo
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Oxxo)) {
                return false;
            }
            Oxxo other = (Oxxo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Oxxo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class P24
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof P24)) {
                return false;
            }
            P24 other = (P24)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof P24;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class PayByBank
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PayByBank)) {
                return false;
            }
            PayByBank other = (PayByBank)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PayByBank;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Payco
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Payco)) {
                return false;
            }
            Payco other = (Payco)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Payco;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Paynow
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paynow)) {
                return false;
            }
            Paynow other = (Paynow)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paynow;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Paypal
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Paypal)) {
                return false;
            }
            Paypal other = (Paypal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Paypal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Pix
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pix)) {
                return false;
            }
            Pix other = (Pix)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pix;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Promptpay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Promptpay)) {
                return false;
            }
            Promptpay other = (Promptpay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Promptpay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class RevolutPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RevolutPay)) {
                return false;
            }
            RevolutPay other = (RevolutPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RevolutPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class SamsungPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SamsungPay)) {
                return false;
            }
            SamsungPay other = (SamsungPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SamsungPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Satispay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Satispay)) {
                return false;
            }
            Satispay other = (Satispay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Satispay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class SepaDebit
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SepaDebit)) {
                return false;
            }
            SepaDebit other = (SepaDebit)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SepaDebit;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Sofort
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Sofort)) {
                return false;
            }
            Sofort other = (Sofort)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Sofort;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Swish
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Swish)) {
                return false;
            }
            Swish other = (Swish)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Swish;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Twint
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Twint)) {
                return false;
            }
            Twint other = (Twint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Twint;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class UsBankAccount
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsBankAccount)) {
                return false;
            }
            UsBankAccount other = (UsBankAccount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsBankAccount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class WechatPay
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WechatPay)) {
                return false;
            }
            WechatPay other = (WechatPay)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WechatPay;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }

    public static class Zip
    extends StripeObject {
        @SerializedName(value="available")
        Boolean available;
        @SerializedName(value="display_preference")
        DisplayPreference displayPreference;

        @Generated
        public Boolean getAvailable() {
            return this.available;
        }

        @Generated
        public DisplayPreference getDisplayPreference() {
            return this.displayPreference;
        }

        @Generated
        public void setAvailable(Boolean available) {
            this.available = available;
        }

        @Generated
        public void setDisplayPreference(DisplayPreference displayPreference) {
            this.displayPreference = displayPreference;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Zip)) {
                return false;
            }
            Zip other = (Zip)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$available = this.getAvailable();
            Boolean other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            DisplayPreference this$displayPreference = this.getDisplayPreference();
            DisplayPreference other$displayPreference = other.getDisplayPreference();
            return !(this$displayPreference == null ? other$displayPreference != null : !((Object)this$displayPreference).equals(other$displayPreference));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Zip;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            DisplayPreference $displayPreference = this.getDisplayPreference();
            result = result * 59 + ($displayPreference == null ? 43 : ((Object)$displayPreference).hashCode());
            return result;
        }

        public static class DisplayPreference
        extends StripeObject {
            @SerializedName(value="overridable")
            Boolean overridable;
            @SerializedName(value="preference")
            String preference;
            @SerializedName(value="value")
            String value;

            @Generated
            public Boolean getOverridable() {
                return this.overridable;
            }

            @Generated
            public String getPreference() {
                return this.preference;
            }

            @Generated
            public String getValue() {
                return this.value;
            }

            @Generated
            public void setOverridable(Boolean overridable) {
                this.overridable = overridable;
            }

            @Generated
            public void setPreference(String preference) {
                this.preference = preference;
            }

            @Generated
            public void setValue(String value) {
                this.value = value;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof DisplayPreference)) {
                    return false;
                }
                DisplayPreference other = (DisplayPreference)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$overridable = this.getOverridable();
                Boolean other$overridable = other.getOverridable();
                if (this$overridable == null ? other$overridable != null : !((Object)this$overridable).equals(other$overridable)) {
                    return false;
                }
                String this$preference = this.getPreference();
                String other$preference = other.getPreference();
                if (this$preference == null ? other$preference != null : !this$preference.equals(other$preference)) {
                    return false;
                }
                String this$value = this.getValue();
                String other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof DisplayPreference;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $overridable = this.getOverridable();
                result = result * 59 + ($overridable == null ? 43 : ((Object)$overridable).hashCode());
                String $preference = this.getPreference();
                result = result * 59 + ($preference == null ? 43 : $preference.hashCode());
                String $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }
        }
    }
}

