/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.BalanceRetrieveParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Balance
extends ApiResource {
    @SerializedName(value="available")
    List<Available> available;
    @SerializedName(value="connect_reserved")
    List<ConnectReserved> connectReserved;
    @SerializedName(value="instant_available")
    List<InstantAvailable> instantAvailable;
    @SerializedName(value="issuing")
    Issuing issuing;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="pending")
    List<Pending> pending;
    @SerializedName(value="refund_and_dispute_prefunding")
    RefundAndDisputePrefunding refundAndDisputePrefunding;
    @SerializedName(value="transit_balances_total")
    TransitBalancesTotal transitBalancesTotal;

    public static Balance retrieve() throws StripeException {
        return Balance.retrieve((Map<String, Object>)null, (RequestOptions)null);
    }

    public static Balance retrieve(RequestOptions options) throws StripeException {
        return Balance.retrieve((Map<String, Object>)null, options);
    }

    public static Balance retrieve(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/balance";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Balance)Balance.getGlobalResponseGetter().request(request, (Type)((Object)Balance.class));
    }

    public static Balance retrieve(BalanceRetrieveParams params, RequestOptions options) throws StripeException {
        String path = "/v1/balance";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Balance)Balance.getGlobalResponseGetter().request(request, (Type)((Object)Balance.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.issuing, responseGetter);
        this.trySetResponseGetter(this.refundAndDisputePrefunding, responseGetter);
        this.trySetResponseGetter(this.transitBalancesTotal, responseGetter);
    }

    @Generated
    public List<Available> getAvailable() {
        return this.available;
    }

    @Generated
    public List<ConnectReserved> getConnectReserved() {
        return this.connectReserved;
    }

    @Generated
    public List<InstantAvailable> getInstantAvailable() {
        return this.instantAvailable;
    }

    @Generated
    public Issuing getIssuing() {
        return this.issuing;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public List<Pending> getPending() {
        return this.pending;
    }

    @Generated
    public RefundAndDisputePrefunding getRefundAndDisputePrefunding() {
        return this.refundAndDisputePrefunding;
    }

    @Generated
    public TransitBalancesTotal getTransitBalancesTotal() {
        return this.transitBalancesTotal;
    }

    @Generated
    public void setAvailable(List<Available> available) {
        this.available = available;
    }

    @Generated
    public void setConnectReserved(List<ConnectReserved> connectReserved) {
        this.connectReserved = connectReserved;
    }

    @Generated
    public void setInstantAvailable(List<InstantAvailable> instantAvailable) {
        this.instantAvailable = instantAvailable;
    }

    @Generated
    public void setIssuing(Issuing issuing) {
        this.issuing = issuing;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setPending(List<Pending> pending) {
        this.pending = pending;
    }

    @Generated
    public void setRefundAndDisputePrefunding(RefundAndDisputePrefunding refundAndDisputePrefunding) {
        this.refundAndDisputePrefunding = refundAndDisputePrefunding;
    }

    @Generated
    public void setTransitBalancesTotal(TransitBalancesTotal transitBalancesTotal) {
        this.transitBalancesTotal = transitBalancesTotal;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Balance)) {
            return false;
        }
        Balance other = (Balance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        List<Available> this$available = this.getAvailable();
        List<Available> other$available = other.getAvailable();
        if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
            return false;
        }
        List<ConnectReserved> this$connectReserved = this.getConnectReserved();
        List<ConnectReserved> other$connectReserved = other.getConnectReserved();
        if (this$connectReserved == null ? other$connectReserved != null : !((Object)this$connectReserved).equals(other$connectReserved)) {
            return false;
        }
        List<InstantAvailable> this$instantAvailable = this.getInstantAvailable();
        List<InstantAvailable> other$instantAvailable = other.getInstantAvailable();
        if (this$instantAvailable == null ? other$instantAvailable != null : !((Object)this$instantAvailable).equals(other$instantAvailable)) {
            return false;
        }
        Issuing this$issuing = this.getIssuing();
        Issuing other$issuing = other.getIssuing();
        if (this$issuing == null ? other$issuing != null : !((Object)this$issuing).equals(other$issuing)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        List<Pending> this$pending = this.getPending();
        List<Pending> other$pending = other.getPending();
        if (this$pending == null ? other$pending != null : !((Object)this$pending).equals(other$pending)) {
            return false;
        }
        RefundAndDisputePrefunding this$refundAndDisputePrefunding = this.getRefundAndDisputePrefunding();
        RefundAndDisputePrefunding other$refundAndDisputePrefunding = other.getRefundAndDisputePrefunding();
        if (this$refundAndDisputePrefunding == null ? other$refundAndDisputePrefunding != null : !((Object)this$refundAndDisputePrefunding).equals(other$refundAndDisputePrefunding)) {
            return false;
        }
        TransitBalancesTotal this$transitBalancesTotal = this.getTransitBalancesTotal();
        TransitBalancesTotal other$transitBalancesTotal = other.getTransitBalancesTotal();
        return !(this$transitBalancesTotal == null ? other$transitBalancesTotal != null : !((Object)this$transitBalancesTotal).equals(other$transitBalancesTotal));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Balance;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        List<Available> $available = this.getAvailable();
        result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
        List<ConnectReserved> $connectReserved = this.getConnectReserved();
        result = result * 59 + ($connectReserved == null ? 43 : ((Object)$connectReserved).hashCode());
        List<InstantAvailable> $instantAvailable = this.getInstantAvailable();
        result = result * 59 + ($instantAvailable == null ? 43 : ((Object)$instantAvailable).hashCode());
        Issuing $issuing = this.getIssuing();
        result = result * 59 + ($issuing == null ? 43 : ((Object)$issuing).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        List<Pending> $pending = this.getPending();
        result = result * 59 + ($pending == null ? 43 : ((Object)$pending).hashCode());
        RefundAndDisputePrefunding $refundAndDisputePrefunding = this.getRefundAndDisputePrefunding();
        result = result * 59 + ($refundAndDisputePrefunding == null ? 43 : ((Object)$refundAndDisputePrefunding).hashCode());
        TransitBalancesTotal $transitBalancesTotal = this.getTransitBalancesTotal();
        result = result * 59 + ($transitBalancesTotal == null ? 43 : ((Object)$transitBalancesTotal).hashCode());
        return result;
    }

    public static class Issuing
    extends StripeObject {
        @SerializedName(value="available")
        List<Available> available;

        @Generated
        public List<Available> getAvailable() {
            return this.available;
        }

        @Generated
        public void setAvailable(List<Available> available) {
            this.available = available;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Issuing)) {
                return false;
            }
            Issuing other = (Issuing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Available> this$available = this.getAvailable();
            List<Available> other$available = other.getAvailable();
            return !(this$available == null ? other$available != null : !((Object)this$available).equals(other$available));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Issuing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Available> $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            return result;
        }

        public static class Available
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="source_types")
            SourceTypes sourceTypes;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public SourceTypes getSourceTypes() {
                return this.sourceTypes;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setSourceTypes(SourceTypes sourceTypes) {
                this.sourceTypes = sourceTypes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Available)) {
                    return false;
                }
                Available other = (Available)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                SourceTypes this$sourceTypes = this.getSourceTypes();
                SourceTypes other$sourceTypes = other.getSourceTypes();
                return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Available;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                SourceTypes $sourceTypes = this.getSourceTypes();
                result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
                return result;
            }

            public static class SourceTypes
            extends StripeObject {
                @SerializedName(value="bank_account")
                Long bankAccount;
                @SerializedName(value="card")
                Long card;
                @SerializedName(value="fpx")
                Long fpx;

                @Generated
                public Long getBankAccount() {
                    return this.bankAccount;
                }

                @Generated
                public Long getCard() {
                    return this.card;
                }

                @Generated
                public Long getFpx() {
                    return this.fpx;
                }

                @Generated
                public void setBankAccount(Long bankAccount) {
                    this.bankAccount = bankAccount;
                }

                @Generated
                public void setCard(Long card) {
                    this.card = card;
                }

                @Generated
                public void setFpx(Long fpx) {
                    this.fpx = fpx;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SourceTypes)) {
                        return false;
                    }
                    SourceTypes other = (SourceTypes)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$bankAccount = this.getBankAccount();
                    Long other$bankAccount = other.getBankAccount();
                    if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                        return false;
                    }
                    Long this$card = this.getCard();
                    Long other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    Long this$fpx = this.getFpx();
                    Long other$fpx = other.getFpx();
                    return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SourceTypes;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $bankAccount = this.getBankAccount();
                    result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                    Long $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    Long $fpx = this.getFpx();
                    result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                    return result;
                }
            }
        }
    }

    public static class RefundAndDisputePrefunding
    extends StripeObject {
        @SerializedName(value="available")
        List<Available> available;
        @SerializedName(value="pending")
        List<Pending> pending;

        @Generated
        public List<Available> getAvailable() {
            return this.available;
        }

        @Generated
        public List<Pending> getPending() {
            return this.pending;
        }

        @Generated
        public void setAvailable(List<Available> available) {
            this.available = available;
        }

        @Generated
        public void setPending(List<Pending> pending) {
            this.pending = pending;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RefundAndDisputePrefunding)) {
                return false;
            }
            RefundAndDisputePrefunding other = (RefundAndDisputePrefunding)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Available> this$available = this.getAvailable();
            List<Available> other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            List<Pending> this$pending = this.getPending();
            List<Pending> other$pending = other.getPending();
            return !(this$pending == null ? other$pending != null : !((Object)this$pending).equals(other$pending));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RefundAndDisputePrefunding;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Available> $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            List<Pending> $pending = this.getPending();
            result = result * 59 + ($pending == null ? 43 : ((Object)$pending).hashCode());
            return result;
        }

        public static class Pending
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="source_types")
            SourceTypes sourceTypes;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public SourceTypes getSourceTypes() {
                return this.sourceTypes;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setSourceTypes(SourceTypes sourceTypes) {
                this.sourceTypes = sourceTypes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pending)) {
                    return false;
                }
                Pending other = (Pending)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                SourceTypes this$sourceTypes = this.getSourceTypes();
                SourceTypes other$sourceTypes = other.getSourceTypes();
                return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pending;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                SourceTypes $sourceTypes = this.getSourceTypes();
                result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
                return result;
            }

            public static class SourceTypes
            extends StripeObject {
                @SerializedName(value="bank_account")
                Long bankAccount;
                @SerializedName(value="card")
                Long card;
                @SerializedName(value="fpx")
                Long fpx;

                @Generated
                public Long getBankAccount() {
                    return this.bankAccount;
                }

                @Generated
                public Long getCard() {
                    return this.card;
                }

                @Generated
                public Long getFpx() {
                    return this.fpx;
                }

                @Generated
                public void setBankAccount(Long bankAccount) {
                    this.bankAccount = bankAccount;
                }

                @Generated
                public void setCard(Long card) {
                    this.card = card;
                }

                @Generated
                public void setFpx(Long fpx) {
                    this.fpx = fpx;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SourceTypes)) {
                        return false;
                    }
                    SourceTypes other = (SourceTypes)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$bankAccount = this.getBankAccount();
                    Long other$bankAccount = other.getBankAccount();
                    if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                        return false;
                    }
                    Long this$card = this.getCard();
                    Long other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    Long this$fpx = this.getFpx();
                    Long other$fpx = other.getFpx();
                    return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SourceTypes;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $bankAccount = this.getBankAccount();
                    result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                    Long $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    Long $fpx = this.getFpx();
                    result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                    return result;
                }
            }
        }

        public static class Available
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="source_types")
            SourceTypes sourceTypes;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public SourceTypes getSourceTypes() {
                return this.sourceTypes;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setSourceTypes(SourceTypes sourceTypes) {
                this.sourceTypes = sourceTypes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Available)) {
                    return false;
                }
                Available other = (Available)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                SourceTypes this$sourceTypes = this.getSourceTypes();
                SourceTypes other$sourceTypes = other.getSourceTypes();
                return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Available;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                SourceTypes $sourceTypes = this.getSourceTypes();
                result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
                return result;
            }

            public static class SourceTypes
            extends StripeObject {
                @SerializedName(value="bank_account")
                Long bankAccount;
                @SerializedName(value="card")
                Long card;
                @SerializedName(value="fpx")
                Long fpx;

                @Generated
                public Long getBankAccount() {
                    return this.bankAccount;
                }

                @Generated
                public Long getCard() {
                    return this.card;
                }

                @Generated
                public Long getFpx() {
                    return this.fpx;
                }

                @Generated
                public void setBankAccount(Long bankAccount) {
                    this.bankAccount = bankAccount;
                }

                @Generated
                public void setCard(Long card) {
                    this.card = card;
                }

                @Generated
                public void setFpx(Long fpx) {
                    this.fpx = fpx;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SourceTypes)) {
                        return false;
                    }
                    SourceTypes other = (SourceTypes)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$bankAccount = this.getBankAccount();
                    Long other$bankAccount = other.getBankAccount();
                    if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                        return false;
                    }
                    Long this$card = this.getCard();
                    Long other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    Long this$fpx = this.getFpx();
                    Long other$fpx = other.getFpx();
                    return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SourceTypes;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $bankAccount = this.getBankAccount();
                    result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                    Long $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    Long $fpx = this.getFpx();
                    result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                    return result;
                }
            }
        }
    }

    public static class TransitBalancesTotal
    extends StripeObject {
        @SerializedName(value="available")
        List<Available> available;
        @SerializedName(value="pending")
        List<Pending> pending;

        @Generated
        public List<Available> getAvailable() {
            return this.available;
        }

        @Generated
        public List<Pending> getPending() {
            return this.pending;
        }

        @Generated
        public void setAvailable(List<Available> available) {
            this.available = available;
        }

        @Generated
        public void setPending(List<Pending> pending) {
            this.pending = pending;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransitBalancesTotal)) {
                return false;
            }
            TransitBalancesTotal other = (TransitBalancesTotal)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Available> this$available = this.getAvailable();
            List<Available> other$available = other.getAvailable();
            if (this$available == null ? other$available != null : !((Object)this$available).equals(other$available)) {
                return false;
            }
            List<Pending> this$pending = this.getPending();
            List<Pending> other$pending = other.getPending();
            return !(this$pending == null ? other$pending != null : !((Object)this$pending).equals(other$pending));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TransitBalancesTotal;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Available> $available = this.getAvailable();
            result = result * 59 + ($available == null ? 43 : ((Object)$available).hashCode());
            List<Pending> $pending = this.getPending();
            result = result * 59 + ($pending == null ? 43 : ((Object)$pending).hashCode());
            return result;
        }

        public static class Pending
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="source_types")
            SourceTypes sourceTypes;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public SourceTypes getSourceTypes() {
                return this.sourceTypes;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setSourceTypes(SourceTypes sourceTypes) {
                this.sourceTypes = sourceTypes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Pending)) {
                    return false;
                }
                Pending other = (Pending)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                SourceTypes this$sourceTypes = this.getSourceTypes();
                SourceTypes other$sourceTypes = other.getSourceTypes();
                return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Pending;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                SourceTypes $sourceTypes = this.getSourceTypes();
                result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
                return result;
            }

            public static class SourceTypes
            extends StripeObject {
                @SerializedName(value="bank_account")
                Long bankAccount;
                @SerializedName(value="card")
                Long card;
                @SerializedName(value="fpx")
                Long fpx;

                @Generated
                public Long getBankAccount() {
                    return this.bankAccount;
                }

                @Generated
                public Long getCard() {
                    return this.card;
                }

                @Generated
                public Long getFpx() {
                    return this.fpx;
                }

                @Generated
                public void setBankAccount(Long bankAccount) {
                    this.bankAccount = bankAccount;
                }

                @Generated
                public void setCard(Long card) {
                    this.card = card;
                }

                @Generated
                public void setFpx(Long fpx) {
                    this.fpx = fpx;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SourceTypes)) {
                        return false;
                    }
                    SourceTypes other = (SourceTypes)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$bankAccount = this.getBankAccount();
                    Long other$bankAccount = other.getBankAccount();
                    if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                        return false;
                    }
                    Long this$card = this.getCard();
                    Long other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    Long this$fpx = this.getFpx();
                    Long other$fpx = other.getFpx();
                    return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SourceTypes;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $bankAccount = this.getBankAccount();
                    result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                    Long $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    Long $fpx = this.getFpx();
                    result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                    return result;
                }
            }
        }

        public static class Available
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="currency")
            String currency;
            @SerializedName(value="source_types")
            SourceTypes sourceTypes;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getCurrency() {
                return this.currency;
            }

            @Generated
            public SourceTypes getSourceTypes() {
                return this.sourceTypes;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setCurrency(String currency) {
                this.currency = currency;
            }

            @Generated
            public void setSourceTypes(SourceTypes sourceTypes) {
                this.sourceTypes = sourceTypes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Available)) {
                    return false;
                }
                Available other = (Available)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$currency = this.getCurrency();
                String other$currency = other.getCurrency();
                if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                    return false;
                }
                SourceTypes this$sourceTypes = this.getSourceTypes();
                SourceTypes other$sourceTypes = other.getSourceTypes();
                return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Available;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $currency = this.getCurrency();
                result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                SourceTypes $sourceTypes = this.getSourceTypes();
                result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
                return result;
            }

            public static class SourceTypes
            extends StripeObject {
                @SerializedName(value="bank_account")
                Long bankAccount;
                @SerializedName(value="card")
                Long card;
                @SerializedName(value="fpx")
                Long fpx;

                @Generated
                public Long getBankAccount() {
                    return this.bankAccount;
                }

                @Generated
                public Long getCard() {
                    return this.card;
                }

                @Generated
                public Long getFpx() {
                    return this.fpx;
                }

                @Generated
                public void setBankAccount(Long bankAccount) {
                    this.bankAccount = bankAccount;
                }

                @Generated
                public void setCard(Long card) {
                    this.card = card;
                }

                @Generated
                public void setFpx(Long fpx) {
                    this.fpx = fpx;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SourceTypes)) {
                        return false;
                    }
                    SourceTypes other = (SourceTypes)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$bankAccount = this.getBankAccount();
                    Long other$bankAccount = other.getBankAccount();
                    if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                        return false;
                    }
                    Long this$card = this.getCard();
                    Long other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    Long this$fpx = this.getFpx();
                    Long other$fpx = other.getFpx();
                    return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SourceTypes;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $bankAccount = this.getBankAccount();
                    result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                    Long $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    Long $fpx = this.getFpx();
                    result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                    return result;
                }
            }
        }
    }

    public static class Pending
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="source_types")
        SourceTypes sourceTypes;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public SourceTypes getSourceTypes() {
            return this.sourceTypes;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setSourceTypes(SourceTypes sourceTypes) {
            this.sourceTypes = sourceTypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pending)) {
                return false;
            }
            Pending other = (Pending)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            SourceTypes this$sourceTypes = this.getSourceTypes();
            SourceTypes other$sourceTypes = other.getSourceTypes();
            return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pending;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            SourceTypes $sourceTypes = this.getSourceTypes();
            result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
            return result;
        }

        public static class SourceTypes
        extends StripeObject {
            @SerializedName(value="bank_account")
            Long bankAccount;
            @SerializedName(value="card")
            Long card;
            @SerializedName(value="fpx")
            Long fpx;

            @Generated
            public Long getBankAccount() {
                return this.bankAccount;
            }

            @Generated
            public Long getCard() {
                return this.card;
            }

            @Generated
            public Long getFpx() {
                return this.fpx;
            }

            @Generated
            public void setBankAccount(Long bankAccount) {
                this.bankAccount = bankAccount;
            }

            @Generated
            public void setCard(Long card) {
                this.card = card;
            }

            @Generated
            public void setFpx(Long fpx) {
                this.fpx = fpx;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceTypes)) {
                    return false;
                }
                SourceTypes other = (SourceTypes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$bankAccount = this.getBankAccount();
                Long other$bankAccount = other.getBankAccount();
                if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                    return false;
                }
                Long this$card = this.getCard();
                Long other$card = other.getCard();
                if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                    return false;
                }
                Long this$fpx = this.getFpx();
                Long other$fpx = other.getFpx();
                return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SourceTypes;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $bankAccount = this.getBankAccount();
                result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                Long $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                Long $fpx = this.getFpx();
                result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                return result;
            }
        }
    }

    public static class InstantAvailable
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="net_available")
        List<NetAvailable> netAvailable;
        @SerializedName(value="source_types")
        SourceTypes sourceTypes;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public List<NetAvailable> getNetAvailable() {
            return this.netAvailable;
        }

        @Generated
        public SourceTypes getSourceTypes() {
            return this.sourceTypes;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setNetAvailable(List<NetAvailable> netAvailable) {
            this.netAvailable = netAvailable;
        }

        @Generated
        public void setSourceTypes(SourceTypes sourceTypes) {
            this.sourceTypes = sourceTypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InstantAvailable)) {
                return false;
            }
            InstantAvailable other = (InstantAvailable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            List<NetAvailable> this$netAvailable = this.getNetAvailable();
            List<NetAvailable> other$netAvailable = other.getNetAvailable();
            if (this$netAvailable == null ? other$netAvailable != null : !((Object)this$netAvailable).equals(other$netAvailable)) {
                return false;
            }
            SourceTypes this$sourceTypes = this.getSourceTypes();
            SourceTypes other$sourceTypes = other.getSourceTypes();
            return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InstantAvailable;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            List<NetAvailable> $netAvailable = this.getNetAvailable();
            result = result * 59 + ($netAvailable == null ? 43 : ((Object)$netAvailable).hashCode());
            SourceTypes $sourceTypes = this.getSourceTypes();
            result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
            return result;
        }

        public static class SourceTypes
        extends StripeObject {
            @SerializedName(value="bank_account")
            Long bankAccount;
            @SerializedName(value="card")
            Long card;
            @SerializedName(value="fpx")
            Long fpx;

            @Generated
            public Long getBankAccount() {
                return this.bankAccount;
            }

            @Generated
            public Long getCard() {
                return this.card;
            }

            @Generated
            public Long getFpx() {
                return this.fpx;
            }

            @Generated
            public void setBankAccount(Long bankAccount) {
                this.bankAccount = bankAccount;
            }

            @Generated
            public void setCard(Long card) {
                this.card = card;
            }

            @Generated
            public void setFpx(Long fpx) {
                this.fpx = fpx;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceTypes)) {
                    return false;
                }
                SourceTypes other = (SourceTypes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$bankAccount = this.getBankAccount();
                Long other$bankAccount = other.getBankAccount();
                if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                    return false;
                }
                Long this$card = this.getCard();
                Long other$card = other.getCard();
                if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                    return false;
                }
                Long this$fpx = this.getFpx();
                Long other$fpx = other.getFpx();
                return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SourceTypes;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $bankAccount = this.getBankAccount();
                result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                Long $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                Long $fpx = this.getFpx();
                result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                return result;
            }
        }

        public static class NetAvailable
        extends StripeObject {
            @SerializedName(value="amount")
            Long amount;
            @SerializedName(value="destination")
            String destination;
            @SerializedName(value="source_types")
            SourceTypes sourceTypes;

            @Generated
            public Long getAmount() {
                return this.amount;
            }

            @Generated
            public String getDestination() {
                return this.destination;
            }

            @Generated
            public SourceTypes getSourceTypes() {
                return this.sourceTypes;
            }

            @Generated
            public void setAmount(Long amount) {
                this.amount = amount;
            }

            @Generated
            public void setDestination(String destination) {
                this.destination = destination;
            }

            @Generated
            public void setSourceTypes(SourceTypes sourceTypes) {
                this.sourceTypes = sourceTypes;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof NetAvailable)) {
                    return false;
                }
                NetAvailable other = (NetAvailable)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$amount = this.getAmount();
                Long other$amount = other.getAmount();
                if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                    return false;
                }
                String this$destination = this.getDestination();
                String other$destination = other.getDestination();
                if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) {
                    return false;
                }
                SourceTypes this$sourceTypes = this.getSourceTypes();
                SourceTypes other$sourceTypes = other.getSourceTypes();
                return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof NetAvailable;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $amount = this.getAmount();
                result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
                String $destination = this.getDestination();
                result = result * 59 + ($destination == null ? 43 : $destination.hashCode());
                SourceTypes $sourceTypes = this.getSourceTypes();
                result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
                return result;
            }

            public static class SourceTypes
            extends StripeObject {
                @SerializedName(value="bank_account")
                Long bankAccount;
                @SerializedName(value="card")
                Long card;
                @SerializedName(value="fpx")
                Long fpx;

                @Generated
                public Long getBankAccount() {
                    return this.bankAccount;
                }

                @Generated
                public Long getCard() {
                    return this.card;
                }

                @Generated
                public Long getFpx() {
                    return this.fpx;
                }

                @Generated
                public void setBankAccount(Long bankAccount) {
                    this.bankAccount = bankAccount;
                }

                @Generated
                public void setCard(Long card) {
                    this.card = card;
                }

                @Generated
                public void setFpx(Long fpx) {
                    this.fpx = fpx;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof SourceTypes)) {
                        return false;
                    }
                    SourceTypes other = (SourceTypes)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$bankAccount = this.getBankAccount();
                    Long other$bankAccount = other.getBankAccount();
                    if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                        return false;
                    }
                    Long this$card = this.getCard();
                    Long other$card = other.getCard();
                    if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                        return false;
                    }
                    Long this$fpx = this.getFpx();
                    Long other$fpx = other.getFpx();
                    return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof SourceTypes;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $bankAccount = this.getBankAccount();
                    result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                    Long $card = this.getCard();
                    result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                    Long $fpx = this.getFpx();
                    result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                    return result;
                }
            }
        }
    }

    public static class ConnectReserved
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="source_types")
        SourceTypes sourceTypes;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public SourceTypes getSourceTypes() {
            return this.sourceTypes;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setSourceTypes(SourceTypes sourceTypes) {
            this.sourceTypes = sourceTypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectReserved)) {
                return false;
            }
            ConnectReserved other = (ConnectReserved)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            SourceTypes this$sourceTypes = this.getSourceTypes();
            SourceTypes other$sourceTypes = other.getSourceTypes();
            return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ConnectReserved;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            SourceTypes $sourceTypes = this.getSourceTypes();
            result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
            return result;
        }

        public static class SourceTypes
        extends StripeObject {
            @SerializedName(value="bank_account")
            Long bankAccount;
            @SerializedName(value="card")
            Long card;
            @SerializedName(value="fpx")
            Long fpx;

            @Generated
            public Long getBankAccount() {
                return this.bankAccount;
            }

            @Generated
            public Long getCard() {
                return this.card;
            }

            @Generated
            public Long getFpx() {
                return this.fpx;
            }

            @Generated
            public void setBankAccount(Long bankAccount) {
                this.bankAccount = bankAccount;
            }

            @Generated
            public void setCard(Long card) {
                this.card = card;
            }

            @Generated
            public void setFpx(Long fpx) {
                this.fpx = fpx;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceTypes)) {
                    return false;
                }
                SourceTypes other = (SourceTypes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$bankAccount = this.getBankAccount();
                Long other$bankAccount = other.getBankAccount();
                if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                    return false;
                }
                Long this$card = this.getCard();
                Long other$card = other.getCard();
                if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                    return false;
                }
                Long this$fpx = this.getFpx();
                Long other$fpx = other.getFpx();
                return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SourceTypes;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $bankAccount = this.getBankAccount();
                result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                Long $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                Long $fpx = this.getFpx();
                result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                return result;
            }
        }
    }

    public static class Available
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="currency")
        String currency;
        @SerializedName(value="source_types")
        SourceTypes sourceTypes;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getCurrency() {
            return this.currency;
        }

        @Generated
        public SourceTypes getSourceTypes() {
            return this.sourceTypes;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setCurrency(String currency) {
            this.currency = currency;
        }

        @Generated
        public void setSourceTypes(SourceTypes sourceTypes) {
            this.sourceTypes = sourceTypes;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Available)) {
                return false;
            }
            Available other = (Available)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$currency = this.getCurrency();
            String other$currency = other.getCurrency();
            if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                return false;
            }
            SourceTypes this$sourceTypes = this.getSourceTypes();
            SourceTypes other$sourceTypes = other.getSourceTypes();
            return !(this$sourceTypes == null ? other$sourceTypes != null : !((Object)this$sourceTypes).equals(other$sourceTypes));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Available;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $currency = this.getCurrency();
            result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
            SourceTypes $sourceTypes = this.getSourceTypes();
            result = result * 59 + ($sourceTypes == null ? 43 : ((Object)$sourceTypes).hashCode());
            return result;
        }

        public static class SourceTypes
        extends StripeObject {
            @SerializedName(value="bank_account")
            Long bankAccount;
            @SerializedName(value="card")
            Long card;
            @SerializedName(value="fpx")
            Long fpx;

            @Generated
            public Long getBankAccount() {
                return this.bankAccount;
            }

            @Generated
            public Long getCard() {
                return this.card;
            }

            @Generated
            public Long getFpx() {
                return this.fpx;
            }

            @Generated
            public void setBankAccount(Long bankAccount) {
                this.bankAccount = bankAccount;
            }

            @Generated
            public void setCard(Long card) {
                this.card = card;
            }

            @Generated
            public void setFpx(Long fpx) {
                this.fpx = fpx;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SourceTypes)) {
                    return false;
                }
                SourceTypes other = (SourceTypes)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$bankAccount = this.getBankAccount();
                Long other$bankAccount = other.getBankAccount();
                if (this$bankAccount == null ? other$bankAccount != null : !((Object)this$bankAccount).equals(other$bankAccount)) {
                    return false;
                }
                Long this$card = this.getCard();
                Long other$card = other.getCard();
                if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                    return false;
                }
                Long this$fpx = this.getFpx();
                Long other$fpx = other.getFpx();
                return !(this$fpx == null ? other$fpx != null : !((Object)this$fpx).equals(other$fpx));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SourceTypes;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $bankAccount = this.getBankAccount();
                result = result * 59 + ($bankAccount == null ? 43 : ((Object)$bankAccount).hashCode());
                Long $card = this.getCard();
                result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
                Long $fpx = this.getFpx();
                result = result * 59 + ($fpx == null ? 43 : ((Object)$fpx).hashCode());
                return result;
            }
        }
    }
}

