/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Discount;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.Margin;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.model.Subscription;
import com.stripe.model.billing.CreditBalanceTransaction;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.InvoiceLineItemUpdateParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;

public class InvoiceLineItem
extends ApiResource
implements HasId,
MetadataStore<InvoiceLineItem> {
    @SerializedName(value="amount")
    Long amount;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="description")
    String description;
    @SerializedName(value="discount_amounts")
    List<DiscountAmount> discountAmounts;
    @SerializedName(value="discountable")
    Boolean discountable;
    @SerializedName(value="discounts")
    List<ExpandableField<Discount>> discounts;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="invoice")
    String invoice;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="margin_amounts")
    List<MarginAmount> marginAmounts;
    @SerializedName(value="margins")
    List<ExpandableField<Margin>> margins;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="parent")
    Parent parent;
    @SerializedName(value="period")
    Period period;
    @SerializedName(value="pretax_credit_amounts")
    List<PretaxCreditAmount> pretaxCreditAmounts;
    @SerializedName(value="pricing")
    Pricing pricing;
    @SerializedName(value="quantity")
    Long quantity;
    @SerializedName(value="subscription")
    ExpandableField<Subscription> subscription;
    @SerializedName(value="tax_calculation_reference")
    TaxCalculationReference taxCalculationReference;
    @SerializedName(value="taxes")
    List<Tax> taxes;

    public String getSubscription() {
        return this.subscription != null ? this.subscription.getId() : null;
    }

    public void setSubscription(String id) {
        this.subscription = ApiResource.setExpandableFieldId(id, this.subscription);
    }

    public Subscription getSubscriptionObject() {
        return this.subscription != null ? this.subscription.getExpanded() : null;
    }

    public void setSubscriptionObject(Subscription expandableObject) {
        this.subscription = new ExpandableField<Subscription>(expandableObject.getId(), expandableObject);
    }

    public List<String> getDiscounts() {
        return this.discounts != null ? this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setDiscounts(List<String> ids) {
        if (ids == null) {
            this.discounts = null;
            return;
        }
        if (this.discounts != null && this.discounts.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.discounts = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Discount> getDiscountObjects() {
        return this.discounts != null ? this.discounts.stream().map(x -> (Discount)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setDiscountObjects(List<Discount> objs) {
        this.discounts = objs != null ? objs.stream().map(x -> new ExpandableField<Discount>(x.getId(), (Discount)x)).collect(Collectors.toList()) : null;
    }

    public List<String> getMargins() {
        return this.margins != null ? this.margins.stream().map(x -> x.getId()).collect(Collectors.toList()) : null;
    }

    public void setMargins(List<String> ids) {
        if (ids == null) {
            this.margins = null;
            return;
        }
        if (this.margins != null && this.margins.stream().map(x -> x.getId()).collect(Collectors.toList()).equals(ids)) {
            return;
        }
        this.margins = ids != null ? ids.stream().map(id -> new ExpandableField<Object>((String)id, null)).collect(Collectors.toList()) : null;
    }

    public List<Margin> getMarginObjects() {
        return this.margins != null ? this.margins.stream().map(x -> (Margin)x.getExpanded()).collect(Collectors.toList()) : null;
    }

    public void setMarginObjects(List<Margin> objs) {
        this.margins = objs != null ? objs.stream().map(x -> new ExpandableField<Margin>(x.getId(), (Margin)x)).collect(Collectors.toList()) : null;
    }

    public InvoiceLineItem update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public InvoiceLineItem update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/lines/%s", ApiResource.urlEncodeId(this.getInvoice()), ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (InvoiceLineItem)this.getResponseGetter().request(request, (Type)((Object)InvoiceLineItem.class));
    }

    public InvoiceLineItem update(InvoiceLineItemUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public InvoiceLineItem update(InvoiceLineItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/invoices/%s/lines/%s", ApiResource.urlEncodeId(this.getInvoice()), ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (InvoiceLineItem)this.getResponseGetter().request(request, (Type)((Object)InvoiceLineItem.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.parent, responseGetter);
        this.trySetResponseGetter(this.period, responseGetter);
        this.trySetResponseGetter(this.pricing, responseGetter);
        this.trySetResponseGetter(this.subscription, responseGetter);
        this.trySetResponseGetter(this.taxCalculationReference, responseGetter);
    }

    @Generated
    public Long getAmount() {
        return this.amount;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public List<DiscountAmount> getDiscountAmounts() {
        return this.discountAmounts;
    }

    @Generated
    public Boolean getDiscountable() {
        return this.discountable;
    }

    @Generated
    public String getInvoice() {
        return this.invoice;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public List<MarginAmount> getMarginAmounts() {
        return this.marginAmounts;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Parent getParent() {
        return this.parent;
    }

    @Generated
    public Period getPeriod() {
        return this.period;
    }

    @Generated
    public List<PretaxCreditAmount> getPretaxCreditAmounts() {
        return this.pretaxCreditAmounts;
    }

    @Generated
    public Pricing getPricing() {
        return this.pricing;
    }

    @Generated
    public Long getQuantity() {
        return this.quantity;
    }

    @Generated
    public TaxCalculationReference getTaxCalculationReference() {
        return this.taxCalculationReference;
    }

    @Generated
    public List<Tax> getTaxes() {
        return this.taxes;
    }

    @Generated
    public void setAmount(Long amount) {
        this.amount = amount;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setDiscountAmounts(List<DiscountAmount> discountAmounts) {
        this.discountAmounts = discountAmounts;
    }

    @Generated
    public void setDiscountable(Boolean discountable) {
        this.discountable = discountable;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMarginAmounts(List<MarginAmount> marginAmounts) {
        this.marginAmounts = marginAmounts;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setParent(Parent parent) {
        this.parent = parent;
    }

    @Generated
    public void setPeriod(Period period) {
        this.period = period;
    }

    @Generated
    public void setPretaxCreditAmounts(List<PretaxCreditAmount> pretaxCreditAmounts) {
        this.pretaxCreditAmounts = pretaxCreditAmounts;
    }

    @Generated
    public void setPricing(Pricing pricing) {
        this.pricing = pricing;
    }

    @Generated
    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    @Generated
    public void setTaxCalculationReference(TaxCalculationReference taxCalculationReference) {
        this.taxCalculationReference = taxCalculationReference;
    }

    @Generated
    public void setTaxes(List<Tax> taxes) {
        this.taxes = taxes;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InvoiceLineItem)) {
            return false;
        }
        InvoiceLineItem other = (InvoiceLineItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amount = this.getAmount();
        Long other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        Boolean this$discountable = this.getDiscountable();
        Boolean other$discountable = other.getDiscountable();
        if (this$discountable == null ? other$discountable != null : !((Object)this$discountable).equals(other$discountable)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$quantity = this.getQuantity();
        Long other$quantity = other.getQuantity();
        if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List<DiscountAmount> this$discountAmounts = this.getDiscountAmounts();
        List<DiscountAmount> other$discountAmounts = other.getDiscountAmounts();
        if (this$discountAmounts == null ? other$discountAmounts != null : !((Object)this$discountAmounts).equals(other$discountAmounts)) {
            return false;
        }
        List<String> this$discounts = this.getDiscounts();
        List<String> other$discounts = other.getDiscounts();
        if (this$discounts == null ? other$discounts != null : !((Object)this$discounts).equals(other$discounts)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$invoice = this.getInvoice();
        String other$invoice = other.getInvoice();
        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
            return false;
        }
        List<MarginAmount> this$marginAmounts = this.getMarginAmounts();
        List<MarginAmount> other$marginAmounts = other.getMarginAmounts();
        if (this$marginAmounts == null ? other$marginAmounts != null : !((Object)this$marginAmounts).equals(other$marginAmounts)) {
            return false;
        }
        List<String> this$margins = this.getMargins();
        List<String> other$margins = other.getMargins();
        if (this$margins == null ? other$margins != null : !((Object)this$margins).equals(other$margins)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Parent this$parent = this.getParent();
        Parent other$parent = other.getParent();
        if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
            return false;
        }
        Period this$period = this.getPeriod();
        Period other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        List<PretaxCreditAmount> this$pretaxCreditAmounts = this.getPretaxCreditAmounts();
        List<PretaxCreditAmount> other$pretaxCreditAmounts = other.getPretaxCreditAmounts();
        if (this$pretaxCreditAmounts == null ? other$pretaxCreditAmounts != null : !((Object)this$pretaxCreditAmounts).equals(other$pretaxCreditAmounts)) {
            return false;
        }
        Pricing this$pricing = this.getPricing();
        Pricing other$pricing = other.getPricing();
        if (this$pricing == null ? other$pricing != null : !((Object)this$pricing).equals(other$pricing)) {
            return false;
        }
        String this$subscription = this.getSubscription();
        String other$subscription = other.getSubscription();
        if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
            return false;
        }
        TaxCalculationReference this$taxCalculationReference = this.getTaxCalculationReference();
        TaxCalculationReference other$taxCalculationReference = other.getTaxCalculationReference();
        if (this$taxCalculationReference == null ? other$taxCalculationReference != null : !((Object)this$taxCalculationReference).equals(other$taxCalculationReference)) {
            return false;
        }
        List<Tax> this$taxes = this.getTaxes();
        List<Tax> other$taxes = other.getTaxes();
        return !(this$taxes == null ? other$taxes != null : !((Object)this$taxes).equals(other$taxes));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InvoiceLineItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        Boolean $discountable = this.getDiscountable();
        result = result * 59 + ($discountable == null ? 43 : ((Object)$discountable).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $quantity = this.getQuantity();
        result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List<DiscountAmount> $discountAmounts = this.getDiscountAmounts();
        result = result * 59 + ($discountAmounts == null ? 43 : ((Object)$discountAmounts).hashCode());
        List<String> $discounts = this.getDiscounts();
        result = result * 59 + ($discounts == null ? 43 : ((Object)$discounts).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $invoice = this.getInvoice();
        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
        List<MarginAmount> $marginAmounts = this.getMarginAmounts();
        result = result * 59 + ($marginAmounts == null ? 43 : ((Object)$marginAmounts).hashCode());
        List<String> $margins = this.getMargins();
        result = result * 59 + ($margins == null ? 43 : ((Object)$margins).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Parent $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        Period $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        List<PretaxCreditAmount> $pretaxCreditAmounts = this.getPretaxCreditAmounts();
        result = result * 59 + ($pretaxCreditAmounts == null ? 43 : ((Object)$pretaxCreditAmounts).hashCode());
        Pricing $pricing = this.getPricing();
        result = result * 59 + ($pricing == null ? 43 : ((Object)$pricing).hashCode());
        String $subscription = this.getSubscription();
        result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
        TaxCalculationReference $taxCalculationReference = this.getTaxCalculationReference();
        result = result * 59 + ($taxCalculationReference == null ? 43 : ((Object)$taxCalculationReference).hashCode());
        List<Tax> $taxes = this.getTaxes();
        result = result * 59 + ($taxes == null ? 43 : ((Object)$taxes).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class Parent
    extends StripeObject {
        @SerializedName(value="invoice_item_details")
        InvoiceItemDetails invoiceItemDetails;
        @SerializedName(value="license_fee_subscription_details")
        LicenseFeeSubscriptionDetails licenseFeeSubscriptionDetails;
        @SerializedName(value="rate_card_subscription_details")
        RateCardSubscriptionDetails rateCardSubscriptionDetails;
        @SerializedName(value="subscription_item_details")
        SubscriptionItemDetails subscriptionItemDetails;
        @SerializedName(value="type")
        String type;

        @Generated
        public InvoiceItemDetails getInvoiceItemDetails() {
            return this.invoiceItemDetails;
        }

        @Generated
        public LicenseFeeSubscriptionDetails getLicenseFeeSubscriptionDetails() {
            return this.licenseFeeSubscriptionDetails;
        }

        @Generated
        public RateCardSubscriptionDetails getRateCardSubscriptionDetails() {
            return this.rateCardSubscriptionDetails;
        }

        @Generated
        public SubscriptionItemDetails getSubscriptionItemDetails() {
            return this.subscriptionItemDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setInvoiceItemDetails(InvoiceItemDetails invoiceItemDetails) {
            this.invoiceItemDetails = invoiceItemDetails;
        }

        @Generated
        public void setLicenseFeeSubscriptionDetails(LicenseFeeSubscriptionDetails licenseFeeSubscriptionDetails) {
            this.licenseFeeSubscriptionDetails = licenseFeeSubscriptionDetails;
        }

        @Generated
        public void setRateCardSubscriptionDetails(RateCardSubscriptionDetails rateCardSubscriptionDetails) {
            this.rateCardSubscriptionDetails = rateCardSubscriptionDetails;
        }

        @Generated
        public void setSubscriptionItemDetails(SubscriptionItemDetails subscriptionItemDetails) {
            this.subscriptionItemDetails = subscriptionItemDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parent)) {
                return false;
            }
            Parent other = (Parent)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InvoiceItemDetails this$invoiceItemDetails = this.getInvoiceItemDetails();
            InvoiceItemDetails other$invoiceItemDetails = other.getInvoiceItemDetails();
            if (this$invoiceItemDetails == null ? other$invoiceItemDetails != null : !((Object)this$invoiceItemDetails).equals(other$invoiceItemDetails)) {
                return false;
            }
            LicenseFeeSubscriptionDetails this$licenseFeeSubscriptionDetails = this.getLicenseFeeSubscriptionDetails();
            LicenseFeeSubscriptionDetails other$licenseFeeSubscriptionDetails = other.getLicenseFeeSubscriptionDetails();
            if (this$licenseFeeSubscriptionDetails == null ? other$licenseFeeSubscriptionDetails != null : !((Object)this$licenseFeeSubscriptionDetails).equals(other$licenseFeeSubscriptionDetails)) {
                return false;
            }
            RateCardSubscriptionDetails this$rateCardSubscriptionDetails = this.getRateCardSubscriptionDetails();
            RateCardSubscriptionDetails other$rateCardSubscriptionDetails = other.getRateCardSubscriptionDetails();
            if (this$rateCardSubscriptionDetails == null ? other$rateCardSubscriptionDetails != null : !((Object)this$rateCardSubscriptionDetails).equals(other$rateCardSubscriptionDetails)) {
                return false;
            }
            SubscriptionItemDetails this$subscriptionItemDetails = this.getSubscriptionItemDetails();
            SubscriptionItemDetails other$subscriptionItemDetails = other.getSubscriptionItemDetails();
            if (this$subscriptionItemDetails == null ? other$subscriptionItemDetails != null : !((Object)this$subscriptionItemDetails).equals(other$subscriptionItemDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Parent;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InvoiceItemDetails $invoiceItemDetails = this.getInvoiceItemDetails();
            result = result * 59 + ($invoiceItemDetails == null ? 43 : ((Object)$invoiceItemDetails).hashCode());
            LicenseFeeSubscriptionDetails $licenseFeeSubscriptionDetails = this.getLicenseFeeSubscriptionDetails();
            result = result * 59 + ($licenseFeeSubscriptionDetails == null ? 43 : ((Object)$licenseFeeSubscriptionDetails).hashCode());
            RateCardSubscriptionDetails $rateCardSubscriptionDetails = this.getRateCardSubscriptionDetails();
            result = result * 59 + ($rateCardSubscriptionDetails == null ? 43 : ((Object)$rateCardSubscriptionDetails).hashCode());
            SubscriptionItemDetails $subscriptionItemDetails = this.getSubscriptionItemDetails();
            result = result * 59 + ($subscriptionItemDetails == null ? 43 : ((Object)$subscriptionItemDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class InvoiceItemDetails
        extends StripeObject {
            @SerializedName(value="invoice_item")
            String invoiceItem;
            @SerializedName(value="proration")
            Boolean proration;
            @SerializedName(value="proration_details")
            ProrationDetails prorationDetails;
            @SerializedName(value="subscription")
            String subscription;

            @Generated
            public String getInvoiceItem() {
                return this.invoiceItem;
            }

            @Generated
            public Boolean getProration() {
                return this.proration;
            }

            @Generated
            public ProrationDetails getProrationDetails() {
                return this.prorationDetails;
            }

            @Generated
            public String getSubscription() {
                return this.subscription;
            }

            @Generated
            public void setInvoiceItem(String invoiceItem) {
                this.invoiceItem = invoiceItem;
            }

            @Generated
            public void setProration(Boolean proration) {
                this.proration = proration;
            }

            @Generated
            public void setProrationDetails(ProrationDetails prorationDetails) {
                this.prorationDetails = prorationDetails;
            }

            @Generated
            public void setSubscription(String subscription) {
                this.subscription = subscription;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceItemDetails)) {
                    return false;
                }
                InvoiceItemDetails other = (InvoiceItemDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$proration = this.getProration();
                Boolean other$proration = other.getProration();
                if (this$proration == null ? other$proration != null : !((Object)this$proration).equals(other$proration)) {
                    return false;
                }
                String this$invoiceItem = this.getInvoiceItem();
                String other$invoiceItem = other.getInvoiceItem();
                if (this$invoiceItem == null ? other$invoiceItem != null : !this$invoiceItem.equals(other$invoiceItem)) {
                    return false;
                }
                ProrationDetails this$prorationDetails = this.getProrationDetails();
                ProrationDetails other$prorationDetails = other.getProrationDetails();
                if (this$prorationDetails == null ? other$prorationDetails != null : !((Object)this$prorationDetails).equals(other$prorationDetails)) {
                    return false;
                }
                String this$subscription = this.getSubscription();
                String other$subscription = other.getSubscription();
                return !(this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof InvoiceItemDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $proration = this.getProration();
                result = result * 59 + ($proration == null ? 43 : ((Object)$proration).hashCode());
                String $invoiceItem = this.getInvoiceItem();
                result = result * 59 + ($invoiceItem == null ? 43 : $invoiceItem.hashCode());
                ProrationDetails $prorationDetails = this.getProrationDetails();
                result = result * 59 + ($prorationDetails == null ? 43 : ((Object)$prorationDetails).hashCode());
                String $subscription = this.getSubscription();
                result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
                return result;
            }

            public static class ProrationDetails
            extends StripeObject {
                @SerializedName(value="credited_items")
                CreditedItems creditedItems;

                @Generated
                public CreditedItems getCreditedItems() {
                    return this.creditedItems;
                }

                @Generated
                public void setCreditedItems(CreditedItems creditedItems) {
                    this.creditedItems = creditedItems;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProrationDetails)) {
                        return false;
                    }
                    ProrationDetails other = (ProrationDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    CreditedItems this$creditedItems = this.getCreditedItems();
                    CreditedItems other$creditedItems = other.getCreditedItems();
                    return !(this$creditedItems == null ? other$creditedItems != null : !((Object)this$creditedItems).equals(other$creditedItems));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProrationDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    CreditedItems $creditedItems = this.getCreditedItems();
                    result = result * 59 + ($creditedItems == null ? 43 : ((Object)$creditedItems).hashCode());
                    return result;
                }

                public static class CreditedItems
                extends StripeObject {
                    @SerializedName(value="invoice")
                    String invoice;
                    @SerializedName(value="invoice_line_items")
                    List<String> invoiceLineItems;

                    @Generated
                    public String getInvoice() {
                        return this.invoice;
                    }

                    @Generated
                    public List<String> getInvoiceLineItems() {
                        return this.invoiceLineItems;
                    }

                    @Generated
                    public void setInvoice(String invoice) {
                        this.invoice = invoice;
                    }

                    @Generated
                    public void setInvoiceLineItems(List<String> invoiceLineItems) {
                        this.invoiceLineItems = invoiceLineItems;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof CreditedItems)) {
                            return false;
                        }
                        CreditedItems other = (CreditedItems)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$invoice = this.getInvoice();
                        String other$invoice = other.getInvoice();
                        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
                            return false;
                        }
                        List<String> this$invoiceLineItems = this.getInvoiceLineItems();
                        List<String> other$invoiceLineItems = other.getInvoiceLineItems();
                        return !(this$invoiceLineItems == null ? other$invoiceLineItems != null : !((Object)this$invoiceLineItems).equals(other$invoiceLineItems));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof CreditedItems;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $invoice = this.getInvoice();
                        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
                        List<String> $invoiceLineItems = this.getInvoiceLineItems();
                        result = result * 59 + ($invoiceLineItems == null ? 43 : ((Object)$invoiceLineItems).hashCode());
                        return result;
                    }
                }
            }
        }

        public static class LicenseFeeSubscriptionDetails
        extends StripeObject {
            @SerializedName(value="invoice_item")
            String invoiceItem;
            @SerializedName(value="license_fee_subscription")
            String licenseFeeSubscription;
            @SerializedName(value="license_fee_version")
            String licenseFeeVersion;
            @SerializedName(value="pricing_plan_subscription")
            String pricingPlanSubscription;
            @SerializedName(value="pricing_plan_version")
            String pricingPlanVersion;

            @Generated
            public String getInvoiceItem() {
                return this.invoiceItem;
            }

            @Generated
            public String getLicenseFeeSubscription() {
                return this.licenseFeeSubscription;
            }

            @Generated
            public String getLicenseFeeVersion() {
                return this.licenseFeeVersion;
            }

            @Generated
            public String getPricingPlanSubscription() {
                return this.pricingPlanSubscription;
            }

            @Generated
            public String getPricingPlanVersion() {
                return this.pricingPlanVersion;
            }

            @Generated
            public void setInvoiceItem(String invoiceItem) {
                this.invoiceItem = invoiceItem;
            }

            @Generated
            public void setLicenseFeeSubscription(String licenseFeeSubscription) {
                this.licenseFeeSubscription = licenseFeeSubscription;
            }

            @Generated
            public void setLicenseFeeVersion(String licenseFeeVersion) {
                this.licenseFeeVersion = licenseFeeVersion;
            }

            @Generated
            public void setPricingPlanSubscription(String pricingPlanSubscription) {
                this.pricingPlanSubscription = pricingPlanSubscription;
            }

            @Generated
            public void setPricingPlanVersion(String pricingPlanVersion) {
                this.pricingPlanVersion = pricingPlanVersion;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LicenseFeeSubscriptionDetails)) {
                    return false;
                }
                LicenseFeeSubscriptionDetails other = (LicenseFeeSubscriptionDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$invoiceItem = this.getInvoiceItem();
                String other$invoiceItem = other.getInvoiceItem();
                if (this$invoiceItem == null ? other$invoiceItem != null : !this$invoiceItem.equals(other$invoiceItem)) {
                    return false;
                }
                String this$licenseFeeSubscription = this.getLicenseFeeSubscription();
                String other$licenseFeeSubscription = other.getLicenseFeeSubscription();
                if (this$licenseFeeSubscription == null ? other$licenseFeeSubscription != null : !this$licenseFeeSubscription.equals(other$licenseFeeSubscription)) {
                    return false;
                }
                String this$licenseFeeVersion = this.getLicenseFeeVersion();
                String other$licenseFeeVersion = other.getLicenseFeeVersion();
                if (this$licenseFeeVersion == null ? other$licenseFeeVersion != null : !this$licenseFeeVersion.equals(other$licenseFeeVersion)) {
                    return false;
                }
                String this$pricingPlanSubscription = this.getPricingPlanSubscription();
                String other$pricingPlanSubscription = other.getPricingPlanSubscription();
                if (this$pricingPlanSubscription == null ? other$pricingPlanSubscription != null : !this$pricingPlanSubscription.equals(other$pricingPlanSubscription)) {
                    return false;
                }
                String this$pricingPlanVersion = this.getPricingPlanVersion();
                String other$pricingPlanVersion = other.getPricingPlanVersion();
                return !(this$pricingPlanVersion == null ? other$pricingPlanVersion != null : !this$pricingPlanVersion.equals(other$pricingPlanVersion));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LicenseFeeSubscriptionDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $invoiceItem = this.getInvoiceItem();
                result = result * 59 + ($invoiceItem == null ? 43 : $invoiceItem.hashCode());
                String $licenseFeeSubscription = this.getLicenseFeeSubscription();
                result = result * 59 + ($licenseFeeSubscription == null ? 43 : $licenseFeeSubscription.hashCode());
                String $licenseFeeVersion = this.getLicenseFeeVersion();
                result = result * 59 + ($licenseFeeVersion == null ? 43 : $licenseFeeVersion.hashCode());
                String $pricingPlanSubscription = this.getPricingPlanSubscription();
                result = result * 59 + ($pricingPlanSubscription == null ? 43 : $pricingPlanSubscription.hashCode());
                String $pricingPlanVersion = this.getPricingPlanVersion();
                result = result * 59 + ($pricingPlanVersion == null ? 43 : $pricingPlanVersion.hashCode());
                return result;
            }
        }

        public static class RateCardSubscriptionDetails
        extends StripeObject {
            @SerializedName(value="invoice_item")
            String invoiceItem;
            @SerializedName(value="pricing_plan_subscription")
            String pricingPlanSubscription;
            @SerializedName(value="pricing_plan_version")
            String pricingPlanVersion;
            @SerializedName(value="rate_card_subscription")
            String rateCardSubscription;
            @SerializedName(value="rate_card_version")
            String rateCardVersion;

            @Generated
            public String getInvoiceItem() {
                return this.invoiceItem;
            }

            @Generated
            public String getPricingPlanSubscription() {
                return this.pricingPlanSubscription;
            }

            @Generated
            public String getPricingPlanVersion() {
                return this.pricingPlanVersion;
            }

            @Generated
            public String getRateCardSubscription() {
                return this.rateCardSubscription;
            }

            @Generated
            public String getRateCardVersion() {
                return this.rateCardVersion;
            }

            @Generated
            public void setInvoiceItem(String invoiceItem) {
                this.invoiceItem = invoiceItem;
            }

            @Generated
            public void setPricingPlanSubscription(String pricingPlanSubscription) {
                this.pricingPlanSubscription = pricingPlanSubscription;
            }

            @Generated
            public void setPricingPlanVersion(String pricingPlanVersion) {
                this.pricingPlanVersion = pricingPlanVersion;
            }

            @Generated
            public void setRateCardSubscription(String rateCardSubscription) {
                this.rateCardSubscription = rateCardSubscription;
            }

            @Generated
            public void setRateCardVersion(String rateCardVersion) {
                this.rateCardVersion = rateCardVersion;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RateCardSubscriptionDetails)) {
                    return false;
                }
                RateCardSubscriptionDetails other = (RateCardSubscriptionDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$invoiceItem = this.getInvoiceItem();
                String other$invoiceItem = other.getInvoiceItem();
                if (this$invoiceItem == null ? other$invoiceItem != null : !this$invoiceItem.equals(other$invoiceItem)) {
                    return false;
                }
                String this$pricingPlanSubscription = this.getPricingPlanSubscription();
                String other$pricingPlanSubscription = other.getPricingPlanSubscription();
                if (this$pricingPlanSubscription == null ? other$pricingPlanSubscription != null : !this$pricingPlanSubscription.equals(other$pricingPlanSubscription)) {
                    return false;
                }
                String this$pricingPlanVersion = this.getPricingPlanVersion();
                String other$pricingPlanVersion = other.getPricingPlanVersion();
                if (this$pricingPlanVersion == null ? other$pricingPlanVersion != null : !this$pricingPlanVersion.equals(other$pricingPlanVersion)) {
                    return false;
                }
                String this$rateCardSubscription = this.getRateCardSubscription();
                String other$rateCardSubscription = other.getRateCardSubscription();
                if (this$rateCardSubscription == null ? other$rateCardSubscription != null : !this$rateCardSubscription.equals(other$rateCardSubscription)) {
                    return false;
                }
                String this$rateCardVersion = this.getRateCardVersion();
                String other$rateCardVersion = other.getRateCardVersion();
                return !(this$rateCardVersion == null ? other$rateCardVersion != null : !this$rateCardVersion.equals(other$rateCardVersion));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RateCardSubscriptionDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $invoiceItem = this.getInvoiceItem();
                result = result * 59 + ($invoiceItem == null ? 43 : $invoiceItem.hashCode());
                String $pricingPlanSubscription = this.getPricingPlanSubscription();
                result = result * 59 + ($pricingPlanSubscription == null ? 43 : $pricingPlanSubscription.hashCode());
                String $pricingPlanVersion = this.getPricingPlanVersion();
                result = result * 59 + ($pricingPlanVersion == null ? 43 : $pricingPlanVersion.hashCode());
                String $rateCardSubscription = this.getRateCardSubscription();
                result = result * 59 + ($rateCardSubscription == null ? 43 : $rateCardSubscription.hashCode());
                String $rateCardVersion = this.getRateCardVersion();
                result = result * 59 + ($rateCardVersion == null ? 43 : $rateCardVersion.hashCode());
                return result;
            }
        }

        public static class SubscriptionItemDetails
        extends StripeObject {
            @SerializedName(value="invoice_item")
            String invoiceItem;
            @SerializedName(value="proration")
            Boolean proration;
            @SerializedName(value="proration_details")
            ProrationDetails prorationDetails;
            @SerializedName(value="subscription")
            String subscription;
            @SerializedName(value="subscription_item")
            String subscriptionItem;

            @Generated
            public String getInvoiceItem() {
                return this.invoiceItem;
            }

            @Generated
            public Boolean getProration() {
                return this.proration;
            }

            @Generated
            public ProrationDetails getProrationDetails() {
                return this.prorationDetails;
            }

            @Generated
            public String getSubscription() {
                return this.subscription;
            }

            @Generated
            public String getSubscriptionItem() {
                return this.subscriptionItem;
            }

            @Generated
            public void setInvoiceItem(String invoiceItem) {
                this.invoiceItem = invoiceItem;
            }

            @Generated
            public void setProration(Boolean proration) {
                this.proration = proration;
            }

            @Generated
            public void setProrationDetails(ProrationDetails prorationDetails) {
                this.prorationDetails = prorationDetails;
            }

            @Generated
            public void setSubscription(String subscription) {
                this.subscription = subscription;
            }

            @Generated
            public void setSubscriptionItem(String subscriptionItem) {
                this.subscriptionItem = subscriptionItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SubscriptionItemDetails)) {
                    return false;
                }
                SubscriptionItemDetails other = (SubscriptionItemDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Boolean this$proration = this.getProration();
                Boolean other$proration = other.getProration();
                if (this$proration == null ? other$proration != null : !((Object)this$proration).equals(other$proration)) {
                    return false;
                }
                String this$invoiceItem = this.getInvoiceItem();
                String other$invoiceItem = other.getInvoiceItem();
                if (this$invoiceItem == null ? other$invoiceItem != null : !this$invoiceItem.equals(other$invoiceItem)) {
                    return false;
                }
                ProrationDetails this$prorationDetails = this.getProrationDetails();
                ProrationDetails other$prorationDetails = other.getProrationDetails();
                if (this$prorationDetails == null ? other$prorationDetails != null : !((Object)this$prorationDetails).equals(other$prorationDetails)) {
                    return false;
                }
                String this$subscription = this.getSubscription();
                String other$subscription = other.getSubscription();
                if (this$subscription == null ? other$subscription != null : !this$subscription.equals(other$subscription)) {
                    return false;
                }
                String this$subscriptionItem = this.getSubscriptionItem();
                String other$subscriptionItem = other.getSubscriptionItem();
                return !(this$subscriptionItem == null ? other$subscriptionItem != null : !this$subscriptionItem.equals(other$subscriptionItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SubscriptionItemDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Boolean $proration = this.getProration();
                result = result * 59 + ($proration == null ? 43 : ((Object)$proration).hashCode());
                String $invoiceItem = this.getInvoiceItem();
                result = result * 59 + ($invoiceItem == null ? 43 : $invoiceItem.hashCode());
                ProrationDetails $prorationDetails = this.getProrationDetails();
                result = result * 59 + ($prorationDetails == null ? 43 : ((Object)$prorationDetails).hashCode());
                String $subscription = this.getSubscription();
                result = result * 59 + ($subscription == null ? 43 : $subscription.hashCode());
                String $subscriptionItem = this.getSubscriptionItem();
                result = result * 59 + ($subscriptionItem == null ? 43 : $subscriptionItem.hashCode());
                return result;
            }

            public static class ProrationDetails
            extends StripeObject {
                @SerializedName(value="credited_items")
                CreditedItems creditedItems;

                @Generated
                public CreditedItems getCreditedItems() {
                    return this.creditedItems;
                }

                @Generated
                public void setCreditedItems(CreditedItems creditedItems) {
                    this.creditedItems = creditedItems;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof ProrationDetails)) {
                        return false;
                    }
                    ProrationDetails other = (ProrationDetails)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    CreditedItems this$creditedItems = this.getCreditedItems();
                    CreditedItems other$creditedItems = other.getCreditedItems();
                    return !(this$creditedItems == null ? other$creditedItems != null : !((Object)this$creditedItems).equals(other$creditedItems));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof ProrationDetails;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    CreditedItems $creditedItems = this.getCreditedItems();
                    result = result * 59 + ($creditedItems == null ? 43 : ((Object)$creditedItems).hashCode());
                    return result;
                }

                public static class CreditedItems
                extends StripeObject {
                    @SerializedName(value="invoice")
                    String invoice;
                    @SerializedName(value="invoice_line_items")
                    List<String> invoiceLineItems;

                    @Generated
                    public String getInvoice() {
                        return this.invoice;
                    }

                    @Generated
                    public List<String> getInvoiceLineItems() {
                        return this.invoiceLineItems;
                    }

                    @Generated
                    public void setInvoice(String invoice) {
                        this.invoice = invoice;
                    }

                    @Generated
                    public void setInvoiceLineItems(List<String> invoiceLineItems) {
                        this.invoiceLineItems = invoiceLineItems;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof CreditedItems)) {
                            return false;
                        }
                        CreditedItems other = (CreditedItems)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        String this$invoice = this.getInvoice();
                        String other$invoice = other.getInvoice();
                        if (this$invoice == null ? other$invoice != null : !this$invoice.equals(other$invoice)) {
                            return false;
                        }
                        List<String> this$invoiceLineItems = this.getInvoiceLineItems();
                        List<String> other$invoiceLineItems = other.getInvoiceLineItems();
                        return !(this$invoiceLineItems == null ? other$invoiceLineItems != null : !((Object)this$invoiceLineItems).equals(other$invoiceLineItems));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof CreditedItems;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        String $invoice = this.getInvoice();
                        result = result * 59 + ($invoice == null ? 43 : $invoice.hashCode());
                        List<String> $invoiceLineItems = this.getInvoiceLineItems();
                        result = result * 59 + ($invoiceLineItems == null ? 43 : ((Object)$invoiceLineItems).hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class Period
    extends StripeObject {
        @SerializedName(value="end")
        Long end;
        @SerializedName(value="start")
        Long start;

        @Generated
        public Long getEnd() {
            return this.end;
        }

        @Generated
        public Long getStart() {
            return this.start;
        }

        @Generated
        public void setEnd(Long end) {
            this.end = end;
        }

        @Generated
        public void setStart(Long start) {
            this.start = start;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Period)) {
                return false;
            }
            Period other = (Period)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$end = this.getEnd();
            Long other$end = other.getEnd();
            if (this$end == null ? other$end != null : !((Object)this$end).equals(other$end)) {
                return false;
            }
            Long this$start = this.getStart();
            Long other$start = other.getStart();
            return !(this$start == null ? other$start != null : !((Object)this$start).equals(other$start));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Period;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $end = this.getEnd();
            result = result * 59 + ($end == null ? 43 : ((Object)$end).hashCode());
            Long $start = this.getStart();
            result = result * 59 + ($start == null ? 43 : ((Object)$start).hashCode());
            return result;
        }
    }

    public static class Pricing
    extends StripeObject {
        @SerializedName(value="license_fee_details")
        LicenseFeeDetails licenseFeeDetails;
        @SerializedName(value="price_details")
        PriceDetails priceDetails;
        @SerializedName(value="rate_card_rate_details")
        RateCardRateDetails rateCardRateDetails;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="unit_amount_decimal")
        BigDecimal unitAmountDecimal;

        @Generated
        public LicenseFeeDetails getLicenseFeeDetails() {
            return this.licenseFeeDetails;
        }

        @Generated
        public PriceDetails getPriceDetails() {
            return this.priceDetails;
        }

        @Generated
        public RateCardRateDetails getRateCardRateDetails() {
            return this.rateCardRateDetails;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public BigDecimal getUnitAmountDecimal() {
            return this.unitAmountDecimal;
        }

        @Generated
        public void setLicenseFeeDetails(LicenseFeeDetails licenseFeeDetails) {
            this.licenseFeeDetails = licenseFeeDetails;
        }

        @Generated
        public void setPriceDetails(PriceDetails priceDetails) {
            this.priceDetails = priceDetails;
        }

        @Generated
        public void setRateCardRateDetails(RateCardRateDetails rateCardRateDetails) {
            this.rateCardRateDetails = rateCardRateDetails;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUnitAmountDecimal(BigDecimal unitAmountDecimal) {
            this.unitAmountDecimal = unitAmountDecimal;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pricing)) {
                return false;
            }
            Pricing other = (Pricing)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LicenseFeeDetails this$licenseFeeDetails = this.getLicenseFeeDetails();
            LicenseFeeDetails other$licenseFeeDetails = other.getLicenseFeeDetails();
            if (this$licenseFeeDetails == null ? other$licenseFeeDetails != null : !((Object)this$licenseFeeDetails).equals(other$licenseFeeDetails)) {
                return false;
            }
            PriceDetails this$priceDetails = this.getPriceDetails();
            PriceDetails other$priceDetails = other.getPriceDetails();
            if (this$priceDetails == null ? other$priceDetails != null : !((Object)this$priceDetails).equals(other$priceDetails)) {
                return false;
            }
            RateCardRateDetails this$rateCardRateDetails = this.getRateCardRateDetails();
            RateCardRateDetails other$rateCardRateDetails = other.getRateCardRateDetails();
            if (this$rateCardRateDetails == null ? other$rateCardRateDetails != null : !((Object)this$rateCardRateDetails).equals(other$rateCardRateDetails)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            BigDecimal this$unitAmountDecimal = this.getUnitAmountDecimal();
            BigDecimal other$unitAmountDecimal = other.getUnitAmountDecimal();
            return !(this$unitAmountDecimal == null ? other$unitAmountDecimal != null : !((Object)this$unitAmountDecimal).equals(other$unitAmountDecimal));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pricing;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LicenseFeeDetails $licenseFeeDetails = this.getLicenseFeeDetails();
            result = result * 59 + ($licenseFeeDetails == null ? 43 : ((Object)$licenseFeeDetails).hashCode());
            PriceDetails $priceDetails = this.getPriceDetails();
            result = result * 59 + ($priceDetails == null ? 43 : ((Object)$priceDetails).hashCode());
            RateCardRateDetails $rateCardRateDetails = this.getRateCardRateDetails();
            result = result * 59 + ($rateCardRateDetails == null ? 43 : ((Object)$rateCardRateDetails).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            BigDecimal $unitAmountDecimal = this.getUnitAmountDecimal();
            result = result * 59 + ($unitAmountDecimal == null ? 43 : ((Object)$unitAmountDecimal).hashCode());
            return result;
        }

        public static class LicenseFeeDetails
        extends StripeObject {
            @SerializedName(value="license_fee")
            String licenseFee;
            @SerializedName(value="license_fee_version")
            String licenseFeeVersion;
            @SerializedName(value="licensed_item")
            String licensedItem;

            @Generated
            public String getLicenseFee() {
                return this.licenseFee;
            }

            @Generated
            public String getLicenseFeeVersion() {
                return this.licenseFeeVersion;
            }

            @Generated
            public String getLicensedItem() {
                return this.licensedItem;
            }

            @Generated
            public void setLicenseFee(String licenseFee) {
                this.licenseFee = licenseFee;
            }

            @Generated
            public void setLicenseFeeVersion(String licenseFeeVersion) {
                this.licenseFeeVersion = licenseFeeVersion;
            }

            @Generated
            public void setLicensedItem(String licensedItem) {
                this.licensedItem = licensedItem;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof LicenseFeeDetails)) {
                    return false;
                }
                LicenseFeeDetails other = (LicenseFeeDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$licenseFee = this.getLicenseFee();
                String other$licenseFee = other.getLicenseFee();
                if (this$licenseFee == null ? other$licenseFee != null : !this$licenseFee.equals(other$licenseFee)) {
                    return false;
                }
                String this$licenseFeeVersion = this.getLicenseFeeVersion();
                String other$licenseFeeVersion = other.getLicenseFeeVersion();
                if (this$licenseFeeVersion == null ? other$licenseFeeVersion != null : !this$licenseFeeVersion.equals(other$licenseFeeVersion)) {
                    return false;
                }
                String this$licensedItem = this.getLicensedItem();
                String other$licensedItem = other.getLicensedItem();
                return !(this$licensedItem == null ? other$licensedItem != null : !this$licensedItem.equals(other$licensedItem));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof LicenseFeeDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $licenseFee = this.getLicenseFee();
                result = result * 59 + ($licenseFee == null ? 43 : $licenseFee.hashCode());
                String $licenseFeeVersion = this.getLicenseFeeVersion();
                result = result * 59 + ($licenseFeeVersion == null ? 43 : $licenseFeeVersion.hashCode());
                String $licensedItem = this.getLicensedItem();
                result = result * 59 + ($licensedItem == null ? 43 : $licensedItem.hashCode());
                return result;
            }
        }

        public static class PriceDetails
        extends StripeObject {
            @SerializedName(value="price")
            String price;
            @SerializedName(value="product")
            String product;

            @Generated
            public String getPrice() {
                return this.price;
            }

            @Generated
            public String getProduct() {
                return this.product;
            }

            @Generated
            public void setPrice(String price) {
                this.price = price;
            }

            @Generated
            public void setProduct(String product) {
                this.product = product;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PriceDetails)) {
                    return false;
                }
                PriceDetails other = (PriceDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$price = this.getPrice();
                String other$price = other.getPrice();
                if (this$price == null ? other$price != null : !this$price.equals(other$price)) {
                    return false;
                }
                String this$product = this.getProduct();
                String other$product = other.getProduct();
                return !(this$product == null ? other$product != null : !this$product.equals(other$product));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof PriceDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $price = this.getPrice();
                result = result * 59 + ($price == null ? 43 : $price.hashCode());
                String $product = this.getProduct();
                result = result * 59 + ($product == null ? 43 : $product.hashCode());
                return result;
            }
        }

        public static class RateCardRateDetails
        extends StripeObject {
            @SerializedName(value="metered_item")
            String meteredItem;
            @SerializedName(value="rate_card")
            String rateCard;
            @SerializedName(value="rate_card_rate")
            String rateCardRate;

            @Generated
            public String getMeteredItem() {
                return this.meteredItem;
            }

            @Generated
            public String getRateCard() {
                return this.rateCard;
            }

            @Generated
            public String getRateCardRate() {
                return this.rateCardRate;
            }

            @Generated
            public void setMeteredItem(String meteredItem) {
                this.meteredItem = meteredItem;
            }

            @Generated
            public void setRateCard(String rateCard) {
                this.rateCard = rateCard;
            }

            @Generated
            public void setRateCardRate(String rateCardRate) {
                this.rateCardRate = rateCardRate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RateCardRateDetails)) {
                    return false;
                }
                RateCardRateDetails other = (RateCardRateDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$meteredItem = this.getMeteredItem();
                String other$meteredItem = other.getMeteredItem();
                if (this$meteredItem == null ? other$meteredItem != null : !this$meteredItem.equals(other$meteredItem)) {
                    return false;
                }
                String this$rateCard = this.getRateCard();
                String other$rateCard = other.getRateCard();
                if (this$rateCard == null ? other$rateCard != null : !this$rateCard.equals(other$rateCard)) {
                    return false;
                }
                String this$rateCardRate = this.getRateCardRate();
                String other$rateCardRate = other.getRateCardRate();
                return !(this$rateCardRate == null ? other$rateCardRate != null : !this$rateCardRate.equals(other$rateCardRate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof RateCardRateDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $meteredItem = this.getMeteredItem();
                result = result * 59 + ($meteredItem == null ? 43 : $meteredItem.hashCode());
                String $rateCard = this.getRateCard();
                result = result * 59 + ($rateCard == null ? 43 : $rateCard.hashCode());
                String $rateCardRate = this.getRateCardRate();
                result = result * 59 + ($rateCardRate == null ? 43 : $rateCardRate.hashCode());
                return result;
            }
        }
    }

    public static class TaxCalculationReference
    extends StripeObject {
        @SerializedName(value="calculation_id")
        String calculationId;
        @SerializedName(value="calculation_item_id")
        String calculationItemId;

        @Generated
        public String getCalculationId() {
            return this.calculationId;
        }

        @Generated
        public String getCalculationItemId() {
            return this.calculationItemId;
        }

        @Generated
        public void setCalculationId(String calculationId) {
            this.calculationId = calculationId;
        }

        @Generated
        public void setCalculationItemId(String calculationItemId) {
            this.calculationItemId = calculationItemId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TaxCalculationReference)) {
                return false;
            }
            TaxCalculationReference other = (TaxCalculationReference)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$calculationId = this.getCalculationId();
            String other$calculationId = other.getCalculationId();
            if (this$calculationId == null ? other$calculationId != null : !this$calculationId.equals(other$calculationId)) {
                return false;
            }
            String this$calculationItemId = this.getCalculationItemId();
            String other$calculationItemId = other.getCalculationItemId();
            return !(this$calculationItemId == null ? other$calculationItemId != null : !this$calculationItemId.equals(other$calculationItemId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TaxCalculationReference;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $calculationId = this.getCalculationId();
            result = result * 59 + ($calculationId == null ? 43 : $calculationId.hashCode());
            String $calculationItemId = this.getCalculationItemId();
            result = result * 59 + ($calculationItemId == null ? 43 : $calculationItemId.hashCode());
            return result;
        }
    }

    public static class Tax
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="tax_behavior")
        String taxBehavior;
        @SerializedName(value="tax_rate_details")
        TaxRateDetails taxRateDetails;
        @SerializedName(value="taxability_reason")
        String taxabilityReason;
        @SerializedName(value="taxable_amount")
        Long taxableAmount;
        @SerializedName(value="type")
        String type;

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getTaxBehavior() {
            return this.taxBehavior;
        }

        @Generated
        public TaxRateDetails getTaxRateDetails() {
            return this.taxRateDetails;
        }

        @Generated
        public String getTaxabilityReason() {
            return this.taxabilityReason;
        }

        @Generated
        public Long getTaxableAmount() {
            return this.taxableAmount;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setTaxBehavior(String taxBehavior) {
            this.taxBehavior = taxBehavior;
        }

        @Generated
        public void setTaxRateDetails(TaxRateDetails taxRateDetails) {
            this.taxRateDetails = taxRateDetails;
        }

        @Generated
        public void setTaxabilityReason(String taxabilityReason) {
            this.taxabilityReason = taxabilityReason;
        }

        @Generated
        public void setTaxableAmount(Long taxableAmount) {
            this.taxableAmount = taxableAmount;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tax)) {
                return false;
            }
            Tax other = (Tax)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            Long this$taxableAmount = this.getTaxableAmount();
            Long other$taxableAmount = other.getTaxableAmount();
            if (this$taxableAmount == null ? other$taxableAmount != null : !((Object)this$taxableAmount).equals(other$taxableAmount)) {
                return false;
            }
            String this$taxBehavior = this.getTaxBehavior();
            String other$taxBehavior = other.getTaxBehavior();
            if (this$taxBehavior == null ? other$taxBehavior != null : !this$taxBehavior.equals(other$taxBehavior)) {
                return false;
            }
            TaxRateDetails this$taxRateDetails = this.getTaxRateDetails();
            TaxRateDetails other$taxRateDetails = other.getTaxRateDetails();
            if (this$taxRateDetails == null ? other$taxRateDetails != null : !((Object)this$taxRateDetails).equals(other$taxRateDetails)) {
                return false;
            }
            String this$taxabilityReason = this.getTaxabilityReason();
            String other$taxabilityReason = other.getTaxabilityReason();
            if (this$taxabilityReason == null ? other$taxabilityReason != null : !this$taxabilityReason.equals(other$taxabilityReason)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tax;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            Long $taxableAmount = this.getTaxableAmount();
            result = result * 59 + ($taxableAmount == null ? 43 : ((Object)$taxableAmount).hashCode());
            String $taxBehavior = this.getTaxBehavior();
            result = result * 59 + ($taxBehavior == null ? 43 : $taxBehavior.hashCode());
            TaxRateDetails $taxRateDetails = this.getTaxRateDetails();
            result = result * 59 + ($taxRateDetails == null ? 43 : ((Object)$taxRateDetails).hashCode());
            String $taxabilityReason = this.getTaxabilityReason();
            result = result * 59 + ($taxabilityReason == null ? 43 : $taxabilityReason.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class TaxRateDetails
        extends StripeObject {
            @SerializedName(value="tax_rate")
            String taxRate;

            @Generated
            public String getTaxRate() {
                return this.taxRate;
            }

            @Generated
            public void setTaxRate(String taxRate) {
                this.taxRate = taxRate;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TaxRateDetails)) {
                    return false;
                }
                TaxRateDetails other = (TaxRateDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$taxRate = this.getTaxRate();
                String other$taxRate = other.getTaxRate();
                return !(this$taxRate == null ? other$taxRate != null : !this$taxRate.equals(other$taxRate));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TaxRateDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $taxRate = this.getTaxRate();
                result = result * 59 + ($taxRate == null ? 43 : $taxRate.hashCode());
                return result;
            }
        }
    }

    public static class PretaxCreditAmount
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="credit_balance_transaction")
        ExpandableField<CreditBalanceTransaction> creditBalanceTransaction;
        @SerializedName(value="discount")
        ExpandableField<Discount> discount;
        @SerializedName(value="margin")
        ExpandableField<Margin> margin;
        @SerializedName(value="type")
        String type;

        public String getCreditBalanceTransaction() {
            return this.creditBalanceTransaction != null ? this.creditBalanceTransaction.getId() : null;
        }

        public void setCreditBalanceTransaction(String id) {
            this.creditBalanceTransaction = ApiResource.setExpandableFieldId(id, this.creditBalanceTransaction);
        }

        public CreditBalanceTransaction getCreditBalanceTransactionObject() {
            return this.creditBalanceTransaction != null ? this.creditBalanceTransaction.getExpanded() : null;
        }

        public void setCreditBalanceTransactionObject(CreditBalanceTransaction expandableObject) {
            this.creditBalanceTransaction = new ExpandableField<CreditBalanceTransaction>(expandableObject.getId(), expandableObject);
        }

        public String getDiscount() {
            return this.discount != null ? this.discount.getId() : null;
        }

        public void setDiscount(String id) {
            this.discount = ApiResource.setExpandableFieldId(id, this.discount);
        }

        public Discount getDiscountObject() {
            return this.discount != null ? this.discount.getExpanded() : null;
        }

        public void setDiscountObject(Discount expandableObject) {
            this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
        }

        public String getMargin() {
            return this.margin != null ? this.margin.getId() : null;
        }

        public void setMargin(String id) {
            this.margin = ApiResource.setExpandableFieldId(id, this.margin);
        }

        public Margin getMarginObject() {
            return this.margin != null ? this.margin.getExpanded() : null;
        }

        public void setMarginObject(Margin expandableObject) {
            this.margin = new ExpandableField<Margin>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PretaxCreditAmount)) {
                return false;
            }
            PretaxCreditAmount other = (PretaxCreditAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$creditBalanceTransaction = this.getCreditBalanceTransaction();
            String other$creditBalanceTransaction = other.getCreditBalanceTransaction();
            if (this$creditBalanceTransaction == null ? other$creditBalanceTransaction != null : !this$creditBalanceTransaction.equals(other$creditBalanceTransaction)) {
                return false;
            }
            String this$discount = this.getDiscount();
            String other$discount = other.getDiscount();
            if (this$discount == null ? other$discount != null : !this$discount.equals(other$discount)) {
                return false;
            }
            String this$margin = this.getMargin();
            String other$margin = other.getMargin();
            if (this$margin == null ? other$margin != null : !this$margin.equals(other$margin)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PretaxCreditAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $creditBalanceTransaction = this.getCreditBalanceTransaction();
            result = result * 59 + ($creditBalanceTransaction == null ? 43 : $creditBalanceTransaction.hashCode());
            String $discount = this.getDiscount();
            result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
            String $margin = this.getMargin();
            result = result * 59 + ($margin == null ? 43 : $margin.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class MarginAmount
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="margin")
        ExpandableField<Margin> margin;

        public String getMargin() {
            return this.margin != null ? this.margin.getId() : null;
        }

        public void setMargin(String id) {
            this.margin = ApiResource.setExpandableFieldId(id, this.margin);
        }

        public Margin getMarginObject() {
            return this.margin != null ? this.margin.getExpanded() : null;
        }

        public void setMarginObject(Margin expandableObject) {
            this.margin = new ExpandableField<Margin>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MarginAmount)) {
                return false;
            }
            MarginAmount other = (MarginAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$margin = this.getMargin();
            String other$margin = other.getMargin();
            return !(this$margin == null ? other$margin != null : !this$margin.equals(other$margin));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MarginAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $margin = this.getMargin();
            result = result * 59 + ($margin == null ? 43 : $margin.hashCode());
            return result;
        }
    }

    public static class DiscountAmount
    extends StripeObject {
        @SerializedName(value="amount")
        Long amount;
        @SerializedName(value="discount")
        ExpandableField<Discount> discount;

        public String getDiscount() {
            return this.discount != null ? this.discount.getId() : null;
        }

        public void setDiscount(String id) {
            this.discount = ApiResource.setExpandableFieldId(id, this.discount);
        }

        public Discount getDiscountObject() {
            return this.discount != null ? this.discount.getExpanded() : null;
        }

        public void setDiscountObject(Discount expandableObject) {
            this.discount = new ExpandableField<Discount>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public Long getAmount() {
            return this.amount;
        }

        @Generated
        public void setAmount(Long amount) {
            this.amount = amount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DiscountAmount)) {
                return false;
            }
            DiscountAmount other = (DiscountAmount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amount = this.getAmount();
            Long other$amount = other.getAmount();
            if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
                return false;
            }
            String this$discount = this.getDiscount();
            String other$discount = other.getDiscount();
            return !(this$discount == null ? other$discount != null : !this$discount.equals(other$discount));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DiscountAmount;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
            String $discount = this.getDiscount();
            result = result * 59 + ($discount == null ? 43 : $discount.hashCode());
            return result;
        }
    }
}

