/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.Customer;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.StripeObject;
import com.stripe.model.billing.AlertCollection;
import com.stripe.model.billing.Meter;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.billing.AlertActivateParams;
import com.stripe.param.billing.AlertArchiveParams;
import com.stripe.param.billing.AlertCreateParams;
import com.stripe.param.billing.AlertDeactivateParams;
import com.stripe.param.billing.AlertListParams;
import com.stripe.param.billing.AlertRetrieveParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class Alert
extends ApiResource
implements HasId {
    @SerializedName(value="alert_type")
    String alertType;
    @SerializedName(value="credit_balance_threshold")
    CreditBalanceThreshold creditBalanceThreshold;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="title")
    String title;
    @SerializedName(value="usage_threshold")
    UsageThreshold usageThreshold;

    public Alert activate() throws StripeException {
        return this.activate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Alert activate(RequestOptions options) throws StripeException {
        return this.activate((Map<String, Object>)null, options);
    }

    public Alert activate(Map<String, Object> params) throws StripeException {
        return this.activate(params, (RequestOptions)null);
    }

    public Alert activate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/activate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert activate(AlertActivateParams params) throws StripeException {
        return this.activate(params, (RequestOptions)null);
    }

    public Alert activate(AlertActivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/activate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert archive() throws StripeException {
        return this.archive((Map<String, Object>)null, (RequestOptions)null);
    }

    public Alert archive(RequestOptions options) throws StripeException {
        return this.archive((Map<String, Object>)null, options);
    }

    public Alert archive(Map<String, Object> params) throws StripeException {
        return this.archive(params, (RequestOptions)null);
    }

    public Alert archive(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/archive", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert archive(AlertArchiveParams params) throws StripeException {
        return this.archive(params, (RequestOptions)null);
    }

    public Alert archive(AlertArchiveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/archive", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static Alert create(Map<String, Object> params) throws StripeException {
        return Alert.create(params, (RequestOptions)null);
    }

    public static Alert create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static Alert create(AlertCreateParams params) throws StripeException {
        return Alert.create(params, (RequestOptions)null);
    }

    public static Alert create(AlertCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert deactivate() throws StripeException {
        return this.deactivate((Map<String, Object>)null, (RequestOptions)null);
    }

    public Alert deactivate(RequestOptions options) throws StripeException {
        return this.deactivate((Map<String, Object>)null, options);
    }

    public Alert deactivate(Map<String, Object> params) throws StripeException {
        return this.deactivate(params, (RequestOptions)null);
    }

    public Alert deactivate(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/deactivate", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public Alert deactivate(AlertDeactivateParams params) throws StripeException {
        return this.deactivate(params, (RequestOptions)null);
    }

    public Alert deactivate(AlertDeactivateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s/deactivate", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Alert)this.getResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static AlertCollection list(Map<String, Object> params) throws StripeException {
        return Alert.list(params, (RequestOptions)null);
    }

    public static AlertCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (AlertCollection)Alert.getGlobalResponseGetter().request(request, (Type)((Object)AlertCollection.class));
    }

    public static AlertCollection list(AlertListParams params) throws StripeException {
        return Alert.list(params, (RequestOptions)null);
    }

    public static AlertCollection list(AlertListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/billing/alerts";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (AlertCollection)Alert.getGlobalResponseGetter().request(request, (Type)((Object)AlertCollection.class));
    }

    public static Alert retrieve(String id) throws StripeException {
        return Alert.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static Alert retrieve(String id, RequestOptions options) throws StripeException {
        return Alert.retrieve(id, (Map<String, Object>)null, options);
    }

    public static Alert retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    public static Alert retrieve(String id, AlertRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/alerts/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (Alert)Alert.getGlobalResponseGetter().request(request, (Type)((Object)Alert.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.creditBalanceThreshold, responseGetter);
        this.trySetResponseGetter(this.usageThreshold, responseGetter);
    }

    @Generated
    public String getAlertType() {
        return this.alertType;
    }

    @Generated
    public CreditBalanceThreshold getCreditBalanceThreshold() {
        return this.creditBalanceThreshold;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public UsageThreshold getUsageThreshold() {
        return this.usageThreshold;
    }

    @Generated
    public void setAlertType(String alertType) {
        this.alertType = alertType;
    }

    @Generated
    public void setCreditBalanceThreshold(CreditBalanceThreshold creditBalanceThreshold) {
        this.creditBalanceThreshold = creditBalanceThreshold;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setUsageThreshold(UsageThreshold usageThreshold) {
        this.usageThreshold = usageThreshold;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Alert)) {
            return false;
        }
        Alert other = (Alert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$alertType = this.getAlertType();
        String other$alertType = other.getAlertType();
        if (this$alertType == null ? other$alertType != null : !this$alertType.equals(other$alertType)) {
            return false;
        }
        CreditBalanceThreshold this$creditBalanceThreshold = this.getCreditBalanceThreshold();
        CreditBalanceThreshold other$creditBalanceThreshold = other.getCreditBalanceThreshold();
        if (this$creditBalanceThreshold == null ? other$creditBalanceThreshold != null : !((Object)this$creditBalanceThreshold).equals(other$creditBalanceThreshold)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        UsageThreshold this$usageThreshold = this.getUsageThreshold();
        UsageThreshold other$usageThreshold = other.getUsageThreshold();
        return !(this$usageThreshold == null ? other$usageThreshold != null : !((Object)this$usageThreshold).equals(other$usageThreshold));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Alert;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $alertType = this.getAlertType();
        result = result * 59 + ($alertType == null ? 43 : $alertType.hashCode());
        CreditBalanceThreshold $creditBalanceThreshold = this.getCreditBalanceThreshold();
        result = result * 59 + ($creditBalanceThreshold == null ? 43 : ((Object)$creditBalanceThreshold).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        UsageThreshold $usageThreshold = this.getUsageThreshold();
        result = result * 59 + ($usageThreshold == null ? 43 : ((Object)$usageThreshold).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class CreditBalanceThreshold
    extends StripeObject {
        @SerializedName(value="filters")
        List<Filter> filters;
        @SerializedName(value="lte")
        Lte lte;

        @Generated
        public List<Filter> getFilters() {
            return this.filters;
        }

        @Generated
        public Lte getLte() {
            return this.lte;
        }

        @Generated
        public void setFilters(List<Filter> filters) {
            this.filters = filters;
        }

        @Generated
        public void setLte(Lte lte) {
            this.lte = lte;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreditBalanceThreshold)) {
                return false;
            }
            CreditBalanceThreshold other = (CreditBalanceThreshold)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Filter> this$filters = this.getFilters();
            List<Filter> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            Lte this$lte = this.getLte();
            Lte other$lte = other.getLte();
            return !(this$lte == null ? other$lte != null : !((Object)this$lte).equals(other$lte));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreditBalanceThreshold;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Filter> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            Lte $lte = this.getLte();
            result = result * 59 + ($lte == null ? 43 : ((Object)$lte).hashCode());
            return result;
        }

        public static class Lte
        extends StripeObject {
            @SerializedName(value="balance_type")
            String balanceType;
            @SerializedName(value="custom_pricing_unit")
            CustomPricingUnit customPricingUnit;
            @SerializedName(value="monetary")
            Monetary monetary;

            @Generated
            public String getBalanceType() {
                return this.balanceType;
            }

            @Generated
            public CustomPricingUnit getCustomPricingUnit() {
                return this.customPricingUnit;
            }

            @Generated
            public Monetary getMonetary() {
                return this.monetary;
            }

            @Generated
            public void setBalanceType(String balanceType) {
                this.balanceType = balanceType;
            }

            @Generated
            public void setCustomPricingUnit(CustomPricingUnit customPricingUnit) {
                this.customPricingUnit = customPricingUnit;
            }

            @Generated
            public void setMonetary(Monetary monetary) {
                this.monetary = monetary;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lte)) {
                    return false;
                }
                Lte other = (Lte)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$balanceType = this.getBalanceType();
                String other$balanceType = other.getBalanceType();
                if (this$balanceType == null ? other$balanceType != null : !this$balanceType.equals(other$balanceType)) {
                    return false;
                }
                CustomPricingUnit this$customPricingUnit = this.getCustomPricingUnit();
                CustomPricingUnit other$customPricingUnit = other.getCustomPricingUnit();
                if (this$customPricingUnit == null ? other$customPricingUnit != null : !((Object)this$customPricingUnit).equals(other$customPricingUnit)) {
                    return false;
                }
                Monetary this$monetary = this.getMonetary();
                Monetary other$monetary = other.getMonetary();
                return !(this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lte;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $balanceType = this.getBalanceType();
                result = result * 59 + ($balanceType == null ? 43 : $balanceType.hashCode());
                CustomPricingUnit $customPricingUnit = this.getCustomPricingUnit();
                result = result * 59 + ($customPricingUnit == null ? 43 : ((Object)$customPricingUnit).hashCode());
                Monetary $monetary = this.getMonetary();
                result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
                return result;
            }

            public static class CustomPricingUnit
            extends StripeObject
            implements HasId {
                @SerializedName(value="custom_pricing_unit_details")
                CustomPricingUnitDetails customPricingUnitDetails;
                @SerializedName(value="id")
                String id;
                @SerializedName(value="value")
                BigDecimal value;

                @Generated
                public CustomPricingUnitDetails getCustomPricingUnitDetails() {
                    return this.customPricingUnitDetails;
                }

                @Generated
                public BigDecimal getValue() {
                    return this.value;
                }

                @Generated
                public void setCustomPricingUnitDetails(CustomPricingUnitDetails customPricingUnitDetails) {
                    this.customPricingUnitDetails = customPricingUnitDetails;
                }

                @Generated
                public void setId(String id) {
                    this.id = id;
                }

                @Generated
                public void setValue(BigDecimal value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomPricingUnit)) {
                        return false;
                    }
                    CustomPricingUnit other = (CustomPricingUnit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    CustomPricingUnitDetails this$customPricingUnitDetails = this.getCustomPricingUnitDetails();
                    CustomPricingUnitDetails other$customPricingUnitDetails = other.getCustomPricingUnitDetails();
                    if (this$customPricingUnitDetails == null ? other$customPricingUnitDetails != null : !((Object)this$customPricingUnitDetails).equals(other$customPricingUnitDetails)) {
                        return false;
                    }
                    String this$id = this.getId();
                    String other$id = other.getId();
                    if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                        return false;
                    }
                    BigDecimal this$value = this.getValue();
                    BigDecimal other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomPricingUnit;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    CustomPricingUnitDetails $customPricingUnitDetails = this.getCustomPricingUnitDetails();
                    result = result * 59 + ($customPricingUnitDetails == null ? 43 : ((Object)$customPricingUnitDetails).hashCode());
                    String $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : $id.hashCode());
                    BigDecimal $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    return result;
                }

                @Override
                @Generated
                public String getId() {
                    return this.id;
                }

                public static class CustomPricingUnitDetails
                extends StripeObject
                implements HasId {
                    @SerializedName(value="created")
                    Long created;
                    @SerializedName(value="display_name")
                    String displayName;
                    @SerializedName(value="id")
                    String id;
                    @SerializedName(value="lookup_key")
                    String lookupKey;
                    @SerializedName(value="metadata")
                    Map<String, String> metadata;
                    @SerializedName(value="status")
                    String status;

                    @Generated
                    public Long getCreated() {
                        return this.created;
                    }

                    @Generated
                    public String getDisplayName() {
                        return this.displayName;
                    }

                    @Generated
                    public String getLookupKey() {
                        return this.lookupKey;
                    }

                    @Generated
                    public Map<String, String> getMetadata() {
                        return this.metadata;
                    }

                    @Generated
                    public String getStatus() {
                        return this.status;
                    }

                    @Generated
                    public void setCreated(Long created) {
                        this.created = created;
                    }

                    @Generated
                    public void setDisplayName(String displayName) {
                        this.displayName = displayName;
                    }

                    @Generated
                    public void setId(String id) {
                        this.id = id;
                    }

                    @Generated
                    public void setLookupKey(String lookupKey) {
                        this.lookupKey = lookupKey;
                    }

                    @Generated
                    public void setMetadata(Map<String, String> metadata) {
                        this.metadata = metadata;
                    }

                    @Generated
                    public void setStatus(String status) {
                        this.status = status;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof CustomPricingUnitDetails)) {
                            return false;
                        }
                        CustomPricingUnitDetails other = (CustomPricingUnitDetails)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$created = this.getCreated();
                        Long other$created = other.getCreated();
                        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
                            return false;
                        }
                        String this$displayName = this.getDisplayName();
                        String other$displayName = other.getDisplayName();
                        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                            return false;
                        }
                        String this$id = this.getId();
                        String other$id = other.getId();
                        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                            return false;
                        }
                        String this$lookupKey = this.getLookupKey();
                        String other$lookupKey = other.getLookupKey();
                        if (this$lookupKey == null ? other$lookupKey != null : !this$lookupKey.equals(other$lookupKey)) {
                            return false;
                        }
                        Map<String, String> this$metadata = this.getMetadata();
                        Map<String, String> other$metadata = other.getMetadata();
                        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                            return false;
                        }
                        String this$status = this.getStatus();
                        String other$status = other.getStatus();
                        return !(this$status == null ? other$status != null : !this$status.equals(other$status));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof CustomPricingUnitDetails;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $created = this.getCreated();
                        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
                        String $displayName = this.getDisplayName();
                        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                        String $id = this.getId();
                        result = result * 59 + ($id == null ? 43 : $id.hashCode());
                        String $lookupKey = this.getLookupKey();
                        result = result * 59 + ($lookupKey == null ? 43 : $lookupKey.hashCode());
                        Map<String, String> $metadata = this.getMetadata();
                        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
                        String $status = this.getStatus();
                        result = result * 59 + ($status == null ? 43 : $status.hashCode());
                        return result;
                    }

                    @Override
                    @Generated
                    public String getId() {
                        return this.id;
                    }
                }
            }

            public static class Monetary
            extends StripeObject {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="value")
                Long value;

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Long getValue() {
                    return this.value;
                }

                @Generated
                public void setCurrency(String currency) {
                    this.currency = currency;
                }

                @Generated
                public void setValue(Long value) {
                    this.value = value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Monetary)) {
                        return false;
                    }
                    Monetary other = (Monetary)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$value = this.getValue();
                    Long other$value = other.getValue();
                    if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    return !(this$currency == null ? other$currency != null : !this$currency.equals(other$currency));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Monetary;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    return result;
                }
            }
        }

        public static class Filter
        extends StripeObject {
            @SerializedName(value="customer")
            ExpandableField<Customer> customer;
            @SerializedName(value="type")
            String type;

            public String getCustomer() {
                return this.customer != null ? this.customer.getId() : null;
            }

            public void setCustomer(String id) {
                this.customer = ApiResource.setExpandableFieldId(id, this.customer);
            }

            public Customer getCustomerObject() {
                return this.customer != null ? this.customer.getExpanded() : null;
            }

            public void setCustomerObject(Customer expandableObject) {
                this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Filter)) {
                    return false;
                }
                Filter other = (Filter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$customer = this.getCustomer();
                String other$customer = other.getCustomer();
                if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Filter;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $customer = this.getCustomer();
                result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }

    public static class UsageThreshold
    extends StripeObject {
        @SerializedName(value="filters")
        List<Filter> filters;
        @SerializedName(value="gte")
        Long gte;
        @SerializedName(value="meter")
        ExpandableField<Meter> meter;
        @SerializedName(value="recurrence")
        String recurrence;

        public String getMeter() {
            return this.meter != null ? this.meter.getId() : null;
        }

        public void setMeter(String id) {
            this.meter = ApiResource.setExpandableFieldId(id, this.meter);
        }

        public Meter getMeterObject() {
            return this.meter != null ? this.meter.getExpanded() : null;
        }

        public void setMeterObject(Meter expandableObject) {
            this.meter = new ExpandableField<Meter>(expandableObject.getId(), expandableObject);
        }

        @Generated
        public List<Filter> getFilters() {
            return this.filters;
        }

        @Generated
        public Long getGte() {
            return this.gte;
        }

        @Generated
        public String getRecurrence() {
            return this.recurrence;
        }

        @Generated
        public void setFilters(List<Filter> filters) {
            this.filters = filters;
        }

        @Generated
        public void setGte(Long gte) {
            this.gte = gte;
        }

        @Generated
        public void setRecurrence(String recurrence) {
            this.recurrence = recurrence;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsageThreshold)) {
                return false;
            }
            UsageThreshold other = (UsageThreshold)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$gte = this.getGte();
            Long other$gte = other.getGte();
            if (this$gte == null ? other$gte != null : !((Object)this$gte).equals(other$gte)) {
                return false;
            }
            List<Filter> this$filters = this.getFilters();
            List<Filter> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            String this$meter = this.getMeter();
            String other$meter = other.getMeter();
            if (this$meter == null ? other$meter != null : !this$meter.equals(other$meter)) {
                return false;
            }
            String this$recurrence = this.getRecurrence();
            String other$recurrence = other.getRecurrence();
            return !(this$recurrence == null ? other$recurrence != null : !this$recurrence.equals(other$recurrence));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsageThreshold;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $gte = this.getGte();
            result = result * 59 + ($gte == null ? 43 : ((Object)$gte).hashCode());
            List<Filter> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            String $meter = this.getMeter();
            result = result * 59 + ($meter == null ? 43 : $meter.hashCode());
            String $recurrence = this.getRecurrence();
            result = result * 59 + ($recurrence == null ? 43 : $recurrence.hashCode());
            return result;
        }

        public static class Filter
        extends StripeObject {
            @SerializedName(value="customer")
            ExpandableField<Customer> customer;
            @SerializedName(value="type")
            String type;

            public String getCustomer() {
                return this.customer != null ? this.customer.getId() : null;
            }

            public void setCustomer(String id) {
                this.customer = ApiResource.setExpandableFieldId(id, this.customer);
            }

            public Customer getCustomerObject() {
                return this.customer != null ? this.customer.getExpanded() : null;
            }

            public void setCustomerObject(Customer expandableObject) {
                this.customer = new ExpandableField<Customer>(expandableObject.getId(), expandableObject);
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Filter)) {
                    return false;
                }
                Filter other = (Filter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$customer = this.getCustomer();
                String other$customer = other.getCustomer();
                if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Filter;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $customer = this.getCustomer();
                result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }
        }
    }
}

