/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.billing.MeterEventSummaryCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.param.billing.MeterEventSummaryListParams;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Map;
import lombok.Generated;

public class MeterEventSummary
extends ApiResource
implements HasId {
    @SerializedName(value="aggregated_value")
    BigDecimal aggregatedValue;
    @SerializedName(value="dimensions")
    Map<String, String> dimensions;
    @SerializedName(value="end_time")
    Long endTime;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="meter")
    String meter;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="start_time")
    Long startTime;

    public static MeterEventSummaryCollection list(String id, Map<String, Object> params) throws StripeException {
        return MeterEventSummary.list(id, params, (RequestOptions)null);
    }

    public static MeterEventSummaryCollection list(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/event_summaries", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (MeterEventSummaryCollection)MeterEventSummary.getGlobalResponseGetter().request(request, (Type)((Object)MeterEventSummaryCollection.class));
    }

    public static MeterEventSummaryCollection list(String id, MeterEventSummaryListParams params) throws StripeException {
        return MeterEventSummary.list(id, params, (RequestOptions)null);
    }

    public static MeterEventSummaryCollection list(String id, MeterEventSummaryListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/billing/meters/%s/event_summaries", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (MeterEventSummaryCollection)MeterEventSummary.getGlobalResponseGetter().request(request, (Type)((Object)MeterEventSummaryCollection.class));
    }

    @Generated
    public BigDecimal getAggregatedValue() {
        return this.aggregatedValue;
    }

    @Generated
    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    @Generated
    public Long getEndTime() {
        return this.endTime;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getMeter() {
        return this.meter;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Long getStartTime() {
        return this.startTime;
    }

    @Generated
    public void setAggregatedValue(BigDecimal aggregatedValue) {
        this.aggregatedValue = aggregatedValue;
    }

    @Generated
    public void setDimensions(Map<String, String> dimensions) {
        this.dimensions = dimensions;
    }

    @Generated
    public void setEndTime(Long endTime) {
        this.endTime = endTime;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMeter(String meter) {
        this.meter = meter;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeterEventSummary)) {
            return false;
        }
        MeterEventSummary other = (MeterEventSummary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$endTime = this.getEndTime();
        Long other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$startTime = this.getStartTime();
        Long other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        BigDecimal this$aggregatedValue = this.getAggregatedValue();
        BigDecimal other$aggregatedValue = other.getAggregatedValue();
        if (this$aggregatedValue == null ? other$aggregatedValue != null : !((Object)this$aggregatedValue).equals(other$aggregatedValue)) {
            return false;
        }
        Map<String, String> this$dimensions = this.getDimensions();
        Map<String, String> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !((Object)this$dimensions).equals(other$dimensions)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$meter = this.getMeter();
        String other$meter = other.getMeter();
        if (this$meter == null ? other$meter != null : !this$meter.equals(other$meter)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        return !(this$object == null ? other$object != null : !this$object.equals(other$object));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MeterEventSummary;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        BigDecimal $aggregatedValue = this.getAggregatedValue();
        result = result * 59 + ($aggregatedValue == null ? 43 : ((Object)$aggregatedValue).hashCode());
        Map<String, String> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : ((Object)$dimensions).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $meter = this.getMeter();
        result = result * 59 + ($meter == null ? 43 : $meter.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

