/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.delegatedcheckout;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.MetadataStore;
import com.stripe.model.StripeObject;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.delegatedcheckout.RequestedSessionConfirmParams;
import com.stripe.param.delegatedcheckout.RequestedSessionCreateParams;
import com.stripe.param.delegatedcheckout.RequestedSessionExpireParams;
import com.stripe.param.delegatedcheckout.RequestedSessionRetrieveParams;
import com.stripe.param.delegatedcheckout.RequestedSessionUpdateParams;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class RequestedSession
extends ApiResource
implements HasId,
MetadataStore<RequestedSession> {
    @SerializedName(value="amount_subtotal")
    Long amountSubtotal;
    @SerializedName(value="amount_total")
    Long amountTotal;
    @SerializedName(value="created_at")
    Long createdAt;
    @SerializedName(value="currency")
    String currency;
    @SerializedName(value="customer")
    String customer;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="fulfillment_details")
    FulfillmentDetails fulfillmentDetails;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="line_item_details")
    List<LineItemDetail> lineItemDetails;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="metadata")
    Map<String, String> metadata;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="order_details")
    OrderDetails orderDetails;
    @SerializedName(value="payment_method")
    String paymentMethod;
    @SerializedName(value="payment_method_preview")
    PaymentMethodPreview paymentMethodPreview;
    @SerializedName(value="seller_details")
    SellerDetails sellerDetails;
    @SerializedName(value="setup_future_usage")
    String setupFutureUsage;
    @SerializedName(value="shared_metadata")
    Map<String, String> sharedMetadata;
    @SerializedName(value="shared_payment_issued_token")
    String sharedPaymentIssuedToken;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="total_details")
    TotalDetails totalDetails;
    @SerializedName(value="updated_at")
    Long updatedAt;

    public RequestedSession confirm() throws StripeException {
        return this.confirm((Map<String, Object>)null, (RequestOptions)null);
    }

    public RequestedSession confirm(RequestOptions options) throws StripeException {
        return this.confirm((Map<String, Object>)null, options);
    }

    public RequestedSession confirm(Map<String, Object> params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public RequestedSession confirm(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s/confirm", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RequestedSession)this.getResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession confirm(RequestedSessionConfirmParams params) throws StripeException {
        return this.confirm(params, (RequestOptions)null);
    }

    public RequestedSession confirm(RequestedSessionConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s/confirm", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.getResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public static RequestedSession create(Map<String, Object> params) throws StripeException {
        return RequestedSession.create(params, (RequestOptions)null);
    }

    public static RequestedSession create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/delegated_checkout/requested_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RequestedSession)RequestedSession.getGlobalResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public static RequestedSession create(RequestedSessionCreateParams params) throws StripeException {
        return RequestedSession.create(params, (RequestOptions)null);
    }

    public static RequestedSession create(RequestedSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/delegated_checkout/requested_sessions";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)RequestedSession.getGlobalResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession expire() throws StripeException {
        return this.expire((Map<String, Object>)null, (RequestOptions)null);
    }

    public RequestedSession expire(RequestOptions options) throws StripeException {
        return this.expire((Map<String, Object>)null, options);
    }

    public RequestedSession expire(Map<String, Object> params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public RequestedSession expire(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s/expire", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RequestedSession)this.getResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession expire(RequestedSessionExpireParams params) throws StripeException {
        return this.expire(params, (RequestOptions)null);
    }

    public RequestedSession expire(RequestedSessionExpireParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s/expire", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.getResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public static RequestedSession retrieve(String requestedSession) throws StripeException {
        return RequestedSession.retrieve(requestedSession, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static RequestedSession retrieve(String requestedSession, RequestOptions options) throws StripeException {
        return RequestedSession.retrieve(requestedSession, (Map<String, Object>)null, options);
    }

    public static RequestedSession retrieve(String requestedSession, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s", ApiResource.urlEncodeId(requestedSession));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (RequestedSession)RequestedSession.getGlobalResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public static RequestedSession retrieve(String requestedSession, RequestedSessionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s", ApiResource.urlEncodeId(requestedSession));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)RequestedSession.getGlobalResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession update(Map<String, Object> params) throws StripeException {
        return this.update((Map)params, (RequestOptions)null);
    }

    public RequestedSession update(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (RequestedSession)this.getResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession update(RequestedSessionUpdateParams params) throws StripeException {
        return this.update(params, (RequestOptions)null);
    }

    public RequestedSession update(RequestedSessionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.getResponseGetter().request(request, (Type)((Object)RequestedSession.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.fulfillmentDetails, responseGetter);
        this.trySetResponseGetter(this.orderDetails, responseGetter);
        this.trySetResponseGetter(this.paymentMethodPreview, responseGetter);
        this.trySetResponseGetter(this.sellerDetails, responseGetter);
        this.trySetResponseGetter(this.totalDetails, responseGetter);
    }

    @Generated
    public Long getAmountSubtotal() {
        return this.amountSubtotal;
    }

    @Generated
    public Long getAmountTotal() {
        return this.amountTotal;
    }

    @Generated
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Generated
    public String getCurrency() {
        return this.currency;
    }

    @Generated
    public String getCustomer() {
        return this.customer;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public FulfillmentDetails getFulfillmentDetails() {
        return this.fulfillmentDetails;
    }

    @Generated
    public List<LineItemDetail> getLineItemDetails() {
        return this.lineItemDetails;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public OrderDetails getOrderDetails() {
        return this.orderDetails;
    }

    @Generated
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    @Generated
    public PaymentMethodPreview getPaymentMethodPreview() {
        return this.paymentMethodPreview;
    }

    @Generated
    public SellerDetails getSellerDetails() {
        return this.sellerDetails;
    }

    @Generated
    public String getSetupFutureUsage() {
        return this.setupFutureUsage;
    }

    @Generated
    public Map<String, String> getSharedMetadata() {
        return this.sharedMetadata;
    }

    @Generated
    public String getSharedPaymentIssuedToken() {
        return this.sharedPaymentIssuedToken;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public TotalDetails getTotalDetails() {
        return this.totalDetails;
    }

    @Generated
    public Long getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public void setAmountSubtotal(Long amountSubtotal) {
        this.amountSubtotal = amountSubtotal;
    }

    @Generated
    public void setAmountTotal(Long amountTotal) {
        this.amountTotal = amountTotal;
    }

    @Generated
    public void setCreatedAt(Long createdAt) {
        this.createdAt = createdAt;
    }

    @Generated
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Generated
    public void setCustomer(String customer) {
        this.customer = customer;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setFulfillmentDetails(FulfillmentDetails fulfillmentDetails) {
        this.fulfillmentDetails = fulfillmentDetails;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLineItemDetails(List<LineItemDetail> lineItemDetails) {
        this.lineItemDetails = lineItemDetails;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setOrderDetails(OrderDetails orderDetails) {
        this.orderDetails = orderDetails;
    }

    @Generated
    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @Generated
    public void setPaymentMethodPreview(PaymentMethodPreview paymentMethodPreview) {
        this.paymentMethodPreview = paymentMethodPreview;
    }

    @Generated
    public void setSellerDetails(SellerDetails sellerDetails) {
        this.sellerDetails = sellerDetails;
    }

    @Generated
    public void setSetupFutureUsage(String setupFutureUsage) {
        this.setupFutureUsage = setupFutureUsage;
    }

    @Generated
    public void setSharedMetadata(Map<String, String> sharedMetadata) {
        this.sharedMetadata = sharedMetadata;
    }

    @Generated
    public void setSharedPaymentIssuedToken(String sharedPaymentIssuedToken) {
        this.sharedPaymentIssuedToken = sharedPaymentIssuedToken;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setTotalDetails(TotalDetails totalDetails) {
        this.totalDetails = totalDetails;
    }

    @Generated
    public void setUpdatedAt(Long updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestedSession)) {
            return false;
        }
        RequestedSession other = (RequestedSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$amountSubtotal = this.getAmountSubtotal();
        Long other$amountSubtotal = other.getAmountSubtotal();
        if (this$amountSubtotal == null ? other$amountSubtotal != null : !((Object)this$amountSubtotal).equals(other$amountSubtotal)) {
            return false;
        }
        Long this$amountTotal = this.getAmountTotal();
        Long other$amountTotal = other.getAmountTotal();
        if (this$amountTotal == null ? other$amountTotal != null : !((Object)this$amountTotal).equals(other$amountTotal)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Long this$updatedAt = this.getUpdatedAt();
        Long other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        String this$currency = this.getCurrency();
        String other$currency = other.getCurrency();
        if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
            return false;
        }
        String this$customer = this.getCustomer();
        String other$customer = other.getCustomer();
        if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
            return false;
        }
        FulfillmentDetails this$fulfillmentDetails = this.getFulfillmentDetails();
        FulfillmentDetails other$fulfillmentDetails = other.getFulfillmentDetails();
        if (this$fulfillmentDetails == null ? other$fulfillmentDetails != null : !((Object)this$fulfillmentDetails).equals(other$fulfillmentDetails)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        List<LineItemDetail> this$lineItemDetails = this.getLineItemDetails();
        List<LineItemDetail> other$lineItemDetails = other.getLineItemDetails();
        if (this$lineItemDetails == null ? other$lineItemDetails != null : !((Object)this$lineItemDetails).equals(other$lineItemDetails)) {
            return false;
        }
        Map<String, String> this$metadata = this.getMetadata();
        Map<String, String> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        OrderDetails this$orderDetails = this.getOrderDetails();
        OrderDetails other$orderDetails = other.getOrderDetails();
        if (this$orderDetails == null ? other$orderDetails != null : !((Object)this$orderDetails).equals(other$orderDetails)) {
            return false;
        }
        String this$paymentMethod = this.getPaymentMethod();
        String other$paymentMethod = other.getPaymentMethod();
        if (this$paymentMethod == null ? other$paymentMethod != null : !this$paymentMethod.equals(other$paymentMethod)) {
            return false;
        }
        PaymentMethodPreview this$paymentMethodPreview = this.getPaymentMethodPreview();
        PaymentMethodPreview other$paymentMethodPreview = other.getPaymentMethodPreview();
        if (this$paymentMethodPreview == null ? other$paymentMethodPreview != null : !((Object)this$paymentMethodPreview).equals(other$paymentMethodPreview)) {
            return false;
        }
        SellerDetails this$sellerDetails = this.getSellerDetails();
        SellerDetails other$sellerDetails = other.getSellerDetails();
        if (this$sellerDetails == null ? other$sellerDetails != null : !((Object)this$sellerDetails).equals(other$sellerDetails)) {
            return false;
        }
        String this$setupFutureUsage = this.getSetupFutureUsage();
        String other$setupFutureUsage = other.getSetupFutureUsage();
        if (this$setupFutureUsage == null ? other$setupFutureUsage != null : !this$setupFutureUsage.equals(other$setupFutureUsage)) {
            return false;
        }
        Map<String, String> this$sharedMetadata = this.getSharedMetadata();
        Map<String, String> other$sharedMetadata = other.getSharedMetadata();
        if (this$sharedMetadata == null ? other$sharedMetadata != null : !((Object)this$sharedMetadata).equals(other$sharedMetadata)) {
            return false;
        }
        String this$sharedPaymentIssuedToken = this.getSharedPaymentIssuedToken();
        String other$sharedPaymentIssuedToken = other.getSharedPaymentIssuedToken();
        if (this$sharedPaymentIssuedToken == null ? other$sharedPaymentIssuedToken != null : !this$sharedPaymentIssuedToken.equals(other$sharedPaymentIssuedToken)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        TotalDetails this$totalDetails = this.getTotalDetails();
        TotalDetails other$totalDetails = other.getTotalDetails();
        return !(this$totalDetails == null ? other$totalDetails != null : !((Object)this$totalDetails).equals(other$totalDetails));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RequestedSession;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $amountSubtotal = this.getAmountSubtotal();
        result = result * 59 + ($amountSubtotal == null ? 43 : ((Object)$amountSubtotal).hashCode());
        Long $amountTotal = this.getAmountTotal();
        result = result * 59 + ($amountTotal == null ? 43 : ((Object)$amountTotal).hashCode());
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Long $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        String $currency = this.getCurrency();
        result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
        String $customer = this.getCustomer();
        result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
        FulfillmentDetails $fulfillmentDetails = this.getFulfillmentDetails();
        result = result * 59 + ($fulfillmentDetails == null ? 43 : ((Object)$fulfillmentDetails).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        List<LineItemDetail> $lineItemDetails = this.getLineItemDetails();
        result = result * 59 + ($lineItemDetails == null ? 43 : ((Object)$lineItemDetails).hashCode());
        Map<String, String> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        OrderDetails $orderDetails = this.getOrderDetails();
        result = result * 59 + ($orderDetails == null ? 43 : ((Object)$orderDetails).hashCode());
        String $paymentMethod = this.getPaymentMethod();
        result = result * 59 + ($paymentMethod == null ? 43 : $paymentMethod.hashCode());
        PaymentMethodPreview $paymentMethodPreview = this.getPaymentMethodPreview();
        result = result * 59 + ($paymentMethodPreview == null ? 43 : ((Object)$paymentMethodPreview).hashCode());
        SellerDetails $sellerDetails = this.getSellerDetails();
        result = result * 59 + ($sellerDetails == null ? 43 : ((Object)$sellerDetails).hashCode());
        String $setupFutureUsage = this.getSetupFutureUsage();
        result = result * 59 + ($setupFutureUsage == null ? 43 : $setupFutureUsage.hashCode());
        Map<String, String> $sharedMetadata = this.getSharedMetadata();
        result = result * 59 + ($sharedMetadata == null ? 43 : ((Object)$sharedMetadata).hashCode());
        String $sharedPaymentIssuedToken = this.getSharedPaymentIssuedToken();
        result = result * 59 + ($sharedPaymentIssuedToken == null ? 43 : $sharedPaymentIssuedToken.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        TotalDetails $totalDetails = this.getTotalDetails();
        result = result * 59 + ($totalDetails == null ? 43 : ((Object)$totalDetails).hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    @Override
    @Generated
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public static class FulfillmentDetails
    extends StripeObject {
        @SerializedName(value="address")
        Address address;
        @SerializedName(value="email")
        String email;
        @SerializedName(value="fulfillment_options")
        List<FulfillmentOption> fulfillmentOptions;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="phone")
        String phone;
        @SerializedName(value="selected_fulfillment_option")
        SelectedFulfillmentOption selectedFulfillmentOption;

        @Generated
        public Address getAddress() {
            return this.address;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public List<FulfillmentOption> getFulfillmentOptions() {
            return this.fulfillmentOptions;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getPhone() {
            return this.phone;
        }

        @Generated
        public SelectedFulfillmentOption getSelectedFulfillmentOption() {
            return this.selectedFulfillmentOption;
        }

        @Generated
        public void setAddress(Address address) {
            this.address = address;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public void setFulfillmentOptions(List<FulfillmentOption> fulfillmentOptions) {
            this.fulfillmentOptions = fulfillmentOptions;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setPhone(String phone) {
            this.phone = phone;
        }

        @Generated
        public void setSelectedFulfillmentOption(SelectedFulfillmentOption selectedFulfillmentOption) {
            this.selectedFulfillmentOption = selectedFulfillmentOption;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FulfillmentDetails)) {
                return false;
            }
            FulfillmentDetails other = (FulfillmentDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Address this$address = this.getAddress();
            Address other$address = other.getAddress();
            if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                return false;
            }
            List<FulfillmentOption> this$fulfillmentOptions = this.getFulfillmentOptions();
            List<FulfillmentOption> other$fulfillmentOptions = other.getFulfillmentOptions();
            if (this$fulfillmentOptions == null ? other$fulfillmentOptions != null : !((Object)this$fulfillmentOptions).equals(other$fulfillmentOptions)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$phone = this.getPhone();
            String other$phone = other.getPhone();
            if (this$phone == null ? other$phone != null : !this$phone.equals(other$phone)) {
                return false;
            }
            SelectedFulfillmentOption this$selectedFulfillmentOption = this.getSelectedFulfillmentOption();
            SelectedFulfillmentOption other$selectedFulfillmentOption = other.getSelectedFulfillmentOption();
            return !(this$selectedFulfillmentOption == null ? other$selectedFulfillmentOption != null : !((Object)this$selectedFulfillmentOption).equals(other$selectedFulfillmentOption));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FulfillmentDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Address $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            List<FulfillmentOption> $fulfillmentOptions = this.getFulfillmentOptions();
            result = result * 59 + ($fulfillmentOptions == null ? 43 : ((Object)$fulfillmentOptions).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $phone = this.getPhone();
            result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
            SelectedFulfillmentOption $selectedFulfillmentOption = this.getSelectedFulfillmentOption();
            result = result * 59 + ($selectedFulfillmentOption == null ? 43 : ((Object)$selectedFulfillmentOption).hashCode());
            return result;
        }

        public static class Address
        extends StripeObject {
            @SerializedName(value="city")
            String city;
            @SerializedName(value="country")
            String country;
            @SerializedName(value="line1")
            String line1;
            @SerializedName(value="line2")
            String line2;
            @SerializedName(value="postal_code")
            String postalCode;
            @SerializedName(value="state")
            String state;

            @Generated
            public String getCity() {
                return this.city;
            }

            @Generated
            public String getCountry() {
                return this.country;
            }

            @Generated
            public String getLine1() {
                return this.line1;
            }

            @Generated
            public String getLine2() {
                return this.line2;
            }

            @Generated
            public String getPostalCode() {
                return this.postalCode;
            }

            @Generated
            public String getState() {
                return this.state;
            }

            @Generated
            public void setCity(String city) {
                this.city = city;
            }

            @Generated
            public void setCountry(String country) {
                this.country = country;
            }

            @Generated
            public void setLine1(String line1) {
                this.line1 = line1;
            }

            @Generated
            public void setLine2(String line2) {
                this.line2 = line2;
            }

            @Generated
            public void setPostalCode(String postalCode) {
                this.postalCode = postalCode;
            }

            @Generated
            public void setState(String state) {
                this.state = state;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Address)) {
                    return false;
                }
                Address other = (Address)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$city = this.getCity();
                String other$city = other.getCity();
                if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                    return false;
                }
                String this$country = this.getCountry();
                String other$country = other.getCountry();
                if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                    return false;
                }
                String this$line1 = this.getLine1();
                String other$line1 = other.getLine1();
                if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                    return false;
                }
                String this$line2 = this.getLine2();
                String other$line2 = other.getLine2();
                if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                    return false;
                }
                String this$postalCode = this.getPostalCode();
                String other$postalCode = other.getPostalCode();
                if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                    return false;
                }
                String this$state = this.getState();
                String other$state = other.getState();
                return !(this$state == null ? other$state != null : !this$state.equals(other$state));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Address;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $city = this.getCity();
                result = result * 59 + ($city == null ? 43 : $city.hashCode());
                String $country = this.getCountry();
                result = result * 59 + ($country == null ? 43 : $country.hashCode());
                String $line1 = this.getLine1();
                result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                String $line2 = this.getLine2();
                result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                String $postalCode = this.getPostalCode();
                result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                String $state = this.getState();
                result = result * 59 + ($state == null ? 43 : $state.hashCode());
                return result;
            }
        }

        public static class SelectedFulfillmentOption
        extends StripeObject {
            @SerializedName(value="shipping")
            Shipping shipping;
            @SerializedName(value="type")
            String type;

            @Generated
            public Shipping getShipping() {
                return this.shipping;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setShipping(Shipping shipping) {
                this.shipping = shipping;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof SelectedFulfillmentOption)) {
                    return false;
                }
                SelectedFulfillmentOption other = (SelectedFulfillmentOption)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Shipping this$shipping = this.getShipping();
                Shipping other$shipping = other.getShipping();
                if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof SelectedFulfillmentOption;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Shipping $shipping = this.getShipping();
                result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Shipping
            extends StripeObject {
                @SerializedName(value="shipping_option")
                String shippingOption;

                @Generated
                public String getShippingOption() {
                    return this.shippingOption;
                }

                @Generated
                public void setShippingOption(String shippingOption) {
                    this.shippingOption = shippingOption;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Shipping)) {
                        return false;
                    }
                    Shipping other = (Shipping)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$shippingOption = this.getShippingOption();
                    String other$shippingOption = other.getShippingOption();
                    return !(this$shippingOption == null ? other$shippingOption != null : !this$shippingOption.equals(other$shippingOption));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Shipping;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $shippingOption = this.getShippingOption();
                    result = result * 59 + ($shippingOption == null ? 43 : $shippingOption.hashCode());
                    return result;
                }
            }
        }

        public static class FulfillmentOption
        extends StripeObject {
            @SerializedName(value="shipping")
            Shipping shipping;
            @SerializedName(value="type")
            String type;

            @Generated
            public Shipping getShipping() {
                return this.shipping;
            }

            @Generated
            public String getType() {
                return this.type;
            }

            @Generated
            public void setShipping(Shipping shipping) {
                this.shipping = shipping;
            }

            @Generated
            public void setType(String type) {
                this.type = type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof FulfillmentOption)) {
                    return false;
                }
                FulfillmentOption other = (FulfillmentOption)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Shipping this$shipping = this.getShipping();
                Shipping other$shipping = other.getShipping();
                if (this$shipping == null ? other$shipping != null : !((Object)this$shipping).equals(other$shipping)) {
                    return false;
                }
                String this$type = this.getType();
                String other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof FulfillmentOption;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Shipping $shipping = this.getShipping();
                result = result * 59 + ($shipping == null ? 43 : ((Object)$shipping).hashCode());
                String $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class Shipping
            extends StripeObject {
                @SerializedName(value="shipping_options")
                List<ShippingOption> shippingOptions;

                @Generated
                public List<ShippingOption> getShippingOptions() {
                    return this.shippingOptions;
                }

                @Generated
                public void setShippingOptions(List<ShippingOption> shippingOptions) {
                    this.shippingOptions = shippingOptions;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Shipping)) {
                        return false;
                    }
                    Shipping other = (Shipping)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    List<ShippingOption> this$shippingOptions = this.getShippingOptions();
                    List<ShippingOption> other$shippingOptions = other.getShippingOptions();
                    return !(this$shippingOptions == null ? other$shippingOptions != null : !((Object)this$shippingOptions).equals(other$shippingOptions));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Shipping;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    List<ShippingOption> $shippingOptions = this.getShippingOptions();
                    result = result * 59 + ($shippingOptions == null ? 43 : ((Object)$shippingOptions).hashCode());
                    return result;
                }

                public static class ShippingOption
                extends StripeObject {
                    @SerializedName(value="description")
                    String description;
                    @SerializedName(value="display_name")
                    String displayName;
                    @SerializedName(value="earliest_delivery_time")
                    Long earliestDeliveryTime;
                    @SerializedName(value="key")
                    String key;
                    @SerializedName(value="latest_delivery_time")
                    Long latestDeliveryTime;
                    @SerializedName(value="shipping_amount")
                    Long shippingAmount;

                    @Generated
                    public String getDescription() {
                        return this.description;
                    }

                    @Generated
                    public String getDisplayName() {
                        return this.displayName;
                    }

                    @Generated
                    public Long getEarliestDeliveryTime() {
                        return this.earliestDeliveryTime;
                    }

                    @Generated
                    public String getKey() {
                        return this.key;
                    }

                    @Generated
                    public Long getLatestDeliveryTime() {
                        return this.latestDeliveryTime;
                    }

                    @Generated
                    public Long getShippingAmount() {
                        return this.shippingAmount;
                    }

                    @Generated
                    public void setDescription(String description) {
                        this.description = description;
                    }

                    @Generated
                    public void setDisplayName(String displayName) {
                        this.displayName = displayName;
                    }

                    @Generated
                    public void setEarliestDeliveryTime(Long earliestDeliveryTime) {
                        this.earliestDeliveryTime = earliestDeliveryTime;
                    }

                    @Generated
                    public void setKey(String key) {
                        this.key = key;
                    }

                    @Generated
                    public void setLatestDeliveryTime(Long latestDeliveryTime) {
                        this.latestDeliveryTime = latestDeliveryTime;
                    }

                    @Generated
                    public void setShippingAmount(Long shippingAmount) {
                        this.shippingAmount = shippingAmount;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ShippingOption)) {
                            return false;
                        }
                        ShippingOption other = (ShippingOption)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Long this$earliestDeliveryTime = this.getEarliestDeliveryTime();
                        Long other$earliestDeliveryTime = other.getEarliestDeliveryTime();
                        if (this$earliestDeliveryTime == null ? other$earliestDeliveryTime != null : !((Object)this$earliestDeliveryTime).equals(other$earliestDeliveryTime)) {
                            return false;
                        }
                        Long this$latestDeliveryTime = this.getLatestDeliveryTime();
                        Long other$latestDeliveryTime = other.getLatestDeliveryTime();
                        if (this$latestDeliveryTime == null ? other$latestDeliveryTime != null : !((Object)this$latestDeliveryTime).equals(other$latestDeliveryTime)) {
                            return false;
                        }
                        Long this$shippingAmount = this.getShippingAmount();
                        Long other$shippingAmount = other.getShippingAmount();
                        if (this$shippingAmount == null ? other$shippingAmount != null : !((Object)this$shippingAmount).equals(other$shippingAmount)) {
                            return false;
                        }
                        String this$description = this.getDescription();
                        String other$description = other.getDescription();
                        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                            return false;
                        }
                        String this$displayName = this.getDisplayName();
                        String other$displayName = other.getDisplayName();
                        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
                            return false;
                        }
                        String this$key = this.getKey();
                        String other$key = other.getKey();
                        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ShippingOption;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Long $earliestDeliveryTime = this.getEarliestDeliveryTime();
                        result = result * 59 + ($earliestDeliveryTime == null ? 43 : ((Object)$earliestDeliveryTime).hashCode());
                        Long $latestDeliveryTime = this.getLatestDeliveryTime();
                        result = result * 59 + ($latestDeliveryTime == null ? 43 : ((Object)$latestDeliveryTime).hashCode());
                        Long $shippingAmount = this.getShippingAmount();
                        result = result * 59 + ($shippingAmount == null ? 43 : ((Object)$shippingAmount).hashCode());
                        String $description = this.getDescription();
                        result = result * 59 + ($description == null ? 43 : $description.hashCode());
                        String $displayName = this.getDisplayName();
                        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
                        String $key = this.getKey();
                        result = result * 59 + ($key == null ? 43 : $key.hashCode());
                        return result;
                    }
                }
            }
        }
    }

    public static class OrderDetails
    extends StripeObject {
        @SerializedName(value="order_id")
        String orderId;
        @SerializedName(value="order_status_url")
        String orderStatusUrl;

        @Generated
        public String getOrderId() {
            return this.orderId;
        }

        @Generated
        public String getOrderStatusUrl() {
            return this.orderStatusUrl;
        }

        @Generated
        public void setOrderId(String orderId) {
            this.orderId = orderId;
        }

        @Generated
        public void setOrderStatusUrl(String orderStatusUrl) {
            this.orderStatusUrl = orderStatusUrl;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderDetails)) {
                return false;
            }
            OrderDetails other = (OrderDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$orderId = this.getOrderId();
            String other$orderId = other.getOrderId();
            if (this$orderId == null ? other$orderId != null : !this$orderId.equals(other$orderId)) {
                return false;
            }
            String this$orderStatusUrl = this.getOrderStatusUrl();
            String other$orderStatusUrl = other.getOrderStatusUrl();
            return !(this$orderStatusUrl == null ? other$orderStatusUrl != null : !this$orderStatusUrl.equals(other$orderStatusUrl));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OrderDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $orderId = this.getOrderId();
            result = result * 59 + ($orderId == null ? 43 : $orderId.hashCode());
            String $orderStatusUrl = this.getOrderStatusUrl();
            result = result * 59 + ($orderStatusUrl == null ? 43 : $orderStatusUrl.hashCode());
            return result;
        }
    }

    public static class PaymentMethodPreview
    extends StripeObject {
        @SerializedName(value="billing_details")
        BillingDetails billingDetails;
        @SerializedName(value="card")
        Card card;
        @SerializedName(value="type")
        String type;

        @Generated
        public BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @Generated
        public Card getCard() {
            return this.card;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setBillingDetails(BillingDetails billingDetails) {
            this.billingDetails = billingDetails;
        }

        @Generated
        public void setCard(Card card) {
            this.card = card;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentMethodPreview)) {
                return false;
            }
            PaymentMethodPreview other = (PaymentMethodPreview)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BillingDetails this$billingDetails = this.getBillingDetails();
            BillingDetails other$billingDetails = other.getBillingDetails();
            if (this$billingDetails == null ? other$billingDetails != null : !((Object)this$billingDetails).equals(other$billingDetails)) {
                return false;
            }
            Card this$card = this.getCard();
            Card other$card = other.getCard();
            if (this$card == null ? other$card != null : !((Object)this$card).equals(other$card)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaymentMethodPreview;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BillingDetails $billingDetails = this.getBillingDetails();
            result = result * 59 + ($billingDetails == null ? 43 : ((Object)$billingDetails).hashCode());
            Card $card = this.getCard();
            result = result * 59 + ($card == null ? 43 : ((Object)$card).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class BillingDetails
        extends StripeObject {
            @SerializedName(value="address")
            Address address;
            @SerializedName(value="email")
            String email;
            @SerializedName(value="name")
            String name;
            @SerializedName(value="phone")
            String phone;

            @Generated
            public Address getAddress() {
                return this.address;
            }

            @Generated
            public String getEmail() {
                return this.email;
            }

            @Generated
            public String getName() {
                return this.name;
            }

            @Generated
            public String getPhone() {
                return this.phone;
            }

            @Generated
            public void setAddress(Address address) {
                this.address = address;
            }

            @Generated
            public void setEmail(String email) {
                this.email = email;
            }

            @Generated
            public void setName(String name) {
                this.name = name;
            }

            @Generated
            public void setPhone(String phone) {
                this.phone = phone;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof BillingDetails)) {
                    return false;
                }
                BillingDetails other = (BillingDetails)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Address this$address = this.getAddress();
                Address other$address = other.getAddress();
                if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
                    return false;
                }
                String this$email = this.getEmail();
                String other$email = other.getEmail();
                if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
                    return false;
                }
                String this$name = this.getName();
                String other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                    return false;
                }
                String this$phone = this.getPhone();
                String other$phone = other.getPhone();
                return !(this$phone == null ? other$phone != null : !this$phone.equals(other$phone));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof BillingDetails;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Address $address = this.getAddress();
                result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
                String $email = this.getEmail();
                result = result * 59 + ($email == null ? 43 : $email.hashCode());
                String $name = this.getName();
                result = result * 59 + ($name == null ? 43 : $name.hashCode());
                String $phone = this.getPhone();
                result = result * 59 + ($phone == null ? 43 : $phone.hashCode());
                return result;
            }

            public static class Address
            extends StripeObject {
                @SerializedName(value="city")
                String city;
                @SerializedName(value="country")
                String country;
                @SerializedName(value="line1")
                String line1;
                @SerializedName(value="line2")
                String line2;
                @SerializedName(value="postal_code")
                String postalCode;
                @SerializedName(value="state")
                String state;

                @Generated
                public String getCity() {
                    return this.city;
                }

                @Generated
                public String getCountry() {
                    return this.country;
                }

                @Generated
                public String getLine1() {
                    return this.line1;
                }

                @Generated
                public String getLine2() {
                    return this.line2;
                }

                @Generated
                public String getPostalCode() {
                    return this.postalCode;
                }

                @Generated
                public String getState() {
                    return this.state;
                }

                @Generated
                public void setCity(String city) {
                    this.city = city;
                }

                @Generated
                public void setCountry(String country) {
                    this.country = country;
                }

                @Generated
                public void setLine1(String line1) {
                    this.line1 = line1;
                }

                @Generated
                public void setLine2(String line2) {
                    this.line2 = line2;
                }

                @Generated
                public void setPostalCode(String postalCode) {
                    this.postalCode = postalCode;
                }

                @Generated
                public void setState(String state) {
                    this.state = state;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Address)) {
                        return false;
                    }
                    Address other = (Address)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    String this$city = this.getCity();
                    String other$city = other.getCity();
                    if (this$city == null ? other$city != null : !this$city.equals(other$city)) {
                        return false;
                    }
                    String this$country = this.getCountry();
                    String other$country = other.getCountry();
                    if (this$country == null ? other$country != null : !this$country.equals(other$country)) {
                        return false;
                    }
                    String this$line1 = this.getLine1();
                    String other$line1 = other.getLine1();
                    if (this$line1 == null ? other$line1 != null : !this$line1.equals(other$line1)) {
                        return false;
                    }
                    String this$line2 = this.getLine2();
                    String other$line2 = other.getLine2();
                    if (this$line2 == null ? other$line2 != null : !this$line2.equals(other$line2)) {
                        return false;
                    }
                    String this$postalCode = this.getPostalCode();
                    String other$postalCode = other.getPostalCode();
                    if (this$postalCode == null ? other$postalCode != null : !this$postalCode.equals(other$postalCode)) {
                        return false;
                    }
                    String this$state = this.getState();
                    String other$state = other.getState();
                    return !(this$state == null ? other$state != null : !this$state.equals(other$state));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Address;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    String $city = this.getCity();
                    result = result * 59 + ($city == null ? 43 : $city.hashCode());
                    String $country = this.getCountry();
                    result = result * 59 + ($country == null ? 43 : $country.hashCode());
                    String $line1 = this.getLine1();
                    result = result * 59 + ($line1 == null ? 43 : $line1.hashCode());
                    String $line2 = this.getLine2();
                    result = result * 59 + ($line2 == null ? 43 : $line2.hashCode());
                    String $postalCode = this.getPostalCode();
                    result = result * 59 + ($postalCode == null ? 43 : $postalCode.hashCode());
                    String $state = this.getState();
                    result = result * 59 + ($state == null ? 43 : $state.hashCode());
                    return result;
                }
            }
        }

        public static class Card
        extends StripeObject {
            @SerializedName(value="exp_month")
            Long expMonth;
            @SerializedName(value="exp_year")
            Long expYear;
            @SerializedName(value="last4")
            String last4;

            @Generated
            public Long getExpMonth() {
                return this.expMonth;
            }

            @Generated
            public Long getExpYear() {
                return this.expYear;
            }

            @Generated
            public String getLast4() {
                return this.last4;
            }

            @Generated
            public void setExpMonth(Long expMonth) {
                this.expMonth = expMonth;
            }

            @Generated
            public void setExpYear(Long expYear) {
                this.expYear = expYear;
            }

            @Generated
            public void setLast4(String last4) {
                this.last4 = last4;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Card)) {
                    return false;
                }
                Card other = (Card)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Long this$expMonth = this.getExpMonth();
                Long other$expMonth = other.getExpMonth();
                if (this$expMonth == null ? other$expMonth != null : !((Object)this$expMonth).equals(other$expMonth)) {
                    return false;
                }
                Long this$expYear = this.getExpYear();
                Long other$expYear = other.getExpYear();
                if (this$expYear == null ? other$expYear != null : !((Object)this$expYear).equals(other$expYear)) {
                    return false;
                }
                String this$last4 = this.getLast4();
                String other$last4 = other.getLast4();
                return !(this$last4 == null ? other$last4 != null : !this$last4.equals(other$last4));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Card;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Long $expMonth = this.getExpMonth();
                result = result * 59 + ($expMonth == null ? 43 : ((Object)$expMonth).hashCode());
                Long $expYear = this.getExpYear();
                result = result * 59 + ($expYear == null ? 43 : ((Object)$expYear).hashCode());
                String $last4 = this.getLast4();
                result = result * 59 + ($last4 == null ? 43 : $last4.hashCode());
                return result;
            }
        }
    }

    public static class SellerDetails
    extends StripeObject {
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SellerDetails)) {
                return false;
            }
            SellerDetails other = (SellerDetails)o;
            return other.canEqual(this);
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SellerDetails;
        }

        @Generated
        public int hashCode() {
            boolean result = true;
            return 1;
        }
    }

    public static class TotalDetails
    extends StripeObject {
        @SerializedName(value="amount_discount")
        Long amountDiscount;
        @SerializedName(value="amount_fulfillment")
        Long amountFulfillment;
        @SerializedName(value="amount_tax")
        Long amountTax;

        @Generated
        public Long getAmountDiscount() {
            return this.amountDiscount;
        }

        @Generated
        public Long getAmountFulfillment() {
            return this.amountFulfillment;
        }

        @Generated
        public Long getAmountTax() {
            return this.amountTax;
        }

        @Generated
        public void setAmountDiscount(Long amountDiscount) {
            this.amountDiscount = amountDiscount;
        }

        @Generated
        public void setAmountFulfillment(Long amountFulfillment) {
            this.amountFulfillment = amountFulfillment;
        }

        @Generated
        public void setAmountTax(Long amountTax) {
            this.amountTax = amountTax;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TotalDetails)) {
                return false;
            }
            TotalDetails other = (TotalDetails)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$amountDiscount = this.getAmountDiscount();
            Long other$amountDiscount = other.getAmountDiscount();
            if (this$amountDiscount == null ? other$amountDiscount != null : !((Object)this$amountDiscount).equals(other$amountDiscount)) {
                return false;
            }
            Long this$amountFulfillment = this.getAmountFulfillment();
            Long other$amountFulfillment = other.getAmountFulfillment();
            if (this$amountFulfillment == null ? other$amountFulfillment != null : !((Object)this$amountFulfillment).equals(other$amountFulfillment)) {
                return false;
            }
            Long this$amountTax = this.getAmountTax();
            Long other$amountTax = other.getAmountTax();
            return !(this$amountTax == null ? other$amountTax != null : !((Object)this$amountTax).equals(other$amountTax));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof TotalDetails;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $amountDiscount = this.getAmountDiscount();
            result = result * 59 + ($amountDiscount == null ? 43 : ((Object)$amountDiscount).hashCode());
            Long $amountFulfillment = this.getAmountFulfillment();
            result = result * 59 + ($amountFulfillment == null ? 43 : ((Object)$amountFulfillment).hashCode());
            Long $amountTax = this.getAmountTax();
            result = result * 59 + ($amountTax == null ? 43 : ((Object)$amountTax).hashCode());
            return result;
        }
    }

    public static class LineItemDetail
    extends StripeObject {
        @SerializedName(value="description")
        String description;
        @SerializedName(value="images")
        List<String> images;
        @SerializedName(value="key")
        String key;
        @SerializedName(value="name")
        String name;
        @SerializedName(value="quantity")
        Long quantity;
        @SerializedName(value="sku_id")
        String skuId;
        @SerializedName(value="unit_amount")
        Long unitAmount;

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public List<String> getImages() {
            return this.images;
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Long getQuantity() {
            return this.quantity;
        }

        @Generated
        public String getSkuId() {
            return this.skuId;
        }

        @Generated
        public Long getUnitAmount() {
            return this.unitAmount;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public void setImages(List<String> images) {
            this.images = images;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setQuantity(Long quantity) {
            this.quantity = quantity;
        }

        @Generated
        public void setSkuId(String skuId) {
            this.skuId = skuId;
        }

        @Generated
        public void setUnitAmount(Long unitAmount) {
            this.unitAmount = unitAmount;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LineItemDetail)) {
                return false;
            }
            LineItemDetail other = (LineItemDetail)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$quantity = this.getQuantity();
            Long other$quantity = other.getQuantity();
            if (this$quantity == null ? other$quantity != null : !((Object)this$quantity).equals(other$quantity)) {
                return false;
            }
            Long this$unitAmount = this.getUnitAmount();
            Long other$unitAmount = other.getUnitAmount();
            if (this$unitAmount == null ? other$unitAmount != null : !((Object)this$unitAmount).equals(other$unitAmount)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                return false;
            }
            List<String> this$images = this.getImages();
            List<String> other$images = other.getImages();
            if (this$images == null ? other$images != null : !((Object)this$images).equals(other$images)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$skuId = this.getSkuId();
            String other$skuId = other.getSkuId();
            return !(this$skuId == null ? other$skuId != null : !this$skuId.equals(other$skuId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LineItemDetail;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $quantity = this.getQuantity();
            result = result * 59 + ($quantity == null ? 43 : ((Object)$quantity).hashCode());
            Long $unitAmount = this.getUnitAmount();
            result = result * 59 + ($unitAmount == null ? 43 : ((Object)$unitAmount).hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            List<String> $images = this.getImages();
            result = result * 59 + ($images == null ? 43 : ((Object)$images).hashCode());
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $skuId = this.getSkuId();
            result = result * 59 + ($skuId == null ? 43 : $skuId.hashCode());
            return result;
        }
    }
}

