/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.identity;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.ExpandableField;
import com.stripe.model.HasId;
import com.stripe.model.identity.BlocklistEntryCollection;
import com.stripe.model.identity.VerificationReport;
import com.stripe.model.identity.VerificationSession;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.identity.BlocklistEntryCreateParams;
import com.stripe.param.identity.BlocklistEntryDisableParams;
import com.stripe.param.identity.BlocklistEntryListParams;
import com.stripe.param.identity.BlocklistEntryRetrieveParams;
import java.lang.reflect.Type;
import java.util.Map;
import lombok.Generated;

public class BlocklistEntry
extends ApiResource
implements HasId {
    @SerializedName(value="created")
    Long created;
    @SerializedName(value="disabled_at")
    Long disabledAt;
    @SerializedName(value="expires_at")
    Long expiresAt;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="status")
    String status;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="verification_report")
    ExpandableField<VerificationReport> verificationReport;
    @SerializedName(value="verification_session")
    ExpandableField<VerificationSession> verificationSession;

    public String getVerificationReport() {
        return this.verificationReport != null ? this.verificationReport.getId() : null;
    }

    public void setVerificationReport(String id) {
        this.verificationReport = ApiResource.setExpandableFieldId(id, this.verificationReport);
    }

    public VerificationReport getVerificationReportObject() {
        return this.verificationReport != null ? this.verificationReport.getExpanded() : null;
    }

    public void setVerificationReportObject(VerificationReport expandableObject) {
        this.verificationReport = new ExpandableField<VerificationReport>(expandableObject.getId(), expandableObject);
    }

    public String getVerificationSession() {
        return this.verificationSession != null ? this.verificationSession.getId() : null;
    }

    public void setVerificationSession(String id) {
        this.verificationSession = ApiResource.setExpandableFieldId(id, this.verificationSession);
    }

    public VerificationSession getVerificationSessionObject() {
        return this.verificationSession != null ? this.verificationSession.getExpanded() : null;
    }

    public void setVerificationSessionObject(VerificationSession expandableObject) {
        this.verificationSession = new ExpandableField<VerificationSession>(expandableObject.getId(), expandableObject);
    }

    public static BlocklistEntry create(Map<String, Object> params) throws StripeException {
        return BlocklistEntry.create(params, (RequestOptions)null);
    }

    public static BlocklistEntry create(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/blocklist_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (BlocklistEntry)BlocklistEntry.getGlobalResponseGetter().request(request, (Type)((Object)BlocklistEntry.class));
    }

    public static BlocklistEntry create(BlocklistEntryCreateParams params) throws StripeException {
        return BlocklistEntry.create(params, (RequestOptions)null);
    }

    public static BlocklistEntry create(BlocklistEntryCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/blocklist_entries";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntry)BlocklistEntry.getGlobalResponseGetter().request(request, (Type)((Object)BlocklistEntry.class));
    }

    public BlocklistEntry disable() throws StripeException {
        return this.disable((Map<String, Object>)null, (RequestOptions)null);
    }

    public BlocklistEntry disable(RequestOptions options) throws StripeException {
        return this.disable((Map<String, Object>)null, options);
    }

    public BlocklistEntry disable(Map<String, Object> params) throws StripeException {
        return this.disable(params, (RequestOptions)null);
    }

    public BlocklistEntry disable(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/blocklist_entries/%s/disable", ApiResource.urlEncodeId(this.getId()));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, params, options);
        return (BlocklistEntry)this.getResponseGetter().request(request, (Type)((Object)BlocklistEntry.class));
    }

    public BlocklistEntry disable(BlocklistEntryDisableParams params) throws StripeException {
        return this.disable(params, (RequestOptions)null);
    }

    public BlocklistEntry disable(BlocklistEntryDisableParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/blocklist_entries/%s/disable", ApiResource.urlEncodeId(this.getId()));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntry)this.getResponseGetter().request(request, (Type)((Object)BlocklistEntry.class));
    }

    public static BlocklistEntryCollection list(Map<String, Object> params) throws StripeException {
        return BlocklistEntry.list(params, (RequestOptions)null);
    }

    public static BlocklistEntryCollection list(Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/blocklist_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (BlocklistEntryCollection)BlocklistEntry.getGlobalResponseGetter().request(request, (Type)((Object)BlocklistEntryCollection.class));
    }

    public static BlocklistEntryCollection list(BlocklistEntryListParams params) throws StripeException {
        return BlocklistEntry.list(params, (RequestOptions)null);
    }

    public static BlocklistEntryCollection list(BlocklistEntryListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/blocklist_entries";
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntryCollection)BlocklistEntry.getGlobalResponseGetter().request(request, (Type)((Object)BlocklistEntryCollection.class));
    }

    public static BlocklistEntry retrieve(String id) throws StripeException {
        return BlocklistEntry.retrieve(id, (Map<String, Object>)null, (RequestOptions)null);
    }

    public static BlocklistEntry retrieve(String id, RequestOptions options) throws StripeException {
        return BlocklistEntry.retrieve(id, (Map<String, Object>)null, options);
    }

    public static BlocklistEntry retrieve(String id, Map<String, Object> params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/blocklist_entries/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, params, options);
        return (BlocklistEntry)BlocklistEntry.getGlobalResponseGetter().request(request, (Type)((Object)BlocklistEntry.class));
    }

    public static BlocklistEntry retrieve(String id, BlocklistEntryRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/blocklist_entries/%s", ApiResource.urlEncodeId(id));
        ApiResource.checkNullTypedParams(path, params);
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntry)BlocklistEntry.getGlobalResponseGetter().request(request, (Type)((Object)BlocklistEntry.class));
    }

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        super.setResponseGetter(responseGetter);
        this.trySetResponseGetter(this.verificationReport, responseGetter);
        this.trySetResponseGetter(this.verificationSession, responseGetter);
    }

    @Generated
    public Long getCreated() {
        return this.created;
    }

    @Generated
    public Long getDisabledAt() {
        return this.disabledAt;
    }

    @Generated
    public Long getExpiresAt() {
        return this.expiresAt;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public String getStatus() {
        return this.status;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setCreated(Long created) {
        this.created = created;
    }

    @Generated
    public void setDisabledAt(Long disabledAt) {
        this.disabledAt = disabledAt;
    }

    @Generated
    public void setExpiresAt(Long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setStatus(String status) {
        this.status = status;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlocklistEntry)) {
            return false;
        }
        BlocklistEntry other = (BlocklistEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$created = this.getCreated();
        Long other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        Long this$disabledAt = this.getDisabledAt();
        Long other$disabledAt = other.getDisabledAt();
        if (this$disabledAt == null ? other$disabledAt != null : !((Object)this$disabledAt).equals(other$disabledAt)) {
            return false;
        }
        Long this$expiresAt = this.getExpiresAt();
        Long other$expiresAt = other.getExpiresAt();
        if (this$expiresAt == null ? other$expiresAt != null : !((Object)this$expiresAt).equals(other$expiresAt)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$verificationReport = this.getVerificationReport();
        String other$verificationReport = other.getVerificationReport();
        if (this$verificationReport == null ? other$verificationReport != null : !this$verificationReport.equals(other$verificationReport)) {
            return false;
        }
        String this$verificationSession = this.getVerificationSession();
        String other$verificationSession = other.getVerificationSession();
        return !(this$verificationSession == null ? other$verificationSession != null : !this$verificationSession.equals(other$verificationSession));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BlocklistEntry;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        Long $disabledAt = this.getDisabledAt();
        result = result * 59 + ($disabledAt == null ? 43 : ((Object)$disabledAt).hashCode());
        Long $expiresAt = this.getExpiresAt();
        result = result * 59 + ($expiresAt == null ? 43 : ((Object)$expiresAt).hashCode());
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $verificationReport = this.getVerificationReport();
        result = result * 59 + ($verificationReport == null ? 43 : $verificationReport.hashCode());
        String $verificationSession = this.getVerificationSession();
        result = result * 59 + ($verificationSession == null ? 43 : $verificationSession.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }
}

