/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.model.v2.core;

import com.google.gson.annotations.SerializedName;
import com.stripe.exception.StripeException;
import com.stripe.model.HasId;
import com.stripe.model.StripeActiveObject;
import com.stripe.model.StripeObject;
import com.stripe.model.StripeRawJsonObject;
import com.stripe.model.v2.EventDataClassLookup;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiResource;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import java.time.Instant;
import java.util.Map;
import lombok.Generated;

public class Event
extends StripeObject
implements HasId,
StripeActiveObject {
    @SerializedName(value="changes")
    Map<String, Object> changes;
    @SerializedName(value="context")
    String context;
    @SerializedName(value="created")
    Instant created;
    @SerializedName(value="id")
    String id;
    @SerializedName(value="livemode")
    Boolean livemode;
    @SerializedName(value="object")
    String object;
    @SerializedName(value="reason")
    Reason reason;
    @SerializedName(value="type")
    String type;
    @SerializedName(value="v1_event_id")
    String v1EventId;
    StripeResponseGetter responseGetter;

    @Override
    public void setResponseGetter(StripeResponseGetter responseGetter) {
        this.responseGetter = responseGetter;
    }

    protected StripeObject fetchRelatedObject(RelatedObject relatedObject) throws StripeException {
        if (relatedObject == null) {
            return null;
        }
        if (relatedObject.getUrl() == null) {
            return null;
        }
        Class<? extends StripeObject> objectClass = EventDataClassLookup.classLookup.get(relatedObject.getType());
        if (objectClass == null) {
            objectClass = StripeRawJsonObject.class;
        }
        RequestOptions opts = null;
        if (this.context != null) {
            opts = new RequestOptions.RequestOptionsBuilder().setStripeAccount(this.context).build();
        }
        return this.responseGetter.request(new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, relatedObject.getUrl(), null, opts), objectClass);
    }

    public static Event parse(String payload) {
        return (Event)ApiResource.GSON.fromJson(payload, Event.class);
    }

    @Generated
    public Map<String, Object> getChanges() {
        return this.changes;
    }

    @Generated
    public String getContext() {
        return this.context;
    }

    @Generated
    public Instant getCreated() {
        return this.created;
    }

    @Generated
    public Boolean getLivemode() {
        return this.livemode;
    }

    @Generated
    public String getObject() {
        return this.object;
    }

    @Generated
    public Reason getReason() {
        return this.reason;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getV1EventId() {
        return this.v1EventId;
    }

    @Generated
    public StripeResponseGetter getResponseGetter() {
        return this.responseGetter;
    }

    @Generated
    public void setChanges(Map<String, Object> changes) {
        this.changes = changes;
    }

    @Generated
    public void setContext(String context) {
        this.context = context;
    }

    @Generated
    public void setCreated(Instant created) {
        this.created = created;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setLivemode(Boolean livemode) {
        this.livemode = livemode;
    }

    @Generated
    public void setObject(String object) {
        this.object = object;
    }

    @Generated
    public void setReason(Reason reason) {
        this.reason = reason;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public void setV1EventId(String v1EventId) {
        this.v1EventId = v1EventId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Event)) {
            return false;
        }
        Event other = (Event)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$livemode = this.getLivemode();
        Boolean other$livemode = other.getLivemode();
        if (this$livemode == null ? other$livemode != null : !((Object)this$livemode).equals(other$livemode)) {
            return false;
        }
        Map<String, Object> this$changes = this.getChanges();
        Map<String, Object> other$changes = other.getChanges();
        if (this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        Instant this$created = this.getCreated();
        Instant other$created = other.getCreated();
        if (this$created == null ? other$created != null : !((Object)this$created).equals(other$created)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$object = this.getObject();
        String other$object = other.getObject();
        if (this$object == null ? other$object != null : !this$object.equals(other$object)) {
            return false;
        }
        Reason this$reason = this.getReason();
        Reason other$reason = other.getReason();
        if (this$reason == null ? other$reason != null : !((Object)this$reason).equals(other$reason)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$v1EventId = this.getV1EventId();
        String other$v1EventId = other.getV1EventId();
        if (this$v1EventId == null ? other$v1EventId != null : !this$v1EventId.equals(other$v1EventId)) {
            return false;
        }
        StripeResponseGetter this$responseGetter = this.getResponseGetter();
        StripeResponseGetter other$responseGetter = other.getResponseGetter();
        return !(this$responseGetter == null ? other$responseGetter != null : !this$responseGetter.equals(other$responseGetter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Event;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $livemode = this.getLivemode();
        result = result * 59 + ($livemode == null ? 43 : ((Object)$livemode).hashCode());
        Map<String, Object> $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        Instant $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : ((Object)$created).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : $object.hashCode());
        Reason $reason = this.getReason();
        result = result * 59 + ($reason == null ? 43 : ((Object)$reason).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $v1EventId = this.getV1EventId();
        result = result * 59 + ($v1EventId == null ? 43 : $v1EventId.hashCode());
        StripeResponseGetter $responseGetter = this.getResponseGetter();
        result = result * 59 + ($responseGetter == null ? 43 : $responseGetter.hashCode());
        return result;
    }

    @Override
    @Generated
    public String getId() {
        return this.id;
    }

    public static class RelatedObject
    extends StripeObject
    implements HasId {
        @SerializedName(value="id")
        String id;
        @SerializedName(value="type")
        String type;
        @SerializedName(value="url")
        String url;

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RelatedObject)) {
                return false;
            }
            RelatedObject other = (RelatedObject)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof RelatedObject;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Override
        @Generated
        public String getId() {
            return this.id;
        }
    }

    public static class Reason
    extends StripeObject {
        @SerializedName(value="request")
        Request request;
        @SerializedName(value="type")
        String type;

        @Generated
        public Request getRequest() {
            return this.request;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setRequest(Request request) {
            this.request = request;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Reason)) {
                return false;
            }
            Reason other = (Reason)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Request this$request = this.getRequest();
            Request other$request = other.getRequest();
            if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Reason;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Request $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public static class Request
        extends StripeObject
        implements HasId {
            @SerializedName(value="id")
            String id;
            @SerializedName(value="idempotency_key")
            String idempotencyKey;

            @Generated
            public String getIdempotencyKey() {
                return this.idempotencyKey;
            }

            @Generated
            public void setId(String id) {
                this.id = id;
            }

            @Generated
            public void setIdempotencyKey(String idempotencyKey) {
                this.idempotencyKey = idempotencyKey;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Request)) {
                    return false;
                }
                Request other = (Request)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$id = this.getId();
                String other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                String this$idempotencyKey = this.getIdempotencyKey();
                String other$idempotencyKey = other.getIdempotencyKey();
                return !(this$idempotencyKey == null ? other$idempotencyKey != null : !this$idempotencyKey.equals(other$idempotencyKey));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Request;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                String $idempotencyKey = this.getIdempotencyKey();
                result = result * 59 + ($idempotencyKey == null ? 43 : $idempotencyKey.hashCode());
                return result;
            }

            @Override
            @Generated
            public String getId() {
                return this.id;
            }
        }
    }
}

