/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.param.billing;

import com.google.gson.annotations.SerializedName;
import com.stripe.net.ApiRequestParams;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class AlertCreateParams
extends ApiRequestParams {
    @SerializedName(value="alert_type")
    AlertType alertType;
    @SerializedName(value="credit_balance_threshold")
    CreditBalanceThreshold creditBalanceThreshold;
    @SerializedName(value="expand")
    List<String> expand;
    @SerializedName(value="_stripe_java_extra_param_key")
    Map<String, Object> extraParams;
    @SerializedName(value="title")
    String title;
    @SerializedName(value="usage_threshold")
    UsageThreshold usageThreshold;

    private AlertCreateParams(AlertType alertType, CreditBalanceThreshold creditBalanceThreshold, List<String> expand, Map<String, Object> extraParams, String title, UsageThreshold usageThreshold) {
        this.alertType = alertType;
        this.creditBalanceThreshold = creditBalanceThreshold;
        this.expand = expand;
        this.extraParams = extraParams;
        this.title = title;
        this.usageThreshold = usageThreshold;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public AlertType getAlertType() {
        return this.alertType;
    }

    @Generated
    public CreditBalanceThreshold getCreditBalanceThreshold() {
        return this.creditBalanceThreshold;
    }

    @Generated
    public List<String> getExpand() {
        return this.expand;
    }

    @Generated
    public Map<String, Object> getExtraParams() {
        return this.extraParams;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public UsageThreshold getUsageThreshold() {
        return this.usageThreshold;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertCreateParams)) {
            return false;
        }
        AlertCreateParams other = (AlertCreateParams)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AlertType this$alertType = this.getAlertType();
        AlertType other$alertType = other.getAlertType();
        if (this$alertType == null ? other$alertType != null : !this$alertType.equals(other$alertType)) {
            return false;
        }
        CreditBalanceThreshold this$creditBalanceThreshold = this.getCreditBalanceThreshold();
        CreditBalanceThreshold other$creditBalanceThreshold = other.getCreditBalanceThreshold();
        if (this$creditBalanceThreshold == null ? other$creditBalanceThreshold != null : !((Object)this$creditBalanceThreshold).equals(other$creditBalanceThreshold)) {
            return false;
        }
        List<String> this$expand = this.getExpand();
        List<String> other$expand = other.getExpand();
        if (this$expand == null ? other$expand != null : !((Object)this$expand).equals(other$expand)) {
            return false;
        }
        Map<String, Object> this$extraParams = this.getExtraParams();
        Map<String, Object> other$extraParams = other.getExtraParams();
        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        UsageThreshold this$usageThreshold = this.getUsageThreshold();
        UsageThreshold other$usageThreshold = other.getUsageThreshold();
        return !(this$usageThreshold == null ? other$usageThreshold != null : !((Object)this$usageThreshold).equals(other$usageThreshold));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AlertCreateParams;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AlertType $alertType = this.getAlertType();
        result = result * 59 + ($alertType == null ? 43 : $alertType.hashCode());
        CreditBalanceThreshold $creditBalanceThreshold = this.getCreditBalanceThreshold();
        result = result * 59 + ($creditBalanceThreshold == null ? 43 : ((Object)$creditBalanceThreshold).hashCode());
        List<String> $expand = this.getExpand();
        result = result * 59 + ($expand == null ? 43 : ((Object)$expand).hashCode());
        Map<String, Object> $extraParams = this.getExtraParams();
        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        UsageThreshold $usageThreshold = this.getUsageThreshold();
        result = result * 59 + ($usageThreshold == null ? 43 : ((Object)$usageThreshold).hashCode());
        return result;
    }

    public static enum AlertType implements ApiRequestParams.EnumParam
    {
        CREDIT_BALANCE_THRESHOLD("credit_balance_threshold"),
        USAGE_THRESHOLD("usage_threshold");

        private final String value;

        private AlertType(String value) {
            this.value = value;
        }

        @Override
        @Generated
        public String getValue() {
            return this.value;
        }
    }

    public static class CreditBalanceThreshold {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="filters")
        List<Filter> filters;
        @SerializedName(value="lte")
        Lte lte;

        private CreditBalanceThreshold(Map<String, Object> extraParams, List<Filter> filters, Lte lte) {
            this.extraParams = extraParams;
            this.filters = filters;
            this.lte = lte;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<Filter> getFilters() {
            return this.filters;
        }

        @Generated
        public Lte getLte() {
            return this.lte;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreditBalanceThreshold)) {
                return false;
            }
            CreditBalanceThreshold other = (CreditBalanceThreshold)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            List<Filter> this$filters = this.getFilters();
            List<Filter> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            Lte this$lte = this.getLte();
            Lte other$lte = other.getLte();
            return !(this$lte == null ? other$lte != null : !((Object)this$lte).equals(other$lte));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreditBalanceThreshold;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            List<Filter> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            Lte $lte = this.getLte();
            result = result * 59 + ($lte == null ? 43 : ((Object)$lte).hashCode());
            return result;
        }

        public static class Lte {
            @SerializedName(value="balance_type")
            BalanceType balanceType;
            @SerializedName(value="custom_pricing_unit")
            CustomPricingUnit customPricingUnit;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="monetary")
            Monetary monetary;

            private Lte(BalanceType balanceType, CustomPricingUnit customPricingUnit, Map<String, Object> extraParams, Monetary monetary) {
                this.balanceType = balanceType;
                this.customPricingUnit = customPricingUnit;
                this.extraParams = extraParams;
                this.monetary = monetary;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public BalanceType getBalanceType() {
                return this.balanceType;
            }

            @Generated
            public CustomPricingUnit getCustomPricingUnit() {
                return this.customPricingUnit;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Monetary getMonetary() {
                return this.monetary;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Lte)) {
                    return false;
                }
                Lte other = (Lte)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                BalanceType this$balanceType = this.getBalanceType();
                BalanceType other$balanceType = other.getBalanceType();
                if (this$balanceType == null ? other$balanceType != null : !this$balanceType.equals(other$balanceType)) {
                    return false;
                }
                CustomPricingUnit this$customPricingUnit = this.getCustomPricingUnit();
                CustomPricingUnit other$customPricingUnit = other.getCustomPricingUnit();
                if (this$customPricingUnit == null ? other$customPricingUnit != null : !((Object)this$customPricingUnit).equals(other$customPricingUnit)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Monetary this$monetary = this.getMonetary();
                Monetary other$monetary = other.getMonetary();
                return !(this$monetary == null ? other$monetary != null : !((Object)this$monetary).equals(other$monetary));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Lte;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                BalanceType $balanceType = this.getBalanceType();
                result = result * 59 + ($balanceType == null ? 43 : $balanceType.hashCode());
                CustomPricingUnit $customPricingUnit = this.getCustomPricingUnit();
                result = result * 59 + ($customPricingUnit == null ? 43 : ((Object)$customPricingUnit).hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Monetary $monetary = this.getMonetary();
                result = result * 59 + ($monetary == null ? 43 : ((Object)$monetary).hashCode());
                return result;
            }

            public static enum BalanceType implements ApiRequestParams.EnumParam
            {
                CUSTOM_PRICING_UNIT("custom_pricing_unit"),
                MONETARY("monetary");

                private final String value;

                private BalanceType(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class CustomPricingUnit {
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="id")
                String id;
                @SerializedName(value="value")
                BigDecimal value;

                private CustomPricingUnit(Map<String, Object> extraParams, String id, BigDecimal value) {
                    this.extraParams = extraParams;
                    this.id = id;
                    this.value = value;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public String getId() {
                    return this.id;
                }

                @Generated
                public BigDecimal getValue() {
                    return this.value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CustomPricingUnit)) {
                        return false;
                    }
                    CustomPricingUnit other = (CustomPricingUnit)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                        return false;
                    }
                    String this$id = this.getId();
                    String other$id = other.getId();
                    if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                        return false;
                    }
                    BigDecimal this$value = this.getValue();
                    BigDecimal other$value = other.getValue();
                    return !(this$value == null ? other$value != null : !((Object)this$value).equals(other$value));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CustomPricingUnit;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    String $id = this.getId();
                    result = result * 59 + ($id == null ? 43 : $id.hashCode());
                    BigDecimal $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    return result;
                }

                public static class Builder {
                    private Map<String, Object> extraParams;
                    private String id;
                    private BigDecimal value;

                    public CustomPricingUnit build() {
                        return new CustomPricingUnit(this.extraParams, this.id, this.value);
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setId(String id) {
                        this.id = id;
                        return this;
                    }

                    public Builder setValue(BigDecimal value) {
                        this.value = value;
                        return this;
                    }
                }
            }

            public static class Monetary {
                @SerializedName(value="currency")
                String currency;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;
                @SerializedName(value="value")
                Long value;

                private Monetary(String currency, Map<String, Object> extraParams, Long value) {
                    this.currency = currency;
                    this.extraParams = extraParams;
                    this.value = value;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public String getCurrency() {
                    return this.currency;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public Long getValue() {
                    return this.value;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Monetary)) {
                        return false;
                    }
                    Monetary other = (Monetary)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    Long this$value = this.getValue();
                    Long other$value = other.getValue();
                    if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
                        return false;
                    }
                    String this$currency = this.getCurrency();
                    String other$currency = other.getCurrency();
                    if (this$currency == null ? other$currency != null : !this$currency.equals(other$currency)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof Monetary;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    Long $value = this.getValue();
                    result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
                    String $currency = this.getCurrency();
                    result = result * 59 + ($currency == null ? 43 : $currency.hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class Builder {
                    private String currency;
                    private Map<String, Object> extraParams;
                    private Long value;

                    public Monetary build() {
                        return new Monetary(this.currency, this.extraParams, this.value);
                    }

                    public Builder setCurrency(String currency) {
                        this.currency = currency;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }

                    public Builder setValue(Long value) {
                        this.value = value;
                        return this;
                    }
                }
            }

            public static class Builder {
                private BalanceType balanceType;
                private CustomPricingUnit customPricingUnit;
                private Map<String, Object> extraParams;
                private Monetary monetary;

                public Lte build() {
                    return new Lte(this.balanceType, this.customPricingUnit, this.extraParams, this.monetary);
                }

                public Builder setBalanceType(BalanceType balanceType) {
                    this.balanceType = balanceType;
                    return this;
                }

                public Builder setCustomPricingUnit(CustomPricingUnit customPricingUnit) {
                    this.customPricingUnit = customPricingUnit;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setMonetary(Monetary monetary) {
                    this.monetary = monetary;
                    return this;
                }
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private List<Filter> filters;
            private Lte lte;

            public CreditBalanceThreshold build() {
                return new CreditBalanceThreshold(this.extraParams, this.filters, this.lte);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addFilter(Filter element) {
                if (this.filters == null) {
                    this.filters = new ArrayList<Filter>();
                }
                this.filters.add(element);
                return this;
            }

            public Builder addAllFilter(List<Filter> elements) {
                if (this.filters == null) {
                    this.filters = new ArrayList<Filter>();
                }
                this.filters.addAll(elements);
                return this;
            }

            public Builder setLte(Lte lte) {
                this.lte = lte;
                return this;
            }
        }

        public static class Filter {
            @SerializedName(value="credit_grants")
            CreditGrants creditGrants;
            @SerializedName(value="customer")
            String customer;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="type")
            Type type;

            private Filter(CreditGrants creditGrants, String customer, Map<String, Object> extraParams, Type type) {
                this.creditGrants = creditGrants;
                this.customer = customer;
                this.extraParams = extraParams;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public CreditGrants getCreditGrants() {
                return this.creditGrants;
            }

            @Generated
            public String getCustomer() {
                return this.customer;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Filter)) {
                    return false;
                }
                Filter other = (Filter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                CreditGrants this$creditGrants = this.getCreditGrants();
                CreditGrants other$creditGrants = other.getCreditGrants();
                if (this$creditGrants == null ? other$creditGrants != null : !((Object)this$creditGrants).equals(other$creditGrants)) {
                    return false;
                }
                String this$customer = this.getCustomer();
                String other$customer = other.getCustomer();
                if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Type this$type = this.getType();
                Type other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Filter;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                CreditGrants $creditGrants = this.getCreditGrants();
                result = result * 59 + ($creditGrants == null ? 43 : ((Object)$creditGrants).hashCode());
                String $customer = this.getCustomer();
                result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Type $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static class CreditGrants {
                @SerializedName(value="applicability_config")
                ApplicabilityConfig applicabilityConfig;
                @SerializedName(value="_stripe_java_extra_param_key")
                Map<String, Object> extraParams;

                private CreditGrants(ApplicabilityConfig applicabilityConfig, Map<String, Object> extraParams) {
                    this.applicabilityConfig = applicabilityConfig;
                    this.extraParams = extraParams;
                }

                public static Builder builder() {
                    return new Builder();
                }

                @Generated
                public ApplicabilityConfig getApplicabilityConfig() {
                    return this.applicabilityConfig;
                }

                @Generated
                public Map<String, Object> getExtraParams() {
                    return this.extraParams;
                }

                @Generated
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof CreditGrants)) {
                        return false;
                    }
                    CreditGrants other = (CreditGrants)o;
                    if (!other.canEqual(this)) {
                        return false;
                    }
                    ApplicabilityConfig this$applicabilityConfig = this.getApplicabilityConfig();
                    ApplicabilityConfig other$applicabilityConfig = other.getApplicabilityConfig();
                    if (this$applicabilityConfig == null ? other$applicabilityConfig != null : !((Object)this$applicabilityConfig).equals(other$applicabilityConfig)) {
                        return false;
                    }
                    Map<String, Object> this$extraParams = this.getExtraParams();
                    Map<String, Object> other$extraParams = other.getExtraParams();
                    return !(this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams));
                }

                @Generated
                protected boolean canEqual(Object other) {
                    return other instanceof CreditGrants;
                }

                @Generated
                public int hashCode() {
                    int PRIME = 59;
                    int result = 1;
                    ApplicabilityConfig $applicabilityConfig = this.getApplicabilityConfig();
                    result = result * 59 + ($applicabilityConfig == null ? 43 : ((Object)$applicabilityConfig).hashCode());
                    Map<String, Object> $extraParams = this.getExtraParams();
                    result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                    return result;
                }

                public static class ApplicabilityConfig {
                    @SerializedName(value="_stripe_java_extra_param_key")
                    Map<String, Object> extraParams;
                    @SerializedName(value="scope")
                    Scope scope;

                    private ApplicabilityConfig(Map<String, Object> extraParams, Scope scope) {
                        this.extraParams = extraParams;
                        this.scope = scope;
                    }

                    public static Builder builder() {
                        return new Builder();
                    }

                    @Generated
                    public Map<String, Object> getExtraParams() {
                        return this.extraParams;
                    }

                    @Generated
                    public Scope getScope() {
                        return this.scope;
                    }

                    @Generated
                    public boolean equals(Object o) {
                        if (o == this) {
                            return true;
                        }
                        if (!(o instanceof ApplicabilityConfig)) {
                            return false;
                        }
                        ApplicabilityConfig other = (ApplicabilityConfig)o;
                        if (!other.canEqual(this)) {
                            return false;
                        }
                        Map<String, Object> this$extraParams = this.getExtraParams();
                        Map<String, Object> other$extraParams = other.getExtraParams();
                        if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                            return false;
                        }
                        Scope this$scope = this.getScope();
                        Scope other$scope = other.getScope();
                        return !(this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope));
                    }

                    @Generated
                    protected boolean canEqual(Object other) {
                        return other instanceof ApplicabilityConfig;
                    }

                    @Generated
                    public int hashCode() {
                        int PRIME = 59;
                        int result = 1;
                        Map<String, Object> $extraParams = this.getExtraParams();
                        result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                        Scope $scope = this.getScope();
                        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
                        return result;
                    }

                    public static class Scope {
                        @SerializedName(value="billable_items")
                        List<BillableItem> billableItems;
                        @SerializedName(value="_stripe_java_extra_param_key")
                        Map<String, Object> extraParams;
                        @SerializedName(value="price_type")
                        PriceType priceType;
                        @SerializedName(value="prices")
                        List<Price> prices;

                        private Scope(List<BillableItem> billableItems, Map<String, Object> extraParams, PriceType priceType, List<Price> prices) {
                            this.billableItems = billableItems;
                            this.extraParams = extraParams;
                            this.priceType = priceType;
                            this.prices = prices;
                        }

                        public static Builder builder() {
                            return new Builder();
                        }

                        @Generated
                        public List<BillableItem> getBillableItems() {
                            return this.billableItems;
                        }

                        @Generated
                        public Map<String, Object> getExtraParams() {
                            return this.extraParams;
                        }

                        @Generated
                        public PriceType getPriceType() {
                            return this.priceType;
                        }

                        @Generated
                        public List<Price> getPrices() {
                            return this.prices;
                        }

                        @Generated
                        public boolean equals(Object o) {
                            if (o == this) {
                                return true;
                            }
                            if (!(o instanceof Scope)) {
                                return false;
                            }
                            Scope other = (Scope)o;
                            if (!other.canEqual(this)) {
                                return false;
                            }
                            List<BillableItem> this$billableItems = this.getBillableItems();
                            List<BillableItem> other$billableItems = other.getBillableItems();
                            if (this$billableItems == null ? other$billableItems != null : !((Object)this$billableItems).equals(other$billableItems)) {
                                return false;
                            }
                            Map<String, Object> this$extraParams = this.getExtraParams();
                            Map<String, Object> other$extraParams = other.getExtraParams();
                            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                                return false;
                            }
                            PriceType this$priceType = this.getPriceType();
                            PriceType other$priceType = other.getPriceType();
                            if (this$priceType == null ? other$priceType != null : !this$priceType.equals(other$priceType)) {
                                return false;
                            }
                            List<Price> this$prices = this.getPrices();
                            List<Price> other$prices = other.getPrices();
                            return !(this$prices == null ? other$prices != null : !((Object)this$prices).equals(other$prices));
                        }

                        @Generated
                        protected boolean canEqual(Object other) {
                            return other instanceof Scope;
                        }

                        @Generated
                        public int hashCode() {
                            int PRIME = 59;
                            int result = 1;
                            List<BillableItem> $billableItems = this.getBillableItems();
                            result = result * 59 + ($billableItems == null ? 43 : ((Object)$billableItems).hashCode());
                            Map<String, Object> $extraParams = this.getExtraParams();
                            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                            PriceType $priceType = this.getPriceType();
                            result = result * 59 + ($priceType == null ? 43 : $priceType.hashCode());
                            List<Price> $prices = this.getPrices();
                            result = result * 59 + ($prices == null ? 43 : ((Object)$prices).hashCode());
                            return result;
                        }

                        public static enum PriceType implements ApiRequestParams.EnumParam
                        {
                            METERED("metered");

                            private final String value;

                            private PriceType(String value) {
                                this.value = value;
                            }

                            @Override
                            @Generated
                            public String getValue() {
                                return this.value;
                            }
                        }

                        public static class Builder {
                            private List<BillableItem> billableItems;
                            private Map<String, Object> extraParams;
                            private PriceType priceType;
                            private List<Price> prices;

                            public Scope build() {
                                return new Scope(this.billableItems, this.extraParams, this.priceType, this.prices);
                            }

                            public Builder addBillableItem(BillableItem element) {
                                if (this.billableItems == null) {
                                    this.billableItems = new ArrayList<BillableItem>();
                                }
                                this.billableItems.add(element);
                                return this;
                            }

                            public Builder addAllBillableItem(List<BillableItem> elements) {
                                if (this.billableItems == null) {
                                    this.billableItems = new ArrayList<BillableItem>();
                                }
                                this.billableItems.addAll(elements);
                                return this;
                            }

                            public Builder putExtraParam(String key, Object value) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.put(key, value);
                                return this;
                            }

                            public Builder putAllExtraParam(Map<String, Object> map) {
                                if (this.extraParams == null) {
                                    this.extraParams = new HashMap<String, Object>();
                                }
                                this.extraParams.putAll(map);
                                return this;
                            }

                            public Builder setPriceType(PriceType priceType) {
                                this.priceType = priceType;
                                return this;
                            }

                            public Builder addPrice(Price element) {
                                if (this.prices == null) {
                                    this.prices = new ArrayList<Price>();
                                }
                                this.prices.add(element);
                                return this;
                            }

                            public Builder addAllPrice(List<Price> elements) {
                                if (this.prices == null) {
                                    this.prices = new ArrayList<Price>();
                                }
                                this.prices.addAll(elements);
                                return this;
                            }
                        }

                        public static class Price {
                            @SerializedName(value="_stripe_java_extra_param_key")
                            Map<String, Object> extraParams;
                            @SerializedName(value="id")
                            String id;

                            private Price(Map<String, Object> extraParams, String id) {
                                this.extraParams = extraParams;
                                this.id = id;
                            }

                            public static Builder builder() {
                                return new Builder();
                            }

                            @Generated
                            public Map<String, Object> getExtraParams() {
                                return this.extraParams;
                            }

                            @Generated
                            public String getId() {
                                return this.id;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof Price)) {
                                    return false;
                                }
                                Price other = (Price)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Map<String, Object> this$extraParams = this.getExtraParams();
                                Map<String, Object> other$extraParams = other.getExtraParams();
                                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                                    return false;
                                }
                                String this$id = this.getId();
                                String other$id = other.getId();
                                return !(this$id == null ? other$id != null : !this$id.equals(other$id));
                            }

                            @Generated
                            protected boolean canEqual(Object other) {
                                return other instanceof Price;
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Map<String, Object> $extraParams = this.getExtraParams();
                                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                                String $id = this.getId();
                                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                                return result;
                            }

                            public static class Builder {
                                private Map<String, Object> extraParams;
                                private String id;

                                public Price build() {
                                    return new Price(this.extraParams, this.id);
                                }

                                public Builder putExtraParam(String key, Object value) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.put(key, value);
                                    return this;
                                }

                                public Builder putAllExtraParam(Map<String, Object> map) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.putAll(map);
                                    return this;
                                }

                                public Builder setId(String id) {
                                    this.id = id;
                                    return this;
                                }
                            }
                        }

                        public static class BillableItem {
                            @SerializedName(value="_stripe_java_extra_param_key")
                            Map<String, Object> extraParams;
                            @SerializedName(value="id")
                            String id;

                            private BillableItem(Map<String, Object> extraParams, String id) {
                                this.extraParams = extraParams;
                                this.id = id;
                            }

                            public static Builder builder() {
                                return new Builder();
                            }

                            @Generated
                            public Map<String, Object> getExtraParams() {
                                return this.extraParams;
                            }

                            @Generated
                            public String getId() {
                                return this.id;
                            }

                            @Generated
                            public boolean equals(Object o) {
                                if (o == this) {
                                    return true;
                                }
                                if (!(o instanceof BillableItem)) {
                                    return false;
                                }
                                BillableItem other = (BillableItem)o;
                                if (!other.canEqual(this)) {
                                    return false;
                                }
                                Map<String, Object> this$extraParams = this.getExtraParams();
                                Map<String, Object> other$extraParams = other.getExtraParams();
                                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                                    return false;
                                }
                                String this$id = this.getId();
                                String other$id = other.getId();
                                return !(this$id == null ? other$id != null : !this$id.equals(other$id));
                            }

                            @Generated
                            protected boolean canEqual(Object other) {
                                return other instanceof BillableItem;
                            }

                            @Generated
                            public int hashCode() {
                                int PRIME = 59;
                                int result = 1;
                                Map<String, Object> $extraParams = this.getExtraParams();
                                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                                String $id = this.getId();
                                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                                return result;
                            }

                            public static class Builder {
                                private Map<String, Object> extraParams;
                                private String id;

                                public BillableItem build() {
                                    return new BillableItem(this.extraParams, this.id);
                                }

                                public Builder putExtraParam(String key, Object value) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.put(key, value);
                                    return this;
                                }

                                public Builder putAllExtraParam(Map<String, Object> map) {
                                    if (this.extraParams == null) {
                                        this.extraParams = new HashMap<String, Object>();
                                    }
                                    this.extraParams.putAll(map);
                                    return this;
                                }

                                public Builder setId(String id) {
                                    this.id = id;
                                    return this;
                                }
                            }
                        }
                    }

                    public static class Builder {
                        private Map<String, Object> extraParams;
                        private Scope scope;

                        public ApplicabilityConfig build() {
                            return new ApplicabilityConfig(this.extraParams, this.scope);
                        }

                        public Builder putExtraParam(String key, Object value) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.put(key, value);
                            return this;
                        }

                        public Builder putAllExtraParam(Map<String, Object> map) {
                            if (this.extraParams == null) {
                                this.extraParams = new HashMap<String, Object>();
                            }
                            this.extraParams.putAll(map);
                            return this;
                        }

                        public Builder setScope(Scope scope) {
                            this.scope = scope;
                            return this;
                        }
                    }
                }

                public static class Builder {
                    private ApplicabilityConfig applicabilityConfig;
                    private Map<String, Object> extraParams;

                    public CreditGrants build() {
                        return new CreditGrants(this.applicabilityConfig, this.extraParams);
                    }

                    public Builder setApplicabilityConfig(ApplicabilityConfig applicabilityConfig) {
                        this.applicabilityConfig = applicabilityConfig;
                        return this;
                    }

                    public Builder putExtraParam(String key, Object value) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.put(key, value);
                        return this;
                    }

                    public Builder putAllExtraParam(Map<String, Object> map) {
                        if (this.extraParams == null) {
                            this.extraParams = new HashMap<String, Object>();
                        }
                        this.extraParams.putAll(map);
                        return this;
                    }
                }
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                CUSTOMER("customer"),
                TENANT("tenant");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private CreditGrants creditGrants;
                private String customer;
                private Map<String, Object> extraParams;
                private Type type;

                public Filter build() {
                    return new Filter(this.creditGrants, this.customer, this.extraParams, this.type);
                }

                public Builder setCreditGrants(CreditGrants creditGrants) {
                    this.creditGrants = creditGrants;
                    return this;
                }

                public Builder setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }
    }

    public static class UsageThreshold {
        @SerializedName(value="_stripe_java_extra_param_key")
        Map<String, Object> extraParams;
        @SerializedName(value="filters")
        List<Filter> filters;
        @SerializedName(value="gte")
        Long gte;
        @SerializedName(value="meter")
        String meter;
        @SerializedName(value="recurrence")
        Recurrence recurrence;

        private UsageThreshold(Map<String, Object> extraParams, List<Filter> filters, Long gte, String meter, Recurrence recurrence) {
            this.extraParams = extraParams;
            this.filters = filters;
            this.gte = gte;
            this.meter = meter;
            this.recurrence = recurrence;
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated
        public Map<String, Object> getExtraParams() {
            return this.extraParams;
        }

        @Generated
        public List<Filter> getFilters() {
            return this.filters;
        }

        @Generated
        public Long getGte() {
            return this.gte;
        }

        @Generated
        public String getMeter() {
            return this.meter;
        }

        @Generated
        public Recurrence getRecurrence() {
            return this.recurrence;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UsageThreshold)) {
                return false;
            }
            UsageThreshold other = (UsageThreshold)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$gte = this.getGte();
            Long other$gte = other.getGte();
            if (this$gte == null ? other$gte != null : !((Object)this$gte).equals(other$gte)) {
                return false;
            }
            Map<String, Object> this$extraParams = this.getExtraParams();
            Map<String, Object> other$extraParams = other.getExtraParams();
            if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                return false;
            }
            List<Filter> this$filters = this.getFilters();
            List<Filter> other$filters = other.getFilters();
            if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
                return false;
            }
            String this$meter = this.getMeter();
            String other$meter = other.getMeter();
            if (this$meter == null ? other$meter != null : !this$meter.equals(other$meter)) {
                return false;
            }
            Recurrence this$recurrence = this.getRecurrence();
            Recurrence other$recurrence = other.getRecurrence();
            return !(this$recurrence == null ? other$recurrence != null : !this$recurrence.equals(other$recurrence));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof UsageThreshold;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $gte = this.getGte();
            result = result * 59 + ($gte == null ? 43 : ((Object)$gte).hashCode());
            Map<String, Object> $extraParams = this.getExtraParams();
            result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
            List<Filter> $filters = this.getFilters();
            result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
            String $meter = this.getMeter();
            result = result * 59 + ($meter == null ? 43 : $meter.hashCode());
            Recurrence $recurrence = this.getRecurrence();
            result = result * 59 + ($recurrence == null ? 43 : $recurrence.hashCode());
            return result;
        }

        public static enum Recurrence implements ApiRequestParams.EnumParam
        {
            ONE_TIME("one_time");

            private final String value;

            private Recurrence(String value) {
                this.value = value;
            }

            @Override
            @Generated
            public String getValue() {
                return this.value;
            }
        }

        public static class Builder {
            private Map<String, Object> extraParams;
            private List<Filter> filters;
            private Long gte;
            private String meter;
            private Recurrence recurrence;

            public UsageThreshold build() {
                return new UsageThreshold(this.extraParams, this.filters, this.gte, this.meter, this.recurrence);
            }

            public Builder putExtraParam(String key, Object value) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.put(key, value);
                return this;
            }

            public Builder putAllExtraParam(Map<String, Object> map) {
                if (this.extraParams == null) {
                    this.extraParams = new HashMap<String, Object>();
                }
                this.extraParams.putAll(map);
                return this;
            }

            public Builder addFilter(Filter element) {
                if (this.filters == null) {
                    this.filters = new ArrayList<Filter>();
                }
                this.filters.add(element);
                return this;
            }

            public Builder addAllFilter(List<Filter> elements) {
                if (this.filters == null) {
                    this.filters = new ArrayList<Filter>();
                }
                this.filters.addAll(elements);
                return this;
            }

            public Builder setGte(Long gte) {
                this.gte = gte;
                return this;
            }

            public Builder setMeter(String meter) {
                this.meter = meter;
                return this;
            }

            public Builder setRecurrence(Recurrence recurrence) {
                this.recurrence = recurrence;
                return this;
            }
        }

        public static class Filter {
            @SerializedName(value="customer")
            String customer;
            @SerializedName(value="_stripe_java_extra_param_key")
            Map<String, Object> extraParams;
            @SerializedName(value="type")
            Type type;

            private Filter(String customer, Map<String, Object> extraParams, Type type) {
                this.customer = customer;
                this.extraParams = extraParams;
                this.type = type;
            }

            public static Builder builder() {
                return new Builder();
            }

            @Generated
            public String getCustomer() {
                return this.customer;
            }

            @Generated
            public Map<String, Object> getExtraParams() {
                return this.extraParams;
            }

            @Generated
            public Type getType() {
                return this.type;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Filter)) {
                    return false;
                }
                Filter other = (Filter)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$customer = this.getCustomer();
                String other$customer = other.getCustomer();
                if (this$customer == null ? other$customer != null : !this$customer.equals(other$customer)) {
                    return false;
                }
                Map<String, Object> this$extraParams = this.getExtraParams();
                Map<String, Object> other$extraParams = other.getExtraParams();
                if (this$extraParams == null ? other$extraParams != null : !((Object)this$extraParams).equals(other$extraParams)) {
                    return false;
                }
                Type this$type = this.getType();
                Type other$type = other.getType();
                return !(this$type == null ? other$type != null : !this$type.equals(other$type));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Filter;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $customer = this.getCustomer();
                result = result * 59 + ($customer == null ? 43 : $customer.hashCode());
                Map<String, Object> $extraParams = this.getExtraParams();
                result = result * 59 + ($extraParams == null ? 43 : ((Object)$extraParams).hashCode());
                Type $type = this.getType();
                result = result * 59 + ($type == null ? 43 : $type.hashCode());
                return result;
            }

            public static enum Type implements ApiRequestParams.EnumParam
            {
                CUSTOMER("customer");

                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                @Override
                @Generated
                public String getValue() {
                    return this.value;
                }
            }

            public static class Builder {
                private String customer;
                private Map<String, Object> extraParams;
                private Type type;

                public Filter build() {
                    return new Filter(this.customer, this.extraParams, this.type);
                }

                public Builder setCustomer(String customer) {
                    this.customer = customer;
                    return this;
                }

                public Builder putExtraParam(String key, Object value) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.put(key, value);
                    return this;
                }

                public Builder putAllExtraParam(Map<String, Object> map) {
                    if (this.extraParams == null) {
                        this.extraParams = new HashMap<String, Object>();
                    }
                    this.extraParams.putAll(map);
                    return this;
                }

                public Builder setType(Type type) {
                    this.type = type;
                    return this;
                }
            }
        }
    }

    public static class Builder {
        private AlertType alertType;
        private CreditBalanceThreshold creditBalanceThreshold;
        private List<String> expand;
        private Map<String, Object> extraParams;
        private String title;
        private UsageThreshold usageThreshold;

        public AlertCreateParams build() {
            return new AlertCreateParams(this.alertType, this.creditBalanceThreshold, this.expand, this.extraParams, this.title, this.usageThreshold);
        }

        public Builder setAlertType(AlertType alertType) {
            this.alertType = alertType;
            return this;
        }

        public Builder setCreditBalanceThreshold(CreditBalanceThreshold creditBalanceThreshold) {
            this.creditBalanceThreshold = creditBalanceThreshold;
            return this;
        }

        public Builder addExpand(String element) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.add(element);
            return this;
        }

        public Builder addAllExpand(List<String> elements) {
            if (this.expand == null) {
                this.expand = new ArrayList<String>();
            }
            this.expand.addAll(elements);
            return this;
        }

        public Builder putExtraParam(String key, Object value) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.put(key, value);
            return this;
        }

        public Builder putAllExtraParam(Map<String, Object> map) {
            if (this.extraParams == null) {
                this.extraParams = new HashMap<String, Object>();
            }
            this.extraParams.putAll(map);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setUsageThreshold(UsageThreshold usageThreshold) {
            this.usageThreshold = usageThreshold;
            return this;
        }
    }
}

