/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.ExternalAccount;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.ExternalAccountCreateParams;
import com.stripe.param.ExternalAccountListParams;
import com.stripe.param.ExternalAccountRetrieveParams;
import com.stripe.param.ExternalAccountUpdateParams;
import java.lang.reflect.Type;

public final class ExternalAccountService
extends ApiService {
    public ExternalAccountService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public ExternalAccount delete(String id) throws StripeException {
        return this.delete(id, null);
    }

    public ExternalAccount delete(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v1/external_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.DELETE, path, null, options);
        return (ExternalAccount)this.request(request, (Type)((Object)ExternalAccount.class));
    }

    public ExternalAccount retrieve(String id, ExternalAccountRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public ExternalAccount retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public ExternalAccount retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public ExternalAccount retrieve(String id, ExternalAccountRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/external_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (ExternalAccount)this.request(request, (Type)((Object)ExternalAccount.class));
    }

    public ExternalAccount update(String id, ExternalAccountUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public ExternalAccount update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public ExternalAccount update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public ExternalAccount update(String id, ExternalAccountUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/external_accounts/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (ExternalAccount)this.request(request, (Type)((Object)ExternalAccount.class));
    }

    public StripeCollection<ExternalAccount> list(ExternalAccountListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<ExternalAccount> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<ExternalAccount> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<ExternalAccount> list(ExternalAccountListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/external_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<ExternalAccount>>(){}.getType());
    }

    public ExternalAccount create(ExternalAccountCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public ExternalAccount create(ExternalAccountCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/external_accounts";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (ExternalAccount)this.request(request, (Type)((Object)ExternalAccount.class));
    }
}

