/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.QuotePreviewInvoice;
import com.stripe.model.StripeCollection;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.QuotePreviewInvoiceListParams;

public final class QuotePreviewInvoiceService
extends ApiService {
    public QuotePreviewInvoiceService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<QuotePreviewInvoice> list(String quote, QuotePreviewInvoiceListParams params) throws StripeException {
        return this.list(quote, params, null);
    }

    public StripeCollection<QuotePreviewInvoice> list(String quote, RequestOptions options) throws StripeException {
        return this.list(quote, null, options);
    }

    public StripeCollection<QuotePreviewInvoice> list(String quote) throws StripeException {
        return this.list(quote, null, null);
    }

    public StripeCollection<QuotePreviewInvoice> list(String quote, QuotePreviewInvoiceListParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/quotes/%s/preview_invoices", ApiResource.urlEncodeId(quote));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<QuotePreviewInvoice>>(){}.getType());
    }
}

