/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.delegatedcheckout;

import com.stripe.exception.StripeException;
import com.stripe.model.delegatedcheckout.RequestedSession;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.delegatedcheckout.RequestedSessionConfirmParams;
import com.stripe.param.delegatedcheckout.RequestedSessionCreateParams;
import com.stripe.param.delegatedcheckout.RequestedSessionExpireParams;
import com.stripe.param.delegatedcheckout.RequestedSessionRetrieveParams;
import com.stripe.param.delegatedcheckout.RequestedSessionUpdateParams;
import java.lang.reflect.Type;

public final class RequestedSessionService
extends ApiService {
    public RequestedSessionService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public RequestedSession retrieve(String requestedSession, RequestedSessionRetrieveParams params) throws StripeException {
        return this.retrieve(requestedSession, params, null);
    }

    public RequestedSession retrieve(String requestedSession, RequestOptions options) throws StripeException {
        return this.retrieve(requestedSession, null, options);
    }

    public RequestedSession retrieve(String requestedSession) throws StripeException {
        return this.retrieve(requestedSession, null, null);
    }

    public RequestedSession retrieve(String requestedSession, RequestedSessionRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s", ApiResource.urlEncodeId(requestedSession));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession update(String requestedSession, RequestedSessionUpdateParams params) throws StripeException {
        return this.update(requestedSession, params, null);
    }

    public RequestedSession update(String requestedSession, RequestOptions options) throws StripeException {
        return this.update(requestedSession, null, options);
    }

    public RequestedSession update(String requestedSession) throws StripeException {
        return this.update(requestedSession, null, null);
    }

    public RequestedSession update(String requestedSession, RequestedSessionUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s", ApiResource.urlEncodeId(requestedSession));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession create(RequestedSessionCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public RequestedSession create(RequestedSessionCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/delegated_checkout/requested_sessions";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession confirm(String requestedSession, RequestedSessionConfirmParams params) throws StripeException {
        return this.confirm(requestedSession, params, null);
    }

    public RequestedSession confirm(String requestedSession, RequestOptions options) throws StripeException {
        return this.confirm(requestedSession, null, options);
    }

    public RequestedSession confirm(String requestedSession) throws StripeException {
        return this.confirm(requestedSession, null, null);
    }

    public RequestedSession confirm(String requestedSession, RequestedSessionConfirmParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s/confirm", ApiResource.urlEncodeId(requestedSession));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.request(request, (Type)((Object)RequestedSession.class));
    }

    public RequestedSession expire(String requestedSession, RequestedSessionExpireParams params) throws StripeException {
        return this.expire(requestedSession, params, null);
    }

    public RequestedSession expire(String requestedSession, RequestOptions options) throws StripeException {
        return this.expire(requestedSession, null, options);
    }

    public RequestedSession expire(String requestedSession) throws StripeException {
        return this.expire(requestedSession, null, null);
    }

    public RequestedSession expire(String requestedSession, RequestedSessionExpireParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/delegated_checkout/requested_sessions/%s/expire", ApiResource.urlEncodeId(requestedSession));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (RequestedSession)this.request(request, (Type)((Object)RequestedSession.class));
    }
}

