/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.identity;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.StripeCollection;
import com.stripe.model.identity.BlocklistEntry;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.identity.BlocklistEntryCreateParams;
import com.stripe.param.identity.BlocklistEntryDisableParams;
import com.stripe.param.identity.BlocklistEntryListParams;
import com.stripe.param.identity.BlocklistEntryRetrieveParams;
import java.lang.reflect.Type;

public final class BlocklistEntryService
extends ApiService {
    public BlocklistEntryService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<BlocklistEntry> list(BlocklistEntryListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<BlocklistEntry> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<BlocklistEntry> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<BlocklistEntry> list(BlocklistEntryListParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/blocklist_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<BlocklistEntry>>(){}.getType());
    }

    public BlocklistEntry create(BlocklistEntryCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public BlocklistEntry create(BlocklistEntryCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v1/identity/blocklist_entries";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntry)this.request(request, (Type)((Object)BlocklistEntry.class));
    }

    public BlocklistEntry retrieve(String id, BlocklistEntryRetrieveParams params) throws StripeException {
        return this.retrieve(id, params, null);
    }

    public BlocklistEntry retrieve(String id, RequestOptions options) throws StripeException {
        return this.retrieve(id, null, options);
    }

    public BlocklistEntry retrieve(String id) throws StripeException {
        return this.retrieve(id, null, null);
    }

    public BlocklistEntry retrieve(String id, BlocklistEntryRetrieveParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/blocklist_entries/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntry)this.request(request, (Type)((Object)BlocklistEntry.class));
    }

    public BlocklistEntry disable(String id, BlocklistEntryDisableParams params) throws StripeException {
        return this.disable(id, params, null);
    }

    public BlocklistEntry disable(String id, RequestOptions options) throws StripeException {
        return this.disable(id, null, options);
    }

    public BlocklistEntry disable(String id) throws StripeException {
        return this.disable(id, null, null);
    }

    public BlocklistEntry disable(String id, BlocklistEntryDisableParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v1/identity/blocklist_entries/%s/disable", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BlocklistEntry)this.request(request, (Type)((Object)BlocklistEntry.class));
    }
}

