/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.BillSetting;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.BillSettingCreateParams;
import com.stripe.param.v2.billing.BillSettingListParams;
import com.stripe.param.v2.billing.BillSettingUpdateParams;
import com.stripe.service.v2.billing.billsettings.VersionService;
import java.lang.reflect.Type;

public final class BillSettingService
extends ApiService {
    public BillSettingService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<BillSetting> list(BillSettingListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<BillSetting> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<BillSetting> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<BillSetting> list(BillSettingListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/bill_settings";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<BillSetting>>(){}.getType());
    }

    public BillSetting create(BillSettingCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public BillSetting create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public BillSetting create() throws StripeException {
        return this.create(null, null);
    }

    public BillSetting create(BillSettingCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/bill_settings";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BillSetting)this.request(request, (Type)((Object)BillSetting.class));
    }

    public BillSetting retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public BillSetting retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/bill_settings/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (BillSetting)this.request(request, (Type)((Object)BillSetting.class));
    }

    public BillSetting update(String id, BillSettingUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public BillSetting update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public BillSetting update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public BillSetting update(String id, BillSettingUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/bill_settings/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (BillSetting)this.request(request, (Type)((Object)BillSetting.class));
    }

    public VersionService versions() {
        return new VersionService(this.getResponseGetter());
    }
}

