/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.CollectionSetting;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.CollectionSettingCreateParams;
import com.stripe.param.v2.billing.CollectionSettingListParams;
import com.stripe.param.v2.billing.CollectionSettingUpdateParams;
import com.stripe.service.v2.billing.collectionsettings.VersionService;
import java.lang.reflect.Type;

public final class CollectionSettingService
extends ApiService {
    public CollectionSettingService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<CollectionSetting> list(CollectionSettingListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<CollectionSetting> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<CollectionSetting> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<CollectionSetting> list(CollectionSettingListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/collection_settings";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<CollectionSetting>>(){}.getType());
    }

    public CollectionSetting create(CollectionSettingCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public CollectionSetting create(RequestOptions options) throws StripeException {
        return this.create(null, options);
    }

    public CollectionSetting create() throws StripeException {
        return this.create(null, null);
    }

    public CollectionSetting create(CollectionSettingCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/collection_settings";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CollectionSetting)this.request(request, (Type)((Object)CollectionSetting.class));
    }

    public CollectionSetting retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public CollectionSetting retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/collection_settings/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (CollectionSetting)this.request(request, (Type)((Object)CollectionSetting.class));
    }

    public CollectionSetting update(String id, CollectionSettingUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public CollectionSetting update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public CollectionSetting update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public CollectionSetting update(String id, CollectionSettingUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/collection_settings/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (CollectionSetting)this.request(request, (Type)((Object)CollectionSetting.class));
    }

    public VersionService versions() {
        return new VersionService(this.getResponseGetter());
    }
}

