/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.Intent;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.IntentCommitParams;
import com.stripe.param.v2.billing.IntentCreateParams;
import com.stripe.param.v2.billing.IntentListParams;
import com.stripe.service.v2.billing.intents.ActionService;
import java.lang.reflect.Type;

public final class IntentService
extends ApiService {
    public IntentService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<Intent> list(IntentListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<Intent> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<Intent> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<Intent> list(IntentListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<Intent>>(){}.getType());
    }

    public Intent create(IntentCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public Intent create(IntentCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/intents";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Intent)this.request(request, (Type)((Object)Intent.class));
    }

    public Intent retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public Intent retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (Intent)this.request(request, (Type)((Object)Intent.class));
    }

    public Intent cancel(String id) throws StripeException {
        return this.cancel(id, null);
    }

    public Intent cancel(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s/cancel", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (Intent)this.request(request, (Type)((Object)Intent.class));
    }

    public Intent commit(String id, IntentCommitParams params) throws StripeException {
        return this.commit(id, params, null);
    }

    public Intent commit(String id, RequestOptions options) throws StripeException {
        return this.commit(id, null, options);
    }

    public Intent commit(String id) throws StripeException {
        return this.commit(id, null, null);
    }

    public Intent commit(String id, IntentCommitParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s/commit", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (Intent)this.request(request, (Type)((Object)Intent.class));
    }

    public Intent releaseReservation(String id) throws StripeException {
        return this.releaseReservation(id, null);
    }

    public Intent releaseReservation(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s/release_reservation", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (Intent)this.request(request, (Type)((Object)Intent.class));
    }

    public Intent reserve(String id) throws StripeException {
        return this.reserve(id, null);
    }

    public Intent reserve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/intents/%s/reserve", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, null, options);
        return (Intent)this.request(request, (Type)((Object)Intent.class));
    }

    public ActionService actions() {
        return new ActionService(this.getResponseGetter());
    }
}

