/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.LicenseFee;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.LicenseFeeCreateParams;
import com.stripe.param.v2.billing.LicenseFeeListParams;
import com.stripe.param.v2.billing.LicenseFeeUpdateParams;
import com.stripe.service.v2.billing.licensefees.VersionService;
import java.lang.reflect.Type;

public final class LicenseFeeService
extends ApiService {
    public LicenseFeeService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<LicenseFee> list(LicenseFeeListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<LicenseFee> list(LicenseFeeListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/license_fees";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<LicenseFee>>(){}.getType());
    }

    public LicenseFee create(LicenseFeeCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public LicenseFee create(LicenseFeeCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/license_fees";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (LicenseFee)this.request(request, (Type)((Object)LicenseFee.class));
    }

    public LicenseFee retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public LicenseFee retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/license_fees/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (LicenseFee)this.request(request, (Type)((Object)LicenseFee.class));
    }

    public LicenseFee update(String id, LicenseFeeUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public LicenseFee update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public LicenseFee update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public LicenseFee update(String id, LicenseFeeUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/license_fees/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (LicenseFee)this.request(request, (Type)((Object)LicenseFee.class));
    }

    public VersionService versions() {
        return new VersionService(this.getResponseGetter());
    }
}

