/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.LicensedItem;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.LicensedItemCreateParams;
import com.stripe.param.v2.billing.LicensedItemListParams;
import com.stripe.param.v2.billing.LicensedItemUpdateParams;
import java.lang.reflect.Type;

public final class LicensedItemService
extends ApiService {
    public LicensedItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<LicensedItem> list(LicensedItemListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<LicensedItem> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<LicensedItem> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<LicensedItem> list(LicensedItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/licensed_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<LicensedItem>>(){}.getType());
    }

    public LicensedItem create(LicensedItemCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public LicensedItem create(LicensedItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/licensed_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (LicensedItem)this.request(request, (Type)((Object)LicensedItem.class));
    }

    public LicensedItem retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public LicensedItem retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/licensed_items/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (LicensedItem)this.request(request, (Type)((Object)LicensedItem.class));
    }

    public LicensedItem update(String id, LicensedItemUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public LicensedItem update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public LicensedItem update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public LicensedItem update(String id, LicensedItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/licensed_items/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (LicensedItem)this.request(request, (Type)((Object)LicensedItem.class));
    }
}

