/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.MeteredItem;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.MeteredItemCreateParams;
import com.stripe.param.v2.billing.MeteredItemListParams;
import com.stripe.param.v2.billing.MeteredItemUpdateParams;
import java.lang.reflect.Type;

public final class MeteredItemService
extends ApiService {
    public MeteredItemService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<MeteredItem> list(MeteredItemListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<MeteredItem> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<MeteredItem> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<MeteredItem> list(MeteredItemListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/metered_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<MeteredItem>>(){}.getType());
    }

    public MeteredItem create(MeteredItemCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public MeteredItem create(MeteredItemCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/metered_items";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (MeteredItem)this.request(request, (Type)((Object)MeteredItem.class));
    }

    public MeteredItem retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public MeteredItem retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/metered_items/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (MeteredItem)this.request(request, (Type)((Object)MeteredItem.class));
    }

    public MeteredItem update(String id, MeteredItemUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public MeteredItem update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public MeteredItem update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public MeteredItem update(String id, MeteredItemUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/metered_items/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (MeteredItem)this.request(request, (Type)((Object)MeteredItem.class));
    }
}

