/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.service.v2.billing;

import com.google.gson.reflect.TypeToken;
import com.stripe.exception.StripeException;
import com.stripe.model.v2.StripeCollection;
import com.stripe.model.v2.billing.PricingPlan;
import com.stripe.net.ApiRequest;
import com.stripe.net.ApiRequestParams;
import com.stripe.net.ApiResource;
import com.stripe.net.ApiService;
import com.stripe.net.BaseAddress;
import com.stripe.net.RequestOptions;
import com.stripe.net.StripeResponseGetter;
import com.stripe.param.v2.billing.PricingPlanCreateParams;
import com.stripe.param.v2.billing.PricingPlanListParams;
import com.stripe.param.v2.billing.PricingPlanUpdateParams;
import com.stripe.service.v2.billing.pricingplans.ComponentService;
import com.stripe.service.v2.billing.pricingplans.VersionService;
import java.lang.reflect.Type;

public final class PricingPlanService
extends ApiService {
    public PricingPlanService(StripeResponseGetter responseGetter) {
        super(responseGetter);
    }

    public StripeCollection<PricingPlan> list(PricingPlanListParams params) throws StripeException {
        return this.list(params, null);
    }

    public StripeCollection<PricingPlan> list(RequestOptions options) throws StripeException {
        return this.list(null, options);
    }

    public StripeCollection<PricingPlan> list() throws StripeException {
        return this.list(null, null);
    }

    public StripeCollection<PricingPlan> list(PricingPlanListParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/pricing_plans";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, ApiRequestParams.paramsToMap(params), options);
        return (StripeCollection)this.request(request, new TypeToken<StripeCollection<PricingPlan>>(){}.getType());
    }

    public PricingPlan create(PricingPlanCreateParams params) throws StripeException {
        return this.create(params, null);
    }

    public PricingPlan create(PricingPlanCreateParams params, RequestOptions options) throws StripeException {
        String path = "/v2/billing/pricing_plans";
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PricingPlan)this.request(request, (Type)((Object)PricingPlan.class));
    }

    public PricingPlan retrieve(String id) throws StripeException {
        return this.retrieve(id, null);
    }

    public PricingPlan retrieve(String id, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.GET, path, null, options);
        return (PricingPlan)this.request(request, (Type)((Object)PricingPlan.class));
    }

    public PricingPlan update(String id, PricingPlanUpdateParams params) throws StripeException {
        return this.update(id, params, null);
    }

    public PricingPlan update(String id, RequestOptions options) throws StripeException {
        return this.update(id, null, options);
    }

    public PricingPlan update(String id) throws StripeException {
        return this.update(id, null, null);
    }

    public PricingPlan update(String id, PricingPlanUpdateParams params, RequestOptions options) throws StripeException {
        String path = String.format("/v2/billing/pricing_plans/%s", ApiResource.urlEncodeId(id));
        ApiRequest request = new ApiRequest(BaseAddress.API, ApiResource.RequestMethod.POST, path, ApiRequestParams.paramsToMap(params), options);
        return (PricingPlan)this.request(request, (Type)((Object)PricingPlan.class));
    }

    public ComponentService components() {
        return new ComponentService(this.getResponseGetter());
    }

    public VersionService versions() {
        return new VersionService(this.getResponseGetter());
    }
}

